!!!!!!!!!!        PHI: ang_mom.f90                                                            !!!!!!!!!!
!!!!!!!!!!        Nicholas F. Chilton     							                          !!!!!!!!!!
!!!!!!!!!!        email: nfchilton@gmail.com                                                  !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        This file is part of PHI.                                                   !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is free software: you can redistribute it and/or modify                 !!!!!!!!!!
!!!!!!!!!!        it under the terms of the GNU General Public License as published by        !!!!!!!!!!
!!!!!!!!!!        the Free Software Foundation, either version 3 of the License, or           !!!!!!!!!!
!!!!!!!!!!        (at your option) any later version.                                         !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is distributed in the hope that it will be useful,                      !!!!!!!!!!
!!!!!!!!!!        but WITHOUT ANY WARRANTY; without even the implied warranty of              !!!!!!!!!!
!!!!!!!!!!        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               !!!!!!!!!!
!!!!!!!!!!        GNU General Public License for more details.                                !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        You should have received a copy of the GNU General Public License           !!!!!!!!!!
!!!!!!!!!!        along with PHI. If not, see <http://www.gnu.org/licenses/>.                 !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        We request that any results obtained through the use of PHI                 !!!!!!!!!!
!!!!!!!!!!        are accompanied by the following reference:                                 !!!!!!!!!!
!!!!!!!!!!        N. F. Chilton, R. P. Anderson, L. D. Turner, A. Soncini and                 !!!!!!!!!!
!!!!!!!!!!        K. S. Murray, J. Comput. Chem., 2013, 34, 1164 - 1175                       !!!!!!!!!!

module ang_mom
	use data
	implicit none

	contains
	
	subroutine set_totaldim
	! Sets maxSnum, maxLnum and totaldim
	implicit none
	integer::j
	real(kind=8)::check
	integer::min_mem
	if(return_all) then
		!write(6,*) "S"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*S"
	end if
	maxSnum = 0
	maxLnum = 0
	do j=1,N
		if(twoS(j) /= 0) then
			maxSnum = maxSnum + 1
		end if
	end do
	do j=1,N
		if(twoL(j) /= 0) then
			maxLnum = maxLnum + 1
		end if
	end do
	totaldim = 1
	check = 1.0_8
	do j=1,N
		totaldim = totaldim*(twoS(j)+1)*(twoL(j)+1)
		check = check*dble(twoS(j)+1)*dble(twoL(j)+1)
	end do
	if(check >= integer_limit) then
		call output_text("Dimensionality of problem exceeds hardware limit",.false.)
		call output_text("You may require 64-bit integers",.false.)
		call control('kill ')
		return
	end if
	if(mpi_rank == 0) then
		call output_text("- - - - - - - - - - ",.false.)
		call output_text("    Spin System     ",.false.)
		call output_text(" N |  Spin  | Orbit ",.false.)
		call output_text("- - - - - - - - - - ",.false.)
		do j=1,N
			SaveTxt = ""
			write(SaveTxt,'(I2,A3,F6.1,A3,F6.1)') j," | ",dble(twoS(j))*0.5_8," | ",dble(twoL(j))*0.5_8
			call output_text(SaveTxt,.false.)
		end do
		call output_text("- - - - - - - - - - ",.false.)
		SaveTxt = ""
		write(SaveTxt,'(A6,I10)') " Dim: ",totaldim
		call output_text(SaveTxt,.false.)
		if(aniso == 0) min_mem = nint(totaldim*totaldim*8.0_8/(1024.0_8*1024.0_8))
		if(aniso == 1) min_mem = nint(totaldim*totaldim*16.0_8/(1024.0_8*1024.0_8))
		if(min_mem < 1) min_mem = 1
		if(approx == 0 .and. OperationMode(1:3) /= 'cou') then
			SaveTxt = ""
			write(SaveTxt,'(A11,I5)') " RAM (MB): ",min_mem
			call output_text(SaveTxt,.false.)
			call output_text("- - - - - - - - - - ",.false.)
		end if
	end if
	if(given_multiplicities == 0 .and. approx == 0) then
		g_numCalc = totaldim
		allocate(GtenDegen(g_numCalc),g_calc(3,g_numCalc),gdir_calc(3,3,g_numCalc))
	end if
	end subroutine set_totaldim
	
	recursive subroutine matrix_elements(RI,UA,matrixR,matrixI,in_B,in_lamda,in_orbred,in_EXmat,in_Gmat,in_A2,in_A4,in_A6,do_soc,do_ex,do_zee,do_cf,do_ored_strain)
	! Calculates matrix elements
	! k is column loop (basis2)
	! j is row loop (basis1)
	! primary_matrix(j,k) = <basis2|H|basis1>
	!			 | <basis2|  <basis2|  <basis2|
	!		  ___|_____________________________
	!	|basis1> |
	!	|basis1> |
	!	|basis1> |
	implicit none
	character(len=1)::RI,UA
	real(kind=8)::matrixR(:,:)
	complex(kind=8)::matrixI(:,:)
	real(kind=8)::in_B(:),in_lamda(:,:),in_orbred(:),in_EXmat(:,:,:,:),in_Gmat(:,:,:),in_A2(:,-2:),in_A4(:,-4:),in_A6(:,-6:)
	real(kind=8)::false_orbred(1:size(in_orbred))
	real(kind=8)::SOcomp,SO2comp,SO3comp,SO4comp,SO5comp,SO6comp,HDVVcompR,ZeeScompR,ZeeLcompR,tempXA,tempZA,tempXB,tempZB,tempLXA,tempLZA,tempLXB,tempLZB
	complex(kind=8)::HDVVcomp,ZeeScomp,ZeeLcomp,LFcomp,tempYA,tempYB,tempLYB,tempLYA
	integer::j,k,ex,m,h,r,FLocS,FLocL,FlocSa,FLocSb,FLocLa,FLocLb
	integer,allocatable::basis1(:),basis2(:)
	logical::do_soc,do_ex,do_zee,do_cf,do_ored_strain
	if(return_all) then
		!write(6,*) "T"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*T"
	end if
	matrixR = 0.0_8
	matrixI = (0.0_8,0.0_8)
	allocate(basis1(maxSnum+maxLnum),basis2(maxSnum+maxLnum))
	
	false_orbred = in_orbred
	if(ored_only_zeeman) then
		false_orbred = 1.0_8
	end if
	
	!write(6,*) in_EXmat(1,1,1,2),in_EXmat(1,2,1,2),in_EXmat(1,3,1,2)
	!write(6,*) in_EXmat(2,1,1,2),in_EXmat(2,2,1,2),in_EXmat(2,3,1,2)
	!write(6,*) in_EXmat(3,1,1,2),in_EXmat(3,2,1,2),in_EXmat(3,3,1,2)
	!write(6,*) '----'
	
	do k=1,totaldim
		if(return_all) return
		if(UA == 'U') then
			ex = k
		else
			ex = totaldim
		end if
		basis2(:) = basis_lookup(k,:)
		do j=1,ex
			if(return_all) return
			basis1(:) = basis_lookup(j,:)
			if(do_soc) then
				!Spin Orbit Coupling*************************************************************************
				SOcomp = 0.0_8
				SO2comp = 0.0_8
				SO3comp = 0.0_8
				SO4comp = 0.0_8
				SO5comp = 0.0_8
				SO6comp = 0.0_8
				do m=1,N
					if((twoS(m) /= 0) .and. (twoL(m) /= 0)) then
						do h=1,maxSnum
							if(LocS(h) /= m .and. basis1(h) /= basis2(h)) goto 18
						end do
						do h=1,maxLnum
							if(LocL(h) /= m .and. basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 18
						end do
						do h=1,maxSnum
							if(LocS(h) == m) then
								FLocS = h
								exit
							end if
						end do
						do h=1,maxLnum
							if(LocL(h) == m) then
								FLocL = h
								exit
							end if
						end do
						if(in_lamda(m,1) /= 0.0_8) SOcomp = SOcomp + in_lamda(m,1)*SO1(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)
						if(in_lamda(m,2) /= 0.0_8) SO2comp = SO2comp + in_lamda(m,2)*SO2(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)
						if(in_lamda(m,3) /= 0.0_8) SO3comp = SO3comp + in_lamda(m,3)*SO3(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)*false_orbred(m)
						if(in_lamda(m,4) /= 0.0_8) SO4comp = SO4comp + in_lamda(m,4)*SO4(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)
						if(in_lamda(m,5) /= 0.0_8) SO5comp = SO5comp + in_lamda(m,5)*SO5(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)
						if(in_lamda(m,6) /= 0.0_8) SO6comp = SO6comp + in_lamda(m,6)*SO6(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)
18						continue
					end if
				end do
				if(RI == 'I') matrixI(j,k) = matrixI(j,k) + EnergyConvert*(SOcomp + SO2comp + SO3comp + SO4comp + SO5comp + SO6comp)
				if(RI == 'R') matrixR(j,k) = matrixR(j,k) + EnergyConvert*(SOcomp + SO2comp + SO3comp + SO4comp + SO5comp + SO6comp)
				!write(6,*) 'SO',EnergyConvert*(SOcomp + SO2comp + SO3comp + SO4comp + SO5comp + SO6comp)
				!***********************************************************************************************
			end if
			
			if(do_ex) then
				!HDVV Exchange**********************************************************************************
				HDVVcomp = (0.0_8,0.0_8)
				HDVVcompR = 0.0_8
				if(maxSnum > 1 .or. maxLnum > 1) then
					!do m=1,N-1
						!do h=m+1,N
					do m = 1,N
						do h = 1,N
							if(m /= h .and. (use_interaction_matrix .or. (.not. use_interaction_matrix .and. m < N .and. h > m))) then
								if(in_EXmat(1,1,m,h) /= 0.0_8 .or. in_EXmat(1,2,m,h) /= 0.0_8 .or. in_EXmat(1,3,m,h) /= 0.0_8 .or. in_EXmat(2,1,m,h) /= 0.0_8 .or. in_EXmat(2,2,m,h) /= 0.0_8 .or. in_EXmat(2,3,m,h) /= 0.0_8 .or. in_EXmat(3,1,m,h) /= 0.0_8 .or. in_EXmat(3,2,m,h) /= 0.0_8 .or. in_EXmat(3,3,m,h) /= 0.0_8) then
									do r=1,maxSnum
										if(LocS(r) == m) then
											FLocSa = r
											exit
										end if
									end do
									do r=1,maxSnum
										if(LocS(r) == h) then
											FLocSb = r
											exit
										end if
									end do
									if(maxSnum > 2) then
										do r=1,FLocSa-1
											if(basis1(r) /= basis2(r)) goto 17
										end do
										do r=FLocSa+1,FLocSb-1
											if(basis1(r) /= basis2(r)) goto 17
										end do
										do r=FLocSb+1,maxSnum
											if(basis1(r) /= basis2(r)) goto 17
										end do
									end if
									if(JJ_not_SS(m,h) == 0 .or. (twoL(m) == 0 .and. twoL(h) == 0)) then
										if(maxLnum /= 0) then
											do r=1,maxLnum
												if(basis1(maxSnum+r) /= basis2(maxSnum+r)) goto 17
											end do
										end if
										if(RI == 'I') then
											tempXA = Sx(FlocSa,1,basis1,basis2)
											tempYA = Sy(FlocSa,1,basis1,basis2)
											tempZA = Szed(FlocSa,1,basis1,basis2)
											tempXB = Sx(FlocSb,1,basis1,basis2)
											tempYB = Sy(FlocSb,1,basis1,basis2)
											tempZB = Szed(FlocSb,1,basis1,basis2)
											if(in_EXmat(1,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXA*tempXB*in_EXmat(1,1,LocS(m),LocS(h))
											if(in_EXmat(1,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXA*tempYB*in_EXmat(1,2,LocS(m),LocS(h))
											if(in_EXmat(1,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXA*tempZB*in_EXmat(1,3,LocS(m),LocS(h))
											if(in_EXmat(2,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYA*tempXB*in_EXmat(2,1,LocS(m),LocS(h))
											if(in_EXmat(2,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYA*tempYB*in_EXmat(2,2,LocS(m),LocS(h))
											if(in_EXmat(2,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYA*tempZB*in_EXmat(2,3,LocS(m),LocS(h))
											if(in_EXmat(3,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZA*tempXB*in_EXmat(3,1,LocS(m),LocS(h))
											if(in_EXmat(3,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZA*tempYB*in_EXmat(3,2,LocS(m),LocS(h))
											if(in_EXmat(3,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZA*tempZB*in_EXmat(3,3,LocS(m),LocS(h))
											!HDVVcomp = HDVVcomp + (Sx(FlocSb,1,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Sy(FlocSb,1,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Szed(FlocSb,1,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)))	!(0.5_8*(Splus(FLocSb,1,basis1,basis2)+Sminus(FLocSb,1,basis1,basis2))*(in_EXmat(1,1,LocS(m),LocS(h))*0.5_8*(Splus(FLocSa,1,basis1,basis2)+Sminus(FLocSa,1,basis1,basis2)) + in_EXmat(2,1,LocS(m),LocS(h))*0.5_8*(0.0_8,-1.0_8)*(Splus(FLocSa,1,basis1,basis2)-Sminus(FLocSa,1,basis1,basis2)) + in_EXmat(3,1,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + 0.5_8*(0.0_8,-1.0_8)*(Splus(FLocSb,1,basis1,basis2)-Sminus(FLocSb,1,basis1,basis2))*(in_EXmat(1,2,LocS(m),LocS(h))*0.5_8*(Splus(FLocSa,1,basis1,basis2)+Sminus(FLocSa,1,basis1,basis2)) + in_EXmat(2,2,LocS(m),LocS(h))*0.5_8*(0.0_8,-1.0_8)*(Splus(FLocSa,1,basis1,basis2)-Sminus(FLocSa,1,basis1,basis2)) + in_EXmat(3,2,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Szed(FlocSb,1,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*0.5_8*(Splus(FLocSa,1,basis1,basis2)+Sminus(FLocSa,1,basis1,basis2)) + in_EXmat(2,3,LocS(m),LocS(h))*0.5_8*(0.0_8,-1.0_8)*(Splus(FLocSa,1,basis1,basis2)-Sminus(FLocSa,1,basis1,basis2)) + in_EXmat(3,3,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)))
										else if(RI == 'R') then
											if(in_EXmat(1,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcompR = HDVVcompR + in_EXmat(1,1,LocS(m),LocS(h))*(Sx(FlocSa,1,basis1,basis2)*Sx(FlocSb,1,basis1,basis2)+Sy(FlocSa,1,basis1,basis2)*Sy(FlocSb,1,basis1,basis2)+Szed(FLocSa,1,basis1,basis2)*Szed(FLocSb,1,basis1,basis2))		!(0.5_8*(Splus(FLocSa,1,basis1,basis2)*Sminus(FLocSb,1,basis1,basis2)+Sminus(FLocSa,1,basis1,basis2)*Splus(FLocSb,1,basis1,basis2))+Szed(FLocSa,1,basis1,basis2)*Szed(FLocSb,1,basis1,basis2))
										end if
									else
										if(twoL(m) == 0 .and. twoL(h) /= 0) then
											do r=1,maxLnum
												if(LocL(r) == h) then
													FLocLb = r
													exit
												end if
											end do
											if(maxLnum > 1) then
												do r=maxSnum+1,maxSnum+FLocLb-1
													if(basis1(r) /= basis2(r)) goto 17
												end do
												do r=maxSnum+FLocLb+1,maxSnum+maxLnum
													if(basis1(r) /= basis2(r)) goto 17
												end do
											end if
											if(RI == 'I') then
												tempXA = Sx(FlocSa,1,basis1,basis2)
												tempYA = Sy(FlocSa,1,basis1,basis2)
												tempZA = Szed(FlocSa,1,basis1,basis2)
												tempXB = Sx(FlocSb,1,basis1,basis2)
												tempYB = Sy(FlocSb,1,basis1,basis2)
												tempZB = Szed(FlocSb,1,basis1,basis2)
												tempLXB = Lx(FlocLb,basis1,basis2)*false_orbred(LocS(h))
												tempLYB = Ly(FlocLb,basis1,basis2)*false_orbred(LocS(h))
												tempLZB = Lzed(FlocLb,basis1,basis2)*false_orbred(LocS(h))
												if(in_EXmat(1,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXA*(tempXB + tempLXB)*in_EXmat(1,1,LocS(m),LocS(h))
												if(in_EXmat(1,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXA*(tempYB + tempLYB)*in_EXmat(1,2,LocS(m),LocS(h))
												if(in_EXmat(1,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXA*(tempZB + tempLZB)*in_EXmat(1,3,LocS(m),LocS(h))
												if(in_EXmat(2,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYA*(tempXB + tempLXB)*in_EXmat(2,1,LocS(m),LocS(h))
												if(in_EXmat(2,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYA*(tempYB + tempLYB)*in_EXmat(2,2,LocS(m),LocS(h))
												if(in_EXmat(2,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYA*(tempZB + tempLZB)*in_EXmat(2,3,LocS(m),LocS(h))
												if(in_EXmat(3,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZA*(tempXB + tempLXB)*in_EXmat(3,1,LocS(m),LocS(h))
												if(in_EXmat(3,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZA*(tempYB + tempLYB)*in_EXmat(3,2,LocS(m),LocS(h))
												if(in_EXmat(3,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZA*(tempZB + tempLZB)*in_EXmat(3,3,LocS(m),LocS(h))
												!HDVVcomp = HDVVcomp + ((Sx(FlocSb,1,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Sy(FlocSb,1,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Szed(FlocSb,1,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2))) + (Lx(FlocLb,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Ly(FlocLb,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Lzed(FlocLb,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2))))
											else if(RI == 'R') then
												if(in_EXmat(1,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcompR = HDVVcompR + in_EXmat(1,1,LocS(m),LocS(h))*(Sx(FlocSa,1,basis1,basis2)*Sx(FlocSb,1,basis1,basis2)+Sy(FlocSa,1,basis1,basis2)*Sy(FlocSb,1,basis1,basis2)+Szed(FLocSa,1,basis1,basis2)*Szed(FLocSb,1,basis1,basis2) + Sx(FlocSa,1,basis1,basis2)*Lx(FlocLb,basis1,basis2)+Sy(FlocSa,1,basis1,basis2)*Ly(FlocLb,basis1,basis2)+Szed(FLocSa,1,basis1,basis2)*Lzed(FLocLb,basis1,basis2))
											end if
										else if(twoL(m) /= 0 .and. twoL(h) == 0) then
											do r=1,maxLnum
												if(LocL(r) == m) then
													FLocLa = r
													exit
												end if
											end do
											if(maxLnum > 1) then
												do r=maxSnum+1,maxSnum+FLocLa-1
													if(basis1(r) /= basis2(r)) goto 17
												end do
												do r=maxSnum+FLocLa+1,maxSnum+maxLnum
													if(basis1(r) /= basis2(r)) goto 17
												end do
											end if
											if(RI == 'I') then
												tempXA = Sx(FlocSa,1,basis1,basis2)
												tempYA = Sy(FlocSa,1,basis1,basis2)
												tempZA = Szed(FlocSa,1,basis1,basis2)
												tempXB = Sx(FlocSb,1,basis1,basis2)
												tempYB = Sy(FlocSb,1,basis1,basis2)
												tempZB = Szed(FlocSb,1,basis1,basis2)
												tempLXA = Lx(FlocLa,basis1,basis2)*false_orbred(LocS(m))
												tempLYA = Ly(FlocLa,basis1,basis2)*false_orbred(LocS(m))
												tempLZA = Lzed(FlocLa,basis1,basis2)*false_orbred(LocS(m))
												if(in_EXmat(1,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXB*(tempXA + tempLXA)*in_EXmat(1,1,LocS(m),LocS(h))
												if(in_EXmat(1,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYB*(tempXA + tempLXA)*in_EXmat(1,2,LocS(m),LocS(h))
												if(in_EXmat(1,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZB*(tempXA + tempLXA)*in_EXmat(1,3,LocS(m),LocS(h))
												if(in_EXmat(2,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXB*(tempYA + tempLYA)*in_EXmat(2,1,LocS(m),LocS(h))
												if(in_EXmat(2,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYB*(tempYA + tempLYA)*in_EXmat(2,2,LocS(m),LocS(h))
												if(in_EXmat(2,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZB*(tempYA + tempLYA)*in_EXmat(2,3,LocS(m),LocS(h))
												if(in_EXmat(3,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempXB*(tempZA + tempLZA)*in_EXmat(3,1,LocS(m),LocS(h))
												if(in_EXmat(3,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempYB*(tempZA + tempLZA)*in_EXmat(3,2,LocS(m),LocS(h))
												if(in_EXmat(3,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + tempZB*(tempZA + tempLZA)*in_EXmat(3,3,LocS(m),LocS(h))
												!HDVVcomp = HDVVcomp + ((Sx(FlocSb,1,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Sy(FlocSb,1,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Szed(FlocSb,1,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)))+(Sx(FlocSb,1,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2)) + Sy(FlocSb,1,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2)) + Szed(FlocSb,1,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2))))
											else if(RI == 'R') then
												if(in_EXmat(1,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcompR = HDVVcompR + in_EXmat(1,1,LocS(m),LocS(h))*(Sx(FlocSa,1,basis1,basis2)*Sx(FlocSb,1,basis1,basis2)+Sy(FlocSa,1,basis1,basis2)*Sy(FlocSb,1,basis1,basis2)+Szed(FLocSa,1,basis1,basis2)*Szed(FLocSb,1,basis1,basis2) + Lx(FlocLa,basis1,basis2)*Sx(FlocSb,1,basis1,basis2)+Ly(FlocLa,basis1,basis2)*Sy(FlocSb,1,basis1,basis2)+Lzed(FLocLa,basis1,basis2)*Szed(FLocSb,1,basis1,basis2))
											end if
										else if(twoL(m) /= 0 .and. twoL(h) /= 0) then
											do r=1,maxLnum
												if(LocL(r) == m) then
													FLocLa = r
													exit
												end if
											end do
											do r=1,maxLnum
												if(LocL(r) == h) then
													FLocLb = r
													exit
												end if
											end do
											if(maxLnum > 2) then
												do r=maxSnum+1,maxSnum+FLocLa-1
													if(basis1(r) /= basis2(r)) goto 17
												end do
												do r=maxSnum+FLocLa+1,maxSnum+FLocLb-1
													if(basis1(r) /= basis2(r)) goto 17
												end do
												do r=maxSnum+FLocLb+1,maxSnum+maxLnum
													if(basis1(r) /= basis2(r)) goto 17
												end do
											end if
											if(RI == 'I') then
												tempXA = Sx(FlocSa,1,basis1,basis2)
												tempYA = Sy(FlocSa,1,basis1,basis2)
												tempZA = Szed(FlocSa,1,basis1,basis2)
												tempXB = Sx(FlocSb,1,basis1,basis2)
												tempYB = Sy(FlocSb,1,basis1,basis2)
												tempZB = Szed(FlocSb,1,basis1,basis2)
												tempLXA = Lx(FlocLa,basis1,basis2)*false_orbred(LocS(m))
												tempLYA = Ly(FlocLa,basis1,basis2)*false_orbred(LocS(m))
												tempLZA = Lzed(FlocLa,basis1,basis2)*false_orbred(LocS(m))
												tempLXB = Lx(FlocLb,basis1,basis2)*false_orbred(LocS(h))
												tempLYB = Ly(FlocLb,basis1,basis2)*false_orbred(LocS(h))
												tempLZB = Lzed(FlocLb,basis1,basis2)*false_orbred(LocS(h))
												if(in_EXmat(1,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempXB + tempLXB)*(tempXA + tempLXA)*in_EXmat(1,1,LocS(m),LocS(h))
												if(in_EXmat(1,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempYB + tempLYB)*(tempXA + tempLXA)*in_EXmat(1,2,LocS(m),LocS(h))
												if(in_EXmat(1,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempZB + tempLZB)*(tempXA + tempLXA)*in_EXmat(1,3,LocS(m),LocS(h))
												if(in_EXmat(2,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempXB + tempLXB)*(tempYA + tempLYA)*in_EXmat(2,1,LocS(m),LocS(h))
												if(in_EXmat(2,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempYB + tempLYB)*(tempYA + tempLYA)*in_EXmat(2,2,LocS(m),LocS(h))
												if(in_EXmat(2,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempZB + tempLZB)*(tempYA + tempLYA)*in_EXmat(2,3,LocS(m),LocS(h))
												if(in_EXmat(3,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempXB + tempLXB)*(tempZA + tempLZA)*in_EXmat(3,1,LocS(m),LocS(h))
												if(in_EXmat(3,2,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempYB + tempLYB)*(tempZA + tempLZA)*in_EXmat(3,2,LocS(m),LocS(h))
												if(in_EXmat(3,3,LocS(m),LocS(h)) /= 0.0_8) HDVVcomp = HDVVcomp + (tempZB + tempLZB)*(tempZA + tempLZA)*in_EXmat(3,3,LocS(m),LocS(h))
												!HDVVcomp = HDVVcomp + ((Sx(FlocSb,1,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Sy(FlocSb,1,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Szed(FlocSb,1,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2))) + (Lx(FlocLb,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Ly(FlocLb,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2)) + Lzed(FlocLb,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Sx(FLocSa,1,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Sy(FLocSa,1,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Szed(FlocSa,1,basis1,basis2))) + (Sx(FlocSb,1,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2)) + Sy(FlocSb,1,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2)) + Szed(FlocSb,1,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2))) + (Lx(FlocLb,basis1,basis2)*(in_EXmat(1,1,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,1,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,1,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2)) + Ly(FlocLb,basis1,basis2)*(in_EXmat(1,2,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,2,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,2,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2)) + Lzed(FlocLb,basis1,basis2)*(in_EXmat(1,3,LocS(m),LocS(h))*Lx(FLocLa,basis1,basis2) + in_EXmat(2,3,LocS(m),LocS(h))*Ly(FLocLa,basis1,basis2) + in_EXmat(3,3,LocS(m),LocS(h))*Lzed(FlocLa,basis1,basis2))))
											else if(RI == 'R') then
												if(in_EXmat(1,1,LocS(m),LocS(h)) /= 0.0_8) HDVVcompR = HDVVcompR + in_EXmat(1,1,LocS(m),LocS(h))*(Sx(FlocSa,1,basis1,basis2)*Sx(FlocSb,1,basis1,basis2)+Sy(FlocSa,1,basis1,basis2)*Sy(FlocSb,1,basis1,basis2)+Szed(FLocSa,1,basis1,basis2)*Szed(FLocSb,1,basis1,basis2) + Sx(FlocSa,1,basis1,basis2)*Lx(FlocLb,basis1,basis2)+Sy(FlocSa,1,basis1,basis2)*Ly(FlocLb,basis1,basis2)+Szed(FLocSa,1,basis1,basis2)*Lzed(FLocLb,basis1,basis2) + Lx(FlocLa,basis1,basis2)*Sx(FlocSb,1,basis1,basis2)+Ly(FlocLa,basis1,basis2)*Sy(FlocSb,1,basis1,basis2)+Lzed(FLocLa,basis1,basis2)*Szed(FLocSb,1,basis1,basis2) + Lx(FlocLa,basis1,basis2)*Lx(FlocLb,basis1,basis2)+Ly(FlocLa,basis1,basis2)*Ly(FlocLb,basis1,basis2)+Lzed(FLocLa,basis1,basis2)*Lzed(FLocLb,basis1,basis2))
											end if
										end if
									end if
	17								continue
								end if
							end if
						end do
					end do
					if(RI == 'I') matrixI(j,k) = matrixI(j,k) + (-2.0_8*EnergyConvert)*HDVVcomp
					if(RI == 'R') matrixR(j,k) = matrixR(j,k) + (-2.0_8*EnergyConvert)*HDVVcompR
					!write(6,*) 'EX',(-2.0_8*EnergyConvert)*HDVVcomp
				end if
				!************************************************************************************************
			end if
			
			if(do_zee) then
				!Zeeman Spin term********************************************************************************
				ZeeScomp = (0.0_8,0.0_8)
				ZeeScompR = 0.0_8
				if(maxSnum /= 0) then
					do m=1,maxSnum
						if(maxSnum > 1) then
							do h=1,m-1
								if(basis1(h) /= basis2(h)) goto 19
							end do
							do h=m+1,maxSnum
								if(basis1(h) /= basis2(h)) goto 19
							end do
						end if
						if(maxLnum /= 0) then
							do r=1,maxLnum
								if(basis1(maxSnum+r) /= basis2(maxSnum+r)) goto 19
							end do
						end if
						if(RI == 'I') then
							tempXA = Sx(m,0,basis1,basis2)
							tempYA = Sy(m,0,basis1,basis2)
							tempZA = Szed(m,0,basis1,basis2)
							if(in_Gmat(1,1,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempXA*in_B(1)*in_Gmat(1,1,LocS(m))
							if(in_Gmat(1,2,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempXA*in_B(2)*in_Gmat(1,2,LocS(m))
							if(in_Gmat(1,3,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempXA*in_B(3)*in_Gmat(1,3,LocS(m))
							if(in_Gmat(2,1,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempYA*in_B(1)*in_Gmat(2,1,LocS(m))
							if(in_Gmat(2,2,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempYA*in_B(2)*in_Gmat(2,2,LocS(m))
							if(in_Gmat(2,3,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempYA*in_B(3)*in_Gmat(2,3,LocS(m))
							if(in_Gmat(3,1,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempZA*in_B(1)*in_Gmat(3,1,LocS(m))
							if(in_Gmat(3,2,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempZA*in_B(2)*in_Gmat(3,2,LocS(m))
							if(in_Gmat(3,3,LocS(m)) /= 0.0_8) ZeeScomp = ZeeScomp + tempZA*in_B(3)*in_Gmat(3,3,LocS(m))
							!ZeeScomp = ZeeScomp + (in_B(1)*(in_Gmat(1,1,LocS(m))*Sx(m,0,basis1,basis2)+in_Gmat(2,1,LocS(m))*Sy(m,0,basis1,basis2)+in_Gmat(3,1,LocS(m))*Szed(m,0,basis1,basis2))+ in_B(2)*(in_Gmat(1,2,LocS(m))*Sx(m,0,basis1,basis2)+in_Gmat(2,2,LocS(m))*Sy(m,0,basis1,basis2)+in_Gmat(3,2,LocS(m))*Szed(m,0,basis1,basis2)) + in_B(3)*(in_Gmat(1,3,LocS(m))*Sx(m,0,basis1,basis2)+in_Gmat(2,3,LocS(m))*Sy(m,0,basis1,basis2)+in_Gmat(3,3,LocS(m))*Szed(m,0,basis1,basis2)))
						else if(RI == 'R') then
							ZeeScompR = ZeeScompR + in_Gmat(3,3,LocS(m))*Szed(m,0,basis1,basis2)*in_B(3)
						end if
19						continue
					end do
					if(RI == 'I') matrixI(j,k) = matrixI(j,k) + beta*ZeeScomp
					if(RI == 'R') matrixR(j,k) = matrixR(j,k) + beta*ZeeScompR
					!write(6,*) 'ZS',beta*ZeeScomp
				end if
				!************************************************************************************************

				!Zeeman Orbital term*****************************************************************************
				ZeeLcomp = (0.0_8,0.0_8)
				ZeeLcompR = 0.0_8
				if(maxLnum /= 0 ) then
					do m=1,maxLnum
						if(maxLnum > 1) then
							do h=1,m-1
								if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 20
							end do
							do h=m+1,maxLnum
								if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 20
							end do
						end if
						if(maxSnum /= 0) then
							do r=1,maxSnum
								if(basis1(r) /= basis2(r)) goto 20
							end do
						end if
						if(RI == 'I') ZeeLcomp = ZeeLcomp + in_orbred(LocL(m))*(in_B(1)*Lx(m,basis1,basis2) + in_B(2)*Ly(m,basis1,basis2) + Lzed(m,basis1,basis2)*in_B(3))
						if(RI == 'R') ZeeLcompR = ZeeLcompR + in_orbred(LocL(m))*Lzed(m,basis1,basis2)*in_B(3)
20						continue
					end do
					if(RI == 'I') matrixI(j,k) = matrixI(j,k) + beta*ZeeLcomp
					if(RI == 'R') matrixR(j,k) = matrixR(j,k) + beta*ZeeLcompR
					!write(6,*) 'ZL',beta*ZeeLcomp
				end if
				!************************************************************************************************
			end if

			if(do_cf) then
				!J Crystal Field Term*******************************************************************************
				LFcomp = (0.0_8,0.0_8)
				do m=1,N
					if(MetalType(m) == 2) then
						do h=1,maxSnum
							if(LocS(h) /= m) then
								if(basis1(h) /= basis2(h)) goto 21
							end if
						end do
						do h=1,maxLnum
							if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 21
						end do
						do h=1,maxSnum
							if(LocS(h) == m) then
								FLocS = h
								exit
							end if
						end do
						if(in_A2(m,0) /= 0.0_8) LFcomp = LFcomp + in_A2(m,0)*O20(m,basis1,basis2,FLocL,FLocS)
						if(in_A2(m,1) /= 0.0_8) LFcomp = LFcomp + in_A2(m,1)*O21(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A2(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A2(m,-1)*O21(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A2(m,2) /= 0.0_8) LFcomp = LFcomp + in_A2(m,2)*O22(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A2(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A2(m,-2)*O22(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A4(m,0) /= 0.0_8) LFcomp = LFcomp + in_A4(m,0)*O40(m,basis1,basis2,FLocL,FLocS)
						if(in_A4(m,1) /= 0.0_8) LFcomp = LFcomp + in_A4(m,1)*O41(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A4(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-1)*O41(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A4(m,2) /= 0.0_8) LFcomp = LFcomp + in_A4(m,2)*O42(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A4(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-2)*O42(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A4(m,3) /= 0.0_8) LFcomp = LFcomp + in_A4(m,3)*O43(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A4(m,-3) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-3)*O43(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A4(m,4) /= 0.0_8) LFcomp = LFcomp + in_A4(m,4)*O44(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A4(m,-4) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-4)*O44(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,0) /= 0.0_8) LFcomp = LFcomp + in_A6(m,0)*O60(m,basis1,basis2,FLocL,FLocS)
						if(in_A6(m,1) /= 0.0_8) LFcomp = LFcomp + in_A6(m,1)*O61(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-1)*O61(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,2) /= 0.0_8) LFcomp = LFcomp + in_A6(m,2)*O62(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-2)*O62(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,3) /= 0.0_8) LFcomp = LFcomp + in_A6(m,3)*O63(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,-3) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-3)*O63(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,4) /= 0.0_8) LFcomp = LFcomp + in_A6(m,4)*O64(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,-4) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-4)*O64(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,5) /= 0.0_8) LFcomp = LFcomp + in_A6(m,5)*O65(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,-5) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-5)*O65(m,'m',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,6) /= 0.0_8) LFcomp = LFcomp + in_A6(m,6)*O66(m,'p',basis1,basis2,FLocL,FLocS)
						if(in_A6(m,-6) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-6)*O66(m,'m',basis1,basis2,FLocL,FLocS)
21						continue
					end if
				end do
				if(RI == 'I') matrixI(j,k) = matrixI(j,k) + EnergyConvert*LFcomp
				!write(6,*) 'CJ',EnergyConvert*LFcomp
				!************************************************************************************************

				!L+S/L Crystal Field Term*************************************************************************
				LFcomp = (0.0_8,0.0_8)
				do m=1,N
					if(MetalType(m) == 1) then
						do h=1,maxLnum
							if(LocL(h) /= m) then
								if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 22
							end if
						end do
						do h=1,maxSnum
							if(basis1(h) /= basis2(h)) goto 22
						end do
						do h=1,maxLnum
							if(LocL(h) == m) then
								FLocL = h
								exit
							end if
						end do
						if(in_A2(m,0) /= 0.0_8) LFcomp = LFcomp + in_A2(m,0)*O20(m,basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m))
						if(in_A2(m,1) /= 0.0_8) LFcomp = LFcomp + in_A2(m,1)*O21(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m))
						if(in_A2(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A2(m,-1)*O21(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m))
						if(in_A2(m,2) /= 0.0_8) LFcomp = LFcomp + in_A2(m,2)*O22(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m))
						if(in_A2(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A2(m,-2)*O22(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m))
						if(in_A4(m,0) /= 0.0_8) LFcomp = LFcomp + in_A4(m,0)*O40(m,basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A4(m,1) /= 0.0_8) LFcomp = LFcomp + in_A4(m,1)*O41(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A4(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-1)*O41(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A4(m,2) /= 0.0_8) LFcomp = LFcomp + in_A4(m,2)*O42(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A4(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-2)*O42(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A4(m,3) /= 0.0_8) LFcomp = LFcomp + in_A4(m,3)*O43(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A4(m,-3) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-3)*O43(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A4(m,4) /= 0.0_8) LFcomp = LFcomp + in_A4(m,4)*O44(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A4(m,-4) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-4)*O44(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,0) /= 0.0_8) LFcomp = LFcomp + in_A6(m,0)*O60(m,basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,1) /= 0.0_8) LFcomp = LFcomp + in_A6(m,1)*O61(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-1)*O61(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,2) /= 0.0_8) LFcomp = LFcomp + in_A6(m,2)*O62(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-2)*O62(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,3) /= 0.0_8) LFcomp = LFcomp + in_A6(m,3)*O63(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,-3) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-3)*O63(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,4) /= 0.0_8) LFcomp = LFcomp + in_A6(m,4)*O64(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,-4) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-4)*O64(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,5) /= 0.0_8) LFcomp = LFcomp + in_A6(m,5)*O65(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,-5) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-5)*O65(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,6) /= 0.0_8) LFcomp = LFcomp + in_A6(m,6)*O66(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
						if(in_A6(m,-6) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-6)*O66(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m))
22						continue
					end if
				end do
				if(RI == 'I') matrixI(j,k) = matrixI(j,k) + EnergyConvert*LFcomp
				!write(6,*) 'CL',EnergyConvert*LFcomp
				!************************************************************************************************
			end if
			
			if(do_ored_strain) then
				!Spin Orbit Coupling*************************************************************************
				SOcomp = 0.0_8
				SO2comp = 0.0_8
				SO3comp = 0.0_8
				SO4comp = 0.0_8
				SO5comp = 0.0_8
				SO6comp = 0.0_8
				do m=1,N
					if((twoS(m) /= 0) .and. (twoL(m) /= 0)) then
						do h=1,maxSnum
							if(LocS(h) /= m .and. basis1(h) /= basis2(h)) goto 23
						end do
						do h=1,maxLnum
							if(LocL(h) /= m .and. basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 23
						end do
						do h=1,maxSnum
							if(LocS(h) == m) then
								FLocS = h
								exit
							end if
						end do
						do h=1,maxLnum
							if(LocL(h) == m) then
								FLocL = h
								exit
							end if
						end do
						if(in_lamda(m,1) /= 0.0_8) SOcomp = SOcomp + in_lamda(m,1)*SO1(m,basis1,basis2,FLocL,FLocS)
						if(in_lamda(m,2) /= 0.0_8) SO2comp = SO2comp + in_lamda(m,2)*SO2(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*2.0_8
						if(in_lamda(m,3) /= 0.0_8) SO3comp = SO3comp + in_lamda(m,3)*SO3(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)*3.0_8
						if(in_lamda(m,4) /= 0.0_8) SO4comp = SO4comp + in_lamda(m,4)*SO4(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8
						if(in_lamda(m,5) /= 0.0_8) SO5comp = SO5comp + in_lamda(m,5)*SO5(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*5.0_8
						if(in_lamda(m,6) /= 0.0_8) SO6comp = SO6comp + in_lamda(m,6)*SO6(m,basis1,basis2,FLocL,FLocS)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8
23						continue
					end if
				end do
				if(RI == 'I') matrixI(j,k) = matrixI(j,k) + EnergyConvert*(SOcomp + SO2comp + SO3comp + SO4comp + SO5comp + SO6comp)
				if(RI == 'R') matrixR(j,k) = matrixR(j,k) + EnergyConvert*(SOcomp + SO2comp + SO3comp + SO4comp + SO5comp + SO6comp)
				!write(6,*) 'SO',EnergyConvert*(SOcomp + SO2comp + SO3comp + SO4comp + SO5comp + SO6comp)
				!***********************************************************************************************
				
				!Zeeman Orbital term*****************************************************************************
				ZeeLcomp = (0.0_8,0.0_8)
				ZeeLcompR = 0.0_8
				if(maxLnum /= 0 ) then
					do m=1,maxLnum
						if(maxLnum > 1) then
							do h=1,m-1
								if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 24
							end do
							do h=m+1,maxLnum
								if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 24
							end do
						end if
						if(maxSnum /= 0) then
							do r=1,maxSnum
								if(basis1(r) /= basis2(r)) goto 24
							end do
						end if
						if(RI == 'I') ZeeLcomp = ZeeLcomp + in_B(1)*Lx(m,basis1,basis2) + in_B(2)*Ly(m,basis1,basis2) + Lzed(m,basis1,basis2)*in_B(3)
						if(RI == 'R') ZeeLcompR = ZeeLcompR + Lzed(m,basis1,basis2)*in_B(3)
24						continue
					end do
					if(RI == 'I') matrixI(j,k) = matrixI(j,k) + beta*ZeeLcomp
					if(RI == 'R') matrixR(j,k) = matrixR(j,k) + beta*ZeeLcompR
					!write(6,*) 'ZL',beta*ZeeLcomp
				end if
				!************************************************************************************************
				
				!L+S/L Crystal Field Term*************************************************************************
				LFcomp = (0.0_8,0.0_8)
				do m=1,N
					if(MetalType(m) == 1) then
						do h=1,maxLnum
							if(LocL(h) /= m) then
								if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 25
							end if
						end do
						do h=1,maxSnum
							if(basis1(h) /= basis2(h)) goto 25
						end do
						do h=1,maxLnum
							if(LocL(h) == m) then
								FLocL = h
								exit
							end if
						end do
						if(in_A2(m,0) /= 0.0_8) LFcomp = LFcomp + in_A2(m,0)*O20(m,basis1,basis2,FLocL,FLocS)*(false_orbred(m)*2.0_8)
						if(in_A2(m,1) /= 0.0_8) LFcomp = LFcomp + in_A2(m,1)*O21(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*2.0_8)
						if(in_A2(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A2(m,-1)*O21(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*2.0_8)
						if(in_A2(m,2) /= 0.0_8) LFcomp = LFcomp + in_A2(m,2)*O22(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*2.0_8)
						if(in_A2(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A2(m,-2)*O22(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*2.0_8)
						if(in_A4(m,0) /= 0.0_8) LFcomp = LFcomp + in_A4(m,0)*O40(m,basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A4(m,1) /= 0.0_8) LFcomp = LFcomp + in_A4(m,1)*O41(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A4(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-1)*O41(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A4(m,2) /= 0.0_8) LFcomp = LFcomp + in_A4(m,2)*O42(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A4(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-2)*O42(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A4(m,3) /= 0.0_8) LFcomp = LFcomp + in_A4(m,3)*O43(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A4(m,-3) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-3)*O43(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A4(m,4) /= 0.0_8) LFcomp = LFcomp + in_A4(m,4)*O44(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A4(m,-4) /= 0.0_8) LFcomp = LFcomp + in_A4(m,-4)*O44(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*4.0_8)
						if(in_A6(m,0) /= 0.0_8) LFcomp = LFcomp + in_A6(m,0)*O60(m,basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,1) /= 0.0_8) LFcomp = LFcomp + in_A6(m,1)*O61(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,-1) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-1)*O61(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,2) /= 0.0_8) LFcomp = LFcomp + in_A6(m,2)*O62(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,-2) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-2)*O62(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,3) /= 0.0_8) LFcomp = LFcomp + in_A6(m,3)*O63(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,-3) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-3)*O63(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,4) /= 0.0_8) LFcomp = LFcomp + in_A6(m,4)*O64(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,-4) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-4)*O64(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,5) /= 0.0_8) LFcomp = LFcomp + in_A6(m,5)*O65(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,-5) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-5)*O65(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,6) /= 0.0_8) LFcomp = LFcomp + in_A6(m,6)*O66(m,'p',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
						if(in_A6(m,-6) /= 0.0_8) LFcomp = LFcomp + in_A6(m,-6)*O66(m,'m',basis1,basis2,FLocL,FLocS)*(false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*false_orbred(m)*6.0_8)
25						continue
					end if
				end do
				if(RI == 'I') matrixI(j,k) = matrixI(j,k) + EnergyConvert*LFcomp
				!write(6,*) 'CL',EnergyConvert*LFcomp
				!************************************************************************************************
			end if
			
			!write(6,*)
			
			if(return_all) return
			
			if(RI == 'I') then
				if(matrixI(j,k) /= matrixI(j,k)) then
					SaveTxt = ""
					write(SaveTxt,'(A8,2I8,A7)')"Element ",j,k," is NaN"
					call output_text(SaveTxt,.false.)
					call control('kill ')
					return
				end if
			else if(RI == 'R') then
				if(matrixR(j,k) /= matrixR(j,k)) then
					SaveTxt = ""
					write(SaveTxt,'(A8,2I8,A7)')"Element ",j,k," is NaN"
					call output_text(SaveTxt,.false.)
					call control('kill ')
					return
				end if
			end if
		end do
	end do
	deallocate(basis1,basis2)
	end subroutine matrix_elements

	recursive subroutine site_operators
	! Calculates site-specific operators
	! k is column loop (basis2)
	! j is row loop (basis1)
	! primary_matrix(j,k) = <basis2|H|basis1>
	!			 | <basis2|  <basis2|  <basis2|
	!		  ___|_____________________________
	!	|basis1> |
	!	|basis1> |
	!	|basis1> |
	implicit none
	complex(kind=8),allocatable::matrixI(:,:)
	integer::j,k,m,h,r,xyz,FLocS,FLocL
	integer,allocatable::basis1(:),basis2(:)
	character(len=5)::filename
	if(return_all) then
		!write(6,*) "T1"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*T1"
	end if
	allocate(basis1(maxSnum+maxLnum),basis2(maxSnum+maxLnum),matrixI(totaldim,totaldim))

	!Spin terms********************************************************************************
	do m=1,N
		if(twoS(m) == 0) cycle
		do h=1,maxSnum
			if(LocS(h) == m) then
				FLocS = h
				exit
			end if
		end do
		do xyz = 1,3
			matrixI = (0.0_8,0.0_8)
			do k=1,totaldim
				if(return_all) return
				basis2(:) = basis_lookup(k,:)
				do j=1,totaldim
					if(return_all) return
					basis1(:) = basis_lookup(j,:)
					
					if(maxSnum > 1) then
						do h=1,FLocS-1
							if(basis1(h) /= basis2(h)) goto 26
						end do
						do h=FLocS+1,maxSnum
							if(basis1(h) /= basis2(h)) goto 26
						end do
					end if
					if(maxLnum /= 0) then
						do r=1,maxLnum
							if(basis1(maxSnum+r) /= basis2(maxSnum+r)) goto 26
						end do
					end if
					if(xyz == 1) matrixI(j,k) = Sx(FLocS,0,basis1,basis2)
					if(xyz == 2) matrixI(j,k) = Sy(FLocS,0,basis1,basis2)
					if(xyz == 3) matrixI(j,k) = Szed(FLocS,0,basis1,basis2)
26					continue

					if(return_all) return
					
					if(matrixI(j,k) /= matrixI(j,k)) then
						SaveTxt = ""
						write(SaveTxt,'(A8,2I8,A7)')"Element ",j,k," is NaN"
						call output_text(SaveTxt,.false.)
						call control('kill ')
						return
					end if
				end do
			end do
			if(xyz == 1) filename(1:3) = "Sx_"
			if(xyz == 2) filename(1:3) = "Sy_"
			if(xyz == 3) filename(1:3) = "Sz_"
			if(m<10) then
				filename(4:4) = "0"
				write(filename(5:5),'(I1)') N
			else if(m<100) then
				write(filename(4:5),'(I2)') N
			else
				if(mpi_rank == 0 .and. .not. return_all) call output_text("Can only print site-specific operators for < 100 sites",.false.)
				call control('kill ')
			end if
			open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_"//filename//".res",status='unknown')
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dble(matrixI(k,j))
					end do
					write(41,*)
				end do
				write(41,*)
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
					end do
					write(41,*)
				end do
			close(41)
		end do
	end do
	!************************************************************************************************

	!Orbital terms*****************************************************************************
	do m=1,N
		if(twoL(m) == 0) cycle
		do h=1,maxLnum
			if(LocL(h) == m) then
				FLocL = h
				exit
			end if
		end do
		do xyz = 1,3
			matrixI = (0.0_8,0.0_8)
			do k=1,totaldim
				if(return_all) return
				basis2(:) = basis_lookup(k,:)
				do j=1,totaldim
					if(return_all) return
					basis1(:) = basis_lookup(j,:)

					if(maxLnum > 1) then
						do h=1,FLocL-1
							if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 27
						end do
						do h=FLocL+1,maxLnum
							if(basis1(maxSnum+h) /= basis2(maxSnum+h)) goto 27
						end do
					end if
					if(maxSnum /= 0) then
						do r=1,maxSnum
							if(basis1(r) /= basis2(r)) goto 27
						end do
					end if
					if(xyz == 1) matrixI(j,k) = Lx(FLocL,basis1,basis2)
					if(xyz == 2) matrixI(j,k) = Ly(FLocL,basis1,basis2)
					if(xyz == 3) matrixI(j,k) = Lzed(FLocL,basis1,basis2)
27					continue

					if(return_all) return
					
					if(matrixI(j,k) /= matrixI(j,k)) then
						SaveTxt = ""
						write(SaveTxt,'(A8,2I8,A7)')"Element ",j,k," is NaN"
						call output_text(SaveTxt,.false.)
						call control('kill ')
						return
					end if
				end do
			end do
			if(xyz == 1) filename(1:3) = "Lx_"
			if(xyz == 2) filename(1:3) = "Ly_"
			if(xyz == 3) filename(1:3) = "Lz_"
			if(m<10) then
				filename(4:4) = "0"
				write(filename(5:5),'(I1)') N
			else if(m<100) then
				write(filename(4:5),'(I2)') N
			else
				if(mpi_rank == 0 .and. .not. return_all) call output_text("Can only print site-specific operators for < 100 sites",.false.)
				call control('kill ')
			end if
			open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_"//filename//".res",status='unknown')
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dble(matrixI(k,j))
					end do
					write(41,*)
				end do
				write(41,*)
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
					end do
					write(41,*)
				end do
			close(41)
		end do
	end do
	!************************************************************************************************
	deallocate(basis1,basis2,matrixI)
	end subroutine site_operators
	
	recursive function Lx(a,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::X
	!if(return_all) then
	!	write(6,*) "U"
	!	return
	!end if
	X = 0.5_8*(Lplus(a,basis1,basis2)+Lminus(a,basis1,basis2))
	end function Lx
	
	recursive function Ly(a,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a
	integer,intent(in),dimension(:)::basis1,basis2
	complex(kind=8)::X
	!if(return_all) then
	!	write(6,*) "V"
	!	return
	!end if
	X = -0.5_8*(0.0_8,1.0_8)*(Lplus(a,basis1,basis2)-Lminus(a,basis1,basis2))
	end function Ly
	
	recursive function Sx(a,type,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a,type
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::X
	!if(return_all) then
	!	write(6,*) "W"
	!	return
	!end if
	X = 0.5_8*(Splus(a,type,basis1,basis2)+Sminus(a,type,basis1,basis2))
	end function Sx
	
	recursive function Sy(a,type,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a,type
	integer,intent(in),dimension(:)::basis1,basis2
	complex(kind=8)::X
	!if(return_all) then
	!	write(6,*) "X"
	!	return
	!end if
	X = -0.5_8*(0.0_8,1.0_8)*(Splus(a,type,basis1,basis2)-Sminus(a,type,basis1,basis2))
	end function Sy
	
	recursive function Lplus(a,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::X
	!if(return_all) then
	!	write(6,*) "Y"
	!	return
	!end if
	if(basis2(maxSnum+a) == basis1(maxSnum+a)+2 .and. basis1(maxSnum+a) /= twoL(LocL(a))) then
		X = 0.5_8*dsqrt(dble(twoL(LocL(a))*(twoL(LocL(a))+2)-basis1(maxSnum+a)*(basis1(maxSnum+a)+2)))
	else
		X = 0.0_8
	end if
	end function Lplus
	
	recursive function Lminus(a,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::X
	!if(return_all) then
	!	write(6,*) "Z"
	!	return
	!end if
	if(basis2(maxSnum+a) == basis1(maxSnum+a)-2 .and. basis1(maxSnum+a) /= -twoL(LocL(a))) then
		X = 0.5_8*dsqrt(dble(twoL(LocL(a))*(twoL(LocL(a))+2)-basis1(maxSnum+a)*(basis1(maxSnum+a)-2)))
	else
		X = 0.0_8
	end if
	end function Lminus
	
	recursive function Splus(a,type,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a,type
	integer,intent(in),dimension(:)::basis1,basis2
	integer::gs,gl,L,S,J
	real(kind=8)::X
	!if(return_all) then
	!	write(6,*) "AA"
	!	return
	!end if
	X = 0.0_8
	if(basis2(a) /= basis1(a)+2) return
	if(type == 1 .and. done_ion == 1 .and. Ln_J(LocS(a)) /= 0) then
		if(Ln_J(LocS(a)) == 58) then
			S = 1
			L = 6
			J = 5
		else if(Ln_J(LocS(a)) == 59) then
			S = 2
			L = 10
			J = 8
		else if(Ln_J(LocS(a)) == 60) then
			S = 3
			L = 12
			J = 9
		else if(Ln_J(LocS(a)) == 61) then
			S = 4
			L = 12
			J = 8
		else if(Ln_J(LocS(a)) == 62) then
			S = 5
			L = 10
			J = 5
		else if(Ln_J(LocS(a)) == 65) then
			S = 6
			L = 6
			J = 12
		else if(Ln_J(LocS(a)) == 66) then
			S = 5
			L = 10
			J = 15
		else if(Ln_J(LocS(a)) == 67) then
			S = 4
			L = 12
			J = 16
		else if(Ln_J(LocS(a)) == 68) then
			S = 3
			L = 12
			J = 15
		else if(Ln_J(LocS(a)) == 69) then
			S = 2
			L = 10
			J = 12
		else if(Ln_J(LocS(a)) == 70) then
			S = 1
			L = 6
			J = 7
		else
			call output_text("Splus recieved incorrect atomic number",.false.)
			call control('kill ')
			return
		end if
		if(twoS(LocS(a)) /= J) then
			call output_text("Given J does not match expected J in Splus",.false.)
			call control('kill ')
			return
		end if
		do gs = -S,S,2
			gl = basis1(a) - gs
			X = X + 0.5_8*dsqrt(dble(S*(S+2)-gs*(gs+2)))*quick_CG(L,gl,S,gs+2,J,basis2(a))*quick_CG(L,gl,S,gs,J,basis1(a))
		end do
	else
		if(basis1(a) /= twoS(LocS(a))) then
			X = 0.5_8*dsqrt(dble(twoS(LocS(a))*(twoS(LocS(a))+2)-basis1(a)*(basis1(a)+2)))
		end if
	end if
	end function Splus
	
	recursive function Sminus(a,type,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a,type
	integer,intent(in),dimension(:)::basis1,basis2
	integer::gs,gl,L,S,J
	real(kind=8)::X
	!if(return_all) then
	!	write(6,*) "AB"
	!	return
	!end if
	X = 0.0_8
	if(basis2(a) /= basis1(a)-2) return
	if(type == 1 .and. done_ion == 1 .and. Ln_J(LocS(a)) /= 0) then
		if(Ln_J(LocS(a)) == 58) then
			S = 1
			L = 6
			J = 5
		else if(Ln_J(LocS(a)) == 59) then
			S = 2
			L = 10
			J = 8
		else if(Ln_J(LocS(a)) == 60) then
			S = 3
			L = 12
			J = 9
		else if(Ln_J(LocS(a)) == 61) then
			S = 4
			L = 12
			J = 8
		else if(Ln_J(LocS(a)) == 62) then
			S = 5
			L = 10
			J = 5
		else if(Ln_J(LocS(a)) == 65) then
			S = 6
			L = 6
			J = 12
		else if(Ln_J(LocS(a)) == 66) then
			S = 5
			L = 10
			J = 15
		else if(Ln_J(LocS(a)) == 67) then
			S = 4
			L = 12
			J = 16
		else if(Ln_J(LocS(a)) == 68) then
			S = 3
			L = 12
			J = 15
		else if(Ln_J(LocS(a)) == 69) then
			S = 2
			L = 10
			J = 12
		else if(Ln_J(LocS(a)) == 70) then
			S = 1
			L = 6
			J = 7
		else
			call output_text("Sminus recieved incorrect atomic number",.false.)
			call control('kill ')
			return
		end if
		if(twoS(LocS(a)) /= J) then
			call output_text("Given J does not match expected J in Sminus",.false.)
			call control('kill ')
			return
		end if
		do gs = -S,S,2
			gl = basis1(a) - gs
			X = X + 0.5_8*dsqrt(dble(S*(S+2)-gs*(gs-2)))*quick_CG(L,gl,S,gs-2,J,basis2(a))*quick_CG(L,gl,S,gs,J,basis1(a))
		end do
	else
		if(basis1(a) /= -twoS(LocS(a))) then
			X = 0.5_8*dsqrt(dble(twoS(LocS(a))*(twoS(LocS(a))+2)-basis1(a)*(basis1(a)-2)))
		end if
	end if
	end function Sminus
			
	recursive function Lzed(a,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::X
	!if(return_all) then
	!	write(6,*) "AC"
	!	return
	!end if
	if(basis1(maxSnum+a) == basis2(maxSnum+a)) then
		X = basis1(maxSnum+a)*0.5_8
	else
		X = 0.0_8
	end if
	end function Lzed
	
	recursive function Szed(a,type,basis1,basis2) result(X)
	implicit none
	integer,intent(in)::a,type
	integer,intent(in),dimension(:)::basis1,basis2
	integer::gs,gl,L,S,J
	real(kind=8)::X
	!if(return_all) then
	!	write(6,*) "AD"
	!	return
	!end if
	X = 0.0_8
	if(basis1(a) /= basis2(a)) return
	if(type == 1 .and. done_ion == 1 .and. Ln_J(LocS(a)) /= 0) then
		if(Ln_J(LocS(a)) == 58) then
			S = 1
			L = 6
			J = 5
		else if(Ln_J(LocS(a)) == 59) then
			S = 2
			L = 10
			J = 8
		else if(Ln_J(LocS(a)) == 60) then
			S = 3
			L = 12
			J = 9
		else if(Ln_J(LocS(a)) == 61) then
			S = 4
			L = 12
			J = 8
		else if(Ln_J(LocS(a)) == 62) then
			S = 5
			L = 10
			J = 5
		else if(Ln_J(LocS(a)) == 65) then
			S = 6
			L = 6
			J = 12
		else if(Ln_J(LocS(a)) == 66) then
			S = 5
			L = 10
			J = 15
		else if(Ln_J(LocS(a)) == 67) then
			S = 4
			L = 12
			J = 16
		else if(Ln_J(LocS(a)) == 68) then
			S = 3
			L = 12
			J = 15
		else if(Ln_J(LocS(a)) == 69) then
			S = 2
			L = 10
			J = 12
		else if(Ln_J(LocS(a)) == 70) then
			S = 1
			L = 6
			J = 7
		else
			call output_text("Szed recieved incorrect atomic number",.false.)
			call control('kill ')
			return
		end if
		if(twoS(LocS(a)) /= J) then
			call output_text("Given J does not match expected J in Szed",.false.)
			call control('kill ')
			return
		end if
		do gs = -S,S,2
			gl = basis1(a) - gs
			X = X + gs*0.5_8*quick_CG(L,gl,S,gs,J,basis1(a))**2
		end do
	else
		X = basis1(a)*0.5_8
	end if
	end function Szed
	
	recursive function SO1(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,b,L,S
	real(kind=8)::Y
	! if(return_all) then
		! write(6,*) "AE"
		! return
	! end if
	if(basis2(FLocS) == basis1(FlocS)+2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.5_8*dsqrt(((1 - a)*a + L*(1 + L))*(-(b*(1 + b)) + S*(1 + S)))
	else if(basis2(FLocS) == basis1(FlocS) .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		Y = a*b
	else if(basis2(FLocS) == basis1(FlocS)-2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.5_8*dsqrt((-(a*(1 + a)) + L*(1 + L))*((1 - b)*b + S*(1 + S)))
	else
		Y = 0.0_8
	end if
	end function SO1
	
	recursive function SO2(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,b,L,S
	real(kind=8)::Y
	! if(return_all) then
		! write(6,*) "AF"
		! return
	! end if
	if(basis2(FLocS) == basis1(FlocS)+4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-(b*(1 + b)) + S*(1 + S))*((-1 - b)*(2 + b) + S*(1 + S)))
	else if(basis2(FLocS) == basis1(FlocS)+2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.5_8*(-1 + a - b + 2*a*b)*dsqrt((a - a*a + L + L*L)*(-b - b*b + S + S*S))
	else if(basis2(FLocS) == basis1(FlocS) .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.5_8*(-(a*b) - L*(1 + L)*(b*b - S*(1 + S)) + a*a*(3*b*b - S*(1 + S)))
	else if(basis2(FLocS) == basis1(FlocS)-2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.5_8*(-1 + b + a*(-1 + 2*b))*dsqrt((-a - a*a + L + L*L)*(b - b*b + S + S*S))
	else if(basis2(FLocS) == basis1(FlocS)-4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*dsqrt((-(a*(1 + a)) + L*(1 + L))*((-1 - a)*(2 + a) + L*(1 + L))*(b - b*b + S + S*S)*(-2 + 3*b - b*b + S + S*S))
	else
		Y = 0.0_8
	end if
	end function SO2
	
	recursive function SO3(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,b,L,S
	real(kind=8)::Y
	! if(return_all) then
		! write(6,*) "AG"
		! return
	! end if
	if(basis2(FLocS) == basis1(FlocS)+6 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-6) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.125_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-6 - 5*b - b*b + S + S*S)*(-2 - 3*b - b*b + S + S*S)*(-b - b*b + S + S*S))
	else if(basis2(FLocS) == basis1(FlocS)+4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*(-5 - 3*b + 3*a*(1 + b))*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-2 - 3*b - b*b + S + S*S)*(-b - b*b + S + S*S))
	else if(basis2(FLocS) == basis1(FlocS)+2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.125_8*dsqrt((a - a*a + L + L*L)*(-b - b*b + S + S*S))*(8 - 2*L - 2*L*L + b*(14 - 3*L - 3*L*L) - 3*b*b*(-2 + L + L*L) - 2*S + 3*L*S + 3*L*L*S - 2*S*S + 3*L*S*S + 3*L*L*S*S + 3*a*a*(2 + 5*b + 5*b*b - S - S*S) + a*(-14 - 31*b - 15*b*b + 3*S + 3*S*S))
	else if(basis2(FLocS) == basis1(FlocS) .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.5_8*(a*a*a*b*(1 + 5*b*b - 3*S - 3*S*S) + 2*a*a*(-3*b*b + S + S*S) + L*(1 + L)*(2*b*b - S*(1 + S)) - a*b*(-1 + b*b*(-1 + 3*L + 3*L*L) + S + S*S + L*(1 - 3*S - 3*S*S) + L*L*(1 - 3*S - 3*S*S)))
	else if(basis2(FLocS) == basis1(FlocS)-2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.125_8*dsqrt((-a - a*a + L + L*L)*(b - b*b + S + S*S))*(8 - 2*L - 2*L*L - 3*b*b*(-2 + L + L*L) + b*(-14 + 3*L + 3*L*L) - 2*S + 3*L*S + 3*L*L*S - 2*S*S + 3*L*S*S + 3*L*L*S*S + a*(14 - 31*b + 15*b*b - 3*S - 3*S*S) + 3*a*a*(2 - 5*b + 5*b*b - S - S*S))
	else if(basis2(FLocS) == basis1(FlocS)-4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*(-5 + 3*a*(-1 + b) + 3*b)*dsqrt((-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b*b + S + S*S)*(-2 + 3*b - b*b + S + S*S))
	else if(basis2(FLocS) == basis1(FlocS)-6 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+6) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.125_8*dsqrt((-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b*b + S + S*S)*(-2 + 3*b - b*b + S + S*S)*(-6 + 5*b - b*b + S + S*S))
	else
		Y = 0.0_8
	end if
	end function SO3
	
	recursive function SO4(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,b,L,S
	real(kind=8)::Y
	! if(return_all) then
		! write(6,*) "AH"
		! return
	! end if
	if(basis2(FLocS) == basis1(FlocS)+8 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-8) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.0625_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L)*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-(b*(1 + b)) + S*(1 + S))*(-((3 + b)*(4 + b)) + S*(1 + S)))
	else if(basis2(FLocS) == basis1(FlocS)+6 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-6) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*(-7 - 3*b + a*(3 + 2*b))*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))
	else if(basis2(FLocS) == basis1(FlocS)+4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))*(31 - 2*L - 2*L*L + b*(33 - 2*L - 2*L*L) - b**2*(-9 + L + L*L) - 2*S + L*S + L*L*S - 2*S**2 + L*S**2 + L*L*S**2 + a*a*(9 + 14*b + 7*b**2 - S - S**2) + a*(-33 - 43*b - 14*b**2 + 2*S + 2*S**2))
	else if(basis2(FLocS) == basis1(FlocS)+2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*dsqrt((a - a*a + L + L*L)*(-b - b**2 + S + S**2))*(-14 + 6*L + 6*L*L + 12*b**2*(-2 + L + L*L) + 3*b**3*(-2 + L + L*L) + 6*S - 5*L*S - 5*L*L*S + 6*S**2 - 5*L*S**2 - 5*L*L*S**2 + b*(L*(13 - 3*S - 3*S**2) + L*L*(13 - 3*S - 3*S**2) + 4*(-8 + S + S**2)) - 3*a*a*(23*b**2 + 7*b**3 + b*(22 - 3*S - 3*S**2) - 4*(-2 + S + S**2)) + a*a*a*(1 + 2*b)*(7*b + 7*b**2 - 3*(-2 + S + S**2)) + a*(32 + b**2*(66 - 9*L - 9*L*L) + b**3*(19 - 6*L - 6*L*L) - 13*S - 13*S**2 + L*(-4 + 3*S + 3*S**2) + L*L*(-4 + 3*S + 3*S**2) + b*(81 - 11*S - 11*S**2 + L*(-11 + 6*S + 6*S**2) + L*L*(-11 + 6*S + 6*S**2))))
	else if(basis2(FLocS) == basis1(FlocS) .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.125_8*(-20*a*a*a*b*(1 + 5*b**2 - 3*S - 3*S**2) + 4*a*b*(-2 + 5*b**2*(-1 + 3*L + 3*L*L) + 4*S + 4*S**2 + L*(4 - 11*S - 11*S**2) + L*L*(4 - 11*S - 11*S**2)) + a*a*a*a*(35*b**4 - 5*b**2*(-5 + 6*S + 6*S**2) + 3*S*(-2 - S + 2*S**2 + S**3)) + L*(3*b**4*(-2 - L + 2*L*L + L*L*L) + (1 + L)*S*(1 + S)*(-2*(-4 + S + S**2) + L*(-2 + 3*S + 3*S**2) + L*L*(-2 + 3*S + 3*S**2)) - b**2*(1 + L)*(22 - 8*S - 8*S**2 + L*(-5 + 6*S + 6*S**2) + L*L*(-5 + 6*S + 6*S**2))) + a*a*(-5*b**4*(-5 + 6*L + 6*L*L) - S*(1 + S)*(22 - 5*S - 5*S**2 + L*(-8 + 6*S + 6*S**2) + L*L*(-8 + 6*S + 6*S**2)) + b**2*(71 - 30*S - 30*S**2 + 6*L*(-5 + 6*S + 6*S**2) + 6*L*L*(-5 + 6*S + 6*S**2))))
	else if(basis2(FLocS) == basis1(FlocS)-2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*dsqrt((-a - a*a + L + L*L)*(b - b**2 + S + S**2))*(-14 + 6*L + 6*L*L + 12*b**2*(-2 + L + L*L) - 3*b**3*(-2 + L + L*L) + 6*S - 5*L*S - 5*L*L*S + 6*S**2 - 5*L*S**2 - 5*L*L*S**2 + a*a*a*(-1 + 2*b)*(-7*b + 7*b**2 - 3*(-2 + S + S**2)) + 3*a*a*(-23*b**2 + 7*b**3 + b*(22 - 3*S - 3*S**2) + 4*(-2 + S + S**2)) + b*(-4*(-8 + S + S**2) + L*(-13 + 3*S + 3*S**2) + L*L*(-13 + 3*S + 3*S**2)) + a*(-32 + b**3*(19 - 6*L - 6*L*L) + b**2*(-66 + 9*L + 9*L*L) + 13*S + 13*S**2 + L*(4 - 3*S - 3*S**2) + L*L*(4 - 3*S - 3*S**2) + b*(81 - 11*S - 11*S**2 + L*(-11 + 6*S + 6*S**2) + L*L*(-11 + 6*S + 6*S**2))))
	else if(basis2(FLocS) == basis1(FlocS)-4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*dsqrt((-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2))*(31 - 2*L - 2*L*L - b**2*(-9 + L + L*L) + b*(-33 + 2*L + 2*L*L) - 2*S + L*S + L*L*S - 2*S**2 + L*S**2 + L*L*S**2 + a*(33 - 43*b + 14*b**2 - 2*S - 2*S**2) + a*a*(9 - 14*b + 7*b**2 - S - S**2))
	else if(basis2(FLocS) == basis1(FlocS)-6 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+6) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*(-7 + 3*b + a*(-3 + 2*b))*dsqrt((-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2))
	else if(basis2(FLocS) == basis1(FlocS)-8 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+8) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.0625_8*dsqrt((-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-(a*(1 + a)) + L*(1 + L))*(-((3 + a)*(4 + a)) + L*(1 + L))*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2)*(-12 + 7*b - b**2 + S + S**2))
	else
		Y = 0.0_8
	end if
	end function SO4
	
	recursive function SO5(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,b,L,S
	real(kind=8)::Y
	! if(return_all) then
		! write(6,*) "AI"
		! return
	! end if
	if(basis2(FLocS) == basis1(FlocS)+10 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-10) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L)*(-20 + 9*a - a*a + L + L*L)*(-20 - 9*b - b**2 + S + S**2)*(-12 - 7*b - b**2 + S + S**2)*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))
	else if(basis2(FLocS) == basis1(FlocS)+8 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-8) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.3125_8*(a*(2 + b) - 2*(3 + b))*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L)*(-12 - 7*b - b**2 + S + S**2)*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))
	else if(basis2(FLocS) == basis1(FlocS)+6 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-6) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))*(772 - 20*L - 20*L*L - 15*b*(-40 + L + L*L) - 5*b**2*(-24 + L + L*L) - 20*S + 5*L*S + 5*L*L*S - 20*S**2 + 5*L*S**2 + 5*L*L*S**2 + 5*a*a*(24 + 27*b + 9*b**2 - S - S**2) - 5*a*(113*b + 27*b**2 - 3*(-40 + S + S**2)))
	else if(basis2(FLocS) == basis1(FlocS)+4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))*(-257 + 32*L + 32*L*L + 5*b**3*(-6 + L + L*L) + 5*b**2*(-36 + 5*L + 5*L*L) + 32*S - 10*L*S - 10*L*L*S + 32*S**2 - 10*L*S**2 - 10*L*L*S**2 + 5*a*a*a*(1 + b)*(6 + 6*b + 3*b**2 - S - S**2) - 5*a*a*(36 + 41*b**2 + 9*b**3 - 5*S - 5*S**2 + b*(64 - 3*S - 3*S**2)) + b*(-5*L*(-9 + S + S**2) - 5*L*L*(-9 + S + S**2) + 3*(-123 + 5*S + 5*S**2)) + a*(-5*b**3*(-12 + L + L*L) - 5*b**2*(-64 + 3*L + 3*L*L) + 5*L*(-3 + S + S**2) + 5*L*L*(-3 + S + S**2) - 9*(-41 + 5*S + 5*S**2) + b*(589 - 25*S - 25*S**2 + 5*L*(-5 + S + S**2) + 5*L*L*(-5 + S + S**2))))
	else if(basis2(FLocS) == basis1(FlocS)+2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.0625_8*dsqrt((a - a*a + L + L*L)*(-b - b**2 + S + S**2))*(304 - 164*L - 156*L*L + 16*L*L*L + 8*L*L*L*L + 10*b**3*(36 - 20*L - 19*L*L + 2*L*L*L + L*L*L*L) + 5*b**4*(12 - 8*L - 7*L*L + 2*L*L*L + L*L*L*L) - 164*S + 114*L*S + 104*L*L*S - 20*L*L*L*S - 10*L*L*L*L*S - 156*S**2 + 104*L*S**2 + 99*L*L*S**2 - 10*L*L*L*S**2 - 5*L*L*L*L*S**2 + 16*S**3 - 20*L*S**3 - 10*L*L*S**3 + 20*L*L*L*S**3 + 10*L*L*L*L*S**3 + 8*S**4 - 10*L*S**4 - 5*L*L*S**4 + 10*L*L*L*S**4 + 5*L*L*L*L*S**4 + 5*a*a*a*a*(12 + 42*b**3 + 21*b**4 - 8*S - 7*S**2 + 2*S**3 + S**4 - 14*b*(-3 + S + S**2) - 7*b**2*(-9 + 2*S + 2*S**2)) - b**2*(-2 + L + L*L)*(5*L*(-5 + 2*S + 2*S**2) + 5*L*L*(-5 + 2*S + 2*S**2) - 6*(-68 + 5*S + 5*S**2)) - 10*a*a*a*(36 + 98*b**3 + 21*b**4 - 20*S - 19*S**2 + 2*S**3 + S**4 - 7*b**2*(-21 + 2*S + 2*S**2) - 2*b*(-59 + 19*S + 19*S**2)) - 2*b*(-410 + 98*S + 98*S**2 + L*(217 - 65*S - 65*S**2) + 10*L*L*L*(-2 + S + S**2) + 5*L*L*L*L*(-2 + S + S**2) - 3*L*L*(-69 + 20*S + 20*S**2)) + a*a*(-70*b**3*(-21 + 2*L + 2*L*L) - 35*b**4*(-9 + 2*L + 2*L*L) - (-2 + S + S**2)*(408 - 25*S - 25*S**2 + 10*L*(-3 + S + S**2) + 10*L*L*(-3 + S + S**2)) + 5*b**2*(579 - 52*S - 52*S**2 + 4*L*(-13 + 4*S + 4*S**2) + 4*L*L*(-13 + 4*S + 4*S**2)) + 10*b*(246 - 62*S - 62*S**2 + L*(-19 + 8*S + 8*S**2) + L*L*(-19 + 8*S + 8*S**2))) + 2*a*(-410 + 35*b**4*(-3 + L + L*L) + 10*b**3*(-59 + 19*L + 19*L*L) + 217*S + 207*S**2 - 20*S**3 - 10*S**4 + L*(98 - 65*S - 60*S**2 + 10*S**3 + 5*S**4) + L*L*(98 - 65*S - 60*S**2 + 10*S**3 + 5*S**4) - 5*b**2*(246 - 19*S - 19*S**2 + L*(-62 + 8*S + 8*S**2) + L*L*(-62 + 8*S + 8*S**2)) + b*(-1169 + 291*S + 291*S**2 - 3*L*(-97 + 40*S + 40*S**2) - 3*L*L*(-97 + 40*S + 40*S**2))))
	else if(basis2(FLocS) == basis1(FlocS) .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.125_8*(a*a*a*a*a*b*(12 + 63*b**4 - 50*S - 35*S**2 + 30*S**3 + 15*S**4 - 35*b**2*(-3 + 2*S + 2*S**2)) - 10*a*a*a*a*(35*b**4 - 5*b**2*(-5 + 6*S + 6*S**2) + 3*S*(-2 - S + 2*S**2 + S**3)) + a*a*a*b*(112 - 35*b**4*(-3 + 2*L + 2*L*L) - 366*S - 321*S**2 + 90*S**3 + 45*S**4 - 10*L*(2 - 8*S - 5*S**2 + 6*S**3 + 3*S**4) - 10*L*L*(2 - 8*S - 5*S**2 + 6*S**3 + 3*S**4) + 5*b**2*(127 - 30*S - 30*S**2 + 10*L*(-3 + 2*S + 2*S**2) + 10*L*L*(-3 + 2*S + 2*S**2))) - 2*L*(15*b**4*(-2 - L + 2*L*L + L*L*L) + (1 + L)*S*(1 + S)*(14 - 6*S - 6*S**2 + L*(-6 + 5*S + 5*S**2) + L*L*(-6 + 5*S + 5*S**2)) - b**2*(1 + L)*(46 - 34*S - 34*S**2 + L*(-19 + 20*S + 20*S**2) + L*L*(-19 + 20*S + 20*S**2))) + a*a*(50*b**4*(-5 + 6*L + 6*L*L) + 2*S*(1 + S)*(46 - 19*S - 19*S**2 + L*(-34 + 20*S + 20*S**2) + L*L*(-34 + 20*S + 20*S**2)) + b**2*(-326 + 264*S + 264*S**2 - 12*L*(-22 + 25*S + 25*S**2) - 12*L*L*(-22 + 25*S + 25*S**2))) + a*b*(b**4*(12 - 50*L - 35*L*L + 30*L*L*L + 15*L*L*L*L) + L*(-76 + 232*S + 202*S**2 - 60*S**3 - 30*S**4) + L*L*(-68 + 202*S + 187*S**2 - 30*S**3 - 15*S**4) + 4*(7 - 19*S - 17*S**2 + 4*S**3 + 2*S**4) + 2*L*L*L*(8 - 30*S - 15*S**2 + 30*S**3 + 15*S**4) + L*L*L*L*(8 - 30*S - 15*S**2 + 30*S**3 + 15*S**4) + b**2*(-30*L*L*L*(-3 + 2*S + 2*S**2) - 15*L*L*L*L*(-3 + 2*S + 2*S**2) - 4*(-28 + 5*S + 5*S**2) + L*L*(-321 + 50*S + 50*S**2) + L*(-366 + 80*S + 80*S**2))))
	else if(basis2(FLocS) == basis1(FlocS)-2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.0625_8*dsqrt((-a - a*a + L + L*L)*(b - b**2 + S + S**2))*(304 - 164*L - 156*L*L + 16*L*L*L + 8*L*L*L*L - 10*b**3*(36 - 20*L - 19*L*L + 2*L*L*L + L*L*L*L) + 5*b**4*(12 - 8*L - 7*L*L + 2*L*L*L + L*L*L*L) - 164*S + 114*L*S + 104*L*L*S - 20*L*L*L*S - 10*L*L*L*L*S - 156*S**2 + 104*L*S**2 + 99*L*L*S**2 - 10*L*L*L*S**2 - 5*L*L*L*L*S**2 + 16*S**3 - 20*L*S**3 - 10*L*L*S**3 + 20*L*L*L*S**3 + 10*L*L*L*L*S**3 + 8*S**4 - 10*L*S**4 - 5*L*L*S**4 + 10*L*L*L*S**4 + 5*L*L*L*L*S**4 + 5*a*a*a*a*(12 - 42*b**3 + 21*b**4 - 8*S - 7*S**2 + 2*S**3 + S**4 + 14*b*(-3 + S + S**2) - 7*b**2*(-9 + 2*S + 2*S**2)) - b**2*(-2 + L + L*L)*(5*L*(-5 + 2*S + 2*S**2) + 5*L*L*(-5 + 2*S + 2*S**2) - 6*(-68 + 5*S + 5*S**2)) + 10*a*a*a*(36 - 98*b**3 + 21*b**4 - 20*S - 19*S**2 + 2*S**3 + S**4 - 7*b**2*(-21 + 2*S + 2*S**2) + 2*b*(-59 + 19*S + 19*S**2)) + 2*b*(-410 + 98*S + 98*S**2 + L*(217 - 65*S - 65*S**2) + 10*L*L*L*(-2 + S + S**2) + 5*L*L*L*L*(-2 + S + S**2) - 3*L*L*(-69 + 20*S + 20*S**2)) + a*a*(70*b**3*(-21 + 2*L + 2*L*L) - 35*b**4*(-9 + 2*L + 2*L*L) - (-2 + S + S**2)*(408 - 25*S - 25*S**2 + 10*L*(-3 + S + S**2) + 10*L*L*(-3 + S + S**2)) + 5*b**2*(579 - 52*S - 52*S**2 + 4*L*(-13 + 4*S + 4*S**2) + 4*L*L*(-13 + 4*S + 4*S**2)) - 10*b*(246 - 62*S - 62*S**2 + L*(-19 + 8*S + 8*S**2) + L*L*(-19 + 8*S + 8*S**2))) - 2*a*(-410 + 35*b**4*(-3 + L + L*L) - 10*b**3*(-59 + 19*L + 19*L*L) + 217*S + 207*S**2 - 20*S**3 - 10*S**4 + L*(98 - 65*S - 60*S**2 + 10*S**3 + 5*S**4) + L*L*(98 - 65*S - 60*S**2 + 10*S**3 + 5*S**4) - 5*b**2*(246 - 19*S - 19*S**2 + L*(-62 + 8*S + 8*S**2) + L*L*(-62 + 8*S + 8*S**2)) + b*(1169 - 291*S - 291*S**2 + 3*L*(-97 + 40*S + 40*S**2) + 3*L*L*(-97 + 40*S + 40*S**2))))
	else if(basis2(FLocS) == basis1(FlocS)-4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.25_8*dsqrt((-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2))*(-257 + 32*L + 32*L*L - 5*b**3*(-6 + L + L*L) + 5*b**2*(-36 + 5*L + 5*L*L) + 32*S - 10*L*S - 10*L*L*S + 32*S**2 - 10*L*S**2 - 10*L*L*S**2 + 5*a*a*a*(-1 + b)*(6 - 6*b + 3*b**2 - S - S**2) + 5*a*a*(-36 - 41*b**2 + 9*b**3 + 5*S + 5*S**2 + b*(64 - 3*S - 3*S**2)) + b*(5*L*(-9 + S + S**2) + 5*L*L*(-9 + S + S**2) - 3*(-123 + 5*S + 5*S**2)) + a*(-5*b**3*(-12 + L + L*L) + 5*b**2*(-64 + 3*L + 3*L*L) - 5*L*(-3 + S + S**2) - 5*L*L*(-3 + S + S**2) + 9*(-41 + 5*S + 5*S**2) + b*(589 - 25*S - 25*S**2 + 5*L*(-5 + S + S**2) + 5*L*L*(-5 + S + S**2))))
	else if(basis2(FLocS) == basis1(FlocS)-6 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+6) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*dsqrt((-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2))*(772 - 20*L - 20*L*L + 15*b*(-40 + L + L*L) - 5*b**2*(-24 + L + L*L) - 20*S + 5*L*S + 5*L*L*S - 20*S**2 + 5*L*S**2 + 5*L*L*S**2 + 5*a*a*(24 - 27*b + 9*b**2 - S - S**2) + 5*a*(-113*b + 27*b**2 - 3*(-40 + S + S**2)))
	else if(basis2(FLocS) == basis1(FlocS)-8 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+8) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.3125_8*(2*(-3 + b) + a*(-2 + b))*dsqrt((-12 - 7*a - a*a + L + L*L)*(-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2)*(-12 + 7*b - b**2 + S + S**2))
	else if(basis2(FLocS) == basis1(FlocS)-10 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+10) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*dsqrt((-20 - 9*a - a*a + L + L*L)*(-12 - 7*a - a*a + L + L*L)*(-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2)*(-12 + 7*b - b**2 + S + S**2)*(-20 + 9*b - b**2 + S + S**2))
	else
		Y = 0.0_8
	end if
	end function SO5
	
	recursive function SO6(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,b,L,S
	real(kind=8)::Y
	! if(return_all) then
		! write(6,*) "AJ"
		! return
	! end if
	if(basis2(FLocS) == basis1(FlocS)+12 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-12) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y =	0.015625_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L)*(-20 + 9*a - a*a + L + L*L)*((6 - a)*(-5 + a) + L*(1 + L))*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-(b*(1 + b)) + S*(1 + S))*((-3 - b)*(4 + b) + S*(1 + S))*((-4 - b)*(5 + b) + S*(1 + S))*((-5 - b)*(6 + b) + S*(1 + S)))
	else if(basis2(FLocS) == basis1(FlocS)+10 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-10) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y =	0.03125_8*(-55 + 15*a - 15*b + 6*a*b)*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L)*(-20 + 9*a - a*a + L + L*L)*(-20 - 9*b - b**2 + S + S**2)*(-12 - 7*b - b**2 + S + S**2)*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))
	else if(basis2(FLocS) == basis1(FlocS)+8 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-8) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L)*(-12 - 7*b - b**2 + S + S**2)*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))*(1546 - 20*L - 20*L*L - 3*b**2*(-50 + L + L*L) - 2*b*(-475 + 6*L + 6*L*L) - 20*S + 3*L*S + 3*L*L*S - 20*S**2 + 3*L*S**2 + 3*L*L*S**2 + 3*a*a*(50 + 44*b + 11*b**2 - S - S**2) + a*(-950 - 703*b - 132*b**2 + 12*S + 12*S**2))
	else if(basis2(FLocS) == basis1(FlocS)+6 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-6) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-6 - 5*b - b**2 + S + S**2)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))*(-12296 + 668*L + 668*L*L + 15*b**3*(-40 + 3*L + 3*L*L) + 10*b**2*(-480 + 29*L + 29*L*L) + 668*S - 115*L*S - 115*L*L*S + 668*S**2 - 115*L*S**2 - 115*L*L*S**2 + 5*a*a*a*(3 + 2*b)*(40 + 33*b + 11*b**2 - 3*S - 3*S**2) - 5*a*a*(960 + 603*b**2 + 99*b**3 - 58*S - 58*S**2 - 9*b*(-142 + 3*S + 3*S**2)) - 3*b*(5*L*(-47 + 3*S + 3*S**2) + 5*L*L*(-47 + 3*S + 3*S**2) - 16*(-274 + 5*S + 5*S**2)) + a*(-45*b**2*(-142 + 3*L + 3*L*L) - 5*b**3*(-179 + 6*L + 6*L*L) + 3*(4384 - 235*S - 235*S**2 + 5*L*(-16 + 3*S + 3*S**2) + 5*L*L*(-16 + 3*S + 3*S**2)) + b*(15683 - 295*S - 295*S**2 + 5*L*(-59 + 6*S + 6*S**2) + 5*L*L*(-59 + 6*S + 6*S**2))))
	else if(basis2(FLocS) == basis1(FlocS)+4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.015625_8*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-2 - 3*b - b**2 + S + S**2)*(-b - b**2 + S + S**2))*(44848 - 7728*L - 7592*L*L + 272*L*L*L + 136*L*L*L*L + 15*b**4*(120 - 26*L - 25*L*L + 2*L*L*L + L*L*L*L) + 20*b**3*(780 - 148*L - 145*L*L + 6*L*L*L + 3*L*L*L*L) - 7728*S + 2060*L*S + 1990*L*L*S - 140*L*L*L*S - 70*L*L*L*L*S - 7592*S**2 + 1990*L*S**2 + 1935*L*L*S**2 - 110*L*L*L*S**2 - 55*L*L*L*L*S**2 + 272*S**3 - 140*L*S**3 - 110*L*L*S**3 + 60*L*L*L*S**3 + 30*L*L*L*L*S**3 + 136*S**4 - 70*L*S**4 - 55*L*L*S**4 + 30*L*L*L*S**4 + 15*L*L*L*L*S**4 + 15*a*a*a*a*(120 + 132*b**3 + 33*b**4 - 26*S - 25*S**2 + 2*S**3 + S**4 - 3*b**2*(-91 + 6*S + 6*S**2) - 6*b*(-47 + 6*S + 6*S**2)) - 20*a*a*a*(780 + 606*b**3 + 99*b**4 - 148*S - 145*S**2 + 6*S**3 + 3*S**4 - 9*b**2*(-161 + 6*S + 6*S**2) - 2*b*(-843 + 89*S + 89*S**2)) - 2*b*(L*(6686 - 920*S - 920*S**2) + L*L*(6571 - 890*S - 890*S**2) + 10*L*L*L*(-23 + 6*S + 6*S**2) + 5*L*L*L*L*(-23 + 6*S + 6*S**2) + 24*(-1630 + 137*S + 137*S**2)) + b**2*(-10*L*L*L*(-35 + 6*S + 6*S**2) - 5*L*L*L*L*(-35 + 6*S + 6*S**2) - 72*(-721 + 20*S + 20*S**2) + L*L*(-9023 + 430*S + 430*S**2) + L*(-9198 + 460*S + 460*S**2)) + 2*a*(-39120 + 45*b**4*(-47 + 6*L + 6*L*L) + 20*b**3*(-843 + 89*L + 89*L*L) + 6686*S + 6571*S**2 - 230*S**3 - 115*S**4 + L*(3288 - 920*S - 890*S**2 + 60*S**3 + 30*S**4) + L*L*(3288 - 920*S - 890*S**2 + 60*S**3 + 30*S**4) + b**2*(-51891 + 1510*S + 1510*S**2 - 10*L*(-469 + 30*S + 30*S**2) - 10*L*L*(-469 + 30*S + 30*S**2)) - 2*b*(36435 - 3134*S - 3134*S**2 + L*(-3134 + 530*S + 530*S**2) + L*L*(-3134 + 530*S + 530*S**2))) + a*a*(-180*b**3*(-161 + 6*L + 6*L*L) - 45*b**4*(-91 + 6*L + 6*L*L) - 10*L*(144 - 46*S - 43*S**2 + 6*S**3 + 3*S**4) - 10*L*L*(144 - 46*S - 43*S**2 + 6*S**3 + 3*S**4) + 7*(7416 - 1314*S - 1289*S**2 + 50*S**3 + 25*S**4) + b**2*(10*L*(-259 + 30*S + 30*S**2) + 10*L*L*(-259 + 30*S + 30*S**2) - 7*(-11553 + 370*S + 370*S**2)) + 2*b*(10*L*(-151 + 30*S + 30*S**2) + 10*L*L*(-151 + 30*S + 30*S**2) - 7*(-7413 + 670*S + 670*S**2))))
	else if(basis2(FLocS) == basis1(FlocS)+2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)-2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.0625_8*dsqrt((a - a*a + L + L*L)*(-b - b**2 + S + S**2))*(-2360 + 1448*L + 1312*L*L - 272*L*L*L - 136*L*L*L*L - 125*b**4*(12 - 8*L - 7*L*L + 2*L*L*L + L*L*L*L) - 15*b**5*(12 - 8*L - 7*L*L + 2*L*L*L + L*L*L*L) + 1448*S - 992*L*S - 866*L*L*S + 252*L*L*L*S + 126*L*L*L*L*S + 1312*S**2 - 866*L*S**2 - 775*L*L*S**2 + 182*L*L*L*S**2 + 91*L*L*L*L*S**2 - 272*S**3 + 252*L*S**3 + 182*L*L*S**3 - 140*L*L*L*S**3 - 70*L*L*L*L*S**3 - 136*S**4 + 126*L*S**4 + 91*L*L*S**4 - 70*L*L*L*S**4 - 35*L*L*L*L*S**4 + b**3*(-2 + L + L*L)*(5*L*(-59 + 6*S + 6*S**2) + 5*L*L*(-59 + 6*S + 6*S**2) - 6*(-421 + 20*S + 20*S**2)) + b**2*(-2 + L + L*L)*(4266 - 642*S - 642*S**2 + L*(-517 + 160*S + 160*S**2) + L*L*(-517 + 160*S + 160*S**2)) + 3*a*a*a*a*a*(1 + 2*b)*(66*b**3 + 33*b**4 - 6*b*(-19 + 5*S + 5*S**2) - 3*b**2*(-49 + 10*S + 10*S**2) + 5*(12 - 8*S - 7*S**2 + 2*S**3 + S**4)) - 5*a*a*a*a*(615*b**4 + 99*b**5 - 15*b**3*(-85 + 6*S + 6*S**2) - 5*b**2*(-333 + 76*S + 76*S**2) + 25*(12 - 8*S - 7*S**2 + 2*S**3 + S**4) + b*(1086 - 410*S - 395*S**2 + 30*S**3 + 15*S**4)) + b*(-10*L*L*L*(80 - 38*S - 35*S**2 + 6*S**3 + 3*S**4) - 5*L*L*L*L*(80 - 38*S - 35*S**2 + 6*S**3 + 3*S**4) - 4*(1790 - 585*S - 568*S**2 + 34*S**3 + 17*S**4) + 2*L*(2180 - 787*S - 757*S**2 + 60*S**3 + 30*S**4) + L*L*(3960 - 1384*S - 1339*S**2 + 90*S**3 + 45*S**4)) + a*a*(45*b**5*(-25 + 6*L + 6*L*L) + 25*b**4*(-333 + 76*L + 76*L*L) + (-2 + S + S**2)*(4266 - 517*S - 517*S**2 + 2*L*(-321 + 80*S + 80*S**2) + 2*L*L*(-321 + 80*S + 80*S**2)) + b**2*(-36783 + 6170*S + 6170*S**2 - 10*L*(-617 + 164*S + 164*S**2) - 10*L*L*(-617 + 164*S + 164*S**2)) + b**3*(-10*L*(-419 + 36*S + 36*S**2) - 10*L*L*(-419 + 36*S + 36*S**2) + 3*(-8019 + 430*S + 430*S**2)) + b*(-27882 + 9428*S + 9143*S**2 - 570*S**3 - 285*S**4 + 10*L*(433 - 182*S - 173*S**2 + 18*S**3 + 9*S**4) + 10*L*L*(433 - 182*S - 173*S**2 + 18*S**3 + 9*S**4))) + a*(6*b**5*(117 - 55*L - 50*L*L + 10*L*L*L + 5*L*L*L*L) + 5*b**4*(1086 - 410*L - 395*L*L + 30*L*L*L + 15*L*L*L*L) + L*L*(-2272 + 1514*S + 1339*S**2 - 350*S**3 - 175*S**4) + 40*(179 - 109*S - 99*S**2 + 20*S**3 + 10*S**4) + 2*L*L*L*(68 - 60*S - 45*S**2 + 30*S**3 + 15*S**4) + L*L*L*L*(68 - 60*S - 45*S**2 + 30*S**3 + 15*S**4) - 2*L*(1170 - 787*S - 692*S**2 + 190*S**3 + 95*S**4) - 2*b**3*(-8709 + 440*S + 440*S**2 + 60*L*L*L*(-4 + S + S**2) + 30*L*L*L*L*(-4 + S + S**2) - 3*L*L*(-1037 + 70*S + 70*S**2) - 3*L*(-1077 + 80*S + 80*S**2)) + b**2*(27882 - 4330*S - 4330*S**2 - 30*L*L*L*(-19 + 6*S + 6*S**2) - 15*L*L*L*L*(-19 + 6*S + 6*S**2) + 4*L*(-2357 + 455*S + 455*S**2) + L*L*(-9143 + 1730*S + 1730*S**2)) + 2*b*(11252 - 3759*S - 3646*S**2 + 226*S**3 + 113*S**4 + L*(-3759 + 1552*S + 1477*S**2 - 150*S**3 - 75*S**4) + L*L*(-3646 + 1477*S + 1417*S**2 - 120*S**3 - 60*S**4) + 2*L*L*L*(113 - 75*S - 60*S**2 + 30*S**3 + 15*S**4) + L*L*L*L*(113 - 75*S - 60*S**2 + 30*S**3 + 15*S**4))) - a*a*a*(180*b**5*(-6 + L + L*L) + 75*b**4*(-85 + 6*L + 6*L*L) + (-2 + S + S**2)*(2526 - 295*S - 295*S**2 + 30*L*(-4 + S + S**2) + 30*L*L*(-4 + S + S**2)) - 2*b**3*(8919 - 580*S - 580*S**2 + 20*L*(-29 + 6*S + 6*S**2) + 20*L*L*(-29 + 6*S + 6*S**2)) + b**2*(-24057 + 4190*S + 4190*S**2 - 30*L*(-43 + 12*S + 12*S**2) - 30*L*L*(-43 + 12*S + 12*S**2)) + 2*b*(10*L*(44 - 24*S - 21*S**2 + 6*S**3 + 3*S**4) + 10*L*L*(44 - 24*S - 21*S**2 + 6*S**3 + 3*S**4) - 3*(2903 - 1077*S - 1037*S**2 + 80*S**3 + 40*S**4))))
	else if(basis2(FLocS) == basis1(FlocS) .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.0625_8*(-35*a*a*a*a*a*b*(12 + 63*b**4 - 50*S - 35*S**2 + 30*S**3 + 15*S**4 - 35*b**2*(-3 + 2*S + 2*S**2)) + a*a*a*a*a*a*(231*b**6 - 105*b**4*(-7 + 3*S + 3*S**2) + 21*b**2*(14 - 25*S - 20*S**2 + 10*S**3 + 5*S**4) - 5*S*(12 + 4*S - 15*S**2 - 5*S**3 + 3*S**4 + S**5)) + a*b*(-35*b**4*(12 - 50*L - 35*L*L + 30*L*L*L + 15*L*L*L*L) + L*L*L*L*(-204 + 766*S + 481*S**2 - 570*S**3 - 285*S**4) - 4*(76 - 246*S - 195*S**2 + 102*S**3 + 51*S**4) - 2*L*L*L*(204 - 766*S - 481*S**2 + 570*S**3 + 285*S**4) + 2*L*(492 - 1688*S - 1305*S**2 + 766*S**3 + 383*S**4) + L*L*(780 - 2610*S - 2129*S**2 + 962*S**3 + 481*S**4) + b**2*(-1636 + 616*S + 616*S**2 + L*(5874 - 2468*S - 2468*S**2) + L*L*(4551 - 1658*S - 1658*S**2) + 54*L*L*L*(-49 + 30*S + 30*S**2) + 27*L*L*L*L*(-49 + 30*S + 30*S**2))) + a*a*a*b*(-1636 + 1225*b**4*(-3 + 2*L + 2*L*L) + 5874*S + 4551*S**2 - 2646*S**3 - 1323*S**4 + 2*L*(308 - 1234*S - 829*S**2 + 810*S**3 + 405*S**4) + 2*L*L*(308 - 1234*S - 829*S**2 + 810*S**3 + 405*S**4) - 5*b**2*(2161 - 966*S - 966*S**2 + L*(-966 + 620*S + 620*S**2) + L*L*(-966 + 620*S + 620*S**2))) + L*(-5*b**6*(12 + 4*L - 15*L*L - 5*L*L*L + 3*L*L*L*L + L*L*L*L*L) + b**4*(-2 - L + 2*L*L + L*L*L)*(5*L*(-7 + 3*S + 3*S**2) + 5*L*L*(-7 + 3*S + 3*S**2) - 12*(-49 + 5*S + 5*S**2)) + (1 + L)*S*(1 + S)*(L*L*(-156 + 104*S + 99*S**2 - 10*S**3 - 5*S**4) + 4*(76 - 41*S - 39*S**2 + 4*S**3 + 2*S**4) - 2*L*(82 - 57*S - 52*S**2 + 10*S**3 + 5*S**4) + 2*L*L*L*(8 - 10*S - 5*S**2 + 10*S**3 + 5*S**4) + L*L*L*L*(8 - 10*S - 5*S**2 + 10*S**3 + 5*S**4)) - b**2*(1 + L)*(L*L*(-570 + 657*S + 612*S**2 - 90*S**3 - 45*S**4) + L*L*L*L*(28 - 45*S - 30*S**2 + 30*S**3 + 15*S**4) + 4*(281 - 294*S - 277*S**2 + 34*S**3 + 17*S**4) - 2*L*(299 - 351*S - 321*S**2 + 60*S**3 + 30*S**4) + L*L*L*(56 - 90*S - 60*S**2 + 60*S**3 + 30*S**4))) + a*a*a*a*(-105*b**6*(-7 + 3*L + 3*L*L) + S*(-2 - S + 2*S**2 + S**3)*(15*L*(-4 + S + S**2) + 15*L*L*(-4 + S + S**2) - 7*(-84 + 5*S + 5*S**2)) + 35*b**4*(5*L*(-7 + 3*S + 3*S**2) + 5*L*L*(-7 + 3*S + 3*S**2) - 7*(-33 + 5*S + 5*S**2)) - 5*b**2*(-7*(144 - 193*S - 178*S**2 + 30*S**3 + 15*S**4) + L*(112 - 195*S - 150*S**2 + 90*S**3 + 45*S**4) + L*L*(112 - 195*S - 150*S**2 + 90*S**3 + 45*S**4))) + a*a*(21*b**6*(14 - 25*L - 20*L*L + 10*L*L*L + 5*L*L*L*L) - 5*b**4*(L*(1351 - 195*S - 195*S**2) + 112*(-9 + S + S**2) + 30*L*L*L*(-7 + 3*S + 3*S**2) + 15*L*L*L*L*(-7 + 3*S + 3*S**2) - 2*L*L*(-623 + 75*S + 75*S**2)) - S*(1 + S)*(1124 - 598*S - 570*S**2 + 56*S**3 + 28*S**4 - 2*L*L*(554 - 321*S - 306*S**2 + 30*S**3 + 15*S**4) - 3*L*(392 - 234*S - 219*S**2 + 30*S**3 + 15*S**4) + 2*L*L*L*(68 - 60*S - 45*S**2 + 30*S**3 + 15*S**4) + L*L*L*L*(68 - 60*S - 45*S**2 + 30*S**3 + 15*S**4)) + b**2*(4338 - 4804*S - 4510*S**2 + 588*S**3 + 294*S**4 + L*(-4804 + 6129*S + 5634*S**2 - 990*S**3 - 495*S**4) + L*L*(-4510 + 5634*S + 5274*S**2 - 720*S**3 - 360*S**4) + 6*L*L*L*(98 - 165*S - 120*S**2 + 90*S**3 + 45*S**4) + 3*L*L*L*L*(98 - 165*S - 120*S**2 + 90*S**3 + 45*S**4))))
	else if(basis2(FLocS) == basis1(FlocS)-2 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+2) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.0625_8*dsqrt((-a - a*a + L + L*L)*(b - b**2 + S + S**2))*(-2360 + 1448*L + 1312*L*L - 272*L*L*L - 136*L*L*L*L - 125*b**4*(12 - 8*L - 7*L*L + 2*L*L*L + L*L*L*L) + 15*b**5*(12 - 8*L - 7*L*L + 2*L*L*L + L*L*L*L) + 1448*S - 992*L*S - 866*L*L*S + 252*L*L*L*S + 126*L*L*L*L*S + 1312*S**2 - 866*L*S**2 - 775*L*L*S**2 + 182*L*L*L*S**2 + 91*L*L*L*L*S**2 - 272*S**3 + 252*L*S**3 + 182*L*L*S**3 - 140*L*L*L*S**3 - 70*L*L*L*L*S**3 - 136*S**4 + 126*L*S**4 + 91*L*L*S**4 - 70*L*L*L*S**4 - 35*L*L*L*L*S**4 - b**3*(-2 + L + L*L)*(5*L*(-59 + 6*S + 6*S**2) + 5*L*L*(-59 + 6*S + 6*S**2) - 6*(-421 + 20*S + 20*S**2)) + b**2*(-2 + L + L*L)*(4266 - 642*S - 642*S**2 + L*(-517 + 160*S + 160*S**2) + L*L*(-517 + 160*S + 160*S**2)) + 3*a*a*a*a*a*(-1 + 2*b)*(-66*b**3 + 33*b**4 + 6*b*(-19 + 5*S + 5*S**2) - 3*b**2*(-49 + 10*S + 10*S**2) + 5*(12 - 8*S - 7*S**2 + 2*S**3 + S**4)) + 5*a*a*a*a*(-615*b**4 + 99*b**5 - 15*b**3*(-85 + 6*S + 6*S**2) + 5*b**2*(-333 + 76*S + 76*S**2) - 25*(12 - 8*S - 7*S**2 + 2*S**3 + S**4) + b*(1086 - 410*S - 395*S**2 + 30*S**3 + 15*S**4)) + b*(L*L*(-3960 + 1384*S + 1339*S**2 - 90*S**3 - 45*S**4) + 10*L*L*L*(80 - 38*S - 35*S**2 + 6*S**3 + 3*S**4) + 5*L*L*L*L*(80 - 38*S - 35*S**2 + 6*S**3 + 3*S**4) + 4*(1790 - 585*S - 568*S**2 + 34*S**3 + 17*S**4) - 2*L*(2180 - 787*S - 757*S**2 + 60*S**3 + 30*S**4)) + a*a*(-45*b**5*(-25 + 6*L + 6*L*L) + 25*b**4*(-333 + 76*L + 76*L*L) + (-2 + S + S**2)*(4266 - 517*S - 517*S**2 + 2*L*(-321 + 80*S + 80*S**2) + 2*L*L*(-321 + 80*S + 80*S**2)) + b**2*(-36783 + 6170*S + 6170*S**2 - 10*L*(-617 + 164*S + 164*S**2) - 10*L*L*(-617 + 164*S + 164*S**2)) + b**3*(10*L*(-419 + 36*S + 36*S**2) + 10*L*L*(-419 + 36*S + 36*S**2) - 3*(-8019 + 430*S + 430*S**2)) + b*(27882 - 9428*S - 9143*S**2 + 570*S**3 + 285*S**4 - 10*L*(433 - 182*S - 173*S**2 + 18*S**3 + 9*S**4) - 10*L*L*(433 - 182*S - 173*S**2 + 18*S**3 + 9*S**4))) + a*(6*b**5*(117 - 55*L - 50*L*L + 10*L*L*L + 5*L*L*L*L) - 5*b**4*(1086 - 410*L - 395*L*L + 30*L*L*L + 15*L*L*L*L) + L*L*L*L*(-68 + 60*S + 45*S**2 - 30*S**3 - 15*S**4) - 40*(179 - 109*S - 99*S**2 + 20*S**3 + 10*S**4) - 2*L*L*L*(68 - 60*S - 45*S**2 + 30*S**3 + 15*S**4) + 2*L*(1170 - 787*S - 692*S**2 + 190*S**3 + 95*S**4) + L*L*(2272 - 1514*S - 1339*S**2 + 350*S**3 + 175*S**4) - 2*b**3*(-8709 + 440*S + 440*S**2 + 60*L*L*L*(-4 + S + S**2) + 30*L*L*L*L*(-4 + S + S**2) - 3*L*L*(-1037 + 70*S + 70*S**2) - 3*L*(-1077 + 80*S + 80*S**2)) + b**2*(-27882 + 4330*S + 4330*S**2 + L*L*(9143 - 1730*S - 1730*S**2) + 30*L*L*L*(-19 + 6*S + 6*S**2) + 15*L*L*L*L*(-19 + 6*S + 6*S**2) - 4*L*(-2357 + 455*S + 455*S**2)) + 2*b*(11252 - 3759*S - 3646*S**2 + 226*S**3 + 113*S**4 + L*(-3759 + 1552*S + 1477*S**2 - 150*S**3 - 75*S**4) + L*L*(-3646 + 1477*S + 1417*S**2 - 120*S**3 - 60*S**4) + 2*L*L*L*(113 - 75*S - 60*S**2 + 30*S**3 + 15*S**4) + L*L*L*L*(113 - 75*S - 60*S**2 + 30*S**3 + 15*S**4))) + a*a*a*(-180*b**5*(-6 + L + L*L) + 75*b**4*(-85 + 6*L + 6*L*L) + (-2 + S + S**2)*(2526 - 295*S - 295*S**2 + 30*L*(-4 + S + S**2) + 30*L*L*(-4 + S + S**2)) + 2*b**3*(8919 - 580*S - 580*S**2 + 20*L*(-29 + 6*S + 6*S**2) + 20*L*L*(-29 + 6*S + 6*S**2)) + b**2*(-24057 + 4190*S + 4190*S**2 - 30*L*(-43 + 12*S + 12*S**2) - 30*L*L*(-43 + 12*S + 12*S**2)) - 2*b*(10*L*(44 - 24*S - 21*S**2 + 6*S**3 + 3*S**4) + 10*L*L*(44 - 24*S - 21*S**2 + 6*S**3 + 3*S**4) - 3*(2903 - 1077*S - 1037*S**2 + 80*S**3 + 40*S**4))))
	else if(basis2(FLocS) == basis1(FlocS)-4 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+4) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.015625_8*dsqrt((-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2))*(44848 - 7728*L - 7592*L*L + 272*L*L*L + 136*L*L*L*L + 15*b**4*(120 - 26*L - 25*L*L + 2*L*L*L + L*L*L*L) - 20*b**3*(780 - 148*L - 145*L*L + 6*L*L*L + 3*L*L*L*L) - 7728*S + 2060*L*S + 1990*L*L*S - 140*L*L*L*S - 70*L*L*L*L*S - 7592*S**2 + 1990*L*S**2 + 1935*L*L*S**2 - 110*L*L*L*S**2 - 55*L*L*L*L*S**2 + 272*S**3 - 140*L*S**3 - 110*L*L*S**3 + 60*L*L*L*S**3 + 30*L*L*L*L*S**3 + 136*S**4 - 70*L*S**4 - 55*L*L*S**4 + 30*L*L*L*S**4 + 15*L*L*L*L*S**4 + 15*a*a*a*a*(120 - 132*b**3 + 33*b**4 - 26*S - 25*S**2 + 2*S**3 + S**4 - 3*b**2*(-91 + 6*S + 6*S**2) + 6*b*(-47 + 6*S + 6*S**2)) + 20*a*a*a*(780 - 606*b**3 + 99*b**4 - 148*S - 145*S**2 + 6*S**3 + 3*S**4 - 9*b**2*(-161 + 6*S + 6*S**2) + 2*b*(-843 + 89*S + 89*S**2)) + 2*b*(L*(6686 - 920*S - 920*S**2) + L*L*(6571 - 890*S - 890*S**2) + 10*L*L*L*(-23 + 6*S + 6*S**2) + 5*L*L*L*L*(-23 + 6*S + 6*S**2) + 24*(-1630 + 137*S + 137*S**2)) + b**2*(-10*L*L*L*(-35 + 6*S + 6*S**2) - 5*L*L*L*L*(-35 + 6*S + 6*S**2) - 72*(-721 + 20*S + 20*S**2) + L*L*(-9023 + 430*S + 430*S**2) + L*(-9198 + 460*S + 460*S**2)) - 2*a*(-39120 + 45*b**4*(-47 + 6*L + 6*L*L) - 20*b**3*(-843 + 89*L + 89*L*L) + 6686*S + 6571*S**2 - 230*S**3 - 115*S**4 + L*(3288 - 920*S - 890*S**2 + 60*S**3 + 30*S**4) + L*L*(3288 - 920*S - 890*S**2 + 60*S**3 + 30*S**4) + b**2*(-51891 + 1510*S + 1510*S**2 - 10*L*(-469 + 30*S + 30*S**2) - 10*L*L*(-469 + 30*S + 30*S**2)) + 2*b*(36435 - 3134*S - 3134*S**2 + L*(-3134 + 530*S + 530*S**2) + L*L*(-3134 + 530*S + 530*S**2))) + a*a*(180*b**3*(-161 + 6*L + 6*L*L) - 45*b**4*(-91 + 6*L + 6*L*L) - 10*L*(144 - 46*S - 43*S**2 + 6*S**3 + 3*S**4) - 10*L*L*(144 - 46*S - 43*S**2 + 6*S**3 + 3*S**4) + 7*(7416 - 1314*S - 1289*S**2 + 50*S**3 + 25*S**4) + b**2*(10*L*(-259 + 30*S + 30*S**2) + 10*L*L*(-259 + 30*S + 30*S**2) - 7*(-11553 + 370*S + 370*S**2)) - 2*b*(10*L*(-151 + 30*S + 30*S**2) + 10*L*L*(-151 + 30*S + 30*S**2) - 7*(-7413 + 670*S + 670*S**2))))
	else if(basis2(FLocS) == basis1(FlocS)-6 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+6) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*dsqrt((-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2))*(-12296 + 668*L + 668*L*L - 15*b**3*(-40 + 3*L + 3*L*L) + 10*b**2*(-480 + 29*L + 29*L*L) + 668*S - 115*L*S - 115*L*L*S + 668*S**2 - 115*L*S**2 - 115*L*L*S**2 + 5*a*a*a*(-3 + 2*b)*(40 - 33*b + 11*b**2 - 3*S - 3*S**2) + 5*a*a*(-960 - 603*b**2 + 99*b**3 + 58*S + 58*S**2 - 9*b*(-142 + 3*S + 3*S**2)) + 3*b*(5*L*(-47 + 3*S + 3*S**2) + 5*L*L*(-47 + 3*S + 3*S**2) - 16*(-274 + 5*S + 5*S**2)) + a*(45*b**2*(-142 + 3*L + 3*L*L) - 5*b**3*(-179 + 6*L + 6*L*L) - 3*(4384 - 235*S - 235*S**2 + 5*L*(-16 + 3*S + 3*S**2) + 5*L*L*(-16 + 3*S + 3*S**2)) + b*(15683 - 295*S - 295*S**2 + 5*L*(-59 + 6*S + 6*S**2) + 5*L*L*(-59 + 6*S + 6*S**2))))
	else if(basis2(FLocS) == basis1(FlocS)-8 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+8) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*dsqrt((-12 - 7*a - a*a + L + L*L)*(-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2)*(-12 + 7*b - b**2 + S + S**2))*(1546 - 20*L - 20*L*L - 3*b**2*(-50 + L + L*L) + 2*b*(-475 + 6*L + 6*L*L) - 20*S + 3*L*S + 3*L*L*S - 20*S**2 + 3*L*S**2 + 3*L*L*S**2 + a*(950 - 703*b + 132*b**2 - 12*S - 12*S**2) + 3*a*a*(50 - 44*b + 11*b**2 - S - S**2))
	else if(basis2(FLocS) == basis1(FlocS)-10 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+10) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.03125_8*(-55 + 15*b + 3*a*(-5 + 2*b))*dsqrt((-20 - 9*a - a*a + L + L*L)*(-12 - 7*a - a*a + L + L*L)*(-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L)*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2)*(-12 + 7*b - b**2 + S + S**2)*(-20 + 9*b - b**2 + S + S**2))
	else if(basis2(FLocS) == basis1(FlocS)-12 .and. basis2(maxSnum+FlocL) == basis1(maxSnum+FLocL)+12) then
		a = basis1(maxSnum+FLocL)*0.5_8
		b = basis1(FLocS)*0.5_8
		L = twoL(x)*0.5_8
		S = twoS(x)*0.5_8
		Y = 0.015625_8*dsqrt((-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-(a*(1 + a)) + L*(1 + L))*((-3 - a)*(4 + a) + L*(1 + L))*((-4 - a)*(5 + a) + L*(1 + L))*((-5 - a)*(6 + a) + L*(1 + L))*(b - b**2 + S + S**2)*(-2 + 3*b - b**2 + S + S**2)*(-6 + 5*b - b**2 + S + S**2)*(-12 + 7*b - b**2 + S + S**2)*(-20 + 9*b - b**2 + S + S**2)*((6 - b)*(-5 + b) + S*(1 + S)))
	else
		Y = 0.0_8
	end if
	end function SO6
	
	recursive function O20(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,L
	real(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AK"
		! return
	! end if
	Y = 0.0_8
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	if(basis2(b) == basis1(b)) then
		a = basis1(b)*0.5_8
		Y = 3*a*a - L - L*L
	end if
	end function O20
	
	recursive function O21(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AL"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+2) then
		Y = (1 + 2*a)*dsqrt(-a - a*a + L + L*L)
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-2) then
		Y = (-1 + 2*a)*dsqrt(a - a*a + L + L*L)
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.25_8
	end function O21
	
	recursive function O22(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AM"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+4) then
		Y = dsqrt((-a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-4) then
		Y = dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.5_8
	end function O22
	
	recursive function O40(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,L
	real(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AN"
		! return
	! end if
	Y = 0.0_8
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)) then
		Y = 35*a*a*a*a - 5*a*a*(-5 + 6*L + 6*L*L) + 3*L*(-2 - L + 2*L*L + L*L*L)
	end if
	end function O40
	
	recursive function O41(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AO"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+2) then
		Y = (1 + 2*a)*dsqrt(-a - a*a + L + L*L)*(7*a + 7*a*a - 3*(-2 + L + L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-2) then
		Y = (-1 + 2*a)*dsqrt(a - a*a + L + L*L)*(-7*a + 7*a*a - 3*(-2 + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.25_8
	end function O41
	
	recursive function O42(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AP"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+4) then
		Y = (9 + 14*a + 7*a*a - L - L*L)*dsqrt((-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-4) then
		Y = (9 - 14*a + 7*a*a - L - L*L)*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.5_8
	end function O42
	
	recursive function O43(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AQ"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+6) then
		Y = (3 + 2*a)*dsqrt((-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-6) then
		Y = (-3 + 2*a)*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.25_8
	end function O43
	
	recursive function O44(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AR"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+8) then
		Y = dsqrt((-(a*(1 + a)) + L*(1 + L))*((-1 - a)*(2 + a) + L*(1 + L))*((-2 - a)*(3 + a) + L*(1 + L))*((-3 - a)*(4 + a) + L*(1 + L)))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-8) then
		Y = dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.5_8
	end function O44
	
	recursive function O60(x,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	real(kind=8)::a,L
	real(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AS"
		! return
	! end if
	Y = 0.0_8
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)) then
		Y = 294*a*a + 735*a*a*a*a + 231*a*a*a*a*a*a - 60*L - 525*a*a*L - 315*a*a*a*a*L - 20*L*L - 420*a*a*L*L - 315*a*a*a*a*L*L + 75*L*L*L + 210*a*a*L*L*L + 25*L*L*L*L + 105*a*a*L*L*L*L - 15*L*L*L*L*L - 5*L*L*L*L*L*L
	end if
	end function O60
	
	recursive function O61(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AT"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+2) then
		Y = (1 + 2*a)*dsqrt(-a - a*a + L + L*L)*(66*a*a*a + 33*a*a*a*a - 6*a*(-19 + 5*L + 5*L*L) - 3*a*a*(-49 + 10*L + 10*L*L) + 5*(12 - 8*L - 7*L*L + 2*L*L*L + L*L*L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-2) then
		Y = (-1 + 2*a)*dsqrt(a - a*a + L + L*L)*(-66*a*a*a + 33*a*a*a*a + 6*a*(-19 + 5*L + 5*L*L) - 3*a*a*(-49 + 10*L + 10*L*L) + 5*(12 - 8*L - 7*L*L + 2*L*L*L + L*L*L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.25_8
	end function O61
	
	recursive function O62(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AU"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+4) then
		Y = dsqrt((-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L))*(120 + 132*a*a*a + 33*a*a*a*a - 26*L - 25*L*L + 2*L*L*L + L*L*L*L - 3*a*a*(-91 + 6*L + 6*L*L) - 6*a*(-47 + 6*L + 6*L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-4) then
		Y = dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L))*(120 - 132*a*a*a + 33*a*a*a*a - 26*L - 25*L*L + 2*L*L*L + L*L*L*L - 3*a*a*(-91 + 6*L + 6*L*L) + 6*a*(-47 + 6*L + 6*L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.5_8
	end function O62
	
	recursive function O63(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AV"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+6) then
		Y = (3 + 2*a)*(40 + 33*a + 11*a*a - 3*L - 3*L*L)*dsqrt((-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-6) then
		Y = (-3 + 2*a)*(40 - 33*a + 11*a*a - 3*L - 3*L*L)*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.25_8
	end function O63
	
	recursive function O64(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AW"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+8) then
		Y = (50 + 44*a + 11*a*a - L - L*L)*dsqrt((-12 - 7*a - a*a + L + L*L)*(-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-8) then
		Y = (50 - 44*a + 11*a*a - L - L*L)*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.5_8
	end function O64
	
	recursive function O65(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AX"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+10) then
		Y = (5 + 2*a)*dsqrt((-20 - 9*a - a*a + L + L*L)*(-12 - 7*a - a*a + L + L*L)*(-6 - 5*a - a*a + L + L*L)*(-2 - 3*a - a*a + L + L*L)*(-a - a*a + L + L*L))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-10) then
		Y = (-5 + 2*a)*dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L)*(-20 + 9*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.25_8
	end function O65
	
	recursive function O66(x,pm,basis1,basis2,FLocL,FLocS) result(Y)
	implicit none
	integer,intent(in)::x,FLocL,FLocS
	integer,intent(in),dimension(:)::basis1,basis2
	character,intent(in)::pm
	real(kind=8)::a,L
	complex(kind=8)::Y
	integer::b
	! if(return_all) then
		! write(6,*) "AY"
		! return
	! end if
	Y = (0.0_8,0.0_8)
	if(MetalType(x) == 0 .or. MetalType(x) == 1) then
		b = maxSnum+FLocL
		L = twoL(x)*0.5_8
	else if(MetalType(x) == 2) then
		b = FLocS
		L = twoS(x)*0.5_8
	end if
	a = basis1(b)*0.5_8
	if(basis2(b) == basis1(b)+12) then
		Y = dsqrt((-(a*(1 + a)) + L*(1 + L))*((-1 - a)*(2 + a) + L*(1 + L))*((-2 - a)*(3 + a) + L*(1 + L))*((-3 - a)*(4 + a) + L*(1 + L))*((-4 - a)*(5 + a) + L*(1 + L))*((-5 - a)*(6 + a) + L*(1 + L)))
		if(pm == 'm') then
			Y = -Y*(0.0_8,1.0_8)
		end if
	else if(basis2(b) == basis1(b)-12) then
		Y = dsqrt((a - a*a + L + L*L)*(-2 + 3*a - a*a + L + L*L)*(-6 + 5*a - a*a + L + L*L)*(-12 + 7*a - a*a + L + L*L)*(-20 + 9*a - a*a + L + L*L)*(-30 + 11*a - a*a + L + L*L))
		if(pm == 'm') then
			Y = Y*(0.0_8,1.0_8)
		end if
	end if
	Y = Y*0.5_8
	end function O66
	
	recursive function quick_CG(j1,m1,j2,m2,j,m) result(X)
	implicit none
	real(kind=8):: X
	integer,intent(in):: j1,m1,j2,m2,j,m
	! if(return_all) then
		! write(6,*) "AZ"
		! return
	! end if
	X = 0.0_8
	if(j1 == 6 .and. j2 == 1 .and. j == 5) then
		if(m1 ==   -4 .and. m2 ==   -1 .and. m ==   -5) X =   0.37796447300922720_8
		if(m1 ==   -2 .and. m2 ==   -1 .and. m ==   -3) X =   0.53452248382484879_8
		if(m1 ==    0 .and. m2 ==   -1 .and. m ==   -1) X =   0.65465367070797709_8
		if(m1 ==    2 .and. m2 ==   -1 .and. m ==    1) X =   0.75592894601845440_8
		if(m1 ==    4 .and. m2 ==   -1 .and. m ==    3) X =   0.84515425472851646_8
		if(m1 ==    6 .and. m2 ==   -1 .and. m ==    5) X =   0.92582009977255142_8
		if(m1 ==   -6 .and. m2 ==    1 .and. m ==   -5) X =  -0.92582009977255142_8
		if(m1 ==   -4 .and. m2 ==    1 .and. m ==   -3) X =  -0.84515425472851646_8
		if(m1 ==   -2 .and. m2 ==    1 .and. m ==   -1) X =  -0.75592894601845440_8
		if(m1 ==    0 .and. m2 ==    1 .and. m ==    1) X =  -0.65465367070797709_8
		if(m1 ==    2 .and. m2 ==    1 .and. m ==    3) X =  -0.53452248382484879_8
		if(m1 ==    4 .and. m2 ==    1 .and. m ==    5) X =  -0.37796447300922720_8
	else if(j1 == 10 .and. j2 == 2 .and. j == 8) then
		if(m1 ==   -6 .and. m2 ==   -2 .and. m ==   -8) X =   0.13483997249264842_8
		if(m1 ==   -4 .and. m2 ==   -2 .and. m ==   -6) X =   0.23354968324845687_8
		if(m1 ==   -2 .and. m2 ==   -2 .and. m ==   -4) X =   0.33028912953790812_8
		if(m1 ==    0 .and. m2 ==   -2 .and. m ==   -2) X =   0.42640143271122083_8
		if(m1 ==    2 .and. m2 ==   -2 .and. m ==    0) X =   0.52223296786709350_8
		if(m1 ==    4 .and. m2 ==   -2 .and. m ==    2) X =   0.61791438065332460_8
		if(m1 ==    6 .and. m2 ==   -2 .and. m ==    4) X =   0.71350606801267580_8
		if(m1 ==    8 .and. m2 ==   -2 .and. m ==    6) X =   0.80903983495589049_8
		if(m1 ==   10 .and. m2 ==   -2 .and. m ==    8) X =   0.90453403373329089_8
		if(m1 ==   -8 .and. m2 ==    0 .and. m ==   -8) X =  -0.40451991747794525_8
		if(m1 ==   -6 .and. m2 ==    0 .and. m ==   -6) X =  -0.53935988997059370_8
		if(m1 ==   -4 .and. m2 ==    0 .and. m ==   -4) X =  -0.61791438065332460_8
		if(m1 ==   -2 .and. m2 ==    0 .and. m ==   -2) X =  -0.66057825907581624_8
		if(m1 ==    0 .and. m2 ==    0 .and. m ==    0) X =  -0.67419986246324204_8
		if(m1 ==    2 .and. m2 ==    0 .and. m ==    2) X =  -0.66057825907581624_8
		if(m1 ==    4 .and. m2 ==    0 .and. m ==    4) X =  -0.61791438065332460_8
		if(m1 ==    6 .and. m2 ==    0 .and. m ==    6) X =  -0.53935988997059370_8
		if(m1 ==    8 .and. m2 ==    0 .and. m ==    8) X =  -0.40451991747794525_8
		if(m1 ==  -10 .and. m2 ==    2 .and. m ==   -8) X =   0.90453403373329089_8
		if(m1 ==   -8 .and. m2 ==    2 .and. m ==   -6) X =   0.80903983495589049_8
		if(m1 ==   -6 .and. m2 ==    2 .and. m ==   -4) X =   0.71350606801267580_8
		if(m1 ==   -4 .and. m2 ==    2 .and. m ==   -2) X =   0.61791438065332460_8
		if(m1 ==   -2 .and. m2 ==    2 .and. m ==    0) X =   0.52223296786709350_8
		if(m1 ==    0 .and. m2 ==    2 .and. m ==    2) X =   0.42640143271122083_8
		if(m1 ==    2 .and. m2 ==    2 .and. m ==    4) X =   0.33028912953790812_8
		if(m1 ==    4 .and. m2 ==    2 .and. m ==    6) X =   0.23354968324845687_8
		if(m1 ==    6 .and. m2 ==    2 .and. m ==    8) X =   0.13483997249264842_8
	else if(j1 == 12 .and. j2 == 3 .and. j == 9) then
		if(m1 ==   -6 .and. m2 ==   -3 .and. m ==   -9) X =   0.59131239598908258D-1
		if(m1 ==   -4 .and. m2 ==   -3 .and. m ==   -7) X =   0.11826247919781652_8
		if(m1 ==   -2 .and. m2 ==   -3 .and. m ==   -5) X =   0.18698939800169145_8
		if(m1 ==    0 .and. m2 ==   -3 .and. m ==   -3) X =   0.26444294267397256_8
		if(m1 ==    2 .and. m2 ==   -3 .and. m ==   -1) X =   0.34982513114072061_8
		if(m1 ==    4 .and. m2 ==   -3 .and. m ==    1) X =   0.44249767886870978_8
		if(m1 ==    6 .and. m2 ==   -3 .and. m ==    3) X =   0.54194676279713461_8
		if(m1 ==    8 .and. m2 ==   -3 .and. m ==    5) X =   0.64775027563129572_8
		if(m1 ==   10 .and. m2 ==   -3 .and. m ==    7) X =   0.75955452531275003_8
		if(m1 ==   12 .and. m2 ==   -3 .and. m ==    9) X =   0.87705801930702920_8
		if(m1 ==   -8 .and. m2 ==   -1 .and. m ==   -9) X =  -0.18698939800169145_8
		if(m1 ==   -6 .and. m2 ==   -1 .and. m ==   -7) X =  -0.30725493389951353_8
		if(m1 ==   -4 .and. m2 ==   -1 .and. m ==   -5) X =  -0.40967324519935133_8
		if(m1 ==   -2 .and. m2 ==   -1 .and. m ==   -3) X =  -0.49472744491815368_8
		if(m1 ==    0 .and. m2 ==   -1 .and. m ==   -1) X =  -0.56096819400507425_8
		if(m1 ==    2 .and. m2 ==   -1 .and. m ==    1) X =  -0.60591490090017364_8
		if(m1 ==    4 .and. m2 ==   -1 .and. m ==    3) X =  -0.62578621877474383_8
		if(m1 ==    6 .and. m2 ==   -1 .and. m ==    5) X =  -0.61450986779902705_8
		if(m1 ==    8 .and. m2 ==   -1 .and. m ==    7) X =  -0.56096819400507436_8
		if(m1 ==   10 .and. m2 ==   -1 .and. m ==    9) X =  -0.43852900965351460_8
		if(m1 ==  -10 .and. m2 ==    1 .and. m ==   -9) X =   0.43852900965351460_8
		if(m1 ==   -8 .and. m2 ==    1 .and. m ==   -7) X =   0.56096819400507436_8
		if(m1 ==   -6 .and. m2 ==    1 .and. m ==   -5) X =   0.61450986779902705_8
		if(m1 ==   -4 .and. m2 ==    1 .and. m ==   -3) X =   0.62578621877474383_8
		if(m1 ==   -2 .and. m2 ==    1 .and. m ==   -1) X =   0.60591490090017364_8
		if(m1 ==    0 .and. m2 ==    1 .and. m ==    1) X =   0.56096819400507425_8
		if(m1 ==    2 .and. m2 ==    1 .and. m ==    3) X =   0.49472744491815368_8
		if(m1 ==    4 .and. m2 ==    1 .and. m ==    5) X =   0.40967324519935133_8
		if(m1 ==    6 .and. m2 ==    1 .and. m ==    7) X =   0.30725493389951353_8
		if(m1 ==    8 .and. m2 ==    1 .and. m ==    9) X =   0.18698939800169145_8
		if(m1 ==  -12 .and. m2 ==    3 .and. m ==   -9) X =  -0.87705801930702920_8
		if(m1 ==  -10 .and. m2 ==    3 .and. m ==   -7) X =  -0.75955452531275003_8
		if(m1 ==   -8 .and. m2 ==    3 .and. m ==   -5) X =  -0.64775027563129572_8
		if(m1 ==   -6 .and. m2 ==    3 .and. m ==   -3) X =  -0.54194676279713461_8
		if(m1 ==   -4 .and. m2 ==    3 .and. m ==   -1) X =  -0.44249767886870978_8
		if(m1 ==   -2 .and. m2 ==    3 .and. m ==    1) X =  -0.34982513114072061_8
		if(m1 ==    0 .and. m2 ==    3 .and. m ==    3) X =  -0.26444294267397256_8
		if(m1 ==    2 .and. m2 ==    3 .and. m ==    5) X =  -0.18698939800169145_8
		if(m1 ==    4 .and. m2 ==    3 .and. m ==    7) X =  -0.11826247919781652_8
		if(m1 ==    6 .and. m2 ==    3 .and. m ==    9) X =  -0.59131239598908258D-1
	else if(j1 == 12 .and. j2 == 4 .and. j == 8) then
		if(m1 ==   -4 .and. m2 ==   -4 .and. m ==   -8) X =   0.37397879600338288D-1
		if(m1 ==   -2 .and. m2 ==   -4 .and. m ==   -6) X =   0.83624201000709081D-1
		if(m1 ==    0 .and. m2 ==   -4 .and. m ==   -4) X =   0.14484136487558025_8
		if(m1 ==    2 .and. m2 ==   -4 .and. m ==   -2) X =   0.22124883943435489_8
		if(m1 ==    4 .and. m2 ==   -4 .and. m ==    0) X =   0.31289310938737197_8
		if(m1 ==    6 .and. m2 ==   -4 .and. m ==    2) X =   0.41979015736886471_8
		if(m1 ==    8 .and. m2 ==   -4 .and. m ==    4) X =   0.54194676279713461_8
		if(m1 ==   10 .and. m2 ==   -4 .and. m ==    6) X =   0.67936622048675743_8
		if(m1 ==   12 .and. m2 ==   -4 .and. m ==    8) X =   0.83205029433784372_8
		if(m1 ==   -6 .and. m2 ==   -2 .and. m ==   -8) X =  -0.11219363880101486_8
		if(m1 ==   -4 .and. m2 ==   -2 .and. m ==   -6) X =  -0.21155435413917803_8
		if(m1 ==   -2 .and. m2 ==   -2 .and. m ==   -4) X =  -0.31289310938737191_8
		if(m1 ==    0 .and. m2 ==   -2 .and. m ==   -2) X =  -0.40967324519935128_8
		if(m1 ==    2 .and. m2 ==   -2 .and. m ==    0) X =  -0.49472744491815368_8
		if(m1 ==    4 .and. m2 ==   -2 .and. m ==    2) X =  -0.55972020982515303_8
		if(m1 ==    6 .and. m2 ==   -2 .and. m ==    4) X =  -0.59367293390178433_8
		if(m1 ==    8 .and. m2 ==   -2 .and. m ==    6) X =  -0.57936545950232110_8
		if(m1 ==   10 .and. m2 ==   -2 .and. m ==    8) X =  -0.48038446141526137_8
		if(m1 ==   -8 .and. m2 ==    0 .and. m ==   -8) X =   0.25087260300212721_8
		if(m1 ==   -6 .and. m2 ==    0 .and. m ==   -6) X =   0.38865016537877739_8
		if(m1 ==   -4 .and. m2 ==    0 .and. m ==   -4) X =   0.48473192072013882_8
		if(m1 ==   -2 .and. m2 ==    0 .and. m ==   -2) X =   0.54194676279713461_8
		if(m1 ==    0 .and. m2 ==    0 .and. m ==    0) X =   0.56096819400507425_8
		if(m1 ==    2 .and. m2 ==    0 .and. m ==    2) X =   0.54194676279713461_8
		if(m1 ==    4 .and. m2 ==    0 .and. m ==    4) X =   0.48473192072013882_8
		if(m1 ==    6 .and. m2 ==    0 .and. m ==    6) X =   0.38865016537877739_8
		if(m1 ==    8 .and. m2 ==    0 .and. m ==    8) X =   0.25087260300212721_8
		if(m1 ==  -10 .and. m2 ==    2 .and. m ==   -8) X =  -0.48038446141526137_8
		if(m1 ==   -8 .and. m2 ==    2 .and. m ==   -6) X =  -0.57936545950232110_8
		if(m1 ==   -6 .and. m2 ==    2 .and. m ==   -4) X =  -0.59367293390178433_8
		if(m1 ==   -4 .and. m2 ==    2 .and. m ==   -2) X =  -0.55972020982515303_8
		if(m1 ==   -2 .and. m2 ==    2 .and. m ==    0) X =  -0.49472744491815368_8
		if(m1 ==    0 .and. m2 ==    2 .and. m ==    2) X =  -0.40967324519935128_8
		if(m1 ==    2 .and. m2 ==    2 .and. m ==    4) X =  -0.31289310938737191_8
		if(m1 ==    4 .and. m2 ==    2 .and. m ==    6) X =  -0.21155435413917803_8
		if(m1 ==    6 .and. m2 ==    2 .and. m ==    8) X =  -0.11219363880101486_8
		if(m1 ==  -12 .and. m2 ==    4 .and. m ==   -8) X =   0.83205029433784372_8
		if(m1 ==  -10 .and. m2 ==    4 .and. m ==   -6) X =   0.67936622048675743_8
		if(m1 ==   -8 .and. m2 ==    4 .and. m ==   -4) X =   0.54194676279713461_8
		if(m1 ==   -6 .and. m2 ==    4 .and. m ==   -2) X =   0.41979015736886471_8
		if(m1 ==   -4 .and. m2 ==    4 .and. m ==    0) X =   0.31289310938737197_8
		if(m1 ==   -2 .and. m2 ==    4 .and. m ==    2) X =   0.22124883943435489_8
		if(m1 ==    0 .and. m2 ==    4 .and. m ==    4) X =   0.14484136487558025_8
		if(m1 ==    2 .and. m2 ==    4 .and. m ==    6) X =   0.83624201000709081D-1
		if(m1 ==    4 .and. m2 ==    4 .and. m ==    8) X =   0.37397879600338288D-1
	else if(j1 == 10 .and. j2 == 5 .and. j == 5) then
		if(m1 ==    0 .and. m2 ==   -5 .and. m ==   -5) X =   0.46524210519923545D-1
		if(m1 ==    2 .and. m2 ==   -5 .and. m ==   -3) X =   0.11396057645963796_8
		if(m1 ==    4 .and. m2 ==   -5 .and. m ==   -1) X =   0.21320071635561044_8
		if(m1 ==    6 .and. m2 ==   -5 .and. m ==    1) X =   0.34815531191139565_8
		if(m1 ==    8 .and. m2 ==   -5 .and. m ==    3) X =   0.52223296786709350_8
		if(m1 ==   10 .and. m2 ==   -5 .and. m ==    5) X =   0.73854894587599640_8
		if(m1 ==   -2 .and. m2 ==   -3 .and. m ==   -5) X =  -0.11396057645963796_8
		if(m1 ==    0 .and. m2 ==   -3 .and. m ==   -3) X =  -0.23262105259961771_8
		if(m1 ==    2 .and. m2 ==   -3 .and. m ==   -1) X =  -0.36037498507822358_8
		if(m1 ==    4 .and. m2 ==   -3 .and. m ==    1) X =  -0.47673129462279618_8
		if(m1 ==    6 .and. m2 ==   -3 .and. m ==    3) X =  -0.55048188256318020_8
		if(m1 ==    8 .and. m2 ==   -3 .and. m ==    5) X =  -0.52223296786709350_8
		if(m1 ==   -4 .and. m2 ==   -1 .and. m ==   -5) X =   0.21320071635561044_8
		if(m1 ==   -2 .and. m2 ==   -1 .and. m ==   -3) X =   0.36037498507822358_8
		if(m1 ==    0 .and. m2 ==   -1 .and. m ==   -1) X =   0.46524210519923542_8
		if(m1 ==    2 .and. m2 ==   -1 .and. m ==    1) X =   0.50964719143762549_8
		if(m1 ==    4 .and. m2 ==   -1 .and. m ==    3) X =   0.47673129462279618_8
		if(m1 ==    6 .and. m2 ==   -1 .and. m ==    5) X =   0.34815531191139565_8
		if(m1 ==   -6 .and. m2 ==    1 .and. m ==   -5) X =  -0.34815531191139565_8
		if(m1 ==   -4 .and. m2 ==    1 .and. m ==   -3) X =  -0.47673129462279618_8
		if(m1 ==   -2 .and. m2 ==    1 .and. m ==   -1) X =  -0.50964719143762549_8
		if(m1 ==    0 .and. m2 ==    1 .and. m ==    1) X =  -0.46524210519923542_8
		if(m1 ==    2 .and. m2 ==    1 .and. m ==    3) X =  -0.36037498507822358_8
		if(m1 ==    4 .and. m2 ==    1 .and. m ==    5) X =  -0.21320071635561044_8
		if(m1 ==   -8 .and. m2 ==    3 .and. m ==   -5) X =   0.52223296786709350_8
		if(m1 ==   -6 .and. m2 ==    3 .and. m ==   -3) X =   0.55048188256318020_8
		if(m1 ==   -4 .and. m2 ==    3 .and. m ==   -1) X =   0.47673129462279618_8
		if(m1 ==   -2 .and. m2 ==    3 .and. m ==    1) X =   0.36037498507822358_8
		if(m1 ==    0 .and. m2 ==    3 .and. m ==    3) X =   0.23262105259961771_8
		if(m1 ==    2 .and. m2 ==    3 .and. m ==    5) X =   0.11396057645963796_8
		if(m1 ==  -10 .and. m2 ==    5 .and. m ==   -5) X =  -0.73854894587599640_8
		if(m1 ==   -8 .and. m2 ==    5 .and. m ==   -3) X =  -0.52223296786709350_8
		if(m1 ==   -6 .and. m2 ==    5 .and. m ==   -1) X =  -0.34815531191139565_8
		if(m1 ==   -4 .and. m2 ==    5 .and. m ==    1) X =  -0.21320071635561044_8
		if(m1 ==   -2 .and. m2 ==    5 .and. m ==    3) X =  -0.11396057645963796_8
		if(m1 ==    0 .and. m2 ==    5 .and. m ==    5) X =  -0.46524210519923545D-1
	else if(j1 == 6 .and. j2 == 6 .and. j == 12) then
		if(m1 ==   -6 .and. m2 ==   -6 .and. m ==  -12) X =   1.0_8
		if(m1 ==   -4 .and. m2 ==   -6 .and. m ==  -10) X =   0.70710678118654746_8
		if(m1 ==   -2 .and. m2 ==   -6 .and. m ==   -8) X =   0.47673129462279612_8
		if(m1 ==    0 .and. m2 ==   -6 .and. m ==   -6) X =   0.30151134457776363_8
		if(m1 ==    2 .and. m2 ==   -6 .and. m ==   -4) X =   0.17407765595569782_8
		if(m1 ==    4 .and. m2 ==   -6 .and. m ==   -2) X =   0.87038827977848912D-1
		if(m1 ==    6 .and. m2 ==   -6 .and. m ==    0) X =   0.32897584747988450D-1
		if(m1 ==   -6 .and. m2 ==   -4 .and. m ==  -10) X =   0.70710678118654746_8
		if(m1 ==   -4 .and. m2 ==   -4 .and. m ==   -8) X =   0.73854894587599640_8
		if(m1 ==   -2 .and. m2 ==   -4 .and. m ==   -6) X =   0.63960214906683133_8
		if(m1 ==    0 .and. m2 ==   -4 .and. m ==   -4) X =   0.49236596391733090_8
		if(m1 ==    2 .and. m2 ==   -4 .and. m ==   -2) X =   0.33709993123162107_8
		if(m1 ==    4 .and. m2 ==   -4 .and. m ==    0) X =   0.19738550848793068_8
		if(m1 ==    6 .and. m2 ==   -4 .and. m ==    2) X =   0.87038827977848912D-1
		if(m1 ==   -6 .and. m2 ==   -2 .and. m ==   -8) X =   0.47673129462279612_8
		if(m1 ==   -4 .and. m2 ==   -2 .and. m ==   -6) X =   0.63960214906683133_8
		if(m1 ==   -2 .and. m2 ==   -2 .and. m ==   -4) X =   0.67419986246324204_8
		if(m1 ==    0 .and. m2 ==   -2 .and. m ==   -2) X =   0.61545745489666381_8
		if(m1 ==    2 .and. m2 ==   -2 .and. m ==    0) X =   0.49346377121982676_8
		if(m1 ==    4 .and. m2 ==   -2 .and. m ==    2) X =   0.33709993123162102_8
		if(m1 ==    6 .and. m2 ==   -2 .and. m ==    4) X =   0.17407765595569782_8
		if(m1 ==   -6 .and. m2 ==    0 .and. m ==   -6) X =   0.30151134457776363_8
		if(m1 ==   -4 .and. m2 ==    0 .and. m ==   -4) X =   0.49236596391733090_8
		if(m1 ==   -2 .and. m2 ==    0 .and. m ==   -2) X =   0.61545745489666359_8
		if(m1 ==    0 .and. m2 ==    0 .and. m ==    0) X =   0.65795169495976891_8
		if(m1 ==    2 .and. m2 ==    0 .and. m ==    2) X =   0.61545745489666359_8
		if(m1 ==    4 .and. m2 ==    0 .and. m ==    4) X =   0.49236596391733090_8
		if(m1 ==    6 .and. m2 ==    0 .and. m ==    6) X =   0.30151134457776363_8
		if(m1 ==   -6 .and. m2 ==    2 .and. m ==   -4) X =   0.17407765595569782_8
		if(m1 ==   -4 .and. m2 ==    2 .and. m ==   -2) X =   0.33709993123162102_8
		if(m1 ==   -2 .and. m2 ==    2 .and. m ==    0) X =   0.49346377121982676_8
		if(m1 ==    0 .and. m2 ==    2 .and. m ==    2) X =   0.61545745489666381_8
		if(m1 ==    2 .and. m2 ==    2 .and. m ==    4) X =   0.67419986246324204_8
		if(m1 ==    4 .and. m2 ==    2 .and. m ==    6) X =   0.63960214906683133_8
		if(m1 ==    6 .and. m2 ==    2 .and. m ==    8) X =   0.47673129462279612_8
		if(m1 ==   -6 .and. m2 ==    4 .and. m ==   -2) X =   0.87038827977848912D-1
		if(m1 ==   -4 .and. m2 ==    4 .and. m ==    0) X =   0.19738550848793068_8
		if(m1 ==   -2 .and. m2 ==    4 .and. m ==    2) X =   0.33709993123162107_8
		if(m1 ==    0 .and. m2 ==    4 .and. m ==    4) X =   0.49236596391733090_8
		if(m1 ==    2 .and. m2 ==    4 .and. m ==    6) X =   0.63960214906683133_8
		if(m1 ==    4 .and. m2 ==    4 .and. m ==    8) X =   0.73854894587599640_8
		if(m1 ==    6 .and. m2 ==    4 .and. m ==   10) X =   0.70710678118654746_8
		if(m1 ==   -6 .and. m2 ==    6 .and. m ==    0) X =   0.32897584747988450D-1
		if(m1 ==   -4 .and. m2 ==    6 .and. m ==    2) X =   0.87038827977848912D-1
		if(m1 ==   -2 .and. m2 ==    6 .and. m ==    4) X =   0.17407765595569782_8
		if(m1 ==    0 .and. m2 ==    6 .and. m ==    6) X =   0.30151134457776363_8
		if(m1 ==    2 .and. m2 ==    6 .and. m ==    8) X =   0.47673129462279612_8
		if(m1 ==    4 .and. m2 ==    6 .and. m ==   10) X =   0.70710678118654746_8
		if(m1 ==    6 .and. m2 ==    6 .and. m ==   12) X =   1.0_8
	else if(j1 == 10 .and. j2 == 5 .and. j == 15) then
		if(m1 ==  -10 .and. m2 ==   -5 .and. m ==  -15) X =   1.0_8
		if(m1 ==   -8 .and. m2 ==   -5 .and. m ==  -13) X =   0.81649658092772603_8
		if(m1 ==   -6 .and. m2 ==   -5 .and. m ==  -11) X =   0.65465367070797720_8
		if(m1 ==   -4 .and. m2 ==   -5 .and. m ==   -9) X =   0.51355259101309547_8
		if(m1 ==   -2 .and. m2 ==   -5 .and. m ==   -7) X =   0.39223227027636809_8
		if(m1 ==    0 .and. m2 ==   -5 .and. m ==   -5) X =   0.28968272975116055_8
		if(m1 ==    2 .and. m2 ==   -5 .and. m ==   -3) X =   0.20483662259967569_8
		if(m1 ==    4 .and. m2 ==   -5 .and. m ==   -1) X =   0.13655774839978377_8
		if(m1 ==    6 .and. m2 ==   -5 .and. m ==    1) X =   0.83624201000709081D-1
		if(m1 ==    8 .and. m2 ==   -5 .and. m ==    3) X =   0.44699015626767410D-1
		if(m1 ==   10 .and. m2 ==   -5 .and. m ==    5) X =   0.18248296715045298D-1
		if(m1 ==  -10 .and. m2 ==   -3 .and. m ==  -13) X =   0.57735026918962584_8
		if(m1 ==   -8 .and. m2 ==   -3 .and. m ==  -11) X =   0.69006555934235425_8
		if(m1 ==   -6 .and. m2 ==   -3 .and. m ==   -9) X =   0.70321084640774312_8
		if(m1 ==   -4 .and. m2 ==   -3 .and. m ==   -7) X =   0.66299354413179579_8
		if(m1 ==   -2 .and. m2 ==   -3 .and. m ==   -5) X =   0.59131239598908258_8
		if(m1 ==    0 .and. m2 ==   -3 .and. m ==   -3) X =   0.50174520600425454_8
		if(m1 ==    2 .and. m2 ==   -3 .and. m ==   -1) X =   0.40394326726678237_8
		if(m1 ==    4 .and. m2 ==   -3 .and. m ==    1) X =   0.30535240827622967_8
		if(m1 ==    6 .and. m2 ==   -3 .and. m ==    3) X =   0.21202604782206583_8
		if(m1 ==    8 .and. m2 ==   -3 .and. m ==    5) X =   0.12903494352312730_8
		if(m1 ==   10 .and. m2 ==   -3 .and. m ==    7) X =   0.60522753266880253D-1
		if(m1 ==  -10 .and. m2 ==   -1 .and. m ==  -11) X =   0.30860669992418382_8
		if(m1 ==   -8 .and. m2 ==   -1 .and. m ==   -9) X =   0.46880723093849541_8
		if(m1 ==   -6 .and. m2 ==   -1 .and. m ==   -7) X =   0.57416925176321454_8
		if(m1 ==   -4 .and. m2 ==   -1 .and. m ==   -5) X =   0.63213954124101401_8
		if(m1 ==   -2 .and. m2 ==   -1 .and. m ==   -3) X =   0.64775027563129584_8
		if(m1 ==    0 .and. m2 ==   -1 .and. m ==   -1) X =   0.62578621877474394_8
		if(m1 ==    2 .and. m2 ==   -1 .and. m ==    1) X =   0.57126204699798355_8
		if(m1 ==    4 .and. m2 ==   -1 .and. m ==    3) X =   0.48965318314112866_8
		if(m1 ==    6 .and. m2 ==   -1 .and. m ==    5) X =   0.38710483056938189_8
		if(m1 ==    8 .and. m2 ==   -1 .and. m ==    7) X =   0.27066598098038341_8
		if(m1 ==   10 .and. m2 ==   -1 .and. m ==    9) X =   0.14824986333222023_8
		if(m1 ==  -10 .and. m2 ==    1 .and. m ==   -9) X =   0.14824986333222023_8
		if(m1 ==   -8 .and. m2 ==    1 .and. m ==   -7) X =   0.27066598098038341_8
		if(m1 ==   -6 .and. m2 ==    1 .and. m ==   -5) X =   0.38710483056938189_8
		if(m1 ==   -4 .and. m2 ==    1 .and. m ==   -3) X =   0.48965318314112877_8
		if(m1 ==   -2 .and. m2 ==    1 .and. m ==   -1) X =   0.57126204699798355_8
		if(m1 ==    0 .and. m2 ==    1 .and. m ==    1) X =   0.62578621877474394_8
		if(m1 ==    2 .and. m2 ==    1 .and. m ==    3) X =   0.64775027563129561_8
		if(m1 ==    4 .and. m2 ==    1 .and. m ==    5) X =   0.63213954124101401_8
		if(m1 ==    6 .and. m2 ==    1 .and. m ==    7) X =   0.57416925176321465_8
		if(m1 ==    8 .and. m2 ==    1 .and. m ==    9) X =   0.46880723093849541_8
		if(m1 ==   10 .and. m2 ==    1 .and. m ==   11) X =   0.30860669992418382_8
		if(m1 ==  -10 .and. m2 ==    3 .and. m ==   -7) X =   0.60522753266880239D-1
		if(m1 ==   -8 .and. m2 ==    3 .and. m ==   -5) X =   0.12903494352312730_8
		if(m1 ==   -6 .and. m2 ==    3 .and. m ==   -3) X =   0.21202604782206588_8
		if(m1 ==   -4 .and. m2 ==    3 .and. m ==   -1) X =   0.30535240827622967_8
		if(m1 ==   -2 .and. m2 ==    3 .and. m ==    1) X =   0.40394326726678237_8
		if(m1 ==    0 .and. m2 ==    3 .and. m ==    3) X =   0.50174520600425443_8
		if(m1 ==    2 .and. m2 ==    3 .and. m ==    5) X =   0.59131239598908258_8
		if(m1 ==    4 .and. m2 ==    3 .and. m ==    7) X =   0.66299354413179601_8
		if(m1 ==    6 .and. m2 ==    3 .and. m ==    9) X =   0.70321084640774312_8
		if(m1 ==    8 .and. m2 ==    3 .and. m ==   11) X =   0.69006555934235425_8
		if(m1 ==   10 .and. m2 ==    3 .and. m ==   13) X =   0.57735026918962584_8
		if(m1 ==  -10 .and. m2 ==    5 .and. m ==   -5) X =   0.18248296715045298D-1
		if(m1 ==   -8 .and. m2 ==    5 .and. m ==   -3) X =   0.44699015626767424D-1
		if(m1 ==   -6 .and. m2 ==    5 .and. m ==   -1) X =   0.83624201000709081D-1
		if(m1 ==   -4 .and. m2 ==    5 .and. m ==    1) X =   0.13655774839978380_8
		if(m1 ==   -2 .and. m2 ==    5 .and. m ==    3) X =   0.20483662259967564_8
		if(m1 ==    0 .and. m2 ==    5 .and. m ==    5) X =   0.28968272975116055_8
		if(m1 ==    2 .and. m2 ==    5 .and. m ==    7) X =   0.39223227027636814_8
		if(m1 ==    4 .and. m2 ==    5 .and. m ==    9) X =   0.51355259101309547_8
		if(m1 ==    6 .and. m2 ==    5 .and. m ==   11) X =   0.65465367070797720_8
		if(m1 ==    8 .and. m2 ==    5 .and. m ==   13) X =   0.81649658092772603_8
		if(m1 ==   10 .and. m2 ==    5 .and. m ==   15) X =   1.0_8
	else if(j1 == 12 .and. j2 == 4 .and. j == 16) then
		if(m1 ==  -12 .and. m2 ==   -4 .and. m ==  -16) X =   1.0_8
		if(m1 ==  -10 .and. m2 ==   -4 .and. m ==  -14) X =   0.86602540378443860_8
		if(m1 ==   -8 .and. m2 ==   -4 .and. m ==  -12) X =   0.74161984870956632_8
		if(m1 ==   -6 .and. m2 ==   -4 .and. m ==  -10) X =   0.62678317052800880_8
		if(m1 ==   -4 .and. m2 ==   -4 .and. m ==   -8) X =   0.52151512152383650_8
		if(m1 ==   -2 .and. m2 ==   -4 .and. m ==   -6) X =   0.42581531362632008_8
		if(m1 ==    0 .and. m2 ==   -4 .and. m ==   -4) X =   0.33968311024337872_8
		if(m1 ==    2 .and. m2 ==   -4 .and. m ==   -2) X =   0.26311740579210879_8
		if(m1 ==    4 .and. m2 ==   -4 .and. m ==    0) X =   0.19611613513818404_8
		if(m1 ==    6 .and. m2 ==   -4 .and. m ==    2) X =   0.13867504905630729_8
		if(m1 ==    8 .and. m2 ==   -4 .and. m ==    4) X =   0.90784129900320351D-1
		if(m1 ==   10 .and. m2 ==   -4 .and. m ==    6) X =   0.52414241836095915D-1
		if(m1 ==   12 .and. m2 ==   -4 .and. m ==    8) X =   0.23440361546924773D-1
		if(m1 ==  -12 .and. m2 ==   -2 .and. m ==  -14) X =   0.50000000000000000_8
		if(m1 ==  -10 .and. m2 ==   -2 .and. m ==  -12) X =   0.63245553203367588_8
		if(m1 ==   -8 .and. m2 ==   -2 .and. m ==  -10) X =   0.68660656232559514_8
		if(m1 ==   -6 .and. m2 ==   -2 .and. m ==   -8) X =   0.69535349536511537_8
		if(m1 ==   -4 .and. m2 ==   -2 .and. m ==   -6) X =   0.67327312681905194_8
		if(m1 ==   -2 .and. m2 ==   -2 .and. m ==   -4) X =   0.62897090203315098_8
		if(m1 ==    0 .and. m2 ==   -2 .and. m ==   -2) X =   0.56839856005880518_8
		if(m1 ==    2 .and. m2 ==   -2 .and. m ==    0) X =   0.49613893835683387_8
		if(m1 ==    4 .and. m2 ==   -2 .and. m ==    2) X =   0.41602514716892192_8
		if(m1 ==    6 .and. m2 ==   -2 .and. m ==    4) X =   0.33149677206589789_8
		if(m1 ==    8 .and. m2 ==   -2 .and. m ==    6) X =   0.24584458594722081_8
		if(m1 ==   10 .and. m2 ==   -2 .and. m ==    8) X =   0.16239958858823006_8
		if(m1 ==   12 .and. m2 ==   -2 .and. m ==   10) X =   0.84515425472851652D-1
		if(m1 ==  -12 .and. m2 ==    0 .and. m ==  -12) X =   0.22360679774997894_8
		if(m1 ==  -10 .and. m2 ==    0 .and. m ==  -10) X =   0.35856858280031811_8
		if(m1 ==   -8 .and. m2 ==    0 .and. m ==   -8) X =   0.46645730520854495_8
		if(m1 ==   -6 .and. m2 ==    0 .and. m ==   -6) X =   0.54972520607827524_8
		if(m1 ==   -4 .and. m2 ==    0 .and. m ==   -4) X =   0.60899845720586265_8
		if(m1 ==   -2 .and. m2 ==    0 .and. m ==   -2) X =   0.64450338663548967_8
		if(m1 ==    0 .and. m2 ==    0 .and. m ==    0) X =   0.65633012331389362_8
		if(m1 ==    2 .and. m2 ==    0 .and. m ==    2) X =   0.64450338663548967_8
		if(m1 ==    4 .and. m2 ==    0 .and. m ==    4) X =   0.60899845720586254_8
		if(m1 ==    6 .and. m2 ==    0 .and. m ==    6) X =   0.54972520607827524_8
		if(m1 ==    8 .and. m2 ==    0 .and. m ==    8) X =   0.46645730520854495_8
		if(m1 ==   10 .and. m2 ==    0 .and. m ==   10) X =   0.35856858280031811_8
		if(m1 ==   12 .and. m2 ==    0 .and. m ==   12) X =   0.22360679774997899_8
		if(m1 ==  -12 .and. m2 ==    2 .and. m ==  -10) X =   0.84515425472851652D-1
		if(m1 ==  -10 .and. m2 ==    2 .and. m ==   -8) X =   0.16239958858823003_8
		if(m1 ==   -8 .and. m2 ==    2 .and. m ==   -6) X =   0.24584458594722081_8
		if(m1 ==   -6 .and. m2 ==    2 .and. m ==   -4) X =   0.33149677206589795_8
		if(m1 ==   -4 .and. m2 ==    2 .and. m ==   -2) X =   0.41602514716892192_8
		if(m1 ==   -2 .and. m2 ==    2 .and. m ==    0) X =   0.49613893835683387_8
		if(m1 ==    0 .and. m2 ==    2 .and. m ==    2) X =   0.56839856005880518_8
		if(m1 ==    2 .and. m2 ==    2 .and. m ==    4) X =   0.62897090203315098_8
		if(m1 ==    4 .and. m2 ==    2 .and. m ==    6) X =   0.67327312681905194_8
		if(m1 ==    6 .and. m2 ==    2 .and. m ==    8) X =   0.69535349536511548_8
		if(m1 ==    8 .and. m2 ==    2 .and. m ==   10) X =   0.68660656232559514_8
		if(m1 ==   10 .and. m2 ==    2 .and. m ==   12) X =   0.63245553203367599_8
		if(m1 ==   12 .and. m2 ==    2 .and. m ==   14) X =   0.50000000000000000_8
		if(m1 ==  -12 .and. m2 ==    4 .and. m ==   -8) X =   0.23440361546924773D-1
		if(m1 ==  -10 .and. m2 ==    4 .and. m ==   -6) X =   0.52414241836095915D-1
		if(m1 ==   -8 .and. m2 ==    4 .and. m ==   -4) X =   0.90784129900320365D-1
		if(m1 ==   -6 .and. m2 ==    4 .and. m ==   -2) X =   0.13867504905630729_8
		if(m1 ==   -4 .and. m2 ==    4 .and. m ==    0) X =   0.19611613513818404_8
		if(m1 ==   -2 .and. m2 ==    4 .and. m ==    2) X =   0.26311740579210879_8
		if(m1 ==    0 .and. m2 ==    4 .and. m ==    4) X =   0.33968311024337866_8
		if(m1 ==    2 .and. m2 ==    4 .and. m ==    6) X =   0.42581531362632008_8
		if(m1 ==    4 .and. m2 ==    4 .and. m ==    8) X =   0.52151512152383650_8
		if(m1 ==    6 .and. m2 ==    4 .and. m ==   10) X =   0.62678317052800880_8
		if(m1 ==    8 .and. m2 ==    4 .and. m ==   12) X =   0.74161984870956632_8
		if(m1 ==   10 .and. m2 ==    4 .and. m ==   14) X =   0.86602540378443860_8
		if(m1 ==   12 .and. m2 ==    4 .and. m ==   16) X =   1.0_8
	else if(j1 == 12 .and. j2 == 3 .and. j == 15) then
		if(m1 ==  -12 .and. m2 ==   -3 .and. m ==  -15) X =   1.0_8
		if(m1 ==  -10 .and. m2 ==   -3 .and. m ==  -13) X =   0.89442719099991574_8
		if(m1 ==   -8 .and. m2 ==   -3 .and. m ==  -11) X =   0.79282496717209194_8
		if(m1 ==   -6 .and. m2 ==   -3 .and. m ==   -9) X =   0.69535349536511537_8
		if(m1 ==   -4 .and. m2 ==   -3 .and. m ==   -7) X =   0.60219379159649489_8
		if(m1 ==   -2 .and. m2 ==   -3 .and. m ==   -5) X =   0.51355259101309547_8
		if(m1 ==    0 .and. m2 ==   -3 .and. m ==   -3) X =   0.42966892442365978_8
		if(m1 ==    2 .and. m2 ==   -3 .and. m ==   -1) X =   0.35082320772281173_8
		if(m1 ==    4 .and. m2 ==   -3 .and. m ==    1) X =   0.27735009811261457_8
		if(m1 ==    6 .and. m2 ==   -3 .and. m ==    3) X =   0.20965696734438363_8
		if(m1 ==    8 .and. m2 ==   -3 .and. m ==    5) X =   0.14824986333222023_8
		if(m1 ==   10 .and. m2 ==   -3 .and. m ==    7) X =   0.93761446187699105D-1
		if(m1 ==   12 .and. m2 ==   -3 .and. m ==    9) X =   0.46880723093849545D-1
		if(m1 ==  -12 .and. m2 ==   -1 .and. m ==  -13) X =   0.44721359549995787_8
		if(m1 ==  -10 .and. m2 ==   -1 .and. m ==  -11) X =   0.58554004376911983_8
		if(m1 ==   -8 .and. m2 ==   -1 .and. m ==   -9) X =   0.65967024729393042_8
		if(m1 ==   -6 .and. m2 ==   -1 .and. m ==   -7) X =   0.69535349536511537_8
		if(m1 ==   -4 .and. m2 ==   -1 .and. m ==   -5) X =   0.70321084640774312_8
		if(m1 ==   -2 .and. m2 ==   -1 .and. m ==   -3) X =   0.68900310211585758_8
		if(m1 ==    0 .and. m2 ==   -1 .and. m ==   -1) X =   0.65633012331389362_8
		if(m1 ==    2 .and. m2 ==   -1 .and. m ==    1) X =   0.60764362025020002_8
		if(m1 ==    4 .and. m2 ==   -1 .and. m ==    3) X =   0.54470477940192208_8
		if(m1 ==    6 .and. m2 ==   -1 .and. m ==    5) X =   0.46880723093849547_8
		if(m1 ==    8 .and. m2 ==   -1 .and. m ==    7) X =   0.38086079485153773_8
		if(m1 ==   10 .and. m2 ==   -1 .and. m ==    9) X =   0.28128433856309720_8
		if(m1 ==   12 .and. m2 ==   -1 .and. m ==   11) X =   0.16903085094570333_8
		if(m1 ==  -12 .and. m2 ==    1 .and. m ==  -11) X =   0.16903085094570333_8
		if(m1 ==  -10 .and. m2 ==    1 .and. m ==   -9) X =   0.28128433856309720_8
		if(m1 ==   -8 .and. m2 ==    1 .and. m ==   -7) X =   0.38086079485153768_8
		if(m1 ==   -6 .and. m2 ==    1 .and. m ==   -5) X =   0.46880723093849547_8
		if(m1 ==   -4 .and. m2 ==    1 .and. m ==   -3) X =   0.54470477940192230_8
		if(m1 ==   -2 .and. m2 ==    1 .and. m ==   -1) X =   0.60764362025019991_8
		if(m1 ==    0 .and. m2 ==    1 .and. m ==    1) X =   0.65633012331389373_8
		if(m1 ==    2 .and. m2 ==    1 .and. m ==    3) X =   0.68900310211585747_8
		if(m1 ==    4 .and. m2 ==    1 .and. m ==    5) X =   0.70321084640774312_8
		if(m1 ==    6 .and. m2 ==    1 .and. m ==    7) X =   0.69535349536511537_8
		if(m1 ==    8 .and. m2 ==    1 .and. m ==    9) X =   0.65967024729393042_8
		if(m1 ==   10 .and. m2 ==    1 .and. m ==   11) X =   0.58554004376911983_8
		if(m1 ==   12 .and. m2 ==    1 .and. m ==   13) X =   0.44721359549995787_8
		if(m1 ==  -12 .and. m2 ==    3 .and. m ==   -9) X =   0.46880723093849545D-1
		if(m1 ==  -10 .and. m2 ==    3 .and. m ==   -7) X =   0.93761446187699077D-1
		if(m1 ==   -8 .and. m2 ==    3 .and. m ==   -5) X =   0.14824986333222023_8
		if(m1 ==   -6 .and. m2 ==    3 .and. m ==   -3) X =   0.20965696734438366_8
		if(m1 ==   -4 .and. m2 ==    3 .and. m ==   -1) X =   0.27735009811261457_8
		if(m1 ==   -2 .and. m2 ==    3 .and. m ==    1) X =   0.35082320772281173_8
		if(m1 ==    0 .and. m2 ==    3 .and. m ==    3) X =   0.42966892442365973_8
		if(m1 ==    2 .and. m2 ==    3 .and. m ==    5) X =   0.51355259101309547_8
		if(m1 ==    4 .and. m2 ==    3 .and. m ==    7) X =   0.60219379159649489_8
		if(m1 ==    6 .and. m2 ==    3 .and. m ==    9) X =   0.69535349536511537_8
		if(m1 ==    8 .and. m2 ==    3 .and. m ==   11) X =   0.79282496717209194_8
		if(m1 ==   10 .and. m2 ==    3 .and. m ==   13) X =   0.89442719099991574_8
		if(m1 ==   12 .and. m2 ==    3 .and. m ==   15) X =   1.0_8
	else if(j1 == 10 .and. j2 == 2 .and. j == 12) then
		if(m1 ==  -10 .and. m2 ==   -2 .and. m ==  -12) X =   1.0_8
		if(m1 ==   -8 .and. m2 ==   -2 .and. m ==  -10) X =   0.91287092917527679_8
		if(m1 ==   -6 .and. m2 ==   -2 .and. m ==   -8) X =   0.82572282384477047_8
		if(m1 ==   -4 .and. m2 ==   -2 .and. m ==   -6) X =   0.73854894587599640_8
		if(m1 ==   -2 .and. m2 ==   -2 .and. m ==   -4) X =   0.65133894727892960_8
		if(m1 ==    0 .and. m2 ==   -2 .and. m ==   -2) X =   0.56407607481776612_8
		if(m1 ==    2 .and. m2 ==   -2 .and. m ==    0) X =   0.47673129462279618_8
		if(m1 ==    4 .and. m2 ==   -2 .and. m ==    2) X =   0.38924947208076149_8
		if(m1 ==    6 .and. m2 ==   -2 .and. m ==    4) X =   0.30151134457776363_8
		if(m1 ==    8 .and. m2 ==   -2 .and. m ==    6) X =   0.21320071635561044_8
		if(m1 ==   10 .and. m2 ==   -2 .and. m ==    8) X =   0.12309149097933274_8
		if(m1 ==  -10 .and. m2 ==    0 .and. m ==  -10) X =   0.40824829046386302_8
		if(m1 ==   -8 .and. m2 ==    0 .and. m ==   -8) X =   0.55048188256318031_8
		if(m1 ==   -6 .and. m2 ==    0 .and. m ==   -6) X =   0.63960214906683133_8
		if(m1 ==   -4 .and. m2 ==    0 .and. m ==   -4) X =   0.69631062382279130_8
		if(m1 ==   -2 .and. m2 ==    0 .and. m ==   -2) X =   0.72821908125441914_8
		if(m1 ==    0 .and. m2 ==    0 .and. m ==    0) X =   0.73854894587599640_8
		if(m1 ==    2 .and. m2 ==    0 .and. m ==    2) X =   0.72821908125441914_8
		if(m1 ==    4 .and. m2 ==    0 .and. m ==    4) X =   0.69631062382279130_8
		if(m1 ==    6 .and. m2 ==    0 .and. m ==    6) X =   0.63960214906683133_8
		if(m1 ==    8 .and. m2 ==    0 .and. m ==    8) X =   0.55048188256318031_8
		if(m1 ==   10 .and. m2 ==    0 .and. m ==   10) X =   0.40824829046386302_8
		if(m1 ==  -10 .and. m2 ==    2 .and. m ==   -8) X =   0.12309149097933274_8
		if(m1 ==   -8 .and. m2 ==    2 .and. m ==   -6) X =   0.21320071635561044_8
		if(m1 ==   -6 .and. m2 ==    2 .and. m ==   -4) X =   0.30151134457776363_8
		if(m1 ==   -4 .and. m2 ==    2 .and. m ==   -2) X =   0.38924947208076149_8
		if(m1 ==   -2 .and. m2 ==    2 .and. m ==    0) X =   0.47673129462279618_8
		if(m1 ==    0 .and. m2 ==    2 .and. m ==    2) X =   0.56407607481776612_8
		if(m1 ==    2 .and. m2 ==    2 .and. m ==    4) X =   0.65133894727892960_8
		if(m1 ==    4 .and. m2 ==    2 .and. m ==    6) X =   0.73854894587599640_8
		if(m1 ==    6 .and. m2 ==    2 .and. m ==    8) X =   0.82572282384477047_8
		if(m1 ==    8 .and. m2 ==    2 .and. m ==   10) X =   0.91287092917527679_8
		if(m1 ==   10 .and. m2 ==    2 .and. m ==   12) X =   1.0_8
	else if(j1 == 6 .and. j2 == 1 .and. j == 7) then
		if(m1 ==   -6 .and. m2 ==   -1 .and. m ==   -7) X =   1.0_8
		if(m1 ==   -4 .and. m2 ==   -1 .and. m ==   -5) X =   0.92582009977255142_8
		if(m1 ==   -2 .and. m2 ==   -1 .and. m ==   -3) X =   0.84515425472851657_8
		if(m1 ==    0 .and. m2 ==   -1 .and. m ==   -1) X =   0.75592894601845440_8
		if(m1 ==    2 .and. m2 ==   -1 .and. m ==    1) X =   0.65465367070797720_8
		if(m1 ==    4 .and. m2 ==   -1 .and. m ==    3) X =   0.53452248382484879_8
		if(m1 ==    6 .and. m2 ==   -1 .and. m ==    5) X =   0.37796447300922720_8
		if(m1 ==   -6 .and. m2 ==    1 .and. m ==   -5) X =   0.37796447300922720_8
		if(m1 ==   -4 .and. m2 ==    1 .and. m ==   -3) X =   0.53452248382484879_8
		if(m1 ==   -2 .and. m2 ==    1 .and. m ==   -1) X =   0.65465367070797720_8
		if(m1 ==    0 .and. m2 ==    1 .and. m ==    1) X =   0.75592894601845440_8
		if(m1 ==    2 .and. m2 ==    1 .and. m ==    3) X =   0.84515425472851657_8
		if(m1 ==    4 .and. m2 ==    1 .and. m ==    5) X =   0.92582009977255142_8
		if(m1 ==    6 .and. m2 ==    1 .and. m ==    7) X =   1.0_8
	else
		X = 0.0_8
	end if
	end function quick_CG
	
	subroutine construct_map
	! Constructs basis mapping for uncoupled basis
	implicit none
	integer::j,k
	if(return_all) then
		!write(6,*) "BA"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BA"
	end if
	allocate(LocS(maxSnum),LocL(maxLnum),basis_lookup(totaldim,maxSnum+maxLnum))
	LocS = 0
	LocL = 0
	do j=1,maxSnum
		if(j == 1) then
			do k=1,N
				if(twoS(k) /= 0) then
					LocS(j) = k
					exit
				end if
			end do
		else
			do k=LocS(j-1)+1,N
				if(twoS(k) /= 0) then
					LocS(j) = k
					exit
				end if
			end do
		end if
	end do
	do j=1,maxLnum
		if(j == 1) then
			do k=1,N
				if(twoL(k) /= 0) then
					LocL(j) = k
					exit
				end if
			end do
		else
			do k=LocL(j-1)+1,N
				if(twoL(k) /= 0) then
					LocL(j) = k
					exit
				end if
			end do
		end if
	end do
	do j=1,maxSnum+maxLnum
		if(j <= maxSnum) then
			basis_lookup(1,j) = -twoS(LocS(j))
		else
			basis_lookup(1,j) = -twoL(LocL(j-maxSnum))
		end if
	end do
	if(maxLnum == 0 .and. maxSnum /= 0) then
		do j=2,totaldim
			basis_lookup(j,:) = basis_lookup(j-1,:)
			if(basis_lookup(j,maxSnum) /= twoS(LocS(maxSnum))) then
				basis_lookup(j,maxSnum) = basis_lookup(j,maxSnum) + 2
			else
				basis_lookup(j,maxSnum) = -twoS(LocS(maxSnum))
				do k = maxSnum-1,1,-1
					if(basis_lookup(j,k) /= twoS(LocS(k))) then
						basis_lookup(j,k) = basis_lookup(j,k) + 2
						exit
					else
						basis_lookup(j,k) = -twoS(LocS(k))
					end if
				end do
			end if
		end do
	else if(maxSnum /= 0 .and. maxLnum /= 0) then
		do j=2,totaldim
			basis_lookup(j,:) = basis_lookup(j-1,:)
			if(basis_lookup(j,maxSnum+maxLnum) /= twoL(LocL(maxLnum))) then
				basis_lookup(j,maxSnum+maxLnum) = basis_lookup(j,maxSnum+maxLnum) + 2
			else
				basis_lookup(j,maxSnum+maxLnum) = -twoL(LocL(maxLnum))
				do k = maxSnum+maxLnum-1,1,-1
					if(k <= maxSnum) then
						if(basis_lookup(j,k) /= twoS(LocS(k)) ) then
							basis_lookup(j,k) = basis_lookup(j,k) + 2
							exit
						else
							basis_lookup(j,k) = -twoS(LocS(k))
						end if
					else
						if(basis_lookup(j,k) /= twoL(LocL(k-maxSnum))) then
							basis_lookup(j,k) = basis_lookup(j,k) + 2
							exit
						else
							basis_lookup(j,k) = -twoL(LocL(k-maxSnum))
						end if
					end if
				end do
			end if
		end do
	else
		call output_text("No basis elements found for lookup table generation",.false.)
		call control('kill ')
		return
	end if
	end subroutine construct_map
	
	subroutine evaluate_coupled_system(local_Jss,local_Gfactor,S_energies,S_vectors,S_Gfactors,S_projections)
	! Evaluate energy matrix and determine state specific g-values
	implicit none
	real(kind=8)::local_Jss(:,:,:),local_Gfactor(:,:),S_energies(:),S_vectors(:,:),S_Gfactors(:),S_projections(:,:)
	integer::num_threads
	complex(kind=8)::dummyI(1,1)
	logical::equalG
!#ifdef omp
!	integer,save::i,k,j,m,h,d,localdim
!	integer,allocatable,save::k_spins(:),k_tilde(:),basis1(:),basis2(:)
!	real(kind=8),save::element,new,g_component
!	real(kind=8),allocatable,save::sub_matrix(:,:),sub_eigenvalues(:),sub_Gfactors(:)
!	!$OMP THREADPRIVATE(i,k,j,m,h,d,localdim,k_spins,k_tilde,basis1,basis2,element,new,g_component,sub_matrix,sub_eigenvalues,sub_Gfactors)
!#else
	integer::i,k,j,m,h,d,localdim
	integer,allocatable::k_spins(:),k_tilde(:),basis1(:),basis2(:)
	real(kind=8)::element,new,g_component
	real(kind=8),allocatable::sub_matrix(:,:),sub_eigenvalues(:),sub_Gfactors(:),sub_projections(:,:)
	!if(.not. allocated(store_6J)) then
	!	allocate(store_6J(1000*totaldim))
	!	store_6J = 9D99
	!end if
!#endif
	if(return_all) then
		!write(6,*) "BB"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BB"
	end if
	S_vectors = 0.0_8
	S_energies = 0.0_8
	S_Gfactors = 0.0_8
	S_projections = 0.0_8
	num_threads = MaxCPU
	if(NumBlocks < MaxCPU) num_threads = NumBlocks
	equalG = .true.
	do m = 2,N
		if(local_Gfactor(3,m) /= local_Gfactor(3,1)) then
			equalG = .false.
			exit
		end if
	end do
#ifdef omp
	!$OMP PARALLEL DO IF(num_threads > 1) SCHEDULE(DYNAMIC,1) NUM_THREADS(num_threads) SHARED(num_threads,NumBlocks,S_localdim,S_basis,N,local_Jss,local_Gfactor,maxSnum,twoS,dummyI,S_energies,S_vectors,S_Gfactors,S_projections) PRIVATE(i,k,j,m,h,d,localdim,k_spins,k_tilde,basis1,basis2,element,new,g_component,sub_matrix,sub_eigenvalues,sub_Gfactors,sub_projections)
#endif	
	do i=1,NumBlocks
		if(.not. return_all) then
			if(i == 1) then
				if(allocated(k_spins)) deallocate(k_spins)
				if(allocated(k_tilde)) deallocate(k_tilde)
				if(allocated(basis1)) deallocate(basis1)
				if(allocated(basis2)) deallocate(basis2)
			end if
			if(.not. allocated(k_spins)) allocate(k_spins(maxSnum))
			if(.not. allocated(k_tilde)) allocate(k_tilde(maxSnum-1))
			if(.not. allocated(basis1)) allocate(basis1(maxSnum))
			if(.not. allocated(basis2)) allocate(basis2(maxSnum))
			localdim = S_localdim(i,2) - S_localdim(i,1) + 1
			allocate(sub_matrix(localdim,localdim),sub_eigenvalues(localdim),sub_Gfactors(localdim),sub_projections(localdim,N))
			sub_matrix = 0.0_8
			do k = S_localdim(i,1),S_localdim(i,2)
				basis2(:) = S_basis(k,:)
				if(.not. return_all) then
					do j = S_localdim(i,1),k
						basis1(:) = S_basis(j,:)
						element = 0.0_8
						do m=1,N-1
							do h=m+1,N
								if(dabs(local_Jss(m,h,3)) > 0.0_8) then
									k_spins(:) = 0
									k_tilde(:) = 0
									k_spins(m) = 1
									k_spins(h) = 1
									new = 1.0_8
									if((k_spins(1) == 0 .and. k_spins(2) == 1) .or. (k_spins(1) == 1 .and. k_spins(2) == 0)) then
										k_tilde(1) = 1
									else
										k_tilde(1) = 0
									end if
									do d = 2,maxSnum-1
										if((k_tilde(d-1) == 0 .and. k_spins(d+1) == 1) .or. (k_tilde(d-1) == 1 .and. k_spins(d+1) == 0)) then
											k_tilde(d) = 1
										else
											k_tilde(d) = 0
										end if
									end do
									do d = 1,maxSnum-1
										if(d == 1) then
											new = new * nineJ(twoS(1),twoS(1),2*k_spins(1),twoS(2),twoS(2),2*k_spins(2),basis2(1),basis1(1),2*k_tilde(1))
											if(new == 0.0_8) goto 17
											new = new * ((basis2(1)+1)*(basis1(1)+1)*(2*k_tilde(1)+1))**0.5_8
										else
											new = new * nineJ(basis2(d-1),basis1(d-1),2*k_tilde(d-1),twoS(d+1),twoS(d+1),2*k_spins(d+1),basis2(d),basis1(d),2*k_tilde(d))
											if(new == 0.0_8) goto 17
											new = new * ((basis2(d)+1)*(basis1(d)+1)*(2*k_tilde(d)+1))**0.5_8
										end if
									end do
									do d = 1,maxSnum
										if(k_spins(d) == 0) then
											new = new * dsqrt(dble(twoS(d)+1))
										else
											new = new * dsqrt(twoS(d)*0.5_8*(twoS(d)*0.5_8+1.0_8)*(twoS(d)+1))
										end if
									end do
									element = element + 3.46410161513775_8*local_Jss(m,h,3)*EnergyConvert*new/dsqrt(dble(basis2(maxSnum-1)+1))
17									continue
								end if
							end do
						end do
						sub_matrix(j-S_localdim(i,1)+1,k-S_localdim(i,1)+1) = sub_matrix(j-S_localdim(i,1)+1,k-S_localdim(i,1)+1) + element
					end do
				end if
			end do
			if(localdim > 1) then
				call diagonalize('R','V','U',localdim,sub_matrix,dummyI,sub_eigenvalues)
			else
				sub_eigenvalues(1) = sub_matrix(1,1)
				sub_matrix(1,1) = 1.0_8
			end if
            if(equalG) then
                sub_Gfactors = local_Gfactor(3,1)
            else
				sub_Gfactors = 0.0_8
				sub_projections = 0.0_8
				if(basis2(maxSnum-1) /= 0) then
					do h = 1,localdim
						do m = 1,N
							g_component = 0.0_8
							do k = S_localdim(i,1),S_localdim(i,2)
								basis2(:) = S_basis(k,:)
								do j = S_localdim(i,1),S_localdim(i,2)
									basis1(:) = S_basis(j,:)
									k_spins = 0
									k_tilde = 0
									k_spins(m) = 1
									new = 1.0_8
									if((k_spins(1) == 0 .and. k_spins(2) == 1) .or. (k_spins(1) == 1 .and. k_spins(2) == 0)) then
										k_tilde(1) = 1
									else
										k_tilde(1) = 0
									end if
									do d = 2,maxSnum-1
										if((k_tilde(d-1) == 0 .and. k_spins(d+1) == 1) .or. (k_tilde(d-1) == 1 .and. k_spins(d+1) == 0)) then
											k_tilde(d) = 1
										else
											k_tilde(d) = 0
										end if
									end do
									do d = 1,maxSnum-1
										if(d == 1) then
											new = new * nineJ(twoS(1),twoS(1),2*k_spins(1),twoS(2),twoS(2),2*k_spins(2),basis2(1),basis1(1),2*k_tilde(1))
											if(new == 0.0_8) goto 18
											new = new * ((basis2(1)+1)*(basis1(1)+1)*(2*k_tilde(1)+1))**0.5_8
										else
											new = new * nineJ(basis2(d-1),basis1(d-1),2*k_tilde(d-1),twoS(d+1),twoS(d+1),2*k_spins(d+1),basis2(d),basis1(d),2*k_tilde(d))
											if(new == 0.0_8) goto 18
											new = new * ((basis2(d)+1)*(basis1(d)+1)*(2*k_tilde(d)+1))**0.5_8
										end if
									end do
									do d = 1,maxSnum
										if(k_spins(d) == 0) then
											new = new * dsqrt(dble(twoS(d)+1))
										else
											new = new * dsqrt(twoS(d)*0.5_8*(twoS(d)*0.5_8+1.0_8)*(twoS(d)+1))
										end if
									end do
									g_component = g_component + sub_matrix(j-S_localdim(i,1)+1,h)*sub_matrix(k-S_localdim(i,1)+1,h)*new/dsqrt((basis2(maxSnum-1)+1)*0.5_8*basis2(maxSnum-1)*(0.5_8*basis2(maxSnum-1)+1.0_8))
18									continue
								end do
							end do
							sub_Gfactors(h) = sub_Gfactors(h) + g_component*local_Gfactor(3,m)
							sub_projections(h,m) = g_component
						end do
					end do
				end if
			end if
			do k = S_localdim(i,1),S_localdim(i,2)
				S_energies(k) = sub_eigenvalues(k-S_localdim(i,1)+1)
				S_vectors(S_localdim(i,1):S_localdim(i,2),k) = sub_matrix(:,k-S_localdim(i,1)+1)
				S_Gfactors(k) = sub_Gfactors(k-S_localdim(i,1)+1)
				do m = 1,N
					S_projections(k,m) = sub_projections(k-S_localdim(i,1)+1,m)
				end do
			end do
			deallocate(sub_matrix,sub_eigenvalues,sub_Gfactors,sub_projections)
			if(i == NumBlocks) then
				deallocate(k_spins,k_tilde,basis1,basis2)
			end if
		end if
	end do
#ifdef omp
	!$OMP END PARALLEL DO
#endif
	if(allocated(k_spins)) deallocate(k_spins)
	if(allocated(k_tilde)) deallocate(k_tilde)
	if(allocated(basis1)) deallocate(basis1)
	if(allocated(basis2)) deallocate(basis2)
	end subroutine evaluate_coupled_system
	
	subroutine couple_states(in)
	! Set up coupled states
	integer,intent(in)::in
	integer::j,k,pos,i,h,h2,maxSpin,minSpin,min_mem,low,high,tot_mem
	integer,allocatable::location(:),re_coupled_basis(:,:),spin_blocks(:,:)
	if(return_all) then
		!write(6,*) "BC"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BC"
	end if
	pos = 1
	allocate(coupled_basis(totaldim,maxSnum),re_coupled_basis(totaldim,maxSnum),spin_blocks(totaldim,4),location(totaldim))
	coupled_basis(:,:) = 0
	low = abs(twoS(1)-twoS(2))
	high = twoS(1)+twoS(2)
	global_couple_pos = 1
	do k = low,high,2
		call recursive_couple(k,2)
	end do
	maxSpin = maxval(coupled_basis(:,maxSnum-1))
	minSpin = minval(coupled_basis(:,maxSnum-1))
	pos = 0
	do j=minSpin,maxSpin,1
		do i=1,totaldim
			if(coupled_basis(i,maxSnum-1) == j) then
				pos = pos + 1
				location(pos) = i
				re_coupled_basis(pos,:) = coupled_basis(i,:)
			end if			
		end do
	end do
	!!!if(mpi_rank == 0) write(6,*) "****Coupled Basis****"
	!do i=1,totaldim
	!	write(6,'(I3,A1)',advance='no') i," "
	!	do j=1,maxSnum
	!		write(6,'(4F5.1)',advance='no') dble(re_coupled_basis(i,j))*0.5_8
	!	end do
	!	write(6,*)
	!end do
	coupled_basis = re_coupled_basis
	pos = 0
	h = 0
	spin_blocks = 0
	do i=1,totaldim-1
		if(coupled_basis(i,maxSnum-1) /= coupled_basis(i+1,maxSnum-1)) then				!found new total spin?
			h = h + 1																	!new block!
			spin_blocks(h,1) = coupled_basis(i,maxSnum-1)								!what spin is it?
			if(h == 1) then
				spin_blocks(h,2) = 1
			else
				spin_blocks(h,2) = spin_blocks(h-1,3) + 1
			end if
			spin_blocks(h,3) = i
			do k = spin_blocks(h,2),spin_blocks(h,3)-1
				do j=1,maxSnum-2
					if(coupled_basis(k,j) /= coupled_basis(k+1,j)) then
						spin_blocks(h,4) = 1
					end if
				end do
			end do
		end if
	end do
	h = h + 1
	spin_blocks(h,1) = coupled_basis(totaldim,maxSnum-1)
	spin_blocks(h,2) = spin_blocks(h-1,3) + 1
	spin_blocks(h,3) = totaldim
	do k = spin_blocks(h,2),spin_blocks(h,3)-1
		do j=1,maxSnum-2
			if(coupled_basis(k,j) /= coupled_basis(k+1,j)) then
				spin_blocks(h,4) = 1
			end if
		end do
	end do
	NumBlocks = h
	h = 1
	do k = 2,totaldim
		do j = 1,maxSnum-1
			if(coupled_basis(k-1,j) /= coupled_basis(k,j)) then
				h = h + 1
				exit
			end if
		end do
	end do
	Sdim = h
	allocate(S_basis(Sdim,maxSnum),S_localdim(NumBlocks,3))
	S_basis = 0
	h = 1
	h2 = 2
	S_localdim(1,1) = 1
	S_localdim(1,3) = coupled_basis(1,maxSnum-1)
	do k = 2,totaldim
		do j = 1,maxSnum-1
			if(coupled_basis(k-1,j) /= coupled_basis(k,j)) then
				S_basis(h,:) = coupled_basis(k-1,:)
				h = h + 1
				exit
			end if
		end do
		if(coupled_basis(k-1,maxSnum-1) /= coupled_basis(k,maxSnum-1)) then
			S_localdim(h2,1) = h
			S_localdim(h2,3) = coupled_basis(k,maxSnum-1)
			h2 = h2 + 1
		end if
	end do
	S_basis(Sdim,:) = coupled_basis(totaldim,:)
	!!!if(mpi_rank == 0) write(6,*) "****Spin Basis****"
	!do i =1,Sdim
	!	do j=1,maxSnum-1
	!		write(6,'(4F5.1)',advance='no') dble(S_basis(i,j))*0.5_8
	!	end do
	!	write(6,*)
	!end do
	do i=1,NumBlocks
		if(i /= NumBlocks) then
			S_localdim(i,2) = S_localdim(i+1,1) - 1
		else
			S_localdim(i,2) = Sdim
		end if
	end do
	tot_mem = 0
	if(in == 1) then
		if(mpi_rank == 0) then
			call output_text("- - - - - - - - - - - - - - -",.false.)
			call output_text("       Coupling Report       ",.false.)
			call output_text(" Spin | Dimension | Size (MB)",.false.)
			call output_text("- - - - - - - - - - - - - - -",.false.)
			do i=1,NumBlocks
				min_mem = nint(dble(S_localdim(i,2)-S_localdim(i,1)+1)*dble(S_localdim(i,2)-S_localdim(i,1)+1)*8.0_8/(1024.0_8*1024.0_8))
				if(min_mem < 1) min_mem = 1
				tot_mem = tot_mem + min_mem
				SaveTxt = ""
				write(SaveTxt,'(F5.1,A3,I9,A3,I9)') S_localdim(i,3)*0.5_8, " | ",S_localdim(i,2)-S_localdim(i,1)+1," | ",min_mem
				call output_text(SaveTxt,.false.)
			end do
			call output_text("- - - - - - - - - - - - - - -",.false.)
			SaveTxt = ""
			write(SaveTxt,'(A25,I9)') "Associated storage (MB): ",nint((6.0_8*dble(Sdim) + 2.0_8*dble(Sdim)*dble(Sdim) + 2.0_8*dble(totaldim)*dble(maxSnum) + 8.0_8*dble(totaldim) + dble(Sdim)*dble(maxSnum))*8.0_8/(1024.0_8*1024.0_8))
			call output_text(SaveTxt,.false.)
			tot_mem = tot_mem + nint((6.0_8*dble(Sdim) + 2.0_8*dble(Sdim)*dble(Sdim) + 2.0_8*dble(totaldim)*dble(maxSnum) + 8.0_8*dble(totaldim) + dble(Sdim)*dble(maxSnum))*8.0_8/(1024.0_8*1024.0_8))
			SaveTxt = ""
			write(SaveTxt,'(A16,I9)') "Total RAM (MB): ",tot_mem
			call output_text(SaveTxt,.false.)
			call output_text("- - - - - - - - - - - - - - -",.false.)
		end if
	else
		if(mpi_rank == 0) then
			do i=1,NumBlocks
				min_mem = nint(dble(S_localdim(i,2)-S_localdim(i,1)+1)*dble(S_localdim(i,2)-S_localdim(i,1)+1)*8.0_8/(1024.0_8*1024.0_8))
				if(min_mem < 1) min_mem = 1
				tot_mem = tot_mem + min_mem
			end do
			call output_text("- - - - - - - - - - - - - - -",.false.)
			tot_mem = tot_mem + nint((6.0_8*dble(Sdim) + 2.0_8*dble(Sdim)*dble(Sdim) + 2.0_8*dble(totaldim)*dble(maxSnum) + 8.0_8*dble(totaldim) + dble(Sdim)*dble(maxSnum))*8.0_8/(1024.0_8*1024.0_8))
			SaveTxt = ""
			write(SaveTxt,'(A16,I9)') "Total RAM (MB): ",tot_mem
			call output_text(SaveTxt,.false.)
			call output_text("- - - - - - - - - - - - - - -",.false.)
		end if
	end if
	deallocate(re_coupled_basis,spin_blocks,location)
	end subroutine couple_states
	
	recursive subroutine recursive_couple(k,l)
	implicit none
	integer,intent(in)::k,l
	integer::low,high,i
	!if(return_all) then
	!	!write(6,*) "BD"
	!	return
	!else
	!	!!if(mpi_rank == 0) write(6,*) "*BD"
	!end if
	if(l < maxSnum) then
		low = abs(k-twoS(l+1))
		high = k + twoS(l+1)
		coupled_basis(global_couple_pos,l-1) = k
		do i = low,high,2
			call recursive_couple(i,l+1)
		end do
	else
		coupled_basis(global_couple_pos,l-1) = k
		do i = -k,k,2
			coupled_basis(global_couple_pos,l) = i
			global_couple_pos = global_couple_pos + 1
			if(global_couple_pos <= totaldim) coupled_basis(global_couple_pos,:) = coupled_basis(global_couple_pos-1,:)
		end do
	end if
	end subroutine recursive_couple
	
	recursive function nineJ(a,b,c,d,e,f,g,h,i) result(X)
	! Calculates a subset of Wigner 9J symbols
	implicit none
	integer,intent(in)::a,b,c,d,e,f,g,h,i
	real(kind=8)::X
	!if(return_all) then
	!	!write(6,*) "BE"
	!	return
	!else
	!	!!if(mpi_rank == 0) write(6,*) "*BE"
	!end if
	X = 0.0_8
	if(c == 2 .and. f == 2 .and. i == 0) then
		if(g == h) then
			X = sixJ(a,b,2,e,d,g)
			if(X /= 0.0_8) X = X*((-1)**((b+2+d+g)*0.5_8))/dsqrt(3.0_8*(g+1))
		end if
	else if(c == 0 .and. f == 0 .and. i == 0) then
		if(a == b .and. d == e .and. g == h) then
			X = 1.0_8/dsqrt(dble((a+1)*(d+1)*(g+1)))
		end if
	else if(c == 2 .and. f == 0 .and. i == 2) then
		if(d == e) then
			X = sixJ(b,a,2,g,h,d)
			if(X /= 0.0_8) X = X*((-1)**((a+2+h+d)*0.5_8))/dsqrt(3.0_8*(d+1))
		end if
	else if(c == 0 .and. f == 2 .and. i == 2) then
		if(a == b) then
			X = sixJ(h,g,2,d,e,a)
			if(X /= 0.0_8) X = X*((-1)**((g+2+e+a)*0.5_8))/dsqrt(3.0_8*(a+1))
		end if
	else
		SaveTxt = ""
		write(SaveTxt,'(A19,I1,A6,I1,A9,I1,A15)') "9J symbol with c = ",c,", f = ",f," and i = ",i," is not defined"
		call output_text(SaveTxt,.false.)
		call control('kill ')
		return
	end if
	end function nineJ
	
	recursive function sixJ(a,b,c,d,e,f) result(X)
	! calculates a Wigner 6-j symbol. Argument a-f are integer and are
	! twice the true value of the 6-j's arguments, in the form
	! { a b c }
	! { d e f }
	! Calculated using binomial coefficients to allow for (reasonably) high
	! arguments.
	implicit none
	integer,intent(in)::a,b,c,d,e,f
	integer::nlo,nhi,n
	real(kind=8)::outfactors,sum,sumterm,X
!#ifndef omp
!	integer::R(3,4),cc,row_move(4),col_move(3),col_index,locA(3),locB(4),alpha(3),beta(4),maxi,mini
!#endif
	!if(return_all) then
	!	!write(6,*) "BF"
	!	return
	!else
	!	!!if(mpi_rank == 0) write(6,*) "*BF"
	!end if
	X=0.0_8
	if(mod(a+b,2)/=mod(c,2)) return
	if(mod(c+d,2)/=mod(e,2)) return
	if(mod(a+e,2)/=mod(f,2)) return
	if(mod(b+d,2)/=mod(f,2)) return
	if(abs(a-b)>c .or. a+b<c) return
	if(abs(c-d)>e .or. c+d<e) return
	if(abs(a-e)>f .or. a+e<f) return
	if(abs(b-d)>f .or. b+d<f) return
! #ifndef omp				
	! locA(1) = (a + b + d + e)/2
	! locA(2) = (a + c + d + f)/2
	! locA(3) = (b + c + e + f)/2
	! locB(1) = (a + b + c)/2
	! locB(2) = (a + e + f)/2
	! locB(3) = (b + d + f)/2
	! locB(4) = (c + d + e)/2
	! maxi = maxloc(locA,1)
	! mini = minloc(locA,1)
	! alpha(1) = locA(maxi)
	! alpha(3) = locA(mini)
	! do n = 1,3
		! if(n /= maxi .and. n /= mini) then
			! alpha(2) = locA(n)
		! end if
	! end do
	! maxi = maxloc(locB,1)
	! mini = minloc(locB,1)
	! beta(1) = locB(maxi)
	! beta(4) = locB(mini)
	! i = 2
	! do n = 1,4
		! if(n /= maxi .and. n /= mini) then
			! beta(i) = locB(n)
			! i=i+1
		! end if
	! end do
	! if(beta(2) < beta(3)) then
		! i = beta(2)
		! beta(2) = beta(3)
		! beta(3) = i
	! end if
	! do i = 1,4
		! do n = 1,3
			! R(n,i) = alpha(n)-beta(i)
		! end do
	! end do
	! if(maxval(R(1,:)) >= maxval(R(2,:))) then
		! if(maxval(R(1,:)) >= maxval(R(3,:))) then
			! col_index = maxloc(R(1,:),1)
			! row_move(:) = R(1,:)
			! R(1,:) = R(2,:)
			! R(2,:) = R(3,:)
			! R(3,:) = row_move(:)
			! if(col_index < 4) col_move(:) = R(:,col_index)
			! do n = col_index,3
				! R(:,n) = R(:,n+1)
			! end do
			! if(col_index < 4) R(:,4) = col_move(:)
		! else
			! col_index = maxloc(R(3,:),1)
			! if(col_index < 4) col_move(:) = R(:,col_index)
			! do n = col_index,3
				! R(:,n) = R(:,n+1)
			! end do
			! if(col_index < 4) R(:,4) = col_move(:)
		! end if
	! else
		! if(maxval(R(2,:)) >= maxval(R(3,:))) then
			! col_index = maxloc(R(2,:),1)
			! row_move(:) = R(2,:)
			! R(2,:) = R(3,:)
			! R(3,:) = row_move(:)
			! if(col_index < 4) col_move(:) = R(:,col_index)
			! do n = col_index,3
				! R(:,n) = R(:,n+1)
			! end do
			! if(col_index < 4) R(:,4) = col_move(:)
		! else
			! col_index = maxloc(R(3,:),1)
			! if(col_index < 4) col_move(:) = R(:,col_index)
			! do n = col_index,3
				! R(:,n) = R(:,n+1)
			! end do
			! if(col_index < 4) R(:,4) = col_move(:)
		! end if
	! end if
	! if(minval(R(1,:)) <= minval(R(2,:))) then
		! if(minval(R(1,:)) <= minval(R(3,:))) then
			! col_index = minloc(R(1,:),1)
			! if(col_index > 1) col_move(:) = R(:,col_index)
			! do n = col_index,2,-1
				! R(:,n) = R(:,n-1)
			! end do
			! if(col_index > 1) R(:,1) = col_move(:)
		! else
			! col_index = minloc(R(3,:),1)
			! row_move(:) = R(3,:)
			! R(3,:) = R(2,:)
			! R(2,:) = R(1,:)
			! R(1,:) = row_move(:)
			! if(col_index > 1) col_move(:) = R(:,col_index)
			! do n = col_index,2,-1
				! R(:,n) = R(:,n-1)
			! end do
			! if(col_index > 1) R(:,1) = col_move(:)
		! end if
	! else
		! if(minval(R(2,:)) <= minval(R(3,:))) then
			! col_index = minloc(R(2,:),1)
			! row_move(:) = R(2,:)
			! R(2,:) = R(1,:)
			! R(1,:) = row_move(:)
			! if(col_index > 1) col_move(:) = R(:,col_index)
			! do n = col_index,2,-1
				! R(:,n) = R(:,n-1)
			! end do
			! if(col_index > 1) R(:,1) = col_move(:)
		! else
			! col_index = minloc(R(3,:),1)
			! row_move(:) = R(3,:)
			! R(3,:) = R(2,:)
			! R(2,:) = R(1,:)
			! R(1,:) = row_move(:)
			! if(col_index > 1) col_move(:) = R(:,col_index)
			! do n = col_index,2,-1
				! R(:,n) = R(:,n-1)
			! end do
			! if(col_index > 1) R(:,1) = col_move(:)
		! end if
	! end if
	! cc = NInt((dble(R(3,4))/720.0_8)*(120.0_8+dble(R(3,4))*(274.0_8+dble(R(3,4))*(225.0_8+dble(R(3,4))*(85.0_8+dble(R(3,4))*(15.0_8+dble(R(3,4)))))))+(dble(R(2,4))/120.0_8)*(24.0_8+dble(R(2,4))*(50.0_8+dble(R(2,4))*(35.0_8+dble(R(2,4))*(10.0_8+dble(R(2,4))))))+(dble(R(1,4))/24.0_8)*(6.0_8+dble(R(1,4))*(11.0_8+dble(R(1,4))*(6.0_8+dble(R(1,4)))))+(dble(R(1,3))/6.0_8)*(2.0_8+dble(R(1,3))*(3.0_8+dble(R(1,3))))+(dble(R(1,2))/2.0_8)*(dble(R(1,2))+1.0_8)+dble(R(1,1))+1.0_8)
	! if(cc > largest_6J_index) largest_6J_index = cc
	! if(store_6J(cc) > 1D99) then
! #endif
		if(f == 0) then
			if(b /= d) goto 16
			if(a /= e) goto 16
			if(abs(a-b) > c .or. c > a+b) goto 16
			X = (-1)**((a+b+c)/2)/dsqrt(dble((a+1)*(b+1)))
		else if(c == 0) then
			if(e /= d) goto 16
			if(a /= b) goto 16
			if(abs(a-e) > f .or. f > a+e) goto 16
			X = (-1)**((a+e+c)/2)/dsqrt(dble((a+1)*(e+1)))
		else if(e == 0) then
			if(c /= d) goto 16
			if(a /= f) goto 16
			if(abs(a-c) > b .or. b > a+c) goto 16
			X = (-1)**((a+c+b)/2)/dsqrt(dble((a+1)*(c+1)))
		else if(b == 0) then
			if(f /= d) goto 16
			if(a /= c) goto 16
			if(abs(a-f) > e .or. e > a+f) goto 16
			X = (-1)**((a+f+e)/2)/dsqrt(dble((a+1)*(f+1)))
		else if(d == 0) then
			if(b /= f) goto 16
			if(c /= e) goto 16
			if(abs(c-b) > a .or. a > c+b) goto 16
			X = (-1)**((c+b+a)/2)/dsqrt(dble((c+1)*(b+1)))
		else if(a == 0) then
			if(b /= c) goto 16
			if(f /= e) goto 16
			if(abs(f-b) > d .or. d > f+b) goto 16
			X = (-1)**((f+b+d)/2)/dsqrt(dble((f+1)*(b+1)))
		else
			outfactors = angdelta(a,e,f)/angdelta(a,b,c)
			outfactors = outfactors * angdelta(b,d,f)*angdelta(c,d,e)
			nlo = max( (a+b+c)/2, (c+d+e)/2, (b+d+f)/2, (a+e+f)/2 )
			nhi = min( (a+b+d+e)/2, (b+c+e+f)/2, (a+c+d+f)/2)
			sum=0.0
			do n=nlo,nhi
			   sumterm = (-1)**n
			   sumterm = sumterm * binom(n+1,n-(a+b+c)/2)
			   sumterm = sumterm * binom((a+b-c)/2,n-(c+d+e)/2)
			   sumterm = sumterm * binom((a-b+c)/2,n-(b+d+f)/2)
			   sumterm = sumterm * binom((b-a+c)/2,n-(a+e+f)/2)
			   sum=sum+sumterm
			end do
			X = sum * outfactors
		end if
16					continue
! #ifndef omp
		! store_6J(cc) = X
	! else
		! X = store_6J(cc)
	! end if
! #endif
	end function sixJ
	
	recursive function angdelta(a,b,c) result(X)
	! calculate the function delta as defined in varshalovich et al. for use in 6-j symbol:
	implicit none
	integer::a,b,c
	real(kind=8)::X,scr1
	!if(return_all) then
	!	!write(6,*) "BG"
	!	return
	!else
	!	!if(mpi_rank == 0) write(6,*) "*BG"
	!end if
	scr1= FACT((a+b-c)/2)
	scr1=scr1/FACT((a+b+c)/2+1)
	scr1=scr1*FACT((a-b+c)/2)
	scr1=scr1*FACT((-a+b+c)/2)
	X=dsqrt(scr1)
	end function angdelta
	
	recursive subroutine diagonalize(RI,NV,UL,dim,matrixR,matrixI,eigenvalues)
	! Provides build dependent diagonalization
	implicit none
	character(len=1)::RI,NV,UL
	integer::dim,lwork,diaginfo
#ifdef gpu
	integer::culainfo
#endif
	real(kind=8),dimension(:,:)::matrixR
	complex(kind=8),dimension(:,:)::matrixI
	real(kind=8),dimension(dim)::eigenvalues
	real(kind=8),allocatable::rwork(:)
	complex(kind=8),allocatable::work(:)
	if(return_all) then
		!write(6,*) "BH"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BH"
	end if
!	if(xPU == 0 .or. dim < 1000) then
		if(RI == 'R') then
			!if(NV == 'N') then
				allocate(rwork(10))
				call dsyev(NV,UL,dim,matrixR,dim,eigenvalues,rwork,-1,diaginfo)
				lwork = nint(rwork(1))
				deallocate(rwork)
				allocate(rwork(lwork))
				call dsyev(NV,UL,dim,matrixR,dim,eigenvalues,rwork,lwork,diaginfo)
				if(diaginfo /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A21,I10)') "Diagonalization Error",diaginfo
					call output_text(SaveTxt,.false.)
					call control('kill ')
					return
				end if
				deallocate(rwork)
			!else
			!	allocate(rwork(10),iwork(10))
			!	call dsyevd(NV,UL,dim,matrixR,dim,eigenvalues,rwork,-1,iwork,-1,diaginfo)
			!	lrwork = nint(rwork(1))
			!	liwork = iwork(1)
			!	deallocate(rwork,iwork)
			!	allocate(rwork(lrwork),iwork(liwork))
			!	call dsyevd(NV,UL,dim,matrixR,dim,eigenvalues,rwork,lrwork,iwork,liwork,diaginfo)
			!	if(diaginfo /= 0) then
			!		if(mpi_rank == 0) write(6,'(A21,I10)') "Diagonalization Error",diaginfo
			!		call control('kill ')
			!		return
			!	end if
			!	deallocate(rwork,iwork)
			!end if
		else if(RI == 'I') then
			!if(NV == 'N') then
				allocate(work(10),rwork(3*dim-2))
				call zheev(NV,UL,dim,matrixI,dim,eigenvalues,work,-1,rwork,diaginfo)
				lwork = nint(dble(work(1)))
				deallocate(work)
				allocate(work(lwork))
				call zheev(NV,UL,dim,matrixI,dim,eigenvalues,work,lwork,rwork,diaginfo)
				if(diaginfo /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A21,I10)') "Diagonalization Error",diaginfo
					call output_text(SaveTxt,.false.)
					call control('kill ')
					return
				end if
				deallocate(work,rwork)
			!else
			!	allocate(work(10),rwork(10),iwork(10))
			!	call zheevd(NV,UL,dim,matrixI,dim,eigenvalues,work,-1,rwork,-1,iwork,-1,diaginfo)
			!	lwork = nint(dble(work(1)))
			!	lrwork = nint(rwork(1))
			!	liwork = iwork(1)
			!	deallocate(work,rwork,iwork)
			!	allocate(work(lwork),rwork(lrwork),iwork(liwork))
			!	call zheevd(NV,UL,dim,matrixI,dim,eigenvalues,work,lwork,rwork,lrwork,iwork,liwork,diaginfo)
			!	if(diaginfo /= 0) then
			!		if(mpi_rank == 0) write(6,'(A21,I10)') "Diagonalization Error",diaginfo
			!		call control('kill ')
			!		return
			!	end if
			!	deallocate(work,rwork,iwork)
			!end if
		end if
!	else
!#ifdef gpu
!		if(RI == 'R') then
!			culainfo = cula_dsyev(NV,UL,dim,matrixR,dim,eigenvalues)
!			call check_status(culainfo)
!		else if(RI == 'I') then
!			culainfo = cula_zheev(NV,UL,dim,matrixI,dim,eigenvalues)
!			call check_status(culainfo)
!		end if
!#else
!		if(mpi_rank == 0) write(6,'(A43)') "You must compile with -Dgpu for GPU support"
!		call control('kill ')
!		return
!#endif
!	end if
	end subroutine diagonalize
	
	recursive subroutine expectation(RI,dim,vectorsR,vectorsI,pertR,pertI)
	! Provides build dependent expectation matrix calculation
	implicit none
	character(len=1)::RI
	integer::dim
#ifdef gpu
	integer::culainfo
#endif
	real(kind=8),dimension(:,:)::vectorsR,pertR
	complex(kind=8),dimension(:,:)::vectorsI,pertI
	real(kind=8),allocatable::tempR(:,:)
	complex(kind=8),allocatable::tempI(:,:)
	if(return_all) then
		!write(6,*) "BI"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BI"
	end if
	if(RI == 'I') allocate(tempI(dim,dim))
	if(RI == 'R') allocate(tempR(dim,dim))
!	if(xPU == 0) then
		if(RI == 'R') then
			!call DGEMM('N','N',dim,dim,dim,1.0_8,pertR,dim,vectorsR,dim,0.0_8,tempR,dim)
			call DSYMM('L','U',dim,dim,1.0_8,pertR,dim,vectorsR,dim,0.0_8,tempR,dim)
			call DGEMM('C','N',dim,dim,dim,1.0_8,vectorsR,dim,tempR,dim,0.0_8,pertR,dim)
		else if(RI == 'I') then
			!call ZGEMM('N','N',dim,dim,dim,(1.0_8,0.0_8),pertI,dim,vectorsI,dim,(0.0_8,0.0_8),tempI,dim)
			call ZHEMM('L','U',dim,dim,(1.0_8,0.0_8),pertI,dim,vectorsI,dim,(0.0_8,0.0_8),tempI,dim)
			call ZGEMM('C','N',dim,dim,dim,(1.0_8,0.0_8),vectorsI,dim,tempI,dim,(0.0_8,0.0_8),pertI,dim)
		end if
!	else
!#ifdef gpu
!		if(RI == 'R') then
!			culainfo = cula_dgemm('N','N',dim,dim,dim,1.0_8,pertR,dim,vectorsR,dim,0.0_8,tempR,dim)
!			culainfo = cula_dgemm('C','N',dim,dim,dim,1.0_8,vectorsR,dim,tempR,dim,0.0_8,pertR,dim)
!			call check_status(culainfo)
!		else if(RI == 'I') then
!			culainfo = cula_zgemm('N','N',dim,dim,dim,(1.0_8,0.0_8),pertI,dim,vectorsI,dim,(0.0_8,0.0_8),tempI,dim)
!			culainfo = cula_zgemm('C','N',dim,dim,dim,(1.0_8,0.0_8),vectorsI,dim,tempI,dim,(0.0_8,0.0_8),pertI,dim)
!			call check_status(culainfo)
!		end if
!#else
!		if(mpi_rank == 0) write(6,'(A43)') "You must compile with -Dgpu for GPU support"
!		call control('kill ')
!		return
!#endif
!	end if
	if(RI == 'I') deallocate(tempI)
	if(RI == 'R') deallocate(tempR)
	end subroutine expectation
	
	recursive subroutine vector_expectation(RI,dim,vector1R,vector1I,pertR,pertI,vector2R,vector2I,resultR,resultI)
	! Provides build dependent expectation element calculation
	implicit none
	character(len=1)::RI
	integer::dim,i
#ifdef gpu
	integer::culainfo
#endif
	real(kind=8),dimension(:)::vector1R,vector2R
	real(kind=8),dimension(:,:)::pertR
	complex(kind=8),dimension(:)::vector1I,vector2I
	complex(kind=8),dimension(:,:)::pertI
	real(kind=8),allocatable::tempR(:)
	complex(kind=8),allocatable::tempI(:)
	real(kind=8)::resultR,DDOT
	complex(kind=8)::resultI,ZDOTU
	EXTERNAL ZDOTU
	EXTERNAL DDOT
	if(return_all) then
		!write(6,*) "BJ"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BJ"
	end if
	if(RI == 'I') allocate(tempI(dim))
	if(RI == 'R') allocate(tempR(dim))
!	if(xPU == 0) then
		if(RI == 'R') then
			call DSYMV('U',dim,1.0_8,pertR(1:dim,1:dim),dim,vector2R(1:dim),1,0.0_8,tempR(1:dim),1)
			!resultR = DDOT(dim,vector1R(1:dim),1,tempR(1:dim),1)
			resultR = 0.0_8
			do i = 1,dim
				resultR = resultR + vector1R(i)*tempR(i)
			end do
		else if(RI == 'I') then
			call ZHEMV('U',dim,(1.0_8,0.0_8),pertI(1:dim,1:dim),dim,vector2I(1:dim),1,(0.0_8,0.0_8),tempI(1:dim),1)
			!resultI = ZDOTU(dim,conjg(vector1I(1:dim)),1,tempI(1:dim),1)
			resultI = (0.0_8,0.0_8)
			do i = 1,dim
				resultI = resultI + conjg(vector1I(i))*tempI(i)
			end do
		end if
!	else
!#ifdef gpu
!		if(mpi_rank == 0) write(6,'(A50)') "GPU implentation of vector_expectation incomplete."
!		if(mpi_rank == 0) write(6,'(A22)') "Please contact author."
!		call control('kill ')
!		return
!#else
!		if(mpi_rank == 0) write(6,'(A43)') "You must compile with -Dgpu for GPU support"
!		call control('kill ')
!		return
!#endif
!	end if
	if(RI == 'I') deallocate(tempI)
	if(RI == 'R') deallocate(tempR)
	end subroutine vector_expectation
	
	recursive subroutine multiply(RI,OpA,OpB,dim,AmatrixR,AmatrixI,BmatrixR,BmatrixI)
	! Provides build dependent matrix multiply
	implicit none
	character(len=1)::RI,OpA,OpB
	integer::dim
#ifdef gpu
	integer::culainfo
#endif
	real(kind=8),dimension(:,:)::AmatrixR,BmatrixR
	real(kind=8),allocatable::CmatrixR(:,:)
	complex(kind=8),dimension(:,:)::AmatrixI,BmatrixI
	complex(kind=8),allocatable::CmatrixI(:,:)
	if(return_all) then
		!write(6,*) "BK"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BK"
	end if
	if(RI == 'R') allocate(CmatrixR(dim,dim))
	if(RI == 'I') allocate(CmatrixI(dim,dim))
!	if(xPU == 0) then
		if(RI == 'R') then
			call DGEMM(OpA,OpB,dim,dim,dim,1.0_8,AmatrixR,dim,BmatrixR,dim,0.0_8,CmatrixR,dim)
		else if(RI == 'I') then
			call ZGEMM(OpA,OpB,dim,dim,dim,(1.0_8,1.0_8),AmatrixI,dim,BmatrixI,dim,(0.0_8,0.0_8),CmatrixI,dim)
		end if
!	else
!#ifdef gpu
!		if(RI == 'R') then
!			culainfo = cula_dgemm(OpA,OpB,dim,dim,dim,1.0_8,AmatrixR,dim,BmatrixR,dim,0.0_8,CmatrixR,dim)
!			call check_status(culainfo)
!		else if(RI == 'I') then
!			culainfo = cula_zgemm(OpA,OpB,dim,dim,dim,(1.0_8,1.0_8),AmatrixI,dim,BmatrixI,dim,(0.0_8,0.0_8),CmatrixI,dim)
!			call check_status(culainfo)
!		end if
!#else
!		if(mpi_rank == 0) write(6,'(A43)') "You must compile with -Dgpu for GPU support"
!		call control('kill ')
!		return
!#endif
!	end if
	if(RI == 'R') then
		AmatrixR = CmatrixR
		deallocate(CmatrixR)
	end if
	if(RI == 'I') then
		AmatrixI = CmatrixI
		deallocate(CmatrixI)
	end if
	end subroutine multiply
	
	recursive function CG(j1,m1,j2,m2,j,m) result(X)
	! calculate a clebsch-gordan coefficient < j1/2 m1/2 j2/2 m2/2 | j/2 m/2 >
	! arguments are integer and twice the true value. 
	implicit none
	real(kind=8):: X
	real(kind=8)::factor,sum
	integer,intent(in):: j1,m1,j2,m2,j,m
	integer::par,z,zmin,zmax
	if(return_all) then
		!write(6,*) "BL"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BL"
	end if
	if (2*(j1/2)-int(2*(j1/2.0)) /= 2*(abs(m1)/2)-int(2*(abs(m1)/2.0)) .or. &
		2*(j2/2)-int(2*(j2/2.0)) /= 2*(abs(m2)/2)-int(2*(abs(m2)/2.0)) .or. &
		2*(j/2)-int(2*(j/2.0)) /= 2*(abs(m)/2)-int(2*(abs(m)/2.0)) .or. &
		j1<0 .or. j2<0 .or. j<0 .or. abs(m1)>j1 .or. abs(m2)>j2 .or.&
		abs(m)>j .or. j1+j2<j .or. abs(j1-j2)>j .or. m1+m2/=m) then
		X= 0.0
	else
		factor = 0.0
		factor = binom(j1,(j1+j2-j)/2) / binom((j1+j2+j+2)/2,(j1+j2-j)/2)
		factor = factor * binom(j2,(j1+j2-j)/2) / binom(j1,(j1-m1)/2)
		factor = factor / binom(j2,(j2-m2)/2) / binom(j,(j-m)/2)
		factor = sqrt(factor)
		zmin = max(0,j2+(j1-m1)/2-(j1+j2+j)/2,j1+(j2+m2)/2-(j1+j2+j)/2)
		zmax = min((j1+j2-j)/2,(j1-m1)/2,(j2+m2)/2)
		sum=0.0
		do z = zmin,zmax
			par=1
			if(2*(z/2)-int(2*(z/2.0)) /= 0) par=-1
			sum=sum+par*binom((j1+j2-j)/2,z)*binom((j1-j2+j)/2,(j1-m1)/2-z)*&
			binom((-j1+j2+j)/2,(j2+m2)/2-z)
		end do
		X = factor*sum
	end if
	end function CG
	
end module ang_mom
