!!!!!!!!!!        PHI: data.f90                                                               !!!!!!!!!!
!!!!!!!!!!        Nicholas F. Chilton     							                          !!!!!!!!!!
!!!!!!!!!!        email: nfchilton@gmail.com                                                  !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        This file is part of PHI.                                                   !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is free software: you can redistribute it and/or modify                 !!!!!!!!!!
!!!!!!!!!!        it under the terms of the GNU General Public License as published by        !!!!!!!!!!
!!!!!!!!!!        the Free Software Foundation, either version 3 of the License, or           !!!!!!!!!!
!!!!!!!!!!        (at your option) any later version.                                         !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is distributed in the hope that it will be useful,                      !!!!!!!!!!
!!!!!!!!!!        but WITHOUT ANY WARRANTY; without even the implied warranty of              !!!!!!!!!!
!!!!!!!!!!        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               !!!!!!!!!!
!!!!!!!!!!        GNU General Public License for more details.                                !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        You should have received a copy of the GNU General Public License           !!!!!!!!!!
!!!!!!!!!!        along with PHI. If not, see <http://www.gnu.org/licenses/>.                 !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        We request that any results obtained through the use of PHI                 !!!!!!!!!!
!!!!!!!!!!        are accompanied by the following reference:                                 !!!!!!!!!!
!!!!!!!!!!        N. F. Chilton, R. P. Anderson, L. D. Turner, A. Soncini and                 !!!!!!!!!!
!!!!!!!!!!        K. S. Murray, J. Comput. Chem., 2013, 34, 1164 - 1175                       !!!!!!!!!!

module data
#ifdef gui
	use iso_c_binding
#endif
	implicit none
#ifdef mpi
	include 'mpif.h'
#endif

#ifndef versionvar
#define versionvar "?????"
#endif
	
	! Machinery
	real(kind=8)::D_NAN	!TRANSFER((/ Z'00000000', Z'7FF80000' /),1.0_8)
	real(kind=8),parameter::kB = 1.3806488D-23,wavenumber_to_erg = (1.98644568326930306D-23)*1D7, g_electron = 2.00231930436153_8, Na = 6.02214129D23, Pie = 3.141592653589793238462643383279502884197_8
	real(kind=8)::beta,erg_beta,EnergyConvert
	real(kind=8)::integer_limit,FACT(0:400),EPS,infinity,negative_infinity,UNDERFLOW,SFMIN,DLAMCH
	integer::start_time(8),mpi_size,mpi_rank,mpi_local_size,mpi_local_rank,mpi_error1,mpi_error2,xPU,done_spin,done_ion,done_orbit,done_metaltype,done_gfac,done_exch,done_anti,done_inter,done_soc,done_ored,done_crys,done_sus,done_mag,done_epr,done_survey,done_fit,done_params,done_zee,done_mce,done_heat,done_tensor,done_shift,printPercent,residualType,maxCPU,maxGPU,plasma_num_cores,noPrint,FullWF,show_binning,printed_binning,NoOEF,FEvals,aniso,approx,largest_6J_index,random_kiss_x,random_kiss_y,random_kiss_z,random_kiss_w,global_percent,global_total
	character(len=300)::OperationMode,OperationModeB,Single_Ion,FitMethod
	character(len=10000)::JobTitle,WorkDir,SaveTxt
	character(len=3)::GDir
	character(len=5)::versionholder
	logical::TF,high_prec
#ifdef gui
	logical,bind(c)::return_all,epr_do_zeeman
#else
	logical::return_all
#endif
#ifdef omp
	integer::OMP_get_num_procs,OMP_get_num_threads,OMP_get_thread_num,OMP_get_team_size,OMP_get_max_active_levels,OMP_get_level
	logical::OMP_get_nested
#endif
	
	! Spin System
	real(kind=8),allocatable::lamda(:,:),EXmat(:,:,:,:),Jss(:,:,:),dss(:,:,:),A2(:,:),A4(:,:),A6(:,:),CFP_rot(:,:),orbred(:),Gmat(:,:,:),EX_rot(:,:,:),SF2(:),SF4(:),SF6(:),Gfactor(:,:),store_6J(:),energy_shift(:)
	real(kind=8)::ImpQuant,unit_cell(6),spin_map(9)
	character(len=10)::space_group
	integer::N,maxSnum,maxLnum,totaldim,SingleXtal,ImpS,global_couple_pos,NumBlocks,Sdim
	integer,allocatable::twoS(:),twoL(:),MetalType(:),LocS(:),LocL(:),basis_lookup(:,:),coupled_basis(:,:),do_rotate(:),do_exrotate(:,:),force_cubic(:),Ln_J(:),D_not_B20(:),JJ_not_SS(:,:),S_localdim(:,:),S_basis(:,:)
	logical::use_interaction_matrix,ored_only_zeeman
	
	! Susceptibility
	real(kind=8),allocatable::sus_temps(:),sus_fields(:),sus_exp(:,:),sus_calc(:,:),sus_exp_temps(:)
	real(kind=8)::sus_high_temp,sus_low_temp,sus_field_vec(3),sus_tip,sus_zJ
	integer::sus_numT,sus_numB,sus_intCover,sus_intLevel,sus_autoscale,sus_exp_numT,sus_exp_numB
	character(len=3)::sus_sweep_scale
	logical::sus_differential
	
	! Magnetization
	real(kind=8),allocatable::mag_fields(:),mag_temps(:),mag_exp(:,:),mag_calc(:,:),mag_exp_fields(:)
	real(kind=8)::mag_low_field,mag_high_field,mag_field_vec(3)
	integer::mag_numB,mag_numT,mag_intCover,mag_intLevel,mag_autoscale,mag_exp_numB,mag_exp_numT
	character(len=3)::mag_sweep_scale
	
	! Tensor
	real(kind=8),allocatable::tensor_fields(:),tensor_temps(:),tensor_exp(:,:,:),tensor_calc(:,:,:),tensor_exp_temps(:)
	real(kind=8)::tensor_low_temp,tensor_high_temp,tensor_field_vec(3)
	integer::tensor_numB,tensor_numT,tensor_intCover,tensor_intLevel,tensor_exp_numT,tensor_exp_numB
	character(len=3)::tensor_sweep_scale
	
	! MCE
	real(kind=8),allocatable::mce_fields(:),mce_temps(:),mce_exp(:,:),mce_calc(:,:),mce_exp_temps(:)
	real(kind=8)::mce_low_temp,mce_high_temp,mce_mass,mce_field_vec(3)
	integer::mce_numT,mce_numB,mce_integration,mce_intCover,mce_intLevel,mce_exp_numT,mce_exp_numB
	character(len=3)::mce_sweep_scale
	
	! Heat Capacity
	real(kind=8),allocatable::heat_fields(:),heat_temps(:),heat_exp(:,:),heat_calc(:,:),heat_exp_temps(:)
	real(kind=8)::heat_low_temp,heat_high_temp,heat_field_vec(3),heat_lattice(2)
	integer::heat_numT,heat_numB,heat_intCover,heat_intLevel,heat_exp_numT,heat_exp_numB
	character(len=3)::heat_sweep_scale
	
	! EPR
	real(kind=8),allocatable::epr_exp_fields(:),epr_fields(:),epr_temps(:),epr_freqs(:),epr_exp(:,:,:),epr_calc(:,:,:),epr_linewidth(:,:),epr_pert_vals(:),epr_voigt(:),epr_mosaic(:),epr_strain_lamda(:,:),epr_strain_EXmat(:,:,:,:),epr_strain_Jss(:,:,:),epr_strain_dss(:,:,:),epr_strain_A2(:,:),epr_strain_A4(:,:),epr_strain_A6(:,:),epr_strain_orbred(:),epr_strain_Gmat(:,:,:),epr_strain_Gfactor(:,:),epr_wave_params(:,:,:)
	complex(kind=8),allocatable::epr_pert_vecs(:,:),epr_wave_exp(:,:,:,:)
	real(kind=8)::epr_low_field,epr_high_field,epr_field_vec(3)
	integer::epr_exp_numB,epr_numB,epr_numT,epr_numF,epr_parallel_mode,epr_intCover,epr_intLevel,epr_subdim,epr_do_subspace,epr_exp_numTF
	integer,allocatable::epr_type(:),epr_iso_G_strain(:),epr_iso_ex_strain(:,:)
	character(len=3)::epr_sweep_scale
	logical::epr_normalise,wavelet_error
	
	! Zeeman
	real(kind=8),allocatable::zee_fields(:),zee_calc(:,:)
	real(kind=8)::zee_low_field,zee_high_field,zee_field_vec(3)
	integer::zee_numB,zee_intCover,zee_intLevel
	character(len=3)::zee_sweep_scale
	
	! States
	real(kind=8),allocatable::levs_exp(:),levs_calc(:),g_exp(:,:),gdir_exp(:,:,:),g_calc(:,:),gdir_calc(:,:,:),me_exp(:,:,:)!,states_vecsR(:,:)
	complex(kind=8),allocatable::me_calc(:,:,:)
	!complex(kind=8),allocatable::states_vecsI(:,:)
	real(kind=8)::static_field_magnitude,static_field_direction(3)
	integer::levs_numExp,g_numExp,given_multiplicities,num_mult,g_numCalc,vecs_numExp
	integer,allocatable::GtenDegen(:)
	
	! Fitting
	character(len=2),allocatable::fit_codes(:,:)
	integer,allocatable::fit_nums(:,:,:),fit_N2(:)
	integer::fit_NOps,fit_NPOps,fit_uncertainties,uncert_in_progress,ncom,fit_pause,fit_max_iter,fit_Npoints
	real(kind=8)::FitVigour,initResidual,xicom(50),pcom(50),FitLimit,FitTolerance,bestResidual,star_correlation(16,3)
	real(kind=8),allocatable::fit_init(:),fit_vec(:,:),fit_yq(:),fit_limits(:,:)
	logical::fit_star
	
	! Survey
	character(len=300)::surveyTarget
	character(len=2),allocatable::sur_codes(:,:)
	integer,allocatable::sur_nums(:,:,:),sur_steps(:),sur_N2(:)
	integer::sur_NOps,sur_NPOps,sur_save
	real(kind=8),allocatable::sur_init(:),sur_final(:)
#ifdef gui
	!C++ data structures
	type(c_ptr)::ptr_to_C_code
#endif
	
!#ifdef gpu
!	EXTERNAL cula_zheev
!	EXTERNAL cula_geterrorinfo
!	EXTERNAL cula_initialize
!	EXTERNAL cula_shutdown
!	EXTERNAL cula_dsyev
!	EXTERNAL cula_dgemm
!	EXTERNAL cula_zgemm
!	EXTERNAL cula_GetDeviceCount
!#endif
#ifdef omp
	EXTERNAL OMP_get_num_procs
	EXTERNAL OMP_set_num_threads
	EXTERNAL OMP_get_num_threads
	EXTERNAL OMP_get_thread_num
	EXTERNAL OMP_get_nested
	EXTERNAL OMP_get_team_size
	EXTERNAL OMP_get_max_active_levels
	EXTERNAL OMP_get_level
#endif
	EXTERNAL DLAMCH
	EXTERNAL ZDOTU
	
#ifdef gui
	interface
		subroutine send_plot_signal(string,ptr) bind(c)
			use iso_c_binding
			character(c_char),intent(in)::string(*)
			type(c_ptr),intent(in),value::ptr
		end subroutine send_plot_signal
	end interface
	
	interface
		subroutine send_plot_data(string, num, data) bind(c)
			use iso_c_binding
			character(c_char),intent(in)::string(*)
			integer(c_int),intent(in),value::num
			real(c_double),intent(in),value::data
		end subroutine send_plot_data
	end interface
	
	interface
		subroutine send_states_signal(ptr) bind(c)
			use iso_c_binding
			type(c_ptr),intent(in),value::ptr
		end subroutine send_states_signal
	end interface
	
	interface
		subroutine send_output_signal(ptr) bind(c)
			use iso_c_binding
			type(c_ptr),intent(in),value::ptr
		end subroutine send_output_signal
	end interface
	
	interface
		subroutine send_text(string,num,ptr) bind(c)
			use iso_c_binding
			character(c_char),intent(in)::string(*)
			integer(c_int),intent(in),value::num
			type(c_ptr),intent(in),value::ptr
		end subroutine send_text
	end interface
	
	interface
		subroutine send_progress(num,ptr) bind(c)
			use iso_c_binding
			integer(c_int),intent(in),value::num
			type(c_ptr),intent(in),value::ptr
		end subroutine send_progress
	end interface
#endif

	contains
	
	subroutine deallocate_all
	! Deallocates any remaining global dynamic memory
	implicit none
	if(return_all) then
		!write(6,*) "BM"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BM"
	end if
	if(allocated(lamda)) deallocate(lamda)
	if(allocated(EXmat)) deallocate(EXmat)
	if(allocated(Jss)) deallocate(Jss)
	if(allocated(dss)) deallocate(dss)
	if(allocated(A2)) deallocate(A2)
	if(allocated(A4)) deallocate(A4)
	if(allocated(A6)) deallocate(A6)
	if(allocated(CFP_rot)) deallocate(CFP_rot)
	if(allocated(orbred)) deallocate(orbred)
	if(allocated(Gmat)) deallocate(Gmat)
	if(allocated(EX_rot)) deallocate(EX_rot)
	if(allocated(SF2)) deallocate(SF2)
	if(allocated(SF4)) deallocate(SF4)
	if(allocated(SF6)) deallocate(SF6)
	if(allocated(Gfactor)) deallocate(Gfactor)
	if(allocated(store_6J)) deallocate(store_6J)
	if(allocated(twoS)) deallocate(twoS)
	if(allocated(twoL)) deallocate(twoL)
	if(allocated(MetalType)) deallocate(MetalType)
	if(allocated(LocS)) deallocate(LocS)
	if(allocated(LocL)) deallocate(LocL)
	if(allocated(basis_lookup)) deallocate(basis_lookup)
	if(allocated(coupled_basis)) deallocate(coupled_basis)
	if(allocated(do_rotate)) deallocate(do_rotate)
	if(allocated(do_exrotate)) deallocate(do_exrotate)
	if(allocated(force_cubic)) deallocate(force_cubic)
	if(allocated(Ln_J)) deallocate(Ln_J)
	if(allocated(D_not_B20)) deallocate(D_not_B20)
	if(allocated(JJ_not_SS)) deallocate(JJ_not_SS)
	if(allocated(S_localdim)) deallocate(S_localdim)
	if(allocated(S_basis)) deallocate(S_basis)
	if(allocated(sus_exp_temps)) deallocate(sus_exp_temps)
	if(allocated(sus_temps)) deallocate(sus_temps)
	if(allocated(sus_fields)) deallocate(sus_fields)
	if(allocated(sus_exp)) deallocate(sus_exp)
	if(allocated(sus_calc)) deallocate(sus_calc)
	if(allocated(mag_exp_fields)) deallocate(mag_exp_fields)
	if(allocated(mag_fields)) deallocate(mag_fields)
	if(allocated(mag_temps)) deallocate(mag_temps)
	if(allocated(mag_exp)) deallocate(mag_exp)
	if(allocated(mag_calc)) deallocate(mag_calc)
	if(allocated(mce_fields)) deallocate(mce_fields)
	if(allocated(mce_exp_temps)) deallocate(mce_exp_temps)
	if(allocated(mce_temps)) deallocate(mce_temps)
	if(allocated(mce_exp)) deallocate(mce_exp)
	if(allocated(mce_calc)) deallocate(mce_calc)
	if(allocated(heat_fields)) deallocate(heat_fields)
	if(allocated(heat_exp_temps)) deallocate(heat_exp_temps)
	if(allocated(heat_temps)) deallocate(heat_temps)
	if(allocated(heat_exp)) deallocate(heat_exp)
	if(allocated(heat_calc)) deallocate(heat_calc)
	if(allocated(epr_exp_fields)) deallocate(epr_exp_fields)
	if(allocated(epr_fields)) deallocate(epr_fields)
	if(allocated(epr_temps)) deallocate(epr_temps)
	if(allocated(epr_freqs)) deallocate(epr_freqs)
	if(allocated(epr_linewidth)) deallocate(epr_linewidth)
	if(allocated(epr_voigt)) deallocate(epr_voigt)
	if(allocated(epr_mosaic)) deallocate(epr_mosaic)
	if(allocated(epr_exp)) deallocate(epr_exp)
	if(allocated(epr_calc)) deallocate(epr_calc)
	if(allocated(epr_type)) deallocate(epr_type)
	if(allocated(epr_pert_vecs)) deallocate(epr_pert_vecs)
	if(allocated(epr_pert_vals)) deallocate(epr_pert_vals)
	if(allocated(epr_strain_Gfactor)) deallocate(epr_strain_Gfactor)
	if(allocated(epr_strain_Gmat)) deallocate(epr_strain_Gmat)
	if(allocated(epr_strain_orbred)) deallocate(epr_strain_orbred)
	if(allocated(epr_strain_A6)) deallocate(epr_strain_A6)
	if(allocated(epr_strain_A4)) deallocate(epr_strain_A4)
	if(allocated(epr_strain_A2)) deallocate(epr_strain_A2)
	if(allocated(epr_strain_dss)) deallocate(epr_strain_dss)
	if(allocated(epr_strain_Jss)) deallocate(epr_strain_Jss)
	if(allocated(epr_strain_EXmat)) deallocate(epr_strain_EXmat)
	if(allocated(epr_strain_lamda)) deallocate(epr_strain_lamda)
	if(allocated(epr_iso_ex_strain)) deallocate(epr_iso_ex_strain)
	if(allocated(epr_iso_G_strain)) deallocate(epr_iso_G_strain)
	if(allocated(zee_fields)) deallocate(zee_fields)
	if(allocated(zee_calc)) deallocate(zee_calc)
	if(allocated(levs_exp)) deallocate(levs_exp)
	if(allocated(levs_calc)) deallocate(levs_calc)
	if(allocated(me_exp)) deallocate(me_exp)
	if(allocated(me_calc)) deallocate(me_calc)
	if(allocated(g_exp)) deallocate(g_exp)
	if(allocated(gdir_exp)) deallocate(gdir_exp)
	if(allocated(g_calc)) deallocate(g_calc)
	if(allocated(gdir_calc)) deallocate(gdir_calc)
	if(allocated(GtenDegen)) deallocate(GtenDegen)
	if(allocated(fit_codes)) deallocate(fit_codes)
	if(allocated(fit_nums)) deallocate(fit_nums)
	if(allocated(fit_N2)) deallocate(fit_N2)
	if(allocated(fit_init)) deallocate(fit_init)
	if(allocated(fit_vec)) deallocate(fit_vec)
	if(allocated(fit_yq)) deallocate(fit_yq)
	if(allocated(fit_limits)) deallocate(fit_limits)
	if(allocated(sur_codes)) deallocate(sur_codes)
	if(allocated(sur_nums)) deallocate(sur_nums)
	if(allocated(sur_steps)) deallocate(sur_steps)
	if(allocated(sur_N2)) deallocate(sur_N2)
	if(allocated(sur_init)) deallocate(sur_init)
	if(allocated(sur_final)) deallocate(sur_final)
	if(allocated(tensor_fields)) deallocate(tensor_fields)
	if(allocated(tensor_temps)) deallocate(tensor_temps)
	if(allocated(tensor_exp)) deallocate(tensor_exp)
	if(allocated(tensor_calc)) deallocate(tensor_calc)
	if(allocated(tensor_exp_temps)) deallocate(tensor_exp_temps)
	if(allocated(epr_wave_exp)) deallocate(epr_wave_exp)
	if(allocated(epr_wave_params)) deallocate(epr_wave_params)
	if(allocated(energy_shift)) deallocate(energy_shift)
	end subroutine deallocate_all
	
	subroutine set_consts
	! Defines factorials and integer limits
	implicit none
	integer::i
	if(bit_size(1) == 32) then
		integer_limit = 2147483646.0_8
		fit_max_iter = 2147483646
	else if(bit_size(1) == 64) then
		integer_limit = 9223372036854775806.0_8
		fit_max_iter = 9223372036854775806
	else
		call output_text("Integers do not seem to be 32- or 64-bit",.false.)
		call control('kill ')
		return
	end if
	FACT(0) = 1.0_8
	do i = 1,400
		FACT(i) = dble(i)*FACT(i-1)
	end do
	EPS = DLAMCH('E')
	!write(6,*) 'EPS = ',EPS
	call random_kiss_seed
	do i = 1,4444
		infinity = random_kiss()
	end do
	infinity = 1.0_8/0.0_8
	negative_infinity = -infinity
	UNDERFLOW = DLAMCH('U')
	SFMIN = DLAMCH('S')
	largest_6J_index = 1
	SaveTxt = ''
	D_NAN = dsqrt(-FACT(0))
	end subroutine set_consts
	
	subroutine data_read(file,numx,numy,lines)
	! Directly reads the files for read_exp_data
	implicit none
	character(len=1000)::lines(:)
	character(len=*)::file
	character(len=100)::check(100)
	logical::got_access
	integer::k,IOstatus,numx,numy,i,d
	numx = 0
	numy = 0
	inquire(file=trim(WorkDir)//"/"//trim(file),exist=got_access)
	if(return_all) then
		!write(6,*) "BN"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BN"
	end if
	if(.not. got_access) then
		if(OperationMode(1:3) == 'sim') return
		call output_text(trim(file)//" not found",.false.)
		call control('kill ')
		return
	end if
#ifdef mpi
	call MPI_BARRIER(MPI_COMM_WORLD,mpi_error1)
#endif
	open(24,file=trim(WorkDir)//"/"//trim(file),status='old')
	do k=1,size(lines)
		read(24,'(A)',end=30,IOSTAT=IOstatus) lines(k)
		if(IOstatus /= 0) then
			SaveTxt = ""
			write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
			call output_text(SaveTxt,.false.)
			call output_text("Check: "//trim(file),.false.)
			call control('kill ')
			return
		end if
	end do
30	CONTINUE
	close(24)
	numx = k-1
	do k=1,numx
		if(trim(lines(k)) == '') then
			do i=k,numx-1
				lines(i) = lines(i+1)
			end do
			numx = numx - 1
		end if
		do i = 1,len_trim(lines(k))
			if(lines(k)(i:i) == "	") lines(k)(i:i) = " "
		end do
		lines(k) = adjustl(lines(k))
		d = index(trim(lines(k)),"  ")
		do while(d > 0)
			i = len_trim(lines(k))
			lines(k)(d+1:i-1) = lines(k)(d+2:i)
			lines(k)(i:i) = " "
			d = index(trim(lines(k)),"  ")
		end do
	end do
	do k = 1,size(check)
		read(lines(1),*,IOSTAT=IOstatus) check(1:k)
		if(IOstatus /= 0) then
			i = k-1
			exit
		end if
	end do
	do d = 2,numx
		do k = 1,size(check)
			read(lines(d),*,IOSTAT=IOstatus) check(1:k)
			if(IOstatus /= 0) then
				if(k-1 /= i) then
					call output_text("Data array is not regular!",.false.)
					call output_text("Check: "//trim(file),.false.)
					call control('kill ')
					return
				end if
				exit
			end if
		end do
	end do
	numy = i-1
	end subroutine data_read
	
	subroutine read_exp_data
	! Reads experimental data or generates neccesary files.
	implicit none
	integer::k,num_line,blanks,IOStatus,i,d,j
	real(kind=8)::localh,localhtemp,low_log,high_log
	real(kind=8),allocatable::test(:)
	character(len=1000),allocatable::lines(:),data_temp(:)
	if(return_all) then
		!write(6,*) "BO"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BO"
	end if
	num_line = 20000
	blanks = 0
	allocate(lines(num_line))
	if(scan(OperationModeB,'s',.false.) /= 0) then
		call data_read(trim(JobTitle)//"_sus.exp",sus_exp_numT,sus_exp_numB,lines)
		if(sus_exp_numT /= 0 .and. sus_exp_numB /= 0) then
			allocate(sus_exp_temps(sus_exp_numT),sus_exp(sus_exp_numB,sus_exp_numT))
			sus_exp_temps = 0.0_8
			sus_exp = 0.0_8
			allocate(data_temp(sus_exp_numB))
			do k=1,sus_exp_numT
				read(lines(k),*,IOSTAT=IOstatus) sus_exp_temps(k), data_temp(:)
				if(IOstatus /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_sus.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				do i = 1,sus_exp_numB
					if(trim(data_temp(i)) == '.' .or. trim(data_temp(i)) == '?' .or. trim(data_temp(i)) == '!' .or. trim(data_temp(i)) == '#' .or. trim(data_temp(i)) == '//' .or. trim(data_temp(i)) == '*') then
						sus_exp(i,k) = D_NAN
					else
						read(data_temp(i),*,IOSTAT=IOstatus) sus_exp(i,k)
						if(IOstatus /= 0) then
							SaveTxt = ""
							write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
							call output_text(SaveTxt,.false.)
							call output_text("Check: "//trim(JobTitle)//"_sus.exp",.false.)
							deallocate(lines)
							call control('kill ')
							return
						end if
					end if
				end do
			end do
			deallocate(data_temp)
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				if(sus_exp_numB /= sus_numB) then
					SaveTxt = ""
					write(SaveTxt,'(I2,A21,I2,A10)') sus_exp_numB," field(s) found, but ",sus_numB," expected."
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_sus.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				sus_numT = sus_exp_numT
				allocate(sus_temps(sus_numT),sus_calc(sus_numB,sus_numT))
				sus_temps = sus_exp_temps
			end if
		else
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				call output_text("No data found!",.false.)
				call output_text("Check: "//trim(JobTitle)//"_sus.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
		end if
		if(OperationMode(1:3) == 'sim') then
			allocate(sus_temps(sus_numT),sus_calc(sus_numB,sus_numT))
			sus_temps = 0.0_8
			if(sus_sweep_scale == 'lin') then
				do k = 1,sus_numT
					sus_temps(k) = ((sus_high_temp-sus_low_temp)/(sus_numT-1))*k - ((sus_high_temp-sus_low_temp)/(sus_numT-1)) + sus_low_temp
				end do
			else if(sus_sweep_scale == 'log') then
				low_log = dlog10(sus_low_temp)
				high_log = dlog10(sus_high_temp)
				do k = 1,sus_numT
					sus_temps(k) = ((high_log-low_log)/(sus_numT-1))*k - ((high_log-low_log)/(sus_numT-1)) + low_log
				end do
				sus_temps = 10.0_8**sus_temps
			end if
			if(sus_numT == 1) sus_temps = sus_low_temp
		end if
	end if
	if(scan(OperationModeB,'t',.false.) /= 0) then
		call data_read(trim(JobTitle)//"_tensor.exp",tensor_exp_numT,tensor_exp_numB,lines)
		tensor_exp_numB = tensor_exp_numB/6
		if(tensor_exp_numT /= 0 .and. tensor_exp_numB /= 0) then
			allocate(tensor_exp_temps(tensor_exp_numT),tensor_exp(tensor_exp_numB,tensor_exp_numT,6))
			tensor_exp_temps = 0.0_8
			tensor_exp = 0.0_8
			allocate(data_temp(tensor_exp_numB*6))
			do k=1,tensor_exp_numT
				read(lines(k),*,IOSTAT=IOstatus) tensor_exp_temps(k), data_temp(:)
				if(IOstatus /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_tensor.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				do i = 1,tensor_exp_numB
					do j = 1,6
						if(trim(data_temp((i-1)*6+j)) == '.' .or. trim(data_temp((i-1)*6+j)) == '?' .or. trim(data_temp((i-1)*6+j)) == '!' .or. trim(data_temp((i-1)*6+j)) == '#' .or. trim(data_temp((i-1)*6+j)) == '//' .or. trim(data_temp((i-1)*6+j)) == '*') then
							tensor_exp(i,k,j) = D_NAN
						else
							read(data_temp((i-1)*6+j),*,IOSTAT=IOstatus) tensor_exp(i,k,j)
							if(IOstatus /= 0) then
								SaveTxt = ""
								write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
								call output_text(SaveTxt,.false.)
								call output_text("Check: "//trim(JobTitle)//"_tensor.exp",.false.)
								deallocate(lines)
								call control('kill ')
								return
							end if
						end if
					end do
				end do
			end do
			deallocate(data_temp)
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				if(tensor_exp_numB /= tensor_numB) then
					SaveTxt = ""
					write(SaveTxt,'(I2,A21,I2,A10)') tensor_exp_numB," field(s) found, but ",tensor_numB," expected."
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_tensor.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				tensor_numT = tensor_exp_numT
				allocate(tensor_temps(tensor_numT),tensor_calc(tensor_numB,tensor_numT,6))
				tensor_temps = tensor_exp_temps
			end if
		else
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				call output_text("No data found!",.false.)
				call output_text("Check: "//trim(JobTitle)//"_tensor.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
		end if
		if(OperationMode(1:3) == 'sim') then
			allocate(tensor_temps(tensor_numT),tensor_calc(tensor_numB,tensor_numT,6))
			tensor_temps = 0.0_8
			if(tensor_sweep_scale == 'lin') then
				do k = 1,tensor_numT
					tensor_temps(k) = ((tensor_high_temp-tensor_low_temp)/(tensor_numT-1))*k - ((tensor_high_temp-tensor_low_temp)/(tensor_numT-1)) + tensor_low_temp
				end do
			else if(tensor_sweep_scale == 'log') then
				low_log = dlog10(tensor_low_temp)
				high_log = dlog10(tensor_high_temp)
				do k = 1,tensor_numT
					tensor_temps(k) = ((high_log-low_log)/(tensor_numT-1))*k - ((high_log-low_log)/(tensor_numT-1)) + low_log
				end do
				tensor_temps = 10.0_8**tensor_temps
			end if
			if(tensor_numT == 1) tensor_temps = tensor_low_temp
		end if
	end if
	if(scan(OperationModeB,'m',.false.) /= 0) then
		call data_read(trim(JobTitle)//"_mag.exp",mag_exp_numB,mag_exp_numT,lines)
		if(mag_exp_numB /= 0 .and. mag_exp_numT /= 0) then
			allocate(mag_exp_fields(mag_exp_numB),mag_exp(mag_exp_numT,mag_exp_numB))
			mag_exp_fields = 0.0_8
			mag_exp = 0.0_8
			allocate(data_temp(mag_exp_numT))
			do k=1,mag_exp_numB
				read(lines(k),*,IOSTAT=IOstatus) mag_exp_fields(k), data_temp(:)
				if(IOstatus /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_mag.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				do i = 1,mag_exp_numT
					if(trim(data_temp(i)) == '.' .or. trim(data_temp(i)) == '?' .or. trim(data_temp(i)) == '!' .or. trim(data_temp(i)) == '#' .or. trim(data_temp(i)) == '//' .or. trim(data_temp(i)) == '*') then
						mag_exp(i,k) = D_NAN
					else
						read(data_temp(i),*,IOSTAT=IOstatus) mag_exp(i,k)
						if(IOstatus /= 0) then
							SaveTxt = ""
							write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
							call output_text(SaveTxt,.false.)
							call output_text("Check: "//trim(JobTitle)//"_mag.exp",.false.)
							deallocate(lines)
							call control('kill ')
							return
						end if
					end if
				end do
			end do
			deallocate(data_temp)
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				if(mag_exp_numT /= mag_numT) then
					SaveTxt = ""
					write(SaveTxt,'(I2,A21,I2,A10)') mag_exp_numT," temperature(s) found, but ",mag_numT," expected."
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_mag.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				mag_numB = mag_exp_numB
				allocate(mag_fields(mag_numB),mag_calc(mag_numT,mag_numB))
				mag_fields = mag_exp_fields
			end if
		else
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				call output_text("No data found!",.false.)
				call output_text("Check: "//trim(JobTitle)//"_mag.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
		end if
		if(OperationMode(1:3) == 'sim') then
			allocate(mag_fields(mag_numB),mag_calc(mag_numT,mag_numB))
			mag_fields = 0.0_8
			if(mag_sweep_scale == 'lin') then
				do k = 1,mag_numB
					mag_fields(k) = ((mag_high_field-mag_low_field)/(mag_numB-1))*k - ((mag_high_field-mag_low_field)/(mag_numB-1)) + mag_low_field
				end do
			else if(mag_sweep_scale == 'log') then
				low_log = dlog10(mag_low_field)
				high_log = dlog10(mag_high_field)
				do k = 1,mag_numB
					mag_fields(k) = ((high_log-low_log)/(mag_numB-1))*k - ((high_log-low_log)/(mag_numB-1)) + low_log
				end do
				mag_fields = 10.0_8**mag_fields
			end if
			if(mag_numB == 1) mag_fields = mag_low_field
		end if
	end if
	if(scan(OperationModeB,'c',.false.) /= 0) then
		call data_read(trim(JobTitle)//"_mce.exp",mce_exp_numT,mce_exp_numB,lines)
		if(mce_exp_numT /= 0 .and. mce_exp_numB /= 0) then
			allocate(mce_exp_temps(mce_exp_numT),mce_exp(mce_exp_numB,mce_exp_numT))
			mce_exp_temps = 0.0_8
			mce_exp = 0.0_8
			allocate(data_temp(mce_exp_numB))
			do k=1,mce_exp_numT
				read(lines(k),*,IOSTAT=IOstatus) mce_exp_temps(k), data_temp(:)
				if(IOstatus /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_mce.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				do i = 1,mce_exp_numB
					if(trim(data_temp(i)) == '.' .or. trim(data_temp(i)) == '?' .or. trim(data_temp(i)) == '!' .or. trim(data_temp(i)) == '#' .or. trim(data_temp(i)) == '//' .or. trim(data_temp(i)) == '*') then
						mce_exp(i,k) = D_NAN
					else
						read(data_temp(i),*,IOSTAT=IOstatus) mce_exp(i,k)
						if(IOstatus /= 0) then
							SaveTxt = ""
							write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
							call output_text(SaveTxt,.false.)
							call output_text("Check: "//trim(JobTitle)//"_mce.exp",.false.)
							deallocate(lines)
							call control('kill ')
							return
						end if
					end if
				end do
			end do
			deallocate(data_temp)
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				if(mce_exp_numB /= mce_numB) then
					SaveTxt = ""
					write(SaveTxt,'(I2,A21,I2,A10)') mce_exp_numB," field(s) found, but ",mce_numB," expected."
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_mce.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				mce_numT = mce_exp_numT
				allocate(mce_temps(mce_numT),mce_calc(mce_numB,mce_numT))
				mce_temps = mce_exp_temps
			end if
		else
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				call output_text("No data found!",.false.)
				call output_text("Check: "//trim(JobTitle)//"_mce.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
		end if
		if(OperationMode(1:3) == 'sim') then
			allocate(mce_temps(mce_numT),mce_calc(mce_numB,mce_numT))
			mce_temps = 0.0_8
			if(mce_sweep_scale == 'lin') then
				do k = 1,mce_numT
					mce_temps(k) = ((mce_high_temp-mce_low_temp)/(mce_numT-1))*k - ((mce_high_temp-mce_low_temp)/(mce_numT-1)) + mce_low_temp
				end do
			else if(mce_sweep_scale == 'log') then
				low_log = dlog10(mce_low_temp)
				high_log = dlog10(mce_high_temp)
				do k = 1,mce_numT
					mce_temps(k) = ((high_log-low_log)/(mce_numT-1))*k - ((high_log-low_log)/(mce_numT-1)) + low_log
				end do
				mce_temps = 10.0_8**mce_temps
			end if
			if(mce_numT == 1) mce_temps = mce_low_temp
		end if
	end if
	if(scan(OperationModeB,'h',.false.) /= 0) then
		call data_read(trim(JobTitle)//"_heat.exp",heat_exp_numT,heat_exp_numB,lines)
		if(heat_exp_numT /= 0 .and. heat_exp_numB /= 0) then
			allocate(heat_exp_temps(heat_exp_numT),heat_exp(heat_exp_numB,heat_exp_numT))
			heat_exp_temps = 0.0_8
			heat_exp = 0.0_8
			allocate(data_temp(heat_exp_numB))
			do k=1,heat_exp_numT
				read(lines(k),*,IOSTAT=IOstatus) heat_exp_temps(k), data_temp(:)
				if(IOstatus /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_heat.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				do i = 1,heat_exp_numB
					if(trim(data_temp(i)) == '.' .or. trim(data_temp(i)) == '?' .or. trim(data_temp(i)) == '!' .or. trim(data_temp(i)) == '#' .or. trim(data_temp(i)) == '//' .or. trim(data_temp(i)) == '*') then
						heat_exp(i,k) = D_NAN
					else
						read(data_temp(i),*,IOSTAT=IOstatus) heat_exp(i,k)
						if(IOstatus /= 0) then
							SaveTxt = ""
							write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
							call output_text(SaveTxt,.false.)
							call output_text("Check: "//trim(JobTitle)//"_heat.exp",.false.)
							deallocate(lines)
							call control('kill ')
							return
						end if
					end if
				end do
			end do
			deallocate(data_temp)
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				if(heat_exp_numB /= heat_numB) then
					SaveTxt = ""
					write(SaveTxt,'(I2,A21,I2,A10)') heat_exp_numB," field(s) found, but ",heat_numB," expected."
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_heat.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				heat_numT = heat_exp_numT
				allocate(heat_temps(heat_numT),heat_calc(heat_numB,heat_numT))
				heat_temps = heat_exp_temps
			end if
		else
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				call output_text("No data found!",.false.)
				call output_text("Check: "//trim(JobTitle)//"_heat.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
		end if
		if(OperationMode(1:3) == 'sim') then
			allocate(heat_temps(heat_numT),heat_calc(heat_numB,heat_numT))
			heat_temps = 0.0_8
			if(heat_sweep_scale == 'lin') then
				do k = 1,heat_numT
					heat_temps(k) = ((heat_high_temp-heat_low_temp)/(heat_numT-1))*k - ((heat_high_temp-heat_low_temp)/(heat_numT-1)) + heat_low_temp
				end do
			else if(heat_sweep_scale == 'log') then
				low_log = dlog10(heat_low_temp)
				high_log = dlog10(heat_high_temp)
				do k = 1,heat_numT
					heat_temps(k) = ((high_log-low_log)/(heat_numT-1))*k - ((high_log-low_log)/(heat_numT-1)) + low_log
				end do
				heat_temps = 10.0_8**heat_temps
			end if
			if(heat_numT == 1) heat_temps = heat_low_temp
		end if
	end if
	if(scan(OperationModeB,'z',.false.) /= 0) then
		allocate(zee_fields(zee_numB),zee_calc(totaldim,zee_numB))
		zee_fields = 0.0_8
		if(zee_sweep_scale == 'lin') then
			do k = 1,zee_numB
				zee_fields(k) = ((zee_high_field-zee_low_field)/(zee_numB-1))*k - ((zee_high_field-zee_low_field)/(zee_numB-1)) + zee_low_field
			end do
		else if(zee_sweep_scale == 'log') then
			low_log = dlog10(zee_low_field)
			high_log = dlog10(zee_high_field)
			do k = 1,zee_numB
				zee_fields(k) = ((high_log-low_log)/(zee_numB-1))*k - ((high_log-low_log)/(zee_numB-1)) + low_log
			end do
			zee_fields = 10.0_8**zee_fields
		end if
		if(zee_numB == 1) zee_fields = zee_low_field
	end if
	if(scan(OperationModeB,'l',.false.) /= 0) then
		allocate(levs_calc(totaldim))
		call data_read(trim(JobTitle)//"_levels.exp",levs_numExp,i,lines)
		if(levs_numExp > totaldim .and. (OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur')) then
			call output_text("More exp energy levels than possible with the spin system",.false.)
			call output_text("Check: "//trim(JobTitle)//"_levels.exp",.false.)
			deallocate(lines)
			call control('kill ')
			return
		end if
		allocate(levs_exp(levs_numExp))
		levs_exp = 0.0_8
		do k=1,levs_numExp
			if(trim(adjustl(lines(k))) == '?' .or. trim(adjustl(lines(k))) == '.' .or. trim(adjustl(lines(k))) == '!' .or. trim(adjustl(lines(k))) == '#' .or. trim(adjustl(lines(k))) == '//' .or. trim(adjustl(lines(k))) == '*') then
				levs_exp(k) = D_NAN
			else
				read(lines(k),*,IOSTAT=IOstatus) levs_exp(k)
				if(IOstatus /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_levels.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
			end if
		end do
	end if
	if(scan(OperationModeB,'g',.false.) /= 0) then
		call data_read(trim(JobTitle)//"_G.exp",g_numExp,i,lines)
		if(g_numExp > totaldim/2 .and. (OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur')) then
			call output_text("More exp g-tensors than possible with the spin system",.false.)
			call output_text("Check: "//trim(JobTitle)//"_G.exp",.false.)
			deallocate(lines)
			call control('kill ')
			return
		end if
		allocate(g_exp(3,g_numExp),data_temp(3))
		g_exp = 0.0_8
		do k=1,g_numExp
			read(lines(k),*,IOSTAT=IOstatus) data_temp(:)
			if(IOstatus /= 0) then
				SaveTxt = ""
				write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
				call output_text(SaveTxt,.false.)
				call output_text("Check: "//trim(JobTitle)//"_G.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			do i = 1,3
				if(trim(data_temp(i)) == '.' .or. trim(data_temp(i)) == '?' .or. trim(data_temp(i)) == '!' .or. trim(data_temp(i)) == '#' .or. trim(data_temp(i)) == '//' .or. trim(data_temp(i)) == '*') then
					g_exp(i,k) = D_NAN
				else
					read(data_temp(i),*,IOSTAT=IOstatus) g_exp(i,k)
					if(IOstatus /= 0) then
						SaveTxt = ""
						write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
						call output_text(SaveTxt,.false.)
						call output_text("Check: "//trim(JobTitle)//"_G.exp",.false.)
						deallocate(lines)
						call control('kill ')
						return
					end if
				end if
			end do
		end do
		deallocate(data_temp)
		if(scan(OperationModeB,'l',.false.) == 0) allocate(levs_calc(totaldim))
	end if
	if(scan(OperationModeB,'d',.false.) /= 0) then
		call data_read(trim(JobTitle)//"_G.exp",g_numExp,i,lines)
		if(g_numExp > totaldim/2 .and. (OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur')) then
			call output_text("More exp g-tensors than possible with the spin system",.false.)
			call output_text("Check: "//trim(JobTitle)//"_G.exp",.false.)
			deallocate(lines)
			call control('kill ')
			return
		end if
		allocate(g_exp(3,g_numExp),gdir_exp(3,3,g_numExp),data_temp(12))
		g_exp = 0.0_8
		gdir_exp = 0.0_8
		g_exp = 0.0_8
		do k=1,g_numExp
			read(lines(k),*,IOSTAT=IOstatus) data_temp(:)
			if(IOstatus /= 0) then
				SaveTxt = ""
				write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
				call output_text(SaveTxt,.false.)
				call output_text("Check: "//trim(JobTitle)//"_G.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			do i = 1,12
				if(trim(data_temp(i)) == '.' .or. trim(data_temp(i)) == '?' .or. trim(data_temp(i)) == '!' .or. trim(data_temp(i)) == '#' .or. trim(data_temp(i)) == '//' .or. trim(data_temp(i)) == '*') then
					if(i <= 3) g_exp(i,k) = D_NAN
					if(i >= 4 .and. i <= 6) gdir_exp(i-3,1,k) = D_NAN
					if(i >= 7 .and. i <= 9) gdir_exp(i-6,2,k) = D_NAN
					if(i >= 10 .and. i <= 12) gdir_exp(i-9,3,k) = D_NAN
				else
					if(i <= 3) read(data_temp(i),*,IOSTAT=IOstatus) g_exp(i,k)
					if(i >= 4 .and. i <= 6) read(data_temp(i),*,IOSTAT=IOstatus) gdir_exp(i-3,1,k)
					if(i >= 7 .and. i <= 9) read(data_temp(i),*,IOSTAT=IOstatus) gdir_exp(i-6,2,k)
					if(i >= 10 .and. i <= 12) read(data_temp(i),*,IOSTAT=IOstatus) gdir_exp(i-9,3,k)
					if(IOstatus /= 0) then
						SaveTxt = ""
						write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
						call output_text(SaveTxt,.false.)
						call output_text("Check: "//trim(JobTitle)//"_G.exp",.false.)
						call control('kill ')
						return
					end if
				end if
			end do
		end do
		deallocate(data_temp)
		if(scan(OperationModeB,'l',.false.) == 0) allocate(levs_calc(totaldim))
	end if
	if(scan(OperationModeB,'x',.false.) /= 0) then
		write(6,*) "allocating mes"
		allocate(me_exp(3,totaldim,totaldim),me_calc(3,totaldim,totaldim))
		open(44,file=trim(WorkDir)//"/"//trim(JobTitle)//"_me.exp")
		do k = 1,totaldim
			read(44,*) me_exp(1,k,:)
		end do
		read(44,*)
		do k = 1,totaldim
			read(44,*) me_exp(2,k,:)
		end do
		read(44,*)
		do k = 1,totaldim
			read(44,*) me_exp(3,k,:)
		end do
		close(44)
		write(6,*) "read mes"
	end if
	if(scan(OperationModeB,'e',.false.) /= 0) then
		call data_read(trim(JobTitle)//"_epr.exp",epr_exp_numB,epr_exp_numTF,lines)
		if(epr_exp_numB /= 0 .and. epr_exp_numTF /= 0) then
			if(epr_exp_numTF /= epr_numT*epr_numF) then
				SaveTxt = ""
				write(SaveTxt,'(I2,A42,I2,A10)') epr_exp_numTF," temperature(s)*frequency(ies) found, but ",epr_numF*epr_numT," expected."
				call output_text(SaveTxt,.false.)
				call output_text("Check: "//trim(JobTitle)//"_epr.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			allocate(epr_exp_fields(epr_exp_numB),epr_exp(epr_numF,epr_numT,epr_exp_numB))
			epr_exp_fields = 0.0_8
			epr_exp = 0.0_8
			allocate(data_temp(epr_exp_numTF))
			do k=1,epr_exp_numB
				read(lines(k),*,IOSTAT=IOstatus) epr_exp_fields(k), data_temp(:)
				if(IOstatus /= 0) then
					SaveTxt = ""
					write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
					call output_text(SaveTxt,.false.)
					call output_text("Check: "//trim(JobTitle)//"_epr.exp",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				i = 0
				do j = 1,epr_numF
					do d = 1,epr_numT
						i = i + 1
						if(trim(data_temp(i)) == '.' .or. trim(data_temp(i)) == '?' .or. trim(data_temp(i)) == '!' .or. trim(data_temp(i)) == '#' .or. trim(data_temp(i)) == '//' .or. trim(data_temp(i)) == '*') then
							epr_exp(j,d,k) = D_NAN
						else
							read(data_temp(i),*,IOSTAT=IOstatus) epr_exp(j,d,k)
							if(IOstatus /= 0) then
								SaveTxt = ""
								write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
								call output_text(SaveTxt,.false.)
								call output_text("Check: "//trim(JobTitle)//"_epr.exp",.false.)
								deallocate(lines)
								call control('kill ')
								return
							end if
						end if
					end do
				end do
			end do
			deallocate(data_temp)
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				epr_numB = epr_exp_numB
				allocate(epr_fields(epr_numB),epr_calc(epr_numF,epr_numT,epr_numB))
				epr_fields = epr_exp_fields
			end if
		else
			if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
				call output_text("No data found!",.false.)
				call output_text("Check: "//trim(JobTitle)//"_epr.exp",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
		end if
		if(OperationMode(1:3) == 'sim') then
			allocate(epr_fields(epr_numB),epr_calc(epr_numF,epr_numT,epr_numB))
			epr_fields = 0.0_8
			if(epr_sweep_scale == 'lin') then
				do k = 1,epr_numB
					epr_fields(k) = ((epr_high_field-epr_low_field)/(epr_numB-1))*k - ((epr_high_field-epr_low_field)/(epr_numB-1)) + epr_low_field
				end do
			else if(epr_sweep_scale == 'log') then
				low_log = dlog10(epr_low_field)
				high_log = dlog10(epr_high_field)
				do k = 1,epr_numB
					epr_fields(k) = ((high_log-low_log)/(epr_numB-1))*k - ((high_log-low_log)/(epr_numB-1)) + low_log
				end do
				epr_fields = 10.0_8**epr_fields
			end if
			if(epr_numB == 1) epr_fields = epr_low_field
		end if
	end if
	deallocate(lines)
	end subroutine read_exp_data
	
	subroutine smart_reading
	! Reads PHI input file and performs checks and conversions
	implicit none
	character(len=500),save::line,char_temp
	character(len=500),save,allocatable::lines(:)
	integer::cut_lines,number_lines,line_iter,i,j,k,d,ii,jj,kk,kk2,dd,dd2,j2,jj2,j3,jj3,comps,brackets,N1a,N2a,N3a,numAs,ender,big_ender,last_asteriskA,last_asteriskB,asterisk_search,IOstatus,temp_int(100),done_sus_field,done_tensor_field,done_mag_field,done_mce_field,done_epr_field,done_heat_field,poss_blocks
	integer,allocatable::fit_N22(:),sur_N22(:),block_check(:),block_order(:)
	real(kind=8)::temp(100),localh,localhtemp
	logical::got_access
	if(return_all) then
		!write(6,*) "BQ"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ"
	end if
	
	poss_blocks = 22
	allocate(block_check(poss_blocks+1),block_order(poss_blocks+1))
	allocate(fit_N2(100),sur_N2(100))
	done_spin = 0
	done_ion = 0
	done_orbit = 0
	done_metaltype = 0
	done_gfac = 0
	done_exch = 0
	done_anti = 0
	done_inter = 0
	done_soc = 0
	done_ored = 0
	done_crys = 0
	done_sus = 0
	done_mag = 0
	done_mce = 0
	done_epr = 0
	done_survey = 0
	done_fit = 0
	done_params = 0
	done_zee = 0
	done_heat = 0
	done_tensor = 0
	done_shift = 0
	block_check = 0
	
	done_sus_field = 0
	done_tensor_field = 0
	done_mag_field = 0
	done_mce_field = 0
	done_epr_field = 0
	done_heat_field = 0
	
	high_prec = .false.
	ImpS = 0
	ImpQuant = 0.0_8
	space_group = 'P1'
	ored_only_zeeman = .false.
	unit_cell(1:3) = 10.0_8
	unit_cell(4:6) = 90.0_8
	sus_high_temp = 300.0_8
	sus_low_temp = 1.8_8
	sus_sweep_scale = 'lin'
	sus_field_vec(1) = 0.0_8
	sus_field_vec(2) = 0.0_8
	sus_field_vec(3) = 1.0_8
	sus_tip = 0.0_8
	sus_zJ = 0.0_8
	sus_numT = 250
	sus_numB = 0
	sus_exp_numT = 0
	sus_intCover = 2
	sus_intLevel = -1
	sus_autoscale = 0
	sus_differential = .false.
	mag_numB = 10
	mag_numT = 0
	mag_exp_numB = 0
	mag_intCover = 2
	mag_intLevel = 3
	mag_low_field = 0.0_8
	mag_high_field = 7.0_8
	mag_sweep_scale = 'lin'
	mag_field_vec(1) = 0.0_8
	mag_field_vec(2) = 0.0_8
	mag_field_vec(3) = 1.0_8
	mag_autoscale = 0
	tensor_numT = 250
	tensor_numB = 0
	tensor_exp_numT = 0
	tensor_low_temp = 0.01_8
	tensor_high_temp = 300.0_8
	tensor_sweep_scale = 'lin'
	mce_low_temp = 1.8_8
	mce_high_temp = 50.0_8
	mce_sweep_scale = 'lin'
	mce_mass = 2000.0_8
	mce_field_vec(1) = 0.0_8
	mce_field_vec(2) = 0.0_8
	mce_field_vec(3) = 1.0_8
	mce_numT = 250
	mce_numB = 0
	mce_exp_numT = 0
	mce_integration = 50
	mce_intCover = 2
	mce_intLevel = 3
	heat_low_temp = 0.5_8
	heat_high_temp = 20.0_8
	heat_sweep_scale = 'log'
	heat_field_vec(1) = 0.0_8
	heat_field_vec(2) = 0.0_8
	heat_field_vec(3) = 1.0_8
	heat_numT = 250
	heat_numB = 0
	heat_exp_numT = 0
	heat_intCover = 2
	heat_intLevel = 3
	heat_lattice = 0.0_8
	epr_low_field = 0.0_8
	epr_high_field = 1.6_8
	epr_sweep_scale = 'lin'
	epr_field_vec(1) = 0.0_8
	epr_field_vec(2) = 0.0_8
	epr_field_vec(3) = 1.0_8
	epr_numB = 250
	epr_numT = 0
	epr_numF = 0
	epr_exp_numB = 0
	epr_parallel_mode = 0
	epr_intCover = 2
	epr_intLevel = 6
	epr_subdim = 0
	epr_do_subspace = 0
	epr_normalise = .true.
	wavelet_error = .false.
	zee_low_field = 0.0_8
	zee_high_field = 7.0_8
	zee_sweep_scale = 'lin'
	zee_field_vec(1) = 0.0_8
	zee_field_vec(2) = 0.0_8
	zee_field_vec(3) = 1.0_8
	zee_numB = 250
	zee_intCover = 3
	zee_intLevel = -2
	static_field_magnitude = 0.0_8
	static_field_direction(1) = 0.0_8
	static_field_direction(2) = 0.0_8
	static_field_direction(3) = 1.0_8
	given_multiplicities = 0
	num_mult = 0
	fit_NOps = 0
	fit_NPOps = 0
	fit_N2 = 0
	fit_uncertainties = 1
	fit_pause = 0
	fit_Npoints = 0
	uncert_in_progress = 0
	FitVigour = 0.1_8
	FitLimit = 12.0_8
	FitTolerance = 1000.0_8*EPS
	FitMethod = 'simplex'
	surveyTarget = 'residual'
	sur_save = 0
	sur_NOps = 0
	sur_NPOps = 0
	sur_N2 = 0
	g_numCalc = 0
	given_multiplicities = 0
	
	printPercent = 0
	global_total = 0
	global_percent = 0
	ResidualType = 0
	OperationMode = 'sim'
	OperationModeB = 'l'
	MaxCPU = 0
	MaxGPU = 0
	plasma_num_cores = 2
	NoPrint = 0
	char_temp = ''
	FullWF = 0
	GDir = 'xyz'
	show_binning = 0
	printed_binning = 0
	NoOEF = 0
	SingleXtal = 0
	aniso = 1
	approx = 0
	use_interaction_matrix = .false.
	
	ender = 0
	j = 1
	line = ''
	big_ender = 0
	i = 0
	k = 0
	
	!NEW VERSION!
	inquire(file=trim(WorkDir)//"/"//trim(JobTitle)//".input",exist=got_access)
	if(.not. got_access) then
		call output_text( trim(JobTitle)//".input not found",.false.)
		call control('kill ')
		return
	end if
	open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//".input",status='old')
	do while(.true.)
		read(41,'(A)',END=20) line
		k = k + 1
	end do
20	continue
	number_lines = k
	allocate(lines(number_lines))
	lines(:) = ''
	rewind(41)
	
	cut_lines = 0
	do line_iter = 1,number_lines
		read(41,'(A)') line
		line = adjustl(line)
		line = trim(line)
		if(len_trim(line) == 0 .or. line(1:1) == "!" .or. line(1:1) == "#" .or. line(1:1) == "/") then
			cycle
		end if
		cut_lines = cut_lines + 1
		call lowercase(line)
		do k = 1,len_trim(line)
			if(line(k:k) == "	") line(k:k) = " "
		end do
		d = index(trim(line),"  ")
		do while(d > 0)
			k = len_trim(line)
			line(d+1:k-1) = line(d+2:k)
			line(k:k) = " "
			d = index(trim(line),"  ")
		end do
		d = index(trim(line),"* *")
		do while(d > 0)
			k = len_trim(line)
			line(d+1:k-1) = line(d+2:k)
			line(k:k) = " "
			d = index(trim(line),"* *")
		end do
		d = index(trim(line),"*****")
		do while(d > 0)
			k = len_trim(line)
			line(d+1:k-1) = line(d+2:k)
			line(k:k) = " "
			d = index(trim(line),"*****")
		end do
		lines(cut_lines) = trim(line)
	end do
	
	
	do line_iter = 1,cut_lines
		read(lines(line_iter),'(A)',IOSTAT=IOstatus) line
		if(IOstatus /= 0) then
			SaveTxt = ""
			write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
			call output_text(SaveTxt,.false.)
			if(IOstatus < 0) call output_text("No ****End block found before end of file!",.false.)
			call output_text("Check: "//trim(JobTitle)//".input",.false.)
			deallocate(lines)
			call control('kill ')
			return
		else
			if(len_trim(line) > 0) then
				if(index(trim(line(1:7)),"*spi") > 0) then
					if(done_spin == 0) then
						done_spin = line_iter
						block_check(1) = line_iter
					else
						call error("More than one ****Spin block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*ion") > 0) then
					if(done_ion == 0) then
						done_ion = line_iter
						block_check(2) = line_iter
					else
						call error("More than one ****Ion block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*orb") > 0) then
					if(done_orbit == 0) then
						done_orbit = line_iter
						block_check(3) = line_iter
					else
						call error("More than one ****Orbit block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*met") > 0) then
					if(done_metaltype == 0) then
						done_metaltype = line_iter
						block_check(4) = line_iter
					else
						call error("More than one ****MetalType block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*gfa") > 0) then
					if(done_gfac == 0) then
						done_gfac = line_iter
						block_check(5) = line_iter
					else
						call error("More than one ****GFactor block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*exc") > 0) then
					if(done_exch == 0) then
						done_exch = line_iter
						block_check(6) = line_iter
					else
						call error("More than one ****Exchange block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*ant") > 0) then
					if(done_anti == 0) then
						done_anti = line_iter
						block_check(7) = line_iter
					else
						call error("More than one ****Antisymmetric block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*int") > 0) then
					if(done_inter == 0) then
						done_inter = line_iter
						block_check(8) = line_iter
					else
						call error("More than one ****Interaction block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*soc") > 0) then
					if(done_soc == 0) then
						done_soc = line_iter
						block_check(9) = line_iter
					else
						call error("More than one ****SOCoupling block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*ore") > 0) then
					if(done_ored == 0) then
						done_ored = line_iter
						block_check(10) = line_iter
					else
						call error("More than one ****OReduction block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*cry") > 0) then
					if(done_crys == 0) then
						done_crys = line_iter
						block_check(11) = line_iter
					else
						call error("More than one ****CrystalField block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*sus") > 0) then
					if(done_sus == 0) then
						done_sus = line_iter
						block_check(12) = line_iter
					else
						call error("More than one ****Sus block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*mag") > 0) then
					if(done_mag == 0) then
						done_mag = line_iter
						block_check(13) = line_iter
					else
						call error("More than one ****Mag block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*mce") > 0) then
					if(done_mce == 0) then
						done_mce = line_iter
						block_check(14) = line_iter
					else
						call error("More than one ****MCE block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*epr") > 0) then
					if(done_epr == 0) then
						done_epr = line_iter
						block_check(15) = line_iter
					else
						call error("More than one ****EPR block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*sur") > 0) then
					if(done_survey == 0) then
						done_survey = line_iter
						block_check(16) = line_iter
					else
						call error("More than one ****Survey block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*fit") > 0) then
					if(done_fit == 0) then
						done_fit = line_iter
						block_check(17) = line_iter
					else
						call error("More than one ****Fit block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*par") > 0) then
					if(done_params == 0) then
						done_params = line_iter
						block_check(18) = line_iter
					else
						call error("More than one ****Params block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*zee") > 0) then
					if(done_zee == 0) then
						done_zee = line_iter
						block_check(19) = line_iter
					else
						call error("More than one ****Zeeman block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*hea") > 0) then
					if(done_heat == 0) then
						done_heat = line_iter
						block_check(20) = line_iter
					else
						call error("More than one ****HeatCapacity block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*ten") > 0) then
					if(done_tensor == 0) then
						done_tensor = line_iter
						block_check(21) = line_iter
					else
						call error("More than one ****Tensor block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*shi") > 0) then
					if(done_shift == 0) then
						done_shift = line_iter
						block_check(22) = line_iter
					else
						call error("More than one ****Shift block found!","Check: "//trim(JobTitle)//".input")
						deallocate(lines)
						return
					end if
				else if(index(trim(line(1:7)),"*end") > 0) then
					block_check(poss_blocks+1) = line_iter
					exit
				end if
			end if
		end if
	end do
	
	
	if(return_all) then
		!write(6,*) "BQ1"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ1"
	end if
	if(done_spin == 0 .and. done_ion == 0) then
		call error("****Spin or ****Ion block must be present!","Check: "//trim(JobTitle)//".input")
		deallocate(lines)
		return
	end if
	if(done_spin > 0 .and. done_ion > 0) then
		call error("****Spin and ****Ion blocks cannot coexist!","Check: "//trim(JobTitle)//".input")
		deallocate(lines)
		return
	end if
	if(done_fit > 0 .and. done_survey > 0) then
		call error("****Fit and ****Survey blocks cannot coexist!","Check: "//trim(JobTitle)//".input")
		deallocate(lines)
		return
	end if
	if(done_exch > 0 .and. done_inter > 0) then
		call error("****Exchange and ****Interaction blocks cannot coexist!","Check: "//trim(JobTitle)//".input")
		deallocate(lines)
		return
	end if
	if(done_anti > 0 .and. done_inter > 0) then
		call error("****Antisymmetric and ****Interaction blocks cannot coexist!","Check: "//trim(JobTitle)//".input")
		deallocate(lines)
		return
	end if
	call re_order(poss_blocks+1,dble(block_check),block_order,'min')
	do k = 2,poss_blocks+1
		if(block_check(block_order(k))-block_check(block_order(k-1)) == 1) then
			if(block_order(k-1) == 1) done_spin = 0
			if(block_order(k-1) == 2) done_ion = 0
			if(block_order(k-1) == 3) done_orbit = 0
			if(block_order(k-1) == 4) done_metaltype = 0
			if(block_order(k-1) == 5) done_gfac = 0
			if(block_order(k-1) == 6) done_exch = 0
			if(block_order(k-1) == 7) done_anti = 0
			if(block_order(k-1) == 8) done_inter = 0
			if(block_order(k-1) == 9) done_soc = 0
			if(block_order(k-1) == 10) done_ored = 0
			if(block_order(k-1) == 11) done_crys = 0
			if(block_order(k-1) == 12) done_sus = 0
			if(block_order(k-1) == 13) done_mag = 0
			if(block_order(k-1) == 14) done_mce = 0
			if(block_order(k-1) == 15) done_epr = 0
			if(block_order(k-1) == 16) done_survey = 0
			if(block_order(k-1) == 17) done_fit = 0
			if(block_order(k-1) == 18) done_params = 0
			if(block_order(k-1) == 19) done_zee = 0
			if(block_order(k-1) == 20) done_heat = 0
			if(block_order(k-1) == 21) done_tensor = 0
			if(block_order(k-1) == 22) done_shift = 0
		end if
	end do
	if(done_inter > 0) use_interaction_matrix = .true.
	if(return_all) then
		!write(6,*) "BQ2"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ2"
	end if
	if(done_spin > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 1) then
				N = block_check(block_order(i+1))-block_check(1)-1
				exit
			end if
		end do
	else if(done_ion > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 2) then
				N = block_check(block_order(i+1))-block_check(2)-1
				exit
			end if
		end do
	end if
	!write(6,*) "N = ",N
	
	allocate(twoS(N),twoL(N),lamda(N,6),Gfactor(3,N),EXmat(3,3,N,N),Jss(N,N,3),dss(N,N,3),MetalType(N),A2(N,-2:2),A4(N,-4:4),A6(N,-6:6),do_rotate(N),CFP_rot(N,3),orbred(N),force_cubic(N),Ln_J(N),Gmat(3,3,N),D_not_B20(N),JJ_not_SS(N,N),do_exrotate(N,N),EX_rot(N,N,3),SF2(N),SF4(N),SF6(N),epr_strain_lamda(N,6),epr_strain_EXmat(3,3,N,N),epr_strain_Jss(N,N,3),epr_strain_dss(N,N,3),epr_strain_A2(N,-2:2),epr_strain_A4(N,-4:4),epr_strain_A6(N,-6:6),epr_strain_orbred(N),epr_strain_Gmat(3,3,N),epr_strain_Gfactor(3,N),epr_iso_G_strain(N),epr_iso_ex_strain(N,N),energy_shift(N))
	twoS = 0
	twoL = 0
	MetalType = 0
	force_cubic = 0
	Gfactor = 2.0_8
	lamda = 0.0_8
	EXmat = 0.0_8
	Jss = 0.0_8
	dss = 0.0_8
	A2 = 0.0_8
	A4 = 0.0_8
	A6 = 0.0_8
	orbred = 1.0_8
	Ln_J = 0
	do_rotate = 0
	CFP_rot = 0.0_8
	Gmat = 0.0_8
	D_not_B20 = 0
	JJ_not_SS = 0
	do_exrotate = 0
	EX_rot = 0.0_8
	SF2 = 1.0_8
	SF4 = 1.0_8
	SF6 = 1.0_8
	epr_strain_lamda = 0.0_8
	epr_strain_EXmat = 0.0_8
	epr_strain_Jss = 0.0_8
	epr_strain_dss = 0.0_8
	epr_strain_A2 = 0.0_8
	epr_strain_A4 = 0.0_8
	epr_strain_A6 = 0.0_8
	epr_strain_orbred = 0.0_8
	epr_strain_Gmat = 0.0_8
	epr_strain_Gfactor = 0.0_8
	epr_iso_G_strain = 0
	epr_iso_ex_strain = 0
	energy_shift = 0.0_8
	
! 	if(done_spin > 0) write(6,*) "done_spin"
! 	if(done_ion > 0) write(6,*) "done_ion"
! 	if(done_orbit > 0) write(6,*) "done_orbit"
! 	if(done_metaltype > 0) write(6,*) "done_metaltype"
! 	if(done_gfac > 0) write(6,*) "done_gfac"
! 	if(done_exch > 0) write(6,*) "done_exch"
! 	if(done_anti > 0) write(6,*) "done_anti"
! 	if(done_inter > 0) write(6,*) "done_inter"
! 	if(done_soc > 0) write(6,*) "done_soc"
! 	if(done_ored > 0) write(6,*) "done_ored"
! 	if(done_crys > 0) write(6,*) "done_crys"
! 	if(done_sus > 0) write(6,*) "done_sus"
! 	if(done_mag > 0) write(6,*) "done_mag"
! 	if(done_mce > 0) write(6,*) "done_mce"
! 	if(done_epr > 0) write(6,*) "done_epr"
! 	if(done_survey > 0) write(6,*) "done_survey"
! 	if(done_fit > 0) write(6,*) "done_fit"
! 	if(done_params > 0) write(6,*) "done_params"
! 	if(done_zee > 0) write(6,*) "done_zee"
! 	if(done_heat > 0) write(6,*) "done_heat"
! 	if(done_tensor > 0) write(6,*) "done_tensor"
! 	if(done_shift > 0) write(6,*) "done_shift"
	
	if(done_spin > 0) then
		do k=1,N
			read(lines(block_check(1)+k),*,IOSTAT=IOstatus) twoS(k)
			if(IOstatus /= 0) then
				call IO_error(IOstatus,lines(block_check(1)+k),"Check: ****Spin block")
				deallocate(lines)
				return
			end if
			if(twoS(k) <= 0) then
				call error("Spin must be > 0","Check: ****Spin block")
				deallocate(lines)
				return
			end if
		end do
	else if(done_ion > 0) then
		do k=1,N
			if(trim(lines(block_check(2)+k)) == 'ee') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ee'
			else if(trim(lines(block_check(2)+k)) == 'ti(iii)oh') then
				twoS(k) = 1
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = 155.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ti(III)Oh'
			else if(trim(lines(block_check(2)+k)) == 'ti(iii)td') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ti(III)Td'
			else if(trim(lines(block_check(2)+k)) == 'ti(iii)fi') then
				twoS(k) = 1
				twoL(k) = 4
				metalType(k) = 1
				lamda(k,1) = 155.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -9.52380952380952D-02
				SF4(k) = 3.17460317460317E-02
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Ti(III)FI'
			else if(trim(lines(block_check(2)+k)) == 'ti(ii)oh') then
				twoS(k) = 2
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.5_8
				lamda(k,1) = 61.5_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ti(II)Oh'
			else if(trim(lines(block_check(2)+k)) == 'ti(ii)td') then
				twoS(k) = 2
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ti(II)Td'
			else if(trim(lines(block_check(2)+k)) == 'ti(ii)fi') then
				twoS(k) = 2
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = 61.5_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -1.90476190476190D-02	
				SF4(k) = -6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Ti(II)FI'
			else if(trim(lines(block_check(2)+k)) == 'v(iv)oh') then
				twoS(k) = 1
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = 250.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'V(IV)Oh'
			else if(trim(lines(block_check(2)+k)) == 'v(iv)td') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'V(IV)Td'
			else if(trim(lines(block_check(2)+k)) == 'v(iv)fi') then
				twoS(k) = 1
				twoL(k) = 4
				metalType(k) = 1
				lamda(k,1) = 250.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -9.52380952380952D-02
				SF4(k) = 3.17460317460317E-02
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'V(IV)FI'
			else if(trim(lines(block_check(2)+k)) == 'v(iii)oh') then
				twoS(k) = 2
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.5_8
				lamda(k,1) = 105.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'V(III)Oh'
			else if(trim(lines(block_check(2)+k)) == 'v(iii)td') then
				twoS(k) = 2
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'V(III)Td'
			else if(trim(lines(block_check(2)+k)) == 'v(iii)fi') then
				twoS(k) = 2
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = 105.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -1.90476190476190D-02	
				SF4(k) = -6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'V(III)FI'
			else if(trim(lines(block_check(2)+k)) == 'v(ii)oh') then
				twoS(k) = 3
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'V(II)Oh'
			else if(trim(lines(block_check(2)+k)) == 'v(ii)td(w)') then
				twoS(k) = 3
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.5_8
				lamda(k,1) = 56.5_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'V(II)Td(w)'
			else if(trim(lines(block_check(2)+k)) == 'v(ii)td(s)') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'V(II)Td(s)'
			else if(trim(lines(block_check(2)+k)) == 'v(ii)fi') then
				twoS(k) = 3
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = 56.5_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = 1.90476190476190D-02	
				SF4(k) = 6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'V(II)FI'
			else if(trim(lines(block_check(2)+k)) == 'cr(iii)oh') then
				twoS(k) = 3
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Cr(III)Oh'
			else if(trim(lines(block_check(2)+k)) == 'cr(iii)td(w)') then
				twoS(k) = 3
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.5_8
				lamda(k,1) = 91.5_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Cr(III)Td(w)'
			else if(trim(lines(block_check(2)+k)) == 'cr(iii)td(s)') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Cr(III)Td(s)'
			else if(trim(lines(block_check(2)+k)) == 'cr(iii)fi') then
				twoS(k) = 3
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = 91.5_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = 1.90476190476190D-02	
				SF4(k) = 6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Cr(III)FI'
			else if(trim(lines(block_check(2)+k)) == 'cr(ii)oh(w)') then
				twoS(k) = 4
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Cr(II)Oh(w)'
			!else if(trim(lines(block_check(2)+k)) == 'cr(ii)oh(s)') then
			!	twoS(k) = 2
			!	twoL(k) = 2
			!	metalType(k) = 1
			!	orbred(k) = -1.5_8
			!	lamda(k,1) = 115.0_8			!4 electrons in T2g set, should this be negative??
			!	Gfactor(:,k) = 2.0_8
			!	if(N == 1) Single_Ion = 'Cr(II)Oh(s)'
			else if(trim(lines(block_check(2)+k)) == 'cr(ii)td(w)') then
				twoS(k) = 4
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = 57.5_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Cr(II)Td(w)'
			else if(trim(lines(block_check(2)+k)) == 'cr(ii)fi') then
				twoS(k) = 4
				twoL(k) = 4
				metalType(k) = 1
				lamda(k,1) = 57.5_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = 9.52380952380952D-02	
				SF4(k) = -3.17460317460317D-02
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Cr(II)FI'
			else if(trim(lines(block_check(2)+k)) == 'mn(vi)oh') then
				twoS(k) = 1
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = 540.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(VI)Oh'
			else if(trim(lines(block_check(2)+k)) == 'mn(vi)td') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(VI)Td'
			else if(trim(lines(block_check(2)+k)) == 'mn(vi)fi') then
				twoS(k) = 1
				twoL(k) = 4
				metalType(k) = 1
				lamda(k,1) = 540.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -9.52380952380952D-02
				SF4(k) = 3.17460317460317E-02
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Mn(VI)FI'
			else if(trim(lines(block_check(2)+k)) == 'mn(iv)oh') then
				twoS(k) = 3
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(IV)Oh'
			else if(trim(lines(block_check(2)+k)) == 'mn(iv)td(w)') then
				twoS(k) = 3
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.5_8
				lamda(k,1) = 138.5_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(IV)Td(w)'
			else if(trim(lines(block_check(2)+k)) == 'mn(iv)td(s)') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(IV)Td(s)'
			else if(trim(lines(block_check(2)+k)) == 'mn(iv)fi') then
				twoS(k) = 3
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = 138.5_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = 1.90476190476190D-02	
				SF4(k) = 6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Mn(IV)FI'
			else if(trim(lines(block_check(2)+k)) == 'mn(iii)oh(w)') then
				twoS(k) = 4
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(III)Oh(w)'
			!else if(trim(lines(block_check(2)+k)) == 'mn(iii)oh(s)') then
			!	twoS(k) = 2
			!	twoL(k) = 2
			!	metalType(k) = 1
			!	orbred(k) = -1.5_8
			!	lamda(k,1) = 177.5_8			!4 electrons in T2g set, should this be negative??
			!	Gfactor(:,k) = 2.0_8
			!	if(N == 1) Single_Ion = 'Mn(III)Oh(s)'
			else if(trim(lines(block_check(2)+k)) == 'mn(iii)td(w)') then
				twoS(k) = 4
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = 89.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(III)Td(w)'
			else if(trim(lines(block_check(2)+k)) == 'mn(iii)fi') then
				twoS(k) = 4
				twoL(k) = 4
				metalType(k) = 1
				lamda(k,1) = 89.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = 9.52380952380952D-02	
				SF4(k) = -3.17460317460317D-02
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Mn(III)FI'
			else if(trim(lines(block_check(2)+k)) == 'mn(ii)oh(w)') then
				twoS(k) = 5
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(II)Oh(w)'
			else if(trim(lines(block_check(2)+k)) == 'mn(ii)oh(s)') then
				twoS(k) = 1
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = -300.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(II)Oh(s)'
			else if(trim(lines(block_check(2)+k)) == 'mn(ii)td(w)') then
				twoS(k) = 5
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(II)Td(w)'
			!else if(trim(lines(block_check(2)+k)) == 'mn(ii)td(s)') then
			!	twoS(k) = 1
			!	twoL(k) = 2
			!	metalType(k) = 1
			!	orbred(k) = -1.0_8
			!	lamda(k,1) = 300.0_8				!1 electron in T2g set, but d5, should this be negative??
			!	Gfactor(:,k) = 2.0_8
			!	if(N == 1) Single_Ion = 'Mn(II)Td(s)'
			else if(trim(lines(block_check(2)+k)) == 'mn(ii)fi') then
				twoS(k) = 5
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Mn(II)FI'
			else if(trim(lines(block_check(2)+k)) == 'fe(vi)oh') then
				twoS(k) = 2
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.5_8
				lamda(k,1) = 332.5_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Fe(VI)Oh'
			else if(trim(lines(block_check(2)+k)) == 'fe(vi)td') then
				twoS(k) = 2
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Fe(VI)Td'
			else if(trim(lines(block_check(2)+k)) == 'fe(vi)fi') then
				twoS(k) = 2
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = 332.5_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -1.90476190476190D-02	
				SF4(k) = -6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Fe(VI)FI'
			else if(trim(lines(block_check(2)+k)) == 'fe(iii)oh(w)') then
				twoS(k) = 5
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Fe(III)Oh(w)'
			else if(trim(lines(block_check(2)+k)) == 'fe(iii)oh(s)') then
				twoS(k) = 1
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = -460.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Fe(III)Oh(s)'
			else if(trim(lines(block_check(2)+k)) == 'fe(iii)td(w)') then
				twoS(k) = 5
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Fe(III)Td(w)'
			!else if(trim(lines(block_check(2)+k)) == 'fe(iii)td(s)') then
			!	twoS(k) = 1
			!	twoL(k) = 2
			!	metalType(k) = 1
			!	orbred(k) = -1.0_8
			!	lamda(k,1) = 460.0_8				!1 electron in T2g set, but d5, should this be negative??
			!	Gfactor(:,k) = 2.0_8
			!	if(N == 1) Single_Ion = 'Fe(III)Td(s)'
			else if(trim(lines(block_check(2)+k)) == 'fe(iii)fi') then
				twoS(k) = 5
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Fe(III)FI'
			else if(trim(lines(block_check(2)+k)) == 'fe(ii)oh(w)') then
				twoS(k) = 4
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = -100.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Fe(II)Oh(w)'
			else if(trim(lines(block_check(2)+k)) == 'fe(ii)td(w)') then
				twoS(k) = 4
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Fe(II)Td(w)'
			!else if(trim(lines(block_check(2)+k)) == 'fe(ii)td(s)') then
			!	twoS(k) = 2
			!	twoL(k) = 2
			!	metalType(k) = 1
			!	orbred(k) = -1.5_8
			!	lamda(k,1) = 200.0_8					!2 electron in T2g set, but d6, should this be negative??
			!	Gfactor(:,k) = 2.0_8
			!	if(N == 1) Single_Ion = 'Fe(II)Td(s)'
			else if(trim(lines(block_check(2)+k)) == 'fe(ii)fi') then
				twoS(k) = 4
				twoL(k) = 4
				metalType(k) = 1
				lamda(k,1) = -100.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -9.52380952380952D-02	
				SF4(k) = 3.17460317460317D-02
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Fe(II)FI'
			else if(trim(lines(block_check(2)+k)) == 'co(iii)oh(w)') then
				twoS(k) = 4
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.0_8
				lamda(k,1) = -145.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Co(III)Oh(w)'
			else if(trim(lines(block_check(2)+k)) == 'co(iii)td(w)') then
				twoS(k) = 4
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Co(III)Td(w)'
			!else if(trim(lines(block_check(2)+k)) == 'co(iii)td(s)') then
			!	twoS(k) = 2
			!	twoL(k) = 2
			!	metalType(k) = 1
			!	orbred(k) = -1.5_8
			!	lamda(k,1) = 290.0_8					!2 electron in T2g set, but d6, should this be negative??
			!	Gfactor(:,k) = 2.0_8
			!	if(N == 1) Single_Ion = 'Co(III)Td(s)'
			else if(trim(lines(block_check(2)+k)) == 'co(iii)fi') then
				twoS(k) = 4
				twoL(k) = 4
				metalType(k) = 1
				lamda(k,1) = -145.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -9.52380952380952D-02	
				SF4(k) = 3.17460317460317D-02
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Co(III)FI'
			else if(trim(lines(block_check(2)+k)) == 'co(ii)oh(w)') then
				twoS(k) = 3
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.5_8
				lamda(k,1) = -171.5_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Co(II)Oh(w)'
			else if(trim(lines(block_check(2)+k)) == 'co(ii)oh(s)') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Co(II)Oh(s)'
			else if(trim(lines(block_check(2)+k)) == 'co(ii)td') then
				twoS(k) = 3
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Co(II)Td'
			else if(trim(lines(block_check(2)+k)) == 'co(ii)fi') then
				twoS(k) = 3
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = -171.5_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -1.90476190476190D-02	
				SF4(k) = -6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Co(II)FI'
			else if(trim(lines(block_check(2)+k)) == 'ni(iii)oh(w)') then
				twoS(k) = 3
				twoL(k) = 2
				metalType(k) = 1
				orbred(k) = -1.5_8
				lamda(k,1) = -235.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ni(III)Oh(w)'
			else if(trim(lines(block_check(2)+k)) == 'ni(iii)oh(s)') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ni(III)Oh(s)'
			else if(trim(lines(block_check(2)+k)) == 'ni(iii)td') then
				twoS(k) = 3
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ni(III)Td'
			else if(trim(lines(block_check(2)+k)) == 'ni(iii)fi') then
				twoS(k) = 3
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = -235.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = -1.90476190476190D-02	
				SF4(k) = -6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Ni(III)FI'
			else if(trim(lines(block_check(2)+k)) == 'ni(ii)oh') then
				twoS(k) = 2
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ni(II)Oh'
			else if(trim(lines(block_check(2)+k)) == 'ni(ii)td') then
				twoS(k) = 2
				twoL(k) = 2
				metalType(k) = 1
				lamda(k,1) = -315.0_8
				orbred(k) = -1.5_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Ni(II)Td'
			else if(trim(lines(block_check(2)+k)) == 'ni(ii)fi') then
				twoS(k) = 2
				twoL(k) = 6
				metalType(k) = 1
				lamda(k,1) = -315.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = 1.90476190476190E-02	
				SF4(k) = 6.34920634920635E-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Ni(II)FI'
			else if(trim(lines(block_check(2)+k)) == 'cu(ii)oh') then
				twoS(k) = 1
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Cu(II)Oh'
			else if(trim(lines(block_check(2)+k)) == 'cu(ii)td') then
				twoS(k) = 1
				twoL(k) = 2
				metalType(k) = 1
				lamda(k,1) = -830.0_8
				orbred(k) = -1.0_8
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Cu(II)Td'
			else if(trim(lines(block_check(2)+k)) == 'cu(ii)fi') then
				twoS(k) = 1
				twoL(k) = 4
				metalType(k) = 1
				lamda(k,1) = -830.0_8
				Gfactor(:,k) = 2.0_8
				SF2(k) = 9.52380952380952E-02	
				SF4(k) = -3.17460317460317E-02
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Cu(II)FI'
			else if(trim(lines(block_check(2)+k)) == 'ce(j)') then
				twoS(k) = 5
				metalType(k) = 2
				Gfactor(:,k) = 0.857142857143_8
				SF2(k) = -5.71428571428571D-02
				SF4(k) = 6.34920634920635D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Ce(J)'
				Ln_J(k) = 58
			else if(trim(lines(block_check(2)+k)) == 'ce(ls)') then
				twoS(k) = 1
				twoL(k) = 6
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = 0.69143935714285715D3 !640.0_8
				lamda(k,2) = 0.0_8
				lamda(k,3) = 0.0_8
				lamda(k,4) = 0.0_8
				lamda(k,5) = 0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = -4.44444444444444D-02
				SF4(k) = 4.04040404040404D-03
				SF6(k) = -1.03600103600104D-03
				if(N == 1) Single_Ion = 'Ce(LS)'
			else if(trim(lines(block_check(2)+k)) == 'pr(j)') then
				twoS(k) = 8
				metalType(k) = 2
				Gfactor(:,k) = 0.8_8
				SF2(k) = -2.10101010101010D-02
				SF4(k) = -7.34618916437098D-04
				SF6(k) = 6.09940003879398D-05
				if(N == 1) Single_Ion = 'Pr(J)'
				Ln_J(k) = 59
			else if(trim(lines(block_check(2)+k)) == 'pr(ls)') then
				twoS(k) = 2
				twoL(k) = 10
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = 0.42139347104545476D3 !405.0_8 !390.0_8
				lamda(k,2) = -0.57834761363635145D1 !-5.69_8 !-4.63_8
				lamda(k,3) = 0.0_8 !-0.533_8 !0.0_8
				lamda(k,4) = 0.0_8
				lamda(k,5) = 0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = -1.48148148148148D-02
				SF4(k) = -3.84800384800385D-04
				SF6(k) = 2.46666913333580D-05
				if(N == 1) Single_Ion = 'Pr(LS)'
			else if(trim(lines(block_check(2)+k)) == 'nd(j)') then
				twoS(k) = 9
				metalType(k) = 2
				Gfactor(:,k) = 8.0_8/11.0_8
				SF2(k) = -6.42791551882461D-03
				SF4(k) = -2.91107729124258D-04
				SF6(k) = -3.79879591576985D-05
				if(N == 1) Single_Ion = 'Nd(J)'
				Ln_J(k) = 60
			else if(trim(lines(block_check(2)+k)) == 'nd(ls)') then
				twoS(k) = 3
				twoL(k) = 12
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = 0.32599267334402259D3 !299.0_8
				lamda(k,2) = -0.26606362589744066D1 !-2.48_8
				lamda(k,3) = 0.24657342723938720D-1 !0.0475_8
				lamda(k,4) = 0.0_8
				lamda(k,5) = 0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = -4.04040404040404D-03
				SF4(k) = -1.22436486072850D-04
				SF6(k) = -1.12121324242536D-05
				if(N == 1) Single_Ion = 'Nd(LS)'
			else if(trim(lines(block_check(2)+k)) == 'pm(j)') then
				twoS(k) = 8
				metalType(k) = 2
				Gfactor(:,k) = 0.6_8
				SF2(k) = 7.71349845259507D-03
				SF4(k) = 4.07550820773961D-04
				SF6(k) = 6.07807346388214D-05  !6.68588081175494D-04
				if(N == 1) Single_Ion = 'Pm(J)'
				Ln_J(k) = 61
			else if(trim(lines(block_check(2)+k)) == 'pm(ls)') then
				twoS(k) = 4
				twoL(k) = 12
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = 0.26931173714705278D3 !251.0_8
				lamda(k,2) = -0.18482053377345331D1 !-1.99_8
				lamda(k,3) = 0.97691863913876853D-2 !0.0239_8
				lamda(k,4) = -0.92015215340181624D-3 !0.0_8
				lamda(k,5) = 0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = 4.04040404040404D-03
				SF4(k) = 1.22436486072850D-04
				SF6(k) = 1.12121324242536D-05
				if(N == 1) Single_Ion = 'Pm(LS)'
			else if(trim(lines(block_check(2)+k)) == 'sm(j)') then
				twoS(k) = 5
				metalType(k) = 2
				Gfactor(:,k) = 2.0_8/7.0_8
				SF2(k) = 4.12698412698413D-02
				SF4(k) = 2.50120250120250D-03
				SF6(k) = 0.0_8
				if(N == 1) Single_Ion = 'Sm(J)'
				Ln_J(k) = 62
			else if(trim(lines(block_check(2)+k)) == 'sm(ls)') then
				twoS(k) = 5
				twoL(k) = 10
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = 0.24071480423582875D3 !228.0_8
				lamda(k,2) = -0.23356939807194017D1 !-2.16_8
				lamda(k,3) = 0.31517444417301033D-1 !0.0368_8
				lamda(k,4) = -0.74292158859408071D-3 !0.0_8
				lamda(k,5) = -0.88349937714328038D-5 !0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = 1.48148148148148D-02
				SF4(k) = 3.84800384800385D-04
				SF6(k) = -2.46666913333580D-05
				if(N == 1) Single_Ion = 'Sm(LS)'
			else if(trim(lines(block_check(2)+k)) == 'eu(ls)') then
				twoS(k) = 6
				twoL(k) = 6
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = 0.22957099161134647D3 !214.0_8
				lamda(k,2) = -0.32774220289844496D1 !-3.82_8
				lamda(k,3) = 0.26874662221646417_8 !0.147_8
				lamda(k,4) = 0.71506518283090815D-3 !0.0_8
				lamda(k,5) = -0.16403186099326846D-2 !0.0_8
				lamda(k,6) = -0.14434181738155145D-3 !0.0_8
				SF2(k) = 4.44444444444444D-02
				SF4(k) = -4.04040404040404D-03
				SF6(k) = 1.03600103600104D-03
				if(N == 1) Single_Ion = 'Eu(LS)'
			else if(trim(lines(block_check(2)+k)) == 'gd(iii)') then
				twoS(k) = 7
				metalType(k) = 0
				Gfactor(:,k) = 2.0_8
				if(N == 1) Single_Ion = 'Gd(III)'
			else if(trim(lines(block_check(2)+k)) == 'tb(j)') then
				twoS(k) = 12
				metalType(k) = 2
				Gfactor(:,k) = 1.5_8
				SF2(k) = -1.01010101010101D-02
				SF4(k) = 1.22436486072850D-04
				SF6(k) = -1.12121324242536D-06
				if(N == 1) Single_Ion = 'Tb(J)'
				Ln_J(k) = 65
			else if(trim(lines(block_check(2)+k)) == 'tb(ls)') then
				twoS(k) = 6
				twoL(k) = 6
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = -0.25987126617063063D3 !-252.0_8
				lamda(k,2) = 0.99709876163494759_8 !-4.50_8
				lamda(k,3) = 0.22253171891940798_8 !-0.267_8
				lamda(k,4) = -0.40184584013748879D-1 !0.0_8
				lamda(k,5) = -0.68450238286265879D-2 !0.0_8
				lamda(k,6) = -0.26653023074673803D-3 !0.0_8
				SF2(k) = -4.44444444444444D-02
				SF4(k) = 4.04040404040404D-03
				SF6(k) = -1.03600103600104D-03
				if(N == 1) Single_Ion = 'Tb(LS)'
			else if(trim(lines(block_check(2)+k)) == 'dy(j)') then
				twoS(k) = 15
				metalType(k) = 2
				Gfactor(:,k) = 4.0_8/3.0_8
				SF2(k) = -6.34920634920635D-03
				SF4(k) = -5.92000592000592D-05
				SF6(k) = 1.03496606993110D-06
				if(N == 1) Single_Ion = 'Dy(J)'
				Ln_J(k) = 66
			else if(trim(lines(block_check(2)+k)) == 'dy(ls)') then
				twoS(k) = 5
				twoL(k) = 10
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = -0.36158539121404556D3 !-357.0_8
				lamda(k,2) = -0.27283088595900238D1 !-4.40_8
				lamda(k,3) = -0.22053828055492949_8 !-0.121_8
				lamda(k,4) = -0.65464322224075755D-2 !0.0_8
				lamda(k,5) = 0.11007237663578021D-3 !0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = -1.48148148148148D-02
				SF4(k) = -3.84800384800385D-04
				SF6(k) = 2.46666913333580D-05
				if(N == 1) Single_Ion = 'Dy(LS)'
			else if(trim(lines(block_check(2)+k)) == 'ho(j)') then
				twoS(k) = 16
				metalType(k) = 2
				Gfactor(:,k) = 1.25_8
				SF2(k) = -2.22222222222222D-03
				SF4(k) = -3.33000333000333D-05
				SF6(k) = -1.29370758741388D-06
				if(N == 1) Single_Ion = 'Ho(J)'
				Ln_J(k) = 67
			else if(trim(lines(block_check(2)+k)) == 'ho(ls)') then
				twoS(k) = 4
				twoL(k) = 12
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = -0.51469621741920741D3 !-497.0_8
				lamda(k,2) = -0.78267163189936824D1 !-7.06_8
				lamda(k,3) = -0.12141606905593069_8 !-0.139_8
				lamda(k,4) = 0.62940540084926071D-2 !0.0_8
				lamda(k,5) = 0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = -4.04040404040404D-03
				SF4(k) = -1.22436486072850D-04
				SF6(k) = -1.12121324242536D-05
				if(N == 1) Single_Ion = 'Ho(LS)'
			else if(trim(lines(block_check(2)+k)) == 'er(j)') then
				twoS(k) = 15
				metalType(k) = 2
				Gfactor(:,k) = 1.2_8
				SF2(k) = 2.53968253968254D-03
				SF4(k) = 4.44000444000444D-05
				SF6(k) = 2.06993213986221D-06
				if(N == 1) Single_Ion = 'Er(J)'
				Ln_J(k) = 68
			else if(trim(lines(block_check(2)+k)) == 'er(ls)') then
				twoS(k) = 3
				twoL(k) = 12
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = -0.57204318359267336D3 !-629.0_8
				lamda(k,2) = -0.12646268923931572D2 !-18.20_8
				lamda(k,3) = -0.18516097189255245D1 !-0.517_8
				lamda(k,4) = 0.0_8
				lamda(k,5) = 0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = 4.04040404040404D-03
				SF4(k) = 1.22436486072850D-04
				SF6(k) = 1.12121324242536D-05
				if(N == 1) Single_Ion = 'Er(LS)'
			else if(trim(lines(block_check(2)+k)) == 'tm(j)') then
				twoS(k) = 12
				metalType(k) = 2
				Gfactor(:,k) = 7.0_8/6.0_8
				SF2(k) = 1.01010101010101D-02
				SF4(k) = 1.63248648097133D-04
				SF6(k) = -5.60606621212682D-06
				if(N == 1) Single_Ion = 'Tm(J)'
				Ln_J(k) = 69
			else if(trim(lines(block_check(2)+k)) == 'tm(ls)') then
				twoS(k) = 2
				twoL(k) = 10
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = -0.68359540409999829D3 !-1181.0_8 !-875.0_8
				lamda(k,2) = -0.17691699310000104D3 !-102.1_8 !-123.0_8
				lamda(k,3) = 0.0_8 !10.56_8 !0.0_8
				lamda(k,4) = 0.0_8
				lamda(k,5) = 0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = 1.48148148148148D-02
				SF4(k) = 3.84800384800385D-04
				SF6(k) = -2.46666913333580D-05
				if(N == 1) Single_Ion = 'Tm(LS)'
			else if(trim(lines(block_check(2)+k)) == 'yb(j)') then
				twoS(k) = 7
				metalType(k) = 2
				Gfactor(:,k) = 8.0_8/7.0_8
				SF2(k) = 3.17460317460317D-02
				SF4(k) = -1.73160173160173D-03
				SF6(k) = 1.48000148000148D-04
				if(N == 1) Single_Ion = 'Yb(J)'
				Ln_J(k) = 70
			else if(trim(lines(block_check(2)+k)) == 'u(iv)') then
				twoS(k) = 6
				metalType(k) = 2
				SF2(k) = 2.11538461538462D+00
				SF4(k) = -5.50000000000000D+00
				SF6(k) = -1.69852941176471D+01
			else if(trim(lines(block_check(2)+k)) == 'yb(ls)') then
				twoS(k) = 1
				twoL(k) = 6
				metalType(k) = 1
				Gfactor(:,k) = 2.0_8
				lamda(k,1) = -0.29566588571428574D4 !-2910.0_8
				lamda(k,2) = 0.0_8
				lamda(k,3) = 0.0_8
				lamda(k,4) = 0.0_8
				lamda(k,5) = 0.0_8
				lamda(k,6) = 0.0_8
				SF2(k) = 4.44444444444444D-02
				SF4(k) = -4.04040404040404D-03
				SF6(k) = 1.03600103600104D-03
				if(N == 1) Single_Ion = 'Yb(LS)'
			else if(trim(lines(block_check(2)+k)) == '1h') then
				twoS(k) = 1
				Gfactor(:,k) = -3.04206422539567D-03
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '7li') then
				twoS(k) = 3
				Gfactor(:,k) = -1.18233679972407D-03
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '9be') then
				twoS(k) = 3
				Gfactor(:,k) = 4.27497106541515D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '14n') then
				twoS(k) = 2
				Gfactor(:,k) = -2.19895100623363D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '19f') then
				twoS(k) = 1
				Gfactor(:,k) = -2.86345235614900D-03
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '23na') then
				twoS(k) = 3
				Gfactor(:,k) = -8.05133438386439D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '27al') then
				twoS(k) = 5
				Gfactor(:,k) = -7.93290633008815D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '31p') then
				twoS(k) = 1
				Gfactor(:,k) = -1.23257717246290D-03
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '39k') then
				twoS(k) = 3
				Gfactor(:,k) = -1.42134142130333D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '45sc') then
				twoS(k) = 7
				Gfactor(:,k) = -7.40129043657371D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '51v') then
				twoS(k) = 7
				Gfactor(:,k) = -8.01164269761082D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '55mn') then
				twoS(k) = 5
				Gfactor(:,k) = -7.52279448711121D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '59co') then
				twoS(k) = 7
				Gfactor(:,k) = -7.19983661185914D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '75as') then
				twoS(k) = 3
				Gfactor(:,k) = -5.22641694748156D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '89y') then
				twoS(k) = 1
				Gfactor(:,k) = 1.49677523139677D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '93nb') then
				twoS(k) = 9
				Gfactor(:,k) = -7.46778817109020D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '103rh') then
				twoS(k) = 1
				Gfactor(:,k) = 9.62882838862856D-05
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '115in') then
				twoS(k) = 9
				Gfactor(:,k) = -6.70586900165064D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '127i') then
				twoS(k) = 5
				Gfactor(:,k) = -6.12862945362421D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '133cs') then
				twoS(k) = 7
				Gfactor(:,k) = -4.01775608553100D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '139la') then
				twoS(k) = 7
				Gfactor(:,k) = -4.33055467544589D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '141pr') then
				twoS(k) = 5
				Gfactor(:,k) = -9.31403976823108D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '159tb') then
				twoS(k) = 3
				Gfactor(:,k) = -7.31420617982361D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '165ho') then
				twoS(k) = 7
				Gfactor(:,k) = -9.08421139832151D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '169tm') then
				twoS(k) = 1
				Gfactor(:,k) = 2.51613049521855D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '171yb') then
				twoS(k) = 1
				Gfactor(:,k) = -5.3772216994002D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '173yb') then
				twoS(k) = 5
				Gfactor(:,k) = 1.4116473195500D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '175lu') then
				twoS(k) = 7
				Gfactor(:,k) = -3.47356716417833D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '181ta') then
				twoS(k) = 7
				Gfactor(:,k) = -3.68863641365058D-04
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '197au') then
				twoS(k) = 3
				Gfactor(:,k) = -5.29171652461937D-05
				metalType(k) = 2
			else if(trim(lines(block_check(2)+k)) == '209bi') then
				twoS(k) = 9
				Gfactor(:,k) = -4.97453158946455D-04
				metalType(k) = 2
			else
				call error(trim(lines(block_check(2)+k))//" is not a valid ion type","Check: ****Ion block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ3"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ3"
	end if
	if(done_orbit > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 3) then
				if(block_check(block_order(i+1))-block_check(3)-1 /= N) then
					call error("Incorrect number of sites in the ****Orbit block!","Check: "//trim(JobTitle)//".input")
					deallocate(lines)
					return
				end if
				exit
			end if
		end do
		do k=1,N
			read(lines(block_check(3)+k),*,IOSTAT=IOstatus) twoL(k)
			if(IOstatus /= 0) then
				call IO_error(IOstatus,lines(block_check(3)+k),"Check: ****Orbit block")
				deallocate(lines)
				return
			end if
			if(twoL(k) < 0) then
				call error("Orbit must be >= 0","Check: ****Orbit block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ4"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ4"
	end if
	if(done_metaltype > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 4) then
				if(block_check(block_order(i+1))-block_check(4)-1 /= N) then
					call error("Incorrect number of sites in the ****MetalType block!","Check: "//trim(JobTitle)//".input")
					deallocate(lines)
					return
				end if
				exit
			end if
		end do
		do k=1,N
			read(lines(block_check(4)+k),*,IOSTAT=IOstatus) MetalType(k)
			if(IOstatus /= 0) then
				call IO_error(IOstatus,lines(block_check(4)+k),"Check: ****MetalType block")
				deallocate(lines)
				return
			end if
			if(MetalType(k) < 0 .or. MetalType(k) > 2) then
				call error("MetalType must be 0, 1, or 2.","Check: ****MetalType block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ5"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ5"
	end if
	if(done_gfac > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 5) then
				k = block_check(block_order(i+1))-block_check(5)-1
				exit
			end if
		end do
		do i = 1,k
			comps = count_spaces(trim(lines(block_check(5)+i)))
			brackets = count_brackets(trim(lines(block_check(5)+i)))
			if(comps /= 1 .and. comps /= 3) then
				call output_text("G-factors incorrectly specified!",.false.)
				call output_text(trim(lines(block_check(5)+i)),.false.)
				call output_text("Check: ****GFactor block",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			if(brackets == 0) then
				read(lines(block_check(5)+i),*,IOSTAT=IOstatus) N1a,temp(1:comps)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(5)+i),"Check: ****GFactor block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N1a < 1) then
					call error(lines(block_check(5)+i),"G-factor given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				Gfactor(1:comps,N1a) = temp(1:comps)
			else
				kk = index(trim(lines(block_check(5)+i)),' ')
				read(lines(block_check(5)+i)(1:kk-1),*,IOSTAT=IOstatus) N1a
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(5)+i),"Check: ****GFactor block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N1a < 1) then
					call error(lines(block_check(5)+i),"G-factor given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				do j = 1,comps
					kk2 = index(lines(block_check(5)+i)(kk+1:),' ')
					if(kk2 /= 0) then
						kk2 = kk2 + kk
					else if(kk2 == 0 .and. j == comps) then
						kk2 = len_trim(lines(block_check(5)+i))+1
					end if
					jj = index(lines(block_check(5)+i)(kk+1:kk2-1),'(')
					if(jj == 0) then
						read(lines(block_check(5)+i)(kk+1:kk2-1),*,IOSTAT=IOstatus) temp(j)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(5)+i),"Check: ****GFactor block")
							deallocate(lines)
							return
						end if
						Gfactor(j,N1a) = temp(j)
					else
						jj = jj+kk
						jj2 = index(lines(block_check(5)+i)(kk+1:kk2-1),')')+kk
						read(lines(block_check(5)+i)(kk+1:jj-1),*,IOSTAT=IOstatus) temp(j)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(5)+i),"Check: ****GFactor block")
							deallocate(lines)
							return
						end if
						Gfactor(j,N1a) = temp(j)
						read(lines(block_check(5)+i)(jj+1:jj2-1),*,IOSTAT=IOstatus) temp(j+3)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(5)+i),"Check: ****GFactor block")
							deallocate(lines)
							return
						end if
						epr_strain_Gfactor(j,N1a) = temp(j+3)
					end if
					kk = kk2
				end do
			end if
			if(comps == 1) then
				Gfactor(:,N1a) = Gfactor(1,N1a)
				epr_strain_Gfactor(:,N1a) = epr_strain_Gfactor(1,N1a)
				epr_iso_G_strain(N1a) = 1
			end if
		end do
		!write(6,*) "gfac"
		!do i = 1,N
		!	write(6,'(3F7.2)') Gfactor(:,i)
		!	write(6,'(3F7.2)') epr_strain_Gfactor(:,i)
		!	write(6,*) "----"
		!end do
		!write(6,*)
		!write(6,*)
	end if
	if(return_all) then
		!write(6,*) "BQ6"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ6"
	end if
	if(done_exch > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 6) then
				k = block_check(block_order(i+1))-block_check(6)-1
				exit
			end if
		end do
		do i = 1,k
			comps = count_spaces(trim(lines(block_check(6)+i)))-1
			brackets = count_brackets(trim(lines(block_check(6)+i)))
			if(comps /= 1 .and. comps /= 3) then
				call output_text("Exchange interactions incorrectly specified!",.false.)
				call output_text(trim(lines(block_check(6)+i)),.false.)
				call output_text("Check: ****Exchange block",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			if(brackets == 0) then
				read(lines(block_check(6)+i),*,IOSTAT=IOstatus) N1a,N2a,temp(1:comps)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(6)+i),"Check: ****Exchange block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N2a > N .or. N1a < 1 .or. N2a < 1) then
					call error(lines(block_check(6)+i),"Exchange interaction given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(N1a == N2a) then
					call error(lines(block_check(6)+i),"Exchange interaction given between the same site?")
					deallocate(lines)
					return
				end if
				Jss(N1a,N2a,1:comps) = temp(1:comps)
			else
				kk = index(trim(lines(block_check(6)+i)),' ')
				kk = index(trim(lines(block_check(6)+i)(kk+1:)),' ')+kk
				read(lines(block_check(6)+i)(1:kk-1),*,IOSTAT=IOstatus) N1a,N2a
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(6)+i),"Check: ****Exchange block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N2a > N .or. N1a < 1 .or. N2a < 1) then
					call error(lines(block_check(6)+i),"Exchange interaction given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(N1a == N2a) then
					call error(lines(block_check(6)+i),"Exchange interaction given between the same site?")
					deallocate(lines)
					return
				end if
				do j = 1,comps
					kk2 = index(lines(block_check(6)+i)(kk+1:),' ')
					if(kk2 /= 0) then
						kk2 = kk2 + kk
					else if(kk2 == 0 .and. j == comps) then
						kk2 = len_trim(lines(block_check(6)+i))+1
					end if
					jj = index(lines(block_check(6)+i)(kk+1:kk2-1),'(')
					if(jj == 0) then
						read(lines(block_check(6)+i)(kk+1:kk2-1),*,IOSTAT=IOstatus) temp(j)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(6)+i),"Check: ****Exchange block")
							deallocate(lines)
							return
						end if
						Jss(N1a,N2a,j) = temp(j)
					else
						jj = jj+kk
						jj2 = index(lines(block_check(6)+i)(kk+1:kk2-1),')')+kk
						read(lines(block_check(6)+i)(kk+1:jj-1),*,IOSTAT=IOstatus) temp(j)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(6)+i),"Check: ****Exchange block")
							deallocate(lines)
							return
						end if
						Jss(N1a,N2a,j) = temp(j)
						read(lines(block_check(6)+i)(jj+1:jj2-1),*,IOSTAT=IOstatus) temp(j+3)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(6)+i),"Check: ****Exchange block")
							deallocate(lines)
							return
						end if
						epr_strain_Jss(N1a,N2a,j) = temp(j+3)
					end if
					kk = kk2
				end do
			end if
			if(comps == 1) then
				Jss(N1a,N2a,:) = Jss(N1a,N2a,1)
				epr_strain_Jss(N1a,N2a,:) = epr_strain_Jss(N1a,N2a,1)
				epr_iso_ex_strain(N1a,N2a) = 1
			end if
			if(N1a > N2a) then
				Jss(N2a,N1a,:) = Jss(N1a,N2a,:)
				Jss(N1a,N2a,:) = 0.0_8
				epr_strain_Jss(N2a,N1a,:) = epr_strain_Jss(N1a,N2a,:)
				epr_strain_Jss(N1a,N2a,:) = 0.0_8
				epr_iso_ex_strain(N2a,N1a) = epr_iso_ex_strain(N1a,N2a)
				epr_iso_ex_strain(N1a,N2a) = 0
			end if
		end do
		!write(6,*) "exch"
		!do i = 1,N
		!	do j = 1,N
		!		if(any(Jss(i,j,:) /= 0.0_8)) then
		!			write(6,'(2I2)') i, j
		!			write(6,'(3F7.2)') Jss(i,j,:)
		!			write(6,'(3F7.2)') epr_strain_Jss(i,j,:)
		!			write(6,*) "----"
		!		end if
		!	end do
		!end do
		!write(6,*)
		!write(6,*)
	end if
	if(return_all) then
		!write(6,*) "BQ7"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ7"
	end if
	if(done_anti > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 7) then
				k = block_check(block_order(i+1))-block_check(7)-1
				exit
			end if
		end do
		do i = 1,k
			comps = count_spaces(trim(lines(block_check(7)+i)))-1
			brackets = count_brackets(trim(lines(block_check(7)+i)))
			if(comps /= 3) then
				call output_text("Antisymmetric interactions incorrectly specified!",.false.)
				call output_text(trim(lines(block_check(7)+i)),.false.)
				call output_text("Check: ****Antisymmetric block",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			if(brackets == 0) then
				read(lines(block_check(7)+i),*,IOSTAT=IOstatus) N1a,N2a,temp(1:comps)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(7)+i),"Check: ****Antisymmetric block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N2a > N .or. N1a < 1 .or. N2a < 1) then
					call error(lines(block_check(7)+i),"Antisymmetric interaction given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(N1a == N2a) then
					call error(lines(block_check(7)+i),"Antisymmetric interaction given between the same site?")
					deallocate(lines)
					return
				end if
				dss(N1a,N2a,1:comps) = temp(1:comps)
			else
				kk = index(trim(lines(block_check(7)+i)),' ')
				kk = index(trim(lines(block_check(7)+i)(kk+1:)),' ')+kk
				read(lines(block_check(7)+i)(1:kk-1),*,IOSTAT=IOstatus) N1a,N2a
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(7)+i),"Check: ****Antisymmetric block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N2a > N .or. N1a < 1 .or. N2a < 1) then
					call error(lines(block_check(7)+i),"Antisymmetric interaction given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(N1a == N2a) then
					call error(lines(block_check(7)+i),"Antisymmetric interaction given between the same site?")
					deallocate(lines)
					return
				end if
				do j = 1,comps
					kk2 = index(lines(block_check(7)+i)(kk+1:),' ')
					if(kk2 /= 0) then
						kk2 = kk2 + kk
					else if(kk2 == 0 .and. j == comps) then
						kk2 = len_trim(lines(block_check(7)+i))+1
					end if
					jj = index(lines(block_check(7)+i)(kk+1:kk2-1),'(')
					if(jj == 0) then
						read(lines(block_check(7)+i)(kk+1:kk2-1),*,IOSTAT=IOstatus) temp(j)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(7)+i),"Check: ****Antisymmetric block")
							deallocate(lines)
							return
						end if
						dss(N1a,N2a,j) = temp(j)
					else
						jj = jj+kk
						jj2 = index(lines(block_check(7)+i)(kk+1:kk2-1),')')+kk
						read(lines(block_check(7)+i)(kk+1:jj-1),*,IOSTAT=IOstatus) temp(j)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(7)+i),"Check: ****Antisymmetric block")
							deallocate(lines)
							return
						end if
						dss(N1a,N2a,j) = temp(j)
						read(lines(block_check(7)+i)(jj+1:jj2-1),*,IOSTAT=IOstatus) temp(j+3)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(7)+i),"Check: ****Antisymmetric block")
							deallocate(lines)
							return
						end if
						epr_strain_dss(N1a,N2a,j) = temp(j+3)
					end if
					kk = kk2
				end do
			end if
			if(N1a > N2a) then
				dss(N2a,N1a,:) = -dss(N1a,N2a,:)
				dss(N1a,N2a,:) = 0.0_8
				epr_strain_dss(N2a,N1a,:) = epr_strain_dss(N1a,N2a,:)
				epr_strain_dss(N1a,N2a,:) = 0.0_8
			end if
		end do
		!write(6,*) "anti"
		!do i = 1,N
		!	do j = 1,N
		!		if(any(dss(i,j,:) /= 0.0_8)) then
		!			write(6,'(2I2)') i, j
		!			write(6,'(3F7.2)') dss(i,j,:)
		!			write(6,'(3F7.2)') epr_strain_dss(i,j,:)
		!			write(6,*) "----"
		!		end if
		!	end do
		!end do
		!write(6,*)
		!write(6,*)
	end if
	if(return_all) then
		!write(6,*) "BQ8"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ8"
	end if
	if(done_inter > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 8) then
				k = block_check(block_order(i+1))-block_check(8)-1
				exit
			end if
		end do
		if((k/5)*5 /= k) then
			call error("Cannot parse interaction matrices","Check: ****Interaction block")
			deallocate(lines)
			return
		end if
		do i = 1,k/5
			read(lines(block_check(8)+(i-1)*5+1),*,IOSTAT=IOstatus) N1a,N2a
			if(N1a > N .or. N2a > N .or. N1a < 1 .or. N2a < 1) then
				call error(lines(block_check(8)+(i-1)*5+1),"Interaction matrix given for a site which doesn't exist?")
				deallocate(lines)
				return
			end if
			if(N1a == N2a) then
				call error(lines(block_check(8)+(i-1)*5+1),"Interaction matrix given between the same site?")
				deallocate(lines)
				return
			end if
			do d = 1,3
				comps = count_spaces(trim(lines(block_check(8)+(i-1)*5+1+d)))+1
				brackets = count_brackets(trim(lines(block_check(8)+(i-1)*5+1+d)))
				if(comps /= 3) then
					call output_text("Interaction matrix incorrectly specified!",.false.)
					call output_text(trim(lines(block_check(8)+(i-1)*5+1+d)),.false.)
					call output_text("Check: ****Interaction block",.false.)
					deallocate(lines)
					call control('kill ')
					return
				end if
				if(brackets == 0) then
					read(lines(block_check(8)+(i-1)*5+1+d),*,IOSTAT=IOstatus) temp(1:comps)
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(8)+(i-1)*5+1+d),"Check: ****Interaction block")
						deallocate(lines)
						return
					end if
					EXmat(d,1:comps,N1a,N2a) = temp(1:comps)
				else
					kk = 0
					do j = 1,comps
						kk2 = index(lines(block_check(8)+(i-1)*5+1+d)(kk+1:),' ')
						if(kk2 /= 0) then
							kk2 = kk2 + kk
						else if(kk2 == 0 .and. j == comps) then
							kk2 = len_trim(lines(block_check(8)+(i-1)*5+1+d))+1
						end if
						jj = index(lines(block_check(8)+(i-1)*5+1+d)(kk+1:kk2-1),'(')
						if(jj == 0) then
							read(lines(block_check(8)+(i-1)*5+1+d)(kk+1:kk2-1),*,IOSTAT=IOstatus) temp(j)
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(8)+(i-1)*5+1+d),"Check: ****Interaction block")
								deallocate(lines)
								return
							end if
							EXmat(d,j,N1a,N2a) = temp(j)
						else
							jj = jj+kk
							jj2 = index(lines(block_check(8)+(i-1)*5+1+d)(kk+1:kk2-1),')')+kk
							read(lines(block_check(8)+(i-1)*5+1+d)(kk+1:jj-1),*,IOSTAT=IOstatus) temp(j)
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(8)+(i-1)*5+1+d),"Check: ****Interaction block")
								deallocate(lines)
								return
							end if
							EXmat(d,j,N1a,N2a) = temp(j)
							read(lines(block_check(8)+(i-1)*5+1+d)(jj+1:jj2-1),*,IOSTAT=IOstatus) temp(j+3)
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(8)+(i-1)*5+1+d),"Check: ****Interaction block")
								deallocate(lines)
								return
							end if
							epr_strain_EXmat(d,j,N1a,N2a) = temp(j+3)
						end if
						kk = kk2
					end do
				end if
			end do
		end do
		!write(6,*) "inter"
		!do i = 1,N
		!	do j = 1,N
		!		if(any(EXmat(:,:,i,j) /= 0.0_8)) then
		!			write(6,'(2I2)') i, j
		!			write(6,'(3F7.2)') EXmat(1,1:3,i,j)
		!			write(6,'(3F7.2)') EXmat(2,1:3,i,j)
		!			write(6,'(3F7.2)') EXmat(3,1:3,i,j)
		!			write(6,*)
		!			write(6,'(3F7.2)') epr_strain_EXmat(1,1:3,i,j)
		!			write(6,'(3F7.2)') epr_strain_EXmat(2,1:3,i,j)
		!			write(6,'(3F7.2)') epr_strain_EXmat(3,1:3,i,j)
		!			write(6,*) "----"
		!		end if
		!	end do
		!end do
		!write(6,*)
		!write(6,*)
	end if
	if(return_all) then
		!write(6,*) "BQ9"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ9"
	end if
	if(done_soc > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 9) then
				k = block_check(block_order(i+1))-block_check(9)-1
				exit
			end if
		end do
		do i = 1,k
			comps = count_spaces(trim(lines(block_check(9)+i)))
			brackets = count_brackets(trim(lines(block_check(9)+i)))
			if(comps == 0) then
				call output_text("SOC incorrectly specified!",.false.)
				call output_text(trim(lines(block_check(9)+i)),.false.)
				call output_text("Check: ****SOCoupling block",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			if(brackets == 0) then
				read(lines(block_check(9)+i),*,IOSTAT=IOstatus) N1a,temp(1:comps)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(9)+i),"Check: ****SOCoupling block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N1a < 1) then
					call error(lines(block_check(9)+i),"SOC given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(twoL(N1a) == 0) then
					call error(lines(block_check(9)+i),"SOC given for a site with no orbital moment?")
					deallocate(lines)
					return
				end if
				lamda(N1a,:) = 0.0_8
				lamda(N1a,1:comps) = temp(1:comps)
			else
				kk = index(trim(lines(block_check(9)+i)),' ')
				read(lines(block_check(9)+i)(1:kk-1),*,IOSTAT=IOstatus) N1a
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(9)+i),"Check: ****SOCoupling block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N1a < 1) then
					call error(lines(block_check(9)+i),"SOC given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(twoL(N1a) == 0) then
					call error(lines(block_check(9)+i),"SOC given for a site with no orbital moment?")
					deallocate(lines)
					return
				end if
				lamda(N1a,:) = 0.0_8
				do j = 1,comps
					kk2 = index(lines(block_check(9)+i)(kk+1:),' ')
					if(kk2 /= 0) then
						kk2 = kk2 + kk
					else if(kk2 == 0 .and. j == comps) then
						kk2 = len_trim(lines(block_check(9)+i))+1
					end if
					jj = index(lines(block_check(9)+i)(kk+1:kk2-1),'(')
					if(jj == 0) then
						read(lines(block_check(9)+i)(kk+1:kk2-1),*,IOSTAT=IOstatus) temp(j)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(9)+i),"Check: ****SOCoupling block")
							deallocate(lines)
							return
						end if
						lamda(N1a,j) = temp(j)
					else
						jj = jj+kk
						jj2 = index(lines(block_check(9)+i)(kk+1:kk2-1),')')+kk
						read(lines(block_check(9)+i)(kk+1:jj-1),*,IOSTAT=IOstatus) temp(j)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(9)+i),"Check: ****SOCoupling block")
							deallocate(lines)
							return
						end if
						lamda(N1a,j) = temp(j)
						read(lines(block_check(9)+i)(jj+1:jj2-1),*,IOSTAT=IOstatus) temp(j+6)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(9)+i),"Check: ****SOCoupling block")
							deallocate(lines)
							return
						end if
						epr_strain_lamda(N1a,j) = temp(j+6)
					end if
					kk = kk2
				end do
			end if
		end do
		!write(6,*) "soc"
		!do i = 1,N
		!	if(any(lamda(i,:) /= 0.0_8)) then
		!		write(6,'(I2)') i
		!		write(6,'(6F7.2)') lamda(i,:)
		!		write(6,'(6F7.2)') epr_strain_lamda(i,:)
		!		write(6,*) "----"
		!	end if
		!end do
		!write(6,*)
		!write(6,*)
	end if
	if(return_all) then
		!write(6,*) "BQ10"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ10"
	end if
	if(done_ored > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 10) then
				k = block_check(block_order(i+1))-block_check(10)-1
				exit
			end if
		end do
		do i = 1,k
			comps = count_spaces(trim(lines(block_check(10)+i)))
			brackets = count_brackets(trim(lines(block_check(10)+i)))
			if(comps /= 1) then
				call output_text("Orbital Reduction incorrectly specified!",.false.)
				call output_text(trim(lines(block_check(10)+i)),.false.)
				call output_text("Check: ****OReduction block",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			if(brackets == 0) then
				read(lines(block_check(10)+i),*,IOSTAT=IOstatus) N1a,temp(1)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(10)+i),"Check: ****OReduction block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N1a < 1) then
					call error(lines(block_check(10)+i),"Orbital Reduction given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(twoL(N1a) == 0) then
					call error(lines(block_check(10)+i),"Orbital Reduction given for a site with no orbital moment?")
					deallocate(lines)
					return
				end if
				orbred(N1a) = temp(1)
			else
				kk = index(trim(lines(block_check(10)+i)),' ')
				read(lines(block_check(10)+i)(1:kk-1),*,IOSTAT=IOstatus) N1a
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(10)+i),"Check: ****OReduction block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N1a < 1) then
					call error(lines(block_check(10)+i),"Orbital Reduction given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(twoL(N1a) == 0) then
					call error(lines(block_check(10)+i),"Orbital Reduction given for a site with no orbital moment?")
					deallocate(lines)
					return
				end if
				jj = index(lines(block_check(10)+i)(kk+1:),'(')+kk
				jj2 = index(lines(block_check(10)+i)(kk+1:),')')+kk
				read(lines(block_check(10)+i)(kk+1:jj-1),*,IOSTAT=IOstatus) temp(1)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(10)+i),"Check: ****OReduction block")
					deallocate(lines)
					return
				end if
				orbred(N1a) = temp(1)
				read(lines(block_check(10)+i)(jj+1:jj2-1),*,IOSTAT=IOstatus) temp(2)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(10)+i),"Check: ****OReduction block")
					deallocate(lines)
					return
				end if
				epr_strain_orbred(N1a) = temp(2)
			end if
		end do
		!write(6,*) "ored"
		!do i = 1,N
		!	if(orbred(i) /= 0.0_8) then
		!		write(6,'(I2)') i
		!		write(6,'(F7.2)') orbred(i)
		!		write(6,'(F7.2)') epr_strain_orbred(i)
		!		write(6,*) "----"
		!	end if
		!end do
		!write(6,*)
		!write(6,*)
	end if
	if(return_all) then
		!write(6,*) "BQ11"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ11"
	end if


	if(done_shift > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 22) then
				k = block_check(block_order(i+1))-block_check(22)-1
				exit
			end if
		end do
		do i = 1,k
			read(lines(block_check(22)+i),*,IOSTAT=IOstatus) N1a,temp(1)
			if(IOstatus /= 0) then
				call IO_error(IOstatus,lines(block_check(22)+i),"Check: ****Shift block")
				deallocate(lines)
				return
			end if
			if(N1a > N .or. N1a < 1) then
				call error(lines(block_check(22)+i),"Energy Shift given for a site which doesn't exist?")
				deallocate(lines)
				return
			end if
			energy_shift(N1a) = temp(1)
		end do
		write(6,*) "shift"
		do i = 1,N
			if(energy_shift(i) /= 0.0_8) then
				write(6,'(I2)') i
				write(6,'(F7.2)') energy_shift(i)
				write(6,*) "----"
			end if
		end do
		write(6,*)
		write(6,*)
	end if
	if(return_all) then
		!write(6,*) "BQ11a"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ11a"
	end if


	if(done_crys > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 11) then
				k = block_check(block_order(i+1))-block_check(11)-1
				exit
			end if
		end do
		do i = 1,k
			comps = count_spaces(trim(lines(block_check(11)+i)))-2
			brackets = count_brackets(trim(lines(block_check(11)+i)))
			if(comps /= 1) then
				call output_text("Crystal Field incorrectly specified!",.false.)
				call output_text(trim(lines(block_check(11)+i)),.false.)
				call output_text("Check: ****CrystalField block",.false.)
				deallocate(lines)
				call control('kill ')
				return
			end if
			if(brackets == 0) then
				read(lines(block_check(11)+i),*,IOSTAT=IOstatus) N1a,N2a,N3a,temp(1)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(11)+i),"Check: ****CrystalField block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N1a < 1) then
					call error(lines(block_check(11)+i),"Crystal Field given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(N2a /= 2 .and. N2a /= 4 .and. N2a /= 6) then
					call error(lines(block_check(11)+i),"Crystal Field rank not 2, 4 or 6?")
					deallocate(lines)
					return
				end if
				if(N2a == 2 .and. (N3a > 2 .or. N3a < -2)) then
					call error(lines(block_check(11)+i),"Crystal Field order incorrect?")
					deallocate(lines)
					return
				end if
				if(N2a == 4 .and. (N3a > 4 .or. N3a < -4)) then
					call error(lines(block_check(11)+i),"Crystal Field order incorrect?")
					deallocate(lines)
					return
				end if
				if(N2a == 6 .and. (N3a > 6 .or. N3a < -6)) then
					call error(lines(block_check(11)+i),"Crystal Field order incorrect?")
					deallocate(lines)
					return
				end if
				if(N2a == 2) A2(N1a,N3a) = temp(1)
				if(N2a == 4) A4(N1a,N3a) = temp(1)
				if(N2a == 6) A6(N1a,N3a) = temp(1)
			else
				kk = index(trim(lines(block_check(11)+i)),' ')
				kk = index(trim(lines(block_check(11)+i)(kk+1:)),' ')+kk
				kk = index(trim(lines(block_check(11)+i)(kk+1:)),' ')+kk
				read(lines(block_check(11)+i)(1:kk-1),*,IOSTAT=IOstatus) N1a,N2a,N3a
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(11)+i),"Check: ****CrystalField block")
					deallocate(lines)
					return
				end if
				if(N1a > N .or. N1a < 1) then
					call error(lines(block_check(11)+i),"Crystal Field given for a site which doesn't exist?")
					deallocate(lines)
					return
				end if
				if(N2a /= 2 .and. N2a /= 4 .and. N2a /= 6) then
					call error(lines(block_check(11)+i),"Crystal Field rank not 2, 4 or 6?")
					deallocate(lines)
					return
				end if
				if(N2a == 2 .and. (N3a > 2 .or. N3a < -2)) then
					call error(lines(block_check(11)+i),"Crystal Field order incorrect?")
					deallocate(lines)
					return
				end if
				if(N2a == 4 .and. (N3a > 4 .or. N3a < -4)) then
					call error(lines(block_check(11)+i),"Crystal Field order incorrect?")
					deallocate(lines)
					return
				end if
				if(N2a == 6 .and. (N3a > 6 .or. N3a < -6)) then
					call error(lines(block_check(11)+i),"Crystal Field order incorrect?")
					deallocate(lines)
					return
				end if
				jj = index(lines(block_check(11)+i)(kk+1:),'(')+kk
				jj2 = index(lines(block_check(11)+i)(kk+1:),')')+kk
				read(lines(block_check(11)+i)(kk+1:jj-1),*,IOSTAT=IOstatus) temp(1)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(11)+i),"Check: ****CrystalField block")
					deallocate(lines)
					return
				end if
				if(N2a == 2) A2(N1a,N3a) = temp(1)
				if(N2a == 4) A4(N1a,N3a) = temp(1)
				if(N2a == 6) A6(N1a,N3a) = temp(1)
				read(lines(block_check(11)+i)(jj+1:jj2-1),*,IOSTAT=IOstatus) temp(2)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(11)+i),"Check: ****CrystalField block")
					deallocate(lines)
					return
				end if
				if(N2a == 2) epr_strain_A2(N1a,N3a) = temp(2)
				if(N2a == 4) epr_strain_A4(N1a,N3a) = temp(2)
				if(N2a == 6) epr_strain_A6(N1a,N3a) = temp(2)
			end if
		end do
		!write(6,*) "crys"
		!do i = 1,N
		!	if(any(A2(i,:) /= 0.0_8)) then
		!		write(6,'(5F7.2)') A2(i,:)
		!		write(6,'(5F7.2)') epr_strain_A2(i,:)
		!	end if
		!	if(any(A4(i,:) /= 0.0_8)) then
		!		write(6,'(9F7.2)') A4(i,:)
		!		write(6,'(9F7.2)') epr_strain_A4(i,:)
		!	end if
		!	if(any(A6(i,:) /= 0.0_8)) then
		!		write(6,'(13F7.2)') A6(i,:)
		!		write(6,'(13F7.2)') epr_strain_A6(i,:)
		!	end if
		!	write(6,*) "----"
		!end do
		!write(6,*)
		!write(6,*)
	end if
	if(return_all) then
		!write(6,*) "BQ12"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ12"
	end if
	if(done_sus > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 12) then
				k = block_check(block_order(i+1))-block_check(12)-1
				exit
			end if
		end do
		do i = 1,k
			if(lines(block_check(12)+i)(1:5) == 'field') then
				if(lines(block_check(12)+i)(7:12) == 'powder') then
					sus_intCover = 2		! 1 = sphere, 2 = hemisphere, 3 = octant
					read(lines(block_check(12)+i)(13:),*,IOSTAT=IOstatus) sus_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(12)+i),"Check: ****Sus block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field powder',sus_intLevel
				else if(lines(block_check(12)+i)(7:12) == 'vector') then
					sus_intCover = 0
					sus_intLevel = -2
					read(lines(block_check(12)+i)(13:),*,IOSTAT=IOstatus) sus_field_vec
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(12)+i),"Check: ****Sus block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field vector',sus_field_vec
				else if(lines(block_check(12)+i)(7:12) == 'angles') then
					sus_intCover = 0
					sus_intLevel = -2
					read(lines(block_check(12)+i)(13:),*,IOSTAT=IOstatus) temp(1:2)
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(12)+i),"Check: ****Sus block")
						deallocate(lines)
						return
					end if
					sus_field_vec(1) = dsin(temp(1)*pie/180.0_8)*dcos(temp(2)*pie/180.0_8)
					sus_field_vec(2) = dsin(temp(1)*pie/180.0_8)*dsin(temp(2)*pie/180.0_8)
					sus_field_vec(3) = dcos(temp(1)*pie/180.0_8)
					!write(6,*) 'field angles',temp(1:2)
				else if(lines(block_check(12)+i)(7:11) == 'axial') then
					sus_intCover = 4		! 4 = axial grid
					read(lines(block_check(12)+i)(13:),*,IOSTAT=IOstatus) sus_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(12)+i),"Check: ****Sus block")
						deallocate(lines)
						return
					end if
				else
					temp_int(1) = scan(trim(lines(block_check(12)+i)(7:)),'x')
					temp_int(2) = scan(trim(lines(block_check(12)+i)(7:)),'y')
					temp_int(3) = scan(trim(lines(block_check(12)+i)(7:)),'z')
					if(temp_int(1) >= 1 .and. temp_int(2) >= 1 .and. temp_int(3) >= 1) then
						sus_intLevel = -1
						sus_intCover = 3
					else if(temp_int(1) >= 1 .and. temp_int(2) == 0 .and. temp_int(3) == 0) then
						sus_intLevel = -2
						sus_intCover = 1
					else if(temp_int(1) == 0 .and. temp_int(2) >= 1 .and. temp_int(3) == 0) then
						sus_intLevel = -2
						sus_intCover = 2
					else if(temp_int(1) == 0 .and. temp_int(2) == 0 .and. temp_int(3) >= 1) then
						sus_intLevel = -2
						sus_intCover = 3
					else
						call error(lines(block_check(12)+i),"Susceptibility field incorrectly specified!")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field x,y,z',temp_int(1:3)
				end if
			else if(lines(block_check(12)+i)(1:4) == 'bsus') then
				do d = 1,1000
					read(lines(block_check(12)+i)(5:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						sus_numB = d-1
						allocate(sus_fields(sus_numB))
						read(lines(block_check(12)+i)(5:),*,IOSTAT=IOstatus) sus_fields
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(12)+i),"Check: ****Sus block")
							deallocate(lines)
							return
						else
							exit
						end if
					end if
				end do
				do d = 1,sus_numB
					if(sus_fields(d) <= 0.0_8) then
						call error(lines(block_check(12)+i),"Susceptibility fields must be > 0 T!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'bsus',sus_fields
			else if(lines(block_check(12)+i)(1:3) == 'tip') then
				read(lines(block_check(12)+i)(4:),*,IOSTAT=IOstatus) sus_tip
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(12)+i),"Check: ****Sus block")
					deallocate(lines)
					return
				end if
				!write(6,*) 'tip',sus_tip
			else if(lines(block_check(12)+i)(1:2) == 'zj') then
				read(lines(block_check(12)+i)(3:),*,IOSTAT=IOstatus) sus_zj
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(12)+i),"Check: ****Sus block")
					deallocate(lines)
					return
				end if
				!write(6,*) 'zj',sus_zj
			else if(lines(block_check(12)+i)(1:5) == 'sweep') then
				read(lines(block_check(12)+i)(6:),*,IOSTAT=IOstatus) sus_low_temp,sus_high_temp,sus_numT,sus_sweep_scale
				if(IOstatus /= 0) then
					read(lines(block_check(12)+i)(6:),*,IOSTAT=IOstatus) sus_low_temp,sus_high_temp,sus_numT
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(12)+i),"Check: ****Sus block")
						deallocate(lines)
						return
					end if
				end if
				if(sus_high_temp < sus_low_temp) then
					temp(1) = sus_low_temp
					sus_low_temp = sus_high_temp
					sus_high_temp = temp(1)
				end if
				if(sus_low_temp <= 0.0_8) sus_low_temp = 0.001_8
				!write(6,*) 'sweep',sus_low_temp,sus_high_temp,sus_numT,sus_sweep_scale
			else if(lines(block_check(12)+i)(1:9) == 'autoscale') then
				sus_autoscale = 1
				!write(6,*) 'sus_autoscale'
			else if(lines(block_check(12)+i)(1:12) == 'differential') then
				sus_differential = .true.
				!write(6,*) 'sus_differential'
			else
				call error(lines(block_check(12)+i),"Unrecognized command. Check: ****Sus block")
				deallocate(lines)
				return
			end if
		end do
		do d = 1,sus_numB
			if(.not. sus_differential .and. sus_fields(d) < 0.001_8) then
				call error(lines(block_check(12)+i),"Susceptibility fields must be > 0.001 T in default M/H mode!")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ13a"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ13A"
	end if
	if(done_tensor > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 21) then
				k = block_check(block_order(i+1))-block_check(21)-1
				exit
			end if
		end do
		do i = 1,k
			if(lines(block_check(21)+i)(1:4) == 'bsus') then
				do d = 1,1000
					read(lines(block_check(21)+i)(5:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						tensor_numB = d-1
						allocate(tensor_fields(tensor_numB))
						read(lines(block_check(21)+i)(5:),*,IOSTAT=IOstatus) tensor_fields
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(21)+i),"Check: ****Tensor block")
							deallocate(lines)
							return
						else
							exit
						end if
					end if
				end do
				do d = 1,tensor_numB
					if(tensor_fields(d) < 0.0_8) then
						call error(lines(block_check(21)+i),"Susceptibility tensor fields must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'bsus',tensor_fields
			else if(lines(block_check(21)+i)(1:5) == 'sweep') then
				read(lines(block_check(21)+i)(6:),*,IOSTAT=IOstatus) tensor_low_temp,tensor_high_temp,tensor_numT,tensor_sweep_scale
				if(IOstatus /= 0) then
					read(lines(block_check(21)+i)(6:),*,IOSTAT=IOstatus) tensor_low_temp,tensor_high_temp,tensor_numT
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(21)+i),"Check: ****Tensor block")
						deallocate(lines)
						return
					end if
				end if
				if(tensor_high_temp < tensor_low_temp) then
					temp(1) = tensor_low_temp
					tensor_low_temp = tensor_high_temp
					tensor_high_temp = temp(1)
				end if
				if(tensor_low_temp <= 0.0_8) tensor_low_temp = 0.001_8
				!write(6,*) 'sweep',tensor_low_temp,tensor_high_temp,tensor_numT,tensor_sweep_scale
			else
				call error(lines(block_check(21)+i),"Unrecognized command. Check: ****Tensor block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ13"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ13"
	end if
	if(done_mag > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 13) then
				k = block_check(block_order(i+1))-block_check(13)-1
				exit
			end if
		end do
		do i = 1,k
			if(lines(block_check(13)+i)(1:5) == 'field') then
				if(lines(block_check(13)+i)(7:12) == 'powder') then
					mag_intCover = 2		! 1 = sphere, 2 = hemisphere, 3 = octant
					read(lines(block_check(13)+i)(13:),*,IOSTAT=IOstatus) mag_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(13)+i),"Check: ****Mag block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field powder',mag_intLevel
				else if(lines(block_check(13)+i)(7:12) == 'vector') then
					mag_intCover = 0
					mag_intLevel = -2
					read(lines(block_check(13)+i)(13:),*,IOSTAT=IOstatus) mag_field_vec
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(13)+i),"Check: ****Mag block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field vector',mag_field_vec
				else if(lines(block_check(13)+i)(7:12) == 'angles') then
					mag_intCover = 0
					mag_intLevel = -2
					read(lines(block_check(13)+i)(13:),*,IOSTAT=IOstatus) temp(1:2)
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(13)+i),"Check: ****Mag block")
						deallocate(lines)
						return
					end if
					mag_field_vec(1) = dsin(temp(1)*pie/180.0_8)*dcos(temp(2)*pie/180.0_8)
					mag_field_vec(2) = dsin(temp(1)*pie/180.0_8)*dsin(temp(2)*pie/180.0_8)
					mag_field_vec(3) = dcos(temp(1)*pie/180.0_8)
					!write(6,*) 'field angles',temp(1:2)
				else if(lines(block_check(13)+i)(7:11) == 'axial') then
					mag_intCover = 4		! 4 = axial grid
					read(lines(block_check(13)+i)(13:),*,IOSTAT=IOstatus) mag_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(13)+i),"Check: ****Mag block")
						deallocate(lines)
						return
					end if
				else
					temp_int(1) = scan(trim(lines(block_check(13)+i)(7:)),'x')
					temp_int(2) = scan(trim(lines(block_check(13)+i)(7:)),'y')
					temp_int(3) = scan(trim(lines(block_check(13)+i)(7:)),'z')
					if(temp_int(1) >= 1 .and. temp_int(2) >= 1 .and. temp_int(3) >= 1) then
						mag_intLevel = -1
						mag_intCover = 3
					else if(temp_int(1) >= 1 .and. temp_int(2) == 0 .and. temp_int(3) == 0) then
						mag_intLevel = -2
						mag_intCover = 1
					else if(temp_int(1) == 0 .and. temp_int(2) >= 1 .and. temp_int(3) == 0) then
						mag_intLevel = -2
						mag_intCover = 2
					else if(temp_int(1) == 0 .and. temp_int(2) == 0 .and. temp_int(3) >= 1) then
						mag_intLevel = -2
						mag_intCover = 3
					else
						call error(lines(block_check(13)+i),"Magnetization field incorrectly specified!")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field x,y,z',temp_int(1:3)
				end if
			else if(lines(block_check(13)+i)(1:4) == 'tmag') then
				do d = 1,1000
					read(lines(block_check(13)+i)(5:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						mag_numT = d-1
						allocate(mag_temps(mag_numT))
						read(lines(block_check(13)+i)(5:),*,IOSTAT=IOstatus) mag_temps
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(13)+i),"Check: ****Mag block")
							deallocate(lines)
							return
						else
							exit
						end if
					end if
				end do
				do d = 1,mag_numT
					if(mag_temps(d) < 0.0_8) then
						call error(lines(block_check(13)+i),"Magnetization temperatures must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'tmag',mag_temps
			else if(lines(block_check(13)+i)(1:5) == 'sweep') then
				read(lines(block_check(13)+i)(6:),*,IOSTAT=IOstatus) mag_low_field,mag_high_field,mag_numB,mag_sweep_scale
				if(IOstatus /= 0) then
					read(lines(block_check(13)+i)(6:),*,IOSTAT=IOstatus) mag_low_field,mag_high_field,mag_numB
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(13)+i),"Check: ****Mag block")
						deallocate(lines)
						return
					end if
				end if
				if(mag_high_field < mag_low_field) then
					temp(1) = mag_low_field
					mag_low_field = mag_high_field
					mag_high_field = temp(1)
				end if
				if(mag_sweep_scale == 'log' .and. mag_low_field < 0.0_8) then
					call error(lines(block_check(13)+i),"Logarithmic scales cannot have negative values!")
					deallocate(lines)
					return
				end if
				if(mag_sweep_scale == 'log' .and. mag_low_field == 0.0_8) mag_low_field = 0.001_8
				!write(6,*) 'sweep',mag_low_field,mag_high_field,mag_numB,mag_sweep_scale
			else if(lines(block_check(13)+i)(1:9) == 'autoscale') then
				mag_autoscale = 1
				!write(6,*) 'mag_autoscale'
			else
				call error(lines(block_check(13)+i),"Unrecognized command. Check: ****Mag block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ14"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ14"
	end if
	if(done_mce > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 14) then
				k = block_check(block_order(i+1))-block_check(14)-1
				exit
			end if
		end do
		do i = 1,k
			if(lines(block_check(14)+i)(1:5) == 'field') then
				if(lines(block_check(14)+i)(7:12) == 'powder') then
					mce_intCover = 2		! 1 = sphere, 2 = hemisphere, 3 = octant
					read(lines(block_check(14)+i)(13:),*,IOSTAT=IOstatus) mce_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(14)+i),"Check: ****MCE block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field powder',mce_intLevel
				else if(lines(block_check(14)+i)(7:12) == 'vector') then
					mce_intCover = 0
					mce_intLevel = -2
					read(lines(block_check(14)+i)(13:),*,IOSTAT=IOstatus) mce_field_vec
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(14)+i),"Check: ****MCE block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field vector',mce_field_vec
				else if(lines(block_check(14)+i)(7:12) == 'angles') then
					mce_intCover = 0
					mce_intLevel = -2
					read(lines(block_check(14)+i)(13:),*,IOSTAT=IOstatus) temp(1:2)
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(14)+i),"Check: ****MCE block")
						deallocate(lines)
						return
					end if
					mce_field_vec(1) = dsin(temp(1)*pie/180.0_8)*dcos(temp(2)*pie/180.0_8)
					mce_field_vec(2) = dsin(temp(1)*pie/180.0_8)*dsin(temp(2)*pie/180.0_8)
					mce_field_vec(3) = dcos(temp(1)*pie/180.0_8)
					!write(6,*) 'field angles',temp(1:2)
				else if(lines(block_check(14)+i)(7:11) == 'axial') then
					mce_intCover = 4		! 4 = axial grid
					read(lines(block_check(14)+i)(13:),*,IOSTAT=IOstatus) mce_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(14)+i),"Check: ****MCE block")
						deallocate(lines)
						return
					end if
				else
					temp_int(1) = scan(trim(lines(block_check(14)+i)(7:)),'x')
					temp_int(2) = scan(trim(lines(block_check(14)+i)(7:)),'y')
					temp_int(3) = scan(trim(lines(block_check(14)+i)(7:)),'z')
					if(temp_int(1) >= 1 .and. temp_int(2) >= 1 .and. temp_int(3) >= 1) then
						mce_intLevel = -1
						mce_intCover = 3
					else if(temp_int(1) >= 1 .and. temp_int(2) == 0 .and. temp_int(3) == 0) then
						mce_intLevel = -2
						mce_intCover = 1
					else if(temp_int(1) == 0 .and. temp_int(2) >= 1 .and. temp_int(3) == 0) then
						mce_intLevel = -2
						mce_intCover = 2
					else if(temp_int(1) == 0 .and. temp_int(2) == 0 .and. temp_int(3) >= 1) then
						mce_intLevel = -2
						mce_intCover = 3
					else
						call error(lines(block_check(14)+i),"MCE field incorrectly specified!")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field x,y,z',temp_int(1:3)
				end if
			else if(lines(block_check(14)+i)(1:4) == 'bmce') then
				do d = 1,1000
					read(lines(block_check(14)+i)(5:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						mce_numB = d-1
						allocate(mce_fields(mce_numB))
						read(lines(block_check(14)+i)(5:),*,IOSTAT=IOstatus) mce_fields
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(14)+i),"Check: ****MCE block")
							deallocate(lines)
							return
						else
							exit
						end if
					end if
				end do
				do d = 1,mce_numB
					if(mce_fields(d) < 0.0_8) then
						call error(lines(block_check(14)+i),"MCE fields must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'bmce',mce_fields
			else if(lines(block_check(14)+i)(1:4) == 'mass') then
				read(lines(block_check(14)+i)(5:),*,IOSTAT=IOstatus) mce_mass
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(14)+i),"Check: ****MCE block")
					deallocate(lines)
					return
				end if
				!write(6,*) 'mass',mce_mass
			else if(lines(block_check(14)+i)(1:9) == 'integrate') then
				read(lines(block_check(14)+i)(10:),*,IOSTAT=IOstatus) mce_integration
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(14)+i),"Check: ****MCE block")
					deallocate(lines)
					return
				end if
				if(mce_integration <= 1) then
					call error(lines(block_check(14)+i),"MCE integration must be > 1")
					deallocate(lines)
					return
				end if
				!write(6,*) 'int',mce_integration
			else if(lines(block_check(14)+i)(1:5) == 'sweep') then
				read(lines(block_check(14)+i)(6:),*,IOSTAT=IOstatus) mce_low_temp,mce_high_temp,mce_numT,mce_sweep_scale
				if(IOstatus /= 0) then
					read(lines(block_check(14)+i)(6:),*,IOSTAT=IOstatus) mce_low_temp,mce_high_temp,mce_numT
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(14)+i),"Check: ****MCE block")
						deallocate(lines)
						return
					end if
				end if
				if(mce_high_temp < mce_low_temp) then
					temp(1) = mce_low_temp
					mce_low_temp = mce_high_temp
					mce_high_temp = temp(1)
				end if
				if(mce_low_temp <= 0.0_8) mce_low_temp = 0.001_8
				!write(6,*) 'sweep',mce_low_temp,mce_high_temp,mce_numT,mce_sweep_scale
			else
				call error(lines(block_check(14)+i),"Unrecognized command. Check: ****MCE block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ15"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ15"
	end if
	if(done_epr > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 15) then
				k = block_check(block_order(i+1))-block_check(15)-1
				exit
			end if
		end do
		epr_numF = 0
		do i = 1,k
			if(lines(block_check(15)+i)(1:4) == 'fepr') then
				do d = 1,1000
					read(lines(block_check(15)+i)(5:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						epr_numF = d-1
						if(epr_numF > 10) then
							call error(lines(block_check(15)+i),"A maximum of 10 EPR frequencies are currently supported")
							deallocate(lines)
							return
						end if
						allocate(epr_freqs(epr_numF),epr_linewidth(epr_numF,3),epr_voigt(epr_numF),epr_mosaic(epr_numF),epr_type(epr_numF))
						read(lines(block_check(15)+i)(5:),*,IOSTAT=IOstatus) epr_freqs
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
							deallocate(lines)
							return
						else
							epr_linewidth = 0.27_8
							epr_voigt = 1.0_8
							epr_mosaic = 0.0_8
							epr_type = 1
							exit
						end if
					end if
				end do
				do d = 1,epr_numF
					if(epr_freqs(d) < 0.0_8) then
						call error(lines(block_check(15)+i),"EPR frequencies must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'fepr',epr_freqs
			end if
		end do
		do i = 1,k
			if(lines(block_check(15)+i)(1:2) == 'lw' .and. lines(block_check(15)+i)(3:3) /= 'x' .and. lines(block_check(15)+i)(3:3) /= 'y' .and. lines(block_check(15)+i)(3:3) /= 'z') then
				!write(6,*) 'first search'
				do d = 1,1000
					read(lines(block_check(15)+i)(3:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						if(d-1 == 1) then
							read(lines(block_check(15)+i)(3:),*,IOSTAT=IOstatus) temp(1)
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
								deallocate(lines)
								return
							end if
							epr_linewidth = temp(1)
						else if(d-1 == epr_numF) then
							read(lines(block_check(15)+i)(3:),*,IOSTAT=IOstatus) epr_linewidth(:,1)
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
								deallocate(lines)
								return
							end if
							do jj = 1,epr_numF
								epr_linewidth(jj,2:3) = epr_linewidth(jj,1)
							end do
						else
							call error(lines(block_check(15)+i),"EPR linewidth incorrectly specified!")
							deallocate(lines)
							return
						end if
						exit
					end if
				end do
				do d = 1,epr_numF
					if(any(epr_linewidth(d,:) < 0.0_8)) then
						call error(lines(block_check(15)+i),"EPR linewidths must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'LW1',epr_linewidth
			end if
		end do
		do i = 1,k
			if(lines(block_check(15)+i)(1:4) == 'fepr') then
				continue
			else if(lines(block_check(15)+i)(1:5) == 'field') then
				if(lines(block_check(15)+i)(7:12) == 'powder') then
					epr_intCover = 2		! 1 = sphere, 2 = hemisphere, 3 = octant
					read(lines(block_check(15)+i)(13:),*,IOSTAT=IOstatus) epr_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field powder',epr_intLevel
				else if(lines(block_check(15)+i)(7:12) == 'vector') then
					epr_intCover = 0
					epr_intLevel = -2
					read(lines(block_check(15)+i)(13:),*,IOSTAT=IOstatus) epr_field_vec
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field vector',epr_field_vec
				else if(lines(block_check(15)+i)(7:12) == 'angles') then
					epr_intCover = 0
					epr_intLevel = -2
					read(lines(block_check(15)+i)(13:),*,IOSTAT=IOstatus) temp(1:2)
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
						deallocate(lines)
						return
					end if
					epr_field_vec(1) = dsin(temp(1)*pie/180.0_8)*dcos(temp(2)*pie/180.0_8)
					epr_field_vec(2) = dsin(temp(1)*pie/180.0_8)*dsin(temp(2)*pie/180.0_8)
					epr_field_vec(3) = dcos(temp(1)*pie/180.0_8)
					!write(6,*) 'field angles',temp(1:2)
				else if(lines(block_check(15)+i)(7:11) == 'axial') then
					epr_intCover = 4		! 4 = axial grid
					read(lines(block_check(15)+i)(13:),*,IOSTAT=IOstatus) epr_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
						deallocate(lines)
						return
					end if
				else
					temp_int(1) = scan(trim(lines(block_check(15)+i)(7:)),'x')
					temp_int(2) = scan(trim(lines(block_check(15)+i)(7:)),'y')
					temp_int(3) = scan(trim(lines(block_check(15)+i)(7:)),'z')
					if(temp_int(1) >= 1 .and. temp_int(2) >= 1 .and. temp_int(3) >= 1) then
						epr_intLevel = -1
						epr_intCover = 3
					else if(temp_int(1) >= 1 .and. temp_int(2) == 0 .and. temp_int(3) == 0) then
						epr_intLevel = -2
						epr_intCover = 1
					else if(temp_int(1) == 0 .and. temp_int(2) >= 1 .and. temp_int(3) == 0) then
						epr_intLevel = -2
						epr_intCover = 2
					else if(temp_int(1) == 0 .and. temp_int(2) == 0 .and. temp_int(3) >= 1) then
						epr_intLevel = -2
						epr_intCover = 3
					else
						call error(lines(block_check(15)+i),"EPR field incorrectly specified!")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field x,y,z',temp_int(1:3)
				end if
			else if(lines(block_check(15)+i)(1:4) == 'tepr') then
				do d = 1,1000
					read(lines(block_check(15)+i)(5:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						epr_numT = d-1
						allocate(epr_temps(epr_numT))
						read(lines(block_check(15)+i)(5:),*,IOSTAT=IOstatus) epr_temps
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
							deallocate(lines)
							return
						else
							exit
						end if
					end if
				end do
				do d = 1,epr_numT
					if(epr_temps(d) < 0.0_8) then
						call error(lines(block_check(15)+i),"EPR temperatures must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'tepr',epr_temps
			else if(lines(block_check(15)+i)(1:4) == 'type') then
				do d = 1,100
					read(lines(block_check(15)+i)(5:),*,IOSTAT=IOstatus) temp_int(1:d)
					if(IOstatus /= 0) then
						if(d-1 == 1) then
							read(lines(block_check(15)+i)(5:),*,IOSTAT=IOstatus) temp_int(1)
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
								deallocate(lines)
								return
							end if
							epr_type = temp_int(1)
						else if(d-1 == epr_numF) then
							read(lines(block_check(15)+i)(5:),*,IOSTAT=IOstatus) epr_type
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
								deallocate(lines)
								return
							end if
						else
							call error(lines(block_check(15)+i),"EPR type incorrectly specified!")
							deallocate(lines)
							return
						end if
						exit
					end if
				end do
				do d = 1,epr_numF
					if(epr_type(d) > 2 .or. epr_type(d) < -1) then
						call error(lines(block_check(15)+i),"EPR Type can only be -1, 0, 1 or 2")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'type',epr_type
			else if(lines(block_check(15)+i)(1:2) == 'lw') then
				if(lines(block_check(15)+i)(3:3) == 'x' .or. lines(block_check(15)+i)(3:3) == 'y' .or. lines(block_check(15)+i)(3:3) == 'z') then
					!write(6,*) 'second search'
					do d = 1,1000
						read(lines(block_check(15)+i)(4:),*,IOSTAT=IOstatus) temp(1:d)
						if(IOstatus /= 0) then
							!write(6,*) 'couldnt read',d
							if(d-1 == 1) then
								read(lines(block_check(15)+i)(4:),*,IOSTAT=IOstatus) temp(1)
								if(IOstatus /= 0) then
									call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
									deallocate(lines)
									return
								end if
								if(temp(1) /= 0.0_8 .and. lines(block_check(15)+i)(3:3) == 'x') epr_linewidth(:,1) = temp(1)
								if(temp(1) /= 0.0_8 .and. lines(block_check(15)+i)(3:3) == 'y') epr_linewidth(:,2) = temp(1)
								if(temp(1) /= 0.0_8 .and. lines(block_check(15)+i)(3:3) == 'z') epr_linewidth(:,3) = temp(1)
							else if(d-1 == epr_numF) then
								read(lines(block_check(15)+i)(4:),*,IOSTAT=IOstatus) temp(1:epr_numF)
								if(IOstatus /= 0) then
									call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
									deallocate(lines)
									return
								end if
								do jj = 1,epr_numF
									if(temp(jj) /= 0.0_8 .and. lines(block_check(15)+i)(3:3) == 'x') epr_linewidth(jj,1) = temp(jj)
									if(temp(jj) /= 0.0_8 .and. lines(block_check(15)+i)(3:3) == 'y') epr_linewidth(jj,2) = temp(jj)
									if(temp(jj) /= 0.0_8 .and. lines(block_check(15)+i)(3:3) == 'z') epr_linewidth(jj,3) = temp(jj)
								end do
							else
								call error(lines(block_check(15)+i),"EPR linewidth incorrectly specified!")
								deallocate(lines)
								return
							end if
							exit
						end if
					end do
					do d = 1,epr_numF
						if(any(epr_linewidth(d,:) < 0.0_8)) then
							call error(lines(block_check(15)+i),"EPR linewidths must be positive values!")
							deallocate(lines)
							return
						end if
					end do
					!write(6,*) 'LW2',epr_linewidth
				end if
			else if(lines(block_check(15)+i)(1:5) == 'voigt') then
				do d = 1,1000
					read(lines(block_check(15)+i)(6:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						if(d-1 == 1) then
							read(lines(block_check(15)+i)(6:),*,IOSTAT=IOstatus) temp(1)
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
								deallocate(lines)
								return
							end if
							epr_voigt = temp(1)
						else if(d-1 == epr_numF) then
							read(lines(block_check(15)+i)(6:),*,IOSTAT=IOstatus) epr_voigt
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
								deallocate(lines)
								return
							end if
						else
							call error(lines(block_check(15)+i),"EPR voigt incorrectly specified!")
							deallocate(lines)
							return
						end if
						exit
					end if
				end do
				do d = 1,epr_numF
					if(epr_voigt(d) < 0.0_8 .or. epr_voigt(d) > 1.0_8) then
						call error(lines(block_check(15)+i),"EPR voigt coefficients must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'voigt',epr_voigt
			else if(lines(block_check(15)+i)(1:6) == 'mosaic') then
				do d = 1,1000
					read(lines(block_check(15)+i)(7:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						if(d-1 == 1) then
							read(lines(block_check(15)+i)(7:),*,IOSTAT=IOstatus) temp(1)
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
								deallocate(lines)
								return
							end if
							epr_mosaic = temp(1)
						else if(d-1 == epr_numF) then
							read(lines(block_check(15)+i)(7:),*,IOSTAT=IOstatus) epr_mosaic
							if(IOstatus /= 0) then
								call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
								deallocate(lines)
								return
							end if
						else
							call error(lines(block_check(15)+i),"EPR mosaic incorrectly specified!")
							deallocate(lines)
							return
						end if
						exit
					end if
				end do
				do d = 1,epr_numF
					if(epr_mosaic(d) < 0.0_8) then
						call error(lines(block_check(15)+i),"EPR mosaic parameters must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'mosaic',epr_mosaic
			else if(lines(block_check(15)+i)(1:4) == 'para') then
				epr_parallel_mode = 1
				!write(6,*) 'parallel mode'
			else if(lines(block_check(15)+i)(1:6) == 'nonorm') then
				epr_normalise = .false.
				!write(6,*) 'no normalisation'
			else if(lines(block_check(15)+i)(1:7) == 'wavelet') then
                                wavelet_error = .true.
                                !write(6,*) 'epr wavelet error'
			else if(lines(block_check(15)+i)(1:8) == 'subspace') then
				read(lines(block_check(15)+i)(9:),*,IOSTAT=IOstatus) epr_subdim
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
					deallocate(lines)
					return
				end if
				epr_do_subspace = 1
				!write(6,*) 'subspace',epr_subdim
			else if(lines(block_check(15)+i)(1:5) == 'sweep') then
				read(lines(block_check(15)+i)(6:),*,IOSTAT=IOstatus) epr_low_field,epr_high_field,epr_numB,epr_sweep_scale
				if(IOstatus /= 0) then
					read(lines(block_check(15)+i)(6:),*,IOSTAT=IOstatus) epr_low_field,epr_high_field,epr_numB
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(15)+i),"Check: ****EPR block")
						deallocate(lines)
						return
					end if
				end if
				if(epr_high_field < epr_low_field) then
					temp(1) = epr_low_field
					epr_low_field = epr_high_field
					epr_high_field = temp(1)
				end if
				if(epr_sweep_scale == 'log' .and. epr_low_field < 0.0_8) then
					call error(lines(block_check(13)+i),"Logarithmic scales cannot have negative values!")
					deallocate(lines)
					return
				end if
				if(epr_sweep_scale == 'log' .and. epr_low_field == 0.0_8) epr_low_field = 0.001_8
				!write(6,*) 'sweep',epr_low_field,epr_high_field,epr_numB,epr_sweep_scale
			else
				call error(lines(block_check(15)+i),"Unrecognized command. Check: ****EPR block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ16"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ16"
	end if
	if(done_zee > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 19) then
				k = block_check(block_order(i+1))-block_check(19)-1
				exit
			end if
		end do
		do i = 1,k
			if(lines(block_check(19)+i)(1:5) == 'field') then
				if(lines(block_check(19)+i)(7:12) == 'vector') then
					zee_intCover = 0
					zee_intLevel = -2
					read(lines(block_check(19)+i)(13:),*,IOSTAT=IOstatus) zee_field_vec
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(19)+i),"Check: ****Zeeman block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field vector',zee_field_vec
				else if(lines(block_check(19)+i)(7:12) == 'angles') then
					zee_intCover = 0
					zee_intLevel = -2
					read(lines(block_check(19)+i)(13:),*,IOSTAT=IOstatus) temp(1:2)
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(19)+i),"Check: ****Zeeman block")
						deallocate(lines)
						return
					end if
					zee_field_vec(1) = dsin(temp(1)*pie/180.0_8)*dcos(temp(2)*pie/180.0_8)
					zee_field_vec(2) = dsin(temp(1)*pie/180.0_8)*dsin(temp(2)*pie/180.0_8)
					zee_field_vec(3) = dcos(temp(1)*pie/180.0_8)
					!write(6,*) 'field angles',temp(1:2)
				else
					temp_int(1) = scan(trim(lines(block_check(19)+i)(7:)),'x')
					temp_int(2) = scan(trim(lines(block_check(19)+i)(7:)),'y')
					temp_int(3) = scan(trim(lines(block_check(19)+i)(7:)),'z')
					if(temp_int(1) >= 1 .and. temp_int(2) >= 1 .and. temp_int(3) >= 1) then
						zee_intLevel = -1
						zee_intCover = 3
					else if(temp_int(1) >= 1 .and. temp_int(2) == 0 .and. temp_int(3) == 0) then
						zee_intLevel = -2
						zee_intCover = 1
					else if(temp_int(1) == 0 .and. temp_int(2) >= 1 .and. temp_int(3) == 0) then
						zee_intLevel = -2
						zee_intCover = 2
					else if(temp_int(1) == 0 .and. temp_int(2) == 0 .and. temp_int(3) >= 1) then
						zee_intLevel = -2
						zee_intCover = 3
					else
						call error(lines(block_check(19)+i),"Zeeman field incorrectly specified!")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field x,y,z',temp_int(1:3)
				end if
			else if(lines(block_check(19)+i)(1:5) == 'sweep') then
				read(lines(block_check(19)+i)(6:),*,IOSTAT=IOstatus) zee_low_field,zee_high_field,zee_numB,zee_sweep_scale
				if(IOstatus /= 0) then
					read(lines(block_check(19)+i)(6:),*,IOSTAT=IOstatus) zee_low_field,zee_high_field,zee_numB
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(19)+i),"Check: ****Zeeman block")
						deallocate(lines)
						return
					end if
				end if
				if(zee_high_field < zee_low_field) then
					temp(1) = zee_low_field
					zee_low_field = zee_high_field
					zee_high_field = temp(1)
				end if
				if(zee_sweep_scale == 'log' .and. zee_low_field < 0.0_8) then
					call error(lines(block_check(13)+i),"Logarithmic scales cannot have negative values!")
					deallocate(lines)
					return
				end if
				if(epr_sweep_scale == 'log' .and. zee_low_field == 0.0_8) zee_low_field = 0.001_8
				!write(6,*) 'sweep',zee_low_field,zee_high_field,zee_numB,zee_sweep_scale
			else
				call error(lines(block_check(19)+i),"Unrecognized command. Check: ****Zeeman block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ20"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ20"
	end if
	if(done_heat > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 20) then
				k = block_check(block_order(i+1))-block_check(20)-1
				exit
			end if
		end do
		do i = 1,k
			if(lines(block_check(20)+i)(1:5) == 'field') then
				if(lines(block_check(20)+i)(7:12) == 'powder') then
					heat_intCover = 2		! 1 = sphere, 2 = hemisphere, 3 = octant
					read(lines(block_check(20)+i)(13:),*,IOSTAT=IOstatus) heat_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(20)+i),"Check: ****HeatCapacity block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field powder',heat_intLevel
				else if(lines(block_check(20)+i)(7:12) == 'vector') then
					heat_intCover = 0
					heat_intLevel = -2
					read(lines(block_check(20)+i)(13:),*,IOSTAT=IOstatus) heat_field_vec
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(20)+i),"Check: ****HeatCapacity block")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field vector',heat_field_vec
				else if(lines(block_check(20)+i)(7:12) == 'angles') then
					heat_intCover = 0
					heat_intLevel = -2
					read(lines(block_check(20)+i)(13:),*,IOSTAT=IOstatus) temp(1:2)
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(20)+i),"Check: ****HeatCapacity block")
						deallocate(lines)
						return
					end if
					heat_field_vec(1) = dsin(temp(1)*pie/180.0_8)*dcos(temp(2)*pie/180.0_8)
					heat_field_vec(2) = dsin(temp(1)*pie/180.0_8)*dsin(temp(2)*pie/180.0_8)
					heat_field_vec(3) = dcos(temp(1)*pie/180.0_8)
					!write(6,*) 'field angles',temp(1:2)
				else if(lines(block_check(20)+i)(7:11) == 'axial') then
					heat_intCover = 4		! 4 = axial grid
					read(lines(block_check(20)+i)(13:),*,IOSTAT=IOstatus) heat_intLevel
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(20)+i),"Check: ****HeatCapacity block")
						deallocate(lines)
						return
					end if
				else
					temp_int(1) = scan(trim(lines(block_check(20)+i)(7:)),'x')
					temp_int(2) = scan(trim(lines(block_check(20)+i)(7:)),'y')
					temp_int(3) = scan(trim(lines(block_check(20)+i)(7:)),'z')
					if(temp_int(1) >= 1 .and. temp_int(2) >= 1 .and. temp_int(3) >= 1) then
						heat_intLevel = -1
						heat_intCover = 3
					else if(temp_int(1) >= 1 .and. temp_int(2) == 0 .and. temp_int(3) == 0) then
						heat_intLevel = -2
						heat_intCover = 1
					else if(temp_int(1) == 0 .and. temp_int(2) >= 1 .and. temp_int(3) == 0) then
						heat_intLevel = -2
						heat_intCover = 2
					else if(temp_int(1) == 0 .and. temp_int(2) == 0 .and. temp_int(3) >= 1) then
						heat_intLevel = -2
						heat_intCover = 3
					else
						call error(lines(block_check(20)+i),"Heat Capacity field incorrectly specified!")
						deallocate(lines)
						return
					end if
					!write(6,*) 'field x,y,z',temp_int(1:3)
				end if
			else if(lines(block_check(20)+i)(1:5) == 'bheat') then
				do d = 1,1000
					read(lines(block_check(20)+i)(6:),*,IOSTAT=IOstatus) temp(1:d)
					if(IOstatus /= 0) then
						heat_numB = d-1
						allocate(heat_fields(heat_numB))
						read(lines(block_check(20)+i)(6:),*,IOSTAT=IOstatus) heat_fields
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(20)+i),"Check: ****HeatCapacity block")
							deallocate(lines)
							return
						else
							exit
						end if
					end if
				end do
				do d = 1,heat_numB
					if(heat_fields(d) < 0.0_8) then
						call error(lines(block_check(20)+i),"Heat Capacity fields must be positive values!")
						deallocate(lines)
						return
					end if
				end do
				!write(6,*) 'bheat',heat_fields
			else if(lines(block_check(20)+i)(1:5) == 'debye') then
				read(lines(block_check(20)+i)(6:),*,IOSTAT=IOstatus) heat_lattice
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(20)+i),"Check: ****HeatCapacity block")
					deallocate(lines)
					return
				end if
				!write(6,*) 'debye',heat_lattice
			else if(lines(block_check(20)+i)(1:5) == 'sweep') then
				read(lines(block_check(20)+i)(6:),*,IOSTAT=IOstatus) heat_low_temp,heat_high_temp,heat_numT,heat_sweep_scale
				if(IOstatus /= 0) then
					read(lines(block_check(20)+i)(6:),*,IOSTAT=IOstatus) heat_low_temp,heat_high_temp,heat_numT
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(20)+i),"Check: ****HeatCapacity block")
						deallocate(lines)
						return
					end if
				end if
				if(heat_high_temp < heat_low_temp) then
					temp(1) = heat_low_temp
					heat_low_temp = heat_high_temp
					heat_high_temp = temp(1)
				end if
				if(heat_low_temp <= 0.0_8) heat_low_temp = 0.001_8
				!write(6,*) 'sweep',heat_low_temp,heat_high_temp,heat_numT,heat_sweep_scale
			else
				call error(lines(block_check(20)+i),"Unrecognized command. Check: ****HeatCapacity block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ21"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ21"
	end if
	if(done_survey > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 16) then
				k = block_check(block_order(i+1))-block_check(16)-1
				exit
			end if
		end do
		read(lines(block_check(16)+1),*,IOSTAT=IOstatus) SurveyTarget
		if(SurveyTarget(1:1) /= 'r' .and. SurveyTarget(1:1) /= 's' .and. SurveyTarget(1:1) /= 'm' .and. SurveyTarget(1:1) /= 'c' .and. SurveyTarget(1:1) /= 'h') then
			call error("Invalid survey target","Check: ****Survey block")
			deallocate(lines)
			return
		end if
		if(IOstatus /= 0) then
			call IO_error(IOstatus,lines(block_check(16)+1),"Check: ****Survey block")
			deallocate(lines)
			return
		end if
		d = 0
		do i = 2,k
			if(lines(block_check(16)+i)(1:2) == '--') then
				sur_NOps = sur_NOps + 1
				if(sur_NOps == 1) sur_N2(sur_NOps) = i-3
				if(sur_NOps /= 1) then
					sur_N2(sur_NOps) = i-3
					do d = sur_NOps-1,1,-1
						sur_N2(sur_NOps) = sur_N2(sur_NOps) - (sur_N2(d) + 2)
					end do
				end if
				!write(6,*) sur_NOps,sur_N2(sur_NOps)
			end if
		end do
		sur_NPOps = sum(sur_N2)
		allocate(sur_codes(sur_NOps,sur_NPOps),sur_nums(sur_NOps,sur_NPOps,3),sur_N22(sur_NOps),sur_init(sur_NOps),sur_final(sur_NOps),sur_steps(sur_NOps))
		d = 1
		sur_codes = ''
		sur_nums = 0
		!write(6,*) 'survey',sur_NOps,sur_NPOps
		do i = 1,sur_NOps
			!write(6,*) 'Ops',i,sur_N2(i)
			read(lines(block_check(16)+1+d),*,IOSTAT=IOstatus) sur_init(i),sur_final(i),sur_steps(i)
			if(IOstatus /= 0) then
				call IO_error(IOstatus,lines(block_check(16)+i),"Check: ****Survey block")
				deallocate(lines)
				return
			end if
			if(sur_steps(i) <= 1) then
				call error(lines(block_check(16)+1+d),"Range must be more than one in the ****Survey block")
				deallocate(lines)
				return
			end if
			d = d + 1
			do jj = 1,sur_N2(i)
				read(lines(block_check(16)+1+d)(1:2),*,IOSTAT=IOstatus) sur_codes(i,jj)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(16)+1+d),"Check: ****Survey block")
					deallocate(lines)
					return
				end if
				if(sur_codes(i,jj) == 'ex' .or. sur_codes(i,jj) == 'in' .or. sur_codes(i,jj) == 'cf' .or. sur_codes(i,jj) == 're' .or. sur_codes(i,jj) == 'es' .or. sur_codes(i,jj) == 'is' .or. sur_codes(i,jj) == 'cs') then
					read(lines(block_check(16)+1+d)(3:),*,IOSTAT=IOstatus) sur_nums(i,jj,1),sur_nums(i,jj,2),sur_nums(i,jj,3)
				else if(sur_codes(i,jj) == 'so' .or. sur_codes(i,jj) == 'gf' .or. sur_codes(i,jj) == 'rc' .or. sur_codes(i,jj) == 'lw' .or. sur_codes(i,jj) == 'ss' .or. sur_codes(i,jj) == 'gs') then
					read(lines(block_check(16)+1+d)(3:),*,IOSTAT=IOstatus) sur_nums(i,jj,1),sur_nums(i,jj,2)
				else if(sur_codes(i,jj) == 'or' .or. sur_codes(i,jj) == 'vo' .or. sur_codes(i,jj) == 'mo' .or. sur_codes(i,jj) == 'os') then
					read(lines(block_check(16)+1+d)(3:),*,IOSTAT=IOstatus) sur_nums(i,jj,1)
				else if(sur_codes(i,jj) == 'ti' .or. sur_codes(i,jj) == 'dt' .or. sur_codes(i,jj) == 'da' .or. sur_codes(i,jj) == 'zj' .or. sur_codes(i,jj) == 'im') then
					IOstatus = 0
					continue
				end if
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(16)+1+d),"Check: ****Survey block")
					deallocate(lines)
					return
				end if
				d = d + 1
				if((sur_nums(i,jj,1) > N .or. sur_nums(i,jj,1) <= 0) .and. (sur_codes(i,jj) == 'ex' .or. sur_codes(i,jj) == 'in' .or. sur_codes(i,jj) == 'so' .or. sur_codes(i,jj) == 'gf' .or. sur_codes(i,jj) == 'cf' .or. sur_codes(i,jj) == 'rc' .or. sur_codes(i,jj) == 're' .or. sur_codes(i,jj) == 'or' .or. sur_codes(i,jj) == 'es' .or. sur_codes(i,jj) == 'is' .or. sur_codes(i,jj) == 'ss' .or. sur_codes(i,jj) == 'gs' .or. sur_codes(i,jj) == 'cs' .or. sur_codes(i,jj) == 'os')) then
					call error(lines(block_check(16)+1+d),"A non-existent centre has been specified in the ****Survey block")
					deallocate(lines)
					return
				end if
				if((sur_nums(i,jj,2) > N .or. sur_nums(i,jj,2) <= 0) .and. (sur_codes(i,jj) == 'ex' .or. sur_codes(i,jj) == 'in' .or. sur_codes(i,jj) == 're' .or. sur_codes(i,jj) == 'es' .or. sur_codes(i,jj) == 'is')) then
					call error(lines(block_check(16)+1+d),"A non-existent centre has been specified in the ****Survey block")
					deallocate(lines)
					return
				end if
				if((sur_nums(i,jj,1) > epr_numF .or. sur_nums(i,jj,1) < 0) .and. (sur_codes(i,jj) == 'lw' .or. sur_codes(i,jj) == 'vo' .or. sur_codes(i,jj) == 'mo')) then
					call error(lines(block_check(16)+1+d),"A non-existent frequency has been specified in the ****Survey block")
					deallocate(lines)
					return
				end if
				if(sur_codes(i,jj) == 'ti' .and. sur_N2(i) > 1) then
					call error(lines(block_check(16)+1+d),"TIP cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(sur_codes(i,jj) == 'im' .and. sur_N2(i) > 1) then
					call error(lines(block_check(16)+1+d),"Impurity fraction cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(sur_codes(i,jj) == 'vo' .and. sur_N2(i) > 1) then
					call error(lines(block_check(16)+1+d),"Voigt parameter cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(sur_codes(i,jj) == 'mo' .and. sur_N2(i) > 1) then
					call error(lines(block_check(16)+1+d),"Mosaicity cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(sur_codes(i,jj) == 'dt' .and. sur_N2(i) > 1) then
					call error(lines(block_check(16)+1+d),"Debye temperature cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(sur_codes(i,jj) == 'da' .and. sur_N2(i) > 1) then
					call error(lines(block_check(16)+1+d),"Debye alpha cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
			end do
			d = d + 1
			!write(6,*) sur_init(i),sur_final(i),sur_steps(i)
			!do jj = 1,sur_N2(i)
			!	write(6,*) sur_codes(i,jj),sur_nums(i,jj,:)
			!end do
			!write(6,*) '----'
		end do
		!write(6,*)
		!write(6,*)
		temp_int = 0
		do i = 1,sur_NOps
			do jj = 1,sur_N2(i)
				if(sur_codes(i,jj) == 'ex' .or. sur_codes(i,jj) == 'es') then
					temp_int(1) = 1
					if(use_interaction_matrix) then
						call error("EX codes are not compatible with","****Interaction block")
						deallocate(lines)
						return
					end if
				end if
				if(sur_codes(i,jj) == 'in' .or. sur_codes(i,jj) == 'is') then
					temp_int(2) = 1
					if(done_exch > 0 .or. done_anti > 0) then
						call error("IN/IS codes are not compatible with","****Exchange or ****Antisymmetric block")
						deallocate(lines)
						return
					end if
				end if
			end do
		end do
		if(temp_int(1) == 1 .and. temp_int(2) == 1) then
			call error("EX/ES and IN/IS codes are not compatible","Check: ****Survey block")
			deallocate(lines)
			return
		else if(temp_int(2) == 1 .and. temp_int(1) == 0) then
			use_interaction_matrix = .true.
		end if
	end if
	if(return_all) then
		!write(6,*) "BQ17"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ17"
	end if
	if(done_fit > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 17) then
				k = block_check(block_order(i+1))-block_check(17)-1
				exit
			end if
		end do
		read(lines(block_check(17)+1),*,IOSTAT=IOstatus) FitMethod
		if(IOstatus /= 0) then
			call IO_error(IOstatus,lines(block_check(17)+1),"Check: ****Fit block")
			deallocate(lines)
			return
		end if
		d = 0
		do i = 2,k
			if(lines(block_check(17)+i)(1:2) == '--') then
				fit_NOps = fit_NOps + 1
				if(fit_NOps == 1) fit_N2(fit_NOps) = i-3
				if(fit_NOps /= 1) then
					fit_N2(fit_NOps) = i-3
					do d = fit_NOps-1,1,-1
						fit_N2(fit_NOps) = fit_N2(fit_NOps) - (fit_N2(d) + 2)
					end do
				end if
				!write(6,*) fit_NOps,fit_N2(fit_NOps)
				if(fit_N2(fit_NOps) < 1) then
					call error(lines(block_check(17)+i-1),"A variable with no parameters has been specified in the ****Fit block")
					deallocate(lines)
					return
				end if
			end if
		end do
		fit_NPOps = sum(fit_N2)
		if(trim(FitMethod) == 'powell') then
			allocate(fit_init(fit_NOps),fit_vec(fit_NOps,fit_NOps),fit_codes(fit_NOps,fit_NPOps),fit_nums(fit_NOps,fit_NPOps,3),fit_N22(fit_NOps),fit_limits(fit_NOps,2))
		else if(trim(FitMethod) == 'simplex') then
			allocate(fit_init(fit_NOps),fit_yq(fit_NOps+1),fit_vec(fit_NOps+1,fit_NOps),fit_codes(fit_NOps,fit_NPOps),fit_nums(fit_NOps,fit_NPOps,3),fit_N22(fit_NOps),fit_limits(fit_NOps,2))
		else
			call error(trim(FitMethod)//" is not a valid fitting algorithm","Please use Powell or Simplex in the ****Fit block")
			deallocate(lines)
			return
		end if
		fit_codes = ''
		fit_nums = 0
		fit_limits(:,:) = infinity
		d = 1
		!write(6,*) 'fit',fit_NOps,fit_NPOps
		do i = 1,fit_NOps
			!write(6,*) 'Ops',i,fit_N2(i)
			read(lines(block_check(17)+1+d),*,IOSTAT=IOstatus) fit_limits(i,1), fit_init(i), fit_limits(i,2)
			if(IOstatus /= 0) then
				read(lines(block_check(17)+1+d),*,IOSTAT=IOstatus) fit_init(i)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(17)+1+d),"Check: ****Fit block")
					deallocate(lines)
					return
				end if
				fit_limits(i,:) = infinity
			end if
			d = d + 1
			do jj = 1,fit_N2(i)
				read(lines(block_check(17)+1+d)(1:2),*,IOSTAT=IOstatus) fit_codes(i,jj)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(17)+1+d),"Check: ****Fit block")
					deallocate(lines)
					return
				end if
				if(fit_codes(i,jj) == 'ex' .or. fit_codes(i,jj) == 'in' .or. fit_codes(i,jj) == 'cf' .or. fit_codes(i,jj) == 're' .or. fit_codes(i,jj) == 'es' .or. fit_codes(i,jj) == 'is' .or. fit_codes(i,jj) == 'cs') then
					read(lines(block_check(17)+1+d)(3:),*,IOSTAT=IOstatus) fit_nums(i,jj,1),fit_nums(i,jj,2),fit_nums(i,jj,3)
				else if(fit_codes(i,jj) == 'so' .or. fit_codes(i,jj) == 'gf' .or. fit_codes(i,jj) == 'rc' .or. fit_codes(i,jj) == 'lw' .or. fit_codes(i,jj) == 'ss' .or. fit_codes(i,jj) == 'gs') then
					read(lines(block_check(17)+1+d)(3:),*,IOSTAT=IOstatus) fit_nums(i,jj,1),fit_nums(i,jj,2)
				else if(fit_codes(i,jj) == 'or' .or. fit_codes(i,jj) == 'vo' .or. fit_codes(i,jj) == 'mo' .or. fit_codes(i,jj) == 'os') then
					read(lines(block_check(17)+1+d)(3:),*,IOSTAT=IOstatus) fit_nums(i,jj,1)
				else if(fit_codes(i,jj) == 'ti' .or. fit_codes(i,jj) == 'dt' .or. fit_codes(i,jj) == 'da' .or. fit_codes(i,jj) == 'zj' .or. fit_codes(i,jj) == 'im') then
					IOstatus = 0
					continue
				end if
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(17)+1+d),"Check: ****Fit block")
					deallocate(lines)
					return
				end if
				d = d + 1
				if((fit_nums(i,jj,1) > N .or. fit_nums(i,jj,1) <= 0) .and. (fit_codes(i,jj) == 'ex' .or. fit_codes(i,jj) == 'in' .or. fit_codes(i,jj) == 'so' .or. fit_codes(i,jj) == 'gf' .or. fit_codes(i,jj) == 'cf' .or. fit_codes(i,jj) == 'rc' .or. fit_codes(i,jj) == 're' .or. fit_codes(i,jj) == 'or' .or. fit_codes(i,jj) == 'es' .or. fit_codes(i,jj) == 'is' .or. fit_codes(i,jj) == 'ss' .or. fit_codes(i,jj) == 'gs' .or. fit_codes(i,jj) == 'cs' .or. fit_codes(i,jj) == 'os')) then
					call error(lines(block_check(17)+1+d),"A non-existent centre has been specified in the ****Fit block")
					deallocate(lines)
					return
				end if
				if((fit_nums(i,jj,2) > N .or. fit_nums(i,jj,2) <= 0) .and. (fit_codes(i,jj) == 'ex' .or. fit_codes(i,jj) == 'in' .or. fit_codes(i,jj) == 're' .or. fit_codes(i,jj) == 'es' .or. fit_codes(i,jj) == 'is')) then
					call error(lines(block_check(17)+1+d),"A non-existent centre has been specified in the ****Fit block")
					deallocate(lines)
					return
				end if
				if((fit_nums(i,jj,1) > epr_numF .or. fit_nums(i,jj,1) < 0) .and. (fit_codes(i,jj) == 'lw' .or. fit_codes(i,jj) == 'vo' .or. fit_codes(i,jj) == 'mo')) then
					call error(lines(block_check(17)+1+d),"A non-existent frequency has been specified in the ****Fit block")
					deallocate(lines)
					return
				end if
				if(fit_codes(i,jj) == 'ti' .and. fit_N2(i) > 1) then
					call error(lines(block_check(17)+1+d),"TIP cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(fit_codes(i,jj) == 'im' .and. fit_N2(i) > 1) then
					call error(lines(block_check(17)+1+d),"Impurity fraction cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(fit_codes(i,jj) == 'vo' .and. fit_N2(i) > 1) then
					call error(lines(block_check(17)+1+d),"Voigt parameter cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(fit_codes(i,jj) == 'mo' .and. fit_N2(i) > 1) then
					call error(lines(block_check(17)+1+d),"Mosaicity cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(fit_codes(i,jj) == 'dt' .and. fit_N2(i) > 1) then
					call error(lines(block_check(17)+1+d),"Debye temperature cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
				if(fit_codes(i,jj) == 'da' .and. fit_N2(i) > 1) then
					call error(lines(block_check(17)+1+d),"Debye alpha cannot be tied to any other parameters")
					deallocate(lines)
					return
				end if
			end do
			d = d + 1
			!write(6,*) fit_limits(i,1),fit_init(i),fit_limits(i,2)
			!do jj = 1,fit_N2(i)
			!	write(6,*) fit_codes(i,jj),fit_nums(i,jj,:)
			!end do
			!write(6,*) '----'
		end do
		!write(6,*)
		!write(6,*)
		temp_int = 0
		do i = 1,fit_NOps
			do jj = 1,fit_N2(i)
				if(fit_codes(i,jj) == 'ex' .or. fit_codes(i,jj) == 'es') then
					temp_int(1) = 1
					if(use_interaction_matrix) then
						call error("EX/ES codes are not compatible with","****Interaction block")
						deallocate(lines)
						return
					end if
				end if
				if(fit_codes(i,jj) == 'in' .or. fit_codes(i,jj) == 'is') then
					temp_int(2) = 1
					if(done_exch > 0 .or. done_anti > 0) then
						call error("IN/IS codes are not compatible with","****Exchange or ****Antisymmetric block")
						deallocate(lines)
						return
					end if
				end if
			end do
		end do
		if(temp_int(1) == 1 .and. temp_int(2) == 1) then
			call error("EX/ES and IN/IS codes are not compatible","Check: ****Fit block")
			deallocate(lines)
			return
		else if(temp_int(2) == 1 .and. temp_int(1) == 0) then
			use_interaction_matrix = .true.
		end if
	end if
	if(return_all) then
		!write(6,*) "BQ18"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ18"
	end if
	if(done_params > 0) then
		do i = 1,poss_blocks
			if(block_order(i) == 18) then
				k = block_check(block_order(i+1))-block_check(18)-1
				exit
			end if
		end do
		do i = 1,k
			if(lines(block_check(18)+i)(1:7) == 'percent') then
				printPercent = 1
			else if(lines(block_check(18)+i)(1:8) == 'residual') then
				read(lines(block_check(18)+i)(9:),*,IOSTAT=IOstatus) char_temp
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(trim(char_temp) == '') ResidualType = 0
				if(trim(char_temp) == 'lowt') ResidualType = 1
				if(trim(char_temp) == 'hight') ResidualType = 2
				if(trim(char_temp) == 'lowb') ResidualType = 3
				if(trim(char_temp) == 'highb') ResidualType = 4
				if(trim(char_temp) == 'lowt/lowb' .or. trim(char_temp) == 'lowb/lowt') ResidualType = 13
				if(trim(char_temp) == 'lowt/highb' .or. trim(char_temp) == 'highb/lowt') ResidualType = 14
				if(trim(char_temp) == 'hight/lowb' .or. trim(char_temp) == 'lowb/hight') ResidualType = 23
				if(trim(char_temp) == 'hight/highb' .or. trim(char_temp) == 'highb/hight') ResidualType = 24
				if(trim(char_temp) == 'lowe') ResidualType = 6
				if(trim(char_temp) == 'highe') ResidualType = 7
				if(trim(char_temp) == 'gfix') ResidualType = 5
			else if(lines(block_check(18)+i)(1:6) == 'opmode') then
				read(lines(block_check(18)+i)(7:),*,IOSTAT=IOstatus) OperationMode,OperationModeB
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
			else if(lines(block_check(18)+i)(1:9) == 'fitvigour') then
				read(lines(block_check(18)+i)(10:),*,IOSTAT=IOstatus) FitVigour
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(FitVigour > 100.0_8 .or. FitVigour < 0.0_8) then
					call error("FitVigour must be between 0 and 100","Check: ****Fit block")
					deallocate(lines)
					return
				end if
				FitVigour = FitVigour/100.0_8
			else if(lines(block_check(18)+i)(1:12) == 'fittolerance') then
				read(lines(block_check(18)+i)(13:),*,IOSTAT=IOstatus) FitTolerance
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(FitTolerance < EPS) then
					call error("FitTolerance must be greater than machine accuracy","Check: ****Fit block")
					deallocate(lines)
					return
				end if
			else if(lines(block_check(18)+i)(1:7) == 'fititer') then
				read(lines(block_check(18)+i)(8:),*,IOSTAT=IOstatus) fit_max_iter
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(fit_max_iter < 1) then
					call error("FitIter must be greater than 0","Check: ****Fit block")
					deallocate(lines)
					return
				end if
			else if(lines(block_check(18)+i)(1:8) == 'fitlimit') then
				read(lines(block_check(18)+i)(9:),*,IOSTAT=IOstatus) FitLimit
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(FitLimit < 1.0_8) then
					call error("FitLimit must be greater than 1","Check: ****Fit block")
					deallocate(lines)
					return
				end if
			else if(lines(block_check(18)+i)(1:3) == 'imp') then
				read(lines(block_check(18)+i)(4:),*,IOSTAT=IOstatus) ImpS, ImpQuant
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(ImpS <= 0) then
					call error("Impurity spin must be greater than 0","Check: ****Fit block")
					deallocate(lines)
					return
				end if
				if(ImpQuant < 0.0_8) then
					call error("Impurity fraction must be a positive quantity","Check: ****Fit block")
					deallocate(lines)
					return
				end if
			else if(lines(block_check(18)+i)(1:3) == 'zfs') then
				do d = 1,100
					read(lines(block_check(18)+i)(4:),*,IOSTAT=IOstatus) temp_int(1:d)
					if(IOstatus /= 0) then
						read(lines(block_check(18)+i)(4:),*,IOSTAT=IOstatus) temp_int(1:d-1)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
							deallocate(lines)
							return
						end if
						do jj = 1,d-1
							if(temp_int(jj) >= 1 .and. temp_int(jj) <= N) then
								D_not_B20(temp_int(jj)) = 1
							else
								call error("Site does not exist for application of ZFS convention","Check: ****Fit block")
								deallocate(lines)
								return
							end if
						end do
						exit
					end if
				end do
			else if(lines(block_check(18)+i)(1:2) == 'jj') then
				read(lines(block_check(18)+i)(3:),*,IOSTAT=IOstatus) temp_int(1:2)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(temp_int(1) > N .or. temp_int(1) <= 0 .or. temp_int(2) > N .or. temp_int(2) <= 0 .or. temp_int(1) == temp_int(2)) then
					call error("Error in J.J coupling input","Check: ****Fit block")
					deallocate(lines)
					return
				end if
				JJ_not_SS(temp_int(1),temp_int(2)) = 1
				JJ_not_SS(temp_int(2),temp_int(1)) = 1
			else if(lines(block_check(18)+i)(1:4) == 'gdir') then
				read(lines(block_check(18)+i)(6:),*,IOSTAT=IOstatus) GDir
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
			else if(lines(block_check(18)+i)(1:14) == 'oredonlyzeeman') then
				ored_only_zeeman = .true.
			else if(lines(block_check(18)+i)(1:6) == 'approx') then
				approx = 1
			else if(lines(block_check(18)+i)(1:8) == 'highprec') then
				high_prec = .true.
			else if(lines(block_check(18)+i)(1:7) == 'staticb') then
				read(lines(block_check(18)+i)(8:),*,IOSTAT=IOstatus) static_field_magnitude,temp(1:3)
				if(IOstatus /= 0) then
					read(lines(block_check(18)+i)(8:),*,IOSTAT=IOstatus) static_field_magnitude,temp(1:2)
					if(IOstatus /= 0) then
						call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
						deallocate(lines)
						return
					end if
					static_field_direction(1) = dsin(temp(1)*pie/180.0_8)*dcos(temp(2)*pie/180.0_8)
					static_field_direction(2) = dsin(temp(1)*pie/180.0_8)*dsin(temp(2)*pie/180.0_8)
					static_field_direction(3) = dcos(temp(1)*pie/180.0_8)
				else
					static_field_direction(1:3) = temp(1:3)
					static_field_direction = static_field_direction/radial(static_field_direction)
				end if
			else if(lines(block_check(18)+i)(1:5) == 'mults') then
				given_multiplicities = 1
				read(lines(block_check(18)+i)(6:),*,IOSTAT=IOstatus) num_mult
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				allocate(GtenDegen(num_mult),g_calc(3,num_mult),gdir_calc(3,3,num_mult))
				read(lines(block_check(18)+i)(6:),*,IOSTAT=IOstatus) num_mult, GtenDegen
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
			else if(lines(block_check(18)+i)(1:6) == 'maxcpu') then
				read(lines(block_check(18)+i)(7:),*,IOSTAT=IOstatus) MaxCPU
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(MaxCPU < 0) MaxCPU = abs(MaxCPU)
			!else if(lines(block_check(18)+i)(1:6) == 'maxgpu') then
			!	read(lines(block_check(18)+i)(7:200),*,IOSTAT=IOstatus) MaxGPU
			!	if(IOstatus /= 0) then
			!		if(mpi_rank == 0) write(6,'(A9,I3)') "IO error ",IOstatus
			!		if(mpi_rank == 0) write(6,'(A31)') "Check: ****Params block; MaxGPU"
			!		call control('kill ')
			!		return
			!	end if
!#ifdef gpu
!				if(MaxGPU < 0) then
!					if(mpi_rank == 0) write(6,'(A41)') "MaxGPU must be greater than or equal to 0"
!					MaxGPU = 0
!				end if
!#else
!				MaxGPU = 0
!#endif
			else if(lines(block_check(18)+i)(1:7) == 'noprint') then
				NoPrint = 1
			else if(lines(block_check(18)+i)(1:7) == 'single') then
				SingleXtal = 1
			else if(lines(block_check(18)+i)(1:7) == 'fullwf') then
				FullWF = 1
			else if(lines(block_check(18)+i)(1:4) == 'save') then
				sur_save = 1
			else if(lines(block_check(18)+i)(1:5) == 'nooef') then
				NoOEF = 1
			!else if(lines(block_check(18)+i)(1:7) == 'binning') then
			!	show_binning = 1
			else if(lines(block_check(18)+i)(1:5) == 'cubic') then
				do d = 1,100
					read(lines(block_check(18)+i)(6:),*,IOSTAT=IOstatus) temp_int(1:d)
					if(IOstatus /= 0) then
						read(lines(block_check(18)+i)(6:),*,IOSTAT=IOstatus) temp_int(1:d-1)
						if(IOstatus /= 0) then
							call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
							deallocate(lines)
							return
						end if
						do jj = 1,d-1
							if(temp_int(jj) >= 1 .and. temp_int(jj) <= N) then
								force_cubic(temp_int(jj)) = 1
							else
								call error("Site does not exist for cubic enforcement","Check: ****Fit block")
								deallocate(lines)
								return
							end if
						end do
						exit
					end if
				end do
			else if(lines(block_check(18)+i)(1:8) == 'nouncert') then
				fit_uncertainties = 0
			else if(lines(block_check(18)+i)(1:6) == 'uncert') then
				continue
			! else if(lines(block_check(18)+i)(1:5) == 'pause') then
				! fit_pause = 1
			else if(lines(block_check(18)+i)(1:6) == 'rotate') then
				read(lines(block_check(18)+i)(7:),*,IOSTAT=IOstatus) temp_int(1), temp(1:3)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(temp_int(1) > N .or. temp_int(1) < 1) then
					call error("Rotating a site which doesn't exist?","Check: ****Fit block")
					deallocate(lines)
					return
				end if
				do_rotate(temp_int(1)) = 1
				CFP_rot(temp_int(1),1) = temp(1)
				CFP_rot(temp_int(1),2) = temp(2)
				CFP_rot(temp_int(1),3) = temp(3)
			else if(lines(block_check(18)+i)(1:8) == 'exrotate') then
				read(lines(block_check(18)+i)(9:),*,IOSTAT=IOstatus) temp_int(1:2), temp(1:3)
				if(IOstatus /= 0) then
					call IO_error(IOstatus,lines(block_check(18)+i),"Check: ****Params block")
					deallocate(lines)
					return
				end if
				if(temp_int(1) > N .or. temp_int(1) < 1 .or. temp_int(2) > N .or. temp_int(2) < 1 .or. temp_int(1) == temp_int(2)) then
					call error("Incorrect exchange pair specified","Check: ****Fit block")
					deallocate(lines)
					return
				end if
				do_exrotate(temp_int(1),temp_int(2)) = 1
				EX_rot(temp_int(1),temp_int(2),1) = temp(1)
				EX_rot(temp_int(1),temp_int(2),2) = temp(2)
				EX_rot(temp_int(1),temp_int(2),3) = temp(3)
			else
				call error(lines(block_check(18)+i),"Unrecognized command. Check: ****Params block")
				deallocate(lines)
				return
			end if
		end do
	end if
	if(return_all) then
		!write(6,*) "BQ19"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BQ19"
	end if
	
10 CONTINUE
	close(41)
	deallocate(lines)
	
	if(OperationMode(1:3) /= 'mat' .and. OperationMode(1:3) /= 'cou' .and. OperationMode(1:3) /= 'eig' .and. (scan(OperationModeB,'g',.false.) == 0 .and. scan(OperationModeB,'d',.false.) == 0 .and. scan(OperationModeB,'s',.false.) == 0 .and. scan(OperationModeB,'m',.false.) == 0 .and. scan(OperationModeB,'c',.false.) == 0 .and. scan(OperationModeB,'z',.false.) == 0 .and. scan(OperationModeB,'e',.false.) == 0 .and. scan(OperationModeB,'h',.false.) == 0 .and. scan(OperationModeB,'i',.false.) == 0 .and. scan(OperationModeB,'l',.false.) == 0 .and. scan(OperationModeB,'t',.false.) == 0)) then
		call output_text('Invalid OpMode',.false.)
		call control('kill ')
		return
	end if
	if(N == 1 .and. OperationMode(1:3) == 'cou') then
		call output_text('Cannot deliver Coupling Report for a single centre',.false.)
		call control('kill ')
		return
	end if
	if(OperationMode(1:3) /= 'cou' .and. (scan(OperationModeB,'g',.false.) /= 0 .and. scan(OperationModeB,'d',.false.) /= 0)) then
		call output_text('OpModes G and D are mutally exclusive',.false.)
		call control('kill ')
		return
	end if
	
	Gmat = 0.0_8
	if(done_inter == 0) then
		EXmat = 0.0_8
		epr_strain_EXmat = 0.0_8
	end if
	
	do k=1,N
		if(twoS(k) == 0 .and. twoL(k) /= 0) then
			call output_text("Cannot have S = 0 and L /= 0",.false.)
			call control('kill ')
			return
		end if
		Gmat(1,1,k) = Gfactor(1,k)
		Gmat(2,2,k) = Gfactor(2,k)
		Gmat(3,3,k) = Gfactor(3,k)
		if(done_inter == 0) then
			do j=1,N
				EXmat(1,1,k,j) = Jss(k,j,1)
				EXmat(2,2,k,j) = Jss(k,j,2)
				EXmat(3,3,k,j) = Jss(k,j,3)
				EXmat(1,2,k,j) = dss(k,j,3)
				EXmat(1,3,k,j) = -dss(k,j,2)
				EXmat(2,1,k,j) = -dss(k,j,3)
				EXmat(2,3,k,j) = dss(k,j,1)
				EXmat(3,1,k,j) = dss(k,j,2)
				EXmat(3,2,k,j) = -dss(k,j,1)
			end do
		end if
	end do
	
	if(OperationMode(1:3) == 'fit') then
		do j=1,fit_NOps
			do k=1,fit_N2(j)
				if(fit_codes(j,k) == 'cf') then! .and. fit_codes(j,k) /= 'im' .and. fit_codes(j,k) /= 'ti'.and. fit_codes(j,k) /= 'vo' .and. fit_codes(j,k) /= 'lw' .and. fit_codes(j,k) /= 'mo' .and. fit_codes(j,k) /= 'dt' .and. fit_codes(j,k) /= 'da') then
					if(MetalType(fit_nums(j,k,1)) == 0) MetalType(fit_nums(j,k,1)) = 2
				end if
			end do
		end do
	end if
	if(OperationMode(1:3) == 'sur') then
		do j=1,sur_NOps
			do k=1,sur_N2(j)
				if(sur_codes(j,k) == 'cf') then! .and. sur_codes(j,k) /= 'im' .and. sur_codes(j,k) /= 'ti'.and. sur_codes(j,k) /= 'vo' .and. sur_codes(j,k) /= 'lw' .and. sur_codes(j,k) /= 'mo' .and. sur_codes(j,k) /= 'dt' .and. sur_codes(j,k) /= 'da') then
					if(MetalType(sur_nums(j,k,1)) == 0) MetalType(sur_nums(j,k,1)) = 2
				end if
			end do
		end do
	end if
	
	do i=1,N
		if(twoS(i) /= 0 .and. twoL(i) /= 0) MetalType(i) = 1
	end do
	
	if(OperationMode(1:3) == 'fit') then
		do j=1,fit_NOps
			do k=1,fit_N2(j)
				if(fit_codes(j,k) == 'so') then! .and. fit_codes(j,k) /= 'im' .and. fit_codes(j,k) /= 'ti'.and. fit_codes(j,k) /= 'vo' .and. fit_codes(j,k) /= 'lw' .and. fit_codes(j,k) /= 'mo') then
					if(MetalType(fit_nums(j,k,1)) /= 1) then
						call output_text("Fit an SO Coupling constant where L = 0?",.false.)
						call control('kill ')
						return
					end if
				end if
				if(fit_codes(j,k) == 'ex') then! .and. fit_codes(j,k) /= 'im' .and. fit_codes(j,k) /= 'ti'.and. fit_codes(j,k) /= 'vo' .and. fit_codes(j,k) /= 'lw' .and. fit_codes(j,k) /= 'mo') then
					do jj = 1,fit_NOps
						do kk=1,fit_N2(jj)
							if(j /= jj .and. k /= kk .and. fit_codes(j,k) == fit_codes(jj,kk) .and. fit_nums(j,k,1) == fit_nums(jj,kk,1) .and. fit_nums(j,k,2) == fit_nums(jj,kk,2) .and. fit_nums(j,k,3) == fit_nums(jj,kk,3)) then
								call output_text("Specified more than one set of exchange",.false.)
								call output_text("parameters between two sites?",.false.)
								call control('kill ')
								return
							end if
						end do
					end do
				end if
			end do
		end do
	end if
	if(OperationMode(1:3) == 'sur') then
		do j=1,sur_NOps
			do k=1,sur_N2(j)
				if(sur_codes(j,k) == 'so') then! .and. sur_codes(j,k) /= 'im' .and. sur_codes(j,k) /= 'ti'.and. sur_codes(j,k) /= 'vo' .and. sur_codes(j,k) /= 'lw' .and. sur_codes(j,k) /= 'mo') then
					if(MetalType(sur_nums(j,k,1)) /= 1) then
						call output_text("Survey an SO Coupling constant where L = 0?",.false.)
						call control('kill ')
						return
					end if
				end if
				if(sur_codes(j,k) == 'ex') then! .and. sur_codes(j,k) /= 'im' .and. sur_codes(j,k) /= 'ti'.and. sur_codes(j,k) /= 'vo' .and. sur_codes(j,k) /= 'lw' .and. sur_codes(j,k) /= 'mo') then
					do jj = 1,sur_NOps
						do kk=1,sur_N2(jj)
							if(j /= jj .and. k /= kk .and. sur_codes(j,k) == sur_codes(jj,kk) .and. sur_nums(j,k,1) == sur_nums(jj,kk,1) .and. sur_nums(j,k,2) == sur_nums(jj,kk,2) .and. sur_nums(j,k,3) == sur_nums(jj,kk,3)) then
								call output_text("Specified more than one set of exchange",.false.)
								call output_text("parameters between two sites?",.false.)
								call control('kill ')
								return
							end if
						end do
					end do
				end if
			end do
		end do
	end if
	
	numAs = 0
	do i = 1,N
		do k = 2,6,2
			do j = -k,k
				if(k == 2) then
					if(A2(i,j) /= 0.0_8) then
						if(MetalType(i) == 0) MetalType(i) = 2
						numAs = numAs + 1
					end if
				end if
				if(k == 4) then
					if(A4(i,j) /= 0.0_8) then
						if(MetalType(i) == 0) MetalType(i) = 2
						numAs = numAs + 1
					end if
				end if
				if(k == 6) then
					if(A6(i,j) /= 0.0_8) then
						if(MetalType(i) == 0) MetalType(i) = 2
						numAs = numAs + 1
					end if
				end if
			end do
		end do
	end do
	
	do j=1,N
		do k=1,N
			if(Jss(j,k,1) /= Jss(j,k,2) .or. Jss(j,k,2) /= Jss(j,k,3) .or. Jss(j,k,1) /= Jss(j,k,3)) numAs = numAs + 1
			if(dss(j,k,1) /= 0.0_8 .or. dss(j,k,2) /= 0.0_8 .or. dss(j,k,3) /= 0.0_8) numAs = numAs + 1
		end do
		if(Gfactor(1,j) /= Gfactor(2,j) .or. Gfactor(1,j) /= Gfactor(3,j) .or. Gfactor(2,j) /= Gfactor(3,j)) numAs = numAs + 1
		if(any(lamda(j,:) /= 0.0_8)) numAs = numAs + 1
	end do
	
	do j=1,N
		if(twoL(j) /= 0 .or. MetalType(j) == 2) numAs = numAs + 1
	end do
	
	if(OperationMode(1:3) == 'fit') then
		do j=1,fit_NOps
			do k=1,fit_N2(j)
				if(fit_codes(j,k) == 'cf') numAs = numAs + 1
				if(fit_codes(j,k) == 'gf' .and. fit_nums(j,k,2) /= 4) numAs = numAs + 1
				if(fit_codes(j,k) == 'ex' .and. fit_nums(j,k,3) /= 4) numAs = numAs + 1
				if(fit_codes(j,k) == 'im' .and. ImpS == 0) then
					call output_text('****Params keyword IMP required to fit magnetic impurity',.false.)
					call control('kill ')
					return
				end if
				if(fit_codes(j,k) == 'zj' .and. scan(OperationModeB,'s',.false.) == 0) then
					call output_text('zJ is redundant for anything other than susceptibility',.false.)
					call control('kill ')
					return
				end if
			end do
		end do
	end if
	if(OperationMode(1:3) == 'sur') then
		do j=1,sur_NOps
			do k=1,sur_N2(j)
				if(sur_codes(j,k) == 'cf') numAs = numAs + 1
				if(sur_codes(j,k) == 'gf' .and. sur_nums(j,k,2) /= 4) numAs = numAs + 1
				if(sur_codes(j,k) == 'ex' .and. sur_nums(j,k,3) /= 4) numAs = numAs + 1
				if(sur_codes(j,k) == 'im' .and. ImpS == 0) then
					call output_text('****Params keyword IMP required to survey magnetic impurity',.false.)
					call control('kill ')
					return
				end if
				if(sur_codes(j,k) == 'zj' .and. scan(OperationModeB,'s',.false.) == 0) then
					call output_text('zJ is redundant for anything other than susceptibility',.false.)
					call control('kill ')
					return
				end if
			end do
		end do
	end if

	if(numAs == 0) aniso = 0
	
	if(aniso == 1 .and. approx == 1 .and. OperationMode(1:3) /= 'cou') then
		call output_text("Cannot use approx mode with an anisotropic system,",.false.)
		call output_text("or when L > 0 or J > 0",.false.)
		call control('kill ')
		return
	end if
	
	if(OperationMode(1:3) /= 'mat' .and. OperationMode(1:3) /= 'cou' .and. OperationMode(1:3) /= 'eig' .and. scan(OperationModeB,'e',.false.) /= 0 .and. approx == 1) then
		call output_text("Cannot calculate EPR with the Approx mode",.false.)

		call control('kill ')
		return
	end if
	
	if((OperationMode(1:3) == 'sur' .or. OperationMode(1:3) == 'fit') .and. (scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0) .and. approx == 1) then
		call output_text("Cannot Fit or Survey g-tensors with the Approx mode",.false.)
		call control('kill ')
		return
	end if
	
	if(N == 1 .and. approx == 1) then
		call output_text('Cannot apply Approx mode to a single centre',.false.)
		approx = 0
	end if

	if(approx == 1 .and. done_shift /=0) then
		call output_text("Cannot use approx mode with energy shifts,",.false.)
		call control('kill ')
		return
	end if
	
	if(aniso == 0 .and. approx == 0) then
		if(done_sus_field == 0) then
			sus_intLevel = -2
			sus_intCover = 3
		end if
		if(done_mag_field == 0) then
			mag_intLevel = -2
			mag_intCover = 3
		end if
		if(done_mce_field == 0) then
			mce_intLevel = -2
			mce_intCover = 3
		end if
		if(done_epr_field == 0) then
			epr_intLevel = -2
			epr_intCover = 3
		end if
		if(done_heat_field == 0) then
			heat_intLevel = -2
			heat_intCover = 3
		end if
	end if
	
	TF = .false.
	if(aniso == 1 .and. SingleXtal == 0) then
		if(scan(OperationModeB,'s',.false.) /= 0 .and. sus_intLevel == -2) TF = .true.
		if(scan(OperationModeB,'m',.false.) /= 0 .and. mag_intLevel == -2) TF = .true.
		if(scan(OperationModeB,'c',.false.) /= 0 .and. mce_intLevel == -2) TF = .true.
		if(scan(OperationModeB,'e',.false.) /= 0 .and. epr_intLevel == -2) TF = .true.
		if(scan(OperationModeB,'h',.false.) /= 0 .and. heat_intLevel == -2) TF = .true.
		if(TF) then
			call output_text("The spin system is anisotropic",.false.)
			call output_text("Unless this is a single crystal, you must powder average",.false.)
			call output_text("Use ****Params keyword 'Single' to suppress",.false.)
			call control('kill ')
			return
		end if
	end if
	
	if(OperationMode(1:3) /= 'mat' .and. OperationMode(1:3) /= 'cou' .and. OperationMode(1:3) /= 'eig') then
		if(sus_numB == 0 .and. scan(OperationModeB,'s',.false.) /= 0) then
			sus_numB = 1
			allocate(sus_fields(sus_numB))
			sus_fields = 0.0_8
			sus_fields(1) = 0.01_8
		end if
		if(tensor_numB == 0 .and. scan(OperationModeB,'t',.false.) /= 0) then
			tensor_numB = 1
			allocate(tensor_fields(tensor_numB))
			tensor_fields = 0.0_8
			tensor_fields(1) = 0.01_8
		end if
		if(mag_numT == 0 .and. scan(OperationModeB,'m',.false.) /= 0) then
			mag_numT = 4
			allocate(mag_temps(mag_numT))
			mag_temps = 0.0_8
			mag_temps(1) = 2.0_8
			mag_temps(2) = 4.0_8
			mag_temps(3) = 10.0_8
			mag_temps(4) = 20.0_8
		end if
		if(epr_numF == 0 .and. scan(OperationModeB,'e',.false.) /= 0) then
			!epr_numF = 3
			!allocate(epr_freqs(epr_numF),epr_linewidth(epr_numF,3),epr_voigt(epr_numF),epr_mosaic(epr_numF))
			!epr_freqs = 0.0_8
			!epr_freqs(1) = 9.5_8
			!epr_freqs(2) = 35.0_8
			!epr_freqs(3) = 94.0_8
			!epr_linewidth = 0.27_8
			!epr_voigt = 1.0_8
			!epr_mosaic = 0.0_8
			call output_text('EPR calculation requested but no EPR frequencies defined',.false.)
			call control('kill ')
			return
		end if
		if(epr_numT == 0 .and. scan(OperationModeB,'e',.false.) /= 0) then
			epr_numT = 1
			allocate(epr_temps(epr_numT))
			epr_temps = 0.0_8
			epr_temps(1) = 5.0_8
		end if
		if(mce_numB == 0 .and. scan(OperationModeB,'c',.false.) /= 0) then
			mce_numB = 1
			allocate(mce_fields(mce_numB))
			mce_fields = 0.0_8
			mce_fields(1) = 7.0_8
		end if
		if(heat_numB == 0 .and. scan(OperationModeB,'h',.false.) /= 0) then
			heat_numB = 1
			allocate(heat_fields(heat_numB))
			heat_fields = 0.0_8
			heat_fields(1) = 0.1_8
		end if
	end if
	
	if(OperationMode(1:3) == 'sim') then
		global_total = 0
		if(approx == 0) then
			if(scan(OperationModeB,'s',.false.) /= 0) global_total = global_total + sus_numB
			if(scan(OperationModeB,'t',.false.) /= 0) global_total = global_total + tensor_numB
			if(scan(OperationModeB,'m',.false.) /= 0) global_total = global_total + mag_numB
			if(scan(OperationModeB,'e',.false.) /= 0) global_total = global_total + epr_numB
			if(scan(OperationModeB,'c',.false.) /= 0) global_total = global_total + mce_numB
			if(scan(OperationModeB,'h',.false.) /= 0) global_total = global_total + heat_numB
			if(scan(OperationModeB,'z',.false.) /= 0) global_total = global_total + zee_numB
		end if
	end if
	
	if(fit_NOps == 0 .and. OperationMode(1:3) == 'fit') then
		call output_text("Fit selected, but no fitting variables?",.false.)
		call control('kill ')
		return
	end if
	if(sur_NOps == 0 .and. OperationMode(1:3) == 'sur') then
		call output_text("Survey selected, but no survey variables?",.false.)
		call control('kill ')
		return
	end if
	if(fit_NOps == 1 .and. trim(FitMethod) == 'simplex') FitMethod = 'powell'
	
	if(done_ion == 1 .and. NoOEF == 0) then
		do k=1,N
			A2(k,:) = A2(k,:)*SF2(k)
			A4(k,:) = A4(k,:)*SF4(k)
			A6(k,:) = A6(k,:)*SF6(k)
			epr_strain_A2(k,:) = epr_strain_A2(k,:)*SF2(k)
			epr_strain_A4(k,:) = epr_strain_A4(k,:)*SF4(k)
			epr_strain_A6(k,:) = epr_strain_A6(k,:)*SF6(k)
		end do
	end if
	
	if(OperationMode(1:3) /= 'mat' .and. OperationMode(1:3) /= 'cou' .and. OperationMode(1:3) /= 'eig' .and. scan(OperationModeB,'e',.false.) /= 0) then
		epr_freqs = epr_freqs*(1.0D9)*(6.62606957D-34)	!GHz to Joule
	end if
	
!#ifdef omp
!	call OMP_set_num_threads(MaxCPU)
!#endif
	
	if(OperationMode(1:3) == 'sur') then
		if(SurveyTarget(1:1) == 'm' .and. scan(OperationModeB,'m',.false.) == 0) then
			call output_text("Survey target is magnetization,",.false.)
			call output_text("yet it is not a property you want to calculate?",.false.)
			call control('kill ')
			return
		else if(SurveyTarget(1:1) == 's' .and. scan(OperationModeB,'s',.false.) == 0) then
			call output_text("Survey target is susceptibility,",.false.)
			call output_text("yet it is not a property you want to calculate?",.false.)
			call control('kill ')
			return
		else if(SurveyTarget(1:1) == 'c' .and. scan(OperationModeB,'c',.false.) == 0) then
			call output_text("Survey target is the magnetocaloric effect,",.false.)
			call output_text("yet it is not a property you want to calculate?",.false.)
			call control('kill ')
			return
		end if
	end if
	if((OperationMode(1:3) == 'sur' .or. OperationMode(1:3) == 'fit') .and. scan(OperationModeB,'z',.false.) /= 0) then
		call output_text("The Zeeman spectrum cannot be surveyed or fitted",.false.)
		call control('kill ')
		return
	end if
	
	beta = 9.27400968D-24
	erg_beta = beta*1D3
	EnergyConvert = 1.98644568326930306D-23
	
	if(allocated(fit_N22)) deallocate(fit_N22)
	if(allocated(sur_N22)) deallocate(sur_N22)
	deallocate(block_check,block_order)
 	end subroutine smart_reading
	
	subroutine print_results
	! Prints calculation results to file
	implicit none
	integer::j,k,l
	logical::access
	if(return_all) then
		!write(6,*) "BR"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BR"
	end if
	if(mpi_rank == 0) then
		if(scan(OperationModeB,'l',.false.) /= 0 .or. (OperationMode(1:3) == 'sim' .and. (scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0))) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_levels.res",status='unknown')
			do j=1,totaldim
				if(high_prec) write(30,'(E24.15E3)') (levs_calc(j)-levs_calc(1))/EnergyConvert
				if(.not. high_prec) write(30,'(E15.6E3)') (levs_calc(j)-levs_calc(1))/EnergyConvert
			end do
			close(30)
		end if
		if(scan(OperationModeB,'m',.false.) /= 0) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_mag.res",status='unknown')
			do j=1,mag_numB
				if(high_prec) write(30,'(E24.15E3)',advance='no') mag_fields(j)
				if(.not. high_prec) write(30,'(E15.6E3)',advance='no') mag_fields(j)
				do k=1,mag_numT
					if(high_prec) write(30,'(E24.15E3)',advance='no') mag_calc(k,j)
					if(.not. high_prec) write(30,'(E15.6E3)',advance='no') mag_calc(k,j)
				end do
				write(30,*)
			end do
			close(30)
		end if
		if(scan(OperationModeB,'s',.false.) /= 0) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_sus.res",status='unknown')
			do j=1,sus_numT
				if(high_prec) write(30,'(E24.15E3)',advance='no') sus_temps(j)
				if(.not. high_prec) write(30,'(E15.6E3)',advance='no') sus_temps(j)
				do k=1,sus_numB
					if(high_prec) write(30,'(E24.15E3)',advance='no') sus_calc(k,j)
					if(.not. high_prec) write(30,'(E15.6E3)',advance='no') sus_calc(k,j)
				end do
				write(30,*)
			end do
			close(30)
		end if
		if(scan(OperationModeB,'t',.false.) /= 0) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_tensor.res",status='unknown')
			do j=1,tensor_numT
				if(high_prec) write(30,'(E24.15E3)',advance='no') tensor_temps(j)
				if(.not. high_prec) write(30,'(E15.6E3)',advance='no') tensor_temps(j)
				do k=1,tensor_numB
					if(high_prec) write(30,'(6E24.15E3)',advance='no') tensor_calc(k,j,1:6)
					if(.not. high_prec) write(30,'(6E15.6E3)',advance='no') tensor_calc(k,j,1:6)
				end do
				write(30,*)
			end do
			close(30)
		end if
		if((scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0 .or. (OperationMode(1:3) == 'sim' .and. scan(OperationModeB,'l',.false.) /= 0)) .and. approx == 0) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_G.res",status='unknown')
			do j=1,g_numCalc
				if(high_prec) write(30,'(12E24.15)') g_calc(1,j), g_calc(2,j), g_calc(3,j), gdir_calc(1,1,j), gdir_calc(2,1,j), gdir_calc(3,1,j), gdir_calc(1,2,j), gdir_calc(2,2,j), gdir_calc(3,2,j), gdir_calc(1,3,j), gdir_calc(2,3,j), gdir_calc(3,3,j)
				if(.not. high_prec) write(30,'(12F10.4)') g_calc(1,j), g_calc(2,j), g_calc(3,j), gdir_calc(1,1,j), gdir_calc(2,1,j), gdir_calc(3,1,j), gdir_calc(1,2,j), gdir_calc(2,2,j), gdir_calc(3,2,j), gdir_calc(1,3,j), gdir_calc(2,3,j), gdir_calc(3,3,j)
			end do
			close(30)
		end if
		if(scan(OperationModeB,'c',.false.) /= 0) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_mce.res",status='unknown')
			do j=1,mce_numT
				if(high_prec) write(30,'(E24.15E3)',advance='no') mce_temps(j)
				if(.not. high_prec) write(30,'(E15.6E3)',advance='no') mce_temps(j)
				do k=1,mce_numB
					if(high_prec) write(30,'(E24.15E3)',advance='no') mce_calc(k,j)
					if(.not. high_prec) write(30,'(E15.6E3)',advance='no') mce_calc(k,j)
				end do
				write(30,*)
			end do
			close(30)
		end if
		if(scan(OperationModeB,'h',.false.) /= 0) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_heat.res",status='unknown')
			do j=1,heat_numT
				if(high_prec) write(30,'(E24.15E3)',advance='no') heat_temps(j)
				if(.not. high_prec) write(30,'(E15.6E3)',advance='no') heat_temps(j)
				do k=1,heat_numB
					if(high_prec) write(30,'(E24.15E3)',advance='no') heat_calc(k,j)
					if(.not. high_prec) write(30,'(E15.6E3)',advance='no') heat_calc(k,j)
				end do
				write(30,*)
			end do
			close(30)
		end if
		if(scan(OperationModeB,'e',.false.) /= 0) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_epr.res",status='unknown')
			do j=1,epr_numB
				if(high_prec) write(30,'(E24.15E3)',advance='no') epr_fields(j)
				if(.not. high_prec) write(30,'(E15.6E3)',advance='no') epr_fields(j)
				do k=1,epr_numF
					do l=1,epr_numT
						if(high_prec) write(30,'(E24.15E3)',advance='no') epr_calc(k,l,j)
						if(.not. high_prec) write(30,'(E15.6E3)',advance='no') epr_calc(k,l,j)
					end do
				end do
				write(30,*)
			end do
			close(30)
		end if
		if(scan(OperationModeB,'z',.false.) /= 0) then
			open(30,file=trim(WorkDir)//"/"//trim(JobTitle)//"_zeeman.res",status='unknown')
			do j=1,zee_numB
				if(high_prec) write(30,'(E24.15E3)',advance='no') zee_fields(j)
				if(.not. high_prec) write(30,'(E15.6E3)',advance='no') zee_fields(j)
				do k=1,totaldim
					if(high_prec) write(30,'(E24.15E3)',advance='no') zee_calc(k,j)
					if(.not. high_prec) write(30,'(E15.6E3)',advance='no') zee_calc(k,j)
				end do
				write(30,*)
			end do
			close(30)
		end if
	end if
	end subroutine print_results
	
	subroutine control(command)
	! Provides headers/footers, timing routines and all stop/deallocation calls
	! Intended to be used first and last in normal operation as well as in abnormal termination
	implicit none
	character(len=5),intent(in)::command
	character(2)::time_format(6)
	integer::time_values(8),TotalTime,m,y,d
	if(return_all) then
		!write(6,*) "BS"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BS"
	end if
	if(trim(command) == 'start') then
		versionholder = versionvar
		call date_and_time(VALUES=time_values)
		time_format = 'I2'
		if(time_values(3) < 10) time_format(1) = 'I1'
		if(time_values(2) < 10) time_format(2) = 'I1'
		if(time_values(5) < 10) time_format(3) = 'I1'
		if(time_values(6) < 10) time_format(4) = 'I1'
		if(time_values(7) < 10) time_format(5) = 'I1'
		call output_text('============================================================',.false.)
		start_time = time_values
		SaveTxt = ""
#ifndef gui
		call output_text(' _______   __    __  ______',.false.)
		call output_text('/       \ /  |  /  |/      |',.false.)
		call output_text('$$$$$$$  |$$ |  $$ |$$$$$$/',.false.)
		call output_text('$$ |__$$ |$$ |__$$ |  $$ |',.false.)
		call output_text('$$    $$/ $$    $$ |  $$ |',.false.)
		call output_text('$$$$$$$/  $$$$$$$$ |  $$ |',.false.)
		call output_text('$$ |      $$ |  $$ | _$$ |_',.false.)
		call output_text('$$ |      $$ |  $$ |/ $$   |',.false.)
		call output_text('$$/       $$/   $$/ $$$$$$/',.false.)
		call output_text('',.true.)
#endif
		write(SaveTxt,'(A5,A5,A11,'//time_format(1)//',A1,'//time_format(2)//',A1,I4,A4,'//time_format(3)//',A1,'//time_format(4)//',A1,'//time_format(5)//')') "PHI v",versionholder," starts on ",time_values(3),"/",time_values(2),"/",time_values(1)," at ",time_values(5),":",time_values(6),":",time_values(7)
		call output_text(SaveTxt,.false.)
		call output_text('nfchilton.com',.false.)
		call output_text('nfchilton@gmail.com',.false.)
		call output_text('============================================================',.false.)
		call output_text("Job: "//trim(JobTitle),.false.)
	else if(trim(command) == 'stop') then
		call deallocate_all
#ifdef mpi
		call MPI_FINALIZE(mpi_error1)
#endif
		call date_and_time(VALUES=time_values)
		time_format = 'I2'
		if(time_values(3) < 10) time_format(1) = 'I1'
		if(time_values(2) < 10) time_format(2) = 'I1'
		if(time_values(5) < 10) time_format(3) = 'I1'
		if(time_values(6) < 10) time_format(4) = 'I1'
		if(time_values(7) < 10) time_format(5) = 'I1'
		call output_text('============================================================',.false.)
		SaveTxt = ""
		write(SaveTxt,'(A22,'//time_format(1)//',A1,'//time_format(2)//',A1,I4,A4,'//time_format(3)//',A1,'//time_format(4)//',A1,'//time_format(5)//')') "PHI exits normally on ",time_values(3),"/",time_values(2),"/",time_values(1)," at ",time_values(5),":",time_values(6),":",time_values(7)
		call output_text(SaveTxt,.false.)
		time_format(:) = 'I2'
		time_format(6) = 'I3'
		TotalTime = 0				
		m = mod((start_time(2)+9),12)
		y = start_time(1) - m/10
		d = 365*y + y/4 - y/100 + y/400 + (m*306+5)/10 + (start_time(3)-1)
		if(start_time(2) /= time_values(2)) then
			m = mod((time_values(2)+9),12)
			y = time_values(1) - m/10
			TotalTime = (365*y+y/4-y/100+y/400+(m*306+5)/10+(time_values(3)-1)-(d+1))*24*60*60*1000+60*60*1000*time_values(5)+60*1000*time_values(6)+1000*time_values(7)+time_values(8) + (1000-start_time(8)) + (60-start_time(7)-1)*1000 + (60-start_time(6)-1)*60*1000 + (24-start_time(5)-1)*60*60*1000
		else
			time_values(:) = time_values(:) - start_time(:)
			TotalTime = 24*60*60*1000*time_values(3)+60*60*1000*time_values(5)+60*1000*time_values(6)+1000*time_values(7)+time_values(8)
		end if
		time_values(3) = TotalTime/(24*60*60*1000)
		TotalTime = TotalTime - time_values(3)*24*60*60*1000
		time_values(5) = TotalTime/(60*60*1000)
		TotalTime = TotalTime - time_values(5)*60*60*1000
		time_values(6) = TotalTime/(60*1000)
		TotalTime = TotalTime - time_values(6)*60*1000
		time_values(7) = TotalTime/(1000)
		TotalTime = TotalTime - time_values(7)*1000
		time_values(8) = TotalTime
		time_format(1) = 'I3'
		if(time_values(3) < 100) time_format(1) = 'I2'
		if(time_values(3) < 10) time_format(1) = 'I1'
		if(time_values(5) < 10) time_format(3) = 'I1'
		if(time_values(6) < 10) time_format(4) = 'I1'
		if(time_values(7) < 10) time_format(5) = 'I1'
		if(time_values(8) < 100) time_format(6) = 'I2'
		if(time_values(8) < 10) time_format(6) = 'I1'
		SaveTxt = ""
		write(SaveTxt,'(A16,'//time_format(1)//',A6,'//time_format(3)//',A5,'//time_format(4)//',A5,'//time_format(5)//',A3,'//time_format(6)//',A3)') "Execution time: ",time_values(3)," days ",time_values(5)," hrs ",time_values(6)," min ",time_values(7)," s ",time_values(8)," ms"
		call output_text(SaveTxt,.false.)
		call output_text('============================================================',.false.)
		!write(6,*) '6J ratio',dble(largest_6J_index)/dble(1000*totaldim)
		close(66)
		close(40)
		close(43)
		close(24)
		close(41)
		close(30)
#ifdef gui
		return_all = .true.
#else
		stop
#endif
	else if(trim(command) == 'kill') then
		call deallocate_all
#ifdef mpi
		call MPI_ABORT(MPI_COMM_WORLD,mpi_error2,mpi_error1)
		SaveTxt = ""
		write(SaveTxt,*) "MPI aborts with",mpi_error2
		call output_text(SaveTxt,.false.)
#endif
		call date_and_time(VALUES=time_values)
		time_format = 'I2'
		if(time_values(3) < 10) time_format(1) = 'I1'
		if(time_values(2) < 10) time_format(2) = 'I1'
		if(time_values(5) < 10) time_format(3) = 'I1'
		if(time_values(6) < 10) time_format(4) = 'I1'
		if(time_values(7) < 10) time_format(5) = 'I1'
		call output_text("============================================================",.false.)
		SaveTxt = ""
		write(SaveTxt,'(A25,'//time_format(1)//',A1,'//time_format(2)//',A1,I4,A4,'//time_format(3)//',A1,'//time_format(4)//',A1,'//time_format(5)//')') "PHI exits erroneously on ",time_values(3),"/",time_values(2),"/",time_values(1)," at ",time_values(5),":",time_values(6),":",time_values(7)
		call output_text(SaveTxt,.false.)
		call output_text("============================================================",.false.)
		close(66)
		close(40)
		close(43)
		close(24)
		close(41)
		close(30)
#ifdef gui
		return_all = .true.
#else
		stop
#endif
	end if
	end subroutine control
	
	subroutine donothing(a)
	implicit none
	real(kind=8),intent(in)::a
	end subroutine donothing
	
	subroutine lowercase(str)
	implicit none
	integer::i,gap
	character*(*)::str
	if(return_all) then
		!write(6,*) "BT"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BT"
	end if
	gap=ICHAR('a')-ICHAR('A')
	if(len(str) > 0) then
		do i=1,len(str)
		if(str(i:i) <= 'Z') then
			if(str(i:i) >= 'A') str(i:i)=CHAR(ICHAR(str(i:i))+gap)
		end if
		end do
	end if
	end subroutine lowercase
	
	subroutine uppercase(str)
	implicit none
	integer::i,gap
	character*(*)::str
	if(return_all) then
		!write(6,*) "BU"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BU"
	end if
	gap=ICHAR('A')-ICHAR('a')
	if(len(str) > 0) then
		do i=1,len(str)
		if(str(i:i) <= 'z') then
			if(str(i:i) >= 'a') str(i:i)=CHAR(ICHAR(str(i:i))+gap)
		end if
		end do
	end if
	end subroutine uppercase
	
	recursive function count_spaces(str) RESULT(Y)
	implicit none
	integer::i,Y
	character*(*)::str
	if(return_all) then
		!write(6,*) "BU1"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BU1"
	end if
	Y = 0
	if(len_trim(str) > 0) then
		do i=1,len_trim(str)
			if(str(i:i) == ' ') Y = Y + 1
		end do
	end if
	end function count_spaces
	
	recursive function count_brackets(str) RESULT(Y)
	implicit none
	integer::i,Y,op,cl
	character*(*)::str
	if(return_all) then
		!write(6,*) "BU2"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BU2"
	end if
	Y = 0
	op = 0
	cl = 0
	if(len_trim(str) > 0) then
		do i=1,len_trim(str)
			if(str(i:i) == '(') op = op + 1
			if(str(i:i) == ')') cl = cl + 1
		end do
	end if
	if(index(trim(str),"(") > index(trim(str),")")) then
		call error("Incorrect brackets detected!",trim(str))
		return
	end if
	if(op == cl) then
		Y = op
	else
		call error("Incomplete brackets detected!",trim(str))
		return
	end if
	end function count_brackets
	
	subroutine check_compile_options
	! Checks compile time options and sets MPI variables
	! Also reads xPU for local GPU use and reads JobTitle
	implicit none
	character(len=2)::String
	integer::IOstatus
	if(return_all) then
		!write(6,*) "BV"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BV"
	end if
!#ifdef plasmaLA
!#ifndef omp
!	if(mpi_rank == 0) write(6,'(A54)') "You must compile with -Domp in addition to -DplasmaLA"
!	call control('kill ')
!	return
!#endif
!#endif

!#ifdef gpu
!#ifdef plasmaLA
!	if(mpi_rank == 0) write(6,'(A37)') "GPU and PLASMA are mutually exclusive"
!	if(mpi_rank == 0) write(6,'(A45)') "Please compile with -Dgpu OR -DplasmaLA -Domp"
!	call control('kill ')
!	return
!#endif
!#ifdef omp
!	if(mpi_rank == 0) write(6,'(A37)') "GPU and OpenMP are mutually exclusive"
!	if(mpi_rank == 0) write(6,'(A36)') "Please recompile with -Dgpu OR -Domp"
!	call control('kill ')
!	return
!#endif
!#endif

#ifdef mpi
#ifdef omp
	call output_text("OpenMP and MPI are mutually exclusive",.false.)
	call output_text("Please recompile with -Domp OR -Dmpi",.false.)
	call control('kill ')
	return
#endif
!#ifdef plasmaLA
!	if(mpi_rank == 0) write(6,'(A37)') "PLASMA and MPI are mutually exclusive"
!	if(mpi_rank == 0) write(6,'(A47)') "Please recompile with -DplasmaLA -Domp OR -Dmpi"
!	call control('kill ')
!	return
!#endif
!#ifdef gpu
!	if(mpi_rank == 0) write(6,'(A34)') "GPU and MPI are mutually exclusive"
!	if(mpi_rank == 0) write(6,'(A36)') "Please recompile with -Dgpu OR -Dmpi"
!	call control('kill ')
!	return
!#endif
	call MPI_Init(mpi_error1)
	call MPI_Comm_size(MPI_COMM_WORLD, mpi_size, mpi_error1)
	call MPI_Comm_rank(MPI_COMM_WORLD, mpi_rank, mpi_error1)
	call getenv("OMPI_COMM_WORLD_LOCAL_RANK",String)
	read(String,'(I2)',IOSTAT=IOstatus) mpi_local_rank
	if(IOstatus /= 0) then
		SaveTxt = ""
		write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
		call output_text(SaveTxt,.false.)
		call output_text("MPI local rank",.false.)
		call control('kill ')
		return
	end if
	call getenv("OMPI_COMM_WORLD_LOCAL_SIZE",String)
	read(String,'(I2)',IOSTAT=IOstatus) mpi_local_size
	if(IOstatus /= 0) then
		SaveTxt = ""
		write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
		call output_text(SaveTxt,.false.)
		call output_text("MPI local size",.false.)
		call control('kill ')
		return
	end if
	!write(6,'(A5,I2,A4,I2,A5,I2,A4,I2)') "I am ",mpi_rank," of ",mpi_size," and ",mpi_local_rank," of ",mpi_local_size
#else
	mpi_size = 1
	mpi_rank = 0
	mpi_local_size = 1
	mpi_local_rank = 0
#endif

!#ifdef gpu
!	call GET_COMMAND_ARGUMENT(1,JobTitle) MUST EXCLUDE -Dgui for this!
!	call GET_COMMAND_ARGUMENT(2,String)
!	read(String,*,IOSTAT=IOstatus) xPU
!	if(IOstatus /= 0) then
!		if(mpi_rank == 0) write(6,'(A9,I3)') "IO error ",IOstatus
!		if(mpi_rank == 0) write(6,'(A3)') "xPU"
!		call control('kill ')
!		return
!	end if
!#else
!	call GET_COMMAND_ARGUMENT(1,JobTitle)
!#endif
	end subroutine check_compile_options
	
	recursive function angle(A,B) RESULT(X)
	implicit none
	real(kind=8),intent(in)::A(3),B(3)
	real(kind=8)::X
	if(return_all) then
		!write(6,*) "BW"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BW"
	end if
	X = 180.0_8*dacos((A(1)*B(1)+A(2)*B(2)+A(3)*B(3))/(radial(A)*radial(B)))/pie
	end function angle
	
	recursive function radial(input) result(res)
	implicit none
	real(kind=8),intent(in)::input(3)
	real(kind=8)::res
	if(return_all) then
		!write(6,*) "BX"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BX"
	end if
	res = dsqrt(input(1)*input(1)+input(2)*input(2)+input(3)*input(3))
	end function radial
	
	recursive subroutine rotate_CFP(ia,ib,ig,iA2,iA4,iA6)
	implicit none
	integer::i,j,k
	complex(kind=8)::D2(5,5),D4(9,9),D6(13,13),B2(5),B4(9),B6(13),Bp2(5),Bp4(9),Bp6(13)
	real(kind=8)::ia,ib,ig,a,b,g,sigma_sum,cosine,sine
	real(kind=8)::iA2(-2:2),iA4(-4:4),iA6(-6:6)
	if(return_all) then
		!write(6,*) "BY"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BY"
	end if
	!Mulak and Mulak's formulae use alternative definition of Euler angles, which switched alpha and gamma
	!The handedness of the Beta rotation is not consistent with my definition, so it is negated. (Corrected since v2.1)
	!This is the Z-Y'-Z'' convention.
	!PHI CONVENTION; RP = RPz(alpha).RPy(beta).RPz(gamma)
	!         [ Cos(x) -Sin(x)   0   ]
	!RPz(x) = [ Sin(x)  Cos(x)   0   ]
	!         [   0       0      1   ]
	!
	!         [ Cos(x)    0    Sin(x)]
	!RPy(x) = [   0       1      0   ]
	!         [-Sin(x)    0    Cos(x)]
	!
	!EASYSPIN CONVENTION; RE = REz(gamma).REy(beta).REz(alpha)
	!         [ Cos(x)  Sin(x)   0   ]
	!REz(x) = [-Sin(x)  Cos(x)   0   ]
	!         [   0       0      1   ]
	!
	!         [ Cos(x)    0   -Sin(x)]
	!REy(x) = [   0       1      0   ]
	!         [ Sin(x)    0    Cos(x)]
	!
	!RE = (RP)^T
	!   = (RPz(alpha).RPy(beta).RPz(gamma))^T
	!   = (RPz(gamma))^T.(RPy(beta))^T.(RPz(alpha))^T
	!   = REz(gamma).REy(beta).REz(alpha)
	a = ia
	b = -ib
	g = ig
	D2 = (0.0_8,0.0_8)
	D4 = (0.0_8,0.0_8)
	D6 = (0.0_8,0.0_8)
	B2 = (0.0_8,0.0_8)
	Bp2 = (0.0_8,0.0_8)
	B4 = (0.0_8,0.0_8)
	Bp4 = (0.0_8,0.0_8)
	B6 = (0.0_8,0.0_8)
	Bp6 = (0.0_8,0.0_8)
	cosine = dcos(b*Pie/360.0_8)
	sine = dsin(b*Pie/360.0_8)
	a = a*pie/180.0_8
	b = b*pie/180.0_8
	g = g*pie/180.0_8
	do i = 1,5
		do j = 1,5
			if(b /= 0.0_8) then
				sigma_sum = 0.0_8
				do k = 0,4
					sigma_sum = sigma_sum + binom(2+j-3,2-i+3-k)*binom(2-j+3,k)*((-1)**(2-i+3-k))*(cosine**(2*k+i-3+j-3))*(sine**(4-2*k-i+3-j+3))
				end do
				D2(i,j) = exp(dcmplx(0.0_8,((i-3)*a + (j-3)*g)))*sqrt(FACT(2+i-3)*FACT(2-i+3)/(FACT(2+j-3)*FACT(2-j+3)))*sigma_sum
			else
				if(i == j) D2(i,j) = exp(dcmplx(0.0_8,((i-3)*a + (j-3)*g)))
			end if
		end do
	end do
	do i = 1,9
		do j = 1,9
			if(b /= 0.0_8) then
				sigma_sum = 0.0_8
				do k = 0,8
					sigma_sum = sigma_sum + binom(4+j-5,4-i+5-k)*binom(4-j+5,k)*((-1)**(4-i+5-k))*(cosine**(2*k+i-5+j-5))*(sine**(8-2*k-i+5-j+5))
				end do
				D4(i,j) = exp(dcmplx(0.0_8,((i-5)*a + (j-5)*g)))*sqrt(FACT(4+i-5)*FACT(4-i+5)/(FACT(4+j-5)*FACT(4-j+5)))*sigma_sum
			else
				if(i == j) D4(i,j) = exp(dcmplx(0.0_8,((i-5)*a + (j-5)*g)))
			end if
		end do
	end do
	do i = 1,13
		do j = 1,13
			if(b /= 0.0_8) then
				sigma_sum = 0.0_8
				do k = 0,12
					sigma_sum = sigma_sum + binom(6+j-7,6-i+7-k)*binom(6-j+7,k)*((-1)**(6-i+7-k))*(cosine**(2*k+i-7+j-7))*(sine**(12-2*k-i+7-j+7))
				end do
				D6(i,j) = exp(dcmplx(0.0_8,((i-7)*a + (j-7)*g)))*sqrt(FACT(6+i-7)*FACT(6-i+7)/(FACT(6+j-7)*FACT(6-j+7)))*sigma_sum
			else
				if(i == j) D6(i,j) = exp(dcmplx(0.0_8,((i-7)*a + (j-7)*g)))
			end if
		end do
	end do
	B2(1) = (dsqrt(6.0_8)/3.0_8)*dcmplx(iA2(2),-iA2(-2))
	B2(2) = (-dsqrt(6.0_8)/6.0_8)*dcmplx(-iA2(1),iA2(-1))
	B2(3) = 2.0_8*iA2(0)
	B2(4) = (-dsqrt(6.0_8)/6.0_8)*dcmplx(iA2(1),iA2(-1))
	B2(5) = (dsqrt(6.0_8)/3.0_8)*dcmplx(iA2(2),iA2(-2))
	B4(1) = (4.0_8*dsqrt(70.0_8)/35.0_8)*dcmplx(iA4(4),-iA4(-4))
	B4(2) = (-2.0_8*dsqrt(35.0_8)/35.0_8)*dcmplx(-iA4(3),iA4(-3))
	B4(3) = (2.0_8*dsqrt(10.0_8)/5.0_8)*dcmplx(iA4(2),-iA4(-2))
	B4(4) = (-2.0_8*dsqrt(5.0_8)/5.0_8)*dcmplx(-iA4(1),iA4(-1))
	B4(5) = 8.0_8*iA4(0)
	B4(6) = (-2.0_8*dsqrt(5.0_8)/5.0_8)*dcmplx(iA4(1),iA4(-1))
	B4(7) = (2.0_8*dsqrt(10.0_8)/5.0_8)*dcmplx(iA4(2),iA4(-2))
	B4(8) = (-2.0_8*dsqrt(35.0_8)/35.0_8)*dcmplx(iA4(3),iA4(-3))
	B4(9) = (4.0_8*dsqrt(70.0_8)/35.0_8)*dcmplx(iA4(4),iA4(-4))
	B6(1) = (16.0_8*dsqrt(231.0_8)/231.0_8)*dcmplx(iA6(6),-iA6(-6))
	B6(2) = (-8.0_8*dsqrt(77.0_8)/231.0_8)*dcmplx(-iA6(5),iA6(-5))
	B6(3) = (8.0_8*dsqrt(14.0_8)/21.0_8)*dcmplx(iA6(4),-iA6(-4))
	B6(4) = (-8.0_8*dsqrt(105.0_8)/105.0_8)*dcmplx(-iA6(3),iA6(-3))
	B6(5) = (16.0_8*dsqrt(105.0_8)/105.0_8)*dcmplx(iA6(2),-iA6(-2))
	B6(6) = (-4.0_8*dsqrt(42.0_8)/21.0_8)*dcmplx(-iA6(1),iA6(-1))
	B6(7) = 16.0_8*iA6(0)
	B6(8) = (-4.0_8*dsqrt(42.0_8)/21.0_8)*dcmplx(iA6(1),iA6(-1))
	B6(9) = (16.0_8*dsqrt(105.0_8)/105.0_8)*dcmplx(iA6(2),iA6(-2))
	B6(10) = (-8.0_8*dsqrt(105.0_8)/105.0_8)*dcmplx(iA6(3),iA6(-3))
	B6(11) = (8.0_8*dsqrt(14.0_8)/21.0_8)*dcmplx(iA6(4),iA6(-4))
	B6(12) = (-8.0_8*dsqrt(77.0_8)/231.0_8)*dcmplx(iA6(5),iA6(-5))
	B6(13) = (16.0_8*dsqrt(231.0_8)/231.0_8)*dcmplx(iA6(6),iA6(-6))
	call ZGEMM('n','n',5,1,5,(1.0_8,0.0_8),D2,5,B2,5,(0.0_8,0.0_8),Bp2,5)
	call ZGEMM('n','n',9,1,9,(1.0_8,0.0_8),D4,9,B4,9,(0.0_8,0.0_8),Bp4,9)
	call ZGEMM('n','n',13,1,13,(1.0_8,0.0_8),D6,13,B6,13,(0.0_8,0.0_8),Bp6,13)
	iA2(0) = 0.5_8*dble(Bp2(3))
	iA2(1) = (-3.0_8/dsqrt(6.0_8))*dble(Bp2(4)-Bp2(2))
	iA2(-1) = dble(dcmplx(0.0_8,3.0_8/dsqrt(6.0_8))*(Bp2(4)+Bp2(2)))
	iA2(2) = (1.5_8/dsqrt(6.0_8))*dble(Bp2(5)+Bp2(1))
	iA2(-2) = dble(dcmplx(0.0_8,-1.5_8/dsqrt(6.0_8))*(Bp2(5)-Bp2(1)))
	iA4(0) = 0.125_8*dble(Bp4(5))
	iA4(1) = (-5.0_8/(4.0_8*dsqrt(5.0_8)))*dble(Bp4(6)-Bp4(4))
	iA4(-1) = dble(dcmplx(0.0_8,5.0_8/(4.0_8*dsqrt(5.0_8)))*(Bp4(6)+Bp4(4)))
	iA4(2) = (5.0_8/(4.0_8*dsqrt(10.0_8)))*dble(Bp4(7)+Bp4(3))
	iA4(-2) = dble(dcmplx(0.0_8,-5.0_8/(4.0_8*dsqrt(10.0_8)))*(Bp4(7)-Bp4(3)))
	iA4(3) = (-35.0_8/(4.0_8*dsqrt(35.0_8)))*dble(Bp4(8)-Bp4(2))
	iA4(-3) = dble(dcmplx(0.0_8,35.0_8/(4.0_8*dsqrt(35.0_8)))*(Bp4(8)+Bp4(2)))
	iA4(4) = (35.0_8/(8.0_8*dsqrt(70.0_8)))*dble(Bp4(9)+Bp4(1))
	iA4(-4) = dble(dcmplx(0.0_8,-35.0_8/(8.0_8*dsqrt(70.0_8)))*(Bp4(9)-Bp4(1)))
	iA6(0) = 0.0625_8*dble(Bp6(7))
	iA6(1) = (-21.0_8/(8.0_8*dsqrt(42.0_8)))*dble(Bp6(8)-Bp6(6))
	iA6(-1) = dble(dcmplx(0.0_8,21.0_8/(8.0_8*dsqrt(42.0_8)))*(Bp6(8)+Bp6(6)))
	iA6(2) = (105.0_8/(32.0_8*dsqrt(105.0_8)))*dble(Bp6(9)+Bp6(5))
	iA6(-2) = dble(dcmplx(0.0_8,-105.0_8/(32.0_8*dsqrt(105.0_8)))*(Bp6(9)-Bp6(5)))
	iA6(3) = (-105.0_8/(16.0_8*dsqrt(105.0_8)))*dble(Bp6(10)-Bp6(4))
	iA6(-3) = dble(dcmplx(0.0_8,105.0_8/(16.0_8*dsqrt(105.0_8)))*(Bp6(10)+Bp6(4)))
	iA6(4) = (21.0_8/(16.0_8*dsqrt(14.0_8)))*dble(Bp6(11)+Bp6(3))
	iA6(-4) = dble(dcmplx(0.0_8,-21.0_8/(16.0_8*dsqrt(14.0_8)))*(Bp6(11)-Bp6(3)))
	iA6(5) = (-231.0_8/(16.0_8*dsqrt(77.0_8)))*dble(Bp6(12)-Bp6(2))
	iA6(-5) = dble(dcmplx(0.0_8,231.0_8/(16.0_8*dsqrt(77.0_8)))*(Bp6(12)+Bp6(2)))
	iA6(6) = (231.0_8/(32.0_8*dsqrt(231.0_8)))*dble(Bp6(13)+Bp6(1))
	iA6(-6) = dble(dcmplx(0.0_8,-231.0_8/(32.0_8*dsqrt(231.0_8)))*(Bp6(13)-Bp6(1)))
	end subroutine rotate_CFP
	
	recursive subroutine rotate_mat(ia,ib,ig,mat)
	implicit none
	real(kind=8)::ia,ib,ig,a,b,g,Euler(3,3),mat(3,3),temp_mat(3,3)
	if(return_all) then
		!write(6,*) "BZ"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*BZ"
	end if
	!Mulak and Mulak's formulae use alternative definition of Euler angles, which switched alpha and gamma
	!This is the Z-Y'-Z'' convention.
	!PHI CONVENTION; RP = RPz(alpha).RPy(beta).RPz(gamma)
	!         [ Cos(x) -Sin(x)   0   ]
	!RPz(x) = [ Sin(x)  Cos(x)   0   ]
	!         [   0       0      1   ]
	!
	!         [ Cos(x)    0    Sin(x)]
	!RPy(x) = [   0       1      0   ]
	!         [-Sin(x)    0    Cos(x)]
	!
	!EASYSPIN CONVENTION; RE = REz(gamma).REy(beta).REz(alpha)
	!         [ Cos(x)  Sin(x)   0   ]
	!REz(x) = [-Sin(x)  Cos(x)   0   ]
	!         [   0       0      1   ]
	!
	!         [ Cos(x)    0   -Sin(x)]
	!REy(x) = [   0       1      0   ]
	!         [ Sin(x)    0    Cos(x)]
	!
	!RE = (RP)^T
	!   = (RPz(alpha).RPy(beta).RPz(gamma))^T
	!   = (RPz(gamma))^T.(RPy(beta))^T.(RPz(alpha))^T
	!   = REz(gamma).REy(beta).REz(alpha)
	a = ia
	b = ib
	g = ig
	a = a*pie/180.0_8
	b = b*pie/180.0_8
	g = g*pie/180.0_8
	Euler(1,1) = dcos(a)*dcos(b)*dcos(g) - dsin(a)*dsin(g)
	Euler(1,2) = -dcos(g)*dsin(a) - dcos(a)*dcos(b)*dsin(g)
	Euler(1,3) = dcos(a)*dsin(b)
	Euler(2,1) = dcos(b)*dcos(g)*dsin(a) + dcos(a)*dsin(g)
	Euler(2,2) = dcos(a)*dcos(g) - dcos(b)*dsin(a)*dsin(g)
	Euler(2,3) = dsin(a)*dsin(b)
	Euler(3,1) = -dcos(g)*dsin(b)
	Euler(3,2) = dsin(b)*dsin(g)
	Euler(3,3) = dcos(b)
	call DGEMM('n','n',3,3,3,1.0_8,Euler,3,mat,3,0.0_8,temp_mat,3)
	call DGEMM('n','t',3,3,3,1.0_8,temp_mat,3,Euler,3,0.0_8,mat,3)
	end subroutine rotate_mat
	
	recursive function binom(n,r) result(res)
	implicit none
	integer,intent(in)::n,r
	real(kind=8)::res
	!if(return_all) then
	!	!write(6,*) "CA"
	!	return
	!else
	!	!!if(mpi_rank == 0) write(6,*) "*CA"
	!end if
	if(n < 0 .or. r < 0 .or. r > n) then
		res = 0.0_8
	else if(n == 0) then
		if(r == 0) then
			res = 1.0_8
		else
			res = 0.0_8
		end if
	else if(n==r .or. r==0) then
	   res = 1.0_8
	else if (r==1) then
	   res = dble(n)
	else
	   res = dble(n)/dble(n-r)*binom(n-1,r)
	end if
	end function binom
	
	recursive subroutine re_order(num,values,list,way)
	! returns ordered list from input
	implicit none
	integer,intent(in)::num
	integer,intent(out),dimension(:)::list(:)
	integer::j,k
	real(kind=8),intent(in),dimension(:)::values(:)
	real(kind=8)::low
	integer,allocatable::done(:)
	character(len=3),intent(in)::way
	if(return_all) then
		!write(6,*) "CB"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*CB"
	end if
	allocate(done(num))
	list(:) = 0
	done(:) = 0
	list(1) = minloc(values,1)
	done(list(1)) = 1
	if(any(values /= values) .or. any(dabs(values) > infinity)) then
		call output_text("NaN or Infinity on entry to re_order",.false.)
		call control('kill ')
		return
	end if
	do j=2,num
		low = 1D99
		do k=1,num
			if((values(k) - values(list(1))) >= (values(list(j-1)) - values(list(1))) .and. (values(k) - values(list(1))) < low .and. done(k) == 0) then
				low = (values(k) - values(list(1)))
				list(j) = k
			end if
		end do
		done(list(j)) = 1
	end do
	if(way == 'max') then
		do j = 1,num
			done(j) = list(num-j+1)
		end do
		list = done
	end if
	deallocate(done)
	end subroutine re_order
	
!	subroutine check_status(Istat1)
!	! Checks CULA status
!	implicit none
!	integer Istat1
!	integer info1
!	integer cula_geterrorinfo
!	if(return_all) then
!		write(6,*) "CC"
!		return
!	end if
!#ifdef gpu
!	info1 = cula_geterrorinfo()
!#else
!	if(mpi_rank == 0) write(6,'(A47)') "GPU not enabled, please choose CPU or recompile"
!	call control('kill ')
!	return
!#endif
!	if (Istat1 .ne. 0) then
!		if (Istat1 .eq. 7) write(*,*) 'CULA: invalid value for parameter ', info1
!		if (Istat1 .eq. 8) write(*,*) 'CULA: data error (', info1 ,')'
!		if (Istat1 .eq. 9) write(*,*) 'CULA: blas error (', info1 ,')'
!		if (Istat1 .eq. 10) write(*,*) 'CULA: runtime error (', info1 ,')'
!		if(Istat1 < 7 .or. Istat1 > 10) then
!#ifdef gpu
!			call cula_getstatusstring(Istat1)
!#else
!			if(mpi_rank == 0) write(6,'(A47)') "GPU not enabled, please choose CPU or recompile"
!			call control('kill ')
!			return
!#endif
!		endif
!		call control('kill ')
!		return
!	end if
!	end subroutine check_status

	subroutine IO_error(IOstatus,str,message)
	implicit none
	integer::IOstatus
	character*(*)::str,message
	call output_text('<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ERROR!',.false.)
	SaveTxt = ""
	write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
	call output_text(SaveTxt,.false.)
	call output_text(trim(str),.false.)
	call output_text(trim(message),.false.)
	call output_text('<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ERROR!',.false.)
	call control('kill ')
	end subroutine IO_error
	
	subroutine error(str,message)
	implicit none
	character*(*)::str,message
	call output_text('<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ERROR!',.false.)
	if(len_trim(str) > 0) call output_text(trim(str),.false.)
	call output_text(trim(message),.false.)
	call output_text('<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ERROR!',.false.)
	call control('kill ')
	end subroutine error
	
	subroutine set_mpi_limits(number,start,finish)
	implicit none
	integer::remainder
	integer,intent(in)::number
	integer,intent(out)::start,finish
	if(return_all) then
		!write(6,*) "CD"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*CD"
	end if
	if(mpi_size < number) then
		if((number/mpi_size)*mpi_size == number) then
			finish = (mpi_rank+1) * (number/mpi_size)
			start = finish - (number/mpi_size) + 1
		else
			remainder = mod(number,mpi_size)
			finish = (mpi_rank+1) * (number/mpi_size)
			start = finish - (number/mpi_size) + 1
			if(mpi_rank+1 <= remainder) then
				finish = finish + (mpi_rank+1)
				start = start + mpi_rank
			else
				finish = finish + remainder
				start = start + remainder
			end if
		end if
	else
		if(mpi_rank+1 > number) then
			start = 0
			finish = 0
		else
			start = mpi_rank+1
			finish = mpi_rank+1
		end if
	end if
	end subroutine set_mpi_limits
	
	subroutine output_text(txt,newline)
	use iso_c_binding
	implicit none
	character*(*),intent(in)::txt
	character(c_char)::string(1001)
	logical::newline
	integer::i
	if(return_all) then
		!write(6,*) "CE"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*CE"
	end if
	string = ''
	if(newline) then
#ifdef gui
		if(mpi_rank == 0) call send_text(" ",1,ptr_to_C_code)
#else
		if(mpi_rank == 0) write(6,*)
#endif
	else
#ifdef gui
		if(mpi_rank == 0) call send_text(trim(txt),len_trim(txt),ptr_to_C_code)
#else
		if(mpi_rank == 0) write(6,'(A)') trim(txt)
#endif
	end if
	end subroutine output_text
	
#ifdef gui
	subroutine send_exp_data_to_gui
	use iso_c_binding
	implicit none
	integer::a,k,i
	if(return_all) then
		!write(6,*) "CF"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*CF"
	end if
	call send_plot_data("tot_dim",totaldim,0.0_8)
	call send_plot_data("sub_dim",epr_subdim,0.0_8)
	if(scan(OperationModeB,'s',.false.) /= 0) then
		do a = 1,sus_numB
			call send_plot_data("susCalB",sus_numB,sus_fields(a))
		end do
		call send_plot_data("susExpB",sus_exp_numB,0.0_8)
		if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
			do a = 0,sus_numB
				do k = 1,sus_numT
					if(a == 0) then
						call send_plot_data("sus_exp",sus_numT,sus_temps(k))
					else
						call send_plot_data("sus_exp",sus_numT,sus_exp(a,k))
					end if
				end do
			end do
		else if(OperationMode(1:3) == 'sim' .and. sus_exp_numT /= 0) then
			do a = 0,sus_exp_numB
				do k = 1,sus_exp_numT
					if(a == 0) then
						call send_plot_data("sus_exp",sus_exp_numT,sus_exp_temps(k))
					else
						call send_plot_data("sus_exp",sus_exp_numT,sus_exp(a,k))
					end if
				end do
			end do
		end if
		call send_plot_signal("susE",ptr_to_C_code)
	end if
	if(scan(OperationModeB,'m',.false.) /= 0) then
		do a = 1,mag_numT
			call send_plot_data("magCalT",mag_numT,mag_temps(a))
		end do
		call send_plot_data("magExpT",mag_exp_numT,0.0_8)
		if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
			do a = 0,mag_numT
				do k = 1,mag_numB
					if(a == 0) then
						call send_plot_data("mag_exp",mag_numB,mag_fields(k))
					else
						call send_plot_data("mag_exp",mag_numB,mag_exp(a,k))
					end if
				end do
			end do
		else if(OperationMode(1:3) == 'sim' .and. mag_exp_numB /= 0) then
			do a = 0,mag_exp_numT
				do k = 1,mag_exp_numB
					if(a == 0) then
						call send_plot_data("mag_exp",mag_exp_numB,mag_exp_fields(k))
					else
						call send_plot_data("mag_exp",mag_exp_numB,mag_exp(a,k))
					end if
				end do
			end do
		end if
		call send_plot_signal("magE",ptr_to_C_code)
	end if
	if(scan(OperationModeB,'c',.false.) /= 0) then
		do a = 1,mce_numB
			call send_plot_data("mceCalB",mce_numB,mce_fields(a))
		end do
		call send_plot_data("mceExpB",mce_exp_numB,0.0_8)
		if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
			do a = 0,mce_numB
				do k = 1,mce_numT
					if(a == 0) then
						call send_plot_data("mce_exp",mce_numT,mce_temps(k))
					else
						call send_plot_data("mce_exp",mce_numT,mce_exp(a,k))
					end if
				end do
			end do
		else if(OperationMode(1:3) == 'sim' .and. mce_exp_numT /= 0) then
			do a = 0,mce_exp_numB
				do k = 1,mce_exp_numT
					if(a == 0) then
						call send_plot_data("mce_exp",mce_exp_numT,mce_exp_temps(k))
					else
						call send_plot_data("mce_exp",mce_exp_numT,mce_exp(a,k))
					end if
				end do
			end do
		end if
		call send_plot_signal("mceE",ptr_to_C_code)
	end if
	if(scan(OperationModeB,'h',.false.) /= 0) then
		do a = 1,heat_numB
			call send_plot_data("heaCalB",heat_numB,heat_fields(a))
		end do
		call send_plot_data("heaExpB",heat_exp_numB,0.0_8)
		if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
			do a = 0,heat_numB
				do k = 1,heat_numT
					if(a == 0) then
						call send_plot_data("hea_exp",heat_numT,heat_temps(k))
					else
						call send_plot_data("hea_exp",heat_numT,heat_exp(a,k))
					end if
				end do
			end do
		else if(OperationMode(1:3) == 'sim' .and. heat_exp_numT /= 0) then
			do a = 0,heat_exp_numB
				do k = 1,heat_exp_numT
					if(a == 0) then
						call send_plot_data("hea_exp",heat_exp_numT,heat_exp_temps(k))
					else
						call send_plot_data("hea_exp",heat_exp_numT,heat_exp(a,k))
					end if
				end do
			end do
		end if
		call send_plot_signal("heaE",ptr_to_C_code)
	end if
	if(scan(OperationModeB,'e',.false.) /= 0) then
		do a = 1,epr_numT
			call send_plot_data("epr_TTT",epr_numT,epr_temps(a))
		end do
		do a = 1,epr_numF
			call send_plot_data("epr_FFF",epr_numF,epr_freqs(a)/((1.0D9)*(6.62606957D-34)))
		end do
		if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
			do a = 1,epr_numB
				call send_plot_data("epr_exp",epr_numB,epr_fields(a))
			end do
			do a = 1,epr_numF
				do k = 1,epr_numT
					do i = 1,epr_numB
						call send_plot_data("epr_exp",epr_numB,epr_exp(a,k,i))
					end do
				end do
			end do
		else if(OperationMode(1:3) == 'sim' .and. epr_exp_numB /= 0) then
			do a = 1,epr_exp_numB
				call send_plot_data("epr_exp",epr_exp_numB,epr_exp_fields(a))
			end do
			do a = 1,epr_numF
				do k = 1,epr_numT
					do i = 1,epr_exp_numB
						call send_plot_data("epr_exp",epr_exp_numB,epr_exp(a,k,i))
					end do
				end do
			end do
		end if
		call send_plot_signal("eprE",ptr_to_C_code)
	end if
	end subroutine send_exp_data_to_gui
#endif

	recursive function random_kiss() result(RANDO)
	! returns pseudo-random number between 0 and 1
	implicit none
	real(kind=8)::RANDO
	integer::integ
	random_kiss_x = 69069 * random_kiss_x + 1327217885
	random_kiss_y = ieor(ieor(ieor(random_kiss_y,ishft(random_kiss_y,13)),ishft(ieor(random_kiss_y,ishft(random_kiss_y,13)),-17)),ishft(ieor(ieor(random_kiss_y,ishft(random_kiss_y,13)),ishft(ieor(random_kiss_y,ishft(random_kiss_y,13)),-17)),5))
	random_kiss_z = 18000 * iand (random_kiss_z, 65535) + ishft (random_kiss_z, - 16)
	random_kiss_w = 30903 * iand (random_kiss_w, 65535) + ishft (random_kiss_w, - 16)
	integ = random_kiss_x + random_kiss_y + ishft (random_kiss_z, 16) + random_kiss_w
	RANDO = integ*2.297483648D-10 + 0.5_8
	end function random_kiss
	
	subroutine random_kiss_seed
	! seeds values for random_kiss
	implicit none
	integer::values(8)
	call date_and_time(VALUES=values)
	random_kiss_x = (values(7)*values(8) + values(8))*123
	random_kiss_y = (values(6)/(values(8)+1) + values(8))*362
	random_kiss_z = (values(6)+values(7)+values(8) + values(8))*521
	random_kiss_w = ((values(5)-values(6))*values(7)/(values(8)+1) + values(8))*916
	end subroutine random_kiss_seed
	
	subroutine inverse(A)
	real(kind=8), dimension(:,:), intent(inout) :: A
	real(kind=8), dimension(size(A,1)) :: work	! work array for LAPACK
	integer, dimension(size(A,1)) :: ipiv	 ! pivot indices
	integer :: n, info
	n = size(A,1)
	! DGETRF computes an LU factorization of a general M-by-N matrix A
	! using partial pivoting with row interchanges.
	call DGETRF(n, n, A, n, ipiv, info)
	if (info /= 0) then
		call output_text('<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ERROR!',.false.)
		call output_text('Matrix is numerically singular and cannot be inverted!',.false.)
		call output_text('<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ERROR!',.false.)
		call control('kill ')
	end if
	! DGETRI computes the inverse of a matrix using the LU factorization
	! computed by DGETRF.
	call DGETRI(n, A, n, ipiv, work, n, info)
	if (info /= 0) then
		call output_text('<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ERROR!',.false.)
		call output_text('Matrix inversion failed!',.false.)
		call output_text('<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ERROR!',.false.)
		call control('kill ')
	end if
	end subroutine inverse
	
end module data
