
!!!!!!!!!!        Nicholas F. Chilton                                                         !!!!!!!!!!
!!!!!!!!!!        email: nfchilton@gmail.com                                                  !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        This file is part of PHI.                                                   !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is free software: you can redistribute it and/or modify                 !!!!!!!!!!
!!!!!!!!!!        it under the terms of the GNU General Public License as published by        !!!!!!!!!!
!!!!!!!!!!        the Free Software Foundation, either version 3 of the License, or           !!!!!!!!!!
!!!!!!!!!!        (at your option) any later version.                                         !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is distributed in the hope that it will be useful,                      !!!!!!!!!!
!!!!!!!!!!        but WITHOUT ANY WARRANTY; without even the implied warranty of              !!!!!!!!!!
!!!!!!!!!!        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               !!!!!!!!!!
!!!!!!!!!!        GNU General Public License for more details.                                !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        You should have received a copy of the GNU General Public License           !!!!!!!!!!
!!!!!!!!!!        along with PHI. If not, see <http://www.gnu.org/licenses/>.                 !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        We request that any results obtained through the use of PHI                 !!!!!!!!!!
!!!!!!!!!!        are accompanied by the following reference:                                 !!!!!!!!!!
!!!!!!!!!!        N. F. Chilton, R. P. Anderson, L. D. Turner, A. Soncini and                 !!!!!!!!!!
!!!!!!!!!!        K. S. Murray, J. Comput. Chem., 2013, 34, 1164 - 1175                       !!!!!!!!!!

module fitting
    use data
    use props
    use wavelet_sub
    implicit none

    contains
    
    subroutine run_fit
        ! Initiates and controls the fitting routines
        implicit none
        integer::k,iterations,j,absparam,HH,lwork,a,b,steps,IERR,d
        real(kind=8)::residual,plus,minus,centre,bothA,bothB,input_copy,pp,mm,pm,mp,FEPS,htemp,hk,hj
        real(kind=8),allocatable::averages(:),moved_params(:),errors(:),hessian(:,:),work(:),correlation_steps(:,:,:,:),corr_init(:),corr_vec(:,:)
        integer,allocatable::IPIV(:)
        character(len=2)::str_copy
        if(return_all) then
            !write(6,*) "CG"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CG"
        end if
        steps = 2
        do j=1,fit_NOps
            do k = 1,fit_N2(j)
                if(fit_codes(j,k) == 'lw' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("LW in fit but not calculating EPR?",.false.)
                else if(fit_codes(j,k) == 'vo' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("VO in fit but not calculating EPR?",.false.)
                else if(fit_codes(j,k) == 'es' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("ES in fit but not calculating EPR?",.false.)
                else if(fit_codes(j,k) == 'is' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("IS in fit but not calculating EPR?",.false.)
                else if(fit_codes(j,k) == 'ss' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("SS in fit but not calculating EPR?",.false.)
                else if(fit_codes(j,k) == 'gs' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("GS in fit but not calculating EPR?",.false.)
                else if(fit_codes(j,k) == 'cs' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("CS in fit but not calculating EPR?",.false.)
                else if(fit_codes(j,k) == 'os' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("OS in fit but not calculating EPR?",.false.)
                else if(fit_codes(j,k) == 'ti' .and. scan(OperationModeB,'s',.false.) == 0) then
                    call output_text("TI in fit but not calculating Susceptibility?",.false.)
                else if(fit_codes(j,k) == 'zj' .and. scan(OperationModeB,'s',.false.) == 0) then
                    call output_text("ZJ in fit but not calculating Susceptibility?",.false.)
                else if(fit_codes(j,k) == 'im' .and. scan(OperationModeB,'s',.false.) == 0) then
                    call output_text("IM in fit but not calculating Susceptibility?",.false.)
                else if(fit_codes(j,k) == 'dt' .and. scan(OperationModeB,'h',.false.) == 0) then
                    call output_text("DT in fit but not calculating Heat Capacity?",.false.)
                else if(fit_codes(j,k) == 'da' .and. scan(OperationModeB,'h',.false.) == 0) then
                    call output_text("DA in fit but not calculating Heat Capacity?",.false.)
                else
                    cycle
                end if
                call control('kill ')
                return
            end do
        end do
        iterations = 0
        FEvals = 0
        allocate(averages(fit_NOps+1),moved_params(fit_NOPs),errors(fit_NOPs),hessian(fit_NOps,fit_NOps),correlation_steps(fit_NOps,fit_NOps,4*steps,3),IPIV(fit_NOps))
        averages = 0.0_8
        fit_vec = 0.0_8
        if(wavelet_error) then
            allocate(epr_wave_exp(epr_numF,epr_numT,size(epr_fields),NINT(1.0_8+(LOG(size(epr_fields)*4.0_8)/LOG(2.0_8))*4)))
            allocate(epr_wave_params(epr_numF,epr_numT,3))
            do d = 1,epr_numF
                do k = 1,epr_numT
                    CALL WAVE_TRANS_OPT(epr_fields(:), epr_exp(d,k,:), epr_wave_params(d,k,:), epr_wave_exp(d,k,:,:))
                end do
            end do
        end if
        if(trim(FitMethod) == 'powell') then
            do k=1,fit_NOps
                if(fit_init(k) /= 0.0_8) then
                    if(any(fit_codes(k,:) == 'vo') .and. fit_init(k) >= 0.5_8) then
                        fit_vec(k,k) = -FitVigour*fit_init(k)
                    else
                        fit_vec(k,k) = FitVigour*fit_init(k)
                    end if
                else
                    if(any(fit_codes(k,:) == 'vo')) then
                        fit_vec(k,k) = 0.10_8
                    else
                        fit_vec(k,k) = 0.50_8
                    end if
                end if
            end do
            call powell(fit_init,fit_vec,fit_NOps,FitTolerance,iterations,residual)
            if(return_all) then
                !write(6,*) "CG1"
                return
            else
                !if(mpi_rank == 0) write(6,*) "*CG1"
            end if
            write(SaveTxt,'(A43)') "==========================================="
            call output_text(SaveTxt,.false.)
            write(SaveTxt,'(A21,I11,A11)') "Finished Powell with ",FEvals," iterations"
            call output_text(SaveTxt,.false.)
            write(SaveTxt,'(A43)') "-------------------------------------------"
            call output_text(SaveTxt,.false.)
            open(45,file=trim(WorkDir)//"/"//trim(JobTitle)//".best",status='unknown')
            write(45,'(A43)') "==========================================="
            write(45,'(A21,I11,A11)') "Finished Powell with ",FEvals," iterations"
            write(45,'(A43)') "-------------------------------------------"
        else if(trim(FitMethod) == 'simplex') then
            fit_vec = 0.0_8
            fit_vec(1,:) = fit_init(:)
            call funk(fit_vec(1,:),fit_yq(1))
            if(return_all) return
            if(fit_NOps > 1) then
                do k = 2,fit_NOps+1
                    fit_vec(k,:) = fit_init(:)
                    if(fit_vec(k,k-1) /= 0.0_8) then
                        if(any(fit_codes(k-1,:) == 'vo') .and. fit_init(k-1) >= 0.5_8) then
                            fit_vec(k,k-1) = (1.0_8-FitVigour)*fit_vec(k,k-1)
                        else
                            fit_vec(k,k-1) = (1.0_8+FitVigour)*fit_vec(k,k-1)
                        end if
                    else
                        if(any(fit_codes(k-1,:) == 'vo')) then
                            fit_vec(k,k-1) = 0.1_8
                        else
                            fit_vec(k,k-1) = 0.5_8
                        end if
                    end if
                    call funk(fit_vec(k,:),fit_yq(k))
                    if(return_all) return
                end do
            end if
            call amoeba(fit_vec,fit_yq,fit_NOps+1,fit_NOps,fit_NOps,FitTolerance,iterations)
            if(return_all) then
                !write(6,*) "CG2"
                return
            else
                !if(mpi_rank == 0) write(6,*) "*CG2"
            end if
            do k = 1,fit_NOps+1
                do j = 1,fit_NOps
                    averages(j) = averages(j) + fit_vec(k,j)
                end do
                averages(fit_NOps+1) = averages(fit_NOps+1) + fit_yq(k)
            end do
            averages(:) = averages(:)/(fit_NOps+1)
            call output_text(SaveTxt,.true.)
            write(SaveTxt,'(A44)') "============================================"
            call output_text(SaveTxt,.false.)
            write(SaveTxt,'(A22,I11,A11)') "Finished Simplex with ",FEvals," iterations"
            call output_text(SaveTxt,.false.)
            write(SaveTxt,'(A44)') "--------------------------------------------"
            call output_text(SaveTxt,.false.)
            residual = averages(fit_NOps+1)
            fit_init = averages(1:fit_NOps)
            open(45,file=trim(WorkDir)//"/"//trim(JobTitle)//".best",status='unknown')
            write(45,'(A44)') "============================================"
            write(45,'(A22,I11,A11)') "Finished Simplex with ",FEvals," iterations"
            write(45,'(A44)') "--------------------------------------------"
        else
            write(SaveTxt,'(A25)') "Invalid fitting algorithm"
            call output_text(SaveTxt,.false.)
            write(SaveTxt,'(A52)') "Please select Powell or Simplex in the ****Fit block"
            call output_text(SaveTxt,.false.)
        end if
        call print_results
        if(fit_uncertainties == 1) then
            uncert_in_progress = 1
            do k = 1,fit_NOps
                !!write(6,*) "==="
                bothA = 99D99
                bothB = 0.02_8
                do while(bothA > 0.055_8 .or. bothA < 0.045_8)
                    !!if(trim(FitMethod) == 'powell') then
                    moved_params = fit_init
                    centre = residual
                    !!else if(trim(FitMethod) == 'simplex') then
                    !!  moved_params = averages(1:fit_NOps)
                    !!  centre = averages(fit_NOps+1)
                    !!end if
                    moved_params(k) = moved_params(k)*(1.0_8+bothB)
                    call funk(moved_params,plus)
                    if(return_all) return
                    moved_params(k) = moved_params(k)*(1.0_8-bothB)/(1.0_8+bothB)
                    call funk(moved_params,minus)
                    if(return_all) return
                    bothA = ((plus+minus)*0.5_8/centre - 1.0_8)
                    !!write(6,*) minus,centre,plus
                    !!write(6,*) bothB, 100.0_8*bothA
                    if(bothA > 0.055_8) bothB = bothB*(0.8_8+0.05_8*random_kiss())
                    if(bothA < 0.045_8) bothB = bothB*(1.3_8-0.05_8*random_kiss())
                end do
                !!if(trim(FitMethod) == 'powell') then
                moved_params = fit_init
                !!else if(trim(FitMethod) == 'simplex') then
                !!  moved_params = averages(1:fit_NOps)
                !!end if
                plus = moved_params(k)*(1.0_8+bothB)
                minus = moved_params(k)*(1.0_8-bothB)
                errors(k) = (dabs(plus-moved_params(k))+dabs(minus-moved_params(k)))*0.5_8
            end do
            !!call funk(averages(1:fit_NOps),residual)
            if(return_all) return
            errors = errors*0.1_8
            correlation_steps = 0.0_8
            if(fit_NOps > 1) then
                do k = 1,fit_NOps
                    do j = k,fit_NOps
                        moved_params = fit_init
                        do a = -steps,steps
                            if(a == 0) cycle
                            moved_params(k) = fit_init(k) + errors(k)*a/dble(steps)
                            if(j /= k) moved_params(j) = fit_init(j) + errors(j)*a/dble(steps)
                            call funk(moved_params,minus)
                            if(a < 0) then
                                correlation_steps(k,j,a+steps+1,1) = errors(k)*a/dble(steps)
                                if(j /= k) correlation_steps(k,j,a+steps+1,2) = errors(j)*a/dble(steps)
                                correlation_steps(k,j,a+steps+1,3) = minus-centre
                            else
                                correlation_steps(k,j,a+steps,1) = errors(k)*a/dble(steps)
                                if(j /= k) correlation_steps(k,j,a+steps,2) = errors(j)*a/dble(steps)
                                correlation_steps(k,j,a+steps,3) = minus-centre
                            end if
                        end do
                        if(j /= k) then
                            do a = -steps,steps
                                if(a == 0) cycle
                                moved_params(k) = fit_init(k) + errors(k)*a/dble(steps)
                                if(j /= k) moved_params(j) = fit_init(j) - errors(j)*a/dble(steps)
                                call funk(moved_params,minus)
                                if(a < 0) then
                                    correlation_steps(k,j,a+steps+1+2*steps,1) = errors(k)*a/dble(steps)
                                    if(j /= k) correlation_steps(k,j,a+steps+1+2*steps,2) = -errors(j)*a/dble(steps)
                                    correlation_steps(k,j,a+steps+1+2*steps,3) = minus-centre
                                else
                                    correlation_steps(k,j,a+steps+2*steps,1) = errors(k)*a/dble(steps)
                                    if(j /= k) correlation_steps(k,j,a+steps+2*steps,2) = -errors(j)*a/dble(steps)
                                    correlation_steps(k,j,a+steps+2*steps,3) = minus-centre
                                end if
                            end do
                        end if
                    end do
                end do
                do k = 1,fit_NOps-1
                    do j = k+1,fit_NOps
                        star_correlation = 0.0_8
                        star_correlation(1:2*steps,1:3) = correlation_steps(k,k,1:2*steps,1:3)
                        star_correlation(2*steps+1:4*steps,2) = correlation_steps(j,j,1:2*steps,1)
                        star_correlation(2*steps+1:4*steps,3) = correlation_steps(j,j,1:2*steps,3)
                        star_correlation(4*steps+1:8*steps,1:3) = correlation_steps(k,j,1:4*steps,1:3)
                        !write(6,*) "STAR",k,j
                        !do HH = 1,16
                        !   write(6,*) star_correlation(HH,1),star_correlation(HH,2),star_correlation(HH,3)
                        !end do
                        fit_star = .false.
                        allocate(corr_init(1),corr_vec(1,1))
                        corr_init(1) = 1.0_8
                        corr_vec(1,1) = 0.1_8
                        call powell(corr_init,corr_vec,1,1D4*FitTolerance,HH,plus)
                        hessian(k,j) = corr_init(1)
                        hessian(j,k) = corr_init(1)
                        deallocate(corr_init,corr_vec)
                        fit_star = .true.
                        allocate(corr_init(5),corr_vec(5,5))
                        corr_init(1) = 0.5_8*(correlation_steps(k,k,1,3) + correlation_steps(k,k,4,3))/(correlation_steps(k,k,1,1)**2)
                        corr_init(2) = 0.5_8*((correlation_steps(k,k,1,3) - 0.5_8*(correlation_steps(k,k,1,3) + correlation_steps(k,k,4,3))/(correlation_steps(k,k,1,1)**2)*(correlation_steps(k,k,1,1)**2))/correlation_steps(k,k,1,1) + (correlation_steps(k,k,4,3) - 0.5_8*(correlation_steps(k,k,1,3) + correlation_steps(k,k,4,3))/(correlation_steps(k,k,1,1)**2)*(correlation_steps(k,k,4,1)**2))/correlation_steps(k,k,4,1))
                        corr_init(3) = 0.5_8*(correlation_steps(j,j,1,3) + correlation_steps(j,j,4,3))/(correlation_steps(j,j,1,1)**2)
                        corr_init(4) = 0.5_8*((correlation_steps(j,j,1,3) - 0.5_8*(correlation_steps(j,j,1,3) + correlation_steps(j,j,4,3))/(correlation_steps(j,j,1,1)**2)*(correlation_steps(j,j,1,1)**2))/correlation_steps(j,j,1,1) + (correlation_steps(j,j,4,3) - 0.5_8*(correlation_steps(j,j,1,3) + correlation_steps(j,j,4,3))/(correlation_steps(j,j,1,1)**2)*(correlation_steps(j,j,4,1)**2))/correlation_steps(j,j,4,1))
                        corr_init(5) = hessian(k,j)
                        corr_vec(1,1) = 0.001_8*corr_init(1)
                        corr_vec(2,2) = 0.001_8*corr_init(2)
                        corr_vec(3,3) = 0.001_8*corr_init(3)
                        corr_vec(4,4) = 0.001_8*corr_init(4)
                        corr_vec(5,5) = 0.001_8*corr_init(5)
                        call powell(corr_init,corr_vec,5,FitTolerance,HH,plus)
                        hessian(k,k) = 2.0_8*corr_init(1)
                        hessian(j,j) = 2.0_8*corr_init(3)
                        hessian(k,j) = corr_init(5)
                        hessian(j,k) = corr_init(5)
                        deallocate(corr_init,corr_vec)
                    end do
                end do
                !write(6,*) "hessian init"
                !write(6,*) hessian(1,:)
                !write(6,*) hessian(2,:)
                !write(6,*) hessian(3,:)
                call inverse(hessian)
                !write(6,*) "inverse"
                !write(6,*) hessian(1,:)
                !write(6,*) hessian(2,:)
                !write(6,*) hessian(3,:)
                hessian = hessian*centre/(dble(fit_Npoints)-dble(fit_NOps))
                !write(6,*) centre, fit_Npoints, centre/(dble(fit_Npoints)-dble(fit_NOps))
                !write(6,*) "scaled"
                !write(6,*) hessian(1,:)
                !write(6,*) hessian(2,:)
                !write(6,*) hessian(3,:)
                do k = 1,fit_NOps
                    hessian(k,k) = dsqrt(hessian(k,k))
                end do
                do k = 1,fit_NOps
                    do j = 1,fit_NOps
                        if(j /= k)  hessian(k,j) = hessian(k,j)/(hessian(k,k)*hessian(j,j))
                    end do
                end do
                if(return_all) return
            else
                moved_params = fit_init
                k = 1
                do a = -steps,steps
                    if(a == 0) cycle
                    moved_params(k) = fit_init(k) + errors(k)*a/dble(steps)
                    call funk(moved_params,minus)
                    if(a < 0) then
                        correlation_steps(k,k,a+steps+1,1) = errors(k)*a/dble(steps)
                        correlation_steps(k,k,a+steps+1,3) = minus-centre
                    else
                        correlation_steps(k,k,a+steps,1) = errors(k)*a/dble(steps)
                        correlation_steps(k,k,a+steps,3) = minus-centre
                    end if
                end do
                hessian(1,1) = 0.5_8*(correlation_steps(k,k,1,3) + correlation_steps(k,k,4,3))/(correlation_steps(k,k,1,1)**2)
                !write(6,*) "hessian init"
                !write(6,*) hessian(1,1)
                hessian = 1.0_8/hessian
                !write(6,*) "inverse"
                !write(6,*) hessian(1,1)
                hessian = hessian*centre/(dble(fit_Npoints)-dble(fit_NOps))
                do k = 1,fit_NOps
                    hessian(k,k) = dsqrt(hessian(k,k))
                end do
                if(return_all) return
            end if
        end if
        uncert_in_progress = 0
        if(mpi_rank == 0) then
            do k=1,fit_NOps
                absparam = 0
                do j=1,fit_N2(k)
                    if(fit_codes(k,j) == 'im') then
                        absparam = 1
                    end if
                end do
                if(absparam == 1) then
                    input_copy = dabs(fit_init(k))
                else
                    input_copy = fit_init(k)
                end if
                if(dabs(input_copy) < 1000.0_8 .and. dabs(input_copy) > 0.001_8) then
                    if(dabs(input_copy) < 1000.0_8 .and. dabs(input_copy) >= 100.0_8) then
                        if(input_copy < 0.0_8) then
                            if(fit_uncertainties == 1) write(SaveTxt,'(F19.14,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(SaveTxt,'(F19.14)') input_copy
                            if(fit_uncertainties == 1) write(45,'(F19.14,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(45,'(F19.14)') input_copy
                        else
                            if(fit_uncertainties == 1) write(SaveTxt,'(F18.14,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(SaveTxt,'(F18.14)') input_copy
                            if(fit_uncertainties == 1) write(45,'(F18.14,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(45,'(F18.14)') input_copy
                        end if
                    else if(dabs(input_copy) < 100.0_8 .and. dabs(input_copy) >= 10.0_8) then
                        if(input_copy < 0.0_8) then
                            if(fit_uncertainties == 1) write(SaveTxt,'(F19.15,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(SaveTxt,'(F19.15)') input_copy
                            if(fit_uncertainties == 1) write(45,'(F19.15,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(45,'(F19.15)') input_copy
                        else
                            if(fit_uncertainties == 1) write(SaveTxt,'(F18.15,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(SaveTxt,'(F18.15)') input_copy
                            if(fit_uncertainties == 1) write(45,'(F18.15,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(45,'(F18.15)') input_copy
                        end if
                    else if(dabs(input_copy) < 10.0_8 .and. dabs(input_copy) >= 1.0_8) then
                        if(input_copy < 0.0_8) then
                            if(fit_uncertainties == 1) write(SaveTxt,'(F19.16,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(SaveTxt,'(F19.16)') input_copy
                            if(fit_uncertainties == 1) write(45,'(F19.16,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(45,'(F19.16)') input_copy
                        else
                            if(fit_uncertainties == 1) write(SaveTxt,'(F18.16,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(SaveTxt,'(F18.16)') input_copy
                            if(fit_uncertainties == 1) write(45,'(F18.16,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(45,'(F18.16)') input_copy
                        end if
                    else if(dabs(input_copy) < 1.0_8) then
                        if(input_copy < 0.0_8) then
                            if(fit_uncertainties == 1) write(SaveTxt,'(F19.16,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(SaveTxt,'(F19.16)') input_copy
                            if(fit_uncertainties == 1) write(45,'(F19.16,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(45,'(F19.16)') input_copy
                        else
                            if(fit_uncertainties == 1) write(SaveTxt,'(F18.16,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(SaveTxt,'(F18.16)') input_copy
                            if(fit_uncertainties == 1) write(45,'(F18.16,A6,F18.14)') input_copy,"  +/- ",hessian(k,k)
                            if(fit_uncertainties == 0) write(45,'(F18.16)') input_copy
                        end if
                    end if
                else
                    if(fit_uncertainties == 1) write(SaveTxt,'(E22.13E3,A5,E17.10E3)') input_copy," +/- ",hessian(k,k)
                    if(fit_uncertainties == 0) write(SaveTxt,'(E22.13E3)') input_copy
                    if(fit_uncertainties == 1) write(45,'(E22.13E3,A5,E17.10E3)') input_copy," +/- ",hessian(k,k)
                    if(fit_uncertainties == 0) write(45,'(E22.13E3)') input_copy
                end if
                call output_text(SaveTxt,.false.)
                do j=1,fit_N2(k)
                    str_copy = fit_codes(k,j)
                    call uppercase(str_copy)
                    write(SaveTxt,'(A2,A1,3I3)') str_copy," ",fit_nums(k,j,:)
                    call output_text(SaveTxt,.false.)
                    write(45,'(A2,A1,3I3)') str_copy," ",fit_nums(k,j,:)
                end do
                write(SaveTxt,'(A44)') "--------------------------------------------"
                call output_text(SaveTxt,.false.)
                write(45,'(A44)') "--------------------------------------------"
            end do
            if(fit_uncertainties == 1 .and. fit_NOps > 1) then
                write(SaveTxt,'(A44)') "---------- Parameter Correlations ----------"
                call output_text(SaveTxt,.false.)
                write(45,'(A44)') "---------- Parameter Correlations ----------"
                write(SaveTxt,'(A44)') "   If magnitude of correlation is > 0.8,    "
                call output_text(SaveTxt,.false.)
                write(45,'(A44)') "   If magnitude of correlation is > 0.8,    "
                write(SaveTxt,'(A44)') "   then a strong correllation is present.   "
                call output_text(SaveTxt,.false.)
                write(45,'(A44)') "   then a strong correllation is present.   "
                do j = 1,fit_NOps
                    do k = j,fit_NOps
                        if(j /= k) then
                            write(SaveTxt,'(2I3,F5.1)') j,k,hessian(k,j)
                            call output_text(SaveTxt,.false.)
                            write(45,'(2I3,F5.1)') j,k,hessian(k,j)
                        end if
                    end do
                end do
                write(SaveTxt,'(A44)') "--------------------------------------------"
                call output_text(SaveTxt,.false.)
                write(45,'(A44)') "--------------------------------------------"
            end if
            if(residual < 1000.0_8 .and. residual > 0.001_8) then
                if(residual < 1000.0_8 .and. residual >= 100.0_8) write(SaveTxt,'(A10,F18.14)') "Residual: ",residual
                if(residual < 100.0_8 .and. residual >= 10.0_8) write(SaveTxt,'(A10,F18.15)') "Residual: ",residual
                if(residual < 10.0_8 .and. residual >= 1.0_8) write(SaveTxt,'(A10,F18.16)') "Residual: ",residual
                if(residual < 1.0_8) write(SaveTxt,'(A10,F19.17)') "Residual: ",residual
                if(residual < 1000.0_8 .and. residual >= 100.0_8) write(45,'(A10,F18.14)') "Residual: ",residual
                if(residual < 100.0_8 .and. residual >= 10.0_8) write(45,'(A10,F18.15)') "Residual: ",residual
                if(residual < 10.0_8 .and. residual >= 1.0_8) write(45,'(A10,F18.16)') "Residual: ",residual
                if(residual < 1.0_8) write(45,'(A10,F19.17)') "Residual: ",residual
            else
                write(SaveTxt,'(A10,E26.17E3)') "Residual: ",residual
                write(45,'(A10,E26.17E3)') "Residual: ",residual
            end if
            call output_text(SaveTxt,.false.)
            if(initResidual-residual < 1000.0_8 .and. initResidual-residual > 0.001_8) then
                if(initResidual-residual < 1000.0_8 .and. initResidual-residual >= 100.0_8) write(SaveTxt,'(A21,F18.14)') "Residual reduced by: ",initResidual-residual
                if(initResidual-residual < 100.0_8 .and. initResidual-residual >= 10.0_8) write(SaveTxt,'(A21,F18.15)') "Residual reduced by: ",initResidual-residual
                if(initResidual-residual < 10.0_8 .and. initResidual-residual >= 1.0_8) write(SaveTxt,'(A21,F18.16)') "Residual reduced by: ",initResidual-residual
                if(initResidual-residual < 1.0_8) write(SaveTxt,'(A21,F19.17)') "Residual reduced by: ",initResidual-residual
                if(initResidual-residual < 1000.0_8 .and. initResidual-residual >= 100.0_8) write(45,'(A21,F18.14)') "Residual reduced by: ",initResidual-residual
                if(initResidual-residual < 100.0_8 .and. initResidual-residual >= 10.0_8) write(45,'(A21,F18.15)') "Residual reduced by: ",initResidual-residual
                if(initResidual-residual < 10.0_8 .and. initResidual-residual >= 1.0_8) write(45,'(A21,F18.16)') "Residual reduced by: ",initResidual-residual
                if(initResidual-residual < 1.0_8) write(45,'(A21,F19.17)') "Residual reduced by: ",initResidual-residual
            else
                write(SaveTxt,'(A21,E23.15E3)') "Residual reduced by: ",initResidual-residual
                write(45,'(A21,E23.15E3)') "Residual reduced by: ",initResidual-residual
            end if
            call output_text(SaveTxt,.false.)
            if((1-(residual/initResidual))*100 < 1000.0_8 .and. (1-(residual/initResidual))*100 > 0.001_8) then
                if((1-(residual/initResidual))*100 < 1000.0_8 .and. (1-(residual/initResidual))*100 >= 100.0_8) write(SaveTxt,'(A22,F18.14,A1)') "                  or: ",(1-(residual/initResidual))*100,"%"
                if((1-(residual/initResidual))*100 < 100.0_8 .and. (1-(residual/initResidual))*100 >= 10.0_8) write(SaveTxt,'(A22,F18.15,A1)') "                  or: ",(1-(residual/initResidual))*100,"%"
                if((1-(residual/initResidual))*100 < 10.0_8 .and. (1-(residual/initResidual))*100 >= 1.0_8) write(SaveTxt,'(A22,F18.16,A1)') "                  or: ",(1-(residual/initResidual))*100,"%"
                if((1-(residual/initResidual))*100 < 1.0_8) write(SaveTxt,'(A22,F19.17,A1)') "                  or: ",(1-(residual/initResidual))*100,"%"
                if((1-(residual/initResidual))*100 < 1000.0_8 .and. (1-(residual/initResidual))*100 >= 100.0_8) write(45,'(A22,F18.14,A1)') "                  or: ",(1-(residual/initResidual))*100,"%"
                if((1-(residual/initResidual))*100 < 100.0_8 .and. (1-(residual/initResidual))*100 >= 10.0_8) write(45,'(A22,F18.15,A1)') "                  or: ",(1-(residual/initResidual))*100,"%"
                if((1-(residual/initResidual))*100 < 10.0_8 .and. (1-(residual/initResidual))*100 >= 1.0_8) write(45,'(A22,F18.16,A1)') "                  or: ",(1-(residual/initResidual))*100,"%"
                if((1-(residual/initResidual))*100 < 1.0_8) write(45,'(A22,F19.17,A1)') "                  or: ",(1-(residual/initResidual))*100,"%"
            else
                write(SaveTxt,'(A20,E23.15E3,A2)') "                or: ",(1-(residual/initResidual))*100," %"
                write(45,'(A20,E23.15E3,A2)') "                or: ",(1-(residual/initResidual))*100," %"
            end if
            call output_text(SaveTxt,.false.)
            write(SaveTxt,'(A44)') "============================================"
            call output_text(SaveTxt,.false.)
            call output_text(SaveTxt,.true.)
            write(45,'(A44)') "============================================"
        end if
        close(45)
        deallocate(averages,moved_params,errors,hessian,correlation_steps,IPIV)
        if(allocated(epr_wave_exp)) deallocate(epr_wave_exp)
        if(allocated(epr_wave_params)) deallocate(epr_wave_params)
    end subroutine run_fit
    
    subroutine run_survey
        ! Controls the survey loop
        implicit none
        real(kind=8)::check,result
        integer::TotalLoopDim,percenter,j,k,bra,ket,comma,IOstatus,i,rename,d
        integer,allocatable::LoopDim(:),LoopBasis(:),LoopRemainder(:),LoopFactor(:)
        real(kind=8),allocatable::input(:)
        character(len=10000)::digit
        if(return_all) then
            !write(6,*) "CH"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CH"
        end if
        !external rename
        allocate(input(sur_NOps))
        check = 1.0_8
        do j=1,sur_NOps
            check = check*dble(sur_steps(j))
        end do
        if(check >= integer_limit) then
            call output_text("Scale of survey exceeds hardware limit",.false.)
            call output_text("Please reduce number of survey steps",.false.)
            call output_text("or complie with 64-bit integers",.false.)
            call control('kill ')
            return
        end if
        do j=1,sur_NOps
            do k = 1,sur_N2(j)
                if(sur_codes(j,k) == 'lw' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("LW in survey but not calculating EPR?",.false.)
                else if(sur_codes(j,k) == 'vo' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("VO in survey but not calculating EPR?",.false.)
                else if(sur_codes(j,k) == 'es' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("ES in survey but not calculating EPR?",.false.)
                else if(sur_codes(j,k) == 'is' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("IS in survey but not calculating EPR?",.false.)
                else if(sur_codes(j,k) == 'ss' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("SS in survey but not calculating EPR?",.false.)
                else if(sur_codes(j,k) == 'gs' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("GS in survey but not calculating EPR?",.false.)
                else if(sur_codes(j,k) == 'cs' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("CS in survey but not calculating EPR?",.false.)
                else if(sur_codes(j,k) == 'os' .and. scan(OperationModeB,'e',.false.) == 0) then
                    call output_text("OS in survey but not calculating EPR?",.false.)
                else if(sur_codes(j,k) == 'ti' .and. scan(OperationModeB,'s',.false.) == 0) then
                    call output_text("TI in survey but not calculating Susceptibility?",.false.)
                else if(sur_codes(j,k) == 'zj' .and. scan(OperationModeB,'s',.false.) == 0) then
                    call output_text("ZJ in survey but not calculating Susceptibility?",.false.)
                else if(sur_codes(j,k) == 'im' .and. scan(OperationModeB,'s',.false.) == 0) then
                    call output_text("IM in survey but not calculating Susceptibility?",.false.)
                else if(sur_codes(j,k) == 'dt' .and. scan(OperationModeB,'h',.false.) == 0) then
                    call output_text("DT in survey but not calculating Heat Capacity?",.false.)
                else if(sur_codes(j,k) == 'da' .and. scan(OperationModeB,'h',.false.) == 0) then
                    call output_text("DA in survey but not calculating Heat Capacity?",.false.)
                else
                    cycle
                end if
                call control('kill ')
                return
            end do
        end do
        if(wavelet_error) then
            allocate(epr_wave_exp(epr_numF,epr_numT,size(epr_fields),NINT(1.0_8+(LOG(size(epr_fields)*4.0_8)/LOG(2.0_8))*4)))
            allocate(epr_wave_params(epr_numF,epr_numT,3))
            do d = 1,epr_numF
                do k = 1,epr_numT
                    CALL WAVE_TRANS_OPT(epr_fields(:), epr_exp(d,k,:), epr_wave_params(d,k,:), epr_wave_exp(d,k,:,:))
                end do
            end do
        end if
        TotalLoopDim = 1
        do j=1,sur_NOps
            TotalLoopDim = TotalLoopDim*sur_steps(j)
        end do
        allocate(LoopDim(sur_NOps-1),LoopBasis(sur_NOps),LoopRemainder(sur_NOps-1),LoopFactor(sur_NOps-1))
        do j=1,(sur_NOps-1)
            LoopDim(j) = 1
            do k=(j+1),sur_NOps
                LoopDim(j) = LoopDim(j)*sur_steps(k)
            end do
        end do
        open(43,file=trim(WorkDir)//"/"//trim(JobTitle)//"_survey.res",status='unknown')
        percenter = 0
        do j=1,TotalLoopDim
            if(return_all) then
                !write(6,*) "CH2"
                return
            else
                !if(mpi_rank == 0) write(6,*) "*CH2"
            end if
            if(sur_NOps > 1) then
                call get_loop(j-1,LoopRemainder,LoopFactor,LoopDim,LoopBasis)
                do k=1,sur_NOps
                    input(k) = ((sur_final(k)-sur_init(k))/(sur_steps(k)-1))*LoopBasis(k) + sur_init(k)
                end do
            else
                input(1) = ((sur_final(1)-sur_init(1))/(sur_steps(1)-1))*(j-1) + sur_init(1)
            end if
            call funk(input,result)
            if(return_all) return
            if(sur_save == 1) then
                write(digit,*) j
                digit = adjustl(digit)
                if(scan(OperationModeB,'m',.false.) /= 0) then
                    IOstatus = rename(trim(WorkDir)//"/"//trim(JobTitle)//"_mag.res",trim(WorkDir)//"/"//trim(JobTitle)//"_mag.survey."//trim(digit))
                    if(IOstatus /= 0) then
                        SaveTxt = ""
                        write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                        call output_text(SaveTxt,.false.)
                        call output_text("Error saving survey for Magnetization",.false.)
                        call control('kill ')
                        return
                    end if
                end if
                if(scan(OperationModeB,'c',.false.) /= 0) then
                    IOstatus = rename(trim(WorkDir)//"/"//trim(JobTitle)//"_mce.res",trim(WorkDir)//"/"//trim(JobTitle)//"_mce.survey."//trim(digit))
                    if(IOstatus /= 0) then
                        SaveTxt = ""
                        write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                        call output_text(SaveTxt,.false.)
                        call output_text("Error saving survey for MCE",.false.)
                        call control('kill ')
                        return
                    end if
                end if
                if(scan(OperationModeB,'s',.false.) /= 0) then
                    IOstatus = rename(trim(WorkDir)//"/"//trim(JobTitle)//"_sus.res",trim(WorkDir)//"/"//trim(JobTitle)//"_sus.survey."//trim(digit))
                    if(IOstatus /= 0) then 
                        SaveTxt = ""
                        write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                        call output_text(SaveTxt,.false.)
                        call output_text("Error saving survey for Susceptibility",.false.)
                        call control('kill ')
                        return
                    end if
                end if
                if(scan(OperationModeB,'e',.false.) /= 0) then
                    IOstatus = rename(trim(WorkDir)//"/"//trim(JobTitle)//"_epr.res",trim(WorkDir)//"/"//trim(JobTitle)//"_epr.survey."//trim(digit))
                    if(IOstatus /= 0) then
                        SaveTxt = ""
                        write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                        call output_text(SaveTxt,.false.)
                        call output_text("Error saving survey for EPR",.false.)
                        call control('kill ')
                        return
                    end if
                end if
                if(scan(OperationModeB,'h',.false.) /= 0) then
                    IOstatus = rename(trim(WorkDir)//"/"//trim(JobTitle)//"_heat.res",trim(WorkDir)//"/"//trim(JobTitle)//"_heat.survey."//trim(digit))
                    if(IOstatus /= 0) then
                        SaveTxt = ""
                        write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                        call output_text(SaveTxt,.false.)
                        call output_text("Error saving survey for Heat Capacity",.false.)
                        call control('kill ')
                        return
                    end if
                end if
                if(scan(OperationModeB,'l',.false.) /= 0) then
                    IOstatus = rename(trim(WorkDir)//"/"//trim(JobTitle)//"_levels.res",trim(WorkDir)//"/"//trim(JobTitle)//"_levels.survey."//trim(digit))
                    if(IOstatus /= 0) then
                        SaveTxt = ""
                        write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                        call output_text(SaveTxt,.false.)
                        call output_text("Error saving survey for Energy Levels",.false.)
                        call control('kill ')
                        return
                    end if
                end if
                if(scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0) then
                    IOstatus = rename(trim(WorkDir)//"/"//trim(JobTitle)//"_G.res",trim(WorkDir)//"/"//trim(JobTitle)//"_G.survey."//trim(digit))
                    if(IOstatus /= 0) then
                        SaveTxt = ""
                        write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                        call output_text(SaveTxt,.false.)
                        call output_text("Error saving survey for G-Factors",.false.)
                        call control('kill ')
                        return
                    end if
                end if
            end if
            do k=1,sur_NOps
                if(high_prec) write(43,'(E24.15E3)',advance='no') input(k)
                if(.not. high_prec) write(43,'(E15.6E3)',advance='no') input(k)
            end do
            if(SurveyTarget(1:1) == 'r') then
                if(high_prec) write(43,'(E24.15E3)',advance='no') result
                if(.not. high_prec) write(43,'(E15.6E3)',advance='no') result
            else
                bra = scan(SurveyTarget,'(')
                ket = scan(SurveyTarget,')')
                comma = scan(SurveyTarget,',')
                read(SurveyTarget(bra+1:comma-1),*,IOSTAT=IOstatus) i
                if(IOstatus /= 0) then
                    SaveTxt = ""
                    write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                    call output_text(SaveTxt,.false.)
                    call output_text("Check: ****Survey block; survey target",.false.)
                    call control('kill ')
                    return
                end if
                read(SurveyTarget(comma+1:ket-1),*,IOSTAT=IOstatus) k
                if(IOstatus /= 0) then
                    SaveTxt = ""
                    write(SaveTxt,'(A9,I3)') "IO error ",IOstatus
                    call output_text(SaveTxt,.false.)
                    call output_text("Check: ****Survey block; survey target",.false.)
                    call control('kill ')
                    return
                end if
                if(SurveyTarget(1:1) == 'm') then
                    if(i <= mag_numB .and. i >= 1 .and. k <= mag_numT .and. k >= 1) then
                        if(high_prec) write(43,'(E24.15E3)',advance='no') mag_calc(k,i)
                        if(.not. high_prec) write(43,'(E15.6E3)',advance='no') mag_calc(k,i)
                    else
                        call output_text("Indices out of range for magnetization survey",.false.)
                        call output_text(trim(SurveyTarget),.false.)
                        SaveTxt = ""
                        write(SaveTxt,'(A19,I2)') "Num. Mag. Fields = ",mag_numB
                        call output_text(SaveTxt,.false.)
                        SaveTxt = ""
                        write(SaveTxt,'(A18,I2)') "Num. Mag. Temps = ",mag_numT
                        call output_text(SaveTxt,.false.)
                        call control('kill ')
                        return
                    end if
                else if(SurveyTarget(1:1) == 's') then
                    if(i <= sus_numB .and. i >= 1 .and. k <= sus_numT .and. k >= 1) then
                        if(high_prec) write(43,'(E24.15E3)',advance='no') sus_calc(k,i)
                        if(.not. high_prec) write(43,'(E15.6E3)',advance='no') sus_calc(k,i)
                    else
                        call output_text("Indices out of range for susceptibility survey",.false.)
                        call output_text(trim(SurveyTarget),.false.)
                        SaveTxt = ""
                        write(SaveTxt,'(A19,I2)') "Num. Sus. Fields = ",sus_numB
                        call output_text(SaveTxt,.false.)
                        SaveTxt = ""
                        write(SaveTxt,'(A18,I2)') "Num. Sus. Temps = ",sus_numT
                        call output_text(SaveTxt,.false.)
                        call control('kill ')
                        return
                    end if
                else if(SurveyTarget(1:1) == 'c') then
                    if(i <= mce_numB .and. i >= 1 .and. k <= mce_numT .and. k >= 1) then
                        if(high_prec) write(43,'(E24.15E3)',advance='no') mce_calc(k,i)
                        if(.not. high_prec) write(43,'(E15.6E3)',advance='no') mce_calc(k,i)
                    else
                        call output_text("Indices out of range for magnetocaloric survey",.false.)
                        call output_text(trim(SurveyTarget),.false.)
                        SaveTxt = ""
                        write(SaveTxt,'(A19,I2)') "Num. MCE Fields = ",mce_numB
                        call output_text(SaveTxt,.false.)
                        SaveTxt = ""
                        write(SaveTxt,'(A18,I2)') "Num. MCE Temps = ",mce_numT
                        call output_text(SaveTxt,.false.)
                        call control('kill ')
                        return
                    end if
                else if(SurveyTarget(1:1) == 'h') then
                    if(i <= heat_numB .and. i >= 1 .and. k <= heat_numT .and. k >= 1) then
                        if(high_prec) write(43,'(E24.15E3)',advance='no') heat_calc(k,i)
                        if(.not. high_prec) write(43,'(E15.6E3)',advance='no') heat_calc(k,i)
                    else
                        call output_text("Indices out of range for heat capacity survey",.false.)
                        call output_text(trim(SurveyTarget),.false.)
                        SaveTxt = ""
                        write(SaveTxt,'(A19,I2)') "Num. heat capacity Fields = ",heat_numB
                        call output_text(SaveTxt,.false.)
                        SaveTxt = ""
                        write(SaveTxt,'(A18,I2)') "Num. heat capacity Temps = ",heat_numT
                        call output_text(SaveTxt,.false.)
                        call control('kill ')
                        return
                    end if
                else
                    call output_text("Invalid survey target, please check ****Survey block",.false.)
                    call control('kill ')
                    return
                end if
            end if
            write(43,*)
#ifdef gui
            if(mpi_rank == 0) call send_progress(100*j/TotalLoopDim,ptr_to_C_code)
#else
            if(printPercent == 1 .and. 100*j/TotalLoopDim > percenter) then
                SaveTxt = ""
                write(SaveTxt,'(I3)') 100*j/TotalLoopDim
                call output_text(SaveTxt,.false.)
                percenter = 100*j/TotalLoopDim
            end if
#endif
        end do
        close(43)
        deallocate(input,LoopDim,LoopBasis,LoopRemainder,LoopFactor)
        if(allocated(epr_wave_exp)) deallocate(epr_wave_exp)
        if(allocated(epr_wave_params)) deallocate(epr_wave_params)
    end subroutine run_survey
    
    subroutine get_loop(i,LoopRemainder,LoopFactor,LoopDim,basisOut)
        implicit none
        integer::i,LoopRemainder(:),LoopFactor(:),LoopDim(:)
        integer,intent(out),dimension(:)::basisOut(:)
        integer::j,k
        if(return_all) then
            !write(6,*) "CI"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CI"
        end if
        if(sur_NOps == 1) then
            basisOut(1) = i-1
        else
            LoopRemainder(:) = i
            do j=1,(sur_NOps-1)
                if(j == 1) then
                    LoopFactor(j) = i/LoopDim(j)
                else
                    LoopFactor(j) = LoopRemainder(j-1)/LoopDim(j)
                end if
                do k=1,j
                    LoopRemainder(j) = LoopRemainder(j) - LoopFactor(k)*LoopDim(k)
                end do
            end do
            do j=1,sur_NOps
                if(j < sur_NOps) then
                    basisOut(j) = LoopFactor(j)
                else if(j == sur_NOps) then
                    basisOut(j) = LoopRemainder(j-1)
                end if
            end do
        end if
    end subroutine get_loop
    
    subroutine CORfunk(INPUT,result)
        implicit none
        real(kind=8),intent(in)::INPUT(:)
        real(kind=8),intent(out)::result
        real(kind=8)::A,B,C,D
        integer::i
        if(return_all) return
        result = 0.0_8
        if(.not. fit_star) then
            A = 0.5_8*(star_correlation(1,3) + star_correlation(4,3))/(star_correlation(1,1)**2)
            B = 0.5_8*((star_correlation(1,3) - A*(star_correlation(1,1)**2))/star_correlation(1,1) + (star_correlation(4,3) - A*(star_correlation(4,1)**2))/star_correlation(4,1))
            C = 0.5_8*(star_correlation(5,3) + star_correlation(8,3))/(star_correlation(5,2)**2)
            D = 0.5_8*((star_correlation(5,3) - C*(star_correlation(5,2)**2))/star_correlation(5,2) + (star_correlation(8,3) - C*(star_correlation(8,2)**2))/star_correlation(8,2))
            do i = 1,16
                result = result + ((A*(star_correlation(i,1)**2) + B*star_correlation(i,1) + C*(star_correlation(i,2)**2) + D*star_correlation(i,2) + INPUT(1)*star_correlation(i,1)*star_correlation(i,2)) - star_correlation(i,3))**2
            end do
            result = dlog10(result)
            !write(6,'(A2,6E14.5E2)') "c ",A,B,C,D,INPUT(1),result
        else
            do i = 1,16
                result = result + ((INPUT(1)*(star_correlation(i,1)**2) + INPUT(2)*star_correlation(i,1) + INPUT(3)*(star_correlation(i,2)**2) + INPUT(4)*star_correlation(i,2) + INPUT(5)*star_correlation(i,1)*star_correlation(i,2)) - star_correlation(i,3))**2
            end do
            result = dlog10(result)
            !write(6,'(A2,6E14.5E2)') "f ",INPUT(1:5),result
        end if
    end subroutine CORfunk
    
    subroutine funk(INPUT,result)
        ! This routine is called by the fitting or surveying routines and manages the property calculations.
        implicit none
        real(kind=8),intent(in)::INPUT(:)
        real(kind=8),intent(out)::result
        real(kind=8)::input_copy,local_sus_tip,local_sus_zJ,local_ImpQuant,local_lattice(2)
        integer::i,j,absparam,k,temp_int,NOps,NPOps,N2(100),local_done_inter,local_done_ex
        integer,allocatable::nums(:,:,:)
        character(len=2),allocatable::codes(:,:)
        character(len=2)::str_copy
        real(kind=8),allocatable::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:),local_Gfactor(:,:),local_Jss(:,:,:),local_dss(:,:,:),local_CFP_rot(:,:),local_EX_rot(:,:,:),local_linewidth(:,:),local_voigt(:),local_mosaic(:),local_strain_lamda(:,:),local_strain_EXmat(:,:,:,:),local_strain_Jss(:,:,:),local_strain_dss(:,:,:),local_strain_Gfactor(:,:),local_strain_A2(:,:),local_strain_A4(:,:),local_strain_A6(:,:),local_strain_orbred(:)
        if(return_all) then
            !write(6,*) "CJ"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CJ"
        end if
        FEvals = FEvals + 1
        allocate(local_lamda(N,6),local_orbred(N),local_EXmat(3,3,N,N),local_Gmat(3,3,N),local_A2(N,-2:2),local_A4(N,-4:4),local_A6(N,-6:6),local_Gfactor(3,N),local_Jss(N,N,3),local_dss(N,N,3),local_CFP_rot(N,3),local_EX_rot(N,N,3),local_linewidth(epr_numF,3),local_voigt(epr_numF),local_mosaic(epr_numF),local_strain_lamda(N,6),local_strain_EXmat(3,3,N,N),local_strain_Jss(N,N,3),local_strain_dss(N,N,3),local_strain_Gfactor(3,N),local_strain_A2(N,-2:2),local_strain_A4(N,-4:4),local_strain_A6(N,-6:6),local_strain_orbred(N))
        if(OperationMode(1:3) == 'fit') then
            NOps = fit_NOps
            NPOps = fit_NPOps
            allocate(codes(NOps,NPOps),nums(NOps,NPOps,3))
            codes = fit_codes
            nums = fit_nums
            N2 = fit_N2
        else if(OperationMode(1:3) == 'sur') then
            NOps = sur_NOps
            NPOps = sur_NPOps
            allocate(codes(NOps,NPOps),nums(NOps,NPOps,3))
            codes = sur_codes
            nums = sur_nums
            N2 = sur_N2
        end if
        local_lamda = lamda
        local_orbred = orbred
        local_A2 = A2
        local_A4 = A4
        local_A6 = A6
        local_Gfactor = Gfactor
        local_EXmat = EXmat
        local_Jss = Jss
        local_dss = dss
        local_CFP_rot = CFP_rot
        local_EX_rot = EX_rot
        local_sus_tip = sus_tip
        local_sus_zJ = sus_zJ
        local_ImpQuant = ImpQuant
        local_lattice = heat_lattice
        if(scan(OperationModeB,'e',.false.) /= 0) then
            local_linewidth = epr_linewidth
            local_voigt = epr_voigt
            local_mosaic = epr_mosaic
            local_strain_lamda = epr_strain_lamda
            local_strain_EXmat = epr_strain_EXmat
            local_strain_Jss = epr_strain_Jss
            local_strain_dss = epr_strain_dss
            local_strain_Gfactor = epr_strain_Gfactor
            local_strain_A2 = epr_strain_A2
            local_strain_A4 = epr_strain_A4
            local_strain_A6 = epr_strain_A6
            local_strain_orbred = epr_strain_orbred
        end if
        local_done_inter = 0
        local_done_ex = 0
        do i=1,NOps
            do j=1,N2(i)
                if(codes(i,j) == 'ex') then
                    local_done_ex = 1
                    if(local_done_inter == 1) then
                        call output_text("Cannot fit/survey Exchange as well as Interaction",.false.)
                        call control('kill ')
                        return
                    end if
                    if(nums(i,j,3) > 9 .or. nums(i,j,3) < 1) then
                        call output_text("Please check Exchange components in the ****Fit/Survey block",.false.)
                        call output_text("EX SiteA SiteB N",.false.)
                        call output_text("N = 1 = Jx",.false.)
                        call output_text("N = 2 = Jy",.false.)
                        call output_text("N = 3 = Jz",.false.)
                        call output_text("N = 4 = Jx = Jy = Jz",.false.)
                        call output_text("N = 5 = dx",.false.)
                        call output_text("N = 6 = dy",.false.)
                        call output_text("N = 7 = dz",.false.)
                        call output_text("N = 8 = JD = (3/2)*Jz",.false.)
                        call output_text("N = 9 = JE = (1/2)*(Jx-Jy)",.false.)
                        call control('kill ')
                        return
                    else
                        if(nums(i,j,3) <= 4) then
                            if(nums(i,j,3) == 4) then
                                if(nums(i,j,1) >= nums(i,j,2)) then
                                    temp_int = nums(i,j,1)
                                    nums(i,j,1) = nums(i,j,2)
                                    nums(i,j,2) = temp_int
                                end if
                                local_EXmat(1,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                                local_EXmat(2,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                                local_EXmat(3,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                                local_Jss(nums(i,j,1),nums(i,j,2),:) = INPUT(i)
                            else
                                if(nums(i,j,1) >= nums(i,j,2)) then
                                    temp_int = nums(i,j,1)
                                    nums(i,j,1) = nums(i,j,2)
                                    nums(i,j,2) = temp_int
                                end if
                                local_EXmat(nums(i,j,3),nums(i,j,3),nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            end if
                        else if(nums(i,j,3) > 4 .and. nums(i,j,3) <= 7) then
                            if(nums(i,j,1) >= nums(i,j,2)) then
                                temp_int = nums(i,j,1)
                                nums(i,j,1) = nums(i,j,2)
                                nums(i,j,2) = temp_int
                                if(nums(i,j,3)-4 == 3) local_EXmat(1,2,nums(i,j,1),nums(i,j,2)) = -INPUT(i)
                                if(nums(i,j,3)-4 == 3) local_EXmat(2,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                                if(nums(i,j,3)-4 == 2) local_EXmat(1,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                                if(nums(i,j,3)-4 == 2) local_EXmat(3,1,nums(i,j,1),nums(i,j,2)) = -INPUT(i)
                                if(nums(i,j,3)-4 == 1) local_EXmat(2,3,nums(i,j,1),nums(i,j,2)) = -INPUT(i)
                                if(nums(i,j,3)-4 == 1) local_EXmat(3,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            else
                                if(nums(i,j,3)-4 == 3) local_EXmat(1,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                                if(nums(i,j,3)-4 == 3) local_EXmat(2,1,nums(i,j,1),nums(i,j,2)) = -INPUT(i)
                                if(nums(i,j,3)-4 == 2) local_EXmat(1,3,nums(i,j,1),nums(i,j,2)) = -INPUT(i)
                                if(nums(i,j,3)-4 == 2) local_EXmat(3,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                                if(nums(i,j,3)-4 == 1) local_EXmat(2,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                                if(nums(i,j,3)-4 == 1) local_EXmat(3,2,nums(i,j,1),nums(i,j,2)) = -INPUT(i)
                            end if
                        else if(nums(i,j,3) == 8) then
                            !JD = (3/2)*Jz
                            !Jz = (2/3)*JD
                            local_EXmat(3,3,nums(i,j,1),nums(i,j,2)) = (2.0_8/3.0_8)*INPUT(i)
                        else if(nums(i,j,3) == 9) then
                            !JE = (1/2)*(Jx-Jy)
                            !Set Jy = 0, then Jx = 2*JE
                            local_EXmat(2,2,nums(i,j,1),nums(i,j,2)) = 0.0_8
                            local_EXmat(1,1,nums(i,j,1),nums(i,j,2)) = 2.0_8*INPUT(i)
                        end if
                    end if
                else if(codes(i,j) == 'in') then
                    local_done_inter = 1
                    if(local_done_ex == 1) then
                        call output_text("Cannot fit/survey Interaction as well as Exchange",.false.)
                        call control('kill ')
                        return
                    end if
                    if(nums(i,j,3) > 9 .or. nums(i,j,3) < 1) then
                        call output_text("Please check Interaction components in the ****Fit/Survey block",.false.)
                        call output_text("IN SiteA SiteB N",.false.)
                        call output_text("N = 1 = Jxx",.false.)
                        call output_text("N = 2 = Jxy",.false.)
                        call output_text("N = 3 = Jxz",.false.)
                        call output_text("N = 4 = Jyx",.false.)
                        call output_text("N = 5 = Jyy",.false.)
                        call output_text("N = 6 = Jyz",.false.)
                        call output_text("N = 7 = Jzx",.false.)
                        call output_text("N = 8 = Jzy",.false.)
                        call output_text("N = 9 = Jzz",.false.)
                        call control('kill ')
                        return
                    else
                        if(nums(i,j,1) >= nums(i,j,2)) then
                            temp_int = nums(i,j,1)
                            nums(i,j,1) = nums(i,j,2)
                            nums(i,j,2) = temp_int
                            if(nums(i,j,3) == 1) local_EXmat(1,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 2) local_EXmat(2,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 3) local_EXmat(3,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 4) local_EXmat(1,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 5) local_EXmat(2,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 6) local_EXmat(3,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 7) local_EXmat(1,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 8) local_EXmat(2,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 9) local_EXmat(3,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        else
                            if(nums(i,j,3) == 1) local_EXmat(1,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 2) local_EXmat(1,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 3) local_EXmat(1,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 4) local_EXmat(2,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 5) local_EXmat(2,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 6) local_EXmat(2,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 7) local_EXmat(3,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 8) local_EXmat(3,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                            if(nums(i,j,3) == 9) local_EXmat(3,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        end if

                    end if
                else if(codes(i,j) == 'so') then
                    if(nums(i,j,2) > 6 .or. nums(i,j,2) < 1) then
                        call output_text("Please check SO coupling in the ****Fit/Survey block",.false.)
                        call output_text("SO Site Order",.false.)
                        call control('kill ')
                        return
                    else
                        local_lamda(nums(i,j,1),nums(i,j,2)) = INPUT(i)
                    end if
                else if(codes(i,j) == 'gf') then
                    if(nums(i,j,2) > 4 .or. nums(i,j,2) < 1) then
                        call output_text("Please check G-factors in the ****Fit/Survey block",.false.)
                        call output_text("GF Site N",.false.)
                        call output_text("N = 1 = Gx",.false.)
                        call output_text("N = 2 = Gy",.false.)
                        call output_text("N = 3 = Gz",.false.)
                        call output_text("N = 4 = Gx = Gy = Gz",.false.)
                        call control('kill ')
                        return
                    else if(INPUT(i) < 0.0_8 .and. OperationMode(1:3) == 'sur') then
                        call output_text("G-Factors have gone negative. Best that we stop here...",.false.)
                        call control('kill ')
                        return
                    else
                        if(nums(i,j,2) == 4) then
                            local_Gfactor(:,nums(i,j,1)) = INPUT(i)
                        else
                            local_Gfactor(nums(i,j,2),nums(i,j,1)) = INPUT(i)
                        end if
                    end if
                else if(codes(i,j) == 'cf') then
                    if(nums(i,j,2) == 2) then
                        if(nums(i,j,3) > 2 .or. nums(i,j,3) < -2) then
                            call output_text("Please check CF in the ****Fit/Survey block",.false.)
                            call output_text("CF Site Rank Order",.false.)
                            call control('kill ')
                            return
                        end if
                        local_A2(nums(i,j,1),nums(i,j,3)) = INPUT(i)
                        if(done_ion == 1 .and. NoOEF == 0) local_A2(nums(i,j,1),nums(i,j,3)) = local_A2(nums(i,j,1),nums(i,j,3))*SF2(nums(i,j,1))
                    else if(nums(i,j,2) == 4) then
                        if(nums(i,j,3) > 4 .or. nums(i,j,3) < -4) then
                            call output_text("Please check CF in the ****Fit/Survey block",.false.)
                            call output_text("CF Site Rank Order",.false.)
                            call control('kill ')
                            return
                        end if
                        local_A4(nums(i,j,1),nums(i,j,3)) = INPUT(i)
                        if(done_ion == 1 .and. NoOEF == 0) local_A4(nums(i,j,1),nums(i,j,3)) = local_A4(nums(i,j,1),nums(i,j,3))*SF4(nums(i,j,1))
                    else if(nums(i,j,2) == 6) then
                        if(nums(i,j,3) > 6 .or. nums(i,j,3) < -6) then
                            call output_text("Please check CF in the ****Fit/Survey block",.false.)
                            call output_text("CF Site Rank Order",.false.)
                            call control('kill ')
                            return
                        end if
                        local_A6(nums(i,j,1),nums(i,j,3)) = INPUT(i)
                        if(done_ion == 1 .and. NoOEF == 0) local_A6(nums(i,j,1),nums(i,j,3)) = local_A6(nums(i,j,1),nums(i,j,3))*SF6(nums(i,j,1))
                    else
                        call output_text("Crystal Field order incorrect, please check ****Fit/Survey block",.false.)
                        call control('kill ')
                        return
                    end if
                else if(codes(i,j) == 'or') then
                    local_orbred(nums(i,j,1)) = INPUT(i)
                else if(codes(i,j) == 'es') then
                    if(nums(i,j,3) > 7 .or. nums(i,j,3) < 1) then
                        call output_text("Please check Exchange strain components in the ****Fit/Survey block",.false.)
                        call output_text("ES SiteA SiteB N",.false.)
                        call output_text("N = 1 = Jx",.false.)
                        call output_text("N = 2 = Jy",.false.)
                        call output_text("N = 3 = Jz",.false.)
                        call output_text("N = 4 = Jx = Jy = Jz",.false.)
                        call output_text("N = 5 = dx",.false.)
                        call output_text("N = 6 = dy",.false.)
                        call output_text("N = 7 = dz",.false.)
                        call control('kill ')
                        return
                    else
                        if(nums(i,j,3) <= 4) then
                            if(nums(i,j,3) == 4) then
                                if(nums(i,j,1) >= nums(i,j,2)) then
                                    temp_int = nums(i,j,1)
                                    nums(i,j,1) = nums(i,j,2)
                                    nums(i,j,2) = temp_int
                                end if
                                local_strain_Jss(nums(i,j,1),nums(i,j,2),1) = INPUT(i)
                                local_strain_Jss(nums(i,j,1),nums(i,j,2),2) = INPUT(i)
                                local_strain_Jss(nums(i,j,1),nums(i,j,2),3) = INPUT(i)
                                epr_iso_ex_strain(nums(i,j,1),nums(i,j,2)) = 1
                            else
                                if(nums(i,j,1) >= nums(i,j,2)) then
                                    temp_int = nums(i,j,1)
                                    nums(i,j,1) = nums(i,j,2)
                                    nums(i,j,2) = temp_int
                                end if
                                local_strain_Jss(nums(i,j,1),nums(i,j,2),nums(i,j,3)) = INPUT(i)
                                epr_iso_ex_strain(nums(i,j,1),nums(i,j,2)) = 0
                            end if
                        else if(nums(i,j,3) > 4 .and. nums(i,j,3) <= 7) then
                            if(nums(i,j,1) >= nums(i,j,2)) then
                                temp_int = nums(i,j,1)
                                nums(i,j,1) = nums(i,j,2)
                                nums(i,j,2) = temp_int
                                local_strain_dss(nums(i,j,1),nums(i,j,2),nums(i,j,3)-4) = INPUT(i)
                                epr_iso_ex_strain(nums(i,j,1),nums(i,j,2)) = 0
                            else
                                local_strain_dss(nums(i,j,1),nums(i,j,2),nums(i,j,3)-4) = INPUT(i)
                                epr_iso_ex_strain(nums(i,j,1),nums(i,j,2)) = 0
                            end if
                        end if
                    end if
                else if(codes(i,j) == 'is') then
                    if(nums(i,j,3) > 9 .or. nums(i,j,3) < 1) then
                        call output_text("Please check Interaction strain components in the ****Fit/Survey block",.false.)
                        call output_text("IS SiteA SiteB N",.false.)
                        call output_text("N = 1 = Jxx",.false.)
                        call output_text("N = 2 = Jxy",.false.)
                        call output_text("N = 3 = Jxz",.false.)
                        call output_text("N = 4 = Jyx",.false.)
                        call output_text("N = 5 = Jyy",.false.)
                        call output_text("N = 6 = Jyz",.false.)
                        call output_text("N = 7 = Jzx",.false.)
                        call output_text("N = 8 = Jzy",.false.)
                        call output_text("N = 9 = Jzz",.false.)
                        call control('kill ')
                        return
                    else
                        if(nums(i,j,3) == 1) local_strain_EXmat(1,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        if(nums(i,j,3) == 2) local_strain_EXmat(1,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        if(nums(i,j,3) == 3) local_strain_EXmat(1,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        if(nums(i,j,3) == 4) local_strain_EXmat(2,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        if(nums(i,j,3) == 5) local_strain_EXmat(2,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        if(nums(i,j,3) == 6) local_strain_EXmat(2,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        if(nums(i,j,3) == 7) local_strain_EXmat(3,1,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        if(nums(i,j,3) == 8) local_strain_EXmat(3,2,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                        if(nums(i,j,3) == 9) local_strain_EXmat(3,3,nums(i,j,1),nums(i,j,2)) = INPUT(i)
                    end if
                else if(codes(i,j) == 'ss') then
                    if(nums(i,j,2) > 6 .or. nums(i,j,2) < 1) then
                        call output_text("Please check SO strain in the ****Fit/Survey block",.false.)
                        call output_text("SS Site Order",.false.)
                        call control('kill ')
                        return
                    else
                        local_strain_lamda(nums(i,j,1),nums(i,j,2)) = INPUT(i)
                    end if
                else if(codes(i,j) == 'gs') then
                    if(nums(i,j,2) > 4 .or. nums(i,j,2) < 1) then
                        call output_text("Please check G-factor strain in the ****Fit/Survey block",.false.)
                        call output_text("GS Site N",.false.)
                        call output_text("N = 1 = Gx",.false.)
                        call output_text("N = 2 = Gy",.false.)
                        call output_text("N = 3 = Gz",.false.)
                        call output_text("N = 4 = Gx = Gy = Gz",.false.)
                        call control('kill ')
                        return
                    else
                        if(nums(i,j,2) == 4) then
                            local_strain_Gfactor(:,nums(i,j,1)) = INPUT(i)
                            epr_iso_G_strain(nums(i,j,1)) = 1
                        else
                            local_strain_Gfactor(nums(i,j,2),nums(i,j,1)) = INPUT(i)
                            epr_iso_G_strain(nums(i,j,1)) = 0
                        end if
                    end if
                else if(codes(i,j) == 'cs') then
                    if(nums(i,j,2) == 2) then
                        if(nums(i,j,3) > 2 .or. nums(i,j,3) < -2) then
                            call output_text("Please check CF strain in the ****Fit/Survey block",.false.)
                            call output_text("CS Site Rank Order",.false.)
                            call control('kill ')
                            return
                        end if
                        local_strain_A2(nums(i,j,1),nums(i,j,3)) = INPUT(i)
                        if(done_ion == 1 .and. NoOEF == 0) local_strain_A2(nums(i,j,1),nums(i,j,3)) = local_strain_A2(nums(i,j,1),nums(i,j,3))*SF2(nums(i,j,1))
                    else if(nums(i,j,2) == 4) then
                        if(nums(i,j,3) > 4 .or. nums(i,j,3) < -4) then
                            call output_text("Please check CF strain in the ****Fit/Survey block",.false.)
                            call output_text("CS Site Rank Order",.false.)
                            call control('kill ')
                            return
                        end if
                        local_strain_A4(nums(i,j,1),nums(i,j,3)) = INPUT(i)
                        if(done_ion == 1 .and. NoOEF == 0) local_strain_A4(nums(i,j,1),nums(i,j,3)) = local_strain_A4(nums(i,j,1),nums(i,j,3))*SF4(nums(i,j,1))
                    else if(nums(i,j,2) == 6) then
                        if(nums(i,j,3) > 6 .or. nums(i,j,3) < -6) then
                            call output_text("Please check CF strain in the ****Fit/Survey block",.false.)
                            call output_text("CS Site Rank Order",.false.)
                            call control('kill ')
                            return
                        end if
                        local_strain_A6(nums(i,j,1),nums(i,j,3)) = INPUT(i)
                        if(done_ion == 1 .and. NoOEF == 0) local_strain_A6(nums(i,j,1),nums(i,j,3)) = local_strain_A6(nums(i,j,1),nums(i,j,3))*SF6(nums(i,j,1))
                    else
                        call output_text("Crystal Field strain order incorrect, please check ****Fit/Survey block",.false.)
                        call control('kill ')
                        return
                    end if
                else if(codes(i,j) == 'os') then
                    local_strain_orbred(nums(i,j,1)) = INPUT(i)
                else if(codes(i,j) == 'lw') then
                    if(nums(i,j,1) > epr_numF .or. nums(i,j,1) < 0 .or. nums(i,j,2) < 1 .or. nums(i,j,2) > 4) then
                        call output_text("EPR Linewidth incorrect, please check ****Fit/Survey block",.false.)
                        call control('kill ')
                        return
                    end if
                    if(nums(i,j,2) == 4) then
                        if(nums(i,j,1) > 0) local_linewidth(nums(i,j,1),:) = dabs(INPUT(i))
                        if(nums(i,j,1) == 0) local_linewidth = dabs(INPUT(i))
                    else
                        if(nums(i,j,1) > 0) local_linewidth(nums(i,j,1),nums(i,j,2)) = dabs(INPUT(i))
                        if(nums(i,j,1) == 0) local_linewidth(:,nums(i,j,2)) = dabs(INPUT(i))
                    end if
                else if(codes(i,j) == 'vo') then
                    if(nums(i,j,1) > epr_numF .or. nums(i,j,1) < 0) then
                        call output_text("EPR Voigt incorrect, please check ****Fit/Survey block",.false.)
                        call control('kill ')
                        return
                    end if
                    if(nums(i,j,1) > 0) local_voigt(nums(i,j,1)) = dabs(INPUT(i))
                    if(nums(i,j,1) == 0) local_voigt = dabs(INPUT(i))
                    if((dabs(INPUT(i)) < 0.0_8 .or. dabs(INPUT(i)) > 1.0_8) .and. OperationMode(1:3) == 'sur') then
                        call output_text("EPR Voigt must be > 0 and < 1",.false.)
                        call control('kill ')
                        return
                    end if
                else if(codes(i,j) == 'mo') then
                    if(nums(i,j,1) > epr_numF .or. nums(i,j,1) < 0) then
                        call output_text("EPR Mosaic incorrect, please check ****Fit/Survey block",.false.)
                        call control('kill ')
                        return
                    end if
                    if(nums(i,j,1) > 0) local_mosaic(nums(i,j,1)) = dabs(INPUT(i))
                    if(nums(i,j,1) == 0) local_mosaic = dabs(INPUT(i))
                else if(codes(i,j) == 'ti') then
                    local_sus_tip = INPUT(i)
                else if(codes(i,j) == 'dt') then
                    local_lattice(1) = dabs(INPUT(i))
                else if(codes(i,j) == 'da') then
                    local_lattice(2) = dabs(INPUT(i))
                else if(codes(i,j) == 'zj') then
                    local_sus_zJ = INPUT(i)
                else if(codes(i,j) == 'im') then
                    local_ImpQuant = dabs(INPUT(i))
                else if(codes(i,j) == 'rc') then
                    if(nums(i,j,2) > 3 .or. nums(i,j,2) < 1) then
                        call output_text("Please check RC in the ****Fit/Survey block",.false.)
                        call output_text("RC Site N",.false.)
                        call output_text("N = 1 = alpha",.false.)
                        call output_text("N = 2 = beta",.false.)
                        call output_text("N = 3 = gamma",.false.)
                        call control('kill ')
                        return
                    end if
                    do_rotate(nums(i,j,1)) = 1
                    local_CFP_rot(nums(i,j,1),nums(i,j,2)) = INPUT(i)
                else if(codes(i,j) == 're') then
                    if(nums(i,j,2) > 3 .or. nums(i,j,2) < 1) then
                        call output_text("Please check RE in the ****Fit/Survey block",.false.)
                        call output_text("RE SiteA SiteB N",.false.)
                        call output_text("N = 1 = alpha",.false.)
                        call output_text("N = 2 = beta",.false.)
                        call output_text("N = 3 = gamma",.false.)
                        call control('kill ')
                        return
                    end if
                    do_exrotate(nums(i,j,1),nums(i,j,2)) = 1
                    local_EX_rot(nums(i,j,1),nums(i,j,2),nums(i,j,3)) = INPUT(i)
                else
                    call output_text("Not a valid variable for fitting; check ****Fit/Survey block",.false.)
                    call output_text(trim(codes(i,j)),.false.)
                    call control('kill ')
                    return
                end if
            end do
        end do
        local_Gmat = 0.0_8
        do k = 1,N
            local_Gmat(1,1,k) = local_Gfactor(1,k)
            local_Gmat(2,2,k) = local_Gfactor(2,k)
            local_Gmat(3,3,k) = local_Gfactor(3,k)
        end do
        do k = 1,N
            if(force_cubic(k) == 1) then
                local_A4(k,4) = 5.0_8*local_A4(k,0)
                local_A6(k,4) = -21.0_8*local_A6(k,0)
                local_strain_A4(k,4) = 5.0_8*local_strain_A4(k,0)
                local_strain_A6(k,4) = -21.0_8*local_strain_A6(k,0)
            end if
        end do
        do k = 1,N
            if(D_not_B20(k) == 1) then
                local_A2(k,0) = local_A2(k,0)/3.0_8
                local_strain_A2(k,0) = local_strain_A2(k,0)/3.0_8
            end if
            if(do_rotate(k) == 1) call rotate_CFP(local_CFP_rot(k,1),local_CFP_rot(k,2),local_CFP_rot(k,3),local_A2(k,:),local_A4(k,:),local_A6(k,:))
            if(do_rotate(k) == 1) call rotate_mat(local_CFP_rot(k,1),local_CFP_rot(k,2),local_CFP_rot(k,3),local_Gmat(:,:,k))
            do j = 1,N
                if(do_exrotate(k,j) == 1) call rotate_mat(local_EX_rot(k,j,1),local_EX_rot(k,j,2),local_EX_rot(k,j,3),local_EXmat(:,:,k,j))
            end do
        end do
        local_linewidth = local_linewidth*(1.0D9)*(6.62606957D-34)  !linewidth input is in GHz
        local_mosaic = local_mosaic*pie/180.0_8 !mosaic input is in degrees
        if(approx == 0) then
            if(scan(OperationModeB,'m',.false.) /= 0) call calc_mag(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_ImpQuant)
            if(scan(OperationModeB,'c',.false.) /= 0) call calc_mce(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
            if(scan(OperationModeB,'s',.false.) /= 0) call calc_sus(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_sus_tip,local_sus_zJ,local_ImpQuant)
            if(scan(OperationModeB,'t',.false.) /= 0) call calc_tensor(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
            if(scan(OperationModeB,'e',.false.) /= 0) then
                if(approx == 0 .and. epr_do_subspace == 0) call calc_epr(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_linewidth,local_voigt,local_mosaic,local_strain_lamda,local_strain_orbred,local_strain_EXmat,local_strain_Jss,local_strain_dss,local_strain_Gfactor,local_strain_A2,local_strain_A4,local_strain_A6,local_CFP_rot,local_EX_rot)
                if(approx == 0 .and. epr_do_subspace == 1) then
                    call pert_prep(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,epr_pert_vecs,epr_pert_vals)
                    call pert_epr(epr_subdim,epr_pert_vecs,epr_pert_vals,local_orbred,local_EXmat,local_Gmat,local_linewidth,local_voigt,local_mosaic,local_strain_lamda,local_strain_orbred,local_strain_EXmat,local_strain_Jss,local_strain_dss,local_strain_Gfactor,local_strain_A2,local_strain_A4,local_strain_A6,local_CFP_rot,local_EX_rot)
                end if
            end if
            if(scan(OperationModeB,'h',.false.) /= 0) call calc_heat_capacity(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_lattice,local_ImpQuant)
            !if(scan(OperationModeB,'i',.false.) /= 0) call calc_ins(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
            if(scan(OperationModeB,'l',.false.) /= 0 .or. scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0 .or. scan(OperationModeB,'x',.false.) /= 0) call calc_states(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
        else
            call calc_coupled_props(local_Jss,local_Gfactor,local_sus_tip,local_sus_zJ,local_ImpQuant,local_lattice)
        end if
        if(return_all) return
        absparam = 0
        if(NoPrint == 0 .and. uncert_in_progress == 0 .and. OperationMode(1:3) /= 'sur') then
            call output_text(SaveTxt,.true.)
            call output_text("============================================",.false.)
            SaveTxt = ""
            write(SaveTxt,'(A11,I11)') "Iteration: ",FEvals
            call output_text(SaveTxt,.false.)
            call output_text("--------------------------------------------",.false.)
            do i=1,fit_NOps
                absparam = 0
                do j=1,fit_N2(i)
                    if(codes(i,j) == 'im' .or. codes(i,j) == 'lw' .or. codes(i,j) == 'vo' .or. codes(i,j) == 'mo' .or. codes(i,j) == 'dt' .or. codes(i,j) == 'da') then
                        absparam = 1
                    end if
                end do
                if(absparam == 1) then
                    input_copy = dabs(INPUT(i))
                else
                    input_copy = INPUT(i)
                end if
                if(dabs(input_copy) < 1000.0_8 .and. dabs(input_copy) > 0.001_8) then
                    if(dabs(input_copy) < 1000.0_8 .and. dabs(input_copy) >= 100.0_8) then
                        if(input_copy < 0.0_8) then
                            write(SaveTxt,'(F19.14)') input_copy
                        else
                            write(SaveTxt,'(F18.14)') input_copy
                        end if
                    else if(dabs(input_copy) < 100.0_8 .and. dabs(input_copy) >= 10.0_8) then
                        if(input_copy < 0.0_8) then
                            write(SaveTxt,'(F19.15)') input_copy
                        else
                            write(SaveTxt,'(F18.15)') input_copy
                        end if
                    else if(dabs(input_copy) < 10.0_8 .and. dabs(input_copy) >= 1.0_8) then
                        if(input_copy < 0.0_8) then
                            write(SaveTxt,'(F19.16)') input_copy
                        else
                            write(SaveTxt,'(F18.16)') input_copy
                        end if
                    else if(dabs(input_copy) < 1.0_8) then
                        if(input_copy < 0.0_8) then
                            write(SaveTxt,'(F19.16)') input_copy
                        else
                            write(SaveTxt,'(F18.16)') input_copy
                        end if
                    end if
                else
                    write(SaveTxt,'(E22.13E3)') input_copy
                end if
                call output_text(SaveTxt,.false.)
                do j=1,N2(i)
                    str_copy = codes(i,j)
                    call uppercase(str_copy)
                    SaveTxt = ""
                    if(fit_codes(i,j) == 'ex' .or. fit_codes(i,j) == 'in' .or. fit_codes(i,j) == 'cf' .or. fit_codes(i,j) == 're' .or. fit_codes(i,j) == 'es' .or. fit_codes(i,j) == 'is' .or. fit_codes(i,j) == 'cs') then
                        write(SaveTxt,'(A2,A1,3I3)') str_copy," ",fit_nums(i,j,:)
                    else if(fit_codes(i,j) == 'so' .or. fit_codes(i,j) == 'gf' .or. fit_codes(i,j) == 'rc' .or. fit_codes(i,j) == 'lw' .or. fit_codes(i,j) == 'ss' .or. fit_codes(i,j) == 'gs') then
                        write(SaveTxt,'(A2,A1,2I3)') str_copy," ",fit_nums(i,j,1:2)
                    else if(fit_codes(i,j) == 'or' .or. fit_codes(i,j) == 'vo' .or. fit_codes(i,j) == 'mo' .or. fit_codes(i,j) == 'os') then
                        write(SaveTxt,'(A2,A1,I3)') str_copy," ",fit_nums(i,j,1)
                    else if(fit_codes(i,j) == 'ti' .or. fit_codes(i,j) == 'dt' .or. fit_codes(i,j) == 'da' .or. fit_codes(i,j) == 'zj' .or. fit_codes(i,j) == 'im') then
                        write(SaveTxt,'(A2)') str_copy
                    end if
                    call output_text(SaveTxt,.false.)
                end do
                call output_text("--------------------------------------------",.false.)
            end do
        end if
        call get_residual(result)
        if(return_all) return
        if(OperationMode(1:3) == 'fit') then
            do i=1,NOps
                !write(6,*) i, INPUT(i),fit_limits(i,1:2)
                if(fit_limits(i,1) /= infinity .or. fit_limits(i,2) /= infinity) then
                    if(any(fit_codes(i,:) == 'rc') .or. any(fit_codes(i,:) == 're')) then
                        if(INPUT(i) > maxval(fit_limits(i,:))) then
                            result = result*dexp(FitLimit*dabs(INPUT(i)-maxval(fit_limits(i,:)))/360.0_8)
                            !write(6,*) 'over', dexp(FitLimit*dabs(INPUT(i)-maxval(fit_limits(i,:)))/360.0_8)
                        else if(INPUT(i) < minval(fit_limits(i,:))) then
                            result = result*dexp(FitLimit*dabs(INPUT(i)-minval(fit_limits(i,:)))/360.0_8)
                            !write(6,*) 'under',dexp(FitLimit*dabs(INPUT(i)-minval(fit_limits(i,:)))/360.0_8)
                        else
                            !write(6,*) 'fine'
                        end if
                    else
                        if(INPUT(i) > maxval(fit_limits(i,:))) then
                            result = result*dexp(FitLimit*dabs(INPUT(i)-maxval(fit_limits(i,:))))
                            !write(6,*) 'over', dexp(FitLimit*dabs(INPUT(i)-maxval(fit_limits(i,:))))
                        else if(INPUT(i) < minval(fit_limits(i,:))) then
                            result = result*dexp(FitLimit*dabs(INPUT(i)-minval(fit_limits(i,:))))
                            !write(6,*) 'under',dexp(FitLimit*dabs(INPUT(i)-minval(fit_limits(i,:))))
                        else
                            !write(6,*) 'fine'
                        end if
                    end if
                end if
                if(any(fit_codes(i,:) == 'vo') .and. INPUT(i) < 0.0_8) result = result*dexp(FitLimit*FitLimit*dabs(INPUT(i)))
                if(any(fit_codes(i,:) == 'vo') .and. INPUT(i) > 1.0_8) result = result*dexp(FitLimit*FitLimit*dabs(1.0_8-INPUT(i)))
                if(any(fit_codes(i,:) == 'gf') .and. INPUT(i) < 0.0_8) result = result*dexp(FitLimit*FitLimit*dabs(INPUT(i)))
            end do
        end if
        if(NoPrint == 0 .and. uncert_in_progress == 0 .and. OperationMode(1:3) /= 'sur') then
            SaveTxt = ""
            if(result < 1000.0_8 .and. result > 0.001_8) then
                if(result < 1000.0_8 .and. result >= 100.0_8) write(SaveTxt,'(A10,F18.14)') "Residual: ",result
                if(result < 100.0_8 .and. result >= 10.0_8) write(SaveTxt,'(A10,F18.15)') "Residual: ",result
                if(result < 10.0_8 .and. result >= 1.0_8) write(SaveTxt,'(A10,F18.16)') "Residual: ",result
                if(result < 1.0_8) write(SaveTxt,'(A10,F19.17)') "Residual: ",result
            else
                write(SaveTxt,'(A10,E26.17E3)') "Residual: ",result
            end if
            call output_text(SaveTxt,.false.)
            call output_text("============================================",.false.)
            !if(fit_pause == 1) pause
        end if
        if(result /= result .or. dabs(result) >= infinity) then
            call output_text("Residual is NaN or infinite",.false.)
            call print_results
            call control('kill ')
            return
        end if
        if(FEvals == 1) then
            initResidual = result
            bestResidual = result
        else
            if(result < bestResidual .and. uncert_in_progress == 0 .and. OperationMode(1:3) == 'fit') then
                bestResidual = result
                if(mpi_rank == 0) then
                    open(45,file=trim(WorkDir)//"/"//trim(JobTitle)//".best",status='unknown')
                    write(45,'(A)') "============================================"
                    write(45,'(A11,I11)') "Iteration: ",FEvals
                    write(45,'(A)') "--------------------------------------------"
                    do i=1,fit_NOps
                        absparam = 0
                        do j=1,fit_N2(i)
                            if(codes(i,j) == 'im' .or. codes(i,j) == 'lw' .or. codes(i,j) == 'vo' .or. codes(i,j) == 'mo' .or. codes(i,j) == 'dt' .or. codes(i,j) == 'da') then
                                absparam = 1
                            end if
                        end do
                        if(absparam == 1) then
                            input_copy = dabs(INPUT(i))
                        else
                            input_copy = INPUT(i)
                        end if
                        if(dabs(input_copy) < 1000.0_8 .and. dabs(input_copy) > 0.001_8) then
                            if(dabs(input_copy) < 1000.0_8 .and. dabs(input_copy) >= 100.0_8) then
                                if(input_copy < 0.0_8) then
                                    write(45,'(F19.14)') input_copy
                                else
                                    write(45,'(F18.14)') input_copy
                                end if
                            else if(dabs(input_copy) < 100.0_8 .and. dabs(input_copy) >= 10.0_8) then
                                if(input_copy < 0.0_8) then
                                    write(45,'(F19.15)') input_copy
                                else
                                    write(45,'(F18.15)') input_copy
                                end if
                            else if(dabs(input_copy) < 10.0_8 .and. dabs(input_copy) >= 1.0_8) then
                                if(input_copy < 0.0_8) then
                                    write(45,'(F19.16)') input_copy
                                else
                                    write(45,'(F18.16)') input_copy
                                end if
                            else if(dabs(input_copy) < 1.0_8) then
                                if(input_copy < 0.0_8) then
                                    write(45,'(F19.16)') input_copy
                                else
                                    write(45,'(F18.16)') input_copy
                                end if
                            end if
                        else
                            write(45,'(E22.13E3)') input_copy
                        end if
                        do j=1,N2(i)
                            str_copy = codes(i,j)
                            call uppercase(str_copy)
                            if(fit_codes(i,j) == 'ex' .or. fit_codes(i,j) == 'in' .or. fit_codes(i,j) == 'cf' .or. fit_codes(i,j) == 're' .or. fit_codes(i,j) == 'es' .or. fit_codes(i,j) == 'is' .or. fit_codes(i,j) == 'cs') then
                                write(45,'(A2,A1,3I3)') str_copy," ",fit_nums(i,j,:)
                            else if(fit_codes(i,j) == 'so' .or. fit_codes(i,j) == 'gf' .or. fit_codes(i,j) == 'rc' .or. fit_codes(i,j) == 'lw' .or. fit_codes(i,j) == 'ss' .or. fit_codes(i,j) == 'gs') then
                                write(45,'(A2,A1,2I3)') str_copy," ",fit_nums(i,j,1:2)
                            else if(fit_codes(i,j) == 'or' .or. fit_codes(i,j) == 'vo' .or. fit_codes(i,j) == 'mo' .or. fit_codes(i,j) == 'os') then
                                write(45,'(A2,A1,I3)') str_copy," ",fit_nums(i,j,1)
                            else if(fit_codes(i,j) == 'ti' .or. fit_codes(i,j) == 'dt' .or. fit_codes(i,j) == 'da' .or. fit_codes(i,j) == 'zj' .or. fit_codes(i,j) == 'im') then
                                write(45,'(A2)') str_copy
                            end if
                        end do
                        write(45,'(A)') "--------------------------------------------"
                    end do
                    if(result < 1000.0_8 .and. result > 0.001_8) then
                        if(result < 1000.0_8 .and. result >= 100.0_8) write(45,'(A10,F18.14)') "Residual: ",result
                        if(result < 100.0_8 .and. result >= 10.0_8) write(45,'(A10,F18.15)') "Residual: ",result
                        if(result < 10.0_8 .and. result >= 1.0_8) write(45,'(A10,F18.16)') "Residual: ",result
                        if(result < 1.0_8) write(45,'(A10,F19.17)') "Residual: ",result
                    else
                        write(45,'(A10,E26.17E3)') "Residual: ",result
                    end if
                    write(45,'(A)') "============================================"
                    close(45)
                end if
            end if
        end if
        if(((OperationMode(1:3) == 'sur' .and. sur_save == 1) .or. (OperationMode(1:3) == 'fit' .and. NoPrint == 0)) .and. uncert_in_progress == 0) call print_results
        if (FEvals == fit_max_iter) then
            call output_text("",.true.)
            call output_text("Fit iteration limit reached.",.false.)
            call control('stop ')
            return
        end if
        deallocate(codes,nums,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_Gfactor,local_Jss,local_dss,local_CFP_rot,local_EX_rot,local_linewidth,local_voigt,local_mosaic,local_strain_lamda,local_strain_EXmat,local_strain_Jss,local_strain_dss,local_strain_Gfactor,local_strain_A2,local_strain_A4,local_strain_A6,local_strain_orbred)
    end subroutine funk
    
    subroutine get_residual(score)
        ! Calculates the error function (residual) for the fitting or survey routines
        implicit none
        real(kind=8),intent(out)::score
        real(kind=8)::temp(10)
        integer::i
        if(return_all) then
            !write(6,*) "CK"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CK"
        end if
        score = 1.0_8
        temp = 1.0_8
        fit_Npoints = 0
        if(scan(OperationModeB,'m',.false.) /= 0) call mag_residual(temp(1))
        if(return_all) return
        if(scan(OperationModeB,'c',.false.) /= 0) call mce_residual(temp(2))
        if(return_all) return
        if(scan(OperationModeB,'s',.false.) /= 0) call sus_residual(temp(3))
        if(return_all) return
        if(scan(OperationModeB,'e',.false.) /= 0) call epr_residual(temp(4))
        if(return_all) return
        if(scan(OperationModeB,'h',.false.) /= 0) call heat_residual(temp(5))
        if(return_all) return
        if(scan(OperationModeB,'t',.false.) /= 0) call tensor_residual(temp(6))
        if(return_all) return
        if(scan(OperationModeB,'l',.false.) /= 0) call levs_residual(temp(7))
        if(return_all) return
        if(scan(OperationModeB,'g',.false.) /= 0) call G_residual(temp(8))
        if(return_all) return
        if(scan(OperationModeB,'d',.false.) /= 0) call Gdir_residual(temp(9))
        if(return_all) return
        if(scan(OperationModeB,'x',.false.) /= 0) call ME_residual(temp(10))
        if(return_all) return
        do i = 1,10
            score = score*temp(i)
        end do
    end subroutine get_residual
    
    subroutine mag_residual(a)
        implicit none
        integer::i,d
        real(kind=8)::a
        if(return_all) then
            !write(6,*) "CL"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CL"
        end if
        a = 0.0_8
        do i=1,mag_numT
            do d=1,mag_numB
                if(mag_exp(i,d) == mag_exp(i,d)) then
                    fit_Npoints = fit_Npoints + 1
                    if(ResidualType == 1 .and. mag_temps(i) /= 0.0_8) then
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)/(mag_temps(i)**2)
                    else if(ResidualType == 2) then
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)*(mag_temps(i)**2)
                    else if(ResidualType == 3 .and. mag_fields(d) /= 0.0_8) then
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)/(mag_fields(d)**2)
                    else if(ResidualType == 4) then
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)*(mag_fields(d)**2)
                    else if(ResidualType == 13 .and. mag_temps(i) /= 0.0_8 .and. mag_fields(d) /= 0.0_8) then
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)/((mag_temps(i)*mag_fields(d))**2)
                    else if(ResidualType == 14 .and. mag_temps(i) /= 0.0_8) then
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)*(mag_fields(d)**2)/(mag_temps(i)**2)
                    else if(ResidualType == 23 .and. mag_fields(d) /= 0.0_8) then
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)*(mag_temps(i)**2)/(mag_fields(d)**2)
                    else if(ResidualType == 24) then
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)*((mag_temps(i)*mag_fields(d))**2)
                    else
                        a = a + ((mag_exp(i,d)-mag_calc(i,d))**2.0_8)
                    end if
                end if
            end do
        end do
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("Mag residual is NaN or infinite",.false.)
            do i=1,mag_numT
                do d=1,mag_numB
                    SaveTxt = ""
                    write(SaveTxt,*) mag_exp(i,d), mag_calc(i,d)
                    call output_text(SaveTxt,.false.)
                end do
                call output_text(SaveTxt,.true.)
            end do
            call control('kill ')
        end if
    end subroutine mag_residual
    
    subroutine sus_residual(a)
        implicit none
        integer::i,d
        real(kind=8)::a
        if(return_all) then
            !write(6,*) "CM"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CM"
        end if
        a = 0.0_8
        do i=1,sus_numB
            do d=1,sus_numT
                if(sus_exp(i,d) == sus_exp(i,d)) then
                    fit_Npoints = fit_Npoints + 1
                    if(ResidualType == 1 .and. sus_temps(d) /= 0.0_8) then
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)/(sus_temps(d)**2)
                    else if(ResidualType == 2) then
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)*(sus_temps(d)**2)
                    else if(ResidualType == 3 .and. sus_fields(i) /= 0.0_8) then
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)/(sus_fields(i)**2)
                    else if(ResidualType == 4) then
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)*(sus_fields(i)**2)
                    else if(ResidualType == 13 .and. sus_temps(d) /= 0.0_8 .and. sus_fields(i) /= 0.0_8) then
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)/((sus_temps(d)*sus_fields(i))**2)
                    else if(ResidualType == 14 .and. sus_temps(d) /= 0.0_8) then
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)*(sus_fields(i)**2)/(sus_temps(d)**2)
                    else if(ResidualType == 23 .and. sus_fields(i) /= 0.0_8) then
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)*(sus_temps(d)**2)/(sus_fields(i)**2)
                    else if(ResidualType == 24) then
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)*((sus_temps(d)*sus_fields(i))**2)
                    else
                        a = a + ((sus_exp(i,d)-sus_calc(i,d))**2.0_8)
                    end if
                end if
            end do
        end do
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("Sus residual is NaN or infinite",.false.)
            do i=1,sus_numB
                do d=1,sus_numT
                    SaveTxt = ""
                    write(SaveTxt,*) sus_temps(d),sus_exp(i,d),sus_calc(i,d)
                    call output_text(SaveTxt,.false.)
                end do
                call output_text(SaveTxt,.true.)
            end do
            call control('kill ')
        end if
    end subroutine sus_residual
    
    subroutine tensor_residual(a)
        implicit none
        integer::i,d,k
        real(kind=8)::a
        if(return_all) then
            !write(6,*) "CM1"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CM1"
        end if
        a = 0.0_8
        do i=1,tensor_numB
            do d=1,tensor_numT
                do k = 1,6
                    if(tensor_exp(i,d,k) == tensor_exp(i,d,k)) then
                        fit_Npoints = fit_Npoints + 1
                        if(ResidualType == 1 .and. tensor_temps(d) /= 0.0_8) then
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)/(tensor_temps(d)**2)
                        else if(ResidualType == 2) then
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)*(tensor_temps(d)**2)
                        else if(ResidualType == 3 .and. tensor_fields(i) /= 0.0_8) then
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)/(tensor_fields(i)**2)
                        else if(ResidualType == 4) then
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)*(tensor_fields(i)**2)
                        else if(ResidualType == 13 .and. tensor_temps(d) /= 0.0_8 .and. tensor_fields(i) /= 0.0_8) then
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)/((tensor_temps(d)*tensor_fields(i))**2)
                        else if(ResidualType == 14 .and. tensor_temps(d) /= 0.0_8) then
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)*(tensor_fields(i)**2)/(tensor_temps(d)**2)
                        else if(ResidualType == 23 .and. tensor_fields(i) /= 0.0_8) then
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)*(tensor_temps(d)**2)/(tensor_fields(i)**2)
                        else if(ResidualType == 24) then
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)*((tensor_temps(d)*tensor_fields(i))**2)
                        else
                            a = a + ((tensor_exp(i,d,k)-tensor_calc(i,d,k))**2.0_8)
                        end if
                    end if
                end do
            end do
        end do
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("tensor residual is NaN or infinite",.false.)
            do i=1,tensor_numB
                do d=1,tensor_numT
                    SaveTxt = ""
                    write(SaveTxt,*) tensor_temps(d),tensor_exp(i,d,k),tensor_calc(i,d,k)
                    call output_text(SaveTxt,.false.)
                end do
                call output_text(SaveTxt,.true.)
            end do
            call control('kill ')
        end if
    end subroutine tensor_residual
    
    subroutine heat_residual(a)
        implicit none
        integer::i,d
        real(kind=8)::a
        if(return_all) then
            !write(6,*) "CN"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CN"
        end if
        a = 0.0_8
        do i=1,heat_numB
            do d=1,heat_numT
                if(heat_exp(i,d) == heat_exp(i,d)) then
                    fit_Npoints = fit_Npoints + 1
                    if(ResidualType == 1 .and. heat_temps(d) /= 0.0_8) then
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)/(heat_temps(d)**2)
                    else if(ResidualType == 2) then
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)*(heat_temps(d)**2)
                    else if(ResidualType == 3 .and. heat_fields(i) /= 0.0_8) then
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)/(heat_fields(i)**2)
                    else if(ResidualType == 4) then
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)*(heat_fields(i)**2)
                    else if(ResidualType == 13 .and. heat_temps(d) /= 0.0_8 .and. heat_fields(i) /= 0.0_8) then
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)/((heat_temps(d)*heat_fields(i))**2)
                    else if(ResidualType == 14 .and. heat_temps(d) /= 0.0_8) then
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)*(heat_fields(i)**2)/(heat_temps(d)**2)
                    else if(ResidualType == 23 .and. heat_fields(i) /= 0.0_8) then
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)*(heat_temps(d)**2)/(heat_fields(i)**2)
                    else if(ResidualType == 24) then
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)*((heat_temps(d)*heat_fields(i))**2)
                    else
                        a = a + ((heat_exp(i,d)-heat_calc(i,d))**2.0_8)
                    end if
                end if
            end do
        end do
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("Heat residual is NaN or infinite",.false.)
            do i=1,heat_numB
                do d=1,heat_numT
                    SaveTxt = ""
                    write(SaveTxt,*) heat_temps(d),heat_exp(i,d),heat_calc(i,d)
                    call output_text(SaveTxt,.false.)
                end do
                call output_text(SaveTxt,.true.)
            end do
            call control('kill ')
        end if
    end subroutine heat_residual
    
    subroutine mce_residual(a)
        implicit none
        integer::i,d
        real(kind=8)::a
        if(return_all) then
            !write(6,*) "CO"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CO"
        end if
        a = 0.0_8
        do i=1,mce_numB
            do d=1,mce_numT
                if(mce_exp(i,d) == mce_exp(i,d)) then
                    fit_Npoints = fit_Npoints + 1
                    if(ResidualType == 1 .and. mce_temps(d) /= 0.0_8) then
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)/(mce_temps(d)**2)
                    else if(ResidualType == 2) then
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)*(mce_temps(d)**2)
                    else if(ResidualType == 3 .and. mce_fields(i) /= 0.0_8) then
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)/(mce_fields(i)**2)
                    else if(ResidualType == 4) then
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)*(mce_fields(i)**2)
                    else if(ResidualType == 13 .and. mce_temps(d) /= 0.0_8 .and. mce_fields(i) /= 0.0_8) then
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)/((mce_temps(d)*mce_fields(i))**2)
                    else if(ResidualType == 14 .and. mce_temps(d) /= 0.0_8) then
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)*(mce_fields(i)**2)/(mce_temps(d)**2)
                    else if(ResidualType == 23.and. mce_fields(i) /= 0.0_8) then
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)*(mce_temps(d)**2)/(mce_fields(i)**2)
                    else if(ResidualType == 24) then
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)*((mce_temps(d)*mce_fields(i))**2)
                    else
                        a = a + ((mce_exp(i,d)-mce_calc(i,d))**2.0_8)
                    end if
                end if
            end do
        end do
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("MCE residual is NaN or infinite",.false.)
            do i=1,mce_numB
                do d=1,mce_numT
                    SaveTxt = ""
                    write(SaveTxt,*) mce_temps(d),mce_exp(i,d),mce_calc(i,d)
                    call output_text(SaveTxt,.false.)
                end do
                call output_text(SaveTxt,.true.)
            end do
            call control('kill ')
        end if
    end subroutine mce_residual
    
    subroutine levs_residual(a)
        implicit none
        integer::i
        real(kind=8)::a
        if(return_all) then
            !write(6,*) "CP"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CP"
        end if
        a = 0.0_8
        do i=1,levs_numExp
            if(levs_exp(i) == levs_exp(i)) then
                fit_Npoints = fit_Npoints + 1
                if(ResidualType == 6 .and. levs_exp(i) /= 0.0_8) then
                    a = a + ((levs_exp(i)-((levs_calc(i)-levs_calc(1))/EnergyConvert))**2.0_8)/(levs_exp(i)**2)
                else if(ResidualType == 7) then
                    a = a + ((levs_exp(i)-((levs_calc(i)-levs_calc(1))/EnergyConvert))**2.0_8)*levs_exp(i)*levs_exp(i)
                else
                    a = a + (levs_exp(i)-((levs_calc(i)-levs_calc(1))/EnergyConvert))**2.0_8
                end if
            end if
        end do
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("Level residual is NaN or infinite",.false.)
            do i=1,levs_numExp
                SaveTxt = ""
                write(SaveTxt,*) levs_exp(i),(levs_calc(i)-levs_calc(1))/EnergyConvert
                call output_text(SaveTxt,.false.)
            end do
            call control('kill ')
        end if
    end subroutine levs_residual
    
    subroutine ME_residual(a)
        implicit none
        integer::i,j,d
        real(kind=8)::a
        if(return_all) then
            !write(6,*) "CMa"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CMa"
        end if
        a = 0.0_8
        do i=1,3
            do d=1,totaldim
                do j=1,totaldim
                    if(me_exp(i,d,j) == me_exp(i,d,j)) then
                        fit_Npoints = fit_Npoints + 1
                        a = a + (me_exp(i,d,j)-dble(me_calc(i,d,j)))**2.0_8
                        write(6,*) i,d,j
                        write(6,*) me_exp(i,d,j),dble(me_calc(i,d,j))
                    end if
                end do
            end do
        end do
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("ME residual is NaN or infinite",.false.)

            call control('kill ')
        end if
    end subroutine ME_residual
    
    subroutine G_residual(a)
        implicit none
        integer::i,d,small
        real(kind=8)::a
        if(return_all) then
            !write(6,*) "CQ"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CQ"
        end if
        a = 0.0_8
        small = min(g_numExp,g_numCalc)
        do i=1,small
            if(scan(GDir,'x',.false.) /= 0 .and. g_exp(1,i) == g_exp(1,i)) then
                fit_Npoints = fit_Npoints + 1
                a = a + (g_exp(1,i)-g_calc(1,i))**2.0_8
            end if
            if(scan(GDir,'y',.false.) /= 0 .and. g_exp(2,i) == g_exp(2,i)) then
                fit_Npoints = fit_Npoints + 1
                a = a + (g_exp(2,i)-g_calc(2,i))**2.0_8
            end if
            if(scan(GDir,'z',.false.) /= 0 .and. g_exp(3,i) == g_exp(3,i)) then
                fit_Npoints = fit_Npoints + 1
                a = a + (g_exp(3,i)-g_calc(3,i))**2.0_8
            end if
        end do
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("G-tensor residual is NaN or infinite",.false.)
            do i=1,small
                do d=1,3
                    SaveTxt = ""
                    write(SaveTxt,*) g_exp(d,i),g_calc(d,i)
                    call output_text(SaveTxt,.false.)
                end do
                call output_text(SaveTxt,.true.)
            end do
            call control('kill ')
        end if
        if(ResidualType == 5) a = a*1000.0_8
    end subroutine G_residual
    
    subroutine Gdir_residual(a)
        implicit none
        integer::i,d,small
        real(kind=8)::a,b,c
        if(return_all) then
            !write(6,*) "CR"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CR"
        end if
        a = 0.0_8
        b = 0.0_8
        c = 0.0_8
        small = min(g_numExp,g_numCalc)
        do i=1,small
            if(scan(GDir,'x',.false.) /= 0) then
                if(g_exp(1,i) == g_exp(1,i) .and. gdir_exp(1,1,i) == gdir_exp(1,1,i) .and. gdir_exp(2,1,i) == gdir_exp(2,1,i) .and. gdir_exp(3,1,i) == gdir_exp(3,1,i)) then
                    fit_Npoints = fit_Npoints + 1
                    a = a + (g_exp(1,i)-g_calc(1,i))**2.0_8
                    c = (gdir_exp(1,1,i)*gdir_calc(1,1,i) + gdir_exp(2,1,i)*gdir_calc(2,1,i) + gdir_exp(3,1,i)*gdir_calc(3,1,i))/(dsqrt((gdir_exp(1,1,i)*gdir_exp(1,1,i) + gdir_exp(2,1,i)*gdir_exp(2,1,i) + gdir_exp(3,1,i)*gdir_exp(3,1,i))*(gdir_calc(1,1,i)*gdir_calc(1,1,i) + gdir_calc(2,1,i)*gdir_calc(2,1,i) + gdir_calc(3,1,i)*gdir_calc(3,1,i))))
                end if
                if(dabs(c) > 1.0_8-EPS) then
                    c = 0.0_8
                else
                    c = 180.0_8*(dacos(c))/Pie
                end if
                if(c > 180.0_8) then
                    call output_text("Angle difference in G-tensor(dirs) residual is greater than 180",.false.)
                    call control('kill ')
                    return
                end if
                if(c > 90.0_8) c = 180.0_8 - c
                b = b + c
            end if
            if(scan(GDir,'y',.false.) /= 0) then
                if(g_exp(2,i) == g_exp(2,i) .and. gdir_exp(1,2,i) == gdir_exp(1,2,i) .and. gdir_exp(2,2,i) == gdir_exp(2,2,i) .and. gdir_exp(3,2,i) == gdir_exp(3,2,i)) then
                    fit_Npoints = fit_Npoints + 1
                    a = a + (g_exp(2,i)-g_calc(2,i))**2.0_8
                    c = (gdir_exp(1,2,i)*gdir_calc(1,2,i) + gdir_exp(2,2,i)*gdir_calc(2,2,i) + gdir_exp(3,2,i)*gdir_calc(3,2,i))/(dsqrt((gdir_exp(1,2,i)*gdir_exp(1,2,i) + gdir_exp(2,2,i)*gdir_exp(2,2,i) + gdir_exp(3,2,i)*gdir_exp(3,2,i))*(gdir_calc(1,2,i)*gdir_calc(1,2,i) + gdir_calc(2,2,i)*gdir_calc(2,2,i) + gdir_calc(3,2,i)*gdir_calc(3,2,i))))
                end if
                if(dabs(c) > 1.0_8-EPS) then
                    c = 0.0_8
                else
                    c = 180.0_8*(dacos(c))/Pie
                end if
                if(c > 180.0_8) then
                    call output_text("Angle difference in G-tensor(dirs) residual is greater than 180",.false.)
                    call control('kill ')
                    return
                end if
                if(c > 90.0_8) c = 180.0_8 - c
                b = b + c
            end if
            if(scan(GDir,'z',.false.) /= 0) then
                if(g_exp(3,i) == g_exp(3,i) .and. gdir_exp(1,3,i) == gdir_exp(1,3,i) .and. gdir_exp(2,3,i) == gdir_exp(2,3,i) .and. gdir_exp(3,3,i) == gdir_exp(3,3,i)) then
                    fit_Npoints = fit_Npoints + 1
                    a = a + (g_exp(3,i)-g_calc(3,i))**2.0_8
                    c = (gdir_exp(1,3,i)*gdir_calc(1,3,i) + gdir_exp(2,3,i)*gdir_calc(2,3,i) + gdir_exp(3,3,i)*gdir_calc(3,3,i))/(dsqrt((gdir_exp(1,3,i)*gdir_exp(1,3,i) + gdir_exp(2,3,i)*gdir_exp(2,3,i) + gdir_exp(3,3,i)*gdir_exp(3,3,i))*(gdir_calc(1,3,i)*gdir_calc(1,3,i) + gdir_calc(2,3,i)*gdir_calc(2,3,i) + gdir_calc(3,3,i)*gdir_calc(3,3,i))))
                end if
                if(dabs(c) > 1.0_8-EPS) then
                    c = 0.0_8
                else
                    c = 180.0_8*(dacos(c))/Pie
                end if
                if(c > 180.0_8) then
                    call output_text("Angle difference in G-tensor(dirs) residual is greater than 180",.false.)
                    call control('kill ')
                    return
                end if
                if(c > 90.0_8) c = 180.0_8 - c
                b = b + c
            end if
        end do
        if((a /= a .or. b /= b .or. dabs(a) >= infinity .or. dabs(b) > infinity) .and. mpi_rank == 0) then
            call output_text("G-tensor(dirs) residual is NaN or infinite",.false.)
            do i=1,small
                do d=1,3
                    SaveTxt = ""
                    write(SaveTxt,*) g_exp(d,i),g_calc(d,i)
                    call output_text(SaveTxt,.false.)
                end do
                if(scan(GDir,'x',.false.) /= 0) then
                    SaveTxt = ""
                    write(SaveTxt,*) gdir_exp(1,1,i),gdir_calc(1,1,i),gdir_exp(2,1,i),gdir_calc(2,1,i),gdir_exp(3,1,i),gdir_calc(3,1,i)
                    call output_text(SaveTxt,.false.)
                end if
                if(scan(GDir,'y',.false.) /= 0) then
                    SaveTxt = ""
                    write(SaveTxt,*) gdir_exp(1,2,i),gdir_calc(1,2,i),gdir_exp(2,2,i),gdir_calc(2,2,i),gdir_exp(3,2,i),gdir_calc(3,2,i)
                    call output_text(SaveTxt,.false.)
                end if
                if(scan(GDir,'z',.false.) /= 0) then
                    SaveTxt = ""
                    write(SaveTxt,*) gdir_exp(1,3,i),gdir_calc(1,3,i),gdir_exp(2,3,i),gdir_calc(2,3,i),gdir_exp(3,3,i),gdir_calc(3,3,i)
                    call output_text(SaveTxt,.false.)
                end if
                call output_text(SaveTxt,.true.)
            end do
            call control('kill ')
        end if
        if(ResidualType == 5) a = a*1000.0_8
        a = a*b
    end subroutine Gdir_residual
    
    subroutine epr_residual(a)
        implicit none
        integer           :: i,d,k
        real(kind=8)      :: a,b
        if(return_all) then
            !write(6,*) "CS"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CS"
        end if
        a = 0.0_8
        if(wavelet_error) then

            if(any(any(any(epr_exp(:,:,:) /= epr_exp(:,:,:),1),1),1)) then
                call output_text("EPR wavelet residual cannot handle dummy data",.false.)
                call control('kill ')
            end if
            
            do d =1,epr_numF
                do k=1,epr_numT
                    CALL WAVELET_ERROR_SUB(epr_calc(d,k,:), epr_fields(:), epr_wave_exp(d,k,1:size(epr_fields),1:NINT(1.0_8+(LOG(size(epr_fields)*4.0_8)/LOG(2.0_8))*4)), epr_wave_params(d,k,:), b)
                    a = a + b
                end do
            end do
        else
            do i=1,epr_numB
                do d=1,epr_numF
                    do k=1,epr_numT
                        if(epr_exp(d,k,i) == epr_exp(d,k,i)) then
                            fit_Npoints = fit_Npoints + 1
                            if(ResidualType == 1 .and. epr_temps(k) /= 0.0_8) then
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)/(epr_temps(k)**2)
                            else if(ResidualType == 2) then
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)*(epr_temps(k)**2)
                            else if(ResidualType == 3 .and. epr_fields(i) /= 0.0_8) then
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)/(epr_fields(i)**2)
                            else if(ResidualType == 4) then
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)*(epr_fields(i)**2)
                            else if(ResidualType == 13 .and. epr_temps(k) /= 0.0_8 .and. epr_fields(i) /= 0.0_8) then
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)/((epr_temps(k)*epr_fields(i))**2)
                            else if(ResidualType == 14 .and. epr_temps(k) /= 0.0_8) then
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)*(epr_fields(i)**2)/(epr_temps(k)**2)
                            else if(ResidualType == 23 .and. epr_fields(i) /= 0.0_8) then
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)*(epr_temps(k)**2)/(epr_fields(i)**2)
                            else if(ResidualType == 24) then
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)*((epr_temps(k)*epr_fields(i))**2)
                            else
                                a = a + ((epr_exp(d,k,i)-epr_calc(d,k,i))**2.0_8)
                            end if
                        end if
                    end do
                end do
            end do
        end if
        if((a /= a .or. dabs(a) >= infinity) .and. mpi_rank == 0) then
            call output_text("EPR residual is NaN or infinite",.false.)
            do i=1,epr_numB
                do d=1,epr_numF
                    do k=1,epr_numT
                        SaveTxt = ""
                        write(SaveTxt,*) epr_exp(d,k,i),epr_calc(d,k,i)
                        call output_text(SaveTxt,.false.)
                    end do
                    call output_text(SaveTxt,.true.)
                end do
                call output_text(SaveTxt,.true.)
            end do
            call control('kill ')
        end if
    end subroutine epr_residual
    
    subroutine mnbrak(ax,bx,cx,fa,fb,fc)
        implicit none
        real(kind=8)::dum,fu,q,r,u,ulim,GOLD,GLIMIT,TINY,ax,bx,cx,fa,fb,fc
        if(return_all) then
            !write(6,*) "CT"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CT"
        end if
        GOLD = 1.618034_8
        GLIMIT = 100.0_8
        TINY = 1.0D-20
        call f1dimmer(ax,fa)
        call f1dimmer(bx,fb)
        if(fb > fa)then
            dum = ax
            ax = bx
            bx = dum
            dum = fb
            fb = fa
            fa = dum
        end if
        cx = bx + (GOLD*(bx-ax))
        call f1dimmer(cx,fc)
        do while(fb > fc)           !changed from >= to move on to next parameter if parameter not affecting fit.
            r = (bx-ax)*(fb-fc)
            q = (bx-cx)*(fb-fa)
            u = bx - ((bx-cx)*q-(bx-ax)*r)/(2.0_8*sign(max(abs(q-r),TINY),q-r))
            ulim = bx + GLIMIT*(cx-bx)
            if((bx-u)*(u-cx) > 0.0_8)then
                call f1dimmer(u,fu)
                if(fu < fc)then
                    ax = bx
                    fa = fb
                    bx = u
                    fb = fu
                    return
                else if(fu > fb)then
                    cx = u
                    fc = fu
                    return
                end if
                u = cx + GOLD*(cx-bx)
                call f1dimmer(u,fu)
            else if((cx-u)*(u-ulim) > 0.0_8)then
                call f1dimmer(u,fu)
                if(fu < fc)then
                    bx = cx
                    cx = u
                    u = cx + GOLD*(cx-bx)
                    fb = fc
                    fc = fu
                    call f1dimmer(u,fu)
                end if
            else if((u-ulim)*(ulim-cx) >= 0.0_8)then
                u = ulim
                call f1dimmer(u,fu)
            else
                u = cx + GOLD*(cx-bx)
                call f1dimmer(u,fu)
            end if
            ax = bx
            bx = cx
            cx = u
            fa = fb
            fb = fc
            fc = fu
        end do
    end subroutine mnbrak

    subroutine brent(ax,bx,cx,tol,xmin,gold)
        implicit none
        integer::ITMAX,iter
        real(kind=8)::gold,ax,bx,cx,tol,xmin,CGOLD,ZEPS,a,b,d,e,etemp,fu,fv,fw,fx,p,q,r,tol1,tol2,u,v,w,x,xm
        if(return_all) then
            !write(6,*) "CU"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CU"
        end if
        ITMAX = 100
        CGOLD = 0.3819660_8
        ZEPS=1.0D-10
        a = min(ax,cx)
        b = max(ax,cx)
        v = bx
        w = v
        x = v
        e = 0.0_8
        call f1dimmer(x,fx)
        fv = fx
        fw = fx
        do iter=1,ITMAX
            xm = 0.5_8*(a+b)
            tol1 = tol*abs(x) + ZEPS
            tol2 = 2.0_8*tol1
            if(abs(x-xm) <= (tol2-.5*(b-a))) goto 3
            if(abs(e) > tol1) then
                r = (x-w)*(fx-fv)
                q = (x-v)*(fx-fw)
                p = (x-v)*q-(x-w)*r
                q = 2.0_8*(q-r)
                if(q > 0.0_8) p = -p
                q = abs(q)
                etemp = e
                e = d
                if(abs(p) >= abs(0.5_8*q*etemp) .or. p <= q*(a-x) .or. p >+ q*(b-x)) goto 1
                d = p/q
                u = x + d
                if(u-a < tol2 .or. b-u < tol2) d = sign(tol1,xm-x)
                goto 2
            end if
            1       if(x >= xm) then
                e = a - x
            else
                e = b - x
            end if
            d = CGOLD*e
            2       if(abs(d) >= tol1) then
                u = x + d
            else
                u = x + sign(tol1,d)
            end if
            call f1dimmer(u,fu)
            if(fu <= fx) then
                if(u >= x) then
                    a = x
                else
                    b = x
                end if
                v = w
                fv = fw
                w = x
                fw = fx
                x = u
                fx = fu
            else
                if(u.lt.x) then
                    a = u
                else
                    b = u
                end if
                if(fu <= fw .or. w == x) then
                    v = w
                    fv = fw
                    w = u
                    fw = fu
                else if(fu <= fv .or. v == x .or. v == w) then
                    v = u
                    fv = fu
                end if                      
            end if
        end do
        3   xmin = x
        gold = fx
    end subroutine brent

    subroutine powell(p,xi,n,ftol,iter,fret)
        implicit none
        integer::iter,n,NMAX,ITMAX,i,ibig,j
        real(kind=8)::fret,ftol,TINY,del,fp,fptt,t,pt(50),ptt(50),xit(50)
        real(kind=8)::p(:),xi(:,:)
        if(return_all) then
            !write(6,*) "CV"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CV"
        end if
        NMAX=20
        ITMAX=200000
        TINY=1.0D-25
        if(uncert_in_progress == 1) then
            call CORfunk(p,fret)
        else
            call funk(p,fret)
        end if
        if(return_all) return
        do j=1,n
            pt(j) = p(j)
        end do
        iter = 0
        4   iter = iter + 1
        fp = fret
        ibig = 0
        del = 0.0_8
        do i=1,n
            do j=1,n
                xit(j) = xi(j,i)
            end do
            fptt = fret
            call linmin(p,xit,n,fret)
            if(fptt-fret > del) then
                del = fptt - fret
                ibig = i
            end if
        end do
        if(2.0_8*(fp-fret) <= ftol*(abs(fp)+abs(fret))+TINY)return
        do j=1,n
            ptt(j) = 2.0_8*p(j)-pt(j)
            xit(j) = p(j) - pt(j)
            pt(j) = p(j)
        end do
        if(uncert_in_progress == 1) then
            call CORfunk(ptt,fptt)
        else
            call funk(ptt,fptt)
        end if
        if(return_all) return
        if(fptt >= fp) goto 4
        t = 2.0_8*(fp - 2.0_8*fret+fptt)*(fp-fret-del)*(fp-fret-del)-del*(fp-fptt)*(fp-fptt)
        if(t >= 0.0_8) goto 4
        call linmin(p,xit,n,fret)
        do j=1,n
            xi(j,ibig) = xi(j,n)
            xi(j,n) = xit(j)
        end do
        goto 4
    end subroutine powell

    subroutine linmin(p,xi,n,fret)
        implicit none
        integer:: n,NMAX,j
        real(kind=8):: fret,TOL,ax,bx,fa,fb,fx,xmin,xx
        real(kind=8)::p(:),xi(:)
        if(return_all) then
            !write(6,*) "CW"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CW"
        end if
        NMAX=50
        TOL=1.e-4
        ncom = n
        do j=1,n
            pcom(j) = p(j)
            xicom(j) = xi(j)
        end do
        ax = 0.0_8
        xx = 1.0_8
        call mnbrak(ax,xx,bx,fa,fx,fb)
        call brent(ax,xx,bx,TOL,xmin,fret)
        do j=1,n
            xi(j) = xmin*xi(j)
            p(j) = p(j) + xi(j)
        end do
    end subroutine linmin

    subroutine f1dimmer(x,f1dim)
        implicit none
        integer:: j
        real(kind=8):: f1dim,x,xt(50)
        do j=1,ncom
            xt(j) = pcom(j)+x*xicom(j)
        end do
        if(uncert_in_progress == 1) then
            call CORfunk(xt,f1dim)
        else
            call funk(xt,f1dim)
        end if
        if(return_all) return
    end subroutine f1dimmer

    SUBROUTINE amoeba(p,y,mp,np,ndim,ftol,iter)
        INTEGER iter,mp,ndim,np,NMAX,ITMAX
        real(kind=8) ftol,p(mp,np),y(mp),TINY,avg,diff
        PARAMETER (NMAX=200,ITMAX=5000000,TINY=1.e-10)
        INTEGER i,ihi,ilo,inhi,j,m,n
        real(kind=8) rtol,sum,swap,ysave,ytry,psum(NMAX)
        if(return_all) then
            !write(6,*) "CX"
            return
        else
            !if(mpi_rank == 0) write(6,*) "*CX"
        end if
        iter=0
        1   do n=1,ndim
        sum=0.0_8
        do m=1,ndim+1
            sum=sum+p(m,n)
        end do
        psum(n)=sum
    end do
    2   ilo=1
    if (y(1).gt.y(2)) then
        ihi=1
        inhi=2
    else
        ihi=2
        inhi=1
    end if
    do i=1,ndim+1
        if(y(i).le.y(ilo)) ilo=i
        if(y(i).gt.y(ihi)) then
            inhi=ihi
            ihi=i
        else if(y(i).gt.y(inhi)) then
            if(i.ne.ihi) inhi=i
        endif
    end do
    rtol=2.*abs(y(ihi)-y(ilo))/(abs(y(ihi))+abs(y(ilo))+TINY)
    do j=1,ndim
        avg = 0.0_8
        do i=1,ndim+1
            avg = avg + p(i,j)
        end do
        avg = avg/(ndim+1)
        do i=1,ndim+1
            diff = dabs((p(i,j) - avg)/avg)
            if(diff > ftol) GOTO 3
        end do
    end do
    return
    3   CONTINUE
    if (rtol.lt.ftol) then
        swap=y(1)
        y(1)=y(ilo)
        y(ilo)=swap
        do n=1,ndim
            swap=p(1,n)
            p(1,n)=p(ilo,n)
            p(ilo,n)=swap
        end do
        return
    endif
    if (iter.ge.ITMAX) then
        call output_text("ITMAX exceeded in Simplex algorithm",.false.)
        call control('kill ')
        return
    end if
    if(return_all) return
    iter=iter+2
    ytry=amotry(p,y,psum,mp,np,ndim,ihi,-1.0_8)
    if (ytry.le.y(ilo)) then
        if(return_all) return
        ytry=amotry(p,y,psum,mp,np,ndim,ihi,2.0_8)
    else if (ytry.ge.y(inhi)) then
        if(return_all) return
        ysave=y(ihi)
        ytry=amotry(p,y,psum,mp,np,ndim,ihi,0.5_8)
        if (ytry.ge.ysave) then
            do i=1,ndim+1
                if(i.ne.ilo)then
                    do j=1,ndim
                        psum(j)=0.5_8*(p(i,j)+p(ilo,j))
                        p(i,j)=psum(j)
                    end do
                    call funk(psum,y(i))
                    if(return_all) return
                endif
            end do
            iter=iter+ndim
            goto 1
        endif
    else
        iter=iter-1
    endif
    goto 2
END SUBROUTINE amoeba

FUNCTION amotry(p,y,psum,mp,np,ndim,ihi,fac)
    INTEGER ihi,mp,ndim,np,NMAX
    real(kind=8) amotry,fac,p(mp,np),psum(np),y(mp)
    PARAMETER (NMAX=40)
    INTEGER j
    real(kind=8) fac1,fac2,ytry,ptry(NMAX)
    if(return_all) then
        !write(6,*) "CY"
        return
    else
        !if(mpi_rank == 0) write(6,*) "*CY"
    end if
    fac1=(1.0_8-fac)/ndim
    fac2=fac1-fac
    do j=1,ndim
        ptry(j)=psum(j)*fac1-p(ihi,j)*fac2
    end do
    call funk(ptry,ytry)
    if(return_all) return
    if (ytry.lt.y(ihi)) then
        y(ihi)=ytry
        do j=1,ndim
            psum(j)=psum(j)-p(ihi,j)+ptry(j)
            p(ihi,j)=ptry(j)
        end do
    endif
    amotry=ytry
END FUNCTION amotry

end module fitting
