#include "mainwindow.h"
#include "qcustomplot.h"
#include "ui_mainwindow.h"
#include "settingswindow.h"
#include <QThread>
#include <iostream>
#include <string>
#include <QColor>
#include <QFile>
#include <QTextStream>
#include <QFont>
#include <algorithm>
#include <QtMath>

#ifdef Q_OS_WIN
#include <windows.h>
#else
#include <sys/syscall.h>
#include <pthread.h>
#include <signal.h>
#include <unistd.h>
#endif

//********************************************** Global **********************************************
long sus_numB,sus_exp_numB,sus_numT,sus_exp_numT;
long mag_numB,mag_numT,mag_exp_numT,mag_exp_numB;
long mce_numB,mce_exp_numB,mce_numT,mce_exp_numT;
long heat_numB,heat_exp_numB,heat_numT,heat_exp_numT;
long epr_numB,epr_numF,epr_numT,epr_exp_numB,epr_numDir;
bool have_sus_exp_data,have_mag_exp_data,have_mce_exp_data,have_heat_exp_data,have_epr_exp_data;
long totaldim,zeeman_numB,progress,subdim;
void* ptr_to_object;
bool phi_running, wd_selected, input_modified;
static bool plotting;
long num_sites,num_added_sites,num_interactions;
QList< site_struct* > sites_content_list;
QList< interaction_struct* > interactions_list;
QVector<double> *sus_data,*sus_exp_data,*sus_fields;
QVector<double> *mag_data,*mag_exp_data,*mag_temps;
QVector<double> *mce_data,*mce_exp_data,*mce_fields;
QVector<double> *heat_data,*heat_exp_data,*heat_fields;
QVector<double> *epr_data,*epr_exp_data,*epr_freqs,*epr_temps,*epr_zee_data,*epr_dirs,*epr_trans_data;
QVector<double> *zeeman_data;
QColor colour_list[13];
QFont fixedFont;
QString cwd, jobname;
extern "C" bool return_all,epr_do_zeeman;
//****************************************************************************************************


//********************************************** Fortran *********************************************
extern "C" void send_plot_data(char *string, int num, double value)
{
    if(return_all){return;}
    std::string str1;
    str1 = string[0];
    str1 = str1 + string[1];
    str1 = str1 + string[2];
    str1 = str1 + string[3];
    str1 = str1 + string[4];
    str1 = str1 + string[5];
    str1 = str1 + string[6];
    //std::cout << "*-send_plot_data" << std::endl;
    /*if(plotting)
    {
        std::cout << "wating til plot done" << std::endl;
        while(plotting){}
        std::cout << "carry on" << std::endl;
    }*/
    //std::cout << string << " " << num << " " << value << std::endl;
    //CONSTANTS and DEPENDENTS
    if(str1.compare("susCalB") == 0)
    {
        sus_numB = num;
        sus_fields->append(value);
    }
    else if(str1.compare("susExpB") == 0)
    {
        sus_exp_numB = num;
    }
    else if(str1.compare("magCalT") == 0)
    {
        mag_numT = num;
        mag_temps->append(value);
    }
    else if(str1.compare("magExpT") == 0)
    {
        mag_exp_numT = num;
    }
    else if(str1.compare("mceCalB") == 0)
    {
        mce_numB = num;
        mce_fields->append(value);
    }
    else if(str1.compare("mceExpB") == 0)
    {
        mce_exp_numB = num;
    }
    else if(str1.compare("heaCalB") == 0)
    {
        heat_numB = num;
        heat_fields->append(value);
    }
    else if(str1.compare("heaExpB") == 0)
    {
        heat_exp_numB = num;
    }
    else if(str1.compare("epr_TTT") == 0)
    {
        epr_numT = num;
        epr_temps->append(value);
    }
    else if(str1.compare("epr_FFF") == 0)
    {
        epr_numF = num;
        epr_freqs->append(value);
    }
    else if(str1.compare("eprCalD") == 0)
    {
        epr_numDir = num;
    }
    else if(str1.compare("tot_dim") == 0)
    {
        totaldim = num;
    }
    else if(str1.compare("sub_dim") == 0)
    {
        subdim = num;
    }
    //EXP DATA
    else if(str1.compare("sus_exp") == 0)
    {
        sus_exp_numT = num;
        have_sus_exp_data = true;
        sus_exp_data->append(value);
    }
    else if(str1.compare("mag_exp") == 0)
    {
        mag_exp_numB = num;
        have_mag_exp_data = true;
        mag_exp_data->append(value);
    }
    else if(str1.compare("mce_exp") == 0)
    {
        mce_exp_numT = num;
        have_mce_exp_data = true;
        mce_exp_data->append(value);
    }
    else if(str1.compare("hea_exp") == 0)
    {
        heat_exp_numT = num;
        have_heat_exp_data = true;
        heat_exp_data->append(value);
    }
    else if(str1.compare("epr_exp") == 0)
    {
        epr_exp_numB = num;
        have_epr_exp_data = true;
        epr_exp_data->append(value);
    }
    //CALC DATA
    else if(str1.compare("sus_cal") == 0)
    {
        sus_numT = num;
        sus_data->append(value);
    }
    else if(str1.compare("mag_cal") == 0)
    {
        mag_numB = num;
        mag_data->append(value);
    }
    else if(str1.compare("mce_cal") == 0)
    {
        mce_numT = num;
        mce_data->append(value);
    }
    else if(str1.compare("hea_cal") == 0)
    {
        heat_numT = num;
        heat_data->append(value);
    }
    else if(str1.compare("epr_cal") == 0)
    {
        epr_numB = num;
        epr_data->append(value);
    }
    else if(str1.compare("epr_zee") == 0)
    {
        epr_zee_data->append(value);
    }
    else if(str1.compare("epr_dir") == 0)
    {
        epr_dirs->append(value);
    }
    else if(str1.compare("epr_tra") == 0)
    {
        epr_trans_data->append(value);
    }
    else if(str1.compare("zee_cal") == 0)
    {
        zeeman_numB = num;
        zeeman_data->append(value);
    }
    else
    {
        std::cout << "We've got a problem in data transfer! - " << str1 << std::endl;
    }
}

extern "C" void send_plot_signal(char *string, void* opaque_ptr_to_class)
{
    if(return_all){return;}
    MainWindow *ptr_to_class = static_cast<MainWindow*>(opaque_ptr_to_class);
    std::string str1;
    plotting = true;
    str1 = string[0];
    str1 = str1 + string[1];
    str1 = str1 + string[2];
    str1 = str1 + string[3];
    //std::cout << "*-B " << str1 << std::endl;
    //std::cout << str1 << " eT " << mag_exp_numT << " cT " <<  mag_numT << " eB " << mag_exp_numB << " cB " << mag_numB << std::endl;
    if(str1.compare("susC") == 0) {(*ptr_to_class).accept_sus_signal();}
    else if(str1.compare("susE") == 0) {(*ptr_to_class).accept_sus_exp_signal();}
    else if(str1.compare("magC") == 0) {(*ptr_to_class).accept_mag_signal();}
    else if(str1.compare("magE") == 0) {(*ptr_to_class).accept_mag_exp_signal();}
    else if(str1.compare("mceC") == 0) {(*ptr_to_class).accept_mce_signal();}
    else if(str1.compare("mceE") == 0) {(*ptr_to_class).accept_mce_exp_signal();}
    else if(str1.compare("heaC") == 0) {(*ptr_to_class).accept_heat_signal();}
    else if(str1.compare("heaE") == 0) {(*ptr_to_class).accept_heat_exp_signal();}
    else if(str1.compare("eprC") == 0) {(*ptr_to_class).accept_epr_signal();}
    else if(str1.compare("eprE") == 0) {(*ptr_to_class).accept_epr_exp_signal();}
    else if(str1.compare("zeeC") == 0){(*ptr_to_class).accept_zeeman_signal();}
    else {std::cout << "We've got a problem in plot signals! - " << str1 << std::endl;}
    while(plotting){}
}

extern "C" void send_states_signal(void* opaque_ptr_to_class)
{
    if(return_all){return;}
    MainWindow *ptr_to_class = static_cast<MainWindow*>(opaque_ptr_to_class);
    //std::cout << "*-C" << std::endl;
    (*ptr_to_class).accept_states_signal();
}

extern "C" void send_text(char *string, int num, void* opaque_ptr_to_class)
{
    if(return_all){return;}
    MainWindow *ptr_to_class = static_cast<MainWindow*>(opaque_ptr_to_class);
    std::string str1;
    str1 = string[0];
    for(int k = 1; k < num; k++)
    {
        str1 = str1 + string[k];
    }
    QString qstr = QString::fromStdString(str1);
    //std::cout << "*-C2 " << str1 << std::endl;
    (*ptr_to_class).accept_text(qstr);
}

extern "C" void send_progress(int num, void* opaque_ptr_to_class)
{
    if(return_all){return;}
    //std::cout << "*-C3-0" << std::endl;
    MainWindow *ptr_to_class = static_cast<MainWindow*>(opaque_ptr_to_class);
    //std::cout << "*-C3" << std::endl;
    progress = num;
    (*ptr_to_class).accept_progress_signal();
}

extern "C" void PhiFort(char a[10001], long *, char b[10001], long *, void* opaque_ptr_to_class);
//****************************************************************************************************


//***************************************** Platform Specific ****************************************
#ifdef Q_OS_WIN
HANDLE thread_handle;

DWORD WINAPI ThreadProc(void *number)
{
    char a[10001], b[10001];
    QString qa,qb;
    long a_len, b_len;
    const char *str;
    QByteArray ba;

    qa = cwd;
    ba = qa.toLatin1();
    str = ba.data();
    strcpy(a,str);

    qb = jobname;
    ba = qb.toLatin1();
    str = ba.data();
    strcpy(b,str);

    a_len = strlen(a);
    b_len = strlen(b);
    ::PhiFort(a,&a_len,b,&b_len,ptr_to_object);
    MainWindow *ptr_to_class = static_cast<MainWindow*>(ptr_to_object);
    //(*ptr_to_class).clear_data();
    phi_running = false;
    //std::cout << "*-PHI op buttons" << std::endl;
    (*ptr_to_class).set_operation_buttons_phi_complete();
    //std::cout << "*-PHI about to return" << std::endl;
    return 0;
}
#else
pthread_t thread_handle;

void * ThreadProc(void *)
{
    char a[10001], b[10001];
    QString qa,qb;
    long a_len, b_len;
    const char *str;
    QByteArray ba;
    
    //pid_t tid;
    //tid = syscall(SYS_gettid);
    //int ret = setpriority(PRIO_PROCESS, tid, 20);

    qa = cwd;
    ba = qa.toLatin1();
    str = ba.data();
    strcpy(a,str);

    qb = jobname;
    ba = qb.toLatin1();
    str = ba.data();
    strcpy(b,str);

    a_len = strlen(a);
    b_len = strlen(b);
    ::PhiFort(a,&a_len,b,&b_len,ptr_to_object);
    MainWindow *ptr_to_class = static_cast<MainWindow*>(ptr_to_object);
    //(*ptr_to_class).clear_data();
    phi_running = false;
    (*ptr_to_class).set_operation_buttons_phi_complete();
    return 0;
}
#endif
//****************************************************************************************************


//******************************************** MainWindow ********************************************
MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ptr_to_object = this;
    input_modified = false;

    current_version = "3.1.6";
    QCoreApplication::setOrganizationName("nfchilton");
    QCoreApplication::setOrganizationDomain("www.nfchilton.com/phi");
    QCoreApplication::setApplicationName("PHI");
    ask_for_update = false;
    totaldim = 0;
    subdim = 0;

    QSettings settings;
    fixedFont = getMonospaceFont();
#ifdef Q_OS_WIN
    default_font_size = 12;
#endif
#ifdef Q_OS_OSX
    default_font_size = 16;
#endif
#ifdef Q_OS_LINUX
    default_font_size = 10;
#endif
    fixedFont.setPointSize(settings.value("fontsize",default_font_size).toInt());
    ui->classic_box->setFont(fixedFont);
    ui->output_box->setFont(fixedFont);
    ui->states_box->setFont(fixedFont);

    this->setWindowTitle(QString::fromUtf8("PHI"));
    if(settings.value("window_maximised",0).toInt() == 1)
    {
        this->setWindowState(Qt::WindowMaximized);
    }
    else
    {
        this->setGeometry(settings.value("window_x",50).toInt(),settings.value("window_y",50).toInt(),settings.value("window_width",1000).toInt(),settings.value("window_height",600).toInt());
    }
    ui->tabWidget->setCurrentIndex(settings.value("plot_tab",0).toInt());
    ui->LR_splitter->restoreState(settings.value("splitter").toByteArray());
    cwd = settings.value("wd_path","").toString();
    QString path = cwd;
    ui->cwd_label->setText(path);
    /*while(ui->cwd_label->width() < QFontMetrics(ui->cwd_label->font()).boundingRect(QString(ui->cwd_label->text())).width())
    {
        path = path.right(path.length()-1);
        ui->cwd_label->setText(path);
    }*/

    this->createActions();
    this->createMenus();
    this->createToolBars();
    this->stopAction->setEnabled(false);
    this->updateRecentFileActions();

    connect( this, SIGNAL(plot_sus_signal()), this, SLOT(plot_sus()) );
    connect( this, SIGNAL(plot_sus_exp_signal()), this, SLOT(plot_sus_exp()) );
    connect( this, SIGNAL(plot_mag_signal()), this, SLOT(plot_mag()) );
    connect( this, SIGNAL(plot_mag_exp_signal()), this, SLOT(plot_mag_exp()) );
    connect( this, SIGNAL(plot_mce_signal()), this, SLOT(plot_mce()) );
    connect( this, SIGNAL(plot_mce_exp_signal()), this, SLOT(plot_mce_exp()) );
    connect( this, SIGNAL(plot_heat_signal()), this, SLOT(plot_heat()) );
    connect( this, SIGNAL(plot_heat_exp_signal()), this, SLOT(plot_heat_exp()) );
    connect( this, SIGNAL(plot_zeeman_signal()), this, SLOT(plot_zeeman()) );
    connect( this, SIGNAL(plot_epr_signal()), this, SLOT(plot_epr()) );
    connect( this, SIGNAL(plot_epr_exp_signal()), this, SLOT(plot_epr_exp()) );
    connect( this, SIGNAL(show_states_signal()), this, SLOT(show_states()) );
    connect( this, SIGNAL(show_text_signal(QString)), this, SLOT(show_text(QString)) );
    connect( ui->classic_box, SIGNAL(textChanged()), this, SLOT(input_has_changed()) );
    connect( this, SIGNAL(set_operation_buttons_phi_complete_signal()), this, SLOT(set_operation_buttons()) );

    colour_list[0] = "#00BF00";
    colour_list[1] = "#0000FF";
    colour_list[2] = "#FF0000";
    colour_list[3] = "#00FFFF";
    colour_list[4] = "#FF00FF";
    colour_list[5] = "black";
    colour_list[6] = "#00FF00";
    colour_list[7] = "#0000BF";
    colour_list[8] = "#BF0000";
    colour_list[9] = "#00BFBF";
    colour_list[10] = "#BF00BF";
    colour_list[11] = "#BFBF00";
    colour_list[12] = "gray";

    //ui->mag_plot->setOpenGl(true);
    ui->mag_plot->setInteraction(QCP::iRangeDrag, true);
    ui->mag_plot->setInteraction(QCP::iRangeZoom, true);
    ui->mag_plot->xAxis->setLabel("Field (T)");
    ui->mag_plot->yAxis->setLabel("Magnetization (NA μB)");
    if(settings.value("MagXLog",0).toInt()==1){ui->mag_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mag_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MagYLog",0).toInt()==1){ui->mag_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mag_plot->yAxis->setScaleType(QCPAxis::stLinear);}

    //ui->redmag_plot->setOpenGl(true);
    ui->redmag_plot->setInteraction(QCP::iRangeDrag, true);
    ui->redmag_plot->setInteraction(QCP::iRangeZoom, true);
    ui->redmag_plot->xAxis->setLabel("Field/Temperature (T K⁻¹)");
    ui->redmag_plot->yAxis->setLabel("Magnetization (NA μB)");
    if(settings.value("RedmagXLog",0).toInt()==1){ui->redmag_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->redmag_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("RedmagYLog",0).toInt()==1){ui->redmag_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->redmag_plot->yAxis->setScaleType(QCPAxis::stLinear);}

    //ui->mce_plot->setOpenGl(true);
    ui->mce_plot->setInteraction(QCP::iRangeDrag, true);
    ui->mce_plot->setInteraction(QCP::iRangeZoom, true);
    ui->mce_plot->xAxis->setLabel("Temperature (K)");
    ui->mce_plot->yAxis->setLabel("-ΔS (J kg⁻¹ K⁻¹)");
    if(settings.value("MCEXLog",0).toInt()==1){ui->mce_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mce_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MCEYLog",0).toInt()==1){ui->mce_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mce_plot->yAxis->setScaleType(QCPAxis::stLinear);}

    //ui->heat_plot->setOpenGl(true);
    ui->heat_plot->setInteraction(QCP::iRangeDrag, true);
    ui->heat_plot->setInteraction(QCP::iRangeZoom, true);
    ui->heat_plot->xAxis->setLabel("Temperature (K)");
    ui->heat_plot->yAxis->setLabel("Cp (R)");
    if(settings.value("HeatXLog",1).toInt()==1){ui->heat_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->heat_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("HeatYLog",1).toInt()==1){ui->heat_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->heat_plot->yAxis->setScaleType(QCPAxis::stLinear);}

    //ui->sus_plot->setOpenGl(true);
    ui->sus_plot->setInteraction(QCP::iRangeDrag, true);
    ui->sus_plot->setInteraction(QCP::iRangeZoom, true);
    ui->sus_plot->xAxis->setLabel("Temperature (K)");
    ui->sus_plot->yAxis->setLabel("χT (cm³ mol⁻¹ K)");
    if(settings.value("SusXLog",0).toInt()==1){ui->sus_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->sus_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("SusYLog",0).toInt()==1){ui->sus_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->sus_plot->yAxis->setScaleType(QCPAxis::stLinear);}

    //ui->chi_plot->setOpenGl(true);
    ui->chi_plot->setInteraction(QCP::iRangeDrag, true);
    ui->chi_plot->setInteraction(QCP::iRangeZoom, true);
    ui->chi_plot->xAxis->setLabel("Temperature (K)");
    ui->chi_plot->yAxis->setLabel("χ (cm³ mol⁻¹)");
    if(settings.value("ChiXLog",0).toInt()==1){ui->chi_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->chi_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("ChiYLog",0).toInt()==1){ui->chi_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->chi_plot->yAxis->setScaleType(QCPAxis::stLinear);}

    //ui->invchi_plot->setOpenGl(true);
    ui->invchi_plot->setInteraction(QCP::iRangeDrag, true);
    ui->invchi_plot->setInteraction(QCP::iRangeZoom, true);
    ui->invchi_plot->xAxis->setLabel("Temperature (K)");
    ui->invchi_plot->yAxis->setLabel("1/χ (cm⁻³ mol)");
    if(settings.value("OneOnChiXLog",0).toInt()==1){ui->invchi_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->invchi_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("OneOnChiYLog",0).toInt()==1){ui->invchi_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->invchi_plot->yAxis->setScaleType(QCPAxis::stLinear);}

    //ui->zeeman_plot->setOpenGl(true);
    ui->zeeman_plot->setInteraction(QCP::iRangeDrag, true);
    ui->zeeman_plot->setInteraction(QCP::iRangeZoom, true);
    ui->zeeman_plot->xAxis->setLabel("Field (T)");
    ui->zeeman_plot->yAxis->setLabel("Energy (cm⁻¹)");

    //ui->epr_plot->setOpenGl(true);
    epr_zeeman_plot = new QCPAxisRect(ui->epr_plot,true);
    ui->epr_plot->setInteraction(QCP::iRangeDrag, true);
    ui->epr_plot->setInteraction(QCP::iRangeZoom, true);
    ui->epr_plot->xAxis->setLabel("Field (T)");
    ui->epr_plot->yAxis->setLabel("Intensity");
    ui->epr_slider->setVisible(false);
    epr_slider_available = false;
    ui->epr_slider->setMinimum(1);
    ui->epr_slider->setValue(1);
    epr_zee_dir = 1;
    epr_zee_dir_label = new QLabel(this);
    ui->epr_slider_layout->insertWidget(0,epr_zee_dir_label);
    epr_zee_dir_label->setText("");
    connect( ui->epr_slider, SIGNAL(valueChanged(int)), this,SLOT(new_epr_dir(int)) );
    epr_numF = 0;

    sus_data = new QVector<double>;
    sus_fields = new QVector<double>;
    sus_exp_data = new QVector<double>;
    mag_data = new QVector<double>;
    mag_temps = new QVector<double>;
    mag_exp_data = new QVector<double>;
    mce_data = new QVector<double>;
    mce_fields = new QVector<double>;
    mce_exp_data = new QVector<double>;
    heat_data = new QVector<double>;
    heat_fields = new QVector<double>;
    heat_exp_data = new QVector<double>;
    zeeman_data = new QVector<double>;
    epr_data = new QVector<double>;
    epr_freqs = new QVector<double>;
    epr_temps = new QVector<double>;
    epr_exp_data = new QVector<double>;
    epr_zee_data = new QVector<double>;
    epr_dirs = new QVector<double>;
    epr_trans_data = new QVector<double>;

    StatusLabel = new QLabel(this);
    ProgressBar = new QProgressBar(this);
    ui->statusBar->addPermanentWidget(StatusLabel);
    ui->statusBar->addPermanentWidget(ProgressBar,1);
    StatusLabel->setText("Idle");
    ProgressBar->setMinimum(0);
    ProgressBar->setMaximum(100);
    ProgressBar->setValue(0);
    ui->output_box->setReadOnly(true);
    ui->states_box->setReadOnly(true);
    ui->states_box->setLineWrapMode(QPlainTextEdit::NoWrap);
    connect(this,SIGNAL(progress_bar_signal()),SLOT(update_progress()));

    ui->LR_splitter->setStyleSheet("QSplitter::handle:horizontal{border: 1px solid darkGray;width: 4px;margin-top: 2px;margin-bottom: 2px;}");
    ui->TB_splitter->setStyleSheet("QSplitter::handle:vertical{border: 1px solid darkGray;height: 2px;margin-left: 2px;margin-right: 2px;}");

    ui->wizard_button->setChecked(true);
    classic_mode = false;
    ui->classic_scroll->hide();
    ui->sim_button->setChecked(true);
    opmode = "sim";
    input_modified = false;
    wd_selected = false;
    plotting = false;
    phi_running = false;

    ui->LR_splitter->setStretchFactor(0, 0);
    ui->LR_splitter->setStretchFactor(1, 1);
    ui->TB_splitter->setStretchFactor(0, 1);
    ui->TB_splitter->setStretchFactor(1, 0);
    QList<int> sizes;
    sizes << 100 << 300;
    ui->TB_splitter->setSizes(sizes);

    new_site_button = new QPushButton();
    new_site_button->setText("New Site");
    //connect(this->new_site_button,SIGNAL(clicked()),this,SLOT(on_new_site_button_clicked()));
    ui->sites_layout->addWidget(new_site_button,1,Qt::AlignTop|Qt::AlignCenter);
    num_sites = 0;
    num_added_sites = 0;

    new_interaction_button = new QPushButton();
    new_interaction_button->setText("New Interaction");
    //connect(this->new_interaction_button,SIGNAL(clicked()),this,SLOT(on_new_interaction_button_clicked()));
    connect(this->new_interaction_button,SIGNAL(clicked()),this,SLOT(move_interaction_button()));
    interaction_headings = new QHBoxLayout;
    site_a_label = new QLabel;
    site_b_label = new QLabel;
    type_label = new QLabel;
    value_label = new QLabel;
    remove_label = new QLabel;
    site_a_label->setText("Site A");
    site_b_label->setText("Site B");
    type_label->setText("Type");
    value_label->setText("Value(s)");
    remove_label->setText("Remove");
    ui->interactions_grid->addWidget(site_a_label,0,0,1,1,Qt::AlignTop|Qt::AlignCenter);
    ui->interactions_grid->addWidget(site_b_label,0,1,1,1,Qt::AlignTop|Qt::AlignCenter);
    ui->interactions_grid->addWidget(type_label,0,2,1,1,Qt::AlignTop|Qt::AlignCenter);
    ui->interactions_grid->addWidget(value_label,0,3,1,1,Qt::AlignTop|Qt::AlignCenter);
    ui->interactions_grid->addWidget(remove_label,0,4,1,1,Qt::AlignTop|Qt::AlignCenter);
    ui->interactions_grid->addWidget(new_interaction_button,1,2,1,1,Qt::AlignTop|Qt::AlignCenter);
    num_interactions = 0;

    this->check_new_version();
    this->check_nfc_message();

    //HIDING WIZARD MODE
    MainWindow::on_classic_button_clicked();
    //ui->horizontalLayout_3->removeWidget(ui->mode_group_box);
    ui->mode_group_box->setVisible(false);
    ui->wizard_button->setChecked(false);
    ui->classic_button->setChecked(true);
    classic_mode = true;
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::closeEvent (QCloseEvent *event)
{
    if(phi_running)
    {
        if (MainWindow::ask_to_abort())
        {
            QSettings settings;
            if(this->windowState() == Qt::WindowMaximized)
            {
                settings.setValue("window_maximised",1);
            }
            else
            {
                settings.setValue("window_maximised",0);
            }
            settings.setValue("window_width",this->size().width());
            settings.setValue("window_height",this->size().height());
            settings.setValue("window_x",this->geometry().x());
            settings.setValue("window_y",this->geometry().y());
            settings.setValue("plot_tab",ui->tabWidget->currentIndex());
            settings.setValue("wd_path",cwd);
            settings.setValue("splitter", ui->LR_splitter->saveState());
            event->accept();
        }
        else
        {
            event->ignore();
        }
    }
    else if(input_modified)
    {
        int response = MainWindow::ask_to_save();
        if (response == QMessageBox::Save)
        {
            if(MainWindow::saveFile())
            {
                QSettings settings;
                if(this->windowState() == Qt::WindowMaximized)
                {
                    settings.setValue("window_maximised",1);
                }
                else
                {
                    settings.setValue("window_maximised",0);
                }
                settings.setValue("window_width",this->size().width());
                settings.setValue("window_height",this->size().height());
                settings.setValue("window_x",this->geometry().x());
                settings.setValue("window_y",this->geometry().y());
                settings.setValue("plot_tab",ui->tabWidget->currentIndex());
                settings.setValue("wd_path",cwd);
                settings.setValue("splitter", ui->LR_splitter->saveState());
                event->accept();
            }
            else
            {
                event->ignore();
            }
        }
        else if (response == QMessageBox::Discard)
        {
            QSettings settings;
            if(this->windowState() == Qt::WindowMaximized)
            {
                settings.setValue("window_maximised",1);
            }
            else
            {
                settings.setValue("window_maximised",0);
            }
            settings.setValue("window_width",this->size().width());
            settings.setValue("window_height",this->size().height());
            settings.setValue("window_x",this->geometry().x());
            settings.setValue("window_y",this->geometry().y());
            settings.setValue("plot_tab",ui->tabWidget->currentIndex());
            settings.setValue("wd_path",cwd);
            settings.setValue("splitter", ui->LR_splitter->saveState());
            event->accept();
        }
        else if (response == QMessageBox::Cancel)
        {
            event->ignore();
        }
    }
    else
    {
        QSettings settings;
        if(this->windowState() == Qt::WindowMaximized)
        {
            settings.setValue("window_maximised",1);
        }
        else
        {
            settings.setValue("window_maximised",0);
        }
        settings.setValue("window_width",this->size().width());
        settings.setValue("window_height",this->size().height());
        settings.setValue("window_x",this->geometry().x());
        settings.setValue("window_y",this->geometry().y());
        settings.setValue("plot_tab",ui->tabWidget->currentIndex());
        settings.setValue("wd_path",cwd);
        settings.setValue("splitter", ui->LR_splitter->saveState());
        event->accept();
    }
}

bool MainWindow::ask_to_abort()
{
    QMessageBox::StandardButton answer = QMessageBox::question(
        this,
        tr("Abort PHI?"),
        tr("PHI is running, do you wish to abort?"),
        QMessageBox::Yes | QMessageBox::No,
        QMessageBox::No
    );
    return answer == QMessageBox::Yes;
}

int MainWindow::ask_to_save()
{
    int ret = QMessageBox::question(
        this,
        tr("Save input?"),
        tr("Input has been modified.\nDo you wish to save?"),
        QMessageBox::Save | QMessageBox::Discard | QMessageBox::Cancel,
        QMessageBox::Save
    );
    //QTextStream out(stdout);
    //out << QString::number(ret) << endl;

    return ret;

    /*QMessageBox msgBox;
    msgBox.setText("Save input?");
    msgBox.setInformativeText("Input has been modified.\nDo you wish to save?");
    msgBox.setStandardButtons(QMessageBox::Save | QMessageBox::Discard | QMessageBox::Cancel);
    msgBox.setDefaultButton(QMessageBox::Save);
    return msgBox.exec();*/


}

void MainWindow::NetworkReplyFinished(QNetworkReply* Reply)
{
    if(Reply->error()==QNetworkReply::NoError)
    {
        QByteArray data=Reply->readAll();
        QString str(data);

        available_version = str.simplified();

        if(current_version != available_version)
        {
            QString message = "New version of PHI v"+available_version+" available!";
            QMessageBox::warning(
                this,
                tr("New version avavilable!"),
                message,
                QMessageBox::Close,
                QMessageBox::Close
            );
        }
        else if(ask_for_update)
        {
            QString message = "You are using the latest version of PHI!";
            QMessageBox::warning(
                this,
                tr("No updates avavilable!"),
                message,
                QMessageBox::Close,
                QMessageBox::Close
            );
            ask_for_update = false;
        }
    }

}

void MainWindow::NetworkReplyFinishedNFC(QNetworkReply* Reply)
{
    if(Reply->error()==QNetworkReply::NoError)
    {
        QByteArray data=Reply->readAll();
        QString str(data);

        if(str.size() > 0)
        {
            /*QMessageBox::information(
                this,
                tr("News"),
                str,
                QMessageBox::Close,
                QMessageBox::Close
            );*/
            QMessageBox msg;
            msg.setIcon(QMessageBox::Information);
            msg.setInformativeText(str);
            //msg.setStyleSheet("QLabel{min-width: 300px;}");
            msg.setStandardButtons(QMessageBox::Close);
            msg.setDefaultButton(QMessageBox::Close);
            int ret = msg.exec();
        }
    }

}

void MainWindow::open_settings()
{
    SettingsWindow settings_window;
    connect(&settings_window,SIGNAL(saved()),this,SLOT(update_prefs()));
    settings_window.setModal(true);
    settings_window.exec();
}

void MainWindow::open_about()
{
    QMessageBox msgBox;
    QPixmap pixmap(":/images/about_icon.png");
    pixmap = pixmap.scaledToHeight(50);
    msgBox.setText("PHI version 3.1.6\nN. F. Chilton\nwww.nfchilton.com/phi");
    msgBox.setModal(true);
    msgBox.setIconPixmap(pixmap);
    msgBox.exec();
}

void MainWindow::file_not_there()
{
    QMessageBox msgBox;
    msgBox.setText("These are not the droids you are looking for...\n\n\n\n(The file you are trying to open does not exist)");
    msgBox.setModal(true);
    msgBox.setIcon(QMessageBox::Warning);
    msgBox.exec();
}

void MainWindow::input_has_changed()
{
    input_modified = true;
}

void MainWindow::copy_res_to_exp()
{
    if(wd_selected && !jobname.isEmpty())
    {
        QFile res_file,exp_file;
        QMessageBox::StandardButton reply;
        reply = QMessageBox::question(this, "Copy .res to .exp?", "Copy .res files to .exp files?\n\nThis will overwrite existing .exp files and cannot be undone.",QMessageBox::Yes|QMessageBox::No,QMessageBox::No);
        if (reply == QMessageBox::Yes)
        {
            res_file.setFileName(cwd+"/"+jobname+"_sus.res");
            exp_file.setFileName(cwd+"/"+jobname+"_sus.exp");
            if(res_file.exists()){exp_file.remove(); res_file.rename(cwd+"/"+jobname+"_sus.exp");}
            res_file.setFileName(cwd+"/"+jobname+"_mag.res");
            exp_file.setFileName(cwd+"/"+jobname+"_mag.exp");
            if(res_file.exists()){exp_file.remove(); res_file.rename(cwd+"/"+jobname+"_mag.exp");}
            res_file.setFileName(cwd+"/"+jobname+"_mce.res");
            exp_file.setFileName(cwd+"/"+jobname+"_mce.exp");
            if(res_file.exists()){exp_file.remove(); res_file.rename(cwd+"/"+jobname+"_mce.exp");}
            res_file.setFileName(cwd+"/"+jobname+"_heat.res");
            exp_file.setFileName(cwd+"/"+jobname+"_heat.exp");
            if(res_file.exists()){exp_file.remove(); res_file.rename(cwd+"/"+jobname+"_heat.exp");}
            res_file.setFileName(cwd+"/"+jobname+"_epr.res");
            exp_file.setFileName(cwd+"/"+jobname+"_epr.exp");
            if(res_file.exists()){exp_file.remove(); res_file.rename(cwd+"/"+jobname+"_epr.exp");}
            res_file.setFileName(cwd+"/"+jobname+"_levels.res");
            exp_file.setFileName(cwd+"/"+jobname+"_levels.exp");
            if(res_file.exists()){exp_file.remove(); res_file.rename(cwd+"/"+jobname+"_levels.exp");}
            res_file.setFileName(cwd+"/"+jobname+"_G.res");
            exp_file.setFileName(cwd+"/"+jobname+"_G.exp");
            if(res_file.exists()){exp_file.remove(); res_file.rename(cwd+"/"+jobname+"_G.exp");}
        }
    }
}

void MainWindow::newFile()
{
    if(phi_running)
    {
        if (MainWindow::ask_to_abort())
        {
            MainWindow::stop_task();
            MainWindow::make_new_file();
        }
        else
        {
            return;
        }
    }
    else if(input_modified)
    {
        int response = MainWindow::ask_to_save();
        if (response == QMessageBox::Save)
        {
            if(MainWindow::saveFile())
            {
                MainWindow::make_new_file();
            }
            else
            {
                return;
            }
        }
        else if(response == QMessageBox::Discard)
        {
            MainWindow::make_new_file();
        }
        else if(response == QMessageBox::Cancel)
        {
            return;
        }
    }
    else
    {
        this->make_new_file();
    }
}

void MainWindow::make_new_file()
{
    ui->classic_box->clear();
    //ui->cwd_label->clear();
    wd_selected = false;
    //cwd = "";
    jobname = "";
    epr_numF = 0;
    this->setWindowTitle(QString::fromUtf8("PHI"));

    ui->output_box->clear();
    ui->states_box->clear();

    ui->mag_plot->clearGraphs();
    ui->redmag_plot->clearGraphs();
    ui->mce_plot->clearGraphs();
    ui->heat_plot->clearGraphs();
    ui->sus_plot->clearGraphs();
    ui->chi_plot->clearGraphs();
    ui->invchi_plot->clearGraphs();
    ui->zeeman_plot->clearGraphs();
    ui->epr_plot->clearGraphs();

    ui->mag_plot->replot();
    ui->redmag_plot->replot();
    ui->mce_plot->replot();
    ui->heat_plot->replot();
    ui->sus_plot->replot();
    ui->chi_plot->replot();
    ui->invchi_plot->replot();
    ui->zeeman_plot->replot();
    ui->epr_plot->replot();

    this->clear_data();
    plotting = false;
    input_modified = false;
}

void MainWindow::openFile()
{
    if(return_all){return;}
    if(phi_running)
    {
        if (MainWindow::ask_to_abort())
        {
            MainWindow::stop_task();
            MainWindow::choose_file();
        }
        else
        {
            return;
        }
    }
    else if(input_modified)
    {
        int response = MainWindow::ask_to_save();
        if (response == QMessageBox::Save)
        {
            if(MainWindow::saveFile())
            {
                MainWindow::choose_file();
            }
            else
            {
                return;
            }
        }
        else if (response == QMessageBox::Discard)
        {
            MainWindow::choose_file();
        }
        else if (response == QMessageBox::Cancel)
        {
            return;
        }
    }
    else
    {
        this->choose_file();
    }

}

void MainWindow::choose_file()
{
    QString fname,path;
    fname = QFileDialog::getOpenFileName(this,tr("Open Input File"), cwd, tr("PHI Input Files (*.input)"));
    QFile file;
    file.setFileName(fname);
    if(!file.open(QIODevice::ReadWrite | QIODevice::Text))
                        //THROW ERROR
        return;
    QTextStream content(&file);
    ui->classic_box->setPlainText(content.readAll());
    epr_numF = 0;
    path = QFileInfo(file).dir().path();
    ui->cwd_label->setText(path);
    while(ui->cwd_label->width() < QFontMetrics(ui->cwd_label->font()).boundingRect(QString(ui->cwd_label->text())).width())
    {
        path = path.right(path.length()-1);
        ui->cwd_label->setText(path);
    }
    wd_selected = true;
    cwd = QFileInfo(file).dir().path();
    jobname = QFileInfo(file).fileName();
    jobname.chop(6);
    file.close();
    this->setWindowTitle(QString::fromUtf8("PHI - ")+jobname);
    this->setCurrentFile(fname);

    ui->output_box->clear();
    ui->states_box->clear();

    ui->mag_plot->clearGraphs();
    ui->redmag_plot->clearGraphs();
    ui->mce_plot->clearGraphs();
    ui->heat_plot->clearGraphs();
    ui->sus_plot->clearGraphs();
    ui->chi_plot->clearGraphs();
    ui->invchi_plot->clearGraphs();
    ui->zeeman_plot->clearGraphs();
    ui->epr_plot->clearGraphs();

    ui->mag_plot->replot();
    ui->redmag_plot->replot();
    ui->mce_plot->replot();
    ui->heat_plot->replot();
    ui->sus_plot->replot();
    ui->chi_plot->replot();
    ui->invchi_plot->replot();
    ui->zeeman_plot->replot();
    ui->epr_plot->replot();

    this->clear_data();
    plotting = false;
    input_modified = false;
}

void MainWindow::loadFile(QString fname)
{
    QString path;
    QFile file;
    file.setFileName(fname);
    if(!file.exists())
    {
        this->file_not_there();
        return;
    }
    if(!file.open(QIODevice::ReadWrite | QIODevice::Text))
    {
        this->file_not_there();
        return;
    }
    QTextStream content(&file);
    ui->classic_box->setPlainText(content.readAll());
    epr_numF = 0;
    path = QFileInfo(file).dir().path();
    ui->cwd_label->setText(path);
    while(ui->cwd_label->width() < QFontMetrics(ui->cwd_label->font()).boundingRect(QString(ui->cwd_label->text())).width())
    {
        path = path.right(path.length()-1);
        ui->cwd_label->setText(path);
    }
    wd_selected = true;
    cwd = QFileInfo(file).dir().path();
    jobname = QFileInfo(file).fileName();
    jobname.chop(6);
    file.close();
    this->setWindowTitle(QString::fromUtf8("PHI - ")+jobname);
    this->setCurrentFile(fname);

    ui->output_box->clear();
    ui->states_box->clear();

    ui->mag_plot->clearGraphs();
    ui->redmag_plot->clearGraphs();
    ui->mce_plot->clearGraphs();
    ui->heat_plot->clearGraphs();
    ui->sus_plot->clearGraphs();
    ui->chi_plot->clearGraphs();
    ui->invchi_plot->clearGraphs();
    ui->zeeman_plot->clearGraphs();
    ui->epr_plot->clearGraphs();

    ui->mag_plot->replot();
    ui->redmag_plot->replot();
    ui->mce_plot->replot();
    ui->heat_plot->replot();
    ui->sus_plot->replot();
    ui->chi_plot->replot();
    ui->invchi_plot->replot();
    ui->zeeman_plot->replot();
    ui->epr_plot->replot();

    this->clear_data();
    plotting = false;
    input_modified = false;
}

bool MainWindow::saveFile()
{
    QFile file;
    QString path;
    if(!wd_selected)
    {
        QString filename = QFileDialog::getSaveFileName(this,tr("Save Input File"), "", tr("PHI Input Files (*.input)"));
        if(!filename.isEmpty() && !filename.isNull()){
#ifdef Q_OS_LINUX
            filename = filename+".input";
#endif
            if(filename.indexOf(".input.input") > -1)
            {
                filename.chop(6);
            }
            file.setFileName(filename);
            this->setCurrentFile(filename);
            file.remove();
            path = QFileInfo(file).dir().path();
            ui->cwd_label->setText(path);
            while(ui->cwd_label->width() < QFontMetrics(ui->cwd_label->font()).boundingRect(QString(ui->cwd_label->text())).width())
            {
                path = path.right(path.length()-1);
                ui->cwd_label->setText(path);
            }
            wd_selected = true;
            cwd = QFileInfo(file).dir().path();
            jobname = QFileInfo(file).fileName();
            jobname.chop(6);
            this->setWindowTitle(QString::fromUtf8("PHI - ")+jobname);
        }
        else
        {
            return false;
        }
    }
    else
    {
        file.setFileName(cwd+"/"+jobname+".input");
        file.remove();
    }
    if (file.open(QIODevice::ReadWrite))
    {
        QTextStream stream(&file);
        stream << ui->classic_box->toPlainText();
        file.flush();
        file.close();
        input_modified = false;
    }
    else
    {
        //THROW ERROR
        return true;
    }
    return true;
}

void MainWindow::saveAsFile()
{
    if(return_all){return;}
    QFile file;
    QString fname,path;
    fname = QFileDialog::getSaveFileName(this,tr("Save Input File As"), cwd, tr("PHI Input Files (*.input)"));
#ifdef Q_OS_LINUX
    fname = fname+".input";
#endif
    if(fname.indexOf(".input.input") > -1)
    {
        fname.chop(6);
    }
    file.setFileName(fname);
    this->setCurrentFile(fname);
    file.remove();
    if(file.open(QIODevice::ReadWrite))
    {
        QTextStream stream(&file);
        stream << ui->classic_box->toPlainText();
        file.flush();
        path = QFileInfo(file).dir().path();
        ui->cwd_label->setText(path);
        while(ui->cwd_label->width() < QFontMetrics(ui->cwd_label->font()).boundingRect(QString(ui->cwd_label->text())).width())
        {
            path = path.right(path.length()-1);
            ui->cwd_label->setText(path);
        }
        wd_selected = true;
        cwd = QFileInfo(file).dir().path();
        jobname = QFileInfo(file).fileName();
        jobname.chop(6);
        file.close();
        this->setWindowTitle(QString::fromUtf8("PHI - ")+jobname);
        input_modified = false;
    }
    else
                          //THROW ERROR
        return;
}

void MainWindow::genReport()
{
    if(return_all){return;}
    if(!phi_running && wd_selected && !jobname.isEmpty() && !ui->classic_box->toPlainText().isEmpty())
    {
        QString html = "<h2 align=left>PHI report - "+jobname+"_"+report_input->text()+"</h2><h3>Input:</h3><p>",temp = ui->output_box->toPlainText(),temp2=Qt::convertFromPlainText(ui->classic_box->toPlainText());
        QStringList lines = ui->classic_box->toPlainText().split('\n', QString::SkipEmptyParts);
        for(int i=0;i<lines.size();i++)
        {
            lines[i] = lines.at(i).toLower();
        }
        int loc;
        loc = temp2.indexOf("****end")+7;
        html = html + temp2.left(loc) + "</p>";
        if(opmode == "fit")
        {
            html = html + "<h3>Output:</h3><p>";
            QString temp = ui->output_box->toPlainText();
            int start,end;
            if(temp.indexOf("Residual reduced by") > -1)
            {
                end = temp.length()-217;
                start = temp.lastIndexOf("=",-280)-43;
            }
            else
            {
                end = temp.length();
                start = temp.lastIndexOf("=",-50)-43;
            }
            html = html+Qt::convertFromPlainText(temp.mid(start,end-start))+"</p>";
        }
        if(opmode == "sim")
        {
            for(int i=0;i<lines.size();i++)
            {
                if(lines.at(i).indexOf("opmode") > -1 && lines.at(i).split(' ', QString::SkipEmptyParts).at(2).indexOf("l") > -1)
                {
                    temp = ui->states_box->toPlainText();
                    loc = temp.count("\\n");
                    //std::cout << "lines " << loc << std::endl;
                    html = html + "<h3>States:</h3><p>" + Qt::convertFromPlainText(temp) + "</p>";
                    break;
                }
            }
        }
        for(int i=0;i<lines.size();i++)
        {
            if(lines.at(i).indexOf("opmode") > -1 && (lines.at(i).indexOf("sim") > -1 || lines.at(i).indexOf("sur") > -1 || lines.at(i).indexOf("fit") > -1))
            {
                if(lines.at(i).split(' ', QString::SkipEmptyParts).at(2).indexOf("s") > -1)
                {
                    html = html+"<h3>Susceptibility:</h3><br>";
                    ui->sus_plot->savePng(cwd+"/"+jobname+"_sus.png",460,345,3.0,6);
                    ui->chi_plot->savePng(cwd+"/"+jobname+"_chi.png",460,345,3.0,6);
                    ui->invchi_plot->savePng(cwd+"/"+jobname+"_invchi.png",460,345,3.0,6);
                    html = html+"<img src=\""+cwd+"/"+jobname+"_sus.png\" width=\"460\" height=\"345\" align=center>";
                    html = html+"<img src=\""+cwd+"/"+jobname+"_chi.png\" width=\"460\" height=\"345\" align=center>";
                    html = html+"<img src=\""+cwd+"/"+jobname+"_invchi.png\" width=\"460\" height=\"345\" align=center>";
                }
                if(lines.at(i).split(' ', QString::SkipEmptyParts).at(2).indexOf("m") > -1)
                {
                    html = html+"<h3>Magnetization:</h3><br>";
                    ui->mag_plot->savePng(cwd+"/"+jobname+"_mag.png",460,345,3.0,6);
                    ui->redmag_plot->savePng(cwd+"/"+jobname+"_redmag.png",460,345,3.0,6);
                    html = html+"<img src=\""+cwd+"/"+jobname+"_mag.png\" width=\"460\" height=\"345\" align=center>";
                    html = html+"<img src=\""+cwd+"/"+jobname+"_redmag.png\" width=\"460\" height=\"345\" align=center>";
                }
                if(lines.at(i).split(' ', QString::SkipEmptyParts).at(2).indexOf("c") > -1)
                {
                    html = html+"<h3>Magnetocaloric Effect:</h3><br>";
                    ui->mce_plot->savePng(cwd+"/"+jobname+"_mce.png",460,345,3.0,6);
                    html = html+"<img src=\""+cwd+"/"+jobname+"_mce.png\" width=\"460\" height=\"345\" align=center>";
                }
                if(lines.at(i).split(' ', QString::SkipEmptyParts).at(2).indexOf("h") > -1)
                {
                    html = html+"<h3>Heat Capacity:</h3><br>";
                    ui->heat_plot->savePng(cwd+"/"+jobname+"_heat.png",460,345,3.0,6);
                    html = html+"<img src=\""+cwd+"/"+jobname+"_heat.png\" width=\"460\" height=\"345\" align=center>";
                }
                if(lines.at(i).split(' ', QString::SkipEmptyParts).at(2).indexOf("e") > -1)
                {
                    html = html+"<h3>EPR:</h3><br>";
                    ui->epr_plot->savePng(cwd+"/"+jobname+"_epr.png",460,345,3.0,6);
                    html = html+"<img src=\""+cwd+"/"+jobname+"_epr.png\" width=\"460\" height=\"345\" align=center>";
                }
                if(lines.at(i).split(' ', QString::SkipEmptyParts).at(2).indexOf("z") > -1)
                {
                    html = html+"<h3>Zeeman Effect:</h3><br>";
                    ui->zeeman_plot->savePng(cwd+"/"+jobname+"_zeeman.png",460,345,3.0,6);
                    html = html+"<img src=\""+cwd+"/"+jobname+"_zeeman.png\" width=\"460\" height=\"345\" align=center>";
                }
            }
        }

        QTextDocument document;
        document.setHtml(html);
        QPrinter printer(QPrinter::PrinterResolution);
        printer.setOutputFormat(QPrinter::PdfFormat);
        printer.setPaperSize(QPrinter::A4);
        printer.setOutputFileName(cwd+"/"+jobname+"_"+report_input->text()+".pdf");
        printer.setPageMargins(QMarginsF(12, 12, 12, 12));
        QFont repfont = fixedFont;
        repfont.setPointSize(10);
        document.setDefaultFont(repfont);
        document.print(&printer);

        QFile file(cwd+"/"+jobname+"_sus.png");
        file.remove();
        file.setFileName(cwd+"/"+jobname+"_chi.png");
        file.remove();
        file.setFileName(cwd+"/"+jobname+"_invchi.png");
        file.remove();
        file.setFileName(cwd+"/"+jobname+"_mag.png");
        file.remove();
        file.setFileName(cwd+"/"+jobname+"_redmag.png");
        file.remove();
        file.setFileName(cwd+"/"+jobname+"_mce.png");
        file.remove();
        file.setFileName(cwd+"/"+jobname+"_heat.png");
        file.remove();
        file.setFileName(cwd+"/"+jobname+"_epr.png");
        file.remove();
        file.setFileName(cwd+"/"+jobname+"_zeeman.png");
        file.remove();
    }
}

void MainWindow::report_start()
{
    if(return_all){return;}
    report_dialog = new QDialog;
    report_Vlayout = new QVBoxLayout;
    report_Hlayout = new QHBoxLayout;
    report_label1 = new QLabel;
    report_label2 = new QLabel;
    report_label3 = new QLabel;
    report_button = new QPushButton;
    report_input = new QLineEdit;
    report_label1->setText("Please choose a name for the report file:");
    report_label2->setText(jobname+"_");
    report_label3->setText(".pdf");
    report_button->setText("Save");
    connect(report_button, SIGNAL(clicked()),report_dialog, SLOT(close()));
    connect(report_button, SIGNAL(clicked()),this, SLOT(genReport()));
    report_Hlayout->addWidget(report_label2,0,Qt::AlignCenter);
    report_Hlayout->addWidget(report_input,0,Qt::AlignCenter);
    report_Hlayout->addWidget(report_label3,0,Qt::AlignCenter);
    report_Vlayout->addWidget(report_label1,0,Qt::AlignCenter);
    report_Vlayout->addLayout(report_Hlayout,0);
    report_Vlayout->addWidget(report_button,0,Qt::AlignCenter);
    report_dialog->setLayout(report_Vlayout);
    Qt::WindowFlags flags = 0;
    flags |= Qt::WindowStaysOnTopHint;
    report_dialog->setWindowFlags(flags);
    report_dialog->setWindowTitle("Save report");
    report_dialog->show();
}

void MainWindow::save_pdfs()
{
    if(return_all){return;}
    if(ui->sus_plot->plottableCount() > 0) {ui->sus_plot->savePdf(cwd+"/"+jobname+"_sus.pdf",640,480);}
    if(ui->mag_plot->plottableCount() > 0) {ui->mag_plot->savePdf(cwd+"/"+jobname+"_mag.pdf",640,480);}
    if(ui->redmag_plot->plottableCount() > 0) {ui->redmag_plot->savePdf(cwd+"/"+jobname+"_redmag.pdf",640,480);}
    if(ui->mce_plot->plottableCount() > 0) {ui->mce_plot->savePdf(cwd+"/"+jobname+"_mce.pdf",640,480);}
    if(ui->heat_plot->plottableCount() > 0) {ui->heat_plot->savePdf(cwd+"/"+jobname+"_heat.pdf",640,480);}
    if(ui->chi_plot->plottableCount() > 0) {ui->chi_plot->savePdf(cwd+"/"+jobname+"_chi.pdf",640,480);}
    if(ui->invchi_plot->plottableCount() > 0) {ui->invchi_plot->savePdf(cwd+"/"+jobname+"_invchi.pdf",640,480);}
    if(ui->zeeman_plot->plottableCount() > 0) {ui->zeeman_plot->savePdf(cwd+"/"+jobname+"_zeeman.pdf",640,480);}
    if(ui->epr_plot->plottableCount() > 0) {ui->epr_plot->savePdf(cwd+"/"+jobname+"_epr.pdf",640,480);}
}

void MainWindow::createActions()
{
    //---- File -> New ----//
    newAction = new QAction(tr("&New"), this);
    newAction->setShortcut(QKeySequence::New);
    connect(newAction, SIGNAL(triggered()), this, SLOT(newFile()));
    //---- File -> Open ----//
    openAction = new QAction(tr("&Open"), this);
    openAction->setShortcut(QKeySequence::Open);
    connect(openAction, SIGNAL(triggered()), this, SLOT(openFile()));
    //---- File -> Save ----//
    saveAction = new QAction(tr("&Save"), this);
    saveAction->setShortcut(QKeySequence::Save);
    connect(saveAction, SIGNAL(triggered()), this, SLOT(saveFile()));
    //---- File -> Save As ----//
    saveAsAction = new QAction(tr("Save &as"), this);
    saveAsAction->setShortcut(tr("Ctrl+Shift+S"));                                                         //TEST FOR MAC OS!
    connect(saveAsAction, SIGNAL(triggered()), this, SLOT(saveAsFile()));
    //---- File -> Recent ----//
    for (int i = 0; i < MaxRecentFiles; ++i)
    {
        recentFileActions[i] = new QAction(this);
        recentFileActions[i]->setVisible(false);
        connect(recentFileActions[i], SIGNAL(triggered()),this, SLOT(openRecentFile()));
    }
    //---- File -> Exit ----//
    exitAction = new QAction(tr("E&xit"), this);
    exitAction->setShortcut(tr("Ctrl+Q"));                                                                 //TEST FOR MAC OS!
    connect(exitAction, SIGNAL(triggered()), this, SLOT(close()));

    //---- Operation -> Start ----//
    startAction = new QAction(tr("&Start"), this);
    startAction->setShortcut(tr("F5"));
    connect(startAction, SIGNAL(triggered()), this, SLOT(start_task()));

    //---- Operation -> Stop ----//
    stopAction = new QAction(tr("S&top"), this);
    stopAction->setShortcut(tr("Esc"));
    connect(stopAction, SIGNAL(triggered()), this, SLOT(stop_task()));

    //---- Tools -> Save PDFs ----//
    savePDFaction = new QAction(tr("Save &plots"), this);
    savePDFaction->setShortcut(tr("Ctrl+P"));
    connect(savePDFaction, SIGNAL(triggered()), this, SLOT(save_pdfs()));

    //---- Tools -> Report ----//
    reportAction = new QAction(tr("Save &report"), this);
    reportAction->setShortcut(tr("Ctrl+R"));
    connect(reportAction, SIGNAL(triggered()), this, SLOT(report_start()));

    //---- Tools -> ResToExp ----//
    ResToExpAction = new QAction(tr("&Copy .res to .exp"), this);
    connect(ResToExpAction, SIGNAL(triggered()), this, SLOT(copy_res_to_exp()));

    //---- Tools -> Check for Updates ----//
    updateAction = new QAction(tr("Check for &updates"), this);
    updateAction->setShortcut(tr("Ctrl+U"));
    connect(updateAction, SIGNAL(triggered()), this, SLOT(check_new_version()));
    connect(updateAction, SIGNAL(triggered()), this, SLOT(update_response_required()));

    //---- Tools -> Settings ----//
    settingsAction = new QAction(tr("Preferences"), this);
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(open_settings()));

    //---- Tools -> About PHI ----//
    aboutAction = new QAction(tr("About PHI"), this);
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(open_about()));
}

void MainWindow::openRecentFile()
{
    if(return_all){return;}
    QAction *action = qobject_cast<QAction *>(sender());
    if (action)
    {
        if(phi_running)
        {
            if (MainWindow::ask_to_abort())
            {
                MainWindow::stop_task();
                MainWindow::loadFile(action->data().toString());
            }
            else
            {
                return;
            }
        }
        else if(input_modified)
        {
            int response = MainWindow::ask_to_save();
            if (response == QMessageBox::Save)
            {
                if(MainWindow::saveFile())
                {
                    MainWindow::loadFile(action->data().toString());
                }
                else
                {
                    return;
                }
            }
            else if (response == QMessageBox::Discard)
            {
                MainWindow::loadFile(action->data().toString());
            }
            else if (response == QMessageBox::Cancel)
            {
                return;
            }
        }
        else
        {
            this->loadFile(action->data().toString());
        }
    }
}

void MainWindow::setCurrentFile(const QString &fileName)
{
    QSettings settings;
    QStringList files = settings.value("recentFileList").toStringList();
    files.removeAll(fileName);
    files.prepend(fileName);
    while (files.size() > MaxRecentFiles)
        files.removeLast();

    settings.setValue("recentFileList", files);

    foreach (QWidget *widget, QApplication::topLevelWidgets()) {
        MainWindow *mainWin = qobject_cast<MainWindow *>(widget);
        if (mainWin)
            mainWin->updateRecentFileActions();
    }
}

void MainWindow::updateRecentFileActions()
{
    QSettings settings;
    QStringList files = settings.value("recentFileList").toStringList();

    int numRecentFiles = qMin(files.size(), (int)MaxRecentFiles);

    for (int i = 0; i < numRecentFiles; ++i) {
        QString text = tr("&%1 %2").arg(i + 1).arg(strippedName(files[i]));
        recentFileActions[i]->setText(text);
        recentFileActions[i]->setData(files[i]);
        recentFileActions[i]->setVisible(true);
    }
    for (int j = numRecentFiles; j < MaxRecentFiles; ++j)
        recentFileActions[j]->setVisible(false);

    separatorAction->setVisible(numRecentFiles > 0);
}

QString MainWindow::strippedName(const QString &fullFileName)
{
    return QFileInfo(fullFileName).fileName();
}

void MainWindow::createMenus()
{
    fileMenu = menuBar()->addMenu(tr("&File"));
    fileMenu->addAction(newAction);
    fileMenu->addAction(openAction);
    fileMenu->addAction(saveAction);
    fileMenu->addAction(saveAsAction);
    separatorAction = fileMenu->addSeparator();
    for (int i = 0; i < MaxRecentFiles; ++i)
        fileMenu->addAction(recentFileActions[i]);
    fileMenu->addSeparator();
    fileMenu->addAction(exitAction);

    operationMenu = menuBar()->addMenu(tr("&Operation"));
    operationMenu->addAction(startAction);
    operationMenu->addAction(stopAction);

    toolsMenu = menuBar()->addMenu(tr("&Tools"));
    toolsMenu->addAction(savePDFaction);
    toolsMenu->addAction(reportAction);
    toolsMenu->addAction(ResToExpAction);
    toolsMenu->addAction(updateAction);
    toolsMenu->addAction(settingsAction);
    toolsMenu->addAction(aboutAction);
}

void MainWindow::createToolBars()
{
    fileToolBar = addToolBar(tr("&File"));
    fileToolBar->addAction(newAction);
    fileToolBar->addAction(openAction);
    fileToolBar->addAction(saveAction);
    fileToolBar->addAction(saveAsAction);

    operationToolBar = addToolBar(tr("&Operation"));
    operationToolBar->addAction(startAction);
    operationToolBar->addAction(stopAction);

    toolsToolBar = addToolBar(tr("&Tools"));
    toolsToolBar->addAction(savePDFaction);
    toolsToolBar->addAction(reportAction);
    toolsToolBar->addAction(ResToExpAction);
    toolsToolBar->addAction(updateAction);
    toolsToolBar->addAction(settingsAction);
    toolsToolBar->addAction(aboutAction);

    /*editToolBar = addToolBar(tr("&Edit"));
    editToolBar->addAction(cutAction);
    editToolBar->addAction(copyAction);
    editToolBar->addAction(pasteAction);
    editToolBar->addSeparator();
    editToolBar->addAction(findAction);
    editToolBar->addAction(goToCellAction);*/
}

void MainWindow::on_wizard_button_clicked()
{
    if(classic_mode)
    {
        this->ui->classic_scroll->hide();
        classic_mode = false;
        this->ui->wizard_tabs->show();
        this->ui->operation_mode_container->show();
    }
}

void MainWindow::on_classic_button_clicked()
{
    if(!classic_mode)
    {
        this->ui->wizard_tabs->hide();
        this->ui->operation_mode_container->hide();
        classic_mode = true;
        this->ui->classic_scroll->show();
    }
}

void MainWindow::on_sim_button_clicked(){opmode = "sim";}

void MainWindow::on_fit_button_clicked(){opmode = "fit";}

void MainWindow::on_sur_button_clicked(){opmode = "sur";}

void MainWindow::on_coupling_button_clicked(){opmode = "cou";}

void MainWindow::on_matrix_button_clicked(){opmode = "mat";}

/*void MainWindow::on_new_site_button_clicked()
{
    num_sites = num_sites + 1;
    num_added_sites = num_added_sites + 1;

    sites_content_list << new site_struct;

    sites_content_box << new QVBoxLayout();
    sites_collapser << new QFrame();
    sites_collapser_box << new QHBoxLayout();
    sites_collapser.last()->setLayout(sites_collapser_box.last());
    sites_collapse << new QPushButton();
    sites_collapse.last()->setCheckable(true);
    sites_collapse.last()->setChecked(true);
    foreach(QPushButton *b,sites_collapse)
    {
        b->setObjectName("collapse_button");
        qApp->setStyleSheet("QPushButton#collapse_button { background-color: transparent; background-repeat: none; border: none}");
    }
    QPixmap pixmap(":/images/button_engaged.png");
    QIcon ButtonIcon(pixmap);
    sites_collapse.last()->setIcon(ButtonIcon);
    sites_collapser_box.last()->addWidget(sites_collapse.last(),1,Qt::AlignLeft);
    sites_name << new QLineEdit();
    sites_name.last()->setText("Site "+QString::number(num_added_sites));
    sites_name.last()->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    connect(sites_name.last(),SIGNAL(textChanged(QString)),this,SLOT(sites_to_interaction(QString)));
    sites_collapser_box.last()->addWidget(sites_name.last(),1,Qt::AlignLeft);
    sites_collapser_box.last()->setSpacing(2);
    connect(this->sites_collapse.last(),SIGNAL(toggled(bool)),sites_content_list.last()->main_frame,SLOT(setVisible(bool)));
    connect(this->sites_collapse.last(),SIGNAL(toggled(bool)),this,SLOT(change_button_appearance(bool)));
    sites_remove << new QPushButton();
    sites_remove.last()->setText("Remove");
    sites_collapser_box.last()->addWidget(sites_remove.last(),1,Qt::AlignRight);
    connect(this->sites_remove.last(),SIGNAL(clicked()),this,SLOT(remove_sites()));
    sites_sep << new QFrame();
    sites_sep.last()->setFrameStyle(QFrame::HLine);
    ui->sites_layout->insertWidget((num_sites-1)*3,sites_collapser.last());
    ui->sites_layout->insertWidget((num_sites-1)*3+1,sites_content_list.last()->main_frame);
    ui->sites_layout->insertWidget((num_sites-1)*3+2,sites_sep.last());

    QString a;
    this->sites_to_interaction(a);
}*/

void MainWindow::remove_sites()
{
    const QObject * sender = QObject::sender();
    QPushButton * button = (QPushButton *)sender;
    int site = this->sites_remove.indexOf(button);

    sites_content_list.takeAt(site)->~site_struct();

    this->sites_name.takeAt(site)->~QLineEdit();
    this->sites_collapse.takeAt(site)->~QPushButton();
    this->sites_remove.takeAt(site)->~QPushButton();
    this->sites_collapser_box.takeAt(site)->~QHBoxLayout();
    this->sites_collapser.takeAt(site)->~QFrame();

    this->sites_sep.takeAt(site)->~QFrame();

    num_sites = num_sites - 1;

    QString a;
    this->sites_to_interaction(a);
}

void MainWindow::sites_to_interaction(QString str)
{
    for(int j=0;j<interactions_list.count();j++)
    {
        interactions_list.at(j)->site_a->clear();
        interactions_list.at(j)->site_b->clear();
        for(int i=0;i<sites_content_list.count();i++)
        {
            interactions_list.at(j)->site_a->addItem(sites_name.at(i)->text());
            interactions_list.at(j)->site_b->addItem(sites_name.at(i)->text());
        }
    }
}

void MainWindow::change_button_appearance(bool check)
{
    const QObject * sender = QObject::sender();
    QPushButton * button = (QPushButton *)sender;
    int site = this->sites_collapse.indexOf(button);

    QPixmap pixmap;
    QIcon ButtonIcon;

    if(check)
    {
        pixmap.load(":/images/button_engaged.png");
        ButtonIcon.addPixmap(pixmap);
        this->sites_collapse.at(site)->setIcon(ButtonIcon);
    }
    else
    {
        pixmap.load(":/images/button_disengaged.png");
        ButtonIcon.addPixmap(pixmap);
        this->sites_collapse.at(site)->setIcon(ButtonIcon);
    }

}

site_struct::site_struct()
{
    main_frame = new QFrame;
    main_layout = new QVBoxLayout;
    top_layout = new QHBoxLayout;
    second_layout = new QHBoxLayout;
    g_ored_layout = new QVBoxLayout;
    ang_mom_box = new QGroupBox(tr("Angular Momentum"));
    presets_box = new QGroupBox(tr("Presets"));
    g_box = new QGroupBox(tr("Spin G-Factor"));
    ang_mom_layout = new QVBoxLayout;
    presets_layout = new QVBoxLayout;
    gx_layout = new QHBoxLayout;
    gy_layout = new QHBoxLayout;
    gz_layout = new QHBoxLayout;
    spin_layout = new QHBoxLayout;
    orbit_layout = new QHBoxLayout;
    g_layout = new QVBoxLayout;
    spin_label = new QLabel;
    orbit_label = new QLabel;
    gx_label = new QLabel;
    gy_label = new QLabel;
    gz_label = new QLabel;
    spin_value = new QDoubleSpinBox;
    orbit_value = new QDoubleSpinBox;
    presets_list = new QComboBox;
    g_aniso = new QRadioButton;
    g_iso = new QRadioButton;
    gx_value = new QLineEdit;
    gy_value = new QLineEdit;
    gz_value = new QLineEdit;
    g_validator = new QDoubleValidator;
    ored_box = new QGroupBox(tr("Orbital Reduction"));
    ored_layout = new QVBoxLayout;
    ored_value = new QLineEdit;
    double_validator = new QDoubleValidator;
    soc_box = new QGroupBox(tr("Spin-Orbit Coupling"));
    soc_layout = new QVBoxLayout;
    for(int i=0;i<6;i++)
    {
        soc_content_layout[i] = new QHBoxLayout;
        soc_labels[i] = new QLabel;
        soc_values[i] = new QLineEdit;
    }
    cfp_box = new QGroupBox(tr("ZFS / Crystal Field"));
    cfp_layout = new QGridLayout;
    for(int i=0;i<5;i++)
    {
        cfp_2_values[i] = new QLineEdit;
    }
    for(int i=0;i<9;i++)
    {
        cfp_4_values[i] = new QLineEdit;
    }
    for(int i=0;i<13;i++)
    {
        cfp_6_values[i] = new QLineEdit;
        cfp_q_labels[i] = new QLabel;
    }
    cfp_k_labels[0] = new QLabel;
    cfp_k_labels[1] = new QLabel;
    cfp_k_labels[2] = new QLabel;
    cfp_main_layout = new QVBoxLayout;
    cfp_d_layout = new QHBoxLayout;
    cfp_button_layout = new QVBoxLayout;
    cfp_d = new QRadioButton;
    cfp_cfp = new QRadioButton;
    cfp_d_label = new QLabel;
    cfp_e_label = new QLabel;
    cfp_d_value = new QLineEdit;
    cfp_e_value = new QLineEdit;
    rot_box = new QGroupBox(tr("Rotation"));
    rot_main_layout = new QHBoxLayout;
    for(int i=0;i<3;i++)
    {
        rot_layouts[i] = new QVBoxLayout;
        rot_labels[i] = new QLabel;
        rot_values[i] = new QLineEdit;
    }

    //---- Pack Ang. Mom. Box ----//
    spin_label->setText("Spin: ");
    orbit_label->setText("Orbital: ");
    spin_value->setDecimals(1);
    spin_value->setMinimum(0.5);
    spin_value->setSingleStep(0.5);
    orbit_value->setDecimals(0);
    orbit_value->setSingleStep(1);
    orbit_value->setMinimum(0);
    spin_layout->addWidget(spin_label);
    spin_layout->addWidget(spin_value);
    orbit_layout->addWidget(orbit_label);
    orbit_layout->addWidget(orbit_value);
    ang_mom_layout->addLayout(spin_layout);
    ang_mom_layout->addLayout(orbit_layout);
    ang_mom_box->setLayout(ang_mom_layout);

    //---- Pack Preset Box ----//
    presets_layout->addWidget(presets_list);
    presets_box->setLayout(presets_layout);

    //---- Pack Top Layout ----//
    top_layout->addWidget(ang_mom_box);
    top_layout->addWidget(presets_box);

    //---- Pack G-factor Box ----//
    gx_label->setText("gx");
    gy_label->setText("gy");
    gz_label->setText("gz");
    g_iso->setText("Isotropic");
    g_aniso->setText("Anisotropic");
    g_iso->setChecked(true);
    connect(g_iso,SIGNAL(clicked()),this,SLOT(g_iso_set()));
    connect(g_aniso,SIGNAL(clicked()),this,SLOT(g_aniso_set()));
    g_layout->addWidget(g_iso);
    g_layout->addWidget(g_aniso);
    g_validator->setBottom(0);
    g_validator->setDecimals(20);
    gx_value->setValidator(g_validator);
    gy_value->setValidator(g_validator);
    gz_value->setValidator(g_validator);
    gx_value->setText("2.0");
    gy_value->setText("2.0");
    gz_value->setText("2.0");
    connect(gx_value,SIGNAL(textChanged(QString)),this,SLOT(g_iso_copy(QString)));
    gy_value->setEnabled(false);
    gz_value->setEnabled(false);
    gx_layout->addWidget(gx_label);
    gx_layout->addWidget(gx_value);
    gy_layout->addWidget(gy_label);
    gy_layout->addWidget(gy_value);
    gz_layout->addWidget(gz_label);
    gz_layout->addWidget(gz_value);
    g_layout->addLayout(gx_layout);
    g_layout->addLayout(gy_layout);
    g_layout->addLayout(gz_layout);
    g_box->setLayout(g_layout);

    //---- Pack ored Box ----//
    ored_value->setText("1.0");
    ored_value->setValidator(double_validator);
    ored_layout->addWidget(ored_value);
    ored_box->setLayout(ored_layout);

    //---- Pack soc Box ----//
    for(int i=0;i<6;i++)
    {
        soc_values[i]->setText("0.0");
        soc_values[i]->setValidator(double_validator);
        soc_labels[i]->setText(QString::number(i+1));
        soc_content_layout[i]->addWidget(soc_labels[i]);
        soc_content_layout[i]->addWidget(soc_values[i]);
        soc_layout->addLayout(soc_content_layout[i]);
    }
    soc_box->setLayout(soc_layout);

    //---- Pack cfp Box ----//
    cfp_k_labels[0]->setText("k = 2");
    cfp_k_labels[1]->setText("k = 4");
    cfp_k_labels[2]->setText("k = 6");
    cfp_layout->addWidget(cfp_k_labels[0],0,1,1,1,Qt::AlignCenter);
    cfp_layout->addWidget(cfp_k_labels[1],0,2,1,1,Qt::AlignCenter);
    cfp_layout->addWidget(cfp_k_labels[2],0,3,1,1,Qt::AlignCenter);
    for(int i=0;i<5;i++)
    {
        cfp_2_values[i]->setValidator(double_validator);
        cfp_2_values[i]->setText("0.0");
        cfp_2_values[i]->setEnabled(false);
        cfp_layout->addWidget(cfp_2_values[i],i+5,1,1,1);
    }
    for(int i=0;i<9;i++)
    {
        cfp_4_values[i]->setValidator(double_validator);
        cfp_4_values[i]->setText("0.0");
        cfp_4_values[i]->setEnabled(false);
        cfp_layout->addWidget(cfp_4_values[i],i+3,2,1,1);
    }
    for(int i=0;i<13;i++)
    {
        cfp_6_values[i]->setValidator(double_validator);
        cfp_6_values[i]->setText("0.0");
        cfp_6_values[i]->setEnabled(false);
        cfp_q_labels[i]->setText("q = "+QString::number(i-6));
        cfp_layout->addWidget(cfp_q_labels[i],i+1,0,1,1);
        cfp_layout->addWidget(cfp_6_values[i],i+1,3,1,1);
    }
    cfp_d->setText("Zero Field Splitting");
    cfp_cfp->setText("Crystal Field");
    cfp_d->setChecked(true);
    connect(cfp_d,SIGNAL(clicked()),this,SLOT(cfp_d_set()));
    connect(cfp_cfp,SIGNAL(clicked()),this,SLOT(cfp_cfp_set()));
    cfp_button_layout->addWidget(cfp_d);
    cfp_button_layout->addWidget(cfp_cfp);
    cfp_d_label->setText("D");
    cfp_e_label->setText("E");
    cfp_d_value->setValidator(double_validator);
    cfp_e_value->setValidator(double_validator);
    cfp_d_value->setText("0.0");
    cfp_e_value->setText("0.0");
    cfp_d_layout->addLayout(cfp_button_layout);
    cfp_d_layout->addWidget(cfp_d_label);
    cfp_d_layout->addWidget(cfp_d_value);
    cfp_d_layout->addWidget(cfp_e_label);
    cfp_d_layout->addWidget(cfp_e_value);
    cfp_main_layout->addLayout(cfp_d_layout);
    cfp_main_layout->addLayout(cfp_layout);
    cfp_box->setLayout(cfp_main_layout);

    //---- Pack rot Box ----//
    rot_labels[0]->setText("Alpha");
    rot_labels[1]->setText("Beta");
    rot_labels[2]->setText("Gamma");
    for(int i=0;i<3;i++)
    {
        rot_values[i]->setValidator(double_validator);
        rot_values[i]->setText("0.0");
        rot_layouts[i]->addWidget(rot_labels[i],0,Qt::AlignCenter);
        rot_layouts[i]->addWidget(rot_values[i]);
        rot_main_layout->addLayout(rot_layouts[i]);
    }
    rot_box->setLayout(rot_main_layout);

    //---- Pack second layout ----//
    g_ored_layout->addWidget(g_box);
    g_ored_layout->addWidget(ored_box);
    second_layout->addLayout(g_ored_layout);
    second_layout->addWidget(soc_box);

    //---- Pack Content ----//
    main_layout->addLayout(top_layout);
    main_layout->addLayout(second_layout);
    main_layout->addWidget(cfp_box);
    main_layout->addWidget(rot_box);

    main_frame->setLayout(main_layout);
}

site_struct::~site_struct()
{
    spin_label->~QLabel();
    orbit_label->~QLabel();
    gx_label->~QLabel();
    gy_label->~QLabel();
    gz_label->~QLabel();
    spin_value->~QDoubleSpinBox();
    orbit_value->~QDoubleSpinBox();
    presets_list->~QComboBox();
    g_aniso->~QRadioButton();
    g_iso->~QRadioButton();
    gx_value->~QLineEdit();
    gy_value->~QLineEdit();
    gz_value->~QLineEdit();
    g_validator->~QDoubleValidator();
    ored_value->~QLineEdit();
    double_validator->~QDoubleValidator();
    for(int i=0;i<6;i++)
    {
        soc_values[i]->~QLineEdit();
        soc_labels[i]->~QLabel();
        soc_content_layout[i]->~QHBoxLayout();
    }
    for(int i=0;i<5;i++)
    {
        cfp_2_values[i]->~QLineEdit();
    }
    for(int i=0;i<9;i++)
    {
        cfp_4_values[i]->~QLineEdit();
    }
    for(int i=0;i<13;i++)
    {
        cfp_6_values[i]->~QLineEdit();
    }
    for(int i=0;i<13;i++)
    {
        cfp_q_labels[i]->~QLabel();
    }
    for(int i=0;i<3;i++)
    {
        cfp_k_labels[i]->~QLabel();
        rot_labels[i]->~QLabel();
        rot_values[i]->~QLineEdit();
        rot_layouts[i]->~QVBoxLayout();
    }
    cfp_d->~QRadioButton();
    cfp_cfp->~QRadioButton();
    cfp_d_label->~QLabel();
    cfp_e_label->~QLabel();
    cfp_d_value->~QLineEdit();
    cfp_e_value->~QLineEdit();

    presets_layout->~QVBoxLayout();
    gx_layout->~QHBoxLayout();
    gy_layout->~QHBoxLayout();
    gz_layout->~QHBoxLayout();
    spin_layout->~QHBoxLayout();
    orbit_layout->~QHBoxLayout();
    g_layout->~QVBoxLayout();
    ang_mom_layout->~QVBoxLayout();
    ored_layout->~QVBoxLayout();
    soc_layout->~QVBoxLayout();
    cfp_layout->~QGridLayout();
    cfp_button_layout->~QVBoxLayout();
    cfp_d_layout->~QHBoxLayout();
    cfp_main_layout->~QVBoxLayout();
    rot_main_layout->~QHBoxLayout();

    ang_mom_box->~QGroupBox();
    presets_box->~QGroupBox();
    g_box->~QGroupBox();
    ored_box->~QGroupBox();
    soc_box->~QGroupBox();
    cfp_box->~QGroupBox();
    rot_box->~QGroupBox();

    g_ored_layout->~QVBoxLayout();
    second_layout->~QHBoxLayout();
    top_layout->~QHBoxLayout();
    main_layout->~QVBoxLayout();
    main_frame->~QFrame();
}

void site_struct::g_iso_copy(QString text)
{
    if(g_iso->isChecked())
    {
        gy_value->setText(text);
        gz_value->setText(text);
    }
}

void site_struct::g_iso_set()
{
    this->gy_value->setEnabled(false);
    this->gz_value->setEnabled(false);
    this->gy_value->setText(this->gx_value->text());
    this->gz_value->setText(this->gx_value->text());
}

void site_struct::g_aniso_set()
{
    this->gy_value->setEnabled(true);
    this->gz_value->setEnabled(true);
}

void site_struct::cfp_d_set()
{
    for(int i=0;i<5;i++)
    {
        cfp_2_values[i]->setEnabled(false);
    }
    for(int i=0;i<9;i++)
    {
        cfp_4_values[i]->setEnabled(false);
    }
    for(int i=0;i<13;i++)
    {
        cfp_6_values[i]->setEnabled(false);
    }
    cfp_d_value->setEnabled(true);
    cfp_e_value->setEnabled(true);
}

void site_struct::cfp_cfp_set()
{
    for(int i=0;i<5;i++)
    {
        cfp_2_values[i]->setEnabled(true);
    }
    for(int i=0;i<9;i++)
    {
        cfp_4_values[i]->setEnabled(true);
    }
    for(int i=0;i<13;i++)
    {
        cfp_6_values[i]->setEnabled(true);
    }
    cfp_d_value->setEnabled(false);
    cfp_e_value->setEnabled(false);
}

/*void MainWindow::on_new_interaction_button_clicked()
{
    num_interactions = num_interactions + 1;
    interactions_list << new interaction_struct;
    interactions_remove << new QPushButton;
    interactions_remove.last()->setText("Remove");
    //connect(interactions_remove.last(),SIGNAL(clicked()),this,SLOT(on_remove_interaction_button_clicked()));
    ui->interactions_grid->addWidget(interactions_list.last()->site_a,num_interactions,0,1,1,Qt::AlignCenter);
    ui->interactions_grid->addWidget(interactions_list.last()->site_b,num_interactions,1,1,1,Qt::AlignCenter);
    ui->interactions_grid->addWidget(interactions_list.last()->type,num_interactions,2,1,1,Qt::AlignCenter);
    ui->interactions_grid->addWidget(interactions_list.last()->values_frame,num_interactions,3.1.6,Qt::AlignCenter);
    ui->interactions_grid->addWidget(interactions_remove.last(),num_interactions,4,1,1,Qt::AlignCenter);

    QString a;
    this->sites_to_interaction(a);
}*/

/*void MainWindow::on_remove_interaction_button_clicked()
{
    const QObject * sender = QObject::sender();
    QPushButton * button = (QPushButton *)sender;
    int site = this->interactions_remove.indexOf(button);

    interactions_list.takeAt(site)->~interaction_struct();

    this->interactions_remove.takeAt(site)->~QPushButton();

    num_interactions = num_interactions - 1;
}*/

void MainWindow::move_interaction_button()
{
    ui->interactions_grid->removeWidget(new_interaction_button);
    ui->interactions_grid->addWidget(new_interaction_button,num_interactions+1,2,1,1,Qt::AlignTop|Qt::AlignCenter);
}

interaction_struct::interaction_struct()
{
    values_frame = new QFrame;
    values_layout = new QHBoxLayout;
    site_a = new QComboBox;
    site_b = new QComboBox;
    type = new QComboBox;
    j_iso = new QLineEdit;
    jx = new QLineEdit;
    jy = new QLineEdit;
    jz = new QLineEdit;
    anti_x = new QLineEdit;
    anti_y = new QLineEdit;
    anti_z = new QLineEdit;
    jxx = new QLineEdit;
    jxy = new QLineEdit;
    jxz = new QLineEdit;
    jyx = new QLineEdit;
    jyy = new QLineEdit;
    jyz = new QLineEdit;
    jzx = new QLineEdit;
    jzy = new QLineEdit;
    jzz = new QLineEdit;
    aniso_layout = new QHBoxLayout;
    anti_layout = new QHBoxLayout;
    grid_layout = new QGridLayout;
    aniso_frame = new QFrame;
    anti_frame = new QFrame;
    matrix_frame = new QFrame;
    remove = new QPushButton;
    double_validator = new QDoubleValidator;

    j_iso->setValidator(double_validator);
    jx->setValidator(double_validator);
    jy->setValidator(double_validator);
    jz->setValidator(double_validator);
    anti_x->setValidator(double_validator);
    anti_y->setValidator(double_validator);
    anti_z->setValidator(double_validator);
    jxx->setValidator(double_validator);
    jxy->setValidator(double_validator);
    jxz->setValidator(double_validator);
    jyx->setValidator(double_validator);
    jyy->setValidator(double_validator);
    jyz->setValidator(double_validator);
    jzx->setValidator(double_validator);
    jzy->setValidator(double_validator);
    jzz->setValidator(double_validator);

    j_iso->setText("0.0");
    jx->setText("0.0");
    jy->setText("0.0");
    jz->setText("0.0");
    anti_x->setText("0.0");
    anti_y->setText("0.0");
    anti_z->setText("0.0");
    jxx->setText("0.0");
    jxy->setText("0.0");
    jxz->setText("0.0");
    jyx->setText("0.0");
    jyy->setText("0.0");
    jyz->setText("0.0");
    jzx->setText("0.0");
    jzy->setText("0.0");
    jzz->setText("0.0");

    remove->setText("Remove");
    connect(remove,SIGNAL(clicked()),this,SLOT(remove_interaction()));

    type->addItem("Isotropic");
    type->addItem("Anisotropic");
    type->addItem("Antisymmetric");
    type->addItem("Matrix");
    connect(type,SIGNAL(currentIndexChanged(int)),this,SLOT(type_changed(int)));

    grid_layout->addWidget(jxx,0,0);
    grid_layout->addWidget(jxy,0,1);
    grid_layout->addWidget(jxz,0,2);
    grid_layout->addWidget(jyx,1,0);
    grid_layout->addWidget(jyy,1,1);
    grid_layout->addWidget(jyz,1,2);
    grid_layout->addWidget(jzx,2,0);
    grid_layout->addWidget(jzy,2,1);
    grid_layout->addWidget(jzz,2,2);
    matrix_frame->setLayout(grid_layout);

    aniso_layout->addWidget(jx);
    aniso_layout->addWidget(jy);
    aniso_layout->addWidget(jz);
    aniso_frame->setLayout(aniso_layout);

    anti_layout->addWidget(anti_x);
    anti_layout->addWidget(anti_y);
    anti_layout->addWidget(anti_z);
    anti_frame->setLayout(anti_layout);

    values_layout->addWidget(j_iso);
    values_layout->addWidget(aniso_frame);
    values_layout->addWidget(anti_frame);
    values_layout->addWidget(matrix_frame);

    aniso_frame->setVisible(false);
    anti_frame->setVisible(false);
    matrix_frame->setVisible(false);

    values_frame->setLayout(values_layout);
}

interaction_struct::~interaction_struct()
{
    site_a->~QComboBox();
    site_b->~QComboBox();
    type->~QComboBox();
    j_iso->~QLineEdit();
    jx->~QLineEdit();
    jy->~QLineEdit();
    jz->~QLineEdit();
    anti_x->~QLineEdit();
    anti_y->~QLineEdit();
    anti_z->~QLineEdit();
    jxx->~QLineEdit();
    jxy->~QLineEdit();
    jxz->~QLineEdit();
    jyx->~QLineEdit();
    jyy->~QLineEdit();
    jyz->~QLineEdit();
    jzx->~QLineEdit();
    jzy->~QLineEdit();
    jzz->~QLineEdit();
    aniso_layout->~QHBoxLayout();
    anti_layout->~QHBoxLayout();
    grid_layout->~QGridLayout();
    remove->~QPushButton();
    double_validator->~QDoubleValidator();

    aniso_frame->~QFrame();
    anti_frame->~QFrame();
    matrix_frame->~QFrame();
    values_layout->~QHBoxLayout();
    values_frame->~QFrame();
}

void interaction_struct::type_changed(int a)
{
    if(a == 0)
    {
        j_iso->setVisible(true);
        aniso_frame->setVisible(false);
        anti_frame->setVisible(false);
        matrix_frame->setVisible(false);
    }
    else if(a == 1)
    {
        j_iso->setVisible(false);
        aniso_frame->setVisible(true);
        anti_frame->setVisible(false);
        matrix_frame->setVisible(false);
    }
    else if(a == 2)
    {
        j_iso->setVisible(false);
        aniso_frame->setVisible(false);
        anti_frame->setVisible(true);
        matrix_frame->setVisible(false);
    }
    else if(a == 3)
    {
        j_iso->setVisible(false);
        aniso_frame->setVisible(false);
        anti_frame->setVisible(false);
        matrix_frame->setVisible(true);
    }
}

void MainWindow::start_task()
{
    //std::cout << "*-start" << std::endl;
    if(!phi_running)
    {
        if(ui->classic_box->toPlainText() != "")
        {
            QSettings settings;
            int i,end_line,h;
            this->saveFile();
            sus_numB = 0;
            sus_exp_numB = 0;
            sus_numT = 0;
            sus_exp_numT = 0;
            mag_numB = 0;
            mag_numT = 0;
            mag_exp_numT = 0;
            mag_exp_numB = 0;
            mce_numB = 0;
            mce_exp_numB = 0;
            mce_numT = 0;
            mce_exp_numT = 0;
            heat_numB = 0;
            heat_exp_numB = 0;
            heat_numT = 0;
            heat_exp_numT = 0;
            epr_numB = 0;
            epr_numF = 0;
            epr_numT = 0;
            epr_numDir = 0;
            epr_exp_numB = 0;
            if(settings.value("EPRZeeman",1).toInt()==1){epr_do_zeeman = true;}else{epr_do_zeeman=false;}
            have_sus_exp_data = false;
            have_mag_exp_data = false;
            have_mce_exp_data = false;
            have_heat_exp_data = false;
            have_epr_exp_data = false;

            ui->epr_plot->clearGraphs();
            ui->epr_plot->clearItems();
            epr_arrows.clear();
            epr_slider_available = false;
            ui->epr_slider->setVisible(false);
            epr_zee_dir_label->setText("");
            epr_zee_dir = 1;

            QStringList lines = ui->classic_box->toPlainText().toLower().split('\n', QString::SkipEmptyParts);
            for(i=0;i<lines.size();i++)
            {
                if(lines.at(i).indexOf("*end") > -1)
                {
                        end_line = i;
                        break;
                }
            }
            for(i=0;i<end_line;i++)
            {
                if(lines.at(i).indexOf("opmode") > -1 && (lines.at(i).indexOf("sim") > -1 || lines.at(i).indexOf("sur") > -1 || lines.at(i).indexOf("fit") > -1))
                {
                    if(lines.at(i).split(QRegExp("(\\s|\\n|\\r|\\t)+"),QString::SkipEmptyParts).at(2).indexOf("e") > -1)
                    {
                        if(lines.at(i).indexOf("sim") > -1 && settings.value("EPRZeeman",1).toInt() == 1)
                        {
                            if(ui->epr_plot->plotLayout()->rowCount() == 1)
                            {
                                ui->epr_plot->plotLayout()->insertRow(1);
                                ui->epr_plot->plotLayout()->addElement(1,0,epr_zeeman_plot);
                                epr_zeeman_plot->axis(QCPAxis::atLeft, 0)->setLabel("Energy (cm⁻¹)");
                                epr_zeeman_plot->axis(QCPAxis::atBottom, 0)->setLabel("Field (T)");
                            }
                            epr_zeeman_plot->setVisible(true);
                            ui->epr_slider->setVisible(true);
                            ui->epr_slider->setValue(1);
                            epr_zee_dir_label->setText("1");
                        }
                        else
                        {
                            if(ui->epr_plot->plotLayout()->rowCount() > 1)
                            {
                                ui->epr_plot->plotLayout()->take(ui->epr_plot->plotLayout()->element(1,0));
                                epr_zeeman_plot->setVisible(false);
                                ui->epr_slider->setVisible(false);
                                ui->epr_plot->plotLayout()->simplify();
                            }
                        }
                        ui->epr_plot->replot();
                    }
                    else
                    {
                        if(ui->epr_plot->plotLayout()->rowCount() > 1)
                        {
                            ui->epr_plot->plotLayout()->take(ui->epr_plot->plotLayout()->element(1,0));
                            epr_zeeman_plot->setVisible(false);
                            ui->epr_slider->setVisible(false);
                            ui->epr_plot->plotLayout()->simplify();
                        }
                    }
                }
                if(lines.at(i).indexOf("opmode") > -1)
                {
                    if(lines.at(i).indexOf("sim") > -1){opmode = "sim";};
                    if(lines.at(i).indexOf("fit") > -1){opmode = "fit";};
                    if(lines.at(i).indexOf("sur") > -1){opmode = "sur";};
                }
            }

            ui->output_box->clear();
            ui->states_box->clear();

            ui->mag_plot->clearGraphs();
            ui->redmag_plot->clearGraphs();
            ui->mce_plot->clearGraphs();
            ui->heat_plot->clearGraphs();
            ui->sus_plot->clearGraphs();
            ui->chi_plot->clearGraphs();
            ui->invchi_plot->clearGraphs();
            ui->zeeman_plot->clearGraphs();

            ui->mag_plot->replot();
            ui->redmag_plot->replot();
            ui->mce_plot->replot();
            ui->heat_plot->replot();
            ui->sus_plot->replot();
            ui->chi_plot->replot();
            ui->invchi_plot->replot();
            ui->zeeman_plot->replot();
            ui->epr_plot->replot();

            this->clear_data();
            plotting = false;
            phi_running = true;
            StatusLabel->setText("Running");
            this->stopAction->setEnabled(true);
            this->startAction->setEnabled(false);
            return_all = false;
            ProgressBar->setValue(0);

#ifdef Q_OS_WIN
            //std::cout <<"Creating thread: "<<QThread::currentThreadId() << std::endl;
            thread_handle = (HANDLE)CreateThread( NULL, 0, ThreadProc, (void*)&i,0, NULL);
            //::SetThreadPriority(thread_handle, THREAD_PRIORITY_BELOW_NORMAL);
            //std::cout <<"Done creating thread: "<<QThread::currentThreadId() << std::endl;
#else
            //std::cout <<"Creating thread: "<<QThread::currentThreadId() << std::endl;
            i = pthread_create(&thread_handle,NULL,ThreadProc,NULL);
            //std::cout <<"Done creating thread: "<<QThread::currentThreadId() << std::endl;
#endif
        }
    }
}

void MainWindow::stop_task()
{
    if(return_all){return;}
    int i=0;
    //std::cout << "*-stop" << std::endl;
    StatusLabel->setText("Aborting...");
    return_all = true;
    QMessageBox msgBox(this);
    QPixmap pixmap(":/images/about_icon.png");
    pixmap = pixmap.scaledToHeight(50);
    msgBox.setWindowTitle("Loading ....");
    msgBox.setText("PHI is in the middle of a matrix diagonalisation.\n\nIf we end now, things could get ugly.\n\nPlease wait until PHI is done.");
    msgBox.setModal(true);
    msgBox.setStandardButtons(0);
    msgBox.setIconPixmap(pixmap);
    msgBox.show();
    qApp->processEvents();
    qApp->processEvents();
    qApp->processEvents();
    qApp->processEvents();
    qApp->processEvents();
    qApp->processEvents();
    qApp->processEvents();
    qApp->processEvents();
    qApp->processEvents();
    qApp->processEvents();
    while(phi_running)
    {

    }
    msgBox.close();
#ifdef Q_OS_WIN
    /*Sleep(10);
    i++;
    if(i==60)
    {
        std::cout << "----------> killing now" << std::endl;
        break;
    }
    DWORD exitcode;
    TerminateThread(thread_handle,exitcode);
    CloseHandle(thread_handle);*/
#endif
#ifdef Q_OS_OSX
    /*usleep(10000);
    i++;
    if(i==60)
    {
        //std::cout << "----------> killing now" << std::endl;
        break;
    }*/
    i = pthread_cancel(thread_handle);
#endif
#ifdef Q_OS_LINUX
    i = pthread_cancel(thread_handle);
#endif
    this->clear_data();
    ProgressBar->setValue(0);
    plotting = false;
    return_all = false;
    phi_running = false;
    this->stopAction->setEnabled(false);
    this->startAction->setEnabled(true);
    StatusLabel->setText("Idle");
}

void MainWindow::clear_data()
{
    //std::cout << "*-D" << std::endl;
    sus_data->clear();
    sus_exp_data->clear();
    sus_fields->clear();
    mag_data->clear();
    mag_exp_data->clear();
    mag_temps->clear();
    mce_data->clear();
    mce_exp_data->clear();
    mce_fields->clear();
    heat_data->clear();
    heat_exp_data->clear();
    heat_fields->clear();
    zeeman_data->clear();
    epr_data->clear();
    epr_exp_data->clear();
    epr_freqs->clear();
    epr_temps->clear();
    epr_zee_data->clear();
    epr_dirs->clear();
    epr_trans_data->clear();
    ProgressBar->setValue(0);
    epr_arrows.clear();
}

void MainWindow::plot_sus()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*ya,*yb,*yc;
    x = new QVector<double>;
    ya = new QVector<double>[sus_numB];
    yb = new QVector<double>[sus_numB];
    yc = new QVector<double>[sus_numB];
    //std::cout << "*-E" << std::endl;
    if(sus_data->length() != (sus_numB+1)*sus_numT){return;}
    for(int j=0;j<sus_numB+1;j++)
    {
        for(int i=0;i<sus_numT;i++)
        {
            if(j==0)
                x->append(sus_data->at(i));
            else
            {
                ya[j-1].append(sus_data->at(j*sus_numT+i));
                yb[j-1].append((sus_data->at(j*sus_numT+i))/(x->at(i)));
                yc[j-1].append((x->at(i))/(sus_data->at(j*sus_numT+i)));
            }
        }
        if(j!=0)
        {
            ui->sus_plot->graph(sus_exp_numB + j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
            ui->sus_plot->graph(sus_exp_numB +j-1)->setData(*x,ya[j-1]);
            ui->chi_plot->graph(sus_exp_numB +j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
            ui->chi_plot->graph(sus_exp_numB +j-1)->setData(*x,yb[j-1]);
            ui->invchi_plot->graph(sus_exp_numB +j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
            ui->invchi_plot->graph(sus_exp_numB +j-1)->setData(*x,yc[j-1]);
        }
    }
    ui->sus_plot->xAxis->rescale();
    ui->sus_plot->yAxis->rescale();
    ui->sus_plot->yAxis->setRangeLower(0.0);
    ui->sus_plot->yAxis->scaleRange(1.05,0.0);
    ui->chi_plot->xAxis->rescale();
    ui->chi_plot->yAxis->rescale();
    ui->chi_plot->yAxis->setRangeLower(0.0);
    ui->chi_plot->yAxis->scaleRange(1.05,0.0);
    ui->invchi_plot->xAxis->rescale();
    ui->invchi_plot->yAxis->rescale();
    ui->invchi_plot->yAxis->setRangeLower(0.0);
    ui->invchi_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("SusXLog",0).toInt()==1){ui->sus_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->sus_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("SusYLog",0).toInt()==1){ui->sus_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->sus_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("ChiXLog",0).toInt()==1){ui->chi_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->chi_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("ChiYLog",0).toInt()==1){ui->chi_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->chi_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("OneOnChiXLog",0).toInt()==1){ui->invchi_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->invchi_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("OneOnChiYLog",0).toInt()==1){ui->invchi_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->invchi_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->sus_plot->replot();
    ui->chi_plot->replot();
    ui->invchi_plot->replot();
    sus_data->clear();
    plotting = false;
}

void MainWindow::plot_sus_exp()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*ya,*yb,*yc;
    x = new QVector<double>;
    ya = new QVector<double>[sus_exp_numB];
    yb = new QVector<double>[sus_exp_numB];
    yc = new QVector<double>[sus_exp_numB];
    if(sus_exp_data->length() != (sus_exp_numB+1)*sus_exp_numT){return;}
    if(have_sus_exp_data)
    {
        for(int j=0;j<sus_exp_numB+1;j++)
        {
            for(int i=0;i<sus_exp_numT;i++)
            {
                if(j==0)
                    x->append(sus_exp_data->at(i));
                else
                {
                    ya[j-1].append(sus_exp_data->at(j*sus_exp_numT+i));
                    yb[j-1].append((sus_exp_data->at(j*sus_exp_numT+i))/(x->at(i)));
                    yc[j-1].append((x->at(i))/(sus_exp_data->at(j*sus_exp_numT+i)));
                }
            }
            if(j!=0)
            {
                ui->sus_plot->addGraph();
                ui->sus_plot->graph(j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
                ui->sus_plot->graph(j-1)->setData(*x,ya[j-1]);
                ui->sus_plot->graph(j-1)->setLineStyle(QCPGraph::lsNone);
                ui->sus_plot->graph(j-1)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssCircle, settings.value("point_size",8).toInt()));
                ui->chi_plot->addGraph();
                ui->chi_plot->graph(j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
                ui->chi_plot->graph(j-1)->setData(*x,yb[j-1]);
                ui->chi_plot->graph(j-1)->setLineStyle(QCPGraph::lsNone);
                ui->chi_plot->graph(j-1)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssCircle, settings.value("point_size",8).toInt()));
                ui->invchi_plot->addGraph();
                ui->invchi_plot->graph(j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
                ui->invchi_plot->graph(j-1)->setData(*x,yc[j-1]);
                ui->invchi_plot->graph(j-1)->setLineStyle(QCPGraph::lsNone);
                ui->invchi_plot->graph(j-1)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssCircle, settings.value("point_size",8).toInt()));
            }
        }
    }
    //Add plots for calc data
    for(int j=0;j<sus_numB;j++)
    {
        ui->sus_plot->addGraph();
        ui->sus_plot->graph(sus_exp_numB+j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        ui->chi_plot->addGraph();
        ui->chi_plot->graph(sus_exp_numB+j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        ui->invchi_plot->addGraph();
        ui->invchi_plot->graph(sus_exp_numB+j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
    }
    ui->sus_plot->xAxis->rescale();
    ui->sus_plot->yAxis->rescale();
    ui->sus_plot->yAxis->setRangeLower(0.0);
    ui->sus_plot->yAxis->scaleRange(1.05,0.0);
    ui->chi_plot->xAxis->rescale();
    ui->chi_plot->yAxis->rescale();
    ui->chi_plot->yAxis->setRangeLower(0.0);
    ui->chi_plot->yAxis->scaleRange(1.05,0.0);
    ui->invchi_plot->xAxis->rescale();
    ui->invchi_plot->yAxis->rescale();
    ui->invchi_plot->yAxis->setRangeLower(0.0);
    ui->invchi_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("SusXLog",0).toInt()==1){ui->sus_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->sus_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("SusYLog",0).toInt()==1){ui->sus_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->sus_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("ChiXLog",0).toInt()==1){ui->chi_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->chi_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("ChiYLog",0).toInt()==1){ui->chi_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->chi_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("OneOnChiXLog",0).toInt()==1){ui->invchi_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->invchi_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("OneOnChiYLog",0).toInt()==1){ui->invchi_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->invchi_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->sus_plot->replot();
    ui->chi_plot->replot();
    ui->invchi_plot->replot();
    sus_exp_data->clear();
    plotting = false;
}

void MainWindow::plot_mag()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    x = new QVector<double>[mag_numT+1];
    y = new QVector<double>[mag_numT];
    //std::cout << "*-H" << std::endl;
    if(mag_data->length() != (mag_numT+1)*mag_numB){return;}
    for(int j=0;j<mag_numT+1;j++)
    {
        for(int i=0;i<mag_numB;i++)
        {
            if(j==0)
                x[mag_numT].append(mag_data->at(i));
            else
                y[j-1].append(mag_data->at(j*mag_numB+i));
        }
        if(j!=0)
        {
            //std::cout << "plotting " << mag_exp_numT+j-1 << std::endl;
            ui->mag_plot->graph(mag_exp_numT+j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
            ui->mag_plot->graph(mag_exp_numT+j-1)->setData(x[mag_numT],y[j-1]);
        }
    }
    ui->mag_plot->xAxis->rescale();
    ui->mag_plot->yAxis->rescale();
    ui->mag_plot->yAxis->setRangeLower(0.0);
    ui->mag_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("MagXLog",0).toInt()==1){ui->mag_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mag_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MagYLog",0).toInt()==1){ui->mag_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mag_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->mag_plot->replot();
    for(int j=0;j<mag_numT;j++)
    {
        for(int i=0;i<mag_numB;i++)
        {
            x[j].append((x[mag_numT].at(i))/(mag_temps->at(j)));
        }
        if(mag_exp_numT == mag_numT)
        {
            //std::cout << "plotting redmag " << mag_exp_numT+j << std::endl;
            ui->redmag_plot->graph(mag_exp_numT+j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->redmag_plot->graph(mag_exp_numT+j)->setData(x[j],y[j]);
        }
        else
        {
            //std::cout << "setting redmag " << mag_exp_numT+j << std::endl;
            ui->redmag_plot->graph(j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->redmag_plot->graph(j)->setData(x[j],y[j]);
        }
    }
    ui->redmag_plot->xAxis->rescale();
    ui->redmag_plot->yAxis->rescale();
    ui->redmag_plot->yAxis->setRangeLower(0.0);
    ui->redmag_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("RedmagXLog",0).toInt()==1){ui->redmag_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->redmag_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("RedmagYLog",0).toInt()==1){ui->redmag_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->redmag_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->redmag_plot->replot();
    mag_data->clear();
    plotting = false;
}

void MainWindow::plot_mag_exp()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    x = new QVector<double>[mag_exp_numT+1];
    y = new QVector<double>[mag_exp_numT];
    //std::cout << "*-I" << std::endl;
    if(mag_exp_data->length() != (mag_exp_numT+1)*mag_exp_numB){return;}
    if(have_mag_exp_data)
    {
        for(int j=0;j<mag_exp_numT+1;j++)
        {
            for(int i=0;i<mag_exp_numB;i++)
            {
                if(j==0)
                    x[mag_exp_numT].append(mag_exp_data->at(i));
                else
                    y[j-1].append(mag_exp_data->at(j*mag_exp_numB+i));
            }
            if(j!=0)
            {
                ui->mag_plot->addGraph();
                ui->mag_plot->graph(j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
                ui->mag_plot->graph(j-1)->setData(x[mag_exp_numT],y[j-1]);
                ui->mag_plot->graph(j-1)->setLineStyle(QCPGraph::lsNone);
                ui->mag_plot->graph(j-1)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssCircle, settings.value("point_size",8).toInt()));
            }
        }
    }
    //Add plots for calc data
    for(int j=0;j<mag_numT;j++)
    {
        ui->mag_plot->addGraph();
        ui->mag_plot->graph(mag_exp_numT+j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
    }
    ui->mag_plot->xAxis->rescale();
    ui->mag_plot->yAxis->rescale();
    ui->mag_plot->yAxis->setRangeLower(0.0);
    ui->mag_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("MagXLog",0).toInt()==1){ui->mag_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mag_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MagYLog",0).toInt()==1){ui->mag_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mag_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->mag_plot->replot();
    for(int j=0;j<mag_exp_numT;j++)
    {
        for(int i=0;i<mag_exp_numB;i++)
            x[j].append((x[mag_exp_numT].at(i))/(mag_temps->at(j)));
        ui->redmag_plot->addGraph();
        ui->redmag_plot->graph(j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        ui->redmag_plot->graph(j)->setData(x[j],y[j]);
        ui->redmag_plot->graph(j)->setLineStyle(QCPGraph::lsNone);
        ui->redmag_plot->graph(j)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssCircle, settings.value("point_size",8).toInt()));
    }
    //Add plots for calc data
    for(int j=0;j<mag_numT;j++)
    {
        ui->redmag_plot->addGraph();
        ui->redmag_plot->graph(mag_exp_numT+j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
    }
    ui->redmag_plot->xAxis->rescale();
    ui->redmag_plot->yAxis->rescale();
    ui->redmag_plot->yAxis->setRangeLower(0.0);
    ui->redmag_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("RedmagXLog",0).toInt()==1){ui->redmag_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->redmag_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("RedmagYLog",0).toInt()==1){ui->redmag_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->redmag_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->redmag_plot->replot();
    mag_exp_data->clear();
    plotting = false;
}

void MainWindow::plot_mce()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    x = new QVector<double>;
    y = new QVector<double>[mce_numB];
    //std::cout << "*-J" << std::endl;
    if(mce_data->length() != (mce_numB+1)*mce_numT){return;}
    for(int j=0;j<mce_numB+1;j++)
    {
        for(int i=0;i<mce_numT;i++)
        {
            if(j==0)
                x->append(mce_data->at(i));
            else
            {
                y[j-1].append(mce_data->at(j*mce_numT+i));
            }
        }
        if(j!=0)
        {
            ui->mce_plot->graph(mce_exp_numB + j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
            ui->mce_plot->graph(mce_exp_numB +j-1)->setData(*x,y[j-1]);
        }
    }
    ui->mce_plot->xAxis->rescale();
    ui->mce_plot->yAxis->rescale();
    ui->mce_plot->yAxis->setRangeLower(0.0);
    ui->mce_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("MCEXLog",0).toInt()==1){ui->mce_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mce_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MCEYLog",0).toInt()==1){ui->mce_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mce_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->mce_plot->replot();
    mce_data->clear();
    plotting = false;
}

void MainWindow::plot_mce_exp()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    x = new QVector<double>;
    y = new QVector<double>[mce_exp_numB];
    //std::cout << "*-K" << std::endl;
    if(mce_exp_data->length() != (mce_exp_numB+1)*mce_exp_numT){return;}
    if(have_mce_exp_data)
    {
        for(int j=0;j<mce_exp_numB+1;j++)
        {
            for(int i=0;i<mce_exp_numT;i++)
            {
                if(j==0)
                    x->append(mce_exp_data->at(i));
                else
                {
                    y[j-1].append(mce_exp_data->at(j*mce_exp_numT+i));
                }
            }
            if(j!=0)
            {
                ui->mce_plot->addGraph();
                ui->mce_plot->graph(j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
                ui->mce_plot->graph(j-1)->setData(*x,y[j-1]);
                ui->mce_plot->graph(j-1)->setLineStyle(QCPGraph::lsNone);
                ui->mce_plot->graph(j-1)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssCircle, settings.value("point_size",8).toInt()));
            }
        }
    }
    for(int j=0;j<mce_numB;j++)
    {
        ui->mce_plot->addGraph();
        ui->mce_plot->graph(mce_exp_numB+j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
    }
    ui->mce_plot->xAxis->rescale();
    ui->mce_plot->yAxis->rescale();
    ui->mce_plot->yAxis->setRangeLower(0.0);
    ui->mce_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("MCEXLog",0).toInt()==1){ui->mce_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mce_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MCEYLog",0).toInt()==1){ui->mce_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mce_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->mce_plot->replot();
    mce_exp_data->clear();
    plotting = false;
}

void MainWindow::plot_heat()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    x = new QVector<double>;
    y = new QVector<double>[heat_numB];
    //std::cout << "*-L" << std::endl;
    if(heat_data->length() != (heat_numB+1)*heat_numT){return;}
    for(int j=0;j<heat_numB+1;j++)
    {
        for(int i=0;i<heat_numT;i++)
        {
            if(j==0)
                x->append(heat_data->at(i));
            else
            {
                y[j-1].append(heat_data->at(j*heat_numT+i));
            }
        }
        if(j!=0)
        {
            ui->heat_plot->graph(heat_exp_numB + j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
            ui->heat_plot->graph(heat_exp_numB +j-1)->setData(*x,y[j-1]);
        }
    }
    ui->heat_plot->xAxis->rescale();
    ui->heat_plot->yAxis->rescale();
    ui->heat_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("HeatXLog",1).toInt()==1){ui->heat_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->heat_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("HeatYLog",1).toInt()==1){ui->heat_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->heat_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->heat_plot->replot();
    heat_data->clear();
    plotting = false;
}

void MainWindow::plot_heat_exp()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    x = new QVector<double>;
    y = new QVector<double>[heat_exp_numB];
    //std::cout << "*-M" << std::endl;
    if(heat_exp_data->length() != (heat_exp_numB+1)*heat_exp_numT){return;}
    if(have_heat_exp_data)
    {
        for(int j=0;j<heat_exp_numB+1;j++)
        {
            for(int i=0;i<heat_exp_numT;i++)
            {
                if(j==0)
                    x->append(heat_exp_data->at(i));
                else
                {
                    y[j-1].append(heat_exp_data->at(j*heat_exp_numT+i));
                }
            }
            if(j!=0)
            {
                ui->heat_plot->addGraph();
                ui->heat_plot->graph(j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
                ui->heat_plot->graph(j-1)->setData(*x,y[j-1]);
                ui->heat_plot->graph(j-1)->setLineStyle(QCPGraph::lsNone);
                ui->heat_plot->graph(j-1)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssCircle, settings.value("point_size",8).toInt()));
            }
        }
    }
    for(int j=0;j<heat_numB;j++)
    {
        ui->heat_plot->addGraph();
        ui->heat_plot->graph(heat_exp_numB+j)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
    }
    ui->heat_plot->xAxis->rescale();
    ui->heat_plot->yAxis->rescale();
    ui->heat_plot->yAxis->setRangeLower(0.0);
    ui->heat_plot->yAxis->scaleRange(1.05,0.0);
    if(settings.value("HeatXLog",1).toInt()==1){ui->heat_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->heat_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("HeatYLog",1).toInt()==1){ui->heat_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->heat_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    ui->heat_plot->replot();
    heat_exp_data->clear();
    plotting = false;
}

void MainWindow::plot_zeeman()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    x = new QVector<double>;
    y = new QVector<double>[totaldim];
    //std::cout << "*-N" << std::endl;
    if(zeeman_data->length() != (totaldim+1)*zeeman_numB){return;}
    ui->zeeman_plot->clearGraphs();
    for(int j=0;j<totaldim+1;j++)
    {
        for(int i=0;i<zeeman_numB;i++)
        {
            if(j==0)
                x->append(zeeman_data->at(i));
            else
            {
                y[j-1].append(zeeman_data->at(j*zeeman_numB+i));
            }
        }
        if(j!=0)
        {
            ui->zeeman_plot->addGraph();
            ui->zeeman_plot->graph(j-1)->setPen(QPen(colour_list[(j-1)%13],settings.value("line_size",2).toReal()));
            ui->zeeman_plot->graph(j-1)->setData(*x,y[j-1]);
        }
    }
    ui->zeeman_plot->xAxis->rescale();
    ui->zeeman_plot->yAxis->rescale();
    ui->zeeman_plot->yAxis->scaleRange(1.05,0.0);
    ui->zeeman_plot->replot();
    zeeman_data->clear();
    plotting = false;
}

void MainWindow::plot_epr_zee()
{
    if(epr_slider_available)
    {
        //std::cout << "*-N1" << std::endl;
        QVector<double> *x,*y;
        QSettings settings;
        int i_lim = 1;
        long local_dim;
        x = new QVector<double>;
        if(subdim == 0)
        {
            local_dim = totaldim;
        }
        else
        {
            local_dim = subdim;
        }
        y = new QVector<double>[local_dim];
        if(epr_zee_data->length() != (local_dim)*epr_numB*epr_numDir){return;}
        int c = epr_zeeman_plot->graphs().count();
        for(int i=0;i<c;i++)
        {
            ui->epr_plot->removeGraph(epr_zeeman_plot->graphs().at(0));
        }
        ui->epr_plot->clearItems();
        epr_arrows.clear();
        for(int b=0;b<epr_numB;b++)
        {
            x->append(epr_data->at(b));
        }
        for(int j=0;j<local_dim;j++)
        {
            for(int i=0;i<epr_numB;i++)
            {
                y[j].append(epr_zee_data->at((epr_zee_dir-1)*local_dim*epr_numB+j*epr_numB+i));
            }
            ui->epr_plot->addGraph(epr_zeeman_plot->axis(QCPAxis::atBottom),epr_zeeman_plot->axis(QCPAxis::atLeft));
            epr_zeeman_plot->graphs().last()->setData(*x,y[j]);
            epr_zeeman_plot->graphs().last()->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
        epr_zeeman_plot->axis(QCPAxis::atBottom)->rescale();
        epr_zeeman_plot->axis(QCPAxis::atLeft)->setRangeLower(*std::min_element(epr_zee_data->constBegin(), epr_zee_data->constEnd()));
        epr_zeeman_plot->axis(QCPAxis::atLeft)->setRangeUpper(*std::max_element(epr_zee_data->constBegin(), epr_zee_data->constEnd()));
        for(int fr=0;fr<epr_numF;fr++)
        {
            for(int i=0;i<i_lim;i++)
            {
                epr_arrows << new QCPItemLine(ui->epr_plot);
                epr_arrows.last()->setClipAxisRect(epr_zeeman_plot);
                epr_arrows.last()->setClipToAxisRect(true);
                epr_arrows.last()->start->setType(QCPItemPosition::ptPlotCoords);
                epr_arrows.last()->start->setAxes(epr_zeeman_plot->axis(QCPAxis::atBottom, 0),epr_zeeman_plot->axis(QCPAxis::atLeft, 0));
                epr_arrows.last()->start->setCoords(epr_trans_data->at(fr*epr_numDir*4*i_lim+(epr_zee_dir-1)*4*i_lim+4*i),epr_trans_data->at(fr*epr_numDir*4*i_lim+(epr_zee_dir-1)*4*i_lim+4*i+1));
                epr_arrows.last()->end->setType(QCPItemPosition::ptPlotCoords);
                epr_arrows.last()->end->setAxes(epr_zeeman_plot->axis(QCPAxis::atBottom, 0),epr_zeeman_plot->axis(QCPAxis::atLeft, 0));
                epr_arrows.last()->end->setCoords(epr_trans_data->at(fr*epr_numDir*4*i_lim+(epr_zee_dir-1)*4*i_lim+4*i),epr_trans_data->at(fr*epr_numDir*4*i_lim+(epr_zee_dir-1)*4*i_lim+4*i+2));
                epr_arrows.last()->setHead(QCPLineEnding(QCPLineEnding::esSpikeArrow,5,6.25,false));
                epr_arrows.last()->setTail(QCPLineEnding::esNone);
                //col = QPen(colour_list[(fr)%13],settings.value("line_size",2).toReal()).color();
                //col.setAlpha(int((epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*i+3)/qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*0+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*1+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*2+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*3+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*4+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*5+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*6+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*7+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*8+3),epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*9+3)))))))))))*200+55));
                //std::cout << "fraction " << fr << " " << i << " " << int((epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*i+3)/qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*0+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*1+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*2+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*3+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*4+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*5+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*6+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*7+3),qMax(epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*8+3),epr_trans_data->at(fr*epr_numDir*40+(epr_zee_dir-1)*40+4*9+3)))))))))))*200+55) << std::endl;
                epr_arrows.last()->setPen(QPen(colour_list[(fr)%13],settings.value("line_size",2).toReal()));
            }
        }
        ui->epr_plot->replot();
        plotting = false;
    }
}

void MainWindow::plot_epr()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    x = new QVector<double>;
    y = new QVector<double>[epr_numT*epr_numF];
    //std::cout << "*-O" << std::endl;
    if(epr_data->length() != (epr_numT*epr_numF+1)*epr_numB){return;}
    for(int b=0;b<epr_numB;b++)
    {
        x->append(epr_data->at(b));
    }
    for(int fr=0;fr<epr_numF;fr++)
    {
        for(int t=0;t<epr_numT;t++)
        {
            for(int b=0;b<epr_numB;b++)
            {
                y[fr*epr_numT+t].append(epr_data->at((fr*epr_numT+t+1)*epr_numB+b));
            }
            if(have_epr_exp_data)
            {
                ui->epr_plot->axisRect(0)->graphs().at(epr_numF*epr_numT + fr*epr_numT + t)->setData(*x,y[fr*epr_numT+t]);
                ui->epr_plot->axisRect(0)->graphs().at(epr_numF*epr_numT + fr*epr_numT + t)->setLineStyle(QCPGraph::lsLine);
                ui->epr_plot->axisRect(0)->graphs().at(epr_numF*epr_numT + fr*epr_numT + t)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssNone));
            }
            else
            {
                ui->epr_plot->axisRect(0)->graphs().at(fr*epr_numT + t)->setData(*x,y[fr*epr_numT+t]);
                ui->epr_plot->axisRect(0)->graphs().at(fr*epr_numT + t)->setLineStyle(QCPGraph::lsLine);
                ui->epr_plot->axisRect(0)->graphs().at(fr*epr_numT + t)->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssNone));
            }
            ui->epr_plot->axisRect(0)->axis(QCPAxis::atBottom)->rescale();
            ui->epr_plot->axisRect(0)->axis(QCPAxis::atLeft)->rescale();
            ui->epr_plot->axisRect(0)->axis(QCPAxis::atLeft)->scaleRange(1.05,0.0);
        }
    }
    if(opmode == "sim" && settings.value("EPRZeeman",1).toInt()==1)
    {
        epr_slider_available = false;
        ui->epr_slider->setMaximum(epr_numDir);
        ui->epr_slider->setValue(1);
        epr_slider_available = true;
        MainWindow::new_epr_dir(1);
    }
    else
    {
        epr_data->clear();
    }
    ui->epr_plot->replot();
    plotting = false;
}

void MainWindow::plot_epr_exp()
{
    if(return_all){return;}
    QSettings settings;
    QVector<double> *x,*y;
    QString label;
    x = new QVector<double>;
    y = new QVector<double>[epr_numT*epr_numF];
    //std::cout << "*-P" << std::endl;
    if(epr_exp_data->length() != (epr_numT*epr_numF+1)*epr_exp_numB){return;}
    for(int b=0;b<epr_exp_numB;b++)
    {
        x->append(epr_exp_data->at(b));
    }
    for(int fr=0;fr<epr_numF;fr++)
    {
        for(int t=0;t<epr_numT;t++)
        {
            for(int b=0;b<epr_exp_numB;b++)
            {
                y[fr*epr_numT+t].append(epr_exp_data->at((fr*epr_numT+t+1)*epr_exp_numB+b));
            }
            ui->epr_plot->addGraph(ui->epr_plot->axisRect(0)->axis(QCPAxis::atBottom),ui->epr_plot->axisRect(0)->axis(QCPAxis::atLeft));
            ui->epr_plot->axisRect()->graphs().last()->setData(*x,y[fr*epr_numT+t]);
            ui->epr_plot->axisRect()->graphs().last()->setPen(QPen(colour_list[(fr*epr_numT + t)%13],settings.value("line_size",2).toReal()));
            ui->epr_plot->axisRect()->graphs().last()->setLineStyle(QCPGraph::lsNone);
            ui->epr_plot->axisRect()->graphs().last()->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssCircle, settings.value("point_size",8).toInt()));
            ui->epr_plot->axisRect(0)->axis(QCPAxis::atBottom)->rescale();
            ui->epr_plot->axisRect(0)->axis(QCPAxis::atLeft)->rescale();
            ui->epr_plot->axisRect(0)->axis(QCPAxis::atLeft)->scaleRange(1.05,0.0);
        }
    }
    //Add empty graphs for calculated data
    for(int fr=0;fr<epr_numF;fr++)
    {
        for(int t=0;t<epr_numT;t++)
        {
            ui->epr_plot->addGraph(ui->epr_plot->axisRect(0)->axis(QCPAxis::atBottom),ui->epr_plot->axisRect(0)->axis(QCPAxis::atLeft));
            if(have_epr_exp_data)
            {
                ui->epr_plot->axisRect()->graphs().last()->setPen(QPen(colour_list[(fr*epr_numT + t)%13],settings.value("line_size",2).toReal()));
                ui->epr_plot->axisRect()->graphs().last()->setLineStyle(QCPGraph::lsLine);
                ui->epr_plot->axisRect()->graphs().last()->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssNone));
            }
            else
            {
                ui->epr_plot->axisRect()->graphs().last()->setPen(QPen(colour_list[(fr*epr_numT + t)%13],settings.value("line_size",2).toReal()));
                ui->epr_plot->axisRect()->graphs().last()->setLineStyle(QCPGraph::lsLine);
                ui->epr_plot->axisRect()->graphs().last()->setScatterStyle(QCPScatterStyle(QCPScatterStyle::ssNone));
            }
        }
    }
    ui->epr_plot->replot();
    epr_exp_data->clear();
    plotting = false;
}

void MainWindow::show_states()
{
    QFile file(cwd+"/"+jobname+"_states.res");
    //std::cout << "*-Q" << std::endl;
    ui->states_box->clear();
    file.open(QFile::ReadOnly | QFile::Text);
    QTextStream ReadFile(&file);
    ui->states_box->setPlainText(ReadFile.readAll());
    ui->states_box->moveCursor(QTextCursor::Start);
    qApp->processEvents();
    file.close();
}

void MainWindow::accept_sus_signal()
{
    if(return_all){return;}
    //std::cout << "*-R" << std::endl;
    emit plot_sus_signal();
}

void MainWindow::accept_sus_exp_signal()
{
    if(return_all){return;}
    //std::cout << "*-S" << std::endl;
    emit plot_sus_exp_signal();
}

void MainWindow::accept_mag_signal()
{
    if(return_all){return;}
    //std::cout << "*-T" << std::endl;
    emit plot_mag_signal();
}

void MainWindow::accept_mag_exp_signal()
{
    if(return_all){return;}
    //std::cout << "*-U" << std::endl;
    emit plot_mag_exp_signal();
}

void MainWindow::accept_mce_signal()
{
    if(return_all){return;}
    //std::cout << "*-V" << std::endl;
    emit plot_mce_signal();
}

void MainWindow::accept_mce_exp_signal()
{
    if(return_all){return;}
    //std::cout << "*-W" << std::endl;
    emit plot_mce_exp_signal();
}

void MainWindow::accept_heat_signal()
{
    if(return_all){return;}
    //std::cout << "*-X" << std::endl;
    emit plot_heat_signal();
}

void MainWindow::accept_heat_exp_signal()
{
    if(return_all){return;}
    //std::cout << "*-Y" << std::endl;
    emit plot_heat_exp_signal();
}

void MainWindow::accept_zeeman_signal()
{
    if(return_all){return;}
    //std::cout << "*-Z" << std::endl;
    emit plot_zeeman_signal();
}

void MainWindow::accept_epr_signal()
{
    if(return_all){return;}
    //std::cout << "*-AA" << std::endl;
    emit plot_epr_signal();
}

void MainWindow::accept_epr_exp_signal()
{
    if(return_all){return;}
    //std::cout << "*-AB" << std::endl;
    emit plot_epr_exp_signal();
}

void MainWindow::accept_states_signal()
{
    //if(return_all){return;}
    //std::cout << "*-AD" << std::endl;
    emit show_states_signal();
}

void MainWindow::accept_progress_signal()
{
    //if(return_all){return;}
    //std::cout << "*-AD3" << std::endl;
    emit progress_bar_signal();
}

void MainWindow::update_progress()
{
    //std::cout << "*-AD4" << std::endl;
    if(return_all)
    {
        ProgressBar->setValue(0);
    }
    else
    {
        ProgressBar->setValue(progress);
    }
}

void MainWindow::accept_text(QString str)
{
    //if(return_all){return;}
    //std::cout << "*-AD2 " << str.toStdString() << std::endl;
    emit show_text_signal(str);
}

void::MainWindow::set_operation_buttons_phi_complete()
{
    //std::cout << "*-AE" << std::endl;
    emit set_operation_buttons_phi_complete_signal();
    StatusLabel->setText("Idle");
}

void::MainWindow::set_operation_buttons()
{
    //std::cout << "*-AF" << std::endl;
    this->stopAction->setEnabled(false);
    this->startAction->setEnabled(true);
    return_all = false;
    phi_running = false;
    StatusLabel->setText("Idle");
}

void::MainWindow::check_new_version()
{
    network_manager = new QNetworkAccessManager(this);
    network_request = new QNetworkRequest;
    connect(network_manager, SIGNAL(finished(QNetworkReply*)),this, SLOT(NetworkReplyFinished(QNetworkReply*)));
    network_request->setUrl(QUrl("http://www.nfchilton.com/current.version"));
    network_manager->get(*network_request);
}

void::MainWindow::check_nfc_message()
{
    network_manager = new QNetworkAccessManager(this);
    network_request = new QNetworkRequest;
    connect(network_manager, SIGNAL(finished(QNetworkReply*)),this, SLOT(NetworkReplyFinishedNFC(QNetworkReply*)));
    network_request->setUrl(QUrl("http://www.nfchilton.com/nfc.message"));
    network_request->setAttribute(QNetworkRequest::CacheLoadControlAttribute, QNetworkRequest::AlwaysNetwork);
    network_manager->get(*network_request);
}

void::MainWindow::update_response_required()
{
    ask_for_update = true;
}

void MainWindow::show_text(QString str)
{
    //if(return_all){return;}
    //std::cout << "*-AG-1" << std::endl;
    ui->output_box->appendPlainText(str);
    //qApp->processEvents();
}

QFont MainWindow::getMonospaceFont()
{
    QFont font("monospace");
    if (MainWindow::isFixedPitch(font)) return font;
    font.setStyleHint(QFont::Monospace);
    if (MainWindow::isFixedPitch(font)) return font;
    font.setStyleHint(QFont::TypeWriter);
    if (MainWindow::isFixedPitch(font)) return font;
    font.setFamily("courier");
    if (MainWindow::isFixedPitch(font)) return font;
    return font;
}

bool MainWindow::isFixedPitch(const QFont & font)
{
    const QFontInfo fi(font);
    return fi.fixedPitch();
}

void MainWindow::new_epr_dir(int value)
//void MainWindow::new_epr_dir()
{
    //std::cout << "*-AH " << std::endl;
    //int value = ui->epr_slider->value();
    epr_zee_dir = value;
    epr_zee_dir_label->setText("x = "+QString::number(epr_dirs->at((value-1)*3),'f',4)+",y = "+QString::number(epr_dirs->at((value-1)*3+1),'f',4)+",z = "+QString::number(epr_dirs->at((value-1)*3+2),'f',4)+"; θ = "+QString::number((180.0/3.141592653589793)*qAcos(epr_dirs->at((value-1)*3+2)),'f',2)+", φ = "+QString::number((180.0/3.141592653589793)*qAtan2(epr_dirs->at((value-1)*3+1),epr_dirs->at((value-1)*3)),'f',2));
    MainWindow::plot_epr_zee();
}

void MainWindow::update_prefs()
{
    QSettings settings;
    if(settings.value("MagXLog",0).toInt()==1){ui->mag_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mag_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MagYLog",0).toInt()==1){ui->mag_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mag_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("RedmagXLog",0).toInt()==1){ui->redmag_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->redmag_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("RedmagYLog",0).toInt()==1){ui->redmag_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->redmag_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MCEXLog",0).toInt()==1){ui->mce_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mce_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("MCEYLog",0).toInt()==1){ui->mce_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->mce_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("HeatXLog",1).toInt()==1){ui->heat_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->heat_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("HeatYLog",1).toInt()==1){ui->heat_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->heat_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("SusXLog",0).toInt()==1){ui->sus_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->sus_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("SusYLog",0).toInt()==1){ui->sus_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->sus_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("ChiXLog",0).toInt()==1){ui->chi_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->chi_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("ChiYLog",0).toInt()==1){ui->chi_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->chi_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("OneOnChiXLog",0).toInt()==1){ui->invchi_plot->xAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->invchi_plot->xAxis->setScaleType(QCPAxis::stLinear);}
    if(settings.value("OneOnChiYLog",0).toInt()==1){ui->invchi_plot->yAxis->setScaleType(QCPAxis::stLogarithmic);}else{ui->invchi_plot->yAxis->setScaleType(QCPAxis::stLinear);}
    int j;
    QCPScatterStyle myScatter;
    myScatter.setShape(QCPScatterStyle::ssCircle);
    myScatter.setSize(settings.value("point_size",8).toReal());
    j = -1;
    for(int i=0;i<ui->mag_plot->graphCount();i++)
    {
        if(ui->mag_plot->graph(i)->scatterStyle().shape() == QCPScatterStyle::ssCircle)
        {
            j++;
            myScatter.setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->mag_plot->graph(i)->setScatterStyle(myScatter);
        }
    }
    j = -1;
    for(int i=0;i<ui->redmag_plot->graphCount();i++)
    {
        if(ui->redmag_plot->graph(i)->scatterStyle().shape() == QCPScatterStyle::ssCircle)
        {
            j++;
            myScatter.setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->redmag_plot->graph(i)->setScatterStyle(myScatter);
        }
    }
    j = -1;
    for(int i=0;i<ui->mce_plot->graphCount();i++)
    {
        if(ui->mce_plot->graph(i)->scatterStyle().shape() == QCPScatterStyle::ssCircle)
        {
            j++;
            myScatter.setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->mce_plot->graph(i)->setScatterStyle(myScatter);
        }
    }
    j = -1;
    for(int i=0;i<ui->heat_plot->graphCount();i++)
    {
        if(ui->heat_plot->graph(i)->scatterStyle().shape() == QCPScatterStyle::ssCircle)
        {
            j++;
            myScatter.setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->heat_plot->graph(i)->setScatterStyle(myScatter);
        }
    }
    j = -1;
    for(int i=0;i<ui->sus_plot->graphCount();i++)
    {
        if(ui->sus_plot->graph(i)->scatterStyle().shape() == QCPScatterStyle::ssCircle)
        {
            j++;
            myScatter.setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->sus_plot->graph(i)->setScatterStyle(myScatter);
        }
    }
    j = -1;
    for(int i=0;i<ui->chi_plot->graphCount();i++)
    {
        if(ui->chi_plot->graph(i)->scatterStyle().shape() == QCPScatterStyle::ssCircle)
        {
            j++;
            myScatter.setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->chi_plot->graph(i)->setScatterStyle(myScatter);
        }
    }
    j = -1;
    for(int i=0;i<ui->invchi_plot->graphCount();i++)
    {
        if(ui->invchi_plot->graph(i)->scatterStyle().shape() == QCPScatterStyle::ssCircle)
        {
            j++;
            myScatter.setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->invchi_plot->graph(i)->setScatterStyle(myScatter);
        }
    }
    j = -1;
    for(int i=0;i<ui->epr_plot->graphCount();i++)
    {
        if(ui->epr_plot->graph(i)->scatterStyle().shape() == QCPScatterStyle::ssCircle)
        {
            j++;
            myScatter.setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
            ui->epr_plot->graph(i)->setScatterStyle(myScatter);
        }
    }
    j = -1;
    for(int i=0;i<ui->mag_plot->graphCount();i++)
    {
        if(ui->mag_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->mag_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<ui->redmag_plot->graphCount();i++)
    {
        if(ui->redmag_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->redmag_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<ui->mce_plot->graphCount();i++)
    {
        if(ui->mce_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->mce_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<ui->heat_plot->graphCount();i++)
    {
        if(ui->heat_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->heat_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<ui->sus_plot->graphCount();i++)
    {
        if(ui->sus_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->sus_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<ui->chi_plot->graphCount();i++)
    {
        if(ui->chi_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->chi_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<ui->invchi_plot->graphCount();i++)
    {
        if(ui->invchi_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->invchi_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<ui->zeeman_plot->graphCount();i++)
    {
        if(ui->zeeman_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->zeeman_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<ui->epr_plot->graphCount();i++)
    {
        if(ui->epr_plot->graph(i)->scatterStyle().shape() != QCPScatterStyle::ssCircle)
        {
            j++;
            ui->epr_plot->graph(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
        }
    }
    j = -1;
    for(int i=0;i<epr_arrows.size();i++)
    {
        j++;
        epr_arrows.at(i)->setPen(QPen(colour_list[(j)%13],settings.value("line_size",2).toReal()));
    }
    ui->mag_plot->replot();
    ui->redmag_plot->replot();
    ui->mce_plot->replot();
    ui->heat_plot->replot();
    ui->sus_plot->replot();
    ui->chi_plot->replot();
    ui->invchi_plot->replot();
    ui->zeeman_plot->replot();
    ui->epr_plot->replot();
    fixedFont.setPointSize(settings.value("fontsize",default_font_size).toInt());
    ui->classic_box->setFont(fixedFont);
    ui->output_box->setFont(fixedFont);
    ui->states_box->setFont(fixedFont);
}

//****************************************************************************************************
