#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "qcustomplot.h"
#include <QMainWindow>
#include <QtGui>
#include <QtCore>
#include <QLabel>
#include <QProgressBar>
#include <QScrollArea>
#include <QPlainTextEdit>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QFrame>
#include <QList>
#include <QLineEdit>
#include <QGroupBox>
#include <QDoubleSpinBox>
#include <QComboBox>
#include <QRadioButton>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QDialog>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void accept_sus_signal();
    void accept_sus_exp_signal();
    void accept_mag_signal();
    void accept_mag_exp_signal();
    void accept_mce_signal();
    void accept_mce_exp_signal();
    void accept_heat_signal();
    void accept_heat_exp_signal();
    void accept_zeeman_signal();
    void accept_epr_signal();
    void accept_epr_exp_signal();
    void accept_states_signal();
    void accept_text(QString);
    void clear_data();
    void set_operation_buttons_phi_complete();
    int default_font_size;
    void accept_progress_signal();

public slots:
    void start_task();
    void stop_task();
    void plot_sus();
    void plot_sus_exp();
    void plot_mag();
    void plot_mag_exp();
    void plot_mce();
    void plot_mce_exp();
    void plot_heat();
    void plot_heat_exp();
    void plot_zeeman();
    void plot_epr_zee();
    void plot_epr();
    void plot_epr_exp();
    void show_states();
    void set_operation_buttons();
    void show_text(QString);
    void update_prefs();
    void update_progress();
    void file_not_there();

private:
    Ui::MainWindow *ui;
    void closeEvent(QCloseEvent *);
    static int const MaxRecentFiles = 10;
    QLabel *StatusLabel,*epr_zee_dir_label;
    QProgressBar *ProgressBar;
    QAction *newAction,*openAction,*saveAction,*saveAsAction,*recentFileActions[MaxRecentFiles],*exitAction,*separatorAction,*startAction,*stopAction,*reportAction,*savePDFaction,*updateAction,*ResToExpAction,*settingsAction,*aboutAction;
    QMenu *fileMenu,*operationMenu,*toolsMenu;
    QToolBar *fileToolBar,*operationToolBar,*toolsToolBar;
    void createActions();
    void createMenus();
    void createToolBars();
    bool classic_mode,ask_for_update;
    QString opmode;
    QList< QFrame* > sites_content;
    QList< QVBoxLayout* > sites_content_box;
    QList< QLabel* > sites_content_label1;
    QList< QLabel* > sites_content_label2;
    QList< QFrame* > sites_collapser;
    QList< QHBoxLayout* > sites_collapser_box;
    QList< QPushButton* > sites_collapse;
    QList< QPushButton* > sites_remove;
    QList< QLineEdit* > sites_name;
    QList< QFrame* > sites_sep;
    QPushButton *new_site_button, *new_interaction_button, *report_button;
    QHBoxLayout *interaction_headings;
    QLabel *site_a_label, *site_b_label, *type_label, *value_label, *remove_label;
    QList< QPushButton* > interactions_remove;
    QNetworkAccessManager *network_manager;
    QNetworkRequest *network_request;
    QString current_version, available_version, nfc_message;
    QDialog *new_version_dialog, *report_dialog;
    QLabel *new_version_label, *report_label1, *report_label2, *report_label3;
    QPushButton *new_version_return;
    QVBoxLayout *new_version_layout, *report_Vlayout;
    QHBoxLayout *report_Hlayout;
    QLineEdit *report_input;
    QCPAxisRect* epr_zeeman_plot;
    QList< QCPItemLine* > epr_arrows;
    bool ask_to_abort();
    int ask_to_save();
    QFont getMonospaceFont();
    bool isFixedPitch(const QFont & font);
    long epr_zee_dir;
    bool epr_slider_available;
    void setCurrentFile(const QString &fileName);
    void updateRecentFileActions();
    QString strippedName(const QString &fullFileName);
    void loadFile(QString fname);

private slots:
    void on_wizard_button_clicked();
    void on_classic_button_clicked();
    void on_sim_button_clicked();
    void on_fit_button_clicked();
    void on_sur_button_clicked();
    void on_coupling_button_clicked();
    void on_matrix_button_clicked();
    //void on_new_site_button_clicked();
    //void on_new_interaction_button_clicked();
    //void on_remove_interaction_button_clicked();
    void remove_sites();
    void change_button_appearance(bool check);
    void move_interaction_button();
    void NetworkReplyFinished(QNetworkReply*);
    void NetworkReplyFinishedNFC(QNetworkReply*);
    void sites_to_interaction(QString str);
    void openFile();
    bool saveFile();
    void saveAsFile();
    void newFile();
    void genReport();
    void report_start();
    void save_pdfs();
    void choose_file();
    void make_new_file();
    void input_has_changed();
    void new_epr_dir(int value);
    //void new_epr_dir();
    void check_new_version();
    void check_nfc_message();
    void update_response_required();
    void copy_res_to_exp();
    void open_settings();
    void open_about();
    void openRecentFile();

signals:
    void plot_sus_signal();
    void plot_sus_exp_signal();
    void plot_mag_signal();
    void plot_mag_exp_signal();
    void plot_mce_signal();
    void plot_mce_exp_signal();
    void plot_heat_signal();
    void plot_heat_exp_signal();
    void plot_zeeman_signal();
    void plot_epr_signal();
    void plot_epr_exp_signal();
    void show_states_signal();
    void show_text_signal(QString);
    void set_operation_buttons_phi_complete_signal();
    void progress_bar_signal();
};

#endif // MAINWINDOW_H


class site_struct : public QMainWindow
{
    Q_OBJECT

public:
    site_struct();
    ~site_struct();
    QFrame *main_frame;
    QVBoxLayout *main_layout, *ang_mom_layout, *presets_layout, *g_layout, *ored_layout, *g_ored_layout, *soc_layout, *cfp_button_layout, *cfp_main_layout, *rot_layouts[3];
    QHBoxLayout *top_layout, *second_layout, *spin_layout, *orbit_layout, *gx_layout, *gy_layout, *gz_layout, *soc_content_layout[6], *cfp_d_layout, *rot_main_layout;
    QGridLayout *cfp_layout;
    QGroupBox *ang_mom_box, *presets_box, *g_box, *ored_box, *soc_box, *cfp_box, *rot_box;
    QLabel *spin_label, *orbit_label, *gx_label, *gy_label, *gz_label, *soc_labels[6], *cfp_q_labels[13], *cfp_k_labels[3], *cfp_d_label, *cfp_e_label, *rot_labels[3];
    QDoubleSpinBox *spin_value, *orbit_value;
    QComboBox *presets_list;
    QRadioButton *g_aniso, *g_iso, *cfp_d, *cfp_cfp;
    QLineEdit *gx_value, *gy_value, *gz_value, *ored_value, *soc_values[6], *cfp_2_values[5], *cfp_4_values[9], *cfp_6_values[13], *cfp_d_value, *cfp_e_value, *rot_values[3];
    QDoubleValidator *g_validator, *double_validator;
public slots:
    void g_iso_copy(QString text);
    void g_iso_set();
    void g_aniso_set();
    void cfp_d_set();
    void cfp_cfp_set();
};

class interaction_struct : public QMainWindow
{
    Q_OBJECT

public:
    interaction_struct();
    ~interaction_struct();
    QFrame *values_frame, *aniso_frame, *anti_frame, *matrix_frame;
    QHBoxLayout *values_layout;
    QComboBox *site_a, *site_b, *type;
    QLineEdit *j_iso, *jx, *jy, *jz, *anti_x, *anti_y, *anti_z, *jxx, *jxy, *jxz, *jyx, *jyy, *jyz, *jzx, *jzy, *jzz;
    QHBoxLayout *aniso_layout, *anti_layout;
    QGridLayout *grid_layout;
    QPushButton *remove;
    QDoubleValidator *double_validator;
public slots:
    void type_changed(int);
};
