!!!!!!!!!!        PHI: phi.f90                                                                !!!!!!!!!!
!!!!!!!!!!        Nicholas F. Chilton     							                          !!!!!!!!!!
!!!!!!!!!!        email: nfchilton@gmail.com                                                  !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        This file is part of PHI.                                                   !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is free software: you can redistribute it and/or modify                 !!!!!!!!!!
!!!!!!!!!!        it under the terms of the GNU General Public License as published by        !!!!!!!!!!
!!!!!!!!!!        the Free Software Foundation, either version 3 of the License, or           !!!!!!!!!!
!!!!!!!!!!        (at your option) any later version.                                         !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is distributed in the hope that it will be useful,                      !!!!!!!!!!
!!!!!!!!!!        but WITHOUT ANY WARRANTY; without even the implied warranty of              !!!!!!!!!!
!!!!!!!!!!        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               !!!!!!!!!!
!!!!!!!!!!        GNU General Public License for more details.                                !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        You should have received a copy of the GNU General Public License           !!!!!!!!!!
!!!!!!!!!!        along with PHI. If not, see <http://www.gnu.org/licenses/>.                 !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        We request that any results obtained through the use of PHI                 !!!!!!!!!!
!!!!!!!!!!        are accompanied by the following reference:                                 !!!!!!!!!!
!!!!!!!!!!        N. F. Chilton, R. P. Anderson, L. D. Turner, A. Soncini and                 !!!!!!!!!!
!!!!!!!!!!        K. S. Murray, J. Comput. Chem., 2013, 34, 1164 - 1175                       !!!!!!!!!!

#ifdef gui
module phi
	use iso_c_binding
#else
program phi
#endif
	use data
	use props
	use fitting
	implicit none

#ifdef gui
	contains
	subroutine PhiFort(pass_work_dir,a_len,pass_job_name,b_len,ptr) bind(c,name='PhiFort')
	character(c_char),dimension(10001),intent(in)::pass_work_dir,pass_job_name
	integer(c_long),intent(in)::a_len,b_len
	type(c_ptr),intent(in),value::ptr
	integer::j,k
	call deallocate_all
	close(40)
	close(43)
	close(24)
	close(41)
	close(30)
	ptr_to_C_code = ptr
	WorkDir = ''
	JobTitle = ''
	k = a_len
	do j=1,k
		WorkDir(j:j) = pass_work_dir(j)
	end do
	k = b_len
	do j=1,k
		JobTitle(j:j) = pass_job_name(j)
	end do
#else
	integer::j,k
	call getcwd(WorkDir)
	call GET_COMMAND_ARGUMENT(1,JobTitle)
#endif
	return_all = .false.
	mpi_size = 1
	mpi_rank = 0
	mpi_local_size = 1
	mpi_local_rank = 0
	xPU = 0
	call check_compile_options
	call control('start')
	call set_consts
	call smart_reading
	if(.not. return_all) then
		call set_totaldim
		if(OperationMode(1:3) == 'cou') then
			call couple_states(1)
		else
			if(approx == 1) call couple_states(0)
			if(approx == 0) call construct_map
			if(OperationMode(1:3) /= 'mat' .and. OperationMode(1:3) /= 'wav' .and. OperationMode(1:3) /= 'cou') call read_exp_data
#ifdef gui
			if(OperationMode(1:3) == 'sim' .or. OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') call send_exp_data_to_gui
#endif
			if(.not. return_all) then
				if(OperationMode(1:3) == 'sim') then
					do k = 1,N
						if(force_cubic(k) == 1) then
							A4(k,4) = 5.0_8*A4(k,0)
							A6(k,4) = -21.0_8*A6(k,0)
							epr_strain_A4(k,4) = 5.0_8*epr_strain_A4(k,0)
							epr_strain_A6(k,4) = -21.0_8*epr_strain_A6(k,0)
						end if
					end do
					do k = 1,N
						if(D_not_B20(k) == 1) then
							A2(k,0) = A2(k,0)/3.0_8
							epr_strain_A2(k,0) = epr_strain_A2(k,0)/3.0_8
						end if
						if(do_rotate(k) == 1) then
							call rotate_CFP(CFP_rot(k,1),CFP_rot(k,2),CFP_rot(k,3),A2(k,:),A4(k,:),A6(k,:))
							call rotate_mat(CFP_rot(k,1),CFP_rot(k,2),CFP_rot(k,3),Gmat(:,:,k))
						end if
						do j = 1,N
							if(do_exrotate(k,j) == 1) call rotate_mat(EX_rot(k,j,1),EX_rot(k,j,2),EX_rot(k,j,3),EXmat(:,:,k,j))
						end do
					end do
					call output_text("Simulation of:",.false.)
					if(scan(OperationModeB,'m',.false.) /= 0) then
						call output_text("  Magnetization",.false.)
						if(approx == 0) call calc_mag(lamda,orbred,EXmat,Gmat,A2,A4,A6,ImpQuant)
					end if
					if(scan(OperationModeB,'c',.false.) /= 0) then
						call output_text("  MCE",.false.)
						if(approx == 0) call calc_mce(lamda,orbred,EXmat,Gmat,A2,A4,A6)
					end if
					if(scan(OperationModeB,'s',.false.) /= 0) then
						call output_text("  Susceptibility",.false.)
						if(approx == 0) call calc_sus(lamda,orbred,EXmat,Gmat,A2,A4,A6,sus_tip,sus_zJ,ImpQuant)
					end if
					if(scan(OperationModeB,'t',.false.) /= 0) then
						call output_text("  Susceptibility Tensor",.false.)
						if(approx == 0) call calc_tensor(lamda,orbred,EXmat,Gmat,A2,A4,A6)
					end if
					if(scan(OperationModeB,'z',.false.) /= 0) then
						call output_text("  Zeeman Effect",.false.)
						if(approx == 0) call calc_zee(lamda,orbred,EXmat,Gmat,A2,A4,A6)
					end if
					if(scan(OperationModeB,'e',.false.) /= 0) then
						epr_linewidth = epr_linewidth*(1.0D9)*(6.62606957D-34)	!linewidth input is in GHz
						epr_mosaic = epr_mosaic*pie/180.0_8	!mosaic input is in degrees
						call output_text("  EPR",.false.)
						if(approx == 0 .and. epr_do_subspace == 0) call calc_epr(lamda,orbred,EXmat,Gmat,A2,A4,A6,epr_linewidth,epr_voigt,epr_mosaic,epr_strain_lamda,epr_strain_orbred,epr_strain_EXmat,epr_strain_Jss,epr_strain_dss,epr_strain_Gfactor,epr_strain_A2,epr_strain_A4,epr_strain_A6,CFP_rot,EX_rot)
						if(approx == 0 .and. epr_do_subspace == 1) then
							call pert_prep(lamda,orbred,EXmat,Gmat,A2,A4,A6,epr_pert_vecs,epr_pert_vals)
							call pert_epr(epr_subdim,epr_pert_vecs,epr_pert_vals,orbred,EXmat,Gmat,epr_linewidth,epr_voigt,epr_mosaic,epr_strain_lamda,epr_strain_orbred,epr_strain_EXmat,epr_strain_Jss,epr_strain_dss,epr_strain_Gfactor,epr_strain_A2,epr_strain_A4,epr_strain_A6,CFP_rot,EX_rot)
						end if
					end if
					if(scan(OperationModeB,'h',.false.) /= 0) then
						call output_text("  Heat Capacity",.false.)
						if(approx == 0) call calc_heat_capacity(lamda,orbred,EXmat,Gmat,A2,A4,A6,heat_lattice,ImpQuant)
					end if
					if(scan(OperationModeB,'l',.false.) /= 0 .or. scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0) then
						call output_text("  States",.false.)
						if(approx == 0) call calc_states(lamda,orbred,EXmat,Gmat,A2,A4,A6)
					end if
					if(approx == 1) call calc_coupled_props(Jss,Gfactor,sus_tip,sus_zJ,ImpQuant,heat_lattice)
					call print_results
				else if(OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') then
					if(mpi_rank == 0) then
						if(OperationMode(1:3) == 'fit') call output_text("Fit of:",.false.)
						if(OperationMode(1:3) == 'sur') call output_text("Survey of:",.false.)
						if(scan(OperationModeB,'m',.false.) /= 0) call output_text("  Magnetization",.false.)
						if(scan(OperationModeB,'c',.false.) /= 0) call output_text("  MCE",.false.)
						if(scan(OperationModeB,'s',.false.) /= 0) call output_text("  Susceptibility",.false.)
						if(scan(OperationModeB,'e',.false.) /= 0) call output_text("  EPR",.false.) 
						if(scan(OperationModeB,'h',.false.) /= 0) call output_text("  Heat Capacity",.false.) 
						if(scan(OperationModeB,'l',.false.) /= 0) call output_text("  Energy Levels",.false.)
						if(scan(OperationModeB,'g',.false.) /= 0) call output_text("  G-tensors",.false.)
						if(scan(OperationModeB,'d',.false.) /= 0) call output_text("  G-tensors (dirs)",.false.) 
					end if
					if(OperationMode(1:3) == 'fit') then
						call run_fit
					else if(OperationMode(1:3) == 'sur') then
						call run_survey
					end if
				! else if(OperationMode(1:3) == 'eig') then
					! if(mpi_rank == 0) write(6,'(A10)') "Eigen Test"
					! call eigen_test(lamda,orbred,EXmat,Gmat,A2,A4,A6)
				else if(OperationMode(1:3) == 'mat' .or. OperationMode(1:3) == 'wav') then
					do k = 1,N
						if(D_not_B20(k) == 1) then
							A2(k,0) = A2(k,0)/3.0_8
						end if
						if(do_rotate(k) == 1) then
							call rotate_CFP(CFP_rot(k,1),CFP_rot(k,2),CFP_rot(k,3),A2(k,:),A4(k,:),A6(k,:))
							call rotate_mat(CFP_rot(k,1),CFP_rot(k,2),CFP_rot(k,3),Gmat(:,:,k))
						end if
						do j = 1,N
							if(do_exrotate(k,j) == 1) call rotate_mat(EX_rot(k,j,1),EX_rot(k,j,2),EX_rot(k,j,3),EXmat(:,:,k,j))
						end do
					end do
					if(OperationMode(1:3) == 'mat') then
						call output_text("Matrix Elements",.false.)
						call print_matrix_elements(lamda,orbred,EXmat,Gmat,A2,A4,A6)
						call site_operators
					else if(OperationMode(1:3) == 'wav') then
						call output_text("Wavefunction",.false.)
						call print_wave_function(lamda,orbred,EXmat,Gmat,A2,A4,A6)
					end if
				else
					if(mpi_rank == 0 .and. .not. return_all) call output_text("Invalid OpMode, please check input",.false.)
					call control('kill ')
#ifdef gui
					return
#endif
				end if
			else
				!write(6,*) "DA"
#ifdef gui
				return
#endif
			end if
		end if
	else
		!write(6,*) "CZ"
!#ifdef gui
!		return
!#endif
	end if
	if(return_all) then
		call deallocate_all
#ifdef mpi
		call MPI_FINALIZE(mpi_error1)
#endif
	else
		call control('stop ')
	end if
	close(40)
	close(43)
	close(24)
	close(41)
	close(30)
#ifdef gui
	!write(6,*) "PHI out!"
	return
	end subroutine PhiFort
end module phi
#else
end program phi
#endif
