!!!!!!!!!!        PHI: powder.f90                                                             !!!!!!!!!!
!!!!!!!!!!        Nicholas F. Chilton     							                          !!!!!!!!!!
!!!!!!!!!!        email: nfchilton@gmail.com                                                  !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        This file is part of PHI.                                                   !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is free software: you can redistribute it and/or modify                 !!!!!!!!!!
!!!!!!!!!!        it under the terms of the GNU General Public License as published by        !!!!!!!!!!
!!!!!!!!!!        the Free Software Foundation, either version 3 of the License, or           !!!!!!!!!!
!!!!!!!!!!        (at your option) any later version.                                         !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is distributed in the hope that it will be useful,                      !!!!!!!!!!
!!!!!!!!!!        but WITHOUT ANY WARRANTY; without even the implied warranty of              !!!!!!!!!!
!!!!!!!!!!        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               !!!!!!!!!!
!!!!!!!!!!        GNU General Public License for more details.                                !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        You should have received a copy of the GNU General Public License           !!!!!!!!!!
!!!!!!!!!!        along with PHI. If not, see <http://www.gnu.org/licenses/>.                 !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        We request that any results obtained through the use of PHI                 !!!!!!!!!!
!!!!!!!!!!        are accompanied by the following reference:                                 !!!!!!!!!!
!!!!!!!!!!        N. F. Chilton, R. P. Anderson, L. D. Turner, A. Soncini and                 !!!!!!!!!!
!!!!!!!!!!        K. S. Murray, J. Comput. Chem., 2013, 34, 1164 - 1175                       !!!!!!!!!!

module powder
	use data
	implicit none

	contains
	
	subroutine ZCW(intLevel,intCover,field_vec,numdir,vecdir)
	implicit none
	integer,intent(in):: intLevel,intCover
	integer,intent(out)::numdir
	real(kind=8),allocatable::vecdir(:,:)
	integer::i,c(3)
	integer,allocatable::g(:)
	real(kind=8)::a,b,field_vec(3)
	if(return_all) then
		!write(6,*) "CZ"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*CZ"
	end if
	if(intLevel == -1) then
		NumDir = 3
		allocate(vecdir(NumDir,10))
		vecdir = 0.0_8
		vecdir(1,1) = 1.0_8
		vecdir(1,2) = 0.0_8
		vecdir(1,3) = 0.0_8
		vecdir(2,1) = 0.0_8
		vecdir(2,2) = 1.0_8
		vecdir(2,3) = 0.0_8
		vecdir(3,1) = 0.0_8
		vecdir(3,2) = 0.0_8
		vecdir(3,3) = 1.0_8
		vecdir(:,10) = 1.0_8/dble(numdir)
	else if(intLevel == -2) then
		NumDir = 1
		allocate(vecdir(NumDir,10))
		vecdir = 0.0_8
		vecdir(:,10) = 1.0_8
		if(intCover == 1) then
			vecdir(1,1) = 1.0_8
			vecdir(1,2) = 0.0_8
			vecdir(1,3) = 0.0_8
		else if(intCover == 2) then
			vecdir(1,1) = 0.0_8
			vecdir(1,2) = 1.0_8
			vecdir(1,3) = 0.0_8
		else if(intCover == 3) then
			vecdir(1,1) = 0.0_8
			vecdir(1,2) = 0.0_8
			vecdir(1,3) = 1.0_8
		else if(intCover == 0) then
			vecdir(1,1) = field_vec(1)/radial(field_vec)
			vecdir(1,2) = field_vec(2)/radial(field_vec)
			vecdir(1,3) = field_vec(3)/radial(field_vec)
		else
			call output_text("Single field direction incorrect, please check input",.false.)
			call control('kill ')
			return
		end if
	else if(intLevel >= 0) then
		if(intCover == 1) then	!sphere
			c(1) = 1
			c(2) = 2
			c(3) = 1
		else if(intCover == 2) then	!hemisphere
			c(1) = -1
			c(2) = 1
			c(3) = 1
		else if(intCover == 3) then	!octant
			c(1) = -1
			c(2) = 1
			c(3) = 4
		else if(intCover == 4) then !axial
			c = 0
		else
			call output_text("Incorrect integration range for ZCW, please check input",.false.)
			call control('kill ')
			return
		end if
		if(intCover <= 3) then
			allocate(g(intLevel+3))
			g(1) = 8
			g(2) = 13
			do i=3,intLevel+3
				g(i) = g(i-1) + g(i-2)
			end do
			NumDir = g(intLevel+3)
			allocate(vecdir(NumDir,10))
			do i=1,NumDir
				a = (2.0_8*Pie/dble(c(3)))*dmod(dble(i-1)*dble(g(intLevel+1))/NumDir,1.0_8)
				b = dacos(dble(c(1))*((dble(c(2))*dmod(dble(i-1)/NumDir,1.0_8))-1.0_8))
				vecdir(i,1) = dsin(b)*dcos(a)
				vecdir(i,2) = dsin(b)*dsin(a)
				vecdir(i,3) = dcos(b)
				!vecdir(i,4) = b
				!vecdir(i,5) = a
				vecdir(i,4) = dcos(b)*dcos(a)	!gives d(Vec)/d(Theta)
				vecdir(i,5) = dcos(b)*dsin(a)
				vecdir(i,6) = -dsin(b)
				vecdir(i,7) = -dsin(b)*dsin(a)	!gives d(Vec)/d(Phi)
				vecdir(i,8) = dsin(b)*dcos(a)
				vecdir(i,9) = 0.0_8
				vecdir(i,10) = 1.0_8/dble(numdir)
			end do
			deallocate(g)
		else if(intCover == 4) then
			NumDir = intLevel
			allocate(vecdir(NumDir,10))
			do i = 1,intLevel
				a = 0.0_8
				b = i*(0.5_8*pie/intLevel)
				vecdir(i,1) = dsin(b)*dcos(a)
				vecdir(i,2) = dsin(b)*dsin(a)
				vecdir(i,3) = dcos(b)
				vecdir(i,4) = dcos(b)*dcos(a)	!gives d(Vec)/d(Theta)
				vecdir(i,5) = dcos(b)*dsin(a)
				vecdir(i,6) = -dsin(b)
				vecdir(i,7) = -dsin(b)*dsin(a)	!gives d(Vec)/d(Phi)
				vecdir(i,8) = dsin(b)*dcos(a)
				vecdir(i,9) = 0.0_8
				vecdir(i,10) = dsin(b)*0.5_8*pie/intLevel
			end do
		end if
	else
		call output_text("Incorrect integration scheme selected, please check input",.false.)
		call control('kill ')
		return
	end if
	end subroutine ZCW
	
	subroutine angle_grid(grid_dens,numdir,vecdir)
	implicit none
	integer,intent(in):: grid_dens
	integer,intent(out)::numdir
	integer::i,j,k
	real(kind=8),allocatable::vecdir(:,:)
	real(kind=8)::a,b
	if(return_all) then
		!write(6,*) "CZ2"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*CZ2"
	end if
	if(grid_dens <= 2) then
		call output_text("Grid density must be greater than two",.false.)
		call control('kill ')
		return
	end if
	NumDir = (grid_dens+1)*grid_dens
	allocate(vecdir(NumDir,9))
	k = 0
	do i = 0,grid_dens
		do j = 1,grid_dens
			k = k + 1
			a = j*(2.0_8*pie/grid_dens)
			b = i*(pie/grid_dens)
			vecdir(k,1) = dsin(b)*dcos(a)
			vecdir(k,2) = dsin(b)*dsin(a)
			vecdir(k,3) = dcos(b)
			vecdir(k,4) = dcos(b)*dcos(a)	!gives d(Vec)/d(Theta)
			vecdir(k,5) = dcos(b)*dsin(a)
			vecdir(k,6) = -dsin(b)
			vecdir(k,7) = -dsin(b)*dsin(a)	!gives d(Vec)/d(Phi)
			vecdir(k,8) = dsin(b)*dcos(a)
			vecdir(k,9) = 0.0_8
		end do
	end do
	end subroutine angle_grid

end module powder
