!!!!!!!!!!        PHI: props.f90                                                              !!!!!!!!!!
!!!!!!!!!!        Nicholas F. Chilton     							                          !!!!!!!!!!
!!!!!!!!!!        email: nfchilton@gmail.com                                                  !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        This file is part of PHI.                                                   !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is free software: you can redistribute it and/or modify                 !!!!!!!!!!
!!!!!!!!!!        it under the terms of the GNU General Public License as published by        !!!!!!!!!!
!!!!!!!!!!        the Free Software Foundation, either version 3 of the License, or           !!!!!!!!!!
!!!!!!!!!!        (at your option) any later version.                                         !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        PHI is distributed in the hope that it will be useful,                      !!!!!!!!!!
!!!!!!!!!!        but WITHOUT ANY WARRANTY; without even the implied warranty of              !!!!!!!!!!
!!!!!!!!!!        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               !!!!!!!!!!
!!!!!!!!!!        GNU General Public License for more details.                                !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        You should have received a copy of the GNU General Public License           !!!!!!!!!!
!!!!!!!!!!        along with PHI. If not, see <http://www.gnu.org/licenses/>.                 !!!!!!!!!!
!!!!!!!!!!                                                                                    !!!!!!!!!!
!!!!!!!!!!        We request that any results obtained through the use of PHI                 !!!!!!!!!!
!!!!!!!!!!        are accompanied by the following reference:                                 !!!!!!!!!!
!!!!!!!!!!        N. F. Chilton, R. P. Anderson, L. D. Turner, A. Soncini and                 !!!!!!!!!!
!!!!!!!!!!        K. S. Murray, J. Comput. Chem., 2013, 34, 1164 - 1175                       !!!!!!!!!!

module props
	use data
	use powder
	use ang_mom
	implicit none

	contains
	
	subroutine calc_coupled_props(local_Jss,local_Gfactor,local_sus_tip,local_sus_zJ,local_ImpQuant,local_heat_lattice)
	! Acts as an intermediary for the calculation of all properties in the coupled basis
	implicit none
	real(kind=8)::local_Jss(:,:,:),local_Gfactor(:,:),local_sus_tip,local_sus_zJ,local_ImpQuant,local_heat_lattice(2)
	real(kind=8),allocatable::S_energies(:),S_vectors(:,:),S_Gfactors(:),S_projections(:,:),ordered_energies(:),ordered_Gfactors(:),ordered_projections(:,:),ordered_vectors(:,:)
	integer,allocatable::order(:),ordered_spins(:)
	integer::k
	if(return_all) then
		!write(6,*) "A"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*A"
	end if
	allocate(S_energies(Sdim),S_vectors(Sdim,Sdim),S_Gfactors(Sdim),S_projections(Sdim,N),order(Sdim),ordered_energies(Sdim),ordered_Gfactors(Sdim),ordered_projections(Sdim,N),ordered_vectors(Sdim,Sdim),ordered_spins(Sdim))
	call evaluate_coupled_system(local_Jss,local_Gfactor,S_energies,S_vectors,S_Gfactors,S_projections)
	call re_order(Sdim,S_energies,order,'min')
	if(.not. return_all) then
		do k=1,Sdim
			ordered_energies(k) = S_energies(order(k))
			ordered_Gfactors(k) = S_Gfactors(order(k))
			ordered_projections(k,:) = S_projections(order(k),:)
			ordered_vectors(:,k) = S_vectors(:,order(k))
			ordered_spins(k) = S_basis(order(k),maxSnum-1)
		end do
		if(scan(OperationModeB,'m',.false.) /= 0) then
			call calc_mag_coupled(ordered_spins,ordered_energies,ordered_Gfactors,local_ImpQuant)
		end if
		if(scan(OperationModeB,'c',.false.) /= 0) then
			call calc_mce_coupled(ordered_spins,ordered_energies,ordered_Gfactors)
		end if
		if(scan(OperationModeB,'s',.false.) /= 0) then
			call calc_sus_coupled(ordered_spins,ordered_energies,ordered_Gfactors,local_sus_tip,local_sus_zJ,local_ImpQuant)
		end if
		if(scan(OperationModeB,'z',.false.) /= 0) then
			call calc_zee_coupled(ordered_spins,ordered_energies,ordered_Gfactors)
		end if
		if(scan(OperationModeB,'h',.false.) /= 0) then
			call calc_heat_capacity_coupled(ordered_spins,ordered_energies,ordered_Gfactors,local_heat_lattice,local_ImpQuant)
		end if
		if(scan(OperationModeB,'i',.false.) /= 0) then
			!call calc_ins_coupled(lamda,orbred,EXmat,Gmat,A2,A4,A6)
		end if
		if(scan(OperationModeB,'l',.false.) /= 0 .or. scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0) then
			if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) call calc_states_coupled(ordered_spins,ordered_energies,ordered_vectors,ordered_Gfactors,ordered_projections)
		end if
		deallocate(S_energies,S_vectors,S_Gfactors,S_projections,order,ordered_energies,ordered_Gfactors,ordered_projections,ordered_vectors,ordered_spins)
	end if
	end subroutine calc_coupled_props
	
	subroutine calc_sus_coupled(S_spins,S_energies,S_Gfactors,local_sus_tip,local_sus_zJ,local_ImpQuant)
	! Calculates the susceptibility in the coupled basis
	implicit none
	real(kind=8)::S_energies(:),S_Gfactors(:),h,htemp,local_B,base,local_sus_tip,local_sus_zJ,local_ImpQuant
	real(kind=8),allocatable::local_eigenvalues(:,:),Z(:)
	integer::S_spins(:),i,a,c,step,k,j,c_lim
	logical::FD
	if(return_all) then
		!write(6,*) "B"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*B"
	end if
	if(.not. sus_differential) c_lim = 2
	if(sus_differential) c_lim = 3
	allocate(local_eigenvalues(c_lim,totaldim),Z(c_lim))
	sus_calc = 0.0_8
	do a=1,sus_numB
		FD = .false.
		if(sus_differential) h = (EPS**(1/6.0_8))*max(1.0_8,sus_fields(a))	!(5.5D-3)*max(1.0_8,sus_fields(a))
		if(.not. sus_differential) h = (EPS**(1/4.5_8))*max(1.0_8,sus_fields(a))
		htemp = sus_fields(a) + h
		call donothing(htemp)
		h = htemp - sus_fields(a)
		if(sus_fields(a) < h) FD = .true.
		do c=1,c_lim
			if(return_all) return
			if(FD) then
				if(c == 1) step = 0
				if(c == 2) step = 1
				if(c == 3) step = 2
			else
				if(c == 1) step = -1
				if(c == 2 .and. sus_differential) step = 0
				if(c == 2 .and. .not. sus_differential) step = 1
				if(c == 3) step = 1
			end if
			local_B = (sus_fields(a)+(step*h)) + static_field_magnitude
			i = 0
			do k = 1,Sdim
				do j = -S_spins(k),S_spins(k),2
					i = i + 1
					local_eigenvalues(c,i) = 0.5_8*j*S_Gfactors(k)*beta*local_B + S_energies(k)
				end do
			end do
		end do
		base = minval(local_eigenvalues(1,:))
		do c = 2,c_lim
			if(minval(local_eigenvalues(c,:)) < base) base = minval(local_eigenvalues(c,:))
		end do
		local_eigenvalues = local_eigenvalues - base
		do k=1,sus_numT
			Z = 0.0_8
			do c = 1,c_lim
				do j = 1,totaldim
					Z(c) = Z(c) + dexp((-local_eigenvalues(c,j)/(kB*sus_temps(k))))
				end do
				Z(c) = dlog(Z(c))
			end do
			if(sus_differential) then
				sus_calc(a,k) = sus_calc(a,k) + 0.1_8*Na*kB*sus_temps(k)*(Z(3)+Z(1)-2.0_8*Z(2))/(h*h)
			else
				if(FD) sus_calc(a,k) = sus_calc(a,k) + Na*kB*sus_temps(k)*(Z(2)-Z(1))/(10*h*sus_fields(a))
				if(.not. FD) sus_calc(a,k) = sus_calc(a,k) + Na*kB*sus_temps(k)*0.5_8*(Z(2)-Z(1))/(10*h*sus_fields(a))
			end if
		end do
	end do
	if(return_all) return
	if(local_sus_tip /= 0.0_8) sus_calc = sus_calc + local_sus_tip
	if(local_sus_zJ /= 0.0_8) sus_calc = sus_calc/(1.0_8-(local_sus_zJ*wavenumber_to_erg/(Na*erg_beta*erg_beta))*sus_calc)
	if(ImpS /=0 .and. local_ImpQuant /= 0.0_8) then
		do a=1,sus_numB
			do k = 1,sus_numT
				if(sus_differential) then
					if(ImpS == 1) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta*beta)/(5.0_8*kB*sus_temps(k)*(1+cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))
					if(ImpS == 2) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(4.0_8*Na*beta*beta*(2.0_8+cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))/(5.0_8*kB*sus_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))**2))
					if(ImpS == 3) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta*beta)*((1.0_8/(cosh(sus_fields(a)*beta/(kB*sus_temps(k)))))*(1.0_8/(cosh(sus_fields(a)*beta/(kB*sus_temps(k)))))+4.0_8*(1.0_8/(cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))*(1.0_8/(cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))))/(10.0_8*kB*sus_temps(k))
					if(ImpS == 4) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(4.0_8*Na*beta*beta)*(10+10*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+4*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(5*kB*sus_temps(k)*(1+2*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))*(1+2*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))
					if(ImpS == 5) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta*beta)*(35+40*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+20*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+8*cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2*cosh(8.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(10*kB*sus_temps(k)*(cosh(sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(3.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(5.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))*(cosh(sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(3.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(5.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))
					if(ImpS == 6) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(4.0_8*Na*beta*beta*(28.0_8+35.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+20.0_8*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+10.0_8*cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+4.0_8*cosh(8.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(10.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))/(5.0_8*kB*sus_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))**2))
					if(ImpS == 7) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta*beta*(0.4_8*dexp(20.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+1.6_8*dexp(22.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+4.0_8*dexp(24.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+8.0_8*dexp(26.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+14.0_8*dexp(28.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+22.4_8*dexp(30.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+33.6_8*dexp(32.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+22.4_8*dexp(34.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+14.0_8*dexp(36.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+8.0_8*dexp(38.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+4.0_8*dexp(40.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+1.6_8*dexp(42.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+0.4_8*dexp(44.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))/(kb*sus_temps(k)*((dexp(9.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(11.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(13.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(15.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(17.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(19.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(21.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(23.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))**2))
				else
					if(ImpS == 1) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*tanh(sus_fields(a)*beta/(kB*sus_temps(k)))
					if(ImpS == 2) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*4.0_8*sinh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))/(1.0_8+2.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 3) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*(tanh(sus_fields(a)*beta/(kB*sus_temps(k)))+2*tanh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 4) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*4.0_8*(sinh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*sinh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(1+2*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 5) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*(-4*sinh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+10*sinh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+3*tanh(sus_fields(a)*beta/(kB*sus_temps(k))))/(1+2*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 6) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*4.0_8*(sinh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*sinh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+3.0_8*sinh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(1.0_8+2.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 7) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*(-7.0_8*dexp(9.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))-5.0_8*dexp(11.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))-3.0_8*dexp(13.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))-1.0_8*dexp(15.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+1.0_8*dexp(17.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+3.0_8*dexp(19.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+5.0_8*dexp(21.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+7.0_8*dexp(23.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(dexp(9.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(11.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(13.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(15.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(17.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(19.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(21.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(23.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
				end if
				if(ImpS > 7) then
					call output_text("Monomer impurities with S > 3.5 are not yet implemented",.false.)
					call control('kill ')
					return
				end if
			end do
		end do
	end if
	do k = 1,sus_numT
		sus_calc(:,k) = sus_calc(:,k)*sus_temps(k)
	end do
	if((OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') .and. sus_autoscale == 1) then
		do a = 1,sus_numB
			sus_calc(a,:) = sus_calc(a,:)*(sus_exp(a,sus_numT)/sus_calc(a,sus_numT))
		end do
	end if
	deallocate(local_eigenvalues,Z)
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,sus_numB
			do k = 1,sus_numT
				if(a == 0) then
					call send_plot_data("sus_cal",sus_numT,sus_temps(k))
				else
					call send_plot_data("sus_cal",sus_numT,sus_calc(a,k))
				end if
			end do
		end do
		call send_plot_signal("susC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_sus_coupled
	
	subroutine calc_sus(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_sus_tip,local_sus_zJ,local_ImpQuant)
	! Calculates the magnetic susceptibility of the system
	implicit none
	real(kind=8),allocatable::vecdir(:,:),dummyR(:,:),static_real(:,:)
	complex(kind=8),allocatable::dummyI(:,:),static_imag(:,:)
	real(kind=8)::h,htemp
	integer::numdir,a,num_threads
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:),local_sus_tip,local_sus_zJ,local_ImpQuant
	logical::FD
	character(len=1)::RI
	!---OMP DATA---!
	integer::g,c,step,k,j,c_lim
	real(kind=8)::local_B(3),base
	real(kind=8),allocatable::local_matrix_real(:,:),local_eigenvalues(:,:),Z(:)
	complex(kind=8),allocatable::local_matrix_imag(:,:)
#ifdef mpi
	integer::g_start,g_finish
	real(kind=8),allocatable::loc_sus(:,:)
#endif
	if(return_all) then
		!write(6,*) "C"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*C"
	end if
	if(.not. sus_differential) c_lim = 2
	if(sus_differential) c_lim = 3
	sus_calc = 0.0_8
	call ZCW(sus_intLevel,sus_intCover,sus_field_vec,numdir,vecdir)
	if(aniso == 0 .and. numdir == 1 .and. vecdir(1,1) == 0.0_8 .and. vecdir(1,2) == 0.0_8) then
		RI = 'R'
		allocate(static_real(totaldim,totaldim),dummyI(1,1))
	else
		RI = 'I'
		allocate(static_imag(totaldim,totaldim),dummyR(1,1))
	end if
#ifdef mpi
	call set_mpi_limits(numdir,g_start,g_finish)
#endif
#ifdef omp
	num_threads = omp_get_num_procs()
	if(MaxCPU >= num_threads) then
		num_threads = omp_get_num_procs()
	else if(MaxCPU == 0)  then
		if(num_threads > 1) num_threads = omp_get_num_procs()-1
	else
		num_threads = MaxCPU
	end if
	if(numdir < num_threads) num_threads = numdir
#endif
	if(RI == 'I') call matrix_elements('I','U',dummyR,static_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	if(RI == 'R') call matrix_elements('R','U',static_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	do a=1,sus_numB
		FD = .false.
		if(sus_differential) h = (EPS**(1/6.0_8))*max(1.0_8,sus_fields(a))	!(5.5D-3)*max(1.0_8,sus_fields(a))
		if(.not. sus_differential) h = (EPS**(1/4.5_8))*max(1.0_8,sus_fields(a))
		htemp = sus_fields(a) + h
		call donothing(htemp)
		h = htemp - sus_fields(a)
		if(sus_fields(a) < h) FD = .true.
#ifdef omp
		!$OMP PARALLEL IF(num_threads > 1 .and. numdir > 1) NUM_THREADS(num_threads) SHARED(num_threads,static_real,static_imag,a,sus_numB,h,numdir,sus_fields,vecdir,RI,dummyR,dummyI,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,totaldim,sus_numT,sus_temps,sus_calc) PRIVATE(g,c,step,k,j,local_B,base,Z,local_matrix_real,local_eigenvalues,local_matrix_imag)
#endif
		if(RI == 'I' .and. .not. allocated(local_matrix_imag)) allocate(local_matrix_imag(totaldim,totaldim))
		if(RI == 'R' .and. .not. allocated(local_matrix_real)) allocate(local_matrix_real(totaldim,totaldim))
		if(.not. allocated(local_eigenvalues)) allocate(local_eigenvalues(c_lim,totaldim))
		if(.not. allocated(Z)) allocate(Z(c_lim))
#ifdef omp
		!$OMP DO
#endif
#ifdef mpi
		if(g_start /= 0 .and.g_finish /= 0) then
			do g = g_start,g_finish
#else
		do g = 1,NumDir
#endif
#ifndef omp
			if(return_all) return
#endif
			if(.not. return_all) then
				do c=1,c_lim
#ifndef omp
					if(return_all) return
#endif
					if(.not. return_all) then
						if(FD) then
							if(c == 1) step = 0
							if(c == 2) step = 1
							if(c == 3) step = 2
						else
							if(c == 1) step = -1
							if(c == 2 .and. sus_differential) step = 0
							if(c == 2 .and. .not. sus_differential) step = 1
							if(c == 3) step = 1
						end if
						local_B = (sus_fields(a)+(step*h))*vecdir(g,1:3) + static_field_magnitude*static_field_direction
						if(RI == 'I') then
							call matrix_elements('I','U',dummyR,local_matrix_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
							local_matrix_imag = local_matrix_imag + static_imag
							call diagonalize('I','N','U',totaldim,dummyR,local_matrix_imag,local_eigenvalues(c,:))
						else if(RI == 'R') then
							call matrix_elements('R','U',local_matrix_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
							local_matrix_real = local_matrix_real + static_real
							call diagonalize('R','N','U',totaldim,local_matrix_real,dummyI,local_eigenvalues(c,:))
						end if
					end if
				end do
				base = minval(local_eigenvalues(1,:))
				do c = 2,c_lim
					if(minval(local_eigenvalues(c,:)) < base) base = minval(local_eigenvalues(c,:))
				end do
				local_eigenvalues = local_eigenvalues - base
				do k=1,sus_numT
					Z = 0.0_8
					do c = 1,c_lim
						do j = 1,totaldim
							Z(c) = Z(c) + dexp((-local_eigenvalues(c,j)/(kB*sus_temps(k))))
						end do
						Z(c) = dlog(Z(c))
					end do
#ifdef omp
					!$OMP CRITICAL
#endif
					if(sus_differential) then
						sus_calc(a,k) = sus_calc(a,k) + vecdir(g,10)*0.1_8*Na*kB*sus_temps(k)*(Z(3)+Z(1)-2.0_8*Z(2))/(h*h)
					else
						if(FD) sus_calc(a,k) = sus_calc(a,k) + vecdir(g,10)*Na*kB*sus_temps(k)*(Z(2)-Z(1))/(10*h*sus_fields(a))
						if(.not. FD) sus_calc(a,k) = sus_calc(a,k) + vecdir(g,10)*Na*kB*sus_temps(k)*0.5_8*(Z(2)-Z(1))/(10*h*sus_fields(a))
					end if
#ifdef omp
					!$OMP END CRITICAL
#endif
				end do
			end if
		end do
#ifdef mpi
		end if
#endif
#ifdef omp
		!$OMP END DO
#endif
		if(RI == 'I' .and. allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(RI == 'R' .and. allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
		if(allocated(Z)) deallocate(Z)
#ifdef omp
		!$OMP END PARALLEL
#endif
		global_percent = global_percent + 1
#ifdef gui
		if(mpi_rank == 0 .and. OperationMode(1:3) == 'sim') call send_progress(100*global_percent/global_total,ptr_to_C_code)
#endif
		if(return_all) return
	end do
	if(return_all) return
#ifdef mpi
	allocate(loc_sus(sus_numB,sus_numT))
	call MPI_ALLREDUCE(sus_calc,loc_sus,sus_numT*sus_numB,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,mpi_error1)
	sus_calc = loc_sus
	deallocate(loc_sus)
#endif
	if(local_sus_tip /= 0.0_8) sus_calc = sus_calc + local_sus_tip
	if(local_sus_zJ /= 0.0_8) sus_calc = sus_calc/(1.0_8-(local_sus_zJ*wavenumber_to_erg/(Na*erg_beta*erg_beta))*sus_calc)
	if(ImpS /=0 .and. local_ImpQuant /= 0.0_8) then
		do a=1,sus_numB
			do k = 1,sus_numT
				if(sus_differential) then
					if(ImpS == 1) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta*beta)/(5.0_8*kB*sus_temps(k)*(1+cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))
					if(ImpS == 2) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(4.0_8*Na*beta*beta*(2.0_8+cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))/(5.0_8*kB*sus_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))**2))
					if(ImpS == 3) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta*beta)*((1.0_8/(cosh(sus_fields(a)*beta/(kB*sus_temps(k)))))*(1.0_8/(cosh(sus_fields(a)*beta/(kB*sus_temps(k)))))+4.0_8*(1.0_8/(cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))*(1.0_8/(cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))))/(10.0_8*kB*sus_temps(k))
					if(ImpS == 4) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(4.0_8*Na*beta*beta)*(10+10*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+4*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(5*kB*sus_temps(k)*(1+2*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))*(1+2*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))
					if(ImpS == 5) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta*beta)*(35+40*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+20*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+8*cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2*cosh(8.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(10*kB*sus_temps(k)*(cosh(sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(3.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(5.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))*(cosh(sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(3.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(5.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))
					if(ImpS == 6) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(4.0_8*Na*beta*beta*(28.0_8+35.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+20.0_8*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+10.0_8*cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+4.0_8*cosh(8.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+cosh(10.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))/(5.0_8*kB*sus_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))**2))
					if(ImpS == 7) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta*beta*(0.4_8*dexp(20.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+1.6_8*dexp(22.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+4.0_8*dexp(24.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+8.0_8*dexp(26.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+14.0_8*dexp(28.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+22.4_8*dexp(30.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+33.6_8*dexp(32.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+22.4_8*dexp(34.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+14.0_8*dexp(36.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+8.0_8*dexp(38.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+4.0_8*dexp(40.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+1.6_8*dexp(42.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+0.4_8*dexp(44.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))))/(kb*sus_temps(k)*((dexp(9.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(11.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(13.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(15.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(17.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(19.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(21.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(23.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))**2))
				else
					if(ImpS == 1) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*tanh(sus_fields(a)*beta/(kB*sus_temps(k)))
					if(ImpS == 2) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*4.0_8*sinh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))/(1.0_8+2.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 3) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*(tanh(sus_fields(a)*beta/(kB*sus_temps(k)))+2*tanh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 4) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*4.0_8*(sinh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*sinh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(1+2*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 5) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*(-4*sinh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+10*sinh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+3*tanh(sus_fields(a)*beta/(kB*sus_temps(k))))/(1+2*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 6) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*4.0_8*(sinh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*sinh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+3.0_8*sinh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(1.0_8+2.0_8*cosh(2.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*cosh(4.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+2.0_8*cosh(6.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
					if(ImpS == 7) sus_calc(a,k) = sus_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(Na*beta/(10*sus_fields(a)))*(-7.0_8*dexp(9.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))-5.0_8*dexp(11.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))-3.0_8*dexp(13.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))-1.0_8*dexp(15.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+1.0_8*dexp(17.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+3.0_8*dexp(19.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+5.0_8*dexp(21.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+7.0_8*dexp(23.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))/(dexp(9.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(11.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(13.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(15.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(17.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(19.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(21.0_8*sus_fields(a)*beta/(kB*sus_temps(k)))+dexp(23.0_8*sus_fields(a)*beta/(kB*sus_temps(k))))
				end if
				if(ImpS > 7) then
					call output_text("Monomer impurities with S > 3.5 are not yet implemented",.false.)
					call control('kill ')
					return
				end if
			end do
		end do
	end if
	do k = 1,sus_numT
		sus_calc(:,k) = sus_calc(:,k)*sus_temps(k)
	end do
	if((OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') .and. sus_autoscale == 1) then
		do a = 1,sus_numB
			sus_calc(a,:) = sus_calc(a,:)*(sus_exp(a,sus_numT)/sus_calc(a,sus_numT))
		end do
	end if
	if(RI == 'I') then
		if(allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(allocated(dummyI)) deallocate(dummyI)
		if(allocated(static_imag)) deallocate(static_imag)
	else if(RI == 'R')then
		if(allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(dummyR)) deallocate(dummyR)
		if(allocated(static_real)) deallocate(static_real)
	end if
	if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
	if(allocated(vecdir)) deallocate(vecdir)
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,sus_numB
			do k = 1,sus_numT
				if(a == 0) then
					call send_plot_data("sus_cal",sus_numT,sus_temps(k))
				else
					call send_plot_data("sus_cal",sus_numT,sus_calc(a,k))
				end if
			end do
		end do
		call send_plot_signal("susC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_sus
	
	subroutine calc_tensor(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
	! Calculates the magnetic susceptibility tensor of the system
	implicit none
	real(kind=8),allocatable::vecdir(:,:),dummyR(:,:),static_real(:,:)
	complex(kind=8),allocatable::dummyI(:,:),static_imag(:,:)
	real(kind=8)::h,htemp
	integer::numdir,a,num_threads
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:)
	logical::FD
	character(len=1)::RI
	!---OMP DATA---!
	integer::g,c,step,k,j,c_lim
	real(kind=8)::local_B(3),base
	real(kind=8),allocatable::local_matrix_real(:,:),local_eigenvalues(:,:),Z(:)
	complex(kind=8),allocatable::local_matrix_imag(:,:)
#ifdef mpi
	integer::g_start,g_finish
	real(kind=8),allocatable::loc_tensor(:,:,:)
#endif
	if(return_all) then
		!write(6,*) "C1"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*C1"
	end if
	tensor_calc = 0.0_8
	numdir = 6
	RI = 'I'
	allocate(static_imag(totaldim,totaldim),dummyR(1,1))
#ifdef mpi
	call set_mpi_limits(numdir,g_start,g_finish)
#endif
#ifdef omp
	num_threads = omp_get_num_procs()
	if(MaxCPU >= num_threads) then
		num_threads = omp_get_num_procs()
	else if(MaxCPU == 0)  then
		if(num_threads > 1) num_threads = omp_get_num_procs()-1
	else
		num_threads = MaxCPU
	end if
	if(numdir < num_threads) num_threads = numdir
#endif
	if(RI == 'I') call matrix_elements('I','U',dummyR,static_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	do a=1,tensor_numB
		FD = .false.
		h = (EPS**(1/6.0_8))*max(1.0_8,tensor_fields(a))	!(5.5D-3)*max(1.0_8,tensor_fields(a))
		htemp = tensor_fields(a) + h
		call donothing(htemp)
		h = htemp - tensor_fields(a)
		if(tensor_fields(a) < h) FD = .true.
#ifdef omp
		!$OMP PARALLEL IF(num_threads > 1 .and. numdir > 1) NUM_THREADS(num_threads) SHARED(num_threads,static_real,static_imag,a,tensor_numB,h,numdir,tensor_fields,vecdir,RI,dummyR,dummyI,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,totaldim,tensor_numT,tensor_temps,tensor_calc,FD) PRIVATE(g,c,step,k,j,local_B,base,Z,local_matrix_real,local_eigenvalues,local_matrix_imag)
#endif
		if(RI == 'I' .and. .not. allocated(local_matrix_imag)) allocate(local_matrix_imag(totaldim,totaldim))
		if(.not. allocated(local_eigenvalues)) allocate(local_eigenvalues(4,totaldim))
		if(.not. allocated(Z)) allocate(Z(4))
#ifdef omp
		!$OMP DO
#endif
#ifdef mpi
		if(g_start /= 0 .and.g_finish /= 0) then
			do g = g_start,g_finish
#else
		do g = 1,NumDir
#endif
#ifndef omp
			if(return_all) return
#endif
			if(g == 1 .or. g == 4 .or. g == 6) then
				c_lim = 3
			else
				c_lim = 4
			end if
			if(.not. return_all) then
				do c=1,c_lim
#ifndef omp
					if(return_all) return
#endif
					if(.not. return_all) then
						if(g == 1) then
							if(FD) then
								if(c == 1) local_B = (tensor_fields(a))*(/ 1.0_8, 0.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (tensor_fields(a)+(h))*(/ 1.0_8, 0.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (tensor_fields(a)+(2*h))*(/ 1.0_8, 0.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
							else
								if(c == 1) local_B = (tensor_fields(a)+(-h))*(/ 1.0_8, 0.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (tensor_fields(a))*(/ 1.0_8, 0.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (tensor_fields(a)+(h))*(/ 1.0_8, 0.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
							end if
						else if(g == 4) then
							if(FD) then
								if(c == 1) local_B = (tensor_fields(a))*(/ 0.0_8, 1.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (tensor_fields(a)+(h))*(/ 0.0_8, 1.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (tensor_fields(a)+(2*h))*(/ 0.0_8, 1.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
							else
								if(c == 1) local_B = (tensor_fields(a)+(-h))*(/ 0.0_8, 1.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (tensor_fields(a))*(/ 0.0_8, 1.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (tensor_fields(a)+(h))*(/ 0.0_8, 1.0_8, 0.0_8 /) + static_field_magnitude*static_field_direction
							end if
						else if(g == 6) then
							if(FD) then
								if(c == 1) local_B = (tensor_fields(a))*(/ 0.0_8, 0.0_8, 1.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (tensor_fields(a)+(h))*(/ 0.0_8, 0.0_8, 1.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (tensor_fields(a)+(2*h))*(/ 0.0_8, 0.0_8, 1.0_8 /) + static_field_magnitude*static_field_direction
							else
								if(c == 1) local_B = (tensor_fields(a)+(-h))*(/ 0.0_8, 0.0_8, 1.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (tensor_fields(a))*(/ 0.0_8, 0.0_8, 1.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (tensor_fields(a)+(h))*(/ 0.0_8, 0.0_8, 1.0_8 /) + static_field_magnitude*static_field_direction
							end if
						else if(g == 2) then
							if(FD) then
								if(c == 1) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)+h, (tensor_fields(a))/dsqrt(2.0_8)+h, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)+h, (tensor_fields(a))/dsqrt(2.0_8), 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8), (tensor_fields(a))/dsqrt(2.0_8)+h, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 4) local_B = (/ tensor_fields(a)/dsqrt(2.0_8), tensor_fields(a)/dsqrt(2.0_8), 0.0_8 /) + static_field_magnitude*static_field_direction
							else
								if(c == 1) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)+h, (tensor_fields(a))/dsqrt(2.0_8)+h, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)-h, (tensor_fields(a))/dsqrt(2.0_8)-h, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)+h, (tensor_fields(a))/dsqrt(2.0_8)-h, 0.0_8 /) + static_field_magnitude*static_field_direction
								if(c == 4) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)-h, (tensor_fields(a)+h)/dsqrt(2.0_8)-h, 0.0_8 /) + static_field_magnitude*static_field_direction
							end if
						else if(g == 3) then
							if(FD) then
								if(c == 1) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)+h, 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)+h /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)+h, 0.0_8, (tensor_fields(a))/dsqrt(2.0_8) /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8), 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)+h /) + static_field_magnitude*static_field_direction
								if(c == 4) local_B = (/ tensor_fields(a)/dsqrt(2.0_8), 0.0_8, tensor_fields(a)/dsqrt(2.0_8) /) + static_field_magnitude*static_field_direction
							else
								if(c == 1) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)+h, 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)+h /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)-h, 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)-h /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)+h, 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)-h /) + static_field_magnitude*static_field_direction
								if(c == 4) local_B = (/ (tensor_fields(a))/dsqrt(2.0_8)-h, 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)+h /) + static_field_magnitude*static_field_direction
							end if
						else if(g == 5) then
							if(FD) then
								if(c == 1) local_B = (/ 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)+h, (tensor_fields(a))/dsqrt(2.0_8)+h /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (/ 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)+h, (tensor_fields(a))/dsqrt(2.0_8) /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (/ 0.0_8, (tensor_fields(a))/dsqrt(2.0_8), (tensor_fields(a))/dsqrt(2.0_8)+h /) + static_field_magnitude*static_field_direction
								if(c == 4) local_B = (/ 0.0_8, tensor_fields(a)/dsqrt(2.0_8), tensor_fields(a)/dsqrt(2.0_8) /) + static_field_magnitude*static_field_direction
							else
								if(c == 1) local_B = (/ 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)+h, (tensor_fields(a))/dsqrt(2.0_8)+h /) + static_field_magnitude*static_field_direction
								if(c == 2) local_B = (/ 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)-h, (tensor_fields(a))/dsqrt(2.0_8)-h /) + static_field_magnitude*static_field_direction
								if(c == 3) local_B = (/ 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)+h, (tensor_fields(a))/dsqrt(2.0_8)-h /) + static_field_magnitude*static_field_direction
								if(c == 4) local_B = (/ 0.0_8, (tensor_fields(a))/dsqrt(2.0_8)-h, (tensor_fields(a))/dsqrt(2.0_8)+h /) + static_field_magnitude*static_field_direction
							end if
						end if
						call matrix_elements('I','U',dummyR,local_matrix_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
						local_matrix_imag = local_matrix_imag + static_imag
						call diagonalize('I','N','U',totaldim,dummyR,local_matrix_imag,local_eigenvalues(c,:))
					end if
				end do
				base = minval(local_eigenvalues(1,:))
				do c = 2,c_lim
					if(minval(local_eigenvalues(c,:)) < base) base = minval(local_eigenvalues(c,:))
				end do
				local_eigenvalues = local_eigenvalues - base
				do k=1,tensor_numT
					Z = 0.0_8
					do c = 1,c_lim
						do j = 1,totaldim
							Z(c) = Z(c) + dexp((-local_eigenvalues(c,j)/(kB*tensor_temps(k))))
						end do
						Z(c) = dlog(Z(c))
					end do
#ifdef omp
					!$OMP CRITICAL
#endif
					if(g == 1 .or. g == 4 .or. g == 6) then
						tensor_calc(a,k,g) = 0.1_8*Na*kB*tensor_temps(k)*(Z(3)+Z(1)-2.0_8*Z(2))/(h*h)
						!if(k == 92 .or. k == 183 .or. k == 273) write(6,*) tensor_temps(k),(Z(3)+Z(1)-2.0_8*Z(2)),(h*h),tensor_temps(k)*tensor_calc(a,k,g)
					else
						if(FD) then
							tensor_calc(a,k,g) = 0.1_8*Na*kB*tensor_temps(k)* (Z(1) - Z(2) - Z(3) + Z(4))/(h*h)
							!if(k == 92 .or. k == 183 .or. k == 273) write(6,*) tensor_temps(k),(Z(1) - Z(2) - Z(3) + Z(4)),(h*h),tensor_temps(k)*tensor_calc(a,k,g)
						else
							tensor_calc(a,k,g) = 0.1_8*Na*kB*tensor_temps(k)*	0.25_8*(Z(1) + Z(2) - Z(3) - Z(4))/(h*h)
							!if(k == 92 .or. k == 183 .or. k == 273) write(6,*) tensor_temps(k),(Z(1) + Z(2) - Z(3) - Z(4)),(h*h),tensor_temps(k)*tensor_calc(a,k,g)
						end if
					end if
#ifdef omp
					!$OMP END CRITICAL
#endif
				end do
			end if
		end do
#ifdef mpi
		end if
#endif
#ifdef omp
		!$OMP END DO
#endif
		if(RI == 'I' .and. allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
		if(allocated(Z)) deallocate(Z)
#ifdef omp
		!$OMP END PARALLEL
#endif
		global_percent = global_percent + 1
#ifdef gui
		if(mpi_rank == 0 .and. OperationMode(1:3) == 'sim') call send_progress(100*global_percent/global_total,ptr_to_C_code)
#endif
		if(return_all) return
	end do
	if(return_all) return
#ifdef mpi
	allocate(loc_tensor(tensor_numB,tensor_numT,6))
	call MPI_ALLREDUCE(tensor_calc,loc_tensor,tensor_numT*tensor_numB*6,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,mpi_error1)
	tensor_calc = loc_tensor
	deallocate(loc_tensor)
#endif
	do k = 1,tensor_numT
		tensor_calc(:,k,:) = tensor_calc(:,k,:)*tensor_temps(k)
	end do
	if(RI == 'I') then
		if(allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(allocated(dummyI)) deallocate(dummyI)
		if(allocated(static_imag)) deallocate(static_imag)
	end if
	if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
	if(allocated(vecdir)) deallocate(vecdir)
	if(return_all) return
	end subroutine calc_tensor
	
	subroutine calc_mag_coupled(S_spins,S_energies,S_Gfactors,local_ImpQuant)
	! Calculates the magnetization in the coupled basis
	implicit none
	real(kind=8)::S_energies(:),S_Gfactors(:),h,htemp,Z(2),local_B,base,local_ImpQuant
	real(kind=8),allocatable::local_eigenvalues(:,:)
	integer::S_spins(:),i,a,c,step,k,j
	logical::FD
	if(return_all) then
		!write(6,*) "D"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*D"
	end if
	allocate(local_eigenvalues(2,totaldim))
	mag_calc = 0.0_8
	do a=1,mag_numB
		FD = .false.
		h = (EPS**(1/3.0_8))*max(1.0_8,mag_fields(a))
		htemp = mag_fields(a) + h
		call donothing(htemp)
		h = htemp - mag_fields(a)
		if((mag_fields(a)-h) < 0.0_8) then
			FD = .true.
			h = (EPS**(1/2.0_8))*max(1.0_8,mag_fields(a))
			htemp = mag_fields(a) + h
			call donothing(htemp)
			h = htemp - mag_fields(a)
		end if
		do c=1,2
			if(return_all) return
			if(FD) then
				if(c == 1) step = 0
				if(c == 2) step = 1
			else
				if(c == 1) step = -1
				if(c == 2) step = 1
			end if
			local_B = (mag_fields(a)+(step*h)) + static_field_magnitude
			i = 0
			do k = 1,Sdim
				do j = -S_spins(k),S_spins(k),2
					i = i + 1
					local_eigenvalues(c,i) = 0.5_8*j*S_Gfactors(k)*beta*local_B + S_energies(k)
				end do
			end do
		end do
		base = min(minval(local_eigenvalues(1,:)),minval(local_eigenvalues(2,:)))
		local_eigenvalues = local_eigenvalues - base
		do k=1,mag_numT
			Z = 0.0_8
			do c = 1,2
				do j = 1,totaldim
					Z(c) = Z(c) + dexp((-local_eigenvalues(c,j)/(kB*mag_temps(k))))
				end do
				Z(c) = dlog(Z(c))
			end do
			if(FD) mag_calc(k,a) = mag_calc(k,a) + kB*mag_temps(k)*(Z(2)-Z(1))/(h*beta)
			if(.not. FD) mag_calc(k,a) = mag_calc(k,a) + kB*mag_temps(k)*0.5_8*(Z(2)-Z(1))/(h*beta)
		end do
	end do
	if(ImpS /=0 .and. local_ImpQuant /= 0.0_8) then
		do a=1,mag_numB
			do k = 1,mag_numT
				if(ImpS == 1) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*tanh(mag_fields(a)*beta/(kB*mag_temps(k)))
				if(ImpS == 2) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*4.0_8*sinh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))/(1.0_8+2.0_8*cosh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 3) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(tanh(mag_fields(a)*beta/(kB*mag_temps(k)))+2*tanh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 4) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*4.0_8*(sinh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2.0_8*sinh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))/(1+2*cosh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2*cosh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 5) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(-4*sinh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+10*sinh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+3*tanh(mag_fields(a)*beta/(kB*mag_temps(k))))/(1+2*cosh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 6) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*4.0_8*(sinh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2.0_8*sinh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+3.0_8*sinh(6.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))/(1.0_8+2.0_8*cosh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2.0_8*cosh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2.0_8*cosh(6.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 7) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(-7.0_8*dexp(9.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))-5.0_8*dexp(11.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))-3.0_8*dexp(13.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))-1.0_8*dexp(15.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+1.0_8*dexp(17.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+3.0_8*dexp(19.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+5.0_8*dexp(21.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+7.0_8*dexp(23.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))/(dexp(9.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(11.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(13.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(15.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(17.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(19.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(21.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(23.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS > 7) then
					call output_text("Monomer impurities with S > 3.5 are not yet implemented",.false.)
					call control('kill ')
					return
				end if
			end do
		end do
	end if
	if((OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') .and. mag_autoscale == 1) then
		do k = 1,mag_numT
			mag_calc(k,:) = mag_calc(k,:)*(mag_exp(k,mag_numB)/mag_calc(k,mag_numB))
		end do
	end if
	deallocate(local_eigenvalues)
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,mag_numT
			do k = 1,mag_numB
				if(a == 0) then
					call send_plot_data("mag_cal",mag_numB,mag_fields(k))
				else
					call send_plot_data("mag_cal",mag_numB,mag_calc(a,k))
				end if
			end do
		end do
		call send_plot_signal("magC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_mag_coupled
	
	subroutine calc_mag(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_ImpQuant)
	! Calculates the magnetization of the system
	implicit none
	real(kind=8),allocatable::vecdir(:,:),dummyR(:,:),static_real(:,:)
	complex(kind=8),allocatable::dummyI(:,:),static_imag(:,:)
	real(kind=8)::h,htemp
	integer::numdir,a,num_threads
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:),local_ImpQuant
	logical::FD
	character(len=1)::RI
	!---OMP DATA---!
	integer::g,c,step,k,j
	real(kind=8)::local_B(3),base,Z(3)
	real(kind=8),allocatable::local_matrix_real(:,:),local_eigenvalues(:,:)
	complex(kind=8),allocatable::local_matrix_imag(:,:)
#ifdef mpi
	integer::g_start,g_finish
	real(kind=8),allocatable::loc_mag(:,:)
#endif
	if(return_all) then
		!write(6,*) "E"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*E"
	end if
	mag_calc = 0.0_8
	call ZCW(mag_intLevel,mag_intCover,mag_field_vec,numdir,vecdir)
	if(aniso == 0 .and. numdir == 1 .and. vecdir(1,1) == 0.0_8 .and. vecdir(1,2) == 0.0_8) then
		RI = 'R'
		allocate(static_real(totaldim,totaldim),dummyI(1,1))
	else
		RI = 'I'
		allocate(static_imag(totaldim,totaldim),dummyR(1,1))
	end if
#ifdef mpi
	call set_mpi_limits(numdir,g_start,g_finish)
#endif
#ifdef omp
	num_threads = omp_get_num_procs()
	if(MaxCPU >= num_threads) then
		num_threads = omp_get_num_procs()
	else if(MaxCPU == 0)  then
		if(num_threads > 1) num_threads = omp_get_num_procs()-1
	else
		num_threads = MaxCPU
	end if
	if(numdir < num_threads) num_threads = numdir
#endif
	if(RI == 'I') call matrix_elements('I','U',dummyR,static_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	if(RI == 'R') call matrix_elements('R','U',static_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	do a=1,mag_numB
		FD = .false.
		h = (EPS**(1/3.0_8))*max(1.0_8,mag_fields(a))
		htemp = mag_fields(a) + h
		call donothing(htemp)
		h = htemp - mag_fields(a)
		if((mag_fields(a)-h) < 0.0_8) then
			FD = .true.
			h = (EPS**(1/2.0_8))*max(1.0_8,mag_fields(a))
			htemp = mag_fields(a) + h
			call donothing(htemp)
			h = htemp - mag_fields(a)
		end if
#ifdef omp
		!$OMP PARALLEL IF(num_threads > 1 .and. numdir > 1) NUM_THREADS(num_threads) SHARED(num_threads,static_real,static_imag,a,mag_numB,h,numdir,mag_fields,vecdir,RI,dummyR,dummyI,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,totaldim,mag_numT,mag_temps,mag_calc) PRIVATE(g,c,step,k,j,local_B,base,Z,local_matrix_real,local_eigenvalues,local_matrix_imag)
#endif
		if(RI == 'I' .and. .not. allocated(local_matrix_imag)) allocate(local_matrix_imag(totaldim,totaldim))
		if(RI == 'R' .and. .not. allocated(local_matrix_real)) allocate(local_matrix_real(totaldim,totaldim))
		if(.not. allocated(local_eigenvalues)) allocate(local_eigenvalues(2,totaldim))
#ifdef omp
		!$OMP DO
#endif
#ifdef mpi
		if(g_start /= 0 .and.g_finish /= 0) then
			do g = g_start,g_finish
#else
		do g = 1,NumDir
#endif
#ifndef omp
			if(return_all) return
#endif
			if(.not. return_all) then
				do c=1,2
#ifndef omp
					if(return_all) return
#endif
					if(.not. return_all) then
						if(FD) then
							if(c == 1) step = 0
							if(c == 2) step = 1
						else
							if(c == 1) step = -1
							if(c == 2) step = 1
						end if
						local_B = (mag_fields(a)+(step*h))*vecdir(g,1:3) + static_field_magnitude*static_field_direction
						if(RI == 'I') then
							call matrix_elements('I','U',dummyR,local_matrix_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
							local_matrix_imag = local_matrix_imag + static_imag
							call diagonalize('I','N','U',totaldim,dummyR,local_matrix_imag,local_eigenvalues(c,:))
						else if(RI == 'R') then
							call matrix_elements('R','U',local_matrix_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
							local_matrix_real = local_matrix_real + static_real
							call diagonalize('R','N','U',totaldim,local_matrix_real,dummyI,local_eigenvalues(c,:))
						end if
					end if
				end do
				if(.not. return_all) then
					base = min(minval(local_eigenvalues(1,:)),minval(local_eigenvalues(2,:)))
					local_eigenvalues = local_eigenvalues - base
					do k=1,mag_numT
						Z = 0.0_8
						do c = 1,2
							do j = 1,totaldim
								Z(c) = Z(c) + dexp((-local_eigenvalues(c,j)/(kB*mag_temps(k))))
							end do
							Z(c) = dlog(Z(c))
						end do
#ifdef omp
						!$OMP CRITICAL
#endif
						if(FD) mag_calc(k,a) = mag_calc(k,a) + vecdir(g,10)*kB*mag_temps(k)*(Z(2)-Z(1))/(h*beta)
						if(.not. FD) mag_calc(k,a) = mag_calc(k,a) + vecdir(g,10)*kB*mag_temps(k)*0.5_8*(Z(2)-Z(1))/(h*beta)
						!if(a == mag_numB .and. k == 1) write(6,*) g,dacos(vecdir(g,3)),kB*mag_temps(k)*0.5_8*(Z(2)-Z(1))/(h*beta)
						!if(a == 2) write(6,*) dacos(vecdir(g,3)),kB*mag_temps(k)*0.5_8*(Z(2)-Z(1))/(h*beta)/dble(numdir),mag_calc(k,a)/dble(numdir)
#ifdef omp
						!$OMP END CRITICAL
#endif
					end do
				end if
			end if
		end do
#ifdef mpi
		end if
#endif
#ifdef omp
		!$OMP END DO
#endif
		if(RI == 'I' .and. allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(RI == 'R' .and. allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
#ifdef omp
		!$OMP END PARALLEL
#endif
		global_percent = global_percent + 1
#ifdef gui
		if(mpi_rank == 0 .and. OperationMode(1:3) == 'sim') call send_progress(100*global_percent/global_total,ptr_to_C_code)
#endif
		if(return_all) return
	end do
	if(return_all) return
#ifdef mpi
	allocate(loc_mag(mag_numT,mag_numB))
	call MPI_ALLREDUCE(mag_calc,loc_mag,mag_numT*mag_numB,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,mpi_error1)
	mag_calc = loc_mag
	deallocate(loc_mag)
#endif
	if(ImpS /=0 .and. local_ImpQuant /= 0.0_8) then
		do a=1,mag_numB
			do k = 1,mag_numT
				if(ImpS == 1) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*tanh(mag_fields(a)*beta/(kB*mag_temps(k)))
				if(ImpS == 2) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*4.0_8*sinh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))/(1.0_8+2.0_8*cosh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 3) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(tanh(mag_fields(a)*beta/(kB*mag_temps(k)))+2*tanh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 4) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*4.0_8*(sinh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2.0_8*sinh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))/(1+2*cosh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2*cosh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 5) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(-4*sinh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+10*sinh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+3*tanh(mag_fields(a)*beta/(kB*mag_temps(k))))/(1+2*cosh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 6) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*4.0_8*(sinh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2.0_8*sinh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+3.0_8*sinh(6.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))/(1.0_8+2.0_8*cosh(2.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2.0_8*cosh(4.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+2.0_8*cosh(6.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS == 7) mag_calc(k,a) = mag_calc(k,a)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(-7.0_8*dexp(9.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))-5.0_8*dexp(11.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))-3.0_8*dexp(13.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))-1.0_8*dexp(15.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+1.0_8*dexp(17.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+3.0_8*dexp(19.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+5.0_8*dexp(21.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+7.0_8*dexp(23.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))/(dexp(9.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(11.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(13.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(15.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(17.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(19.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(21.0_8*mag_fields(a)*beta/(kB*mag_temps(k)))+dexp(23.0_8*mag_fields(a)*beta/(kB*mag_temps(k))))
				if(ImpS > 7) then
					call output_text("Monomer impurities with S > 3.5 are not yet implemented",.false.)
					call control('kill ')
					return
				end if
			end do
		end do
	end if
	if((OperationMode(1:3) == 'fit' .or. OperationMode(1:3) == 'sur') .and. mag_autoscale == 1) then
		do k = 1,mag_numT
			mag_calc(k,:) = mag_calc(k,:)*(mag_exp(k,mag_numB)/mag_calc(k,mag_numB))
		end do
	end if
	if(RI == 'I') then
		if(allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(allocated(dummyI)) deallocate(dummyI)
		if(allocated(static_imag)) deallocate(static_imag)
	else if(RI == 'R')then
		if(allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(dummyR)) deallocate(dummyR)
		if(allocated(static_real)) deallocate(static_real)
	end if
	if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
	if(allocated(vecdir)) deallocate(vecdir)
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,mag_numT
			do k = 1,mag_numB
				if(a == 0) then
					call send_plot_data("mag_cal",mag_numB,mag_fields(k))
				else
					call send_plot_data("mag_cal",mag_numB,mag_calc(a,k))
				end if
			end do
		end do
		call send_plot_signal("magC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_mag
	
!	subroutine calc_torque(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_ImpQuant)
!	! Calculates the torque on the system
!	implicit none
!	integer::a,t,g,d
!	torque_calc = 0.0_8
!	do a = 1,torque_numB
!		!parallelise over num angles
!		do d = 1,torque_numA
!			do g = 1,num_unique_mol
!				local_B = torque_fields(b)*mol_field_dir(g)
!				!pay attention to CD/FD
!				!calc eigs perpdir 1
!				
!				!calc eigs perpdir 2
!				do t = 1,torque_numT
!					!calc partition function derivatives etc.
!					torque_calc(a,t,d) = torque_calc(a,t,d) + 
!				end do
!			end do
!		end do
!	end do
!	end subroutine calc_torque
	
	subroutine calc_mce_coupled(S_spins,S_energies,S_Gfactors)
	! Calculates the MCE in the coupled basis
	implicit none
	real(kind=8)::S_energies(:),S_Gfactors(:),h,htemp,Z(2),local_B,base,Bstep,integrand_sum,hh,integrate_B,dM(2),min_field,Itemp(2),M_p
	real(kind=8),allocatable::local_eigenvalues(:,:)
	integer::S_spins(:),i,a,c,step,k,j,d,l
	if(return_all) then
		!write(6,*) "F"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*F"
	end if
	allocate(local_eigenvalues(2,totaldim))
	mce_calc = 0.0_8
	h = (EPS**(1/3.0_8))
	htemp = 1.0_8 + h
	call donothing(htemp)
	h = htemp - 1.0_8
	min_field = 1.05_8*h
	do a=1,mce_numB
		Bstep = (mce_fields(a)-min_field)/mce_integration
		do k =1,mce_numT
			integrand_sum = 0.0_8
			do c = 1,2
				if(return_all) return
				if(c == 1) step = -1
				if(c == 2) step = 1
				hh = (EPS**(1/3.0_8))*max(1.0_8,mce_temps(k))
				htemp = mce_temps(k) + hh
				call donothing(htemp)
				hh = htemp - mce_temps(k)
				ITemp(c) = mce_temps(k)+ step*hh
			end do
			do i=0,mce_integration
				integrate_B = i*Bstep
				h = (EPS**(1/3.0_8))*max(1.0_8,integrate_B)
				htemp = integrate_B + h
				call donothing(htemp)
				h = htemp - integrate_B
				if((integrate_B-h) < 0.0_8) then
					integrate_B = 1.05_8*h
					h = (EPS**(1/3.0_8))*max(1.0_8,integrate_B)
					htemp = integrate_B + h
					call donothing(htemp)
					h = htemp - integrate_B
				end if
				do c=1,2
					if(c == 1) step = -1
					if(c == 2) step = 1
					local_B = (integrate_B+(step*h)) + static_field_magnitude
					d = 0
					do l = 1,Sdim
						do j = -S_spins(l),S_spins(l),2
							d = d + 1
							local_eigenvalues(c,d) = 0.5_8*j*S_Gfactors(l)*beta*local_B + S_energies(l)
						end do
					end do
				end do
				base = min(minval(local_eigenvalues(1,:)),minval(local_eigenvalues(2,:)))
				local_eigenvalues = local_eigenvalues - base
				dM = 0.0_8
				do d = 1,2
					Z = 0.0_8
					do c = 1,2
						do j = 1,totaldim
							Z(c) = Z(c) + dexp((-local_eigenvalues(c,j)/(kB*ITemp(d))))
						end do
						Z(c) = dlog(Z(c))
					end do
					dM(d) = kB*ITemp(d)*0.5_8*(Z(2)-Z(1))/(h)
				end do
				if(i == 0) then
					M_p = (dM(2)-dM(1))/(2.0_8*hh)
				else
					integrand_sum = integrand_sum + Bstep*0.5_8*(M_p+(dM(2)-dM(1))/(2.0_8*hh))
					M_p = (dM(2)-dM(1))/(2.0_8*hh)
				end if
			end do
			mce_calc(a,k) = -Na*1000.0_8*integrand_sum/mce_mass
		end do
	end do
	deallocate(local_eigenvalues)
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,mce_numB
			do k = 1,mce_numT
				if(a == 0) then
					call send_plot_data("mce_cal",mce_numT,mce_temps(k))
				else
					call send_plot_data("mce_cal",mce_numT,mce_calc(a,k))
				end if
			end do
		end do
		call send_plot_signal("mceC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_mce_coupled
	
	subroutine calc_mce(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
	! Calculates the MCE of the system
	implicit none
	real(kind=8),allocatable::vecdir(:,:),dummyR(:,:),static_real(:,:)
	complex(kind=8),allocatable::dummyI(:,:),static_imag(:,:)
	real(kind=8)::min_field,Bstep
	integer::numdir,a,num_threads
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:)
	character(len=1)::RI
	!---OMP DATA---!
	integer::g,k,c,step,i,j,d
	real(kind=8)::integrand_sum,hh,htemp,ITemp(2),integrate_B,h,local_B(3),base,Z(2),dM(2),M_p
	real(kind=8),allocatable::local_matrix_real(:,:),local_eigenvalues(:,:)
	complex(kind=8),allocatable::local_matrix_imag(:,:)
#ifdef mpi
	integer::g_start,g_finish
	real(kind=8),allocatable::loc_mce(:,:)
#endif
	if(return_all) then
		!write(6,*) "G"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*G"
	end if
	mce_calc = 0.0_8
	call ZCW(mce_intLevel,mce_intCover,mce_field_vec,numdir,vecdir)
	if(aniso == 0 .and. numdir == 1 .and. vecdir(1,1) == 0.0_8 .and. vecdir(1,2) == 0.0_8) then
		RI = 'R'
		allocate(static_real(totaldim,totaldim),dummyI(1,1))
	else
		RI = 'I'
		allocate(static_imag(totaldim,totaldim),dummyR(1,1))
	end if
#ifdef mpi
	call set_mpi_limits(numdir,g_start,g_finish)
#endif
#ifdef omp
	num_threads = omp_get_num_procs()
	if(MaxCPU >= num_threads) then
		num_threads = omp_get_num_procs()
	else if(MaxCPU == 0)  then
		if(num_threads > 1) num_threads = omp_get_num_procs()-1
	else
		num_threads = MaxCPU
	end if
	if(numdir < num_threads) num_threads = numdir
#endif
	if(RI == 'I') call matrix_elements('I','U',dummyR,static_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	if(RI == 'R') call matrix_elements('R','U',static_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	h = (EPS**(1/3.0_8))
	htemp = 1.0_8 + h
	call donothing(htemp)
	h = htemp - 1.0_8
	min_field = 1.05_8*h
	do a = 1,mce_numB
		Bstep = (mce_fields(a)-min_field)/mce_integration
#ifdef omp
		!$OMP PARALLEL IF(num_threads > 1 .and. numdir > 1) NUM_THREADS(num_threads) SHARED(a,mce_numB,numdir,mce_numT,EPS,mce_temps,mce_integration,min_field,Bstep,vecdir,RI,dummyR,dummyI,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,static_imag,static_real,totaldim,mce_calc,mce_mass) PRIVATE(g,k,integrand_sum,c,step,hh,htemp,ITemp,i,integrate_B,h,local_B,local_matrix_imag,local_matrix_real,local_eigenvalues,base,dM,d,Z,j,M_p)
#endif
		if(RI == 'I' .and. .not. allocated(local_matrix_imag)) allocate(local_matrix_imag(totaldim,totaldim))
		if(RI == 'R' .and. .not. allocated(local_matrix_real)) allocate(local_matrix_real(totaldim,totaldim))
		if(.not. allocated(local_eigenvalues)) allocate(local_eigenvalues(2,totaldim))
#ifdef omp
		!$OMP DO
#endif
#ifdef mpi
		if(g_start /= 0 .and.g_finish /= 0) then
			do g = g_start,g_finish
#else
		do g = 1,NumDir
#endif
#ifndef omp
			if(return_all) return
#endif
			if(.not. return_all) then
				do k = 1,mce_numT
					integrand_sum = 0.0_8
					do c = 1,2
#ifndef omp
						if(return_all) return
#endif
						if(.not. return_all) then
							if(c == 1) step = -1
							if(c == 2) step = 1
							hh = (EPS**(1/3.0_8))*max(1.0_8,mce_temps(k))
							htemp = mce_temps(k) + hh
							call donothing(htemp)
							hh = htemp - mce_temps(k)
							ITemp(c) = mce_temps(k)+ step*hh
						end if
					end do
					do i = 0,mce_integration
						integrate_B = min_field + i*Bstep
						h = (EPS**(1/3.0_8))*max(1.0_8,integrate_B)
						htemp = integrate_B + h
						call donothing(htemp)
						h = htemp - integrate_B
						if((integrate_B-h) < 0.0_8) then
							integrate_B = 1.05_8*h
							h = (EPS**(1/3.0_8))*max(1.0_8,integrate_B)
							htemp = integrate_B + h
							call donothing(htemp)
							h = htemp - integrate_B
						end if
						do c=1,2
							if(c == 1) step = -1
							if(c == 2) step = 1
							local_B = (integrate_B+(step*h))*vecdir(g,1:3) + static_field_magnitude*static_field_direction
							if(RI == 'I') then
								call matrix_elements('I','U',dummyR,local_matrix_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
								local_matrix_imag = local_matrix_imag + static_imag
								call diagonalize('I','N','U',totaldim,dummyR,local_matrix_imag,local_eigenvalues(c,:))
							else if(RI == 'R') then
								call matrix_elements('R','U',local_matrix_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
								local_matrix_real = local_matrix_real + static_real
								call diagonalize('R','N','U',totaldim,local_matrix_real,dummyI,local_eigenvalues(c,:))
							end if
						end do
						base = min(minval(local_eigenvalues(1,:)),minval(local_eigenvalues(2,:)))
						local_eigenvalues = local_eigenvalues - base
						dM = 0.0_8
						do d = 1,2
							Z = 0.0_8
							do c = 1,2
								do j = 1,totaldim
									Z(c) = Z(c) + dexp((-local_eigenvalues(c,j)/(kB*ITemp(d))))
								end do
								Z(c) = dlog(Z(c))
							end do
							dM(d) = kB*ITemp(d)*0.5_8*(Z(2)-Z(1))/(h)
						end do
						if(i == 0) then
							M_p = (dM(2)-dM(1))/(2.0_8*hh)
						else
							integrand_sum = integrand_sum + Bstep*0.5_8*(M_p+(dM(2)-dM(1))/(2.0_8*hh))
							M_p = (dM(2)-dM(1))/(2.0_8*hh)
						end if
					end do
#ifdef omp
					!$OMP CRITICAL
#endif
					mce_calc(a,k) = mce_calc(a,k) + vecdir(g,10)*(-Na)*1000.0_8*integrand_sum/mce_mass
#ifdef omp
					!$OMP END CRITICAL
#endif
				end do
			end if
		end do
#ifdef mpi
		end if
#endif
#ifdef omp
		!$OMP END DO
#endif
		if(RI == 'I' .and. allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(RI == 'R' .and. allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
#ifdef omp
		!$OMP END PARALLEL
#endif
		global_percent = global_percent + 1
#ifdef gui
		if(mpi_rank == 0 .and. OperationMode(1:3) == 'sim') call send_progress(100*global_percent/global_total,ptr_to_C_code)
#endif
		if(return_all) return
	end do
	if(return_all) return
#ifdef mpi
	allocate(loc_mce(mce_numB,mce_numT))
	call MPI_ALLREDUCE(mce_calc,loc_mce,mce_numT*mce_numB,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,mpi_error1)
	mce_calc = loc_mce
	deallocate(loc_mce)
#endif
	if(RI == 'I') then
		if(allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(allocated(dummyI)) deallocate(dummyI)
		if(allocated(static_imag)) deallocate(static_imag)
	else if(RI == 'R')then
		if(allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(dummyR)) deallocate(dummyR)
		if(allocated(static_real)) deallocate(static_real)
	end if
	if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
	if(allocated(vecdir)) deallocate(vecdir)
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,mce_numB
			do k = 1,mce_numT
				if(a == 0) then
					call send_plot_data("mce_cal",mce_numT,mce_temps(k))
				else
					call send_plot_data("mce_cal",mce_numT,mce_calc(a,k))
				end if
			end do
		end do
		call send_plot_signal("mceC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_mce
	
	subroutine calc_heat_capacity_coupled(S_spins,S_energies,S_Gfactors,local_lattice,local_ImpQuant)
	! Calculates the heat capacity of the coupled system
	implicit none
	real(kind=8),allocatable::local_eigenvalues(:)
	real(kind=8)::local_B,base,Z(3)
	real(kind=8),intent(in)::S_energies(:),S_Gfactors(:),local_lattice(2),local_ImpQuant
	integer,intent(in)::S_spins(:)
	integer::a,i,k,j
	if(return_all) then
		!write(6,*) "H"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*H"
	end if
	allocate(local_eigenvalues(totaldim))
	heat_calc = 0.0_8
	do a = 1,heat_numB
		if(return_all) return
		local_B = heat_fields(a) + static_field_magnitude
		i = 0
		do k = 1,Sdim
			do j = -S_spins(k),S_spins(k),2
				i = i + 1
				local_eigenvalues(i) = 0.5_8*j*S_Gfactors(k)*beta*local_B + S_energies(k)
			end do
		end do
		base = minval(local_eigenvalues(:))
		local_eigenvalues = local_eigenvalues - base
		do k = 1,heat_numT
			Z = 0.0_8
			do j = 1,totaldim
				Z(1) = Z(1) + dexp((-local_eigenvalues(j)/(kB*heat_temps(k))))
				Z(2) = Z(2) + local_eigenvalues(j)*dexp((-local_eigenvalues(j)/(kB*heat_temps(k))))
				Z(3) = Z(3) + local_eigenvalues(j)*local_eigenvalues(j)*dexp((-local_eigenvalues(j)/(kB*heat_temps(k))))
			end do
			heat_calc(a,k) = heat_calc(a,k) + (Z(3)*Z(1)-Z(2)*Z(2))/(Z(1)*Z(1)*kB*kB*heat_temps(k)*heat_temps(k))
		end do
	end do
	deallocate(local_eigenvalues)
	if(ImpS /=0 .and. local_ImpQuant /= 0.0_8) then
		do a=1,heat_numB
			do k = 1,heat_numT
				if(ImpS == 1) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(heat_fields(a)*heat_fields(a)*beta*beta)/(kB*kB*heat_temps(k)*heat_temps(k)*((cosh(heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 2) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(8.0_8*heat_fields(a)*heat_fields(a)*beta*beta*(2.0_8+cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 3) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(heat_fields(a)*heat_fields(a)*beta*beta*((1.0_8/(cosh(heat_fields(a)*beta/(kB*heat_temps(k)))**2))+4.0_8*(1.0_8/(cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))**2))))/(kB*kB*heat_temps(k)*heat_temps(k))
				if(ImpS == 4) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(8.0_8*heat_fields(a)*heat_fields(a)*beta*beta*(10.0_8+10.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+4.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+2.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 5) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(heat_fields(a)*heat_fields(a)*beta*beta*(35.0_8+40.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+20.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+8.0_8*cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+2.0_8*cosh(8.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((cosh(heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(3.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(5.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 6) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(8.0_8*heat_fields(a)*heat_fields(a)*beta*beta*(28.0_8+35.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+20.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+10.0_8*cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+4.0_8*cosh(8.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(10.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+2.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+2.0_8*cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 7) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(2.0_8*heat_fields(a)*heat_fields(a)*beta*beta*(42.0_8+56.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+35.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+20.0_8*cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+10.0_8*cosh(8.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+4.0_8*cosh(10.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(12.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((cosh(heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(3.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(5.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(7.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS > 7) then
					call output_text("Monomer impurities with S > 3.5 are not yet implemented",.false.)
					call control('kill ')
					return
				end if
			end do
		end do
	end if
	if(local_lattice(1) /= 0.0_8) then
		do k = 1,heat_numT
			heat_calc(:,k) = heat_calc(:,k) + 234.0_8*dabs((heat_temps(k)/local_lattice(1))**local_lattice(2))
		end do
	end if
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,heat_numB
			do k = 1,heat_numT
				if(a == 0) then
					call send_plot_data("hea_cal",heat_numT,heat_temps(k))
				else
					call send_plot_data("hea_cal",heat_numT,heat_calc(a,k))
				end if
			end do
		end do
		call send_plot_signal("heaC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_heat_capacity_coupled
	
	subroutine calc_heat_capacity(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_lattice,local_ImpQuant)
	! Calculates the heat capacity of the system
	implicit none
	real(kind=8),allocatable::vecdir(:,:),dummyR(:,:),static_real(:,:)
	complex(kind=8),allocatable::dummyI(:,:),static_imag(:,:)
	integer::numdir,a,num_threads
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:),local_lattice(2),local_ImpQuant
	character(len=1)::RI
	!---OMP---!
	integer::g,k,j
	real(kind=8)::local_B(3),base,Z(3)
	real(kind=8),allocatable::local_matrix_real(:,:),local_eigenvalues(:)
	complex(kind=8),allocatable::local_matrix_imag(:,:)
#ifdef mpi
	integer::g_start,g_finish
	real(kind=8),allocatable::loc_heat(:,:)
#endif
	if(return_all) then
		!write(6,*) "I"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*I"
	end if
	heat_calc = 0.0_8
	call ZCW(heat_intLevel,heat_intCover,heat_field_vec,numdir,vecdir)
	if(aniso == 0 .and. numdir == 1 .and. vecdir(1,1) == 0.0_8 .and. vecdir(1,2) == 0.0_8) then
		RI = 'R'
		allocate(static_real(totaldim,totaldim),dummyI(1,1))
	else
		RI = 'I'
		allocate(static_imag(totaldim,totaldim),dummyR(1,1))
	end if
#ifdef mpi
	call set_mpi_limits(numdir,g_start,g_finish)
#endif
#ifdef omp
	num_threads = omp_get_num_procs()
	if(MaxCPU >= num_threads) then
		num_threads = omp_get_num_procs()
	else if(MaxCPU == 0)  then
		if(num_threads > 1) num_threads = omp_get_num_procs()-1
	else
		num_threads = MaxCPU
	end if
	if(numdir < num_threads) num_threads = numdir
#endif
	if(RI == 'I') call matrix_elements('I','U',dummyR,static_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	if(RI == 'R') call matrix_elements('R','U',static_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	do a = 1,heat_numB
#ifdef omp
		!$OMP PARALLEL IF(num_threads > 1 .and. numdir > 1) NUM_THREADS(num_threads) SHARED(num_threads,a,heat_numB,numdir,heat_fields,vecdir,RI,dummyR,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,static_imag,static_real,totaldim,dummyI,heat_numT,EPS,heat_temps,heat_calc) PRIVATE(g,local_B,local_matrix_imag,local_matrix_real,local_eigenvalues,base,k,Z,j)
#endif
		if(RI == 'I' .and. .not. allocated(local_matrix_imag)) allocate(local_matrix_imag(totaldim,totaldim))
		if(RI == 'R' .and. .not. allocated(local_matrix_real)) allocate(local_matrix_real(totaldim,totaldim))
		if(.not. allocated(local_eigenvalues)) allocate(local_eigenvalues(totaldim))
#ifdef omp
		!$OMP DO
#endif
#ifdef mpi
	if(g_start /= 0 .and.g_finish /= 0) then
		do g = g_start,g_finish
#else
		do g = 1,numdir
#endif
#ifndef omp
			if(return_all) return
#endif
			if(.not. return_all) then
				local_B = heat_fields(a)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
				if(RI == 'I') then
					call matrix_elements('I','U',dummyR,local_matrix_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
					local_matrix_imag = local_matrix_imag + static_imag
					call diagonalize('I','N','U',totaldim,dummyR,local_matrix_imag,local_eigenvalues(:))
				else if(RI == 'R') then
					call matrix_elements('R','U',local_matrix_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
					local_matrix_real = local_matrix_real + static_real
					call diagonalize('R','N','U',totaldim,local_matrix_real,dummyI,local_eigenvalues(:))
				end if
				base = local_eigenvalues(1)
				local_eigenvalues = local_eigenvalues - base
				do k = 1,heat_numT
					Z = 0.0_8
					do j = 1,totaldim
						Z(1) = Z(1) + dexp((-local_eigenvalues(j)/(kB*heat_temps(k))))
						Z(2) = Z(2) + local_eigenvalues(j)*dexp((-local_eigenvalues(j)/(kB*heat_temps(k))))
						Z(3) = Z(3) + local_eigenvalues(j)*local_eigenvalues(j)*dexp((-local_eigenvalues(j)/(kB*heat_temps(k))))
					end do
#ifdef omp
					!$OMP CRITICAL
#endif
					heat_calc(a,k) = heat_calc(a,k) + vecdir(g,10)*(Z(3)*Z(1)-Z(2)*Z(2))/(Z(1)*Z(1)*kB*kB*heat_temps(k)*heat_temps(k))
#ifdef omp
					!$OMP END CRITICAL
#endif
				end do
			end if
		end do
#ifdef mpi
	end if
#endif
#ifdef omp
		!$OMP END DO
#endif
		if(RI == 'I' .and. allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(RI == 'R' .and. allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
#ifdef omp
		!$OMP END PARALLEL
#endif
		global_percent = global_percent + 1
#ifdef gui
		if(mpi_rank == 0 .and. OperationMode(1:3) == 'sim') call send_progress(100*global_percent/global_total,ptr_to_C_code)
#endif
		if(return_all) return
	end do
	if(return_all) return
#ifdef mpi
	allocate(loc_heat(heat_numB,heat_numT))
	call MPI_ALLREDUCE(heat_calc,loc_heat,heat_numB*heat_numT,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,mpi_error1)
	heat_calc = loc_heat
	deallocate(loc_heat)
#endif
	if(ImpS /=0 .and. local_ImpQuant /= 0.0_8) then
		do a=1,heat_numB
			do k = 1,heat_numT
				if(ImpS == 1) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(heat_fields(a)*heat_fields(a)*beta*beta)/(kB*kB*heat_temps(k)*heat_temps(k)*((cosh(heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 2) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(8.0_8*heat_fields(a)*heat_fields(a)*beta*beta*(2.0_8+cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 3) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(heat_fields(a)*heat_fields(a)*beta*beta*((1.0_8/(cosh(heat_fields(a)*beta/(kB*heat_temps(k)))**2))+4.0_8*(1.0_8/(cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))**2))))/(kB*kB*heat_temps(k)*heat_temps(k))
				if(ImpS == 4) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(8.0_8*heat_fields(a)*heat_fields(a)*beta*beta*(10.0_8+10.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+4.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+2.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 5) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(heat_fields(a)*heat_fields(a)*beta*beta*(35.0_8+40.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+20.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+8.0_8*cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+2.0_8*cosh(8.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((cosh(heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(3.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(5.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 6) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(8.0_8*heat_fields(a)*heat_fields(a)*beta*beta*(28.0_8+35.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+20.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+10.0_8*cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+4.0_8*cosh(8.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(10.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((1.0_8+2.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+2.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+2.0_8*cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS == 7) heat_calc(a,k) = heat_calc(a,k)*(1.0_8-dabs(local_ImpQuant)) + dabs(local_ImpQuant)*(2.0_8*heat_fields(a)*heat_fields(a)*beta*beta*(42.0_8+56.0_8*cosh(2.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+35.0_8*cosh(4.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+20.0_8*cosh(6.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+10.0_8*cosh(8.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+4.0_8*cosh(10.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(12.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))))/(kB*kB*heat_temps(k)*heat_temps(k)*((cosh(heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(3.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(5.0_8*heat_fields(a)*beta/(kB*heat_temps(k)))+cosh(7.0_8*heat_fields(a)*beta/(kB*heat_temps(k))))**2))
				if(ImpS > 7) then
					call output_text("Monomer impurities with S > 3.5 are not yet implemented",.false.)
					call control('kill ')
					return
				end if
			end do
		end do
	end if
	if(local_lattice(1) /= 0.0_8) then
		do k = 1,heat_numT
			heat_calc(:,k) = heat_calc(:,k) + 234.0_8*dabs((heat_temps(k)/local_lattice(1))**local_lattice(2))
		end do
	end if
	if(RI == 'I') then
		if(allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(allocated(dummyI)) deallocate(dummyI)
		if(allocated(static_imag)) deallocate(static_imag)
	else if(RI == 'R')then
		if(allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(dummyR)) deallocate(dummyR)
		if(allocated(static_real)) deallocate(static_real)
	end if
	if(allocated(local_eigenvalues)) deallocate(local_eigenvalues)
	deallocate(vecdir)
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,heat_numB
			do k = 1,heat_numT
				if(a == 0) then
					call send_plot_data("hea_cal",heat_numT,heat_temps(k))
				else
					call send_plot_data("hea_cal",heat_numT,heat_calc(a,k))
				end if
			end do
		end do
		call send_plot_signal("heaC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_heat_capacity
	
	subroutine calc_zee_coupled(S_spins,S_energies,S_Gfactors)
	! Calculates a zeeman plot for the coupled system
	real(kind=8)::S_energies(:),S_Gfactors(:)
	integer::a,S_spins(:),d,k,j
	if(return_all) then
		!write(6,*) "J"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*J"
	end if
	zee_calc = 0.0_8
	do a=1,zee_numB
		if(return_all) return
		d = 0
		do k = 1,Sdim
			do j = -S_spins(k),S_spins(k),2
				d = d + 1
				zee_calc(d,a) = 0.5_8*j*S_Gfactors(k)*beta*zee_fields(a) + S_energies(k)
			end do
		end do
	end do
	zee_calc = zee_calc/EnergyConvert
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 1,zee_numB
			call send_plot_data("zee_cal",zee_numB,zee_fields(a))
		end do
		d = 0
		do k = 1,Sdim
			do j = -S_spins(k),S_spins(k),2
				d = d + 1
				do a = 1,zee_numB
					call send_plot_data("zee_cal",zee_numB,zee_calc(d,a))
				end do
			end do
		end do
		call send_plot_signal("zeeC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_zee_coupled
	
	subroutine calc_zee(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
	! Calculates a zeeman plot for the system
	real(kind=8),allocatable::vecdir(:,:),dummyR(:,:),static_real(:,:)
	complex(kind=8),allocatable::dummyI(:,:),static_imag(:,:)
	integer::numdir,num_threads
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:)
	character(len=1)::RI
	!---OMP---
	integer::a,k
	real(kind=8)::local_B(3)
	real(kind=8),allocatable::local_matrix_real(:,:)
	complex(kind=8),allocatable::local_matrix_imag(:,:)
#ifdef mpi
	integer::g_start,g_finish
	real(kind=8),allocatable::loc_zee(:,:)
#endif
	if(return_all) then
		!write(6,*) "K"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*K"
	end if
	zee_calc = 0.0_8
	call ZCW(zee_intLevel,zee_intCover,zee_field_vec,numdir,vecdir)
	if(aniso == 0 .and. numdir == 1 .and. vecdir(1,1) == 0.0_8 .and. vecdir(1,2) == 0.0_8) then
		RI = 'R'
		allocate(static_real(totaldim,totaldim),dummyI(1,1))
	else
		RI = 'I'
		allocate(static_imag(totaldim,totaldim),dummyR(1,1))
	end if
#ifdef mpi
	call set_mpi_limits(zee_numB,g_start,g_finish)
#endif
#ifdef omp
	num_threads = omp_get_num_procs()
	if(MaxCPU >= num_threads) then
		num_threads = omp_get_num_procs()
	else if(MaxCPU == 0)  then
		if(num_threads > 1) num_threads = omp_get_num_procs()-1
	else
		num_threads = MaxCPU
	end if
	if(zee_numB < num_threads) num_threads = zee_numB
#endif
	if(RI == 'I') call matrix_elements('I','U',dummyR,static_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
	if(RI == 'R') call matrix_elements('R','U',static_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
#ifdef omp
	!$OMP PARALLEL IF(num_threads > 1 .and. zee_numB > 1) NUM_THREADS(num_threads) SHARED(zee_numB,zee_fields,vecdir,RI,dummyR,dummyI,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,static_imag,static_real,totaldim,zee_calc) PRIVATE(a,local_B,local_matrix_real,local_matrix_imag)
#endif
	if(RI == 'I' .and. .not. allocated(local_matrix_imag)) allocate(local_matrix_imag(totaldim,totaldim))
	if(RI == 'R' .and. .not. allocated(local_matrix_real)) allocate(local_matrix_real(totaldim,totaldim))
#ifdef omp
	!$OMP DO
#endif
#ifdef mpi
	if(g_start /= 0 .and.g_finish /= 0) then
		do a = g_start,g_finish
#else
	do a=1,zee_numB
#endif
#ifndef omp
		if(return_all) return
#endif
		if(.not. return_all) then
			local_B = zee_fields(a)*vecdir(1,1:3) + static_field_magnitude*static_field_direction
			if(RI == 'I') then
				call matrix_elements('I','U',dummyR,local_matrix_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
				local_matrix_imag = local_matrix_imag + static_imag
				call diagonalize('I','N','U',totaldim,dummyR,local_matrix_imag,zee_calc(:,a))
			else if(RI == 'R') then
				call matrix_elements('R','U',local_matrix_real,dummyI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
				local_matrix_real = local_matrix_real + static_real
				call diagonalize('R','N','U',totaldim,local_matrix_real,dummyI,zee_calc(:,a))
			end if
		end if
#ifdef omp
		!$OMP CRITICAL
#endif
		global_percent = global_percent + 1
#ifdef omp
		!$OMP END CRITICAL
#endif
#ifdef gui
		if(mpi_rank == 0 .and. OperationMode(1:3) == 'sim') call send_progress(100*global_percent/global_total,ptr_to_C_code)
#endif
	end do
#ifdef mpi
	end if
#endif
#ifdef omp
	!$OMP END DO
#endif
	if(RI == 'I' .and. allocated(local_matrix_imag)) deallocate(local_matrix_imag)
	if(RI == 'R' .and. allocated(local_matrix_real)) deallocate(local_matrix_real)
#ifdef omp
	!$OMP END PARALLEL
#endif
	if(return_all) return
#ifdef mpi
	allocate(loc_zee(totaldim,zee_numB))
	call MPI_ALLREDUCE(zee_calc,loc_zee,totaldim*zee_numB,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,mpi_error1)
	zee_calc = loc_zee
	deallocate(loc_zee)
#endif
	zee_calc = zee_calc/EnergyConvert
	if(RI == 'I') then
		if(allocated(local_matrix_imag)) deallocate(local_matrix_imag)
		if(allocated(dummyI)) deallocate(dummyI)
		if(allocated(static_imag)) deallocate(static_imag)
	else if(RI == 'R')then
		if(allocated(local_matrix_real)) deallocate(local_matrix_real)
		if(allocated(dummyR)) deallocate(dummyR)
		if(allocated(static_real)) deallocate(static_real)
	end if
	deallocate(vecdir)
	if(return_all) return
#ifdef gui
	if(uncert_in_progress == 0) then
		do a = 0,totaldim
			do k = 1,zee_numB
				if(a == 0) call send_plot_data("zee_cal",zee_numB,zee_fields(k))
				if(a /= 0) call send_plot_data("zee_cal",zee_numB,zee_calc(a,k))
			end do
		end do
		call send_plot_signal("zeeC",ptr_to_C_code)
	end if
#endif
	end subroutine calc_zee
	
	subroutine calc_states(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
	! Calculates and prints the wavefunction and static properties of the system
	implicit none
	real(kind=8),allocatable::dummyR(:,:),identity_Gmat(:,:,:),identity_ored(:)
	complex(kind=8),allocatable::zeeX(:,:),zeeY(:,:),zeeZ(:,:),CG_matI(:,:),dummyI(:,:),states_vecsI(:,:),static_imag(:,:)
	real(kind=8)::local_B(3),G_tensor(3,3),temp(3),trans_prob
	integer::k,j,num_J,counter,curr,order(3),maxtwoJ,mintwoJ
	integer,allocatable::basis2(:),ion_J(:),J_basis(:,:)
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:)
	if(return_all) then
		!write(6,*) "L"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*L"
	end if
	allocate(states_vecsI(totaldim,totaldim),dummyR(1,1),dummyI(1,1),static_imag(totaldim,totaldim),identity_Gmat(3,3,N),identity_ored(N))
	local_B = static_field_magnitude*static_field_direction
	call matrix_elements('I','U',dummyR,states_vecsI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.true.,.true.,.false.)
	if(OperationMode(1:3) == 'sim' .or. scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0) then
		call diagonalize('I','V','U',totaldim,dummyR,states_vecsI,levs_calc)
	else
		call diagonalize('I','N','U',totaldim,dummyR,states_vecsI,levs_calc)
	end if
	if(return_all) then
		!write(6,*) "L1"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*L1"
	end if
	if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
		allocate(basis2(maxSnum+maxLnum))
		open(40,file=trim(WorkDir)//"/"//trim(JobTitle)//"_states.res",status='unknown')
		write(40,'(A39)') "---------------------------------------"
		write(40,'(A39)') "Eigenstates (Wavefunction coefficients)"
		write(40,'(A39)') "---------------------------------------"
		write(40,*)
		write(40,'(A6)',advance='no') "E cm-1"
		do k=2,maxSnum+maxLnum
			write(40,'(A6)',advance='no') "      "
		end do
		do k=1,totaldim
			write(40,'(E12.4E2)',advance='no') (levs_calc(k)-levs_calc(1))/EnergyConvert
		end do
		write(40,*)
		write(40,*)
		write(40,'(A1)',advance='no') ' '
		do j = 1,maxSnum
			if(metalType(j) == 2) then
				if(j < 10) write(40,'(A4,I1,A1)',advance='no') ' mJ(',j,')'
				if(j < 100 .and. j > 9) write(40,'(A3,I1,A1)',advance='no') 'mJ(',j,')'
			else
				if(j < 10) write(40,'(A4,I1,A1)',advance='no') ' mS(',j,')'
				if(j < 100 .and. j > 9) write(40,'(A3,I1,A1)',advance='no') 'mS(',j,')'
			end if			
		end do
		do j = maxSnum+1,maxSnum+maxLnum
			if(j < 10) write(40,'(A4,I1,A1)',advance='no') ' mL(',j-maxSnum,')'
			if(j < 100 .and. j > 9) write(40,'(A3,I1,A1)',advance='no') 'mL(',j-maxSnum,')'
		end do
		write(40,*)
		do k=1,totaldim
			basis2(:) = basis_lookup(k,:)
			do j = 1,maxSnum+maxLnum
				write(40,'(F6.1)',advance='no') basis2(j)*0.5_8
			end do
			do j=1,totaldim
				if(FullWF == 1 .or. dabs(dble(states_vecsI(k,j))) >= 0.000000005_8) then
					write(40,'(F12.8)',advance='no') dble(states_vecsI(k,j))
				else
					write(40,'(A12)',advance='no') "            "
				end if
			end do
			write(40,*)
		end do
		write(40,*)
		do k=1,totaldim
			basis2(:) = basis_lookup(k,:)
			do j = 1,maxSnum+maxLnum
				write(40,'(F6.1)',advance='no') basis2(j)*0.5_8
			end do
			do j=1,totaldim
				if(FullWF == 1 .or. dabs(dimag(states_vecsI(k,j))) >= 0.000000005_8) then
					write(40,'(F12.8)',advance='no') dimag(states_vecsI(k,j))
				else
					write(40,'(A12)',advance='no') "            "
				end if
			end do
			write(40,*)
		end do
		write(40,*)
		write(40,*)
		write(40,'(A36)') "------------------------------------"
		write(40,'(A36)') "Eigenstates (Percentage Composition)"
		write(40,'(A36)') "------------------------------------"
		write(40,*)
		write(40,'(A6)',advance='no') "E cm-1"
		do k=2,maxSnum+maxLnum
			write(40,'(A6)',advance='no') "      "
		end do
		do k=1,totaldim
			write(40,'(E12.4E2)',advance='no') (levs_calc(k)-levs_calc(1))/EnergyConvert
		end do
		write(40,*)
		write(40,*)
		write(40,'(A1)',advance='no') ' '
		do j = 1,maxSnum
			if(j < 10) write(40,'(A4,I1,A1)',advance='no') ' mS(',j,')'
			if(j < 100 .and. j > 9) write(40,'(A3,I1,A1)',advance='no') 'mS(',j,')'
		end do
		do j = maxSnum+1,maxSnum+maxLnum
			if(j < 10) write(40,'(A4,I1,A1)',advance='no') ' mL(',j-maxSnum,')'
			if(j < 100 .and. j > 9) write(40,'(A3,I1,A1)',advance='no') 'mL(',j-maxSnum,')'
		end do
		write(40,*)
		do k=1,totaldim
			basis2(:) = basis_lookup(k,:)
			do j = 1,maxSnum+maxLnum
				write(40,'(F6.1)',advance='no') basis2(j)*0.5_8
			end do
			do j=1,totaldim
				if(FullWF == 1 .or. dabs(dble(states_vecsI(k,j)*conjg(states_vecsI(k,j)))) >= 0.00000005_8) then
					write(40,'(F12.7)',advance='no') 100.0_8*dble(states_vecsI(k,j)*conjg(states_vecsI(k,j)))
				else
					write(40,'(A12)',advance='no') "            "
				end if
			end do
			write(40,*)
		end do
		write(40,*)
		write(40,*)
		if(N == 1) then
			if(MetalType(1) == 1) then
				num_J = 0
				maxtwoJ = twoS(1) + twoL(1)
				mintwoJ = abs(twoS(1) - twoL(1))
				num_J = (maxtwoJ - mintwoJ)/2 + 1
				if(num_J /= 0) then
					write(40,'(A46)') "----------------------------------------------"
					write(40,'(A46)') "|J,Jz> Representation (Percentage Composition)"
					write(40,'(A46)') "----------------------------------------------"
					write(40,*)
					allocate(ion_J(num_J),J_basis(totaldim,2),CG_matI(totaldim,totaldim))
					counter = 0
					do j = mintwoJ,maxtwoJ,2
						counter = counter + 1
						ion_J(counter) = j
					end do
					counter = 0
					do k = 1,num_J
						do j = 1,ion_J(k)+1
							counter = counter + 1
							J_basis(counter,1) = ion_J(k)
							J_basis(counter,2) = -ion_J(k) + 2*(j-1)
						end do
					end do
					CG_matI = (0.0_8,0.0_8)
					do j = 1,totaldim
						do k = 1,totaldim
							CG_matI(j,k) = CG(twoS(1),basis_lookup(k,1),twoL(1),basis_lookup(k,2),J_basis(j,1),J_basis(j,2))
						end do
					end do
					call multiply('I','N','N',totaldim,dummyR,CG_matI,dummyR,states_vecsI)
					do k=1,totaldim
						basis2(:) = J_basis(k,:)
						do j = 1,maxSnum+maxLnum
							write(40,'(F6.1)',advance='no') basis2(j)*0.5_8
						end do
						do j=1,totaldim
							if(FullWF == 1 .or. 50.0_8*dabs(dble(CG_matI(k,j)*conjg(CG_matI(k,j)))) >= 0.0000001_8) then
								write(40,'(F12.7)',advance='no') 50.0_8*dabs(dble(CG_matI(k,j)*conjg(CG_matI(k,j))))
							else
								write(40,'(A12)',advance='no') "            "
							end if
						end do
						write(40,*)
					end do
					write(40,*)
					write(40,*)
					deallocate(ion_J,J_basis,CG_matI)
				end if
			end if
		end if
		if(.not. allocated(zeeX)) allocate(zeeX(totaldim,totaldim))
		if(.not. allocated(zeeY)) allocate(zeeY(totaldim,totaldim))
		if(.not. allocated(zeeZ)) allocate(zeeZ(totaldim,totaldim))
		zeeX = (0.0_8,0.0_8)
		zeeY = (0.0_8,0.0_8)
		zeeZ = (0.0_8,0.0_8)
		identity_Gmat(:,:,:) = 0.0_8
		identity_Gmat(1,1,:) = 1.0_8
		identity_Gmat(2,2,:) = 1.0_8
		identity_Gmat(3,3,:) = 1.0_8
		identity_ored(:) = 0.0_8
		if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
			write(40,'(A24)') "------------------------"
			write(40,'(A24)') "   Sx matrix elements   "
			write(40,'(A24)') "------------------------"
			write(40,*)
			write(40,'(A12)',advance='no') "            "
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
			end do
			write(40,*)
			write(40,*)
		end if
		local_B = 0.0_8
		local_B(1) = 1.0_8
		call matrix_elements('I','A',dummyR,zeeX,local_B,local_lamda,identity_ored,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeX)
		zeeX = zeeX/beta
		if(OperationMode(1:3) == 'fit' .and. scan(OperationModeB,'x',.false.) /= 0) me_calc(1,:,:) = zeeX
		if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
			open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Sx.res",status='unknown')
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dble(ZeeX(k,j))
					end do
					write(41,*)
				end do
				write(41,*)
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dimag(ZeeX(k,j))
					end do
					write(41,*)
				end do
			close(41)
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
				do j=1,totaldim
					if((FullWF == 1 .or. dabs(dble(ZeeX(k,j))) >= 1D-10)) then
						write(40,'(E12.4E2)',advance='no') dble(ZeeX(k,j))
					else
						write(40,'(A12)',advance='no') "            "
					end if
				end do
				write(40,*)
			end do
			write(40,*)
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
				do j=1,totaldim
					if((FullWF == 1 .or. dabs(dimag(ZeeX(k,j))) >= 1D-10)) then
						write(40,'(E12.4E2)',advance='no') dimag(ZeeX(k,j))
					else
						write(40,'(A12)',advance='no') "            "
					end if
				end do
				write(40,*)
			end do
			write(40,*)
			write(40,*)
			write(40,'(A24)') "------------------------"
			write(40,'(A24)') "   Sy matrix elements   "
			write(40,'(A24)') "------------------------"
			write(40,*)
			write(40,'(A12)',advance='no') "            "
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
			end do
			write(40,*)
			write(40,*)
		end if
		local_B = 0.0_8
		local_B(2) = 1.0_8
		call matrix_elements('I','A',dummyR,zeeY,local_B,local_lamda,identity_ored,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeY)
		zeeY = zeeY/beta
		if(OperationMode(1:3) == 'fit' .and. scan(OperationModeB,'x',.false.) /= 0) me_calc(2,:,:) = zeeY
		if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
			open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Sy.res",status='unknown')
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dble(ZeeY(k,j))
					end do
					write(41,*)
				end do
				write(41,*)
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dimag(ZeeY(k,j))
					end do
					write(41,*)
				end do
			close(41)
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
				do j=1,totaldim
					if((FullWF == 1 .or. dabs(dble(ZeeY(k,j))) >= 1D-10)) then
						write(40,'(E12.4E2)',advance='no') dble(ZeeY(k,j))
					else
						write(40,'(A12)',advance='no') "            "
					end if
				end do
				write(40,*)
			end do
			write(40,*)
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
				do j=1,totaldim
					if((FullWF == 1 .or. dabs(dimag(ZeeY(k,j))) >= 1D-10)) then
						write(40,'(E12.4E2)',advance='no') dimag(ZeeY(k,j))
					else
						write(40,'(A12)',advance='no') "            "
					end if
				end do
				write(40,*)
			end do
			write(40,*)
			write(40,*)
			write(40,'(A24)') "------------------------"
			write(40,'(A24)') "   Sz matrix elements   "
			write(40,'(A24)') "------------------------"
			write(40,*)
			write(40,'(A12)',advance='no') "            "
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
			end do
			write(40,*)
			write(40,*)
		end if
		local_B = 0.0_8
		local_B(3) = 1.0_8
		call matrix_elements('I','A',dummyR,zeeZ,local_B,local_lamda,identity_ored,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeZ)
		zeeZ = zeeZ/beta
		if(OperationMode(1:3) == 'fit' .and. scan(OperationModeB,'x',.false.) /= 0) me_calc(3,:,:) = zeeZ
		if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
			open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Sz.res",status='unknown')
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dble(ZeeZ(k,j))
					end do
					write(41,*)
				end do
				write(41,*)
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dimag(ZeeZ(k,j))
					end do
					write(41,*)
				end do
			close(41)
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
				do j=1,totaldim
					if((FullWF == 1 .or. dabs(dble(ZeeZ(k,j))) >= 1D-10)) then
						write(40,'(E12.4E2)',advance='no') dble(ZeeZ(k,j))
					else
						write(40,'(A12)',advance='no') "            "
					end if
				end do
				write(40,*)
			end do
			write(40,*)
			do k=1,totaldim
				write(40,'(I12)',advance='no') k
				do j=1,totaldim
					if((FullWF == 1 .or. dabs(dimag(ZeeZ(k,j))) >= 1D-10)) then
						write(40,'(E12.4E2)',advance='no') dimag(ZeeZ(k,j))
					else
						write(40,'(A12)',advance='no') "            "
					end if
				end do
				write(40,*)
			end do
			write(40,*)
			write(40,*)
		end if
		if(sum(twoL) /= 0) then
			if(.not. allocated(zeeX)) allocate(zeeX(totaldim,totaldim))
			if(.not. allocated(zeeY)) allocate(zeeY(totaldim,totaldim))
			if(.not. allocated(zeeZ)) allocate(zeeZ(totaldim,totaldim))
			zeeX = (0.0_8,0.0_8)
			zeeY = (0.0_8,0.0_8)
			zeeZ = (0.0_8,0.0_8)
			identity_Gmat(:,:,:) = 0.0_8
			identity_ored(:) = 1.0_8
			if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
				write(40,'(A24)') "------------------------"
				write(40,'(A24)') "   Lx matrix elements   "
				write(40,'(A24)') "------------------------"
				write(40,*)
				write(40,'(A12)',advance='no') "            "
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
				end do
				write(40,*)
				write(40,*)
			end if
			local_B = 0.0_8
			local_B(1) = 1.0_8
			call matrix_elements('I','A',dummyR,zeeX,local_B,local_lamda,local_orbred,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeX)
			zeeX = zeeX/beta
			if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
				open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Lx.res",status='unknown')
					do k=1,totaldim
						do j=1,totaldim
							write(41,'(E24.15E3)',advance='no') dble(ZeeX(k,j))
						end do
						write(41,*)
					end do
					write(41,*)
					do k=1,totaldim
						do j=1,totaldim
							write(41,'(E24.15E3)',advance='no') dimag(ZeeX(k,j))
						end do
						write(41,*)
					end do
				close(41)
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
					do j=1,totaldim
						if((FullWF == 1 .or. dabs(dble(ZeeX(k,j))) >= 1D-10)) then
							write(40,'(E12.4E2)',advance='no') dble(ZeeX(k,j))
						else
							write(40,'(A12)',advance='no') "            "
						end if
					end do
					write(40,*)
				end do
				write(40,*)
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
					do j=1,totaldim
						if((FullWF == 1 .or. dabs(dimag(ZeeX(k,j))) >= 1D-10)) then
							write(40,'(E12.4E2)',advance='no') dimag(ZeeX(k,j))
						else
							write(40,'(A12)',advance='no') "            "
						end if
					end do
					write(40,*)
				end do
				write(40,*)
				write(40,*)
				write(40,'(A24)') "------------------------"
				write(40,'(A24)') "   Ly matrix elements   "
				write(40,'(A24)') "------------------------"
				write(40,*)
				write(40,'(A12)',advance='no') "            "
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
				end do
				write(40,*)
				write(40,*)
			end if
			local_B = 0.0_8
			local_B(2) = 1.0_8
			call matrix_elements('I','A',dummyR,zeeY,local_B,local_lamda,local_orbred,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeY)
			zeeY = zeeY/beta
			if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
				open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Ly.res",status='unknown')
					do k=1,totaldim
						do j=1,totaldim
							write(41,'(E24.15E3)',advance='no') dble(ZeeY(k,j))
						end do
						write(41,*)
					end do
					write(41,*)
					do k=1,totaldim
						do j=1,totaldim
							write(41,'(E24.15E3)',advance='no') dimag(ZeeY(k,j))
						end do
						write(41,*)
					end do
				close(41)
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
					do j=1,totaldim
						if((FullWF == 1 .or. dabs(dble(ZeeY(k,j))) >= 1D-10)) then
							write(40,'(E12.4E2)',advance='no') dble(ZeeY(k,j))
						else
							write(40,'(A12)',advance='no') "            "
						end if
					end do
					write(40,*)
				end do
				write(40,*)
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
					do j=1,totaldim
						if((FullWF == 1 .or. dabs(dimag(ZeeY(k,j))) >= 1D-10)) then
							write(40,'(E12.4E2)',advance='no') dimag(ZeeY(k,j))
						else
							write(40,'(A12)',advance='no') "            "
						end if
					end do
					write(40,*)
				end do
				write(40,*)
				write(40,*)
				write(40,'(A24)') "------------------------"
				write(40,'(A24)') "   Lz matrix elements   "
				write(40,'(A24)') "------------------------"
				write(40,*)
				write(40,'(A12)',advance='no') "            "
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
				end do
				write(40,*)
				write(40,*)
			end if
			local_B = 0.0_8
			local_B(3) = 1.0_8
			call matrix_elements('I','A',dummyR,zeeZ,local_B,local_lamda,local_orbred,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeZ)
			zeeZ = zeeZ/beta
			if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
				open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Lz.res",status='unknown')
					do k=1,totaldim
						do j=1,totaldim
							write(41,'(E24.15E3)',advance='no') dble(ZeeZ(k,j))
						end do
						write(41,*)
					end do
					write(41,*)
					do k=1,totaldim
						do j=1,totaldim
							write(41,'(E24.15E3)',advance='no') dimag(ZeeZ(k,j))
						end do
						write(41,*)
					end do
				close(41)
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
					do j=1,totaldim
						if((FullWF == 1 .or. dabs(dble(ZeeZ(k,j))) >= 1D-10)) then
							write(40,'(E12.4E2)',advance='no') dble(ZeeZ(k,j))
						else
							write(40,'(A12)',advance='no') "            "
						end if
					end do
					write(40,*)
				end do
				write(40,*)
				do k=1,totaldim
					write(40,'(I12)',advance='no') k
					do j=1,totaldim
						if((FullWF == 1 .or. dabs(dimag(ZeeZ(k,j))) >= 1D-10)) then
							write(40,'(E12.4E2)',advance='no') dimag(ZeeZ(k,j))
						else
							write(40,'(A12)',advance='no') "            "
						end if
					end do
					write(40,*)
				end do
				write(40,*)
				write(40,*)
			end if
		end if
		if(return_all) then
			!write(6,*) "L2"
			return
		end if
		if(.not. allocated(zeeX)) allocate(zeeX(totaldim,totaldim))
		if(.not. allocated(zeeY)) allocate(zeeY(totaldim,totaldim))
		if(.not. allocated(zeeZ)) allocate(zeeZ(totaldim,totaldim))
		zeeX = (0.0_8,0.0_8)
		local_B = 0.0_8
		local_B(1) = 1.0_8
		call matrix_elements('I','A',dummyR,zeeX,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeX)
		zeeX = zeeX/beta
		zeeY = (0.0_8,0.0_8)
		local_B = 0.0_8
		local_B(2) = 1.0_8
		call matrix_elements('I','A',dummyR,zeeY,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeY)
		zeeY = zeeY/beta
		zeeZ = (0.0_8,0.0_8)
		local_B = 0.0_8
		local_B(3) = 1.0_8
		call matrix_elements('I','A',dummyR,zeeZ,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeZ)
		zeeZ = zeeZ/beta
		write(40,'(A24)') "------------------------"
		write(40,'(A24)') "Transition Probabilities"
		write(40,'(A24)') "------------------------"
		write(40,*)
		write(40,'(A12)',advance='no') "            "
		do k=1,totaldim
			write(40,'(I12)',advance='no') k
		end do
		write(40,*)
		write(40,*)
		do k=1,totaldim
			write(40,'(I12)',advance='no') k
			do j=1,totaldim
				trans_prob = dabs(dble(ZeeX(k,j)*conjg(ZeeX(k,j)) + ZeeY(k,j)*conjg(ZeeY(k,j)) + ZeeZ(k,j)*conjg(ZeeZ(k,j)))/3.0_8)
				if((FullWF == 1 .or. trans_prob >= 1D-10) .and. k /= j) then
					write(40,'(E12.4E2)',advance='no') trans_prob
				else
					write(40,'(A12)',advance='no') "            "
				end if
			end do
			write(40,*)
		end do
		!if(OperationMode(1:3) /= 'sim' .and. scan(OperationModeB,'g',.false.) == 0 .and. scan(OperationModeB,'d',.false.) == 0) deallocate(zeeX,zeeY,zeeZ)
		write(40,*)
		write(40,*)
		deallocate(basis2)
	end if
	if(return_all) then
		!write(6,*) "L3"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*L3"
	end if
	if(OperationMode(1:3) == 'sim' .or. scan(OperationModeB,'g',.false.) /= 0 .or. scan(OperationModeB,'d',.false.) /= 0) then
		if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
			write(40,'(A9)') "---------"
			write(40,'(A9)') "G-tensors"
			write(40,'(A9)') "---------"
			write(40,*)
		end if
		if(OperationMode(1:3) /= 'sim') then
			allocate(zeeX(totaldim,totaldim),zeeY(totaldim,totaldim),zeeZ(totaldim,totaldim))
			zeeX = (0.0_8,0.0_8)
			local_B = 0.0_8
			local_B(1) = 1.0_8
			call matrix_elements('I','A',dummyR,zeeX,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeX)
			zeeX = zeeX/beta
			zeeY = (0.0_8,0.0_8)
			local_B = 0.0_8
			local_B(2) = 1.0_8
			call matrix_elements('I','A',dummyR,zeeY,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeY)
			zeeY = zeeY/beta
			zeeZ = (0.0_8,0.0_8)
			local_B = 0.0_8
			local_B(3) = 1.0_8
			call matrix_elements('I','A',dummyR,zeeZ,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			call expectation('I',totaldim,dummyR,states_vecsI,dummyR,zeeZ)
			zeeZ = zeeZ/beta
		end if
		if(return_all) then
			!write(6,*) "L4"
			return
		end if
		if(given_multiplicities == 0) then
			GtenDegen = 1
			if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) write(40,'(A50)') "Searching for doublets based on energy spectrum..."
			curr = 1
			do j = 1,totaldim-1
				if(dabs((levs_calc(j+1)-levs_calc(j))/(0.5_8*(levs_calc(j+1)+levs_calc(j)))) < 1000.0_8*EPS .or. levs_calc(j+1) == levs_calc(j)) then
					GtenDegen(curr) = GtenDegen(curr) + 1
				else
					curr = curr + 1
				end if
			end do
			num_mult = curr
		else
			if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) write(40,'(A32)') "Using multiplicities as given..."
		end if
		if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
			write(40,*)
			write(40,'(A14)') "Multiplicities"
			do j = 1,num_mult
				write(40,'(I4)') GtenDegen(j)
			end do
			write(40,*)
		end if
		g_numCalc = 0
		if(return_all) then
			!write(6,*) "L5"
			return
		end if
		do k = 1,num_mult
			if(GtenDegen(k) == 2) then
				curr = sum(GtenDegen(1:k))
				g_numCalc = g_numCalc + 1
				G_tensor(1,1) = dble(ZeeX(curr-1,curr)*ZeeX(curr,curr-1)+ZeeX(curr,curr-1)*ZeeX(curr-1,curr)+ZeeX(curr-1,curr-1)*ZeeX(curr-1,curr-1)+ZeeX(curr,curr)*ZeeX(curr,curr))
				G_tensor(1,2) = dble(ZeeX(curr-1,curr)*ZeeY(curr,curr-1)+ZeeX(curr,curr-1)*ZeeY(curr-1,curr)+ZeeX(curr-1,curr-1)*ZeeY(curr-1,curr-1)+ZeeX(curr,curr)*ZeeY(curr,curr))
				G_tensor(1,3) = dble(ZeeX(curr-1,curr)*ZeeZ(curr,curr-1)+ZeeX(curr,curr-1)*ZeeZ(curr-1,curr)+ZeeX(curr-1,curr-1)*ZeeZ(curr-1,curr-1)+ZeeX(curr,curr)*ZeeZ(curr,curr))
				G_tensor(2,1) = dble(ZeeY(curr-1,curr)*ZeeX(curr,curr-1)+ZeeY(curr,curr-1)*ZeeX(curr-1,curr)+ZeeY(curr-1,curr-1)*ZeeX(curr-1,curr-1)+ZeeY(curr,curr)*ZeeX(curr,curr))
				G_tensor(2,2) = dble(ZeeY(curr-1,curr)*ZeeY(curr,curr-1)+ZeeY(curr,curr-1)*ZeeY(curr-1,curr)+ZeeY(curr-1,curr-1)*ZeeY(curr-1,curr-1)+ZeeY(curr,curr)*ZeeY(curr,curr))
				G_tensor(2,3) = dble(ZeeY(curr-1,curr)*ZeeZ(curr,curr-1)+ZeeY(curr,curr-1)*ZeeZ(curr-1,curr)+ZeeY(curr-1,curr-1)*ZeeZ(curr-1,curr-1)+ZeeY(curr,curr)*ZeeZ(curr,curr))
				G_tensor(3,1) = dble(ZeeZ(curr-1,curr)*ZeeX(curr,curr-1)+ZeeZ(curr,curr-1)*ZeeX(curr-1,curr)+ZeeZ(curr-1,curr-1)*ZeeX(curr-1,curr-1)+ZeeZ(curr,curr)*ZeeX(curr,curr))
				G_tensor(3,2) = dble(ZeeZ(curr-1,curr)*ZeeY(curr,curr-1)+ZeeZ(curr,curr-1)*ZeeY(curr-1,curr)+ZeeZ(curr-1,curr-1)*ZeeY(curr-1,curr-1)+ZeeZ(curr,curr)*ZeeY(curr,curr))
				G_tensor(3,3) = dble(ZeeZ(curr-1,curr)*ZeeZ(curr,curr-1)+ZeeZ(curr,curr-1)*ZeeZ(curr-1,curr)+ZeeZ(curr-1,curr-1)*ZeeZ(curr-1,curr-1)+ZeeZ(curr,curr)*ZeeZ(curr,curr))
				G_tensor = 2.0_8*G_tensor
				gdir_calc(:,:,g_numCalc) = G_tensor
				call diagonalize('R','V','U',3,gdir_calc(:,:,g_numCalc),dummyI,g_calc(:,g_numCalc))
				do j=1,3
					if(g_calc(j,g_numCalc) < 0) g_calc(j,g_numCalc) = dabs(g_calc(j,g_numCalc))
					g_calc(j,g_numCalc) = dsqrt(g_calc(j,g_numCalc))
				end do
				temp = g_calc(:,g_numCalc)
				G_tensor = gdir_calc(:,:,g_numCalc)
				call re_order(3,g_calc(:,g_numCalc),order,'min')
				g_calc(1,g_numCalc) = temp(order(1))
				g_calc(2,g_numCalc) = temp(order(2))
				g_calc(3,g_numCalc) = temp(order(3))
				gdir_calc(1,1,g_numCalc) = G_tensor(1,order(1))
				gdir_calc(2,1,g_numCalc) = G_tensor(2,order(1))
				gdir_calc(3,1,g_numCalc) = G_tensor(3,order(1))
				gdir_calc(1,2,g_numCalc) = G_tensor(1,order(2))
				gdir_calc(2,2,g_numCalc) = G_tensor(2,order(2))
				gdir_calc(3,2,g_numCalc) = G_tensor(3,order(2))
				gdir_calc(1,3,g_numCalc) = G_tensor(1,order(3))
				gdir_calc(2,3,g_numCalc) = G_tensor(2,order(3))
				gdir_calc(3,3,g_numCalc) = G_tensor(3,order(3))
				if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
					write(40,'(A82)') "----------------------------------------------------------------------------------"
					write(40,'(A19,I4,A5,I4,A11,E12.4E2,A10,E12.4E2,A5)') "G-tensor of states ",curr-1," and ",curr,"; Energies = ",(levs_calc(curr-1)-levs_calc(1))/EnergyConvert," cm-1 and ",(levs_calc(curr)-levs_calc(1))/EnergyConvert," cm-1"
					write(40,'(A82)') "----------------------------------------------------------------------------------"
					write(40,'(A48)') "                       x           y           z"
					write(40,'(A4,F9.4,A4,3F12.8)') "Gx =",g_calc(1,g_numCalc),"    ",gdir_calc(1,1,g_numCalc),gdir_calc(2,1,g_numCalc),gdir_calc(3,1,g_numCalc)
					write(40,'(A4,F9.4,A4,3F12.8)') "Gy =",g_calc(2,g_numCalc),"    ",gdir_calc(1,2,g_numCalc),gdir_calc(2,2,g_numCalc),gdir_calc(3,2,g_numCalc)
					write(40,'(A4,F9.4,A4,3F12.8)') "Gz =",g_calc(3,g_numCalc),"    ",gdir_calc(1,3,g_numCalc),gdir_calc(2,3,g_numCalc),gdir_calc(3,3,g_numCalc)
					write(40,*)
				end if
			else
				if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) then
					if(GtenDegen(k) == 1) write(40,'(A21)') "Found a singlet state"
					if(GtenDegen(k) == 3) write(40,'(A21)') "Found a triplet state"
					if(GtenDegen(k) == 4) write(40,'(A21)') "Found a quartet state"
					if(GtenDegen(k) == 5) write(40,'(A21)') "Found a quintet state"
					if(GtenDegen(k) == 6) write(40,'(A20)') "Found a sextet state"
					if(GtenDegen(k) == 7) write(40,'(A20)') "Found a septet state"
					if(GtenDegen(k) == 8) write(40,'(A19)') "Found a octet state"
					if(GtenDegen(k) == 9) write(40,'(A19)') "Found a nonet state"
					if(GtenDegen(k) >= 10) write(40,'(A33,I4)') "Found a state with multiplicity: ",GtenDegen(k)
					write(40,*)
				end if
			end if
		end do
	end if
	if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) close(40)
	deallocate(states_vecsI,dummyR,static_imag,dummyI,identity_Gmat,identity_ored)
	if(allocated(ZeeX)) deallocate(ZeeX)
	if(allocated(ZeeY)) deallocate(ZeeY)
	if(allocated(ZeeZ)) deallocate(ZeeZ)
#ifdef gui
	if(OperationMode(1:3) == 'sim') call send_states_signal(ptr_to_C_code)
#endif
	end subroutine calc_states
	
	subroutine calc_states_coupled(S_spins,S_energies,S_vectors,S_Gfactors,S_projections)
	! Calculates the states in the coupled basis
	implicit none
	real(kind=8)::S_energies(:),S_vectors(:,:),S_Gfactors(:),S_projections(:,:)
	integer::k,j,i,S_spins(:)
	if(return_all) then
		!write(6,*) "M"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*M"
	end if
	open(40,file=trim(WorkDir)//"/"//trim(JobTitle)//"_states.res",status='unknown')
	if(FullWF == 1) then
		write(40,'(A39)') "---------------------------------------"
		write(40,'(A39)') "Eigenstates (Wavefunction coefficients)"
		write(40,'(A39)') "---------------------------------------"
		write(40,*)
		write(40,'(A6)',advance='no') "E cm-1"
		do k=2,maxSnum-1
			write(40,'(A6)',advance='no') "      "
		end do
		i = 0
		do k=1,Sdim
			if(OperationMode(1:3) == 'sim' .and. mpi_rank == 0) write(40,'(E12.4E2)',advance='no') (S_energies(k) - S_energies(1))/EnergyConvert
			do j = 1,S_spins(k)+1
				i = i+1
				levs_calc(i) = S_energies(k) - S_energies(1)
			end do
		end do
		write(40,*)
		write(40,*)
		write(40,'(A1)',advance='no') ' '
		do j = 1,maxSnum-2
			if(j < 10) write(40,'(A4,I1,A1)',advance='no') '  S(',j,')'
			if(j < 100 .and. j > 9) write(40,'(A3,I1,A1)',advance='no') ' S(',j,')'
		end do
		write(40,'(A6)',advance='no') '  S(T)'
		write(40,*)
		do k=1,Sdim
			do j = 1,maxSnum-1
				write(40,'(F6.1)',advance='no') S_basis(k,j)*0.5_8
			end do
			do j=1,Sdim
				if(dabs(S_vectors(k,j)) >= 0.000000005_8 .or. FullWF == 1) then
					write(40,'(F12.8)',advance='no') S_vectors(k,j)
				else
					write(40,'(A12)',advance='no') "            "
				end if
			end do
			write(40,*)
		end do
		write(40,*)
		write(40,'(A6)',advance='no') "G S(T)"
		do k=2,maxSnum-1
			write(40,'(A6)',advance='no') "      "
		end do
		do k=1,Sdim
			write(40,'(F12.7)',advance='no') S_Gfactors(k)
		end do
		write(40,*)
		write(40,*)
		write(40,'(A28)') "----------------------------"
		write(40,'(A28)') "Spin projection coefficients"
		write(40,'(A28)') "----------------------------"
		write(40,*)
		do j = 1,N
			write(40,'(A4,I2)',advance='no') "Site",j
			do k=2,maxSnum-1
				write(40,'(A6)',advance='no') "      "
			end do
			do k=1,Sdim
				write(40,'(F12.7)',advance='no') S_projections(k,j)
			end do
			write(40,*)
		end do
		write(40,*)
		write(40,'(A36)') "------------------------------------"
		write(40,'(A36)') "Eigenstates (Percentage Composition)"
		write(40,'(A36)') "------------------------------------"
		write(40,*)
		write(40,'(A6)',advance='no') "E cm-1"
		do k=2,maxSnum-1
			write(40,'(A6)',advance='no') "      "
		end do
		do k=1,Sdim
			write(40,'(E12.4E2)',advance='no') (S_energies(k) - S_energies(1))/EnergyConvert
		end do
		write(40,*)
		write(40,*)
		write(40,'(A1)',advance='no') ' '
		do j = 1,maxSnum-2
			if(j < 10) write(40,'(A4,I1,A1)',advance='no') '  S(',j,')'
			if(j < 100 .and. j > 9) write(40,'(A3,I1,A1)',advance='no') ' S(',j,')'
		end do
		write(40,'(A6)',advance='no') '  S(T)'
		write(40,*)
		do k=1,Sdim
			do j = 1,maxSnum-1
				write(40,'(F6.1)',advance='no') S_basis(k,j)*0.5_8
			end do
			do j=1,Sdim
				if(abs(S_vectors(k,j)*S_vectors(k,j)) >= 0.0000001_8 .or. FullWF == 1) then
					write(40,'(F12.7)',advance='no') 100.0_8*S_vectors(k,j)*S_vectors(k,j)
				else
					write(40,'(A12)',advance='no') "            "
				end if
			end do
			write(40,*)
		end do
	else
		write(40,'(A)') "---------------------------------------"
		write(40,'(A)') "Total Spin Eigenstates"
		write(40,'(A)') "---------------------------------------"
		write(40,*)
		write(40,'(A)') "    E cm-1      S(T)          G"
		i = 0
		do k=1,Sdim
			do j = 1,Sdim
				if(abs(S_vectors(j,k)*S_vectors(j,k)) > 2.0_8*EPS) then
					write(40,'(E12.4E2,A1,F6.1,A3,F12.7)') (S_energies(k) - S_energies(1))/EnergyConvert," ",S_basis(j,maxSnum-1)*0.5_8,"   ",S_Gfactors(k)
					exit
				end if
			end do
			do j = 1,S_spins(k)+1
				i = i+1
				levs_calc(i) = S_energies(k) - S_energies(1)
			end do
		end do
	end if
#ifdef gui
	if(OperationMode(1:3) == 'sim') call send_states_signal(ptr_to_C_code)
#endif
	end subroutine calc_states_coupled
	
	subroutine print_matrix_elements(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
	! Prints the matrix for the given system
	implicit none
	real(kind=8),allocatable::dummyR(:,:),identity_Gmat(:,:,:),identity_ored(:)
	real(kind=8)::local_B(3)
	complex(kind=8),allocatable::matrixI(:,:)
	integer::k,j
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:)
	if(return_all) then
		!write(6,*) "N"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*N"
	end if
	if(approx == 0 .and. mpi_rank == 0) then
		open(40,file=trim(WorkDir)//"/"//trim(JobTitle)//"_matrix.res",status='unknown')
		local_B = static_field_magnitude*static_field_direction
		allocate(dummyR(1,1),matrixI(totaldim,totaldim))
		call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.true.,.true.,.false.)
		do k=1,totaldim
			do j=1,totaldim
				write(40,'(E24.15E3)',advance='no') dble(matrixI(k,j))/EnergyConvert
			end do
			write(40,*)
		end do
		write(40,*)
		do k=1,totaldim
			do j=1,totaldim
				write(40,'(E24.15E3)',advance='no') dimag(matrixI(k,j))/EnergyConvert
			end do
			write(40,*)
		end do
		close(40)
		allocate(identity_Gmat(3,3,N),identity_ored(N))
		matrixI = (0.0_8,0.0_8)
		identity_Gmat(:,:,:) = 0.0_8
		identity_Gmat(1,1,:) = 1.0_8
		identity_Gmat(2,2,:) = 1.0_8
		identity_Gmat(3,3,:) = 1.0_8
		identity_ored(:) = 0.0_8
		local_B = 0.0_8
		local_B(1) = 1.0_8
		call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,identity_ored,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		matrixI = matrixI/beta
		open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Sx.res",status='unknown')
			do k=1,totaldim
				do j=1,totaldim
					write(41,'(E24.15E3)',advance='no') dble(matrixI(k,j))
				end do
				write(41,*)
			end do
			write(41,*)
			do k=1,totaldim
				do j=1,totaldim
					write(41,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
				end do
				write(41,*)
			end do
		close(41)
		matrixI = (0.0_8,0.0_8)
		local_B = 0.0_8
		local_B(2) = 1.0_8
		call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,identity_ored,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		matrixI = matrixI/beta
		open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Sy.res",status='unknown')
			do k=1,totaldim
				do j=1,totaldim
					write(41,'(E24.15E3)',advance='no') dble(matrixI(k,j))
				end do
				write(41,*)
			end do
			write(41,*)
			do k=1,totaldim
				do j=1,totaldim
					write(41,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
				end do
				write(41,*)
			end do
		close(41)
		matrixI = (0.0_8,0.0_8)
		local_B = 0.0_8
		local_B(3) = 1.0_8
		call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,identity_ored,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
		matrixI = matrixI/beta
		open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Sz.res",status='unknown')
			do k=1,totaldim
				do j=1,totaldim
					write(41,'(E24.15E3)',advance='no') dble(matrixI(k,j))
				end do
				write(41,*)
			end do
			write(41,*)
			do k=1,totaldim
				do j=1,totaldim
					write(41,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
				end do
				write(41,*)
			end do
		close(41)
		if(sum(twoL) /= 0) then
			matrixI = (0.0_8,0.0_8)
			identity_Gmat(:,:,:) = 0.0_8
			identity_ored(:) = 1.0_8
			local_B = 0.0_8
			local_B(1) = 1.0_8
			call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,local_orbred,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			matrixI = matrixI/beta
			open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Lx.res",status='unknown')
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dble(matrixI(k,j))
					end do
					write(41,*)
				end do
				write(41,*)
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
					end do
					write(41,*)
				end do
			close(41)
			matrixI = (0.0_8,0.0_8)
			local_B = 0.0_8
			local_B(2) = 1.0_8
			call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,local_orbred,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			matrixI = matrixI/beta
			open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Ly.res",status='unknown')
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dble(matrixI(k,j))
					end do
					write(41,*)
				end do
				write(41,*)
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
					end do
					write(41,*)
				end do
			close(41)
			matrixI = (0.0_8,0.0_8)
			local_B = 0.0_8
			local_B(3) = 1.0_8
			call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,local_orbred,local_EXmat,identity_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
			matrixI = matrixI/beta
			open(41,file=trim(WorkDir)//"/"//trim(JobTitle)//"_Lz.res",status='unknown')
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dble(matrixI(k,j))
					end do
					write(41,*)
				end do
				write(41,*)
				do k=1,totaldim
					do j=1,totaldim
						write(41,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
					end do
					write(41,*)
				end do
			close(41)
		end if
		deallocate(matrixI,identity_Gmat,identity_ored,dummyR)
	else if(approx == 1) then 
		call output_text("Matrix elements will not be printed for the Approx mode",.false.)
	end if
	end subroutine print_matrix_elements
	
	subroutine print_wave_function(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
	! Prints the wave function for the given system
	implicit none
	real(kind=8),allocatable::dummyR(:,:),levs(:)
	real(kind=8)::local_B(3)
	complex(kind=8),allocatable::matrixI(:,:)
	integer::k,j
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:)
	if(return_all) then
		!write(6,*) "N1"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*N1"
	end if
	if(approx == 0) then
		open(40,file=trim(WorkDir)//"/"//trim(JobTitle)//"_wavefunction.res",status='unknown')
		local_B = static_field_magnitude*static_field_direction
		allocate(dummyR(1,1),matrixI(totaldim,totaldim),levs(totaldim))
		call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.true.,.true.,.false.)
		call diagonalize('I','V','U',totaldim,dummyR,matrixI,levs)
		do k=1,totaldim
			do j=1,totaldim
				write(40,'(E24.15E3)',advance='no') dble(matrixI(k,j))
			end do
			write(40,*)
		end do
		write(40,*)
		do k=1,totaldim
			do j=1,totaldim
				write(40,'(E24.15E3)',advance='no') dimag(matrixI(k,j))
			end do
			write(40,*)
		end do
		close(40)
		open(40,file=trim(WorkDir)//"/"//trim(JobTitle)//"_levels.res",status='unknown')
		do k = 1,totaldim
			write(40,'(E24.15E3)') levs(k)/EnergyConvert
		end do
		close(40)
		deallocate(dummyR,matrixI,levs)
	else if(approx == 1) then 
		call output_text("Wavefunction will not be printed for the Approx mode",.false.)
	end if
	end subroutine print_wave_function
	
	! subroutine eigen_test(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6)
	! ! Tests the diagonalization routine chosen
	! implicit none
	! real(kind=8),allocatable::dummyR(:,:),eigenvalues(:)
	! real(kind=8)::local_B(3),largest,average,magnitude
	! complex(kind=8),allocatable::matrixI(:,:),vecsI(:,:),Identity(:,:)
	! integer::k,j
	! real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:)
	! if(return_all) then
	!	write(6,*) "O"
	!	return
	!end if
	! if(problem_type == 0 .or. problem_type == 1) then
		! open(40,file=trim(WorkDir)//"/"//trim(JobTitle)//"_matrix.res",status='unknown')
		! local_B = static_field_magnitude*static_field_direction
		! allocate(dummyR(1,1),matrixI(totaldim,totaldim),vecsI(totaldim,totaldim),Identity(totaldim,totaldim),eigenvalues(totaldim))
		! call matrix_elements('I','A',dummyR,matrixI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.true.,.true.,.false.)
		! vecsI = matrixI
		! call diagonalize('I','V','U',totaldim,dummyR,vecsI,eigenvalues)
		! Identity = (0.0_8,0.0_8)
		! !eigenvalues = eigenvalues/EnergyConvert
		! !matrixI = matrixI/EnergyConvert
		! do j = 1,totaldim
			! Identity(j,j) = dcmplx(eigenvalues(j),0.0_8)
		! end do
		! call multiply('I','N','N',totaldim,dummyR,matrixI,dummyR,vecsI)
		! call multiply('I','N','N',totaldim,dummyR,Identity,dummyR,vecsI)
		! do k=1,totaldim
			! do j=1,totaldim
				! write(6,'(E12.4E2)',advance='no') dble(matrixI(k,j))/EnergyConvert
			! end do
			! write(6,*)
		! end do
		! write(6,*)
		! do k=1,totaldim
			! do j=1,totaldim
				! write(6,'(E12.4E2)',advance='no') dimag(matrixI(k,j))/EnergyConvert
			! end do
			! write(6,*)
		! end do
		! write(6,*)
		! write(6,*)
		! write(6,*)
		! do k=1,totaldim
			! do j=1,totaldim
				! write(6,'(E12.4E2)',advance='no') dble(Identity(k,j))/EnergyConvert
			! end do
			! write(6,*)
		! end do
		! write(6,*)
		! do k=1,totaldim
			! do j=1,totaldim
				! write(6,'(E12.4E2)',advance='no') dimag(Identity(k,j))/EnergyConvert
			! end do
			! write(6,*)
		! end do
		! vecsI = matrixI - Identity
		! write(6,*)
		! write(6,*)
		! write(6,*)
		! do k=1,totaldim
			! do j=1,totaldim
				! write(6,'(E12.4E2)',advance='no') dble(vecsI(k,j))/EnergyConvert
			! end do
			! write(6,*)
		! end do
		! write(6,*)
		! do k=1,totaldim
			! do j=1,totaldim
				! write(6,'(E12.4E2)',advance='no') dimag(vecsI(k,j))/EnergyConvert
			! end do
			! write(6,*)
		! end do
		! largest = -99D99
		! average = 0.0_8
		! do k=1,totaldim
			! do j=1,totaldim
				! magnitude = dsqrt(dble(vecsI(j,k))*dble(vecsI(j,k)) + dimag(vecsI(j,k))*dimag(vecsI(j,k)))
				! average = average + magnitude
				! if(magnitude > largest) largest = magnitude
			! end do
		! end do
		! average = average/(totaldim*totaldim)
		! if(mpi_rank == 0) then
			! write(6,'(A21)') "- - - - - - - - - - -"
			! write(6,'(A20)') "Eigensystem Residual"
			! write(6,'(A21)') "- - - - - - - - - - -"
			! write(6,'(A6,E13.4E2)') "Max = ",largest
			! write(6,'(A6,E13.4E2)') "Avg = ",average
			! write(6,'(A21)') "- - - - - - - - - - -"
		! end if
		! deallocate(dummyR,matrixI,vecsI,Identity,eigenvalues)
	! else if(problem_type == 2) then
		! write(6,'(A69)') "Eigen Test will not be performed for the Block Diagonal Approximation"
	! end if
	! end subroutine eigen_test
	
	subroutine calc_epr(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_linewidth,local_voigt,local_mosaic,local_strain_lamda,local_strain_orbred,local_strain_EXmat,local_strain_Jss,local_strain_dss,local_strain_Gfactor,local_strain_A2,local_strain_A4,local_strain_A6,local_CFP_rot,local_EX_rot)
	! Calculates an EPR spectrum for the system
	implicit none
	real(kind=8),allocatable::vecdir(:,:),dummyR(:,:),abs_spec(:,:,:)
	complex(kind=8),allocatable::static_imag(:,:)
	real(kind=8)::roof,lorentzian_coeff,gaussian_coeff(2),intensity,sort_intens(4)
	integer::numdir,num_threads,chunk,do_mosaic,num_strain,sort_trans(10,3),loc
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:),local_linewidth(:,:),local_voigt(:),local_mosaic(:),local_strain_lamda(:,:),local_strain_orbred(:),local_strain_EXmat(:,:,:,:),local_strain_Jss(:,:,:),local_strain_dss(:,:,:),local_strain_Gfactor(:,:),local_strain_A2(:,-2:),local_strain_A4(:,-4:),local_strain_A6(:,-6:),local_CFP_rot(:,:),local_EX_rot(:,:,:)
	real(kind=8),allocatable::temp_strain_lamda(:,:),temp_strain_orbred(:),temp_strain_EXmat(:,:,:,:),temp_strain_Gmat(:,:,:),temp_strain_A2(:,:),temp_strain_A4(:,:),temp_strain_A6(:,:),zeeman_data(:,:,:),first(:,:,:),second(:,:,:),trans_intens(:,:)
	integer,allocatable::trans_data(:,:,:)
	!---OMP---
	integer::g,c,d,t,fr,i,h,j,k,l,m
	real(kind=8)::local_B(3),vector(3),vector2(3),base,Zepr,linewidth_val,energy_temp,this_linewidth
	real(kind=8),allocatable::epr_vals(:)
	complex(kind=8),allocatable::epr_vecsI(:,:),ZeeX(:,:),ZeeY(:,:),ZeeZ(:,:),ZeeTheta(:,:),ZeePhi(:,:),Strain(:,:,:)
#ifdef mpi
	integer::g_start,g_finish
	real(kind=8),allocatable::loc_epr(:,:,:)
#endif
	if(return_all) then
		!write(6,*) "P"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*P"
	end if
	epr_calc = 0.0_8
	call ZCW(epr_intLevel,epr_intCover,epr_field_vec,numdir,vecdir)
	!call angle_grid(4,numdir,vecdir)
#ifdef mpi
	call set_mpi_limits(epr_numB,g_start,g_finish)
#endif
#ifdef gui
	if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') then
		call send_plot_data("eprCalD",numdir,0.0_8)
		allocate(zeeman_data(numdir,epr_numB,totaldim),trans_data(epr_numF,numdir,3),trans_intens(epr_numF,numdir))
		trans_data = 0
		trans_intens = 0.0_8
		do g = 1,numdir
			call send_plot_data("epr_dir",numdir,vecdir(g,1))
			call send_plot_data("epr_dir",numdir,vecdir(g,2))
			call send_plot_data("epr_dir",numdir,vecdir(g,3))
		end do
	end if
#endif
#ifdef omp
	num_threads = omp_get_num_procs()
	if(MaxCPU >= num_threads) then
		num_threads = omp_get_num_procs()
	else if(MaxCPU == 0)  then
		if(num_threads > 1) num_threads = omp_get_num_procs()-1
	else
		num_threads = MaxCPU
	end if
	if(epr_numB < num_threads) num_threads = epr_numB
#endif
	allocate(static_imag(totaldim,totaldim),dummyR(1,1),abs_spec(epr_numB,epr_numF,epr_numT),first(epr_numB,epr_numF,epr_numT),second(epr_numB,epr_numF,epr_numT))
	lorentzian_coeff = 2.0_8/pie
	gaussian_coeff(1) = 2.0_8*dsqrt(dlog(2.0_8)/pie)
	gaussian_coeff(2) = (1.0_8/(2.0_8*dsqrt(dlog(2.0_8))))**2.0_8
	abs_spec = 0.0_8
	first = 0.0_8
	second = 0.0_8
	do_mosaic = 0
	if(any(local_mosaic /= 0.0_8)) do_mosaic = 1
	num_strain = 0
	do i = 1,N
		do g = 1,6
			if(local_strain_lamda(i,g) /= 0.0_8) num_strain = num_strain + 1
		end do
		if(local_strain_orbred(i) /= 0.0_8) num_strain = num_strain + 1
		do c = 1,N
			if(epr_iso_ex_strain(i,c) == 1) then
				num_strain = num_strain + 1
			else
				if(use_interaction_matrix) then
					do g = 1,3
						do d = 1,3
							if(local_strain_EXmat(g,d,i,c) /= 0.0_8) num_strain = num_strain + 1
						end do
					end do
				else
					do g = 1,3
						if(local_strain_Jss(i,c,g) /= 0.0_8) num_strain = num_strain + 1
						if(local_strain_dss(i,c,g) /= 0.0_8) num_strain = num_strain + 1
					end do
				end if
			end if
		end do
		if(epr_iso_G_strain(i) == 1) then
			num_strain = num_strain + 1
		else
			do g = 1,3
				if(local_strain_Gfactor(g,i) /= 0.0_8) num_strain = num_strain + 1
			end do
		end if
		do g = -2,2
			if(local_strain_A2(i,g) /= 0.0_8) num_strain = num_strain + 1
		end do
		do g = -4,4
			if(local_strain_A4(i,g) /= 0.0_8) num_strain = num_strain + 1
		end do
		do g = -6,6
			if(local_strain_A6(i,g) /= 0.0_8) num_strain = num_strain + 1
		end do
	end do
	if(num_strain > 0) then
		allocate(temp_strain_lamda(N,6),temp_strain_orbred(N),temp_strain_EXmat(3,3,N,N),temp_strain_Gmat(3,3,N),temp_strain_A2(N,-2:2),temp_strain_A4(N,-4:4),temp_strain_A6(N,-6:6))
	end if
	chunk = ceiling(dble(epr_numB)/(10.0_8*dble(num_threads)))
	call matrix_elements('I','U',dummyR,static_imag,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)
#ifdef omp
	!$OMP PARALLEL IF(num_threads > 1 .and. epr_numB > 1) NUM_THREADS(num_threads) SHARED(local_strain_lamda,local_strain_orbred,local_strain_EXmat,local_strain_Jss,local_strain_dss,local_strain_Gfactor,local_strain_A2,local_strain_A4,local_strain_A6,local_CFP_rot,local_EX_rot,do_mosaic,local_mosaic,chunk,local_voigt,lorentzian_coeff,gaussian_coeff,num_threads,static_imag,dummyR,epr_numB,numdir,epr_fields,vecdir,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,totaldim,epr_parallel_mode,epr_numT,epr_temps,epr_numF,epr_freqs,local_linewidth,abs_spec,zeeman_data,trans_data,trans_intens) PRIVATE(epr_vecsI,ZeeX,ZeeY,ZeeZ,epr_vals,local_B,vector,vector2,base,Zepr,g,c,d,t,fr,linewidth_val,energy_temp,i,ZeeTheta,ZeePhi,this_linewidth,Strain,j,k,l,m,h,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,intensity)
#endif
	if(.not. allocated(epr_vals)) allocate(epr_vals(totaldim))
	if(.not. allocated(epr_vecsI)) allocate(epr_vecsI(totaldim,totaldim))
	if(.not. allocated(ZeeX)) allocate(ZeeX(totaldim,totaldim))
	if(.not. allocated(ZeeY)) allocate(ZeeY(totaldim,totaldim))
	if(.not. allocated(ZeeZ)) allocate(ZeeZ(totaldim,totaldim))
	if(do_mosaic == 1 .and. .not. allocated(ZeeTheta)) allocate(ZeeTheta(totaldim,totaldim))
	if(do_mosaic == 1 .and. .not. allocated(ZeePhi)) allocate(ZeePhi(totaldim,totaldim))
	if(num_strain > 0 .and. .not. allocated(Strain)) allocate(Strain(num_strain,totaldim,totaldim))
#ifdef omp
	!$OMP DO SCHEDULE(DYNAMIC,chunk)
#endif
#ifdef mpi
	if(g_start /= 0 .and.g_finish /= 0) then
		do i = g_start,g_finish
#else
	do i = 1,epr_numB
#endif
		do g = 1,numdir
#ifndef omp
			if(return_all) return
#endif
			if(.not. return_all) then
				local_B = 0.0_8
				local_B = epr_fields(i)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
				call matrix_elements('I','U',dummyR,epr_vecsI,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
				epr_vecsI = epr_vecsI + static_imag
				call diagonalize('I','V','U',totaldim,dummyR,epr_vecsI,epr_vals)
#ifdef gui
				if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') then
					zeeman_data(g,i,1:totaldim) = epr_vals(1:totaldim)
				end if
#endif
				if(.not. return_all) then
					if(epr_parallel_mode == 0) then
						vector = 0.0_8
						if(vecdir(g,3) /= 0.0_8) then
							vector(1) = 1.0_8
							vector(2) = 1.0_8
							vector(3) = (-vecdir(g,1)-vecdir(g,2))/vecdir(g,3)
							if(.not. return_all) vector = vector/radial(vector)
						else
							vector(3) = 1.0_8
						end if
						local_B = vector
						call matrix_elements('I','U',dummyR,zeeX,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
						call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,zeeX)
						vector2 = 0.0_8
						vector2(1) = vector(2)*vecdir(g,3) - vector(3)*vecdir(g,2)
						vector2(2) = vector(3)*vecdir(g,1) - vector(1)*vecdir(g,3)
						vector2(3) = vector(1)*vecdir(g,2) - vector(2)*vecdir(g,1)
						local_B = vector2
						call matrix_elements('I','U',dummyR,zeeY,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
						call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,zeeY)
					else if(epr_parallel_mode == 1) then
						local_B = 0.0_8
						local_B(1) = vecdir(g,1)
						local_B(2) = vecdir(g,2)
						local_B(3) = vecdir(g,3)
						call matrix_elements('I','U',dummyR,zeeZ,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
						call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,zeeZ)
					end if
					if(do_mosaic == 1) then
						local_B = 0.0_8
						local_B(1) = epr_fields(i)*vecdir(g,4)
						local_B(2) = epr_fields(i)*vecdir(g,5)
						local_B(3) = epr_fields(i)*vecdir(g,6)
						call matrix_elements('I','U',dummyR,ZeeTheta,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
						call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,ZeeTheta)
						local_B = 0.0_8
						local_B(1) = epr_fields(i)*vecdir(g,7)
						local_B(2) = epr_fields(i)*vecdir(g,8)
						local_B(3) = epr_fields(i)*vecdir(g,9)
						call matrix_elements('I','U',dummyR,ZeePhi,local_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.true.,.false.,.false.)
						call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,ZeePhi)
					end if
					if(num_strain > 0) then
						h = 0
						temp_strain_lamda = 0.0_8
						temp_strain_orbred = 1.0_8
						temp_strain_EXmat = 0.0_8
						temp_strain_Gmat = 0.0_8
						temp_strain_A2 = 0.0_8
						temp_strain_A4 = 0.0_8
						temp_strain_A6 = 0.0_8
						local_B = 0.0_8
						do t = 1,N
							do fr = 1,6
								if(local_strain_lamda(t,fr) /= 0.0_8) then
									h = h + 1
									temp_strain_lamda(t,fr) = 1.0_8
									call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.true.,.false.,.false.,.false.,.false.)
									call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
									temp_strain_lamda = 0.0_8
								end if
							end do
							do c = 1,N
								if(epr_iso_ex_strain(t,c) == 1) then
									if(local_strain_Jss(t,c,1) /= 0.0_8 .and. local_strain_Jss(t,c,2) /= 0.0_8 .and. local_strain_Jss(t,c,3) /= 0.0_8) then
										h = h + 1
										temp_strain_EXmat(1,1,t,c) = 1.0_8
										temp_strain_EXmat(2,2,t,c) = 1.0_8
										temp_strain_EXmat(3,3,t,c) = 1.0_8
										if(do_exrotate(t,c) == 1) call rotate_mat(local_EX_rot(t,c,1),local_EX_rot(t,c,2),local_EX_rot(t,c,3),temp_strain_EXmat(:,:,t,c))
										call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.true.,.false.,.false.,.false.)
										call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
										temp_strain_EXmat = 0.0_8
									end if
								else
									if(use_interaction_matrix) then
										do fr = 1,3
											do d = 1,3
												if(local_strain_EXmat(fr,d,t,c) /= 0.0_8) then
													h = h + 1
													temp_strain_EXmat(fr,d,t,c) = 1.0_8
													if(do_exrotate(t,c) == 1) call rotate_mat(local_EX_rot(t,c,1),local_EX_rot(t,c,2),local_EX_rot(t,c,3),temp_strain_EXmat(:,:,t,c))
													call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.true.,.false.,.false.,.false.)
													call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
													temp_strain_EXmat = 0.0_8
												end if
											end do
										end do
									else
										do fr = 1,3
											if(local_strain_Jss(t,c,fr) /= 0.0_8) then
												h = h + 1
												temp_strain_EXmat(fr,fr,t,c) = 1.0_8
												if(do_exrotate(t,c) == 1) call rotate_mat(local_EX_rot(t,c,1),local_EX_rot(t,c,2),local_EX_rot(t,c,3),temp_strain_EXmat(:,:,t,c))
												call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.true.,.false.,.false.,.false.)
												call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
												temp_strain_EXmat = 0.0_8
											end if
											if(local_strain_dss(t,c,fr) /= 0.0_8) then
												h = h + 1
												if(fr == 1) temp_strain_EXmat(2,3,t,c) = 1.0_8
												if(fr == 1) temp_strain_EXmat(3,2,t,c) = -1.0_8
												if(fr == 2) temp_strain_EXmat(1,3,t,c) = -1.0_8
												if(fr == 2) temp_strain_EXmat(3,1,t,c) = 1.0_8
												if(fr == 3) temp_strain_EXmat(1,2,t,c) = 1.0_8
												if(fr == 3) temp_strain_EXmat(2,1,t,c) = -1.0_8
												if(do_exrotate(t,c) == 1) call rotate_mat(local_EX_rot(t,c,1),local_EX_rot(t,c,2),local_EX_rot(t,c,3),temp_strain_EXmat(:,:,t,c))
												call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.true.,.false.,.false.,.false.)
												call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
												temp_strain_EXmat = 0.0_8
											end if
										end do
									end if
								end if
							end do
							if(epr_iso_G_strain(t) == 1) then
								if(local_strain_Gfactor(1,t) /= 0.0_8 .and. local_strain_Gfactor(2,t) /= 0.0_8 .and. local_strain_Gfactor(3,t) /= 0.0_8) then
									h = h + 1
									temp_strain_Gmat(1,1,t) = 1.0_8
									temp_strain_Gmat(2,2,t) = 1.0_8
									temp_strain_Gmat(3,3,t) = 1.0_8
									local_B = epr_fields(i)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
									if(do_rotate(t) == 1) call rotate_mat(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_Gmat(:,:,t))
									call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.true.,.false.,.false.)
									call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
									temp_strain_Gmat = 0.0_8
									local_B = 0.0_8
								end if
							else
								do d = 1,3
									if(local_strain_Gfactor(d,t) /= 0.0_8) then
										h = h + 1
										if(d == 1) temp_strain_Gmat(1,1,t) = 1.0_8
										if(d == 2) temp_strain_Gmat(2,2,t) = 1.0_8
										if(d == 3) temp_strain_Gmat(3,3,t) = 1.0_8
										local_B = epr_fields(i)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
										if(do_rotate(t) == 1) call rotate_mat(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_Gmat(:,:,t))
										call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.true.,.false.,.false.)
										call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
										temp_strain_Gmat = 0.0_8
										local_B = 0.0_8
									end if
								end do
							end if
							do fr = -2,2
								if(local_strain_A2(t,fr) /= 0.0_8) then
									h = h + 1
									temp_strain_A2(t,fr) = 1.0_8
									if(do_rotate(t) == 1) call rotate_CFP(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_A2(t,:),temp_strain_A4(t,:),temp_strain_A6(t,:))
									call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.false.,.true.,.false.)
									call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
									temp_strain_A2 = 0.0_8
								end if
							end do
							do fr = -4,4
								if(local_strain_A4(t,fr) /= 0.0_8) then
									h = h + 1
									temp_strain_A4(t,fr) = 1.0_8
									if(do_rotate(t) == 1) call rotate_CFP(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_A2(t,:),temp_strain_A4(t,:),temp_strain_A6(t,:))
									call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.false.,.true.,.false.)
									call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
									temp_strain_A4 = 0.0_8
								end if
							end do
							do fr = -6,6
								if(local_strain_A6(t,fr) /= 0.0_8) then
									h = h + 1
									temp_strain_A6(t,fr) = 1.0_8
									if(do_rotate(t) == 1) call rotate_CFP(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_A2(t,:),temp_strain_A4(t,:),temp_strain_A6(t,:))
									call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.false.,.true.,.false.)
									call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
									temp_strain_A6 = 0.0_8
								end if
							end do
							if(local_strain_orbred(t) /= 0.0_8) then
								h = h + 1
								local_B = epr_fields(i)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
								call matrix_elements('I','U',dummyR,Strain(h,:,:),local_B,local_lamda,local_orbred,temp_strain_EXmat,temp_strain_Gmat,local_A2,local_A4,local_A6,.false.,.false.,.false.,.false.,.true.)
								call expectation('I',totaldim,dummyR,epr_vecsI,dummyR,Strain(h,:,:))
								local_B = 0.0_8
							end if
						end do
					end if
					base = epr_vals(1)
					epr_vals = epr_vals-base
					do t = 1,epr_numT
						Zepr = 0.0_8
						do c = 1,totaldim
							Zepr = Zepr + dexp((-epr_vals(c))/(kB*epr_temps(t)))
						end do
						do fr = 1,epr_numF
							do c = 1,totaldim-1
								do d = c+1,totaldim
									energy_temp = (dabs(epr_vals(d)-epr_vals(c))-epr_freqs(fr))**2.0_8
									this_linewidth = local_linewidth(fr,1)*local_linewidth(fr,1)*vecdir(g,1)*vecdir(g,1) + local_linewidth(fr,2)*local_linewidth(fr,2)*vecdir(g,2)*vecdir(g,2) + local_linewidth(fr,3)*local_linewidth(fr,3)*vecdir(g,3)*vecdir(g,3)
									if(do_mosaic == 1) this_linewidth = this_linewidth + local_mosaic(fr)*local_mosaic(fr)*(dble(ZeeTheta(d,d)-ZeeTheta(c,c))*dble(ZeeTheta(d,d)-ZeeTheta(c,c)) + dble(ZeePhi(d,d)-ZeePhi(c,c))*dble(ZeePhi(d,d)-ZeePhi(c,c)))
									if(num_strain > 0) then
										h = 0
										do j = 1,N
											do k = 1,6
												if(local_strain_lamda(j,k) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_lamda(j,k)*local_strain_lamda(j,k)
												end if
											end do
											do l = 1,N
												if(epr_iso_ex_strain(j,l) == 1) then
													if(local_strain_Jss(j,l,1) /= 0.0_8 .and. local_strain_Jss(j,l,2) /= 0.0_8 .and. local_strain_Jss(j,l,3) /= 0.0_8) then
														h = h + 1
														this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_Jss(j,l,1)*local_strain_Jss(j,l,1)
													end if
												else
													if(done_inter > 0) then
														do k = 1,3
															do m = 1,3
																if(local_strain_EXmat(k,m,j,l) /= 0.0_8) then
																	h = h + 1
																	this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_EXmat(k,m,j,l)*local_strain_EXmat(k,m,j,l)
																end if
															end do
														end do
													else
														do k = 1,3
															if(local_strain_Jss(j,l,k) /= 0.0_8) then
																h = h + 1
																this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_Jss(j,l,k)*local_strain_Jss(j,l,k)
															end if
															if(local_strain_dss(j,l,k) /= 0.0_8) then
																h = h + 1
																this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_dss(j,l,k)*local_strain_dss(j,l,k)
															end if
														end do
													end if
												end if
											end do
											if(epr_iso_G_strain(j) == 1) then
												if(local_strain_Gfactor(1,j) /= 0.0_8 .and. local_strain_Gfactor(2,j) /= 0.0_8 .and. local_strain_Gfactor(3,j) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_Gfactor(1,j)*local_strain_Gfactor(1,j)
												end if
											else
												do m = 1,3
													if(local_strain_Gfactor(m,j) /= 0.0_8) then
														h = h + 1
														this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_Gfactor(m,j)*local_strain_Gfactor(m,j)
													end if
												end do
											end if
											do k = -2,2
												if(local_strain_A2(j,k) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_A2(j,k)*local_strain_A2(j,k)
												end if
											end do
											do k = -4,4
												if(local_strain_A4(j,k) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_A4(j,k)*local_strain_A4(j,k)
												end if
											end do
											do k = -6,6
												if(local_strain_A6(j,k) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_A6(j,k)*local_strain_A6(j,k)
												end if
											end do
											if(local_strain_orbred(j) /= 0.0_8) then
												h = h + 1
												this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_orbred(j)*local_strain_orbred(j)
											end if
										end do
									end if
									this_linewidth = dsqrt(this_linewidth)
									linewidth_val = local_voigt(fr)*((lorentzian_coeff/this_linewidth)*(1.0_8/(1.0_8+(energy_temp/(this_linewidth*this_linewidth*0.25_8))))) + (1.0_8-local_voigt(fr))*(gaussian_coeff(1)/this_linewidth)*dexp(-energy_temp/(this_linewidth*this_linewidth*gaussian_coeff(2)))
									if(epr_parallel_mode == 0) then
										intensity = (dble(ZeeX(d,c)*conjg(ZeeX(d,c)))+dble(ZeeY(d,c)*conjg(ZeeY(d,c))))*((dexp((-epr_vals(c))/(kB*epr_temps(t)))-dexp((-epr_vals(d))/(kB*epr_temps(t))))/Zepr)*linewidth_val*vecdir(g,10)
									else if(epr_parallel_mode == 1) then
										intensity = dble(ZeeZ(d,c)*conjg(ZeeZ(d,c)))*((dexp((-epr_vals(c))/(kB*epr_temps(t)))-dexp((-epr_vals(d))/(kB*epr_temps(t))))/Zepr)*linewidth_val*vecdir(g,10)
									end if
									abs_spec(i,fr,t) = abs_spec(i,fr,t) + intensity
#ifdef gui
									if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') then
										if(t == 1 .and. trans_intens(fr,g) <= intensity) then
											trans_intens(fr,g) = intensity
											trans_data(fr,g,1) = i
											trans_data(fr,g,2) = c
											trans_data(fr,g,3) = d
										end if
									end if
#endif
								end do
							end do
						end do
					end do
				end if
			end if
		end do
		if(i == epr_numB) then
			deallocate(epr_vals,epr_vecsI,ZeeX,ZeeY,ZeeZ)
			if(do_mosaic == 1) deallocate(ZeeTheta,ZeePhi)
		end if
#ifdef omp
		!$OMP CRITICAL
#endif
		global_percent = global_percent + 1
#ifdef omp
		!$OMP END CRITICAL
#endif
#ifdef gui
		if(mpi_rank == 0 .and. OperationMode(1:3) == 'sim') call send_progress(100*global_percent/global_total,ptr_to_C_code)
#endif
	end do
#ifdef mpi
	end if
	allocate(loc_epr(epr_numB,epr_numF,epr_numT))
	call MPI_ALLREDUCE(abs_spec,loc_epr,epr_numB*epr_numF*epr_numT,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,mpi_error1)
	abs_spec = loc_epr
	deallocate(loc_epr)
#endif
#ifdef omp
		!$OMP END DO
#endif
		if(allocated(epr_vals)) deallocate(epr_vals)
		if(allocated(epr_vecsI)) deallocate(epr_vecsI)
		if(allocated(ZeeX)) deallocate(ZeeX)
		if(allocated(ZeeY)) deallocate(ZeeY)
		if(allocated(ZeeZ)) deallocate(ZeeZ)
		if(do_mosaic == 1 .and. allocated(ZeeTheta)) deallocate(ZeeTheta)
		if(do_mosaic == 1 .and. allocated(ZeePhi)) deallocate(ZeePhi)
		if(num_strain > 0 .and. allocated(Strain)) deallocate(Strain)
#ifdef omp
		!$OMP END PARALLEL
#endif
	if(num_strain > 0) then
		deallocate(temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6)
	end if
	if(return_all) return
	do fr = 1,epr_numF
		do t = 1,epr_numT
			do i = 1,epr_numB
				if(i == 1) then
					first(i,fr,t) = (abs_spec(i+1,fr,t)-abs_spec(i,fr,t))/(epr_fields(i+1)-epr_fields(i))
					second(i,fr,t) = (abs_spec(i+2,fr,t)-2.0_8*abs_spec(i+1,fr,t)+abs_spec(i,fr,t))/((epr_fields(i+1)-epr_fields(i))**2.0_8)
					if(epr_type(fr) == -1) then
						epr_calc(fr,t,i) = 0.0_8
					else if(epr_type(fr) == 0) then
						epr_calc(fr,t,i) = abs_spec(i,fr,t)
					else if(epr_type(fr) == 1) then
						epr_calc(fr,t,i) = first(i,fr,t)
					else if(epr_type(fr) == 2) then
						epr_calc(fr,t,i) = second(i,fr,t)
					end if
				else if(i == epr_numB) then
					first(i,fr,t) = (abs_spec(i,fr,t)-abs_spec(i-1,fr,t))/(epr_fields(i)-epr_fields(i-1))
					second(i,fr,t) = (abs_spec(i-2,fr,t)-2.0_8*abs_spec(i-1,fr,t)+abs_spec(i,fr,t))/((epr_fields(i)-epr_fields(i-1))**2.0_8)
					if(epr_type(fr) == -1) then
						epr_calc(fr,t,i) = 0.5_8*(epr_fields(i)-epr_fields(i-1))*(abs_spec(i,fr,t)+abs_spec(i-1,fr,t)) + epr_calc(fr,t,i-1)
					else if(epr_type(fr) == 0) then
						epr_calc(fr,t,i) = abs_spec(i,fr,t)
					else if(epr_type(fr) == 1) then
						epr_calc(fr,t,i) = first(i,fr,t)
					else if(epr_type(fr) == 2) then
						epr_calc(fr,t,i) = second(i,fr,t)
					end if
				else
					first(i,fr,t) = 0.5_8*(abs_spec(i+1,fr,t)-abs_spec(i-1,fr,t))/(epr_fields(i+1)-epr_fields(i-1))
					second(i,fr,t) = (abs_spec(i+1,fr,t)-2.0_8*abs_spec(i,fr,t)+abs_spec(i-1,fr,t))/((epr_fields(i+1)-epr_fields(i))**2.0_8)
					if(epr_type(fr) == -1) then
						epr_calc(fr,t,i) = 0.5_8*(epr_fields(i)-epr_fields(i-1))*(abs_spec(i,fr,t)+abs_spec(i-1,fr,t)) + epr_calc(fr,t,i-1)
					else if(epr_type(fr) == 0) then
						epr_calc(fr,t,i) = abs_spec(i,fr,t)
					else if(epr_type(fr) == 1) then
						epr_calc(fr,t,i) = first(i,fr,t)
					else if(epr_type(fr) == 2) then
						epr_calc(fr,t,i) = second(i,fr,t)
					end if
				end if
			end do
		end do
		if(epr_type(fr) == 1 .or. epr_type(fr) == 2) then
			epr_calc(fr,:,1) = epr_calc(fr,:,2)
			epr_calc(fr,:,epr_numB) = epr_calc(fr,:,epr_numB-1)
		end if
		if(epr_normalise) then
			roof = dabs(maxval(epr_calc(fr,1,:)))
			base = dabs(minval(epr_calc(fr,1,:)))
			if(base > roof) roof = base
			if(roof /= 0.0_8) epr_calc(fr,:,:) = epr_calc(fr,:,:)/roof
		end if
		roof = dabs(maxval(abs_spec(:,fr,1)))
		if(roof /= 0.0_8) abs_spec(:,fr,:) = abs_spec(:,fr,:)/roof
	end do
#ifdef gui
	!ISMAEEL
	!if(epr_do_zeeman) then
	!	open(69,file=trim(WorkDir)//"/"//"save.zeeman",status="unknown")
	!		do i = 1,epr_numB
	!			do g = 1,numdir
	!				write(69,'(8E22.10E2)') epr_fields(i),dacos(vecdir(g,3)),datan2(vecdir(g,2),vecdir(g,1)),zeeman_data(g,i,6)/EnergyConvert,zeeman_data(g,i,7)/EnergyConvert,zeeman_data(g,i,8)/EnergyConvert,zeeman_data(g,i,11)/EnergyConvert,zeeman_data(g,i,12)/EnergyConvert
	!				!write(69,'(16E22.10E2)') epr_fields(i),dacos(vecdir(g,3)),datan2(vecdir(g,2),vecdir(g,1)),zeeman_data(g,epr_numB,:)/EnergyConvert
	!			end do
	!		end do
	!	close(69)
	!end if
	!ISMAEEL
	do i = 1,epr_numB
		call send_plot_data("epr_cal",epr_numB,epr_fields(i))
	end do
	if(return_all) return
	do fr = 1,epr_numF
		do t = 1,epr_numT
			do i = 1,epr_numB
				call send_plot_data("epr_cal",epr_numB,epr_calc(fr,t,i))
			end do
		end do
	end do
	if(return_all) return
	if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') then
		do g = 1,numdir
			do k = 1,totaldim
				do i = 1,epr_numB
					call send_plot_data("epr_zee",epr_numB,zeeman_data(g,i,k)/EnergyConvert)
				end do
			end do
		end do
		if(return_all) return
		do fr = 1,epr_numF
			do g = 1,numdir
				call send_plot_data("epr_tra",epr_numB,epr_fields(trans_data(fr,g,1)))
				call send_plot_data("epr_tra",epr_numB,zeeman_data(g,trans_data(fr,g,1),trans_data(fr,g,2))/EnergyConvert)
				call send_plot_data("epr_tra",epr_numB,zeeman_data(g,trans_data(fr,g,1),trans_data(fr,g,3))/EnergyConvert)
				call send_plot_data("epr_tra",epr_numB,trans_intens(fr,g))
			end do
		end do
	end if
	if(return_all) return
	call send_plot_signal("eprC",ptr_to_C_code)
	if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') deallocate(zeeman_data,trans_data,trans_intens)
#endif
	if(allocated(static_imag)) deallocate(static_imag)
	if(allocated(ZeeX)) deallocate(ZeeX)
	if(allocated(ZeeY)) deallocate(ZeeY)
	if(allocated(ZeeZ)) deallocate(ZeeZ)
	if(allocated(dummyR)) deallocate(dummyR)
	if(allocated(abs_spec)) deallocate(abs_spec)
	if(allocated(first)) deallocate(first)
	if(allocated(second)) deallocate(second)
	if(allocated(epr_vecsI)) deallocate(epr_vecsI)
	if(allocated(epr_vals)) deallocate(epr_vals)
	if(allocated(ZeeTheta)) deallocate(ZeeTheta)
	if(allocated(ZeePhi)) deallocate(ZeePhi)
	end subroutine calc_epr
	
	subroutine pert_prep(local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,local_eigvecs,local_eigvals)
	! Pre-calculates the eigenvectors for pert_epr
	implicit none
	real(kind=8),intent(in)::local_lamda(:,:),local_orbred(:),local_EXmat(:,:,:,:),local_Gmat(:,:,:),local_A2(:,:),local_A4(:,:),local_A6(:,:)
	real(kind=8)::dummyR(1,1),zero_B(3)
	complex(kind=8),allocatable,intent(out)::local_eigvecs(:,:)
	real(kind=8),allocatable,intent(out)::local_eigvals(:)
	if(return_all) then
		!write(6,*) "Q"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*Q"
	end if
	allocate(local_eigvecs(totaldim,totaldim),local_eigvals(totaldim))
	call matrix_elements('I','U',dummyR,local_eigvecs,zero_B,local_lamda,local_orbred,local_EXmat,local_Gmat,local_A2,local_A4,local_A6,.true.,.true.,.false.,.true.,.false.)	!SOC,EX,MAG,CF
	call diagonalize('I','V','U',totaldim,dummyR,local_eigvecs,local_eigvals)
	end subroutine pert_prep
	
	subroutine pert_epr(subdim,local_eigenvecs,local_eigenvals,local_orbred,local_EXmat,local_Gmat,local_linewidth,local_voigt,local_mosaic,local_strain_lamda,local_strain_orbred,local_strain_EXmat,local_strain_Jss,local_strain_dss,local_strain_Gfactor,local_strain_A2,local_strain_A4,local_strain_A6,local_CFP_rot,local_EX_rot)
	! Calculates an EPR spectrum for the system based on infinite order perturbation theory within a subspace
	implicit none
	real(kind=8),allocatable::vecdir(:,:),dummyR(:,:),dummyvecR(:),abs_spec(:,:,:),first(:,:,:),second(:,:,:),zero_lamda(:,:),zero_A2(:,:),zero_A4(:,:),zero_A6(:,:),zeeman_data(:,:,:),trans_intens(:,:),temp_strain_lamda(:,:),temp_strain_orbred(:),temp_strain_EXmat(:,:,:,:),temp_strain_Gmat(:,:,:),temp_strain_A2(:,:),temp_strain_A4(:,:),temp_strain_A6(:,:)
	complex(kind=8),intent(in)::local_eigenvecs(:,:)
	real(kind=8)::roof,lorentzian_coeff,gaussian_coeff(2),intensity
	integer::numdir,num_threads,chunk,do_mosaic
	integer,intent(in)::subdim
	integer,allocatable::trans_data(:,:,:)
	real(kind=8),intent(in)::local_EXmat(:,:,:,:),local_linewidth(:,:),local_eigenvals(:),local_voigt(:),local_Gmat(:,:,:),local_orbred(:),local_mosaic(:),local_strain_lamda(:,:),local_strain_orbred(:),local_strain_EXmat(:,:,:,:),local_strain_Jss(:,:,:),local_strain_dss(:,:,:),local_strain_Gfactor(:,:),local_strain_A2(:,-2:),local_strain_A4(:,-4:),local_strain_A6(:,-6:),local_CFP_rot(:,:),local_EX_rot(:,:,:)
	!---OMP---
	integer::g,c,d,t,fr,i,k,h,num_strain,dd,j,l,m
	real(kind=8)::local_B(3),vector(3),vector2(3),base,Zepr,linewidth_val,energy_temp,this_linewidth
	real(kind=8),allocatable::epr_vals(:)
	complex(kind=8),allocatable::epr_vecsI(:,:),ZeeX(:,:),ZeeY(:,:),ZeeZ(:,:),full_mat(:,:),small_vecs(:,:),ZeeTheta(:,:),ZeePhi(:,:),Strain(:,:,:)
#ifdef mpi
	integer::g_start,g_finish
	real(kind=8),allocatable::loc_epr(:,:,:)
#endif
	if(return_all) then
		!write(6,*) "R"
		return
	else
		!if(mpi_rank == 0) write(6,*) "*R"
	end if
	if(subdim > totaldim) then
		call output_text("Subspace dimension must be less than the total dimension",.false.)
		call control('kill ')
		return
	else if(subdim < 2) then
		call output_text("Subspace dimension must be at least 2",.false.)
		call control('kill ')
		return
	end if
	epr_calc = 0.0_8
	call ZCW(epr_intLevel,epr_intCover,epr_field_vec,numdir,vecdir)
#ifdef mpi
	call set_mpi_limits(epr_numB,g_start,g_finish)
#endif
#ifdef gui
	if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') then
		call send_plot_data("eprCalD",numdir,0.0_8)
		allocate(zeeman_data(numdir,epr_numB,subdim),trans_data(epr_numF,numdir,3),trans_intens(epr_numF,numdir))
		trans_data = 0
		trans_intens = 0.0_8
		do g = 1,numdir
			call send_plot_data("epr_dir",numdir,vecdir(g,1))
			call send_plot_data("epr_dir",numdir,vecdir(g,2))
			call send_plot_data("epr_dir",numdir,vecdir(g,3))
		end do
	end if
#endif
#ifdef omp
	num_threads = omp_get_num_procs()
	if(MaxCPU >= num_threads) then
		num_threads = omp_get_num_procs()
	else if(MaxCPU == 0)  then
		if(num_threads > 1) num_threads = omp_get_num_procs()-1
	else
		num_threads = MaxCPU
	end if
	if(epr_numB < num_threads) num_threads = epr_numB
#endif
	allocate(dummyR(1,1),dummyvecR(1),abs_spec(epr_numB,epr_numF,epr_numT),first(epr_numB,epr_numF,epr_numT),second(epr_numB,epr_numF,epr_numT))
	lorentzian_coeff = 2.0_8/pie
	gaussian_coeff(1) = 2.0_8*dsqrt(dlog(2.0_8)/pie)
	gaussian_coeff(2) = (1.0_8/(2.0_8*dsqrt(dlog(2.0_8))))**2.0_8
	abs_spec = 0.0_8
	do_mosaic = 0
	if(any(local_mosaic /= 0.0_8)) do_mosaic = 1
	num_strain = 0
	do i = 1,N
		do g = 1,6
			if(local_strain_lamda(i,g) /= 0.0_8) num_strain = num_strain + 1
		end do
		if(local_strain_orbred(i) /= 0.0_8) num_strain = num_strain + 1
		do c = 1,N
			if(epr_iso_ex_strain(i,c) == 1) then
				num_strain = num_strain + 1
			else
				if(use_interaction_matrix) then
					do g = 1,3
						do d = 1,3
							if(local_strain_EXmat(g,d,i,c) /= 0.0_8) num_strain = num_strain + 1
						end do
					end do
				else
					do g = 1,3
						if(local_strain_Jss(i,c,g) /= 0.0_8) num_strain = num_strain + 1
						if(local_strain_dss(i,c,g) /= 0.0_8) num_strain = num_strain + 1
					end do
				end if
			end if
		end do
		if(epr_iso_G_strain(i) == 1) then
			num_strain = num_strain + 1
		else
			do g = 1,3
				if(local_strain_Gfactor(g,i) /= 0.0_8) num_strain = num_strain + 1
			end do
		end if
		do g = -2,2
			if(local_strain_A2(i,g) /= 0.0_8) num_strain = num_strain + 1
		end do
		do g = -4,4
			if(local_strain_A4(i,g) /= 0.0_8) num_strain = num_strain + 1
		end do
		do g = -6,6
			if(local_strain_A6(i,g) /= 0.0_8) num_strain = num_strain + 1
		end do
	end do
	chunk = ceiling(dble(epr_numB)/(10.0_8*dble(num_threads)))
#ifdef omp
	!$OMP PARALLEL IF(num_threads > 1 .and. epr_numB > 1) NUM_THREADS(num_threads) SHARED(local_strain_lamda,local_strain_orbred,local_strain_EXmat,local_strain_Jss,local_strain_dss,local_strain_Gfactor,local_strain_A2,local_strain_A4,local_strain_A6,local_CFP_rot,local_EX_rot,do_mosaic,local_mosaic,chunk,subdim,dummyvecR,local_eigenvecs,local_eigenvals,lorentzian_coeff,gaussian_coeff,local_voigt,num_threads,dummyR,epr_numB,numdir,epr_fields,vecdir,zero_lamda,local_orbred,local_EXmat,local_Gmat,zero_A2,zero_A4,zero_A6,totaldim,epr_parallel_mode,epr_numT,epr_temps,epr_numF,epr_freqs,local_linewidth,abs_spec,num_strain) PRIVATE(epr_vecsI,ZeeX,ZeeY,ZeeZ,epr_vals,local_B,vector,vector2,base,Zepr,g,c,d,t,fr,h,dd,j,k,l,m,linewidth_val,energy_temp,full_mat,small_vecs,i,ZeeTheta,ZeePhi,Strain,this_linewidth,intensity,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6)
#endif
	if(.not. allocated(epr_vals)) allocate(epr_vals(subdim))
	if(.not. allocated(epr_vecsI)) allocate(epr_vecsI(subdim,subdim))
	if(.not. allocated(ZeeX)) allocate(ZeeX(subdim,subdim))
	if(.not. allocated(ZeeY)) allocate(ZeeY(subdim,subdim))
	if(.not. allocated(ZeeZ)) allocate(ZeeZ(subdim,subdim))
	if(do_mosaic == 1 .and. .not. allocated(ZeeTheta)) allocate(ZeeTheta(subdim,subdim))
	if(do_mosaic == 1 .and. .not. allocated(ZeePhi)) allocate(ZeePhi(subdim,subdim))
	if(num_strain > 0 .and. .not. allocated(Strain)) allocate(Strain(num_strain,subdim,subdim))
	if(.not. allocated(full_mat)) allocate(full_mat(totaldim,totaldim))
	if(.not. allocated(small_vecs)) allocate(small_vecs(totaldim,subdim))
	if(num_strain > 0) then
		allocate(temp_strain_lamda(N,6),temp_strain_orbred(N),temp_strain_EXmat(3,3,N,N),temp_strain_Gmat(3,3,N),temp_strain_A2(N,-2:2),temp_strain_A4(N,-4:4),temp_strain_A6(N,-6:6))
	end if
#ifdef omp
	!$OMP DO SCHEDULE(DYNAMIC,chunk)
#endif
#ifdef mpi
	if(g_start /= 0 .and.g_finish /= 0) then
		do i = g_start,g_finish
#else
	do i = 1,epr_numB
#endif
		do g = 1,numdir
#ifndef omp
			if(return_all) return
#endif
			if(.not. return_all) then
				local_B = 0.0_8
				local_B = epr_fields(i)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
				call matrix_elements('I','U',dummyR,full_mat,local_B,zero_lamda,local_orbred,local_EXmat,local_Gmat,zero_A2,zero_A4,zero_A6,.false.,.false.,.true.,.false.,.false.)
				do c = 1,subdim
					do d = 1,subdim
						call vector_expectation('I',totaldim,dummyvecR,local_eigenvecs(:,c),dummyR,full_mat,dummyvecR,local_eigenvecs(:,d),dummyvecR(1),epr_vecsI(c,d))
						if(c == d) epr_vecsI(c,d) = epr_vecsI(c,d) + dcmplx(local_eigenvals(c),0.0_8)
					end do
				end do
				call diagonalize('I','V','U',subdim,dummyR,epr_vecsI,epr_vals)
#ifdef gui
				if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') zeeman_data(g,i,1:subdim) = epr_vals(1:subdim)
#endif
				small_vecs = (0.0_8,0.0_8)
				do c = 1,subdim
					do d = 1,subdim
						small_vecs(:,c) = small_vecs(:,c) + epr_vecsI(d,c)*local_eigenvecs(:,d)
					end do
				end do
				if(.not. return_all) then
					if(epr_parallel_mode == 0) then
						vector = 0.0_8
						if(vecdir(g,3) /= 0.0_8) then
							vector(1) = 1.0_8
							vector(2) = 1.0_8
							vector(3) = (-vecdir(g,1)-vecdir(g,2))/vecdir(g,3)
							if(.not. return_all) vector = vector/radial(vector)
						else
							vector(3) = 1.0_8
						end if
						local_B = vector
						call matrix_elements('I','U',dummyR,full_mat,local_B,zero_lamda,local_orbred,local_EXmat,local_Gmat,zero_A2,zero_A4,zero_A6,.false.,.false.,.true.,.false.,.false.)
						do c = 1,subdim-1
							do d = c+1,subdim
								call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,d),dummyR,full_mat,dummyvecR,small_vecs(:,c),dummyvecR(1),ZeeX(d,c))
							end do
						end do
						vector2 = 0.0_8
						vector2(1) = vector(2)*vecdir(g,3) - vector(3)*vecdir(g,2)
						vector2(2) = vector(3)*vecdir(g,1) - vector(1)*vecdir(g,3)
						vector2(3) = vector(1)*vecdir(g,2) - vector(2)*vecdir(g,1)
						local_B = vector2
						call matrix_elements('I','U',dummyR,full_mat,local_B,zero_lamda,local_orbred,local_EXmat,local_Gmat,zero_A2,zero_A4,zero_A6,.false.,.false.,.true.,.false.,.false.)
						do c = 1,subdim-1
							do d = c+1,subdim
								call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,d),dummyR,full_mat,dummyvecR,small_vecs(:,c),dummyvecR(1),ZeeY(d,c))
							end do
						end do
					else if(epr_parallel_mode == 1) then
						local_B = 0.0_8
						local_B(1) = vecdir(g,1)
						local_B(2) = vecdir(g,2)
						local_B(3) = vecdir(g,3)
						call matrix_elements('I','U',dummyR,full_mat,local_B,zero_lamda,local_orbred,local_EXmat,local_Gmat,zero_A2,zero_A4,zero_A6,.false.,.false.,.true.,.false.,.false.)
						do c = 1,subdim-1
							do d = c+1,subdim
								call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,d),dummyR,full_mat,dummyvecR,small_vecs(:,c),dummyvecR(1),ZeeZ(d,c))
							end do
						end do
					end if
					if(do_mosaic == 1) then
						local_B = 0.0_8
						local_B(1) = epr_fields(i)*vecdir(g,4)
						local_B(2) = epr_fields(i)*vecdir(g,5)
						local_B(3) = epr_fields(i)*vecdir(g,6)
						call matrix_elements('I','U',dummyR,full_mat,local_B,zero_lamda,local_orbred,local_EXmat,local_Gmat,zero_A2,zero_A4,zero_A6,.false.,.false.,.true.,.false.,.false.)
						do c = 1,subdim
							call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,c),dummyR,full_mat,dummyvecR,small_vecs(:,c),dummyvecR(1),ZeeTheta(c,c))
						end do
						local_B = 0.0_8
						local_B(1) = epr_fields(i)*vecdir(g,7)
						local_B(2) = epr_fields(i)*vecdir(g,8)
						local_B(3) = epr_fields(i)*vecdir(g,9)
						call matrix_elements('I','U',dummyR,full_mat,local_B,zero_lamda,local_orbred,local_EXmat,local_Gmat,zero_A2,zero_A4,zero_A6,.false.,.false.,.true.,.false.,.false.)
						do c = 1,subdim
							call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,c),dummyR,full_mat,dummyvecR,small_vecs(:,c),dummyvecR(1),ZeePhi(c,c))
						end do
					end if
					if(num_strain > 0) then
						h = 0
						temp_strain_lamda = 0.0_8
						temp_strain_orbred = 1.0_8
						temp_strain_EXmat = 0.0_8
						temp_strain_Gmat = 0.0_8
						temp_strain_A2 = 0.0_8
						temp_strain_A4 = 0.0_8
						temp_strain_A6 = 0.0_8
						local_B = 0.0_8
						do t = 1,N
							do fr = 1,6
								if(local_strain_lamda(t,fr) /= 0.0_8) then
									h = h + 1
									temp_strain_lamda(t,fr) = 1.0_8
									call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.true.,.false.,.false.,.false.,.false.)
									do dd = 1,subdim
										call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
									end do
									temp_strain_lamda = 0.0_8
								end if
							end do
							do c = 1,N
								if(epr_iso_ex_strain(t,c) == 1) then
									if(local_strain_Jss(t,c,1) /= 0.0_8 .and. local_strain_Jss(t,c,2) /= 0.0_8 .and. local_strain_Jss(t,c,3) /= 0.0_8) then
										h = h + 1
										temp_strain_EXmat(1,1,t,c) = 1.0_8
										temp_strain_EXmat(2,2,t,c) = 1.0_8
										temp_strain_EXmat(3,3,t,c) = 1.0_8
										if(do_exrotate(t,c) == 1) call rotate_mat(local_EX_rot(t,c,1),local_EX_rot(t,c,2),local_EX_rot(t,c,3),temp_strain_EXmat(:,:,t,c))
										call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.true.,.false.,.false.,.false.)
										do dd = 1,subdim
											call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
										end do
										temp_strain_EXmat = 0.0_8
									end if
								else
									if(use_interaction_matrix) then
										do fr = 1,3
											do d = 1,3
												if(local_strain_EXmat(fr,d,t,c) /= 0.0_8) then
													h = h + 1
													temp_strain_EXmat(fr,d,t,c) = 1.0_8
													if(do_exrotate(t,c) == 1) call rotate_mat(local_EX_rot(t,c,1),local_EX_rot(t,c,2),local_EX_rot(t,c,3),temp_strain_EXmat(:,:,t,c))
													call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.true.,.false.,.false.,.false.)
													do dd = 1,subdim
														call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
													end do
													temp_strain_EXmat = 0.0_8
												end if
											end do
										end do
									else
										do fr = 1,3
											if(local_strain_Jss(t,c,fr) /= 0.0_8) then
												h = h + 1
												temp_strain_EXmat(fr,fr,t,c) = 1.0_8
												if(do_exrotate(t,c) == 1) call rotate_mat(local_EX_rot(t,c,1),local_EX_rot(t,c,2),local_EX_rot(t,c,3),temp_strain_EXmat(:,:,t,c))
												call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.true.,.false.,.false.,.false.)
												do dd = 1,subdim
													call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
												end do
												temp_strain_EXmat = 0.0_8
											end if
											if(local_strain_dss(t,c,fr) /= 0.0_8) then
												h = h + 1
												if(fr == 1) temp_strain_EXmat(2,3,t,c) = 1.0_8
												if(fr == 1) temp_strain_EXmat(3,2,t,c) = -1.0_8
												if(fr == 2) temp_strain_EXmat(1,3,t,c) = -1.0_8
												if(fr == 2) temp_strain_EXmat(3,1,t,c) = 1.0_8
												if(fr == 3) temp_strain_EXmat(1,2,t,c) = 1.0_8
												if(fr == 3) temp_strain_EXmat(2,1,t,c) = -1.0_8
												if(do_exrotate(t,c) == 1) call rotate_mat(local_EX_rot(t,c,1),local_EX_rot(t,c,2),local_EX_rot(t,c,3),temp_strain_EXmat(:,:,t,c))
												call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.true.,.false.,.false.,.false.)
												do dd = 1,subdim
													call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
												end do
												temp_strain_EXmat = 0.0_8
											end if
										end do
									end if
								end if
							end do
							if(epr_iso_G_strain(t) == 1) then
								if(local_strain_Gfactor(1,t) /= 0.0_8 .and. local_strain_Gfactor(2,t) /= 0.0_8 .and. local_strain_Gfactor(3,t) /= 0.0_8) then
									h = h + 1
									temp_strain_Gmat(1,1,t) = 1.0_8
									temp_strain_Gmat(2,2,t) = 1.0_8
									temp_strain_Gmat(3,3,t) = 1.0_8
									local_B = epr_fields(i)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
									if(do_rotate(t) == 1) call rotate_mat(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_Gmat(:,:,t))
									call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.true.,.false.,.false.)
									do dd = 1,subdim
										call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
									end do
									temp_strain_Gmat = 0.0_8
									local_B = 0.0_8
								end if
							else
								do d = 1,3
									if(local_strain_Gfactor(d,t) /= 0.0_8) then
										h = h + 1
										if(d == 1) temp_strain_Gmat(1,1,t) = 1.0_8
										if(d == 2) temp_strain_Gmat(2,2,t) = 1.0_8
										if(d == 3) temp_strain_Gmat(3,3,t) = 1.0_8
										local_B = epr_fields(i)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
										if(do_rotate(t) == 1) call rotate_mat(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_Gmat(:,:,t))
										call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.true.,.false.,.false.)
										do dd = 1,subdim
											call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
										end do
										temp_strain_Gmat = 0.0_8
										local_B = 0.0_8
									end if
								end do
							end if
							do fr = -2,2
								if(local_strain_A2(t,fr) /= 0.0_8) then
									h = h + 1
									temp_strain_A2(t,fr) = 1.0_8
									if(do_rotate(t) == 1) call rotate_CFP(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_A2(t,:),temp_strain_A4(t,:),temp_strain_A6(t,:))
									call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.false.,.true.,.false.)
									do dd = 1,subdim
										call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
									end do
									temp_strain_A2 = 0.0_8
								end if
							end do
							do fr = -4,4
								if(local_strain_A4(t,fr) /= 0.0_8) then
									h = h + 1
									temp_strain_A4(t,fr) = 1.0_8
									if(do_rotate(t) == 1) call rotate_CFP(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_A2(t,:),temp_strain_A4(t,:),temp_strain_A6(t,:))
									call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.true.,.false.,.false.,.true.,.false.)
									do dd = 1,subdim
										call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
									end do
									temp_strain_A4 = 0.0_8
								end if
							end do
							do fr = -6,6
								if(local_strain_A6(t,fr) /= 0.0_8) then
									h = h + 1
									temp_strain_A6(t,fr) = 1.0_8
									if(do_rotate(t) == 1) call rotate_CFP(local_CFP_rot(t,1),local_CFP_rot(t,2),local_CFP_rot(t,3),temp_strain_A2(t,:),temp_strain_A4(t,:),temp_strain_A6(t,:))
									call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.true.,.false.,.false.,.true.,.false.)
									do dd = 1,subdim
										call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
									end do
									temp_strain_A6 = 0.0_8
								end if
							end do
							if(local_strain_orbred(t) /= 0.0_8) then
								h = h + 1
								local_B = epr_fields(i)*vecdir(g,1:3) + static_field_magnitude*static_field_direction
								call matrix_elements('I','U',dummyR,full_mat,local_B,temp_strain_lamda,local_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6,.false.,.false.,.false.,.false.,.true.)
								do dd = 1,subdim
									call vector_expectation('I',totaldim,dummyvecR,small_vecs(:,dd),dummyR,full_mat,dummyvecR,small_vecs(:,dd),dummyvecR(1),Strain(h,dd,dd))
								end do
								local_B = 0.0_8
							end if
						end do
					end if
					base = epr_vals(1)
					epr_vals = epr_vals-base
					do t = 1,epr_numT
						Zepr = 0.0_8
						do c = 1,subdim
							Zepr = Zepr + dexp((-epr_vals(c))/(kB*epr_temps(t)))
						end do
						do fr = 1,epr_numF
							do c = 1,subdim-1
								do d = c+1,subdim
									energy_temp = (dabs(epr_vals(d)-epr_vals(c))-epr_freqs(fr))**2.0_8
									this_linewidth = local_linewidth(fr,1)*local_linewidth(fr,1)*vecdir(g,1)*vecdir(g,1) + local_linewidth(fr,2)*local_linewidth(fr,2)*vecdir(g,2)*vecdir(g,2) + local_linewidth(fr,3)*local_linewidth(fr,3)*vecdir(g,3)*vecdir(g,3)
									if(do_mosaic == 1) this_linewidth = this_linewidth + local_mosaic(fr)*local_mosaic(fr)*(dble(ZeeTheta(d,d)-ZeeTheta(c,c))*dble(ZeeTheta(d,d)-ZeeTheta(c,c)) + dble(ZeePhi(d,d)-ZeePhi(c,c))*dble(ZeePhi(d,d)-ZeePhi(c,c)))
									if(num_strain > 0) then
										h = 0
										do j = 1,N
											do k = 1,6
												if(local_strain_lamda(j,k) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_lamda(j,k)*local_strain_lamda(j,k)
												end if
											end do
											do l = 1,N
												if(epr_iso_ex_strain(j,l) == 1) then
													if(local_strain_Jss(j,l,1) /= 0.0_8 .and. local_strain_Jss(j,l,2) /= 0.0_8 .and. local_strain_Jss(j,l,3) /= 0.0_8) then
														h = h + 1
														this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_Jss(j,l,1)*local_strain_Jss(j,l,1)
													end if
												else
													if(done_inter > 0) then
														do k = 1,3
															do m = 1,3
																if(local_strain_EXmat(k,m,j,l) /= 0.0_8) then
																	h = h + 1
																	this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_EXmat(k,m,j,l)*local_strain_EXmat(k,m,j,l)
																end if
															end do
														end do
													else
														do k = 1,3
															if(local_strain_Jss(j,l,k) /= 0.0_8) then
																h = h + 1
																this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_Jss(j,l,k)*local_strain_Jss(j,l,k)
															end if
															if(local_strain_dss(j,l,k) /= 0.0_8) then
																h = h + 1
																this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_dss(j,l,k)*local_strain_dss(j,l,k)
															end if
														end do
													end if
												end if
											end do
											if(epr_iso_G_strain(j) == 1) then
												if(local_strain_Gfactor(1,j) /= 0.0_8 .and. local_strain_Gfactor(2,j) /= 0.0_8 .and. local_strain_Gfactor(3,j) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_Gfactor(1,j)*local_strain_Gfactor(1,j)
												end if
											else
												do m = 1,3
													if(local_strain_Gfactor(m,j) /= 0.0_8) then
														h = h + 1
														this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_Gfactor(m,j)*local_strain_Gfactor(m,j)
													end if
												end do
											end if
											do k = -2,2
												if(local_strain_A2(j,k) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_A2(j,k)*local_strain_A2(j,k)
												end if
											end do
											do k = -4,4
												if(local_strain_A4(j,k) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_A4(j,k)*local_strain_A4(j,k)
												end if
											end do
											do k = -6,6
												if(local_strain_A6(j,k) /= 0.0_8) then
													h = h + 1
													this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_A6(j,k)*local_strain_A6(j,k)
												end if
											end do
											if(local_strain_orbred(j) /= 0.0_8) then
												h = h + 1
												this_linewidth = this_linewidth + (dble(Strain(h,d,d)-Strain(h,c,c))**2.0_8)*local_strain_orbred(j)*local_strain_orbred(j)
											end if
										end do
									end if
									this_linewidth = dsqrt(this_linewidth)
									linewidth_val = local_voigt(fr)*((lorentzian_coeff/this_linewidth)*(1.0_8/(1.0_8+(energy_temp/(this_linewidth*this_linewidth*0.25_8))))) + (1.0_8-local_voigt(fr))*(gaussian_coeff(1)/this_linewidth)*dexp(-energy_temp/(this_linewidth*this_linewidth*gaussian_coeff(2)))
									if(epr_parallel_mode == 0) then
										intensity = (dble(ZeeX(d,c)*conjg(ZeeX(d,c)))+dble(ZeeY(d,c)*conjg(ZeeY(d,c))))*((dexp((-epr_vals(c))/(kB*epr_temps(t)))-dexp((-epr_vals(d))/(kB*epr_temps(t))))/Zepr)*linewidth_val*vecdir(g,10)
									else if(epr_parallel_mode == 1) then
										intensity = dble(ZeeZ(d,c)*conjg(ZeeZ(d,c)))*((dexp((-epr_vals(c))/(kB*epr_temps(t)))-dexp((-epr_vals(d))/(kB*epr_temps(t))))/Zepr)*linewidth_val*vecdir(g,10)
									end if
									abs_spec(i,fr,t) = abs_spec(i,fr,t) + intensity
#ifdef gui
									if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') then
										if(t == 1 .and. trans_intens(fr,g) <= intensity) then
											trans_intens(fr,g) = intensity
											trans_data(fr,g,1) = i
											trans_data(fr,g,2) = c
											trans_data(fr,g,3) = d
										end if
									end if
#endif
								end do
							end do
						end do
					end do
				end if
			end if
		end do
		if(i == epr_numB) then
			deallocate(epr_vals,epr_vecsI,ZeeX,ZeeY,ZeeZ,full_mat,small_vecs)
			if(do_mosaic == 1) deallocate(ZeeTheta,ZeePhi)
		end if
#ifdef omp
		!$OMP CRITICAL
#endif
		global_percent = global_percent + 1
#ifdef omp
		!$OMP END CRITICAL
#endif
#ifdef gui
		if(mpi_rank == 0 .and. OperationMode(1:3) == 'sim') call send_progress(100*global_percent/global_total,ptr_to_C_code)
#endif
	end do
#ifdef mpi
	end if
	allocate(loc_epr(epr_numB,epr_numF,epr_numT))
	call MPI_ALLREDUCE(abs_spec,loc_epr,epr_numB*epr_numF*epr_numT,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,mpi_error1)
	abs_spec = loc_epr
	deallocate(loc_epr)
#endif
#ifdef omp
		!$OMP END DO
#endif
	if(num_strain > 0) then
		deallocate(temp_strain_lamda,temp_strain_orbred,temp_strain_EXmat,temp_strain_Gmat,temp_strain_A2,temp_strain_A4,temp_strain_A6)
	end if
	if(allocated(epr_vals)) deallocate(epr_vals)
	if(allocated(epr_vecsI)) deallocate(epr_vecsI)
	if(allocated(ZeeX)) deallocate(ZeeX)
	if(allocated(ZeeY)) deallocate(ZeeY)
	if(allocated(ZeeZ)) deallocate(ZeeZ)
	if(do_mosaic == 1 .and. allocated(ZeeTheta)) deallocate(ZeeTheta)
	if(do_mosaic == 1 .and. allocated(ZeePhi)) deallocate(ZeePhi)
	if(num_strain > 0 .and. allocated(Strain)) deallocate(Strain)
	if(allocated(full_mat)) deallocate(full_mat)
	if(allocated(small_vecs)) deallocate(small_vecs)
#ifdef omp
		!$OMP END PARALLEL
#endif
	write(6,*)
	if(return_all) return
	do fr = 1,epr_numF
		do t = 1,epr_numT
			do i = 1,epr_numB
				if(i == 1) then
					first(i,fr,t) = (abs_spec(i+1,fr,t)-abs_spec(i,fr,t))/(epr_fields(i+1)-epr_fields(i))
					second(i,fr,t) = (abs_spec(i+2,fr,t)-2.0_8*abs_spec(i+1,fr,t)+abs_spec(i,fr,t))/((epr_fields(i+1)-epr_fields(i))**2.0_8)
					if(epr_type(fr) == -1) then
						epr_calc(fr,t,i) = 0.0_8
					else if(epr_type(fr) == 0) then
						epr_calc(fr,t,i) = abs_spec(i,fr,t)
					else if(epr_type(fr) == 1) then
						epr_calc(fr,t,i) = first(i,fr,t)
					else if(epr_type(fr) == 2) then
						epr_calc(fr,t,i) = second(i,fr,t)
					end if
				else if(i == epr_numB) then
					first(i,fr,t) = (abs_spec(i,fr,t)-abs_spec(i-1,fr,t))/(epr_fields(i)-epr_fields(i-1))
					second(i,fr,t) = (abs_spec(i-2,fr,t)-2.0_8*abs_spec(i-1,fr,t)+abs_spec(i,fr,t))/((epr_fields(i)-epr_fields(i-1))**2.0_8)
					if(epr_type(fr) == -1) then
						epr_calc(fr,t,i) = 0.5_8*(epr_fields(i)-epr_fields(i-1))*(abs_spec(i,fr,t)+abs_spec(i-1,fr,t)) + epr_calc(fr,t,i-1)
					else if(epr_type(fr) == 0) then
						epr_calc(fr,t,i) = abs_spec(i,fr,t)
					else if(epr_type(fr) == 1) then
						epr_calc(fr,t,i) = first(i,fr,t)
					else if(epr_type(fr) == 2) then
						epr_calc(fr,t,i) = second(i,fr,t)
					end if
				else
					first(i,fr,t) = 0.5_8*(abs_spec(i+1,fr,t)-abs_spec(i-1,fr,t))/(epr_fields(i+1)-epr_fields(i-1))
					second(i,fr,t) = (abs_spec(i+1,fr,t)-2.0_8*abs_spec(i,fr,t)+abs_spec(i-1,fr,t))/((epr_fields(i+1)-epr_fields(i))**2.0_8)
					if(epr_type(fr) == -1) then
						epr_calc(fr,t,i) = 0.5_8*(epr_fields(i)-epr_fields(i-1))*(abs_spec(i,fr,t)+abs_spec(i-1,fr,t)) + epr_calc(fr,t,i-1)
					else if(epr_type(fr) == 0) then
						epr_calc(fr,t,i) = abs_spec(i,fr,t)
					else if(epr_type(fr) == 1) then
						epr_calc(fr,t,i) = first(i,fr,t)
					else if(epr_type(fr) == 2) then
						epr_calc(fr,t,i) = second(i,fr,t)
					end if
				end if
			end do
		end do
		if(epr_type(fr) == 1 .or. epr_type(fr) == 2) then
			epr_calc(fr,:,1) = epr_calc(fr,:,2)
			epr_calc(fr,:,epr_numB) = epr_calc(fr,:,epr_numB-1)
		end if
		if(epr_normalise) then
			roof = dabs(maxval(epr_calc(fr,1,:)))
			base = dabs(minval(epr_calc(fr,1,:)))
			if(base > roof) roof = base
			if(roof /= 0.0_8) epr_calc(fr,:,:) = epr_calc(fr,:,:)/roof
		end if
		roof = dabs(maxval(abs_spec(:,fr,1)))
		if(roof /= 0.0_8) abs_spec(:,fr,:) = abs_spec(:,fr,:)/roof
	end do
#ifdef gui
	do i = 1,epr_numB
		call send_plot_data("epr_cal",epr_numB,epr_fields(i))
	end do
	if(return_all) return
	do fr = 1,epr_numF
		do t = 1,epr_numT
			do i = 1,epr_numB
				call send_plot_data("epr_cal",epr_numB,epr_calc(fr,t,i))
			end do
		end do
	end do
	if(return_all) return
	if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') then
		do g = 1,numdir
			do k = 1,subdim
				do i = 1,epr_numB
					call send_plot_data("epr_zee",epr_numB,zeeman_data(g,i,k)/EnergyConvert)
				end do
			end do
		end do
		if(return_all) return
		do fr = 1,epr_numF
			do g = 1,numdir
				call send_plot_data("epr_tra",epr_numB,epr_fields(trans_data(fr,g,1)))
				call send_plot_data("epr_tra",epr_numB,zeeman_data(g,trans_data(fr,g,1),trans_data(fr,g,2))/EnergyConvert)
				call send_plot_data("epr_tra",epr_numB,zeeman_data(g,trans_data(fr,g,1),trans_data(fr,g,3))/EnergyConvert)
				call send_plot_data("epr_tra",epr_numB,trans_intens(fr,g))
			end do
		end do
	end if
	if(return_all) return
	call send_plot_signal("eprC",ptr_to_C_code)
	if(epr_do_zeeman .and. OperationMode(1:3) == 'sim') deallocate(zeeman_data,trans_data,trans_intens)
#endif
	if(allocated(epr_vecsI)) deallocate(epr_vecsI)
	if(allocated(epr_vals)) deallocate(epr_vals)
	if(allocated(ZeeX)) deallocate(ZeeX)
	if(allocated(ZeeY)) deallocate(ZeeY)
	if(allocated(ZeeZ)) deallocate(ZeeZ)
	if(allocated(full_mat)) deallocate(full_mat)
	if(allocated(small_vecs)) deallocate(small_vecs)
	if(allocated(ZeeTheta)) deallocate(ZeeTheta)
	if(allocated(ZeePhi)) deallocate(ZeePhi)
	deallocate(dummyR,dummyvecR,abs_spec,first,second)
	end subroutine pert_epr
	
end module props
