#include "settingswindow.h"
#include "ui_settingswindow.h"
#include "mainwindow.h"
#include <iostream>

SettingsWindow::SettingsWindow(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);
    this->setWindowTitle(QString::fromUtf8("Preferences"));
    connect( this, SIGNAL(accepted()), this, SLOT(accept_settings()) );
    QSettings settings;
#ifdef Q_OS_WIN
    default_font_size = 14;
#endif
#ifdef Q_OS_OSX
    default_font_size = 16;
#endif
#ifdef Q_OS_LINUX
    default_font_size = 10;
#endif
    ui->fontBox->setValue(settings.value("fontsize",default_font_size).toInt());
    ui->pointsBox->setValue(settings.value("point_size",8).toInt());
    ui->lineBox->setValue(settings.value("line_size",2).toInt());

    if(settings.value("MagXLog",0).toInt()==0){ui->MagXLog->setChecked(false);ui->MagXLin->setChecked(true);}else{ui->MagXLog->setChecked(true);ui->MagXLin->setChecked(false);}
    if(settings.value("MagYLog",0).toInt()==0){ui->MagYLog->setChecked(false);ui->MagYLin->setChecked(true);}else{ui->MagYLog->setChecked(true);ui->MagYLin->setChecked(false);}
    if(settings.value("RedmagXLog",0).toInt()==0){ui->RedmagXLog->setChecked(false);ui->RedmagXLin->setChecked(true);}else{ui->RedmagXLog->setChecked(true);ui->RedmagXLin->setChecked(false);}
    if(settings.value("RedmagYLog",0).toInt()==0){ui->RedmagYLog->setChecked(false);ui->RedmagYLin->setChecked(true);}else{ui->RedmagYLog->setChecked(true);ui->RedmagYLin->setChecked(false);}
    if(settings.value("MCEXLog",0).toInt()==0){ui->MCEXLog->setChecked(false);ui->MCEXLin->setChecked(true);}else{ui->MCEXLog->setChecked(true);ui->MCEXLin->setChecked(false);}
    if(settings.value("MCEYLog",0).toInt()==0){ui->MCEYLog->setChecked(false);ui->MCEYLin->setChecked(true);}else{ui->MCEYLog->setChecked(true);ui->MCEYLin->setChecked(false);}
    if(settings.value("HeatXLog",1).toInt()==0){ui->HeatXLog->setChecked(false);ui->HeatXLin->setChecked(true);}else{ui->HeatXLog->setChecked(true);ui->HeatXLin->setChecked(false);}
    if(settings.value("HeatYLog",1).toInt()==0){ui->HeatYLog->setChecked(false);ui->HeatYLin->setChecked(true);}else{ui->HeatYLog->setChecked(true);ui->HeatYLin->setChecked(false);}
    if(settings.value("SusXLog",0).toInt()==0){ui->SusXLog->setChecked(false);ui->SusXLin->setChecked(true);}else{ui->SusXLog->setChecked(true);ui->SusXLin->setChecked(false);}
    if(settings.value("SusYLog",0).toInt()==0){ui->SusYLog->setChecked(false);ui->SusYLin->setChecked(true);}else{ui->SusYLog->setChecked(true);ui->SusYLin->setChecked(false);}
    if(settings.value("ChiXLog",0).toInt()==0){ui->ChiXLog->setChecked(false);ui->ChiXLin->setChecked(true);}else{ui->ChiXLog->setChecked(true);ui->ChiXLin->setChecked(false);}
    if(settings.value("ChiYLog",0).toInt()==0){ui->ChiYLog->setChecked(false);ui->ChiYLin->setChecked(true);}else{ui->ChiYLog->setChecked(true);ui->ChiYLin->setChecked(false);}
    if(settings.value("OneOnChiXLog",0).toInt()==0){ui->OneOnChiXLog->setChecked(false);ui->OneOnChiXLin->setChecked(true);}else{ui->OneOnChiXLog->setChecked(true);ui->OneOnChiXLin->setChecked(false);}
    if(settings.value("OneOnChiYLog",0).toInt()==0){ui->OneOnChiYLog->setChecked(false);ui->OneOnChiYLin->setChecked(true);}else{ui->OneOnChiYLog->setChecked(true);ui->OneOnChiYLin->setChecked(false);}
    if(settings.value("EPRZeeman",1).toInt()==1){ui->epr_zeeman_check->setChecked(true);}else{ui->epr_zeeman_check->setChecked(false);}

    ui->tabby->setCurrentIndex(settings.value("index",0).toInt());
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::accept_settings()
{
    QSettings settings;
    if(ui->MagXLog->isChecked()){settings.setValue("MagXLog",1);}else{settings.setValue("MagXLog",0);}
    if(ui->MagYLog->isChecked()){settings.setValue("MagYLog",1);}else{settings.setValue("MagYLog",0);}
    if(ui->RedmagXLog->isChecked()){settings.setValue("RedmagXLog",1);}else{settings.setValue("RedmagXLog",0);}
    if(ui->RedmagYLog->isChecked()){settings.setValue("RedmagYLog",1);}else{settings.setValue("RedmagYLog",0);}
    if(ui->MCEXLog->isChecked()){settings.setValue("MCEXLog",1);}else{settings.setValue("MCEXLog",0);}
    if(ui->MCEYLog->isChecked()){settings.setValue("MCEYLog",1);}else{settings.setValue("MCEYLog",0);}
    if(ui->HeatXLog->isChecked()){settings.setValue("HeatXLog",1);}else{settings.setValue("HeatXLog",0);}
    if(ui->HeatYLog->isChecked()){settings.setValue("HeatYLog",1);}else{settings.setValue("HeatYLog",0);}
    if(ui->SusXLog->isChecked()){settings.setValue("SusXLog",1);}else{settings.setValue("SusXLog",0);}
    if(ui->SusYLog->isChecked()){settings.setValue("SusYLog",1);}else{settings.setValue("SusYLog",0);}
    if(ui->ChiXLog->isChecked()){settings.setValue("ChiXLog",1);}else{settings.setValue("ChiXLog",0);}
    if(ui->ChiYLog->isChecked()){settings.setValue("ChiYLog",1);}else{settings.setValue("ChiYLog",0);}
    if(ui->OneOnChiXLog->isChecked()){settings.setValue("OneOnChiXLog",1);}else{settings.setValue("OneOnChiXLog",0);}
    if(ui->OneOnChiYLog->isChecked()){settings.setValue("OneOnChiYLog",1);}else{settings.setValue("OneOnChiYLog",0);}
    if(ui->epr_zeeman_check->isChecked()){settings.setValue("EPRZeeman",1);}else{settings.setValue("EPRZeeman",0);}
    settings.setValue("fontsize",ui->fontBox->value());
    settings.setValue("index",ui->tabby->currentIndex());
    settings.setValue("point_size",ui->pointsBox->value());
    settings.setValue("line_size",ui->lineBox->value());
    settings.sync();
    emit saved();
}

void SettingsWindow::on_MagXLin_clicked()
{
    ui->MagXLog->setChecked(false);
}

void SettingsWindow::on_MagXLog_clicked()
{
    ui->MagXLin->setChecked(false);
}

void SettingsWindow::on_MagYLin_clicked()
{
    ui->MagYLog->setChecked(false);
}

void SettingsWindow::on_MagYLog_clicked()
{
    ui->MagYLin->setChecked(false);
}

void SettingsWindow::on_RedmagXLin_clicked()
{
    ui->RedmagXLog->setChecked(false);
}

void SettingsWindow::on_RedmagXLog_clicked()
{
    ui->RedmagXLin->setChecked(false);
}

void SettingsWindow::on_RedmagYLin_clicked()
{
    ui->RedmagYLog->setChecked(false);
}

void SettingsWindow::on_RedmagYLog_clicked()
{
    ui->RedmagYLin->setChecked(false);
}

void SettingsWindow::on_MCEXLin_clicked()
{
    ui->MCEXLog->setChecked(false);
}

void SettingsWindow::on_MCEXLog_clicked()
{
    ui->MCEXLin->setChecked(false);
}

void SettingsWindow::on_MCEYLin_clicked()
{
    ui->MCEYLog->setChecked(false);
}

void SettingsWindow::on_MCEYLog_clicked()
{
    ui->MCEYLin->setChecked(false);
}

void SettingsWindow::on_HeatXLin_clicked()
{
    ui->HeatXLog->setChecked(false);
}

void SettingsWindow::on_HeatXLog_clicked()
{
    ui->HeatXLin->setChecked(false);
}

void SettingsWindow::on_HeatYLin_clicked()
{
    ui->HeatYLog->setChecked(false);
}

void SettingsWindow::on_HeatYLog_clicked()
{
    ui->HeatYLin->setChecked(false);
}

void SettingsWindow::on_SusXLin_clicked()
{
    ui->SusXLog->setChecked(false);
}

void SettingsWindow::on_SusXLog_clicked()
{
    ui->SusXLin->setChecked(false);
}

void SettingsWindow::on_SusYLin_clicked()
{
    ui->SusYLog->setChecked(false);
}

void SettingsWindow::on_SusYLog_clicked()
{
    ui->SusYLin->setChecked(false);
}

void SettingsWindow::on_ChiXLin_clicked()
{
    ui->ChiXLog->setChecked(false);
}

void SettingsWindow::on_ChiXLog_clicked()
{
    ui->ChiXLin->setChecked(false);
}

void SettingsWindow::on_ChiYLin_clicked()
{
    ui->ChiYLog->setChecked(false);
}

void SettingsWindow::on_ChiYLog_clicked()
{
    ui->ChiYLin->setChecked(false);
}

void SettingsWindow::on_OneOnChiXLin_clicked()
{
    ui->OneOnChiXLog->setChecked(false);
}

void SettingsWindow::on_OneOnChiXLog_clicked()
{
    ui->OneOnChiXLin->setChecked(false);
}

void SettingsWindow::on_OneOnChiYLin_clicked()
{
    ui->OneOnChiYLog->setChecked(false);
}

void SettingsWindow::on_OneOnChiYLog_clicked()
{
    ui->OneOnChiYLin->setChecked(false);
}
